/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.highprec.octonion;

import ch.obermuhlner.math.big.BigDecimalMath;
import java.math.BigDecimal;
import java.math.MathContext;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.OctonionNumberWithin;
import nom.bdezonia.zorbage.algorithm.PowerAny;
import nom.bdezonia.zorbage.algorithm.Sinc;
import nom.bdezonia.zorbage.algorithm.Sinch;
import nom.bdezonia.zorbage.algorithm.Sinchpi;
import nom.bdezonia.zorbage.algorithm.Sincpi;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.type.algebra.Conjugate;
import nom.bdezonia.zorbage.type.algebra.Exponential;
import nom.bdezonia.zorbage.type.algebra.Hyperbolic;
import nom.bdezonia.zorbage.type.algebra.ImaginaryConstants;
import nom.bdezonia.zorbage.type.algebra.Norm;
import nom.bdezonia.zorbage.type.algebra.OctonionConstants;
import nom.bdezonia.zorbage.type.algebra.Power;
import nom.bdezonia.zorbage.type.algebra.QuaternionConstants;
import nom.bdezonia.zorbage.type.algebra.RealConstants;
import nom.bdezonia.zorbage.type.algebra.RealUnreal;
import nom.bdezonia.zorbage.type.algebra.Roots;
import nom.bdezonia.zorbage.type.algebra.Scale;
import nom.bdezonia.zorbage.type.algebra.ScaleByDouble;
import nom.bdezonia.zorbage.type.algebra.ScaleByHighPrec;
import nom.bdezonia.zorbage.type.algebra.ScaleByRational;
import nom.bdezonia.zorbage.type.algebra.ScaleComponents;
import nom.bdezonia.zorbage.type.algebra.SkewField;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.algebra.Trigonometric;
import nom.bdezonia.zorbage.type.data.highprec.complex.ComplexHighPrecisionMember;
import nom.bdezonia.zorbage.type.data.highprec.octonion.OctonionHighPrecisionMember;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionAlgebra;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class OctonionHighPrecisionAlgebra
implements SkewField<OctonionHighPrecisionAlgebra, OctonionHighPrecisionMember>,
Conjugate<OctonionHighPrecisionMember>,
Norm<OctonionHighPrecisionMember, HighPrecisionMember>,
RealConstants<OctonionHighPrecisionMember>,
ImaginaryConstants<OctonionHighPrecisionMember>,
QuaternionConstants<OctonionHighPrecisionMember>,
OctonionConstants<OctonionHighPrecisionMember>,
Exponential<OctonionHighPrecisionMember>,
Trigonometric<OctonionHighPrecisionMember>,
Hyperbolic<OctonionHighPrecisionMember>,
Power<OctonionHighPrecisionMember>,
Roots<OctonionHighPrecisionMember>,
RealUnreal<OctonionHighPrecisionMember, HighPrecisionMember>,
Scale<OctonionHighPrecisionMember, OctonionHighPrecisionMember>,
ScaleByHighPrec<OctonionHighPrecisionMember>,
ScaleByRational<OctonionHighPrecisionMember>,
ScaleByDouble<OctonionHighPrecisionMember>,
ScaleComponents<OctonionHighPrecisionMember, HighPrecisionMember>,
Tolerance<HighPrecisionMember, OctonionHighPrecisionMember> {
    private static final OctonionHighPrecisionMember ZERO = new OctonionHighPrecisionMember();
    private static final OctonionHighPrecisionMember ONE = new OctonionHighPrecisionMember(BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
    private static final OctonionHighPrecisionMember TWO = new OctonionHighPrecisionMember(BigDecimal.valueOf(2L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
    private static final OctonionHighPrecisionMember I = new OctonionHighPrecisionMember(BigDecimal.ZERO, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
    private static final OctonionHighPrecisionMember J = new OctonionHighPrecisionMember(BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
    private static final OctonionHighPrecisionMember K = new OctonionHighPrecisionMember(BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
    private static final OctonionHighPrecisionMember L = new OctonionHighPrecisionMember(BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
    private static final OctonionHighPrecisionMember I0 = new OctonionHighPrecisionMember(BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO);
    private static final OctonionHighPrecisionMember J0 = new OctonionHighPrecisionMember(BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ONE, BigDecimal.ZERO);
    private static final OctonionHighPrecisionMember K0 = new OctonionHighPrecisionMember(BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ONE);
    private final Procedure1<OctonionHighPrecisionMember> UNITY = new Procedure1<OctonionHighPrecisionMember>(){

        @Override
        public void call(OctonionHighPrecisionMember a) {
            OctonionHighPrecisionAlgebra.this.assign().call(ONE, a);
        }
    };
    private final Procedure3<OctonionHighPrecisionMember, OctonionHighPrecisionMember, OctonionHighPrecisionMember> MUL = new Procedure3<OctonionHighPrecisionMember, OctonionHighPrecisionMember, OctonionHighPrecisionMember>(){

        @Override
        public void call(OctonionHighPrecisionMember a, OctonionHighPrecisionMember b, OctonionHighPrecisionMember c) {
            OctonionHighPrecisionMember tmp = new OctonionHighPrecisionMember(ZERO);
            tmp.setR(a.r().multiply(b.r()));
            tmp.setI(a.r().multiply(b.i()));
            tmp.setJ(a.r().multiply(b.j()));
            tmp.setK(a.r().multiply(b.k()));
            tmp.setL(a.r().multiply(b.l()));
            tmp.setI0(a.r().multiply(b.i0()));
            tmp.setJ0(a.r().multiply(b.j0()));
            tmp.setK0(a.r().multiply(b.k0()));
            tmp.setI(tmp.i().add(a.i().multiply(b.r())));
            tmp.setR(tmp.r().subtract(a.i().multiply(b.i())));
            tmp.setK(tmp.k().add(a.i().multiply(b.j())));
            tmp.setJ(tmp.j().subtract(a.i().multiply(b.k())));
            tmp.setI0(tmp.i0().add(a.i().multiply(b.l())));
            tmp.setL(tmp.l().subtract(a.i().multiply(b.i0())));
            tmp.setK0(tmp.k0().subtract(a.i().multiply(b.j0())));
            tmp.setJ0(tmp.j0().add(a.i().multiply(b.k0())));
            tmp.setJ(tmp.j().add(a.j().multiply(b.r())));
            tmp.setK(tmp.k().subtract(a.j().multiply(b.i())));
            tmp.setR(tmp.r().subtract(a.j().multiply(b.j())));
            tmp.setI(tmp.i().add(a.j().multiply(b.k())));
            tmp.setJ0(tmp.j0().add(a.j().multiply(b.l())));
            tmp.setK0(tmp.k0().add(a.j().multiply(b.i0())));
            tmp.setL(tmp.l().subtract(a.j().multiply(b.j0())));
            tmp.setI0(tmp.i0().subtract(a.j().multiply(b.k0())));
            tmp.setK(tmp.k().add(a.k().multiply(b.r())));
            tmp.setJ(tmp.j().add(a.k().multiply(b.i())));
            tmp.setI(tmp.i().subtract(a.k().multiply(b.j())));
            tmp.setR(tmp.r().subtract(a.k().multiply(b.k())));
            tmp.setK0(tmp.k0().add(a.k().multiply(b.l())));
            tmp.setJ0(tmp.j0().subtract(a.k().multiply(b.i0())));
            tmp.setI0(tmp.i0().add(a.k().multiply(b.j0())));
            tmp.setL(tmp.l().subtract(a.k().multiply(b.k0())));
            tmp.setL(tmp.l().add(a.l().multiply(b.r())));
            tmp.setI0(tmp.i0().subtract(a.l().multiply(b.i())));
            tmp.setJ0(tmp.j0().subtract(a.l().multiply(b.j())));
            tmp.setK0(tmp.k0().subtract(a.l().multiply(b.k())));
            tmp.setR(tmp.r().subtract(a.l().multiply(b.l())));
            tmp.setI(tmp.i().add(a.l().multiply(b.i0())));
            tmp.setJ(tmp.j().add(a.l().multiply(b.j0())));
            tmp.setK(tmp.k().add(a.l().multiply(b.k0())));
            tmp.setI0(tmp.i0().add(a.i0().multiply(b.r())));
            tmp.setL(tmp.l().add(a.i0().multiply(b.i())));
            tmp.setK0(tmp.k0().subtract(a.i0().multiply(b.j())));
            tmp.setJ0(tmp.j0().add(a.i0().multiply(b.k())));
            tmp.setI(tmp.i().subtract(a.i0().multiply(b.l())));
            tmp.setR(tmp.r().subtract(a.i0().multiply(b.i0())));
            tmp.setK(tmp.k().subtract(a.i0().multiply(b.j0())));
            tmp.setJ(tmp.j().add(a.i0().multiply(b.k0())));
            tmp.setJ0(tmp.j0().add(a.j0().multiply(b.r())));
            tmp.setK0(tmp.k0().add(a.j0().multiply(b.i())));
            tmp.setL(tmp.l().add(a.j0().multiply(b.j())));
            tmp.setI0(tmp.i0().subtract(a.j0().multiply(b.k())));
            tmp.setJ(tmp.j().subtract(a.j0().multiply(b.l())));
            tmp.setK(tmp.k().add(a.j0().multiply(b.i0())));
            tmp.setR(tmp.r().subtract(a.j0().multiply(b.j0())));
            tmp.setI(tmp.i().subtract(a.j0().multiply(b.k0())));
            tmp.setK0(tmp.k0().add(a.k0().multiply(b.r())));
            tmp.setJ0(tmp.j0().subtract(a.k0().multiply(b.i())));
            tmp.setI0(tmp.i0().add(a.k0().multiply(b.j())));
            tmp.setL(tmp.l().add(a.k0().multiply(b.k())));
            tmp.setK(tmp.k().subtract(a.k0().multiply(b.l())));
            tmp.setJ(tmp.j().subtract(a.k0().multiply(b.i0())));
            tmp.setI(tmp.i().add(a.k0().multiply(b.j0())));
            tmp.setR(tmp.r().subtract(a.k0().multiply(b.k0())));
            OctonionHighPrecisionAlgebra.this.assign().call(tmp, c);
        }
    };
    private final Procedure3<Integer, OctonionHighPrecisionMember, OctonionHighPrecisionMember> POWER = new Procedure3<Integer, OctonionHighPrecisionMember, OctonionHighPrecisionMember>(){

        @Override
        public void call(Integer power, OctonionHighPrecisionMember a, OctonionHighPrecisionMember b) {
            PowerAny.compute(G.OHP, power, a, b);
        }
    };
    private final Procedure1<OctonionHighPrecisionMember> ZER = new Procedure1<OctonionHighPrecisionMember>(){

        @Override
        public void call(OctonionHighPrecisionMember a) {
            a.primitiveInit();
        }
    };
    private final Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember> NEG = new Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember>(){

        @Override
        public void call(OctonionHighPrecisionMember a, OctonionHighPrecisionMember b) {
            OctonionHighPrecisionAlgebra.this.subtract().call(ZERO, a, b);
        }
    };
    private final Procedure3<OctonionHighPrecisionMember, OctonionHighPrecisionMember, OctonionHighPrecisionMember> ADD = new Procedure3<OctonionHighPrecisionMember, OctonionHighPrecisionMember, OctonionHighPrecisionMember>(){

        @Override
        public void call(OctonionHighPrecisionMember a, OctonionHighPrecisionMember b, OctonionHighPrecisionMember c) {
            c.setR(a.r().add(b.r()));
            c.setI(a.i().add(b.i()));
            c.setJ(a.j().add(b.j()));
            c.setK(a.k().add(b.k()));
            c.setL(a.l().add(b.l()));
            c.setI0(a.i0().add(b.i0()));
            c.setJ0(a.j0().add(b.j0()));
            c.setK0(a.k0().add(b.k0()));
        }
    };
    private final Procedure3<OctonionHighPrecisionMember, OctonionHighPrecisionMember, OctonionHighPrecisionMember> SUB = new Procedure3<OctonionHighPrecisionMember, OctonionHighPrecisionMember, OctonionHighPrecisionMember>(){

        @Override
        public void call(OctonionHighPrecisionMember a, OctonionHighPrecisionMember b, OctonionHighPrecisionMember c) {
            c.setR(a.r().subtract(b.r()));
            c.setI(a.i().subtract(b.i()));
            c.setJ(a.j().subtract(b.j()));
            c.setK(a.k().subtract(b.k()));
            c.setL(a.l().subtract(b.l()));
            c.setI0(a.i0().subtract(b.i0()));
            c.setJ0(a.j0().subtract(b.j0()));
            c.setK0(a.k0().subtract(b.k0()));
        }
    };
    private Function2<Boolean, OctonionHighPrecisionMember, OctonionHighPrecisionMember> EQ = new Function2<Boolean, OctonionHighPrecisionMember, OctonionHighPrecisionMember>(){

        @Override
        public Boolean call(OctonionHighPrecisionMember a, OctonionHighPrecisionMember b) {
            return a.r() == b.r() && a.i() == b.i() && a.j() == b.j() && a.k() == b.k() && a.l() == b.l() && a.i0() == b.i0() && a.j0() == b.j0() && a.k0() == b.k0();
        }
    };
    private Function2<Boolean, OctonionHighPrecisionMember, OctonionHighPrecisionMember> NEQ = new Function2<Boolean, OctonionHighPrecisionMember, OctonionHighPrecisionMember>(){

        @Override
        public Boolean call(OctonionHighPrecisionMember a, OctonionHighPrecisionMember b) {
            return OctonionHighPrecisionAlgebra.this.isEqual().call(a, b) == false;
        }
    };
    private Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember> ASSIGN = new Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember>(){

        @Override
        public void call(OctonionHighPrecisionMember from, OctonionHighPrecisionMember to) {
            to.set(from);
        }
    };
    private Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember> INV = new Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember>(){

        @Override
        public void call(OctonionHighPrecisionMember a, OctonionHighPrecisionMember b) {
            BigDecimal norm2 = OctonionHighPrecisionAlgebra.this.norm2(a);
            OctonionHighPrecisionAlgebra.this.conjugate().call(a, b);
            b.setR(b.r().divide(norm2, HighPrecisionAlgebra.getContext()));
            b.setI(b.i().divide(norm2, HighPrecisionAlgebra.getContext()));
            b.setJ(b.j().divide(norm2, HighPrecisionAlgebra.getContext()));
            b.setK(b.k().divide(norm2, HighPrecisionAlgebra.getContext()));
            b.setL(b.l().divide(norm2, HighPrecisionAlgebra.getContext()));
            b.setI0(b.i0().divide(norm2, HighPrecisionAlgebra.getContext()));
            b.setJ0(b.j0().divide(norm2, HighPrecisionAlgebra.getContext()));
            b.setK0(b.k0().divide(norm2, HighPrecisionAlgebra.getContext()));
        }
    };
    private final Procedure3<OctonionHighPrecisionMember, OctonionHighPrecisionMember, OctonionHighPrecisionMember> DIVIDE = new Procedure3<OctonionHighPrecisionMember, OctonionHighPrecisionMember, OctonionHighPrecisionMember>(){

        @Override
        public void call(OctonionHighPrecisionMember a, OctonionHighPrecisionMember b, OctonionHighPrecisionMember c) {
            OctonionHighPrecisionMember tmp = new OctonionHighPrecisionMember();
            OctonionHighPrecisionAlgebra.this.invert().call(b, tmp);
            OctonionHighPrecisionAlgebra.this.multiply().call(a, tmp, c);
        }
    };
    private final Procedure2<OctonionHighPrecisionMember, HighPrecisionMember> NORM = new Procedure2<OctonionHighPrecisionMember, HighPrecisionMember>(){

        @Override
        public void call(OctonionHighPrecisionMember a, HighPrecisionMember b) {
            b.setV(OctonionHighPrecisionAlgebra.this.norm(a));
        }
    };
    private Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember> CONJ = new Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember>(){

        @Override
        public void call(OctonionHighPrecisionMember a, OctonionHighPrecisionMember b) {
            b.setR(a.r());
            b.setI(a.i().negate());
            b.setJ(a.j().negate());
            b.setK(a.k().negate());
            b.setL(a.l().negate());
            b.setI0(a.i0().negate());
            b.setJ0(a.j0().negate());
            b.setK0(a.k0().negate());
        }
    };
    private final Procedure1<OctonionHighPrecisionMember> PI_ = new Procedure1<OctonionHighPrecisionMember>(){

        @Override
        public void call(OctonionHighPrecisionMember a) {
            HighPrecisionMember pi = G.HP.construct();
            G.HP.PI().call(pi);
            a.setR(pi.v());
            a.setI(BigDecimal.ZERO);
            a.setJ(BigDecimal.ZERO);
            a.setK(BigDecimal.ZERO);
            a.setL(BigDecimal.ZERO);
            a.setI0(BigDecimal.ZERO);
            a.setJ0(BigDecimal.ZERO);
            a.setK0(BigDecimal.ZERO);
        }
    };
    private final Procedure1<OctonionHighPrecisionMember> E_ = new Procedure1<OctonionHighPrecisionMember>(){

        @Override
        public void call(OctonionHighPrecisionMember a) {
            HighPrecisionMember e = G.HP.construct();
            G.HP.E().call(e);
            a.setR(e.v());
            a.setI(BigDecimal.ZERO);
            a.setJ(BigDecimal.ZERO);
            a.setK(BigDecimal.ZERO);
            a.setL(BigDecimal.ZERO);
            a.setI0(BigDecimal.ZERO);
            a.setJ0(BigDecimal.ZERO);
            a.setK0(BigDecimal.ZERO);
        }
    };
    private final Procedure1<OctonionHighPrecisionMember> GAMMA_ = new Procedure1<OctonionHighPrecisionMember>(){

        @Override
        public void call(OctonionHighPrecisionMember a) {
            HighPrecisionMember gamma = G.HP.construct();
            G.HP.GAMMA().call(gamma);
            a.setR(gamma.v());
            a.setI(BigDecimal.ZERO);
            a.setJ(BigDecimal.ZERO);
            a.setK(BigDecimal.ZERO);
            a.setL(BigDecimal.ZERO);
            a.setI0(BigDecimal.ZERO);
            a.setJ0(BigDecimal.ZERO);
            a.setK0(BigDecimal.ZERO);
        }
    };
    private final Procedure1<OctonionHighPrecisionMember> PHI_ = new Procedure1<OctonionHighPrecisionMember>(){

        @Override
        public void call(OctonionHighPrecisionMember a) {
            HighPrecisionMember phi = G.HP.construct();
            G.HP.PHI().call(phi);
            a.setR(phi.v());
            a.setI(BigDecimal.ZERO);
            a.setJ(BigDecimal.ZERO);
            a.setK(BigDecimal.ZERO);
            a.setL(BigDecimal.ZERO);
            a.setI0(BigDecimal.ZERO);
            a.setJ0(BigDecimal.ZERO);
            a.setK0(BigDecimal.ZERO);
        }
    };
    private final Procedure1<OctonionHighPrecisionMember> I_ = new Procedure1<OctonionHighPrecisionMember>(){

        @Override
        public void call(OctonionHighPrecisionMember a) {
            OctonionHighPrecisionAlgebra.this.assign().call(I, a);
        }
    };
    private final Procedure1<OctonionHighPrecisionMember> J_ = new Procedure1<OctonionHighPrecisionMember>(){

        @Override
        public void call(OctonionHighPrecisionMember a) {
            OctonionHighPrecisionAlgebra.this.assign().call(J, a);
        }
    };
    private final Procedure1<OctonionHighPrecisionMember> K_ = new Procedure1<OctonionHighPrecisionMember>(){

        @Override
        public void call(OctonionHighPrecisionMember a) {
            OctonionHighPrecisionAlgebra.this.assign().call(K, a);
        }
    };
    private final Procedure1<OctonionHighPrecisionMember> L_ = new Procedure1<OctonionHighPrecisionMember>(){

        @Override
        public void call(OctonionHighPrecisionMember a) {
            OctonionHighPrecisionAlgebra.this.assign().call(L, a);
        }
    };
    private final Procedure1<OctonionHighPrecisionMember> I0_ = new Procedure1<OctonionHighPrecisionMember>(){

        @Override
        public void call(OctonionHighPrecisionMember a) {
            OctonionHighPrecisionAlgebra.this.assign().call(I0, a);
        }
    };
    private final Procedure1<OctonionHighPrecisionMember> J0_ = new Procedure1<OctonionHighPrecisionMember>(){

        @Override
        public void call(OctonionHighPrecisionMember a) {
            OctonionHighPrecisionAlgebra.this.assign().call(J0, a);
        }
    };
    private final Procedure1<OctonionHighPrecisionMember> K0_ = new Procedure1<OctonionHighPrecisionMember>(){

        @Override
        public void call(OctonionHighPrecisionMember a) {
            OctonionHighPrecisionAlgebra.this.assign().call(K0, a);
        }
    };
    private final Procedure2<OctonionHighPrecisionMember, HighPrecisionMember> REAL = new Procedure2<OctonionHighPrecisionMember, HighPrecisionMember>(){

        @Override
        public void call(OctonionHighPrecisionMember a, HighPrecisionMember b) {
            b.setV(a.r());
        }
    };
    private Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember> UNREAL = new Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember>(){

        @Override
        public void call(OctonionHighPrecisionMember a, OctonionHighPrecisionMember b) {
            OctonionHighPrecisionAlgebra.this.assign().call(a, b);
            b.setR(BigDecimal.ZERO);
        }
    };
    private final Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember> SINH = new Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember>(){

        @Override
        public void call(OctonionHighPrecisionMember a, OctonionHighPrecisionMember b) {
            OctonionHighPrecisionMember negA = new OctonionHighPrecisionMember();
            OctonionHighPrecisionMember sum = new OctonionHighPrecisionMember();
            OctonionHighPrecisionMember tmp1 = new OctonionHighPrecisionMember();
            OctonionHighPrecisionMember tmp2 = new OctonionHighPrecisionMember();
            OctonionHighPrecisionAlgebra.this.negate().call(a, negA);
            OctonionHighPrecisionAlgebra.this.exp().call(a, tmp1);
            OctonionHighPrecisionAlgebra.this.exp().call(negA, tmp2);
            OctonionHighPrecisionAlgebra.this.subtract().call(tmp1, tmp2, sum);
            OctonionHighPrecisionAlgebra.this.divide().call(sum, TWO, b);
        }
    };
    private Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember> COSH = new Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember>(){

        @Override
        public void call(OctonionHighPrecisionMember a, OctonionHighPrecisionMember b) {
            OctonionHighPrecisionMember negA = new OctonionHighPrecisionMember();
            OctonionHighPrecisionMember sum = new OctonionHighPrecisionMember();
            OctonionHighPrecisionMember tmp1 = new OctonionHighPrecisionMember();
            OctonionHighPrecisionMember tmp2 = new OctonionHighPrecisionMember();
            OctonionHighPrecisionAlgebra.this.negate().call(a, negA);
            OctonionHighPrecisionAlgebra.this.exp().call(a, tmp1);
            OctonionHighPrecisionAlgebra.this.exp().call(negA, tmp2);
            OctonionHighPrecisionAlgebra.this.add().call(tmp1, tmp2, sum);
            OctonionHighPrecisionAlgebra.this.divide().call(sum, TWO, b);
        }
    };
    private final Procedure3<OctonionHighPrecisionMember, OctonionHighPrecisionMember, OctonionHighPrecisionMember> SINHANDCOSH = new Procedure3<OctonionHighPrecisionMember, OctonionHighPrecisionMember, OctonionHighPrecisionMember>(){

        @Override
        public void call(OctonionHighPrecisionMember a, OctonionHighPrecisionMember s, OctonionHighPrecisionMember c) {
            OctonionHighPrecisionMember negA = new OctonionHighPrecisionMember();
            OctonionHighPrecisionMember sum = new OctonionHighPrecisionMember();
            OctonionHighPrecisionMember tmp1 = new OctonionHighPrecisionMember();
            OctonionHighPrecisionMember tmp2 = new OctonionHighPrecisionMember();
            OctonionHighPrecisionAlgebra.this.negate().call(a, negA);
            OctonionHighPrecisionAlgebra.this.exp().call(a, tmp1);
            OctonionHighPrecisionAlgebra.this.exp().call(negA, tmp2);
            OctonionHighPrecisionAlgebra.this.subtract().call(tmp1, tmp2, sum);
            OctonionHighPrecisionAlgebra.this.divide().call(sum, TWO, s);
            OctonionHighPrecisionAlgebra.this.add().call(tmp1, tmp2, sum);
            OctonionHighPrecisionAlgebra.this.divide().call(sum, TWO, c);
        }
    };
    private final Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember> TANH = new Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember>(){

        @Override
        public void call(OctonionHighPrecisionMember a, OctonionHighPrecisionMember b) {
            OctonionHighPrecisionMember s = new OctonionHighPrecisionMember();
            OctonionHighPrecisionMember c = new OctonionHighPrecisionMember();
            OctonionHighPrecisionAlgebra.this.sinhAndCosh().call(a, s, c);
            OctonionHighPrecisionAlgebra.this.divide().call(s, c, b);
        }
    };
    private final Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember> SIN = new Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember>(){

        @Override
        public void call(OctonionHighPrecisionMember a, OctonionHighPrecisionMember b) {
            HighPrecisionMember z = new HighPrecisionMember();
            HighPrecisionMember z2 = new HighPrecisionMember();
            OctonionHighPrecisionMember tmp = new OctonionHighPrecisionMember();
            OctonionHighPrecisionAlgebra.this.unreal().call(a, tmp);
            OctonionHighPrecisionAlgebra.this.norm().call(tmp, z);
            G.HP.sinch().call(z, z2);
            BigDecimal cos = BigDecimalMath.cos((BigDecimal)a.r(), (MathContext)HighPrecisionAlgebra.getContext());
            BigDecimal sin = BigDecimalMath.sin((BigDecimal)a.r(), (MathContext)HighPrecisionAlgebra.getContext());
            BigDecimal sinhc_pi = z2.v();
            BigDecimal cosh = BigDecimalMath.cosh((BigDecimal)z.v(), (MathContext)HighPrecisionAlgebra.getContext());
            BigDecimal ws = cos.multiply(sinhc_pi);
            b.setR(sin.multiply(cosh));
            b.setI(ws.multiply(a.i()));
            b.setJ(ws.multiply(a.j()));
            b.setK(ws.multiply(a.k()));
            b.setL(ws.multiply(a.l()));
            b.setI0(ws.multiply(a.i0()));
            b.setJ0(ws.multiply(a.j0()));
            b.setK0(ws.multiply(a.k0()));
        }
    };
    private final Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember> COS = new Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember>(){

        @Override
        public void call(OctonionHighPrecisionMember a, OctonionHighPrecisionMember b) {
            HighPrecisionMember z = new HighPrecisionMember();
            HighPrecisionMember z2 = new HighPrecisionMember();
            OctonionHighPrecisionMember tmp = new OctonionHighPrecisionMember();
            OctonionHighPrecisionAlgebra.this.unreal().call(a, tmp);
            OctonionHighPrecisionAlgebra.this.norm().call(tmp, z);
            G.HP.sinch().call(z, z2);
            BigDecimal cos = BigDecimalMath.cos((BigDecimal)a.r(), (MathContext)HighPrecisionAlgebra.getContext());
            BigDecimal sin = BigDecimalMath.sin((BigDecimal)a.r(), (MathContext)HighPrecisionAlgebra.getContext());
            BigDecimal sinhc_pi = z2.v();
            BigDecimal cosh = BigDecimalMath.cosh((BigDecimal)z.v(), (MathContext)HighPrecisionAlgebra.getContext());
            BigDecimal wc = sin.negate().multiply(sinhc_pi);
            b.setR(cos.multiply(cosh));
            b.setI(wc.multiply(a.i()));
            b.setJ(wc.multiply(a.j()));
            b.setK(wc.multiply(a.k()));
            b.setL(wc.multiply(a.l()));
            b.setI0(wc.multiply(a.i0()));
            b.setJ0(wc.multiply(a.j0()));
            b.setK0(wc.multiply(a.k0()));
        }
    };
    private final Procedure3<OctonionHighPrecisionMember, OctonionHighPrecisionMember, OctonionHighPrecisionMember> SINANDCOS = new Procedure3<OctonionHighPrecisionMember, OctonionHighPrecisionMember, OctonionHighPrecisionMember>(){

        @Override
        public void call(OctonionHighPrecisionMember a, OctonionHighPrecisionMember s, OctonionHighPrecisionMember c) {
            HighPrecisionMember z = new HighPrecisionMember();
            HighPrecisionMember z2 = new HighPrecisionMember();
            OctonionHighPrecisionMember tmp = new OctonionHighPrecisionMember();
            OctonionHighPrecisionAlgebra.this.unreal().call(a, tmp);
            OctonionHighPrecisionAlgebra.this.norm().call(tmp, z);
            G.HP.sinch().call(z, z2);
            BigDecimal cos = BigDecimalMath.cos((BigDecimal)a.r(), (MathContext)HighPrecisionAlgebra.getContext());
            BigDecimal sin = BigDecimalMath.sin((BigDecimal)a.r(), (MathContext)HighPrecisionAlgebra.getContext());
            BigDecimal sinhc_pi = z2.v();
            BigDecimal cosh = BigDecimalMath.cosh((BigDecimal)z.v(), (MathContext)HighPrecisionAlgebra.getContext());
            BigDecimal ws = cos.multiply(sinhc_pi);
            BigDecimal wc = sin.negate().multiply(sinhc_pi);
            s.setR(sin.multiply(cosh));
            s.setI(ws.multiply(a.i()));
            s.setJ(ws.multiply(a.j()));
            s.setK(ws.multiply(a.k()));
            s.setL(ws.multiply(a.l()));
            s.setI0(ws.multiply(a.i0()));
            s.setJ0(ws.multiply(a.j0()));
            s.setK0(ws.multiply(a.k0()));
            c.setR(cos.multiply(cosh));
            c.setI(wc.multiply(a.i()));
            c.setJ(wc.multiply(a.j()));
            c.setK(wc.multiply(a.k()));
            c.setL(wc.multiply(a.l()));
            c.setI0(wc.multiply(a.i0()));
            c.setJ0(wc.multiply(a.j0()));
            c.setK0(wc.multiply(a.k0()));
        }
    };
    private final Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember> TAN = new Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember>(){

        @Override
        public void call(OctonionHighPrecisionMember a, OctonionHighPrecisionMember b) {
            OctonionHighPrecisionMember sin = new OctonionHighPrecisionMember();
            OctonionHighPrecisionMember cos = new OctonionHighPrecisionMember();
            OctonionHighPrecisionAlgebra.this.sinAndCos().call(a, sin, cos);
            OctonionHighPrecisionAlgebra.this.divide().call(sin, cos, b);
        }
    };
    private final Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember> EXP = new Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember>(){

        @Override
        public void call(OctonionHighPrecisionMember a, OctonionHighPrecisionMember b) {
            HighPrecisionMember z = new HighPrecisionMember();
            HighPrecisionMember z2 = new HighPrecisionMember();
            OctonionHighPrecisionMember tmp = new OctonionHighPrecisionMember();
            BigDecimal u = BigDecimalMath.exp((BigDecimal)a.r(), (MathContext)HighPrecisionAlgebra.getContext());
            OctonionHighPrecisionAlgebra.this.unreal().call(a, tmp);
            OctonionHighPrecisionAlgebra.this.norm().call(tmp, z);
            G.HP.sinc().call(z, z2);
            BigDecimal w = z2.v();
            BigDecimal uw = u.multiply(w);
            b.setR(u.multiply(BigDecimalMath.cos((BigDecimal)z.v(), (MathContext)HighPrecisionAlgebra.getContext())));
            b.setI(uw.multiply(a.i()));
            b.setJ(uw.multiply(a.j()));
            b.setK(uw.multiply(a.k()));
            b.setL(uw.multiply(a.l()));
            b.setI0(uw.multiply(a.i0()));
            b.setJ0(uw.multiply(a.j0()));
            b.setK0(uw.multiply(a.k0()));
        }
    };
    private final Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember> LOG = new Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember>(){

        @Override
        public void call(OctonionHighPrecisionMember a, OctonionHighPrecisionMember b) {
            OctonionHighPrecisionMember unreal = new OctonionHighPrecisionMember();
            ComplexHighPrecisionMember tmp = new ComplexHighPrecisionMember();
            HighPrecisionMember norm = new HighPrecisionMember();
            OctonionHighPrecisionAlgebra.this.assign().call(a, b);
            OctonionHighPrecisionAlgebra.this.unreal().call(a, unreal);
            OctonionHighPrecisionAlgebra.this.norm().call(unreal, norm);
            tmp.setR(a.r());
            tmp.setI(norm.v());
            G.CHP.log().call(tmp, tmp);
            BigDecimal factor = norm.v().signum() == 0 ? tmp.i() : tmp.i().divide(norm.v(), HighPrecisionAlgebra.getContext());
            OctonionHighPrecisionAlgebra.this.multiplier(tmp.r(), factor, b);
        }
    };
    private final Procedure3<OctonionHighPrecisionMember, OctonionHighPrecisionMember, OctonionHighPrecisionMember> POW = new Procedure3<OctonionHighPrecisionMember, OctonionHighPrecisionMember, OctonionHighPrecisionMember>(){

        @Override
        public void call(OctonionHighPrecisionMember a, OctonionHighPrecisionMember b, OctonionHighPrecisionMember c) {
            OctonionHighPrecisionMember logA = new OctonionHighPrecisionMember();
            OctonionHighPrecisionMember bLogA = new OctonionHighPrecisionMember();
            OctonionHighPrecisionAlgebra.this.log().call(a, logA);
            OctonionHighPrecisionAlgebra.this.multiply().call(b, logA, bLogA);
            OctonionHighPrecisionAlgebra.this.exp().call(bLogA, c);
        }
    };
    private final Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember> SINCH = new Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember>(){

        @Override
        public void call(OctonionHighPrecisionMember a, OctonionHighPrecisionMember b) {
            Sinch.compute(G.OHP, a, b);
        }
    };
    private final Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember> SINCHPI = new Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember>(){

        @Override
        public void call(OctonionHighPrecisionMember a, OctonionHighPrecisionMember b) {
            Sinchpi.compute(G.OHP, a, b);
        }
    };
    private final Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember> SINC = new Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember>(){

        @Override
        public void call(OctonionHighPrecisionMember a, OctonionHighPrecisionMember b) {
            Sinc.compute(G.OHP, a, b);
        }
    };
    private final Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember> SINCPI = new Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember>(){

        @Override
        public void call(OctonionHighPrecisionMember a, OctonionHighPrecisionMember b) {
            Sincpi.compute(G.OHP, a, b);
        }
    };
    private final Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember> SQRT = new Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember>(){

        @Override
        public void call(OctonionHighPrecisionMember a, OctonionHighPrecisionMember b) {
            OctonionHighPrecisionMember ONE_HALF = G.OHP.construct();
            ONE_HALF.setR(BigDecimal.ONE.divide(BigDecimal.valueOf(2L), HighPrecisionAlgebra.getContext()));
            OctonionHighPrecisionAlgebra.this.pow().call(a, ONE_HALF, b);
        }
    };
    private final Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember> CBRT = new Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember>(){

        @Override
        public void call(OctonionHighPrecisionMember a, OctonionHighPrecisionMember b) {
            OctonionHighPrecisionMember ONE_THIRD = G.OHP.construct();
            ONE_THIRD.setR(BigDecimal.ONE.divide(BigDecimal.valueOf(3L), HighPrecisionAlgebra.getContext()));
            OctonionHighPrecisionAlgebra.this.pow().call(a, ONE_THIRD, b);
        }
    };
    private final Function1<Boolean, OctonionHighPrecisionMember> ISZERO = new Function1<Boolean, OctonionHighPrecisionMember>(){

        @Override
        public Boolean call(OctonionHighPrecisionMember a) {
            return a.r().signum() == 0 && a.i().signum() == 0 && a.j().signum() == 0 && a.k().signum() == 0 && a.l().signum() == 0 && a.i0().signum() == 0 && a.j0().signum() == 0 && a.k0().signum() == 0;
        }
    };
    private final Procedure3<HighPrecisionMember, OctonionHighPrecisionMember, OctonionHighPrecisionMember> SBHP = new Procedure3<HighPrecisionMember, OctonionHighPrecisionMember, OctonionHighPrecisionMember>(){

        @Override
        public void call(HighPrecisionMember a, OctonionHighPrecisionMember b, OctonionHighPrecisionMember c) {
            BigDecimal tmp = a.v().multiply(b.r());
            c.setR(tmp);
            tmp = a.v().multiply(b.i());
            c.setI(tmp);
            tmp = a.v().multiply(b.j());
            c.setJ(tmp);
            tmp = a.v().multiply(b.k());
            c.setK(tmp);
            tmp = a.v().multiply(b.l());
            c.setL(tmp);
            tmp = a.v().multiply(b.i0());
            c.setI0(tmp);
            tmp = a.v().multiply(b.j0());
            c.setJ0(tmp);
            tmp = a.v().multiply(b.k0());
            c.setK0(tmp);
        }
    };
    private final Procedure3<RationalMember, OctonionHighPrecisionMember, OctonionHighPrecisionMember> SBR = new Procedure3<RationalMember, OctonionHighPrecisionMember, OctonionHighPrecisionMember>(){

        @Override
        public void call(RationalMember a, OctonionHighPrecisionMember b, OctonionHighPrecisionMember c) {
            BigDecimal n = new BigDecimal(a.n());
            BigDecimal d = new BigDecimal(a.d());
            BigDecimal tmp = b.r();
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setR(tmp);
            tmp = b.i();
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setI(tmp);
            tmp = b.j();
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setJ(tmp);
            tmp = b.k();
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setK(tmp);
            tmp = b.l();
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setL(tmp);
            tmp = b.i0();
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setI0(tmp);
            tmp = b.j0();
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setJ0(tmp);
            tmp = b.k0();
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setK0(tmp);
        }
    };
    private final Procedure3<Double, OctonionHighPrecisionMember, OctonionHighPrecisionMember> SBD = new Procedure3<Double, OctonionHighPrecisionMember, OctonionHighPrecisionMember>(){

        @Override
        public void call(Double a, OctonionHighPrecisionMember b, OctonionHighPrecisionMember c) {
            BigDecimal d = BigDecimal.valueOf(a);
            BigDecimal tmp = b.r();
            tmp = tmp.multiply(d);
            c.setR(tmp);
            tmp = b.i();
            tmp = tmp.multiply(d);
            c.setI(tmp);
            tmp = b.j();
            tmp = tmp.multiply(d);
            c.setJ(tmp);
            tmp = b.k();
            tmp = tmp.multiply(d);
            c.setK(tmp);
            tmp = b.l();
            tmp = tmp.multiply(d);
            c.setL(tmp);
            tmp = b.i0();
            tmp = tmp.multiply(d);
            c.setI0(tmp);
            tmp = b.j0();
            tmp = tmp.multiply(d);
            c.setJ0(tmp);
            tmp = b.k0();
            tmp = tmp.multiply(d);
            c.setK0(tmp);
        }
    };
    private final Procedure3<HighPrecisionMember, OctonionHighPrecisionMember, OctonionHighPrecisionMember> SC = new Procedure3<HighPrecisionMember, OctonionHighPrecisionMember, OctonionHighPrecisionMember>(){

        @Override
        public void call(HighPrecisionMember a, OctonionHighPrecisionMember b, OctonionHighPrecisionMember c) {
            c.setR(a.v().multiply(b.r()));
            c.setI(a.v().multiply(b.i()));
            c.setJ(a.v().multiply(b.j()));
            c.setK(a.v().multiply(b.k()));
            c.setL(a.v().multiply(b.l()));
            c.setI0(a.v().multiply(b.i0()));
            c.setJ0(a.v().multiply(b.j0()));
            c.setK0(a.v().multiply(b.k0()));
        }
    };
    private final Function3<Boolean, HighPrecisionMember, OctonionHighPrecisionMember, OctonionHighPrecisionMember> WITHIN = new Function3<Boolean, HighPrecisionMember, OctonionHighPrecisionMember, OctonionHighPrecisionMember>(){

        @Override
        public Boolean call(HighPrecisionMember tol, OctonionHighPrecisionMember a, OctonionHighPrecisionMember b) {
            return OctonionNumberWithin.compute(G.HP, tol, a, b);
        }
    };

    @Override
    public Procedure1<OctonionHighPrecisionMember> unity() {
        return this.UNITY;
    }

    @Override
    public Procedure3<OctonionHighPrecisionMember, OctonionHighPrecisionMember, OctonionHighPrecisionMember> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<Integer, OctonionHighPrecisionMember, OctonionHighPrecisionMember> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<OctonionHighPrecisionMember> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<OctonionHighPrecisionMember, OctonionHighPrecisionMember, OctonionHighPrecisionMember> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<OctonionHighPrecisionMember, OctonionHighPrecisionMember, OctonionHighPrecisionMember> subtract() {
        return this.SUB;
    }

    @Override
    public Function2<Boolean, OctonionHighPrecisionMember, OctonionHighPrecisionMember> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, OctonionHighPrecisionMember, OctonionHighPrecisionMember> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public OctonionHighPrecisionMember construct() {
        return new OctonionHighPrecisionMember();
    }

    @Override
    public OctonionHighPrecisionMember construct(OctonionHighPrecisionMember other) {
        return new OctonionHighPrecisionMember(other);
    }

    @Override
    public OctonionHighPrecisionMember construct(String s) {
        return new OctonionHighPrecisionMember(s);
    }

    @Override
    public Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember> invert() {
        return this.INV;
    }

    @Override
    public Procedure3<OctonionHighPrecisionMember, OctonionHighPrecisionMember, OctonionHighPrecisionMember> divide() {
        return this.DIVIDE;
    }

    @Override
    public Procedure2<OctonionHighPrecisionMember, HighPrecisionMember> norm() {
        return this.NORM;
    }

    private BigDecimal norm(OctonionHighPrecisionMember a) {
        BigDecimal sum = a.r().multiply(a.r());
        sum = sum.add(a.i().multiply(a.i()));
        sum = sum.add(a.j().multiply(a.j()));
        sum = sum.add(a.k().multiply(a.k()));
        sum = sum.add(a.l().multiply(a.l()));
        sum = sum.add(a.i0().multiply(a.i0()));
        sum = sum.add(a.j0().multiply(a.j0()));
        sum = sum.add(a.k0().multiply(a.k0()));
        return BigDecimalMath.sqrt((BigDecimal)sum, (MathContext)HighPrecisionAlgebra.getContext());
    }

    private BigDecimal norm2(OctonionHighPrecisionMember a) {
        BigDecimal norm = this.norm(a);
        return norm.multiply(norm);
    }

    @Override
    public Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember> conjugate() {
        return this.CONJ;
    }

    @Override
    public Procedure1<OctonionHighPrecisionMember> PI() {
        return this.PI_;
    }

    @Override
    public Procedure1<OctonionHighPrecisionMember> E() {
        return this.E_;
    }

    @Override
    public Procedure1<OctonionHighPrecisionMember> GAMMA() {
        return this.GAMMA_;
    }

    @Override
    public Procedure1<OctonionHighPrecisionMember> PHI() {
        return this.PHI_;
    }

    @Override
    public Procedure1<OctonionHighPrecisionMember> I() {
        return this.I_;
    }

    @Override
    public Procedure1<OctonionHighPrecisionMember> J() {
        return this.J_;
    }

    @Override
    public Procedure1<OctonionHighPrecisionMember> K() {
        return this.K_;
    }

    @Override
    public Procedure1<OctonionHighPrecisionMember> L() {
        return this.L_;
    }

    @Override
    public Procedure1<OctonionHighPrecisionMember> I0() {
        return this.I0_;
    }

    @Override
    public Procedure1<OctonionHighPrecisionMember> J0() {
        return this.J0_;
    }

    @Override
    public Procedure1<OctonionHighPrecisionMember> K0() {
        return this.K0_;
    }

    @Override
    public Procedure2<OctonionHighPrecisionMember, HighPrecisionMember> real() {
        return this.REAL;
    }

    @Override
    public Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember> unreal() {
        return this.UNREAL;
    }

    @Override
    public Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember> sinh() {
        return this.SINH;
    }

    @Override
    public Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember> cosh() {
        return this.COSH;
    }

    @Override
    public Procedure3<OctonionHighPrecisionMember, OctonionHighPrecisionMember, OctonionHighPrecisionMember> sinhAndCosh() {
        return this.SINHANDCOSH;
    }

    @Override
    public Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember> tanh() {
        return this.TANH;
    }

    @Override
    public Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember> sin() {
        return this.SIN;
    }

    @Override
    public Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember> cos() {
        return this.COS;
    }

    @Override
    public Procedure3<OctonionHighPrecisionMember, OctonionHighPrecisionMember, OctonionHighPrecisionMember> sinAndCos() {
        return this.SINANDCOS;
    }

    @Override
    public Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember> tan() {
        return this.TAN;
    }

    @Override
    public Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember> exp() {
        return this.EXP;
    }

    @Override
    public Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember> log() {
        return this.LOG;
    }

    private void multiplier(BigDecimal r, BigDecimal factor, OctonionHighPrecisionMember result) {
        result.setR(r);
        result.setI(result.i().multiply(factor));
        result.setJ(result.j().multiply(factor));
        result.setK(result.k().multiply(factor));
        result.setL(result.l().multiply(factor));
        result.setI0(result.i0().multiply(factor));
        result.setJ0(result.j0().multiply(factor));
        result.setK0(result.k0().multiply(factor));
    }

    @Override
    public Procedure3<OctonionHighPrecisionMember, OctonionHighPrecisionMember, OctonionHighPrecisionMember> pow() {
        return this.POW;
    }

    @Override
    public Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember> sinch() {
        return this.SINCH;
    }

    @Override
    public Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember> sinchpi() {
        return this.SINCHPI;
    }

    @Override
    public Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember> sinc() {
        return this.SINC;
    }

    @Override
    public Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember> sincpi() {
        return this.SINCPI;
    }

    @Override
    public Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember> sqrt() {
        return this.SQRT;
    }

    @Override
    public Procedure2<OctonionHighPrecisionMember, OctonionHighPrecisionMember> cbrt() {
        return this.CBRT;
    }

    @Override
    public Function1<Boolean, OctonionHighPrecisionMember> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<OctonionHighPrecisionMember, OctonionHighPrecisionMember, OctonionHighPrecisionMember> scale() {
        return this.MUL;
    }

    @Override
    public Procedure3<HighPrecisionMember, OctonionHighPrecisionMember, OctonionHighPrecisionMember> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<RationalMember, OctonionHighPrecisionMember, OctonionHighPrecisionMember> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, OctonionHighPrecisionMember, OctonionHighPrecisionMember> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<HighPrecisionMember, OctonionHighPrecisionMember, OctonionHighPrecisionMember> scaleComponents() {
        return this.SC;
    }

    @Override
    public Function3<Boolean, HighPrecisionMember, OctonionHighPrecisionMember, OctonionHighPrecisionMember> within() {
        return this.WITHIN;
    }
}

