/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.highprec.octonion;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import nom.bdezonia.zorbage.misc.BigList;
import nom.bdezonia.zorbage.misc.LongUtils;
import nom.bdezonia.zorbage.sampling.IntegerIndex;
import nom.bdezonia.zorbage.sampling.SamplingCartesianIntegerGrid;
import nom.bdezonia.zorbage.sampling.SamplingIterator;
import nom.bdezonia.zorbage.type.algebra.Gettable;
import nom.bdezonia.zorbage.type.algebra.Settable;
import nom.bdezonia.zorbage.type.algebra.TensorMember;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.data.highprec.octonion.OctonionHighPrecisionMember;
import nom.bdezonia.zorbage.type.data.universal.OctonionRepresentation;
import nom.bdezonia.zorbage.type.data.universal.PrimitiveConversion;
import nom.bdezonia.zorbage.type.data.universal.PrimitiveRepresentation;
import nom.bdezonia.zorbage.type.data.universal.TensorOctonionRepresentation;
import nom.bdezonia.zorbage.type.data.universal.TensorStringRepresentation;
import nom.bdezonia.zorbage.type.data.universal.UniversalRepresentation;
import nom.bdezonia.zorbage.type.storage.Storage;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;
import nom.bdezonia.zorbage.type.storage.datasource.RawData;

public final class OctonionHighPrecisionCartesianTensorProductMember
implements TensorMember<OctonionHighPrecisionMember>,
Gettable<OctonionHighPrecisionCartesianTensorProductMember>,
Settable<OctonionHighPrecisionCartesianTensorProductMember>,
PrimitiveConversion,
UniversalRepresentation,
RawData<OctonionHighPrecisionMember> {
    private static final OctonionHighPrecisionMember ZERO = new OctonionHighPrecisionMember();
    private int rank;
    private long dimCount;
    private IndexedDataSource<OctonionHighPrecisionMember> storage;
    private long[] dims;
    private long[] multipliers;
    private StorageConstruction s;
    private static ThreadLocal<OctonionHighPrecisionMember> tmpOct = new ThreadLocal<OctonionHighPrecisionMember>(){

        @Override
        protected OctonionHighPrecisionMember initialValue() {
            return new OctonionHighPrecisionMember();
        }
    };

    @Override
    public int rank() {
        return this.lowerRank() + this.upperRank();
    }

    @Override
    public int lowerRank() {
        return this.rank;
    }

    @Override
    public int upperRank() {
        return 0;
    }

    @Override
    public boolean indexIsLower(int index) {
        if (index < 0 || index > this.lowerRank()) {
            throw new IllegalArgumentException("index of tensor component is outside bounds");
        }
        return true;
    }

    @Override
    public boolean indexIsUpper(int index) {
        if (index < 0 || index > this.upperRank()) {
            throw new IllegalArgumentException("index of tensor component is outside bounds");
        }
        return false;
    }

    @Override
    public long dimension() {
        return this.dimCount;
    }

    public OctonionHighPrecisionCartesianTensorProductMember() {
        this.rank = 0;
        this.dimCount = 0L;
        this.dims = new long[0];
        this.s = StorageConstruction.MEM_ARRAY;
        this.storage = Storage.allocate(this.s, 1L, new OctonionHighPrecisionMember());
        this.multipliers = this.calcMultipliers();
    }

    public OctonionHighPrecisionCartesianTensorProductMember(int rank, long dimCount) {
        if (rank < 0) {
            throw new IllegalArgumentException("bad rank in tensor constructor");
        }
        if (dimCount < 0L) {
            throw new IllegalArgumentException("bad dimensionality in tensor constructor");
        }
        this.rank = rank;
        this.dimCount = dimCount;
        this.dims = new long[rank];
        for (int i = 0; i < rank; ++i) {
            this.dims[i] = dimCount;
        }
        long numElems = LongUtils.numElements(this.dims);
        if (numElems == 0L) {
            numElems = 1L;
        }
        this.s = StorageConstruction.MEM_ARRAY;
        this.storage = Storage.allocate(this.s, numElems, new OctonionHighPrecisionMember());
        this.multipliers = this.calcMultipliers();
    }

    public OctonionHighPrecisionCartesianTensorProductMember(int rank, long dimCount, BigDecimal[] vals) {
        this(rank, dimCount);
        if ((long)vals.length != this.storage.size() * 8L) {
            throw new IllegalArgumentException("incorrect number of values given in tensor constructor");
        }
        OctonionHighPrecisionMember value = new OctonionHighPrecisionMember();
        for (int i = 0; i < vals.length; i += 8) {
            value.setR(vals[i]);
            value.setI(vals[i + 1]);
            value.setJ(vals[i + 2]);
            value.setK(vals[i + 3]);
            value.setL(vals[i + 4]);
            value.setI0(vals[i + 5]);
            value.setJ0(vals[i + 6]);
            value.setK0(vals[i + 7]);
            this.storage.set(i, value);
        }
    }

    public OctonionHighPrecisionCartesianTensorProductMember(long[] dims) {
        this.rank = dims.length;
        long max = 0L;
        for (long d : dims) {
            if (max >= d) continue;
            max = d;
        }
        this.dimCount = max;
        this.dims = new long[this.rank];
        for (int i = 0; i < this.rank; ++i) {
            this.dims[i] = this.dimCount;
        }
        long numElems = LongUtils.numElements(this.dims);
        if (numElems == 0L) {
            numElems = 1L;
        }
        this.s = StorageConstruction.MEM_ARRAY;
        this.storage = Storage.allocate(this.s, numElems, new OctonionHighPrecisionMember());
        this.multipliers = this.calcMultipliers();
    }

    public OctonionHighPrecisionCartesianTensorProductMember(long[] dims, BigDecimal[] vals) {
        this(dims);
        long numElems = LongUtils.numElements(dims);
        if (numElems == 0L) {
            numElems = 1L;
        }
        if ((long)vals.length != numElems * 8L) {
            throw new IllegalArgumentException("incorrect number of values provided to tensor constructor");
        }
        OctonionHighPrecisionMember value = new OctonionHighPrecisionMember();
        if (numElems == 1L) {
            value.setR(vals[0]);
            value.setI(vals[1]);
            value.setJ(vals[2]);
            value.setK(vals[3]);
            value.setL(vals[4]);
            value.setI0(vals[5]);
            value.setJ0(vals[6]);
            value.setK0(vals[7]);
            this.storage.set(0L, value);
        } else {
            int i;
            long[] point1 = new long[dims.length];
            long[] point2 = new long[dims.length];
            for (i = 0; i < dims.length; ++i) {
                point2[i] = dims[i] - 1L;
            }
            i = 0;
            SamplingCartesianIntegerGrid sampling = new SamplingCartesianIntegerGrid(point1, point2);
            SamplingIterator<IntegerIndex> iter = sampling.iterator();
            IntegerIndex index = new IntegerIndex(dims.length);
            while (iter.hasNext()) {
                iter.next(index);
                value.setR(vals[i]);
                value.setI(vals[i + 1]);
                value.setJ(vals[i + 2]);
                value.setK(vals[i + 3]);
                value.setL(vals[i + 4]);
                value.setI0(vals[i + 5]);
                value.setJ0(vals[i + 6]);
                value.setK0(vals[i + 7]);
                long idx = this.indexToLong(index);
                this.storage.set(idx, value);
                i += 8;
            }
        }
    }

    public OctonionHighPrecisionCartesianTensorProductMember(OctonionHighPrecisionCartesianTensorProductMember other) {
        this.set(other);
    }

    public OctonionHighPrecisionCartesianTensorProductMember(String s) {
        TensorStringRepresentation rep = new TensorStringRepresentation(s);
        BigList<OctonionRepresentation> data = rep.values();
        long[] tmpDims = (long[])rep.dimensions().clone();
        this.rank = tmpDims.length;
        long max = 0L;
        for (long d : tmpDims) {
            if (max >= d) continue;
            max = d;
        }
        this.dimCount = max;
        this.dims = new long[this.rank];
        for (int i = 0; i < this.rank; ++i) {
            this.dims[i] = this.dimCount;
        }
        long numElems = LongUtils.numElements(this.dims);
        if (numElems == 0L) {
            numElems = 1L;
        }
        this.s = StorageConstruction.MEM_ARRAY;
        this.storage = Storage.allocate(this.s, numElems, new OctonionHighPrecisionMember());
        this.multipliers = this.calcMultipliers();
        OctonionHighPrecisionMember value = new OctonionHighPrecisionMember();
        if (numElems == 1L) {
            OctonionRepresentation val = data.get(0L);
            value.setR(val.r());
            value.setI(val.i());
            value.setJ(val.j());
            value.setK(val.k());
            value.setL(val.l());
            value.setI0(val.i0());
            value.setJ0(val.j0());
            value.setK0(val.k0());
            this.storage.set(0L, value);
        } else {
            long[] point1 = new long[tmpDims.length];
            long[] point2 = new long[tmpDims.length];
            for (int i = 0; i < tmpDims.length; ++i) {
                point2[i] = tmpDims[i] - 1L;
            }
            long i = 0L;
            SamplingCartesianIntegerGrid sampling = new SamplingCartesianIntegerGrid(point1, point2);
            SamplingIterator<IntegerIndex> iter = sampling.iterator();
            IntegerIndex index = new IntegerIndex(this.dims.length);
            while (iter.hasNext()) {
                iter.next(index);
                OctonionRepresentation val = data.get(i);
                value.setR(val.r());
                value.setI(val.i());
                value.setJ(val.j());
                value.setK(val.k());
                value.setL(val.l());
                value.setI0(val.i0());
                value.setJ0(val.j0());
                value.setK0(val.k0());
                long idx = this.indexToLong(index);
                this.storage.set(idx, value);
                ++i;
            }
        }
    }

    public OctonionHighPrecisionCartesianTensorProductMember(StorageConstruction s, long[] nd) {
        this.rank = this.dims.length;
        long max = 0L;
        for (long d : this.dims) {
            if (max >= d) continue;
            max = d;
        }
        this.dimCount = max;
        this.dims = new long[this.rank];
        for (int i = 0; i < this.rank; ++i) {
            this.dims[i] = this.dimCount;
        }
        this.multipliers = this.calcMultipliers();
        this.s = s;
        long numElems = LongUtils.numElements(this.dims);
        if (numElems == 0L) {
            numElems = 1L;
        }
        this.storage = Storage.allocate(s, numElems, new OctonionHighPrecisionMember());
    }

    @Override
    public StorageConstruction storageType() {
        return this.s;
    }

    @Override
    public void set(OctonionHighPrecisionCartesianTensorProductMember other) {
        if (this == other) {
            return;
        }
        this.rank = other.rank;
        this.dimCount = other.dimCount;
        this.dims = (long[])other.dims.clone();
        this.multipliers = (long[])other.multipliers.clone();
        this.storage = (IndexedDataSource)other.storage.duplicate();
        this.s = other.s;
    }

    @Override
    public void get(OctonionHighPrecisionCartesianTensorProductMember other) {
        if (this == other) {
            return;
        }
        other.rank = this.rank;
        other.dimCount = this.dimCount;
        other.dims = (long[])this.dims.clone();
        other.multipliers = (long[])this.multipliers.clone();
        other.storage = (IndexedDataSource)this.storage.duplicate();
        other.s = this.s;
    }

    @Override
    public boolean alloc(long[] newDims) {
        boolean theSame = true;
        if (newDims.length != this.dims.length) {
            theSame = false;
        } else {
            for (int i = 0; i < newDims.length; ++i) {
                if (newDims[i] == this.dims[i]) continue;
                theSame = false;
                break;
            }
        }
        if (theSame) {
            return false;
        }
        this.rank = newDims.length;
        long max = 0L;
        for (long d : newDims) {
            if (max >= d) continue;
            max = d;
        }
        this.dimCount = max;
        this.dims = new long[this.rank];
        for (int i = 0; i < this.rank; ++i) {
            this.dims[i] = this.dimCount;
        }
        this.multipliers = this.calcMultipliers();
        long newCount = LongUtils.numElements(this.dims);
        if (newCount == 0L) {
            newCount = 1L;
        }
        if (this.storage == null || newCount != this.storage.size()) {
            this.storage = Storage.allocate(this.s, newCount, new OctonionHighPrecisionMember());
            return true;
        }
        return false;
    }

    @Override
    public void init(long[] newDims) {
        if (!this.alloc(newDims)) {
            long storageSize = this.storage.size();
            for (long i = 0L; i < storageSize; ++i) {
                this.storage.set(i, ZERO);
            }
        }
    }

    public long numElems() {
        return this.storage.size();
    }

    void v(long index, OctonionHighPrecisionMember value) {
        this.storage.get(index, value);
    }

    @Override
    public void v(IntegerIndex index, OctonionHighPrecisionMember value) {
        long idx = this.indexToLong(index);
        this.storage.get(idx, value);
    }

    void setV(long index, OctonionHighPrecisionMember value) {
        this.storage.set(index, value);
    }

    @Override
    public void setV(IntegerIndex index, OctonionHighPrecisionMember value) {
        long idx = this.indexToLong(index);
        this.storage.set(idx, value);
    }

    @Override
    public void toRep(TensorOctonionRepresentation rep) {
        long storageSize = this.storage.size();
        OctonionHighPrecisionMember value = new OctonionHighPrecisionMember();
        BigList<OctonionRepresentation> values = new BigList<OctonionRepresentation>(storageSize);
        for (long i = 0L; i < storageSize; ++i) {
            this.storage.get(i, value);
            BigDecimal re = value.r();
            BigDecimal im = value.i();
            BigDecimal j = value.j();
            BigDecimal k = value.k();
            BigDecimal l = value.l();
            BigDecimal i0 = value.i0();
            BigDecimal j0 = value.j0();
            BigDecimal k0 = value.k0();
            OctonionRepresentation o = new OctonionRepresentation(re, im, j, k, l, i0, j0, k0);
            values.set(i, o);
        }
        rep.setTensor(this.dims, values);
    }

    @Override
    public void fromRep(TensorOctonionRepresentation rep) {
        OctonionHighPrecisionMember value = new OctonionHighPrecisionMember();
        BigList<OctonionRepresentation> tensor = rep.getTensor();
        this.init(rep.getTensorDims());
        long tensorSize = tensor.size();
        for (long i = 0L; i < tensorSize; ++i) {
            OctonionRepresentation o = tensor.get(i);
            value.setR(o.r());
            value.setI(o.i());
            value.setJ(o.j());
            value.setK(o.k());
            value.setL(o.l());
            value.setI0(o.i0());
            value.setJ0(o.j0());
            value.setK0(o.k0());
            this.storage.set(i, value);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        OctonionHighPrecisionMember tmp = new OctonionHighPrecisionMember();
        IntegerIndex index = new IntegerIndex(this.dims.length);
        long storageSize = this.storage.size();
        for (long i = 0L; i < storageSize; ++i) {
            this.storage.get(i, tmp);
            this.longToIntegerIndex(i, index);
            int j = 0;
            while (j < index.numDimensions() && index.get(j++) == 0L) {
                builder.append('[');
            }
            if (index.get(0) != 0L) {
                builder.append(',');
            }
            builder.append('{');
            builder.append(tmp.r());
            builder.append(',');
            builder.append(tmp.i());
            builder.append(',');
            builder.append(tmp.j());
            builder.append(',');
            builder.append(tmp.k());
            builder.append(',');
            builder.append(tmp.l());
            builder.append(',');
            builder.append(tmp.i0());
            builder.append(',');
            builder.append(tmp.j0());
            builder.append(',');
            builder.append(tmp.k0());
            builder.append('}');
            j = 0;
            while (j < index.numDimensions() && index.get(j) == this.dims[j++] - 1L) {
                builder.append(']');
            }
        }
        return builder.toString();
    }

    private long[] calcMultipliers() {
        if (this.dims.length == 0) {
            return new long[0];
        }
        long[] result = new long[this.dims.length - 1];
        long mult = 1L;
        for (int i = 0; i < result.length; ++i) {
            result[i] = mult;
            mult *= this.dims[i];
        }
        return result;
    }

    private long indexToLong(IntegerIndex idx) {
        if (idx.numDimensions() == 0) {
            throw new IllegalArgumentException("null index");
        }
        if (idx.numDimensions() >= this.dims.length && this.indexOob(idx, 0)) {
            throw new IllegalArgumentException("index out of bounds");
        }
        long index = 0L;
        long mult = 1L;
        for (int i = 0; i < this.dims.length; ++i) {
            index += mult * idx.get(i);
            mult *= this.dims[i];
        }
        return index;
    }

    private void longToIntegerIndex(long idx, IntegerIndex result) {
        int i;
        if (idx < 0L) {
            throw new IllegalArgumentException("negative index in tensor addressing");
        }
        if (idx >= this.storage.size()) {
            throw new IllegalArgumentException("index beyond end of tensor storage");
        }
        if (result.numDimensions() < this.dims.length) {
            throw new IllegalArgumentException("mismatched dims in tensor member");
        }
        for (i = this.dims.length; i < result.numDimensions(); ++i) {
            result.set(i, 0L);
        }
        for (i = this.dims.length - 1; i >= 0; --i) {
            result.set(i, idx / this.multipliers[i]);
            idx %= this.multipliers[i];
        }
    }

    private boolean indexOob(IntegerIndex idx, int component) {
        long index;
        int i;
        if (component < 0) {
            throw new IllegalArgumentException("negative component specified in indexOob");
        }
        if (component > 7) {
            return true;
        }
        for (i = 0; i < this.dims.length; ++i) {
            index = idx.get(i);
            if (index < 0L) {
                throw new IllegalArgumentException("negative index in indexOob");
            }
            if (index < this.dims[i]) continue;
            return true;
        }
        for (i = this.dims.length; i < idx.numDimensions(); ++i) {
            index = idx.get(i);
            if (index < 0L) {
                throw new IllegalArgumentException("negative index in indexOob");
            }
            if (index <= 0L) continue;
            return true;
        }
        return false;
    }

    @Override
    public int numDimensions() {
        return this.dims.length;
    }

    @Override
    public void reshape(long[] dims) {
        if (Arrays.equals(this.dims, dims)) {
            return;
        }
        throw new IllegalArgumentException("to implement");
    }

    @Override
    public long dimension(int d) {
        if (d < 0) {
            throw new IllegalArgumentException("can't query negative dimension");
        }
        if (d >= this.dims.length) {
            return 1L;
        }
        return this.dims[d];
    }

    @Override
    public PrimitiveRepresentation preferredRepresentation() {
        return PrimitiveRepresentation.BIGDECIMAL;
    }

    @Override
    public int componentCount() {
        return 8;
    }

    @Override
    public void primComponentSetByte(IntegerIndex index, int component, byte v) {
        OctonionHighPrecisionMember tmp = tmpOct.get();
        this.v(index, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    tmp.setR(BigDecimal.valueOf(v));
                } else {
                    tmp.setI(BigDecimal.valueOf(v));
                }
            } else if (component == 2) {
                tmp.setJ(BigDecimal.valueOf(v));
            } else {
                tmp.setK(BigDecimal.valueOf(v));
            }
        } else if (component < 6) {
            if (component == 4) {
                tmp.setL(BigDecimal.valueOf(v));
            } else {
                tmp.setI0(BigDecimal.valueOf(v));
            }
        } else if (component == 6) {
            tmp.setJ0(BigDecimal.valueOf(v));
        } else {
            tmp.setK0(BigDecimal.valueOf(v));
        }
        this.setV(index, tmp);
    }

    @Override
    public void primComponentSetShort(IntegerIndex index, int component, short v) {
        OctonionHighPrecisionMember tmp = tmpOct.get();
        this.v(index, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    tmp.setR(BigDecimal.valueOf(v));
                } else {
                    tmp.setI(BigDecimal.valueOf(v));
                }
            } else if (component == 2) {
                tmp.setJ(BigDecimal.valueOf(v));
            } else {
                tmp.setK(BigDecimal.valueOf(v));
            }
        } else if (component < 6) {
            if (component == 4) {
                tmp.setL(BigDecimal.valueOf(v));
            } else {
                tmp.setI0(BigDecimal.valueOf(v));
            }
        } else if (component == 6) {
            tmp.setJ0(BigDecimal.valueOf(v));
        } else {
            tmp.setK0(BigDecimal.valueOf(v));
        }
        this.setV(index, tmp);
    }

    @Override
    public void primComponentSetInt(IntegerIndex index, int component, int v) {
        OctonionHighPrecisionMember tmp = tmpOct.get();
        this.v(index, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    tmp.setR(BigDecimal.valueOf(v));
                } else {
                    tmp.setI(BigDecimal.valueOf(v));
                }
            } else if (component == 2) {
                tmp.setJ(BigDecimal.valueOf(v));
            } else {
                tmp.setK(BigDecimal.valueOf(v));
            }
        } else if (component < 6) {
            if (component == 4) {
                tmp.setL(BigDecimal.valueOf(v));
            } else {
                tmp.setI0(BigDecimal.valueOf(v));
            }
        } else if (component == 6) {
            tmp.setJ0(BigDecimal.valueOf(v));
        } else {
            tmp.setK0(BigDecimal.valueOf(v));
        }
        this.setV(index, tmp);
    }

    @Override
    public void primComponentSetLong(IntegerIndex index, int component, long v) {
        OctonionHighPrecisionMember tmp = tmpOct.get();
        this.v(index, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    tmp.setR(BigDecimal.valueOf(v));
                } else {
                    tmp.setI(BigDecimal.valueOf(v));
                }
            } else if (component == 2) {
                tmp.setJ(BigDecimal.valueOf(v));
            } else {
                tmp.setK(BigDecimal.valueOf(v));
            }
        } else if (component < 6) {
            if (component == 4) {
                tmp.setL(BigDecimal.valueOf(v));
            } else {
                tmp.setI0(BigDecimal.valueOf(v));
            }
        } else if (component == 6) {
            tmp.setJ0(BigDecimal.valueOf(v));
        } else {
            tmp.setK0(BigDecimal.valueOf(v));
        }
        this.setV(index, tmp);
    }

    @Override
    public void primComponentSetFloat(IntegerIndex index, int component, float v) {
        OctonionHighPrecisionMember tmp = tmpOct.get();
        this.v(index, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    tmp.setR(BigDecimal.valueOf(v));
                } else {
                    tmp.setI(BigDecimal.valueOf(v));
                }
            } else if (component == 2) {
                tmp.setJ(BigDecimal.valueOf(v));
            } else {
                tmp.setK(BigDecimal.valueOf(v));
            }
        } else if (component < 6) {
            if (component == 4) {
                tmp.setL(BigDecimal.valueOf(v));
            } else {
                tmp.setI0(BigDecimal.valueOf(v));
            }
        } else if (component == 6) {
            tmp.setJ0(BigDecimal.valueOf(v));
        } else {
            tmp.setK0(BigDecimal.valueOf(v));
        }
        this.setV(index, tmp);
    }

    @Override
    public void primComponentSetDouble(IntegerIndex index, int component, double v) {
        OctonionHighPrecisionMember tmp = tmpOct.get();
        this.v(index, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    tmp.setR(BigDecimal.valueOf(v));
                } else {
                    tmp.setI(BigDecimal.valueOf(v));
                }
            } else if (component == 2) {
                tmp.setJ(BigDecimal.valueOf(v));
            } else {
                tmp.setK(BigDecimal.valueOf(v));
            }
        } else if (component < 6) {
            if (component == 4) {
                tmp.setL(BigDecimal.valueOf(v));
            } else {
                tmp.setI0(BigDecimal.valueOf(v));
            }
        } else if (component == 6) {
            tmp.setJ0(BigDecimal.valueOf(v));
        } else {
            tmp.setK0(BigDecimal.valueOf(v));
        }
        this.setV(index, tmp);
    }

    @Override
    public void primComponentSetBigInteger(IntegerIndex index, int component, BigInteger v) {
        OctonionHighPrecisionMember tmp = tmpOct.get();
        this.v(index, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    tmp.setR(new BigDecimal(v));
                } else {
                    tmp.setI(new BigDecimal(v));
                }
            } else if (component == 2) {
                tmp.setJ(new BigDecimal(v));
            } else {
                tmp.setK(new BigDecimal(v));
            }
        } else if (component < 6) {
            if (component == 4) {
                tmp.setL(new BigDecimal(v));
            } else {
                tmp.setI0(new BigDecimal(v));
            }
        } else if (component == 6) {
            tmp.setJ0(new BigDecimal(v));
        } else {
            tmp.setK0(new BigDecimal(v));
        }
        this.setV(index, tmp);
    }

    @Override
    public void primComponentSetBigDecimal(IntegerIndex index, int component, BigDecimal v) {
        OctonionHighPrecisionMember tmp = tmpOct.get();
        this.v(index, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    tmp.setR(v);
                } else {
                    tmp.setI(v);
                }
            } else if (component == 2) {
                tmp.setJ(v);
            } else {
                tmp.setK(v);
            }
        } else if (component < 6) {
            if (component == 4) {
                tmp.setL(v);
            } else {
                tmp.setI0(v);
            }
        } else if (component == 6) {
            tmp.setJ0(v);
        } else {
            tmp.setK0(v);
        }
        this.setV(index, tmp);
    }

    @Override
    public void primComponentSetByteSafe(IntegerIndex index, int component, byte v) {
        if (this.indexOob(index, component)) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            OctonionHighPrecisionMember tmp = tmpOct.get();
            this.v(index, tmp);
            if (component < 4) {
                if (component < 2) {
                    if (component == 0) {
                        tmp.setR(BigDecimal.valueOf(v));
                    } else {
                        tmp.setI(BigDecimal.valueOf(v));
                    }
                } else if (component == 2) {
                    tmp.setJ(BigDecimal.valueOf(v));
                } else {
                    tmp.setK(BigDecimal.valueOf(v));
                }
            } else if (component < 6) {
                if (component == 4) {
                    tmp.setL(BigDecimal.valueOf(v));
                } else {
                    tmp.setI0(BigDecimal.valueOf(v));
                }
            } else if (component == 6) {
                tmp.setJ0(BigDecimal.valueOf(v));
            } else {
                tmp.setK0(BigDecimal.valueOf(v));
            }
            this.setV(index, tmp);
        }
    }

    @Override
    public void primComponentSetShortSafe(IntegerIndex index, int component, short v) {
        if (this.indexOob(index, component)) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            OctonionHighPrecisionMember tmp = tmpOct.get();
            this.v(index, tmp);
            if (component < 4) {
                if (component < 2) {
                    if (component == 0) {
                        tmp.setR(BigDecimal.valueOf(v));
                    } else {
                        tmp.setI(BigDecimal.valueOf(v));
                    }
                } else if (component == 2) {
                    tmp.setJ(BigDecimal.valueOf(v));
                } else {
                    tmp.setK(BigDecimal.valueOf(v));
                }
            } else if (component < 6) {
                if (component == 4) {
                    tmp.setL(BigDecimal.valueOf(v));
                } else {
                    tmp.setI0(BigDecimal.valueOf(v));
                }
            } else if (component == 6) {
                tmp.setJ0(BigDecimal.valueOf(v));
            } else {
                tmp.setK0(BigDecimal.valueOf(v));
            }
            this.setV(index, tmp);
        }
    }

    @Override
    public void primComponentSetIntSafe(IntegerIndex index, int component, int v) {
        if (this.indexOob(index, component)) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            OctonionHighPrecisionMember tmp = tmpOct.get();
            this.v(index, tmp);
            if (component < 4) {
                if (component < 2) {
                    if (component == 0) {
                        tmp.setR(BigDecimal.valueOf(v));
                    } else {
                        tmp.setI(BigDecimal.valueOf(v));
                    }
                } else if (component == 2) {
                    tmp.setJ(BigDecimal.valueOf(v));
                } else {
                    tmp.setK(BigDecimal.valueOf(v));
                }
            } else if (component < 6) {
                if (component == 4) {
                    tmp.setL(BigDecimal.valueOf(v));
                } else {
                    tmp.setI0(BigDecimal.valueOf(v));
                }
            } else if (component == 6) {
                tmp.setJ0(BigDecimal.valueOf(v));
            } else {
                tmp.setK0(BigDecimal.valueOf(v));
            }
            this.setV(index, tmp);
        }
    }

    @Override
    public void primComponentSetLongSafe(IntegerIndex index, int component, long v) {
        if (this.indexOob(index, component)) {
            if (v != 0L) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            OctonionHighPrecisionMember tmp = tmpOct.get();
            this.v(index, tmp);
            if (component < 4) {
                if (component < 2) {
                    if (component == 0) {
                        tmp.setR(BigDecimal.valueOf(v));
                    } else {
                        tmp.setI(BigDecimal.valueOf(v));
                    }
                } else if (component == 2) {
                    tmp.setJ(BigDecimal.valueOf(v));
                } else {
                    tmp.setK(BigDecimal.valueOf(v));
                }
            } else if (component < 6) {
                if (component == 4) {
                    tmp.setL(BigDecimal.valueOf(v));
                } else {
                    tmp.setI0(BigDecimal.valueOf(v));
                }
            } else if (component == 6) {
                tmp.setJ0(BigDecimal.valueOf(v));
            } else {
                tmp.setK0(BigDecimal.valueOf(v));
            }
            this.setV(index, tmp);
        }
    }

    @Override
    public void primComponentSetFloatSafe(IntegerIndex index, int component, float v) {
        if (this.indexOob(index, component)) {
            if (v != 0.0f) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            OctonionHighPrecisionMember tmp = tmpOct.get();
            this.v(index, tmp);
            if (component < 4) {
                if (component < 2) {
                    if (component == 0) {
                        tmp.setR(BigDecimal.valueOf(v));
                    } else {
                        tmp.setI(BigDecimal.valueOf(v));
                    }
                } else if (component == 2) {
                    tmp.setJ(BigDecimal.valueOf(v));
                } else {
                    tmp.setK(BigDecimal.valueOf(v));
                }
            } else if (component < 6) {
                if (component == 4) {
                    tmp.setL(BigDecimal.valueOf(v));
                } else {
                    tmp.setI0(BigDecimal.valueOf(v));
                }
            } else if (component == 6) {
                tmp.setJ0(BigDecimal.valueOf(v));
            } else {
                tmp.setK0(BigDecimal.valueOf(v));
            }
            this.setV(index, tmp);
        }
    }

    @Override
    public void primComponentSetDoubleSafe(IntegerIndex index, int component, double v) {
        if (this.indexOob(index, component)) {
            if (v != 0.0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            OctonionHighPrecisionMember tmp = tmpOct.get();
            this.v(index, tmp);
            if (component < 4) {
                if (component < 2) {
                    if (component == 0) {
                        tmp.setR(BigDecimal.valueOf(v));
                    } else {
                        tmp.setI(BigDecimal.valueOf(v));
                    }
                } else if (component == 2) {
                    tmp.setJ(BigDecimal.valueOf(v));
                } else {
                    tmp.setK(BigDecimal.valueOf(v));
                }
            } else if (component < 6) {
                if (component == 4) {
                    tmp.setL(BigDecimal.valueOf(v));
                } else {
                    tmp.setI0(BigDecimal.valueOf(v));
                }
            } else if (component == 6) {
                tmp.setJ0(BigDecimal.valueOf(v));
            } else {
                tmp.setK0(BigDecimal.valueOf(v));
            }
            this.setV(index, tmp);
        }
    }

    @Override
    public void primComponentSetBigIntegerSafe(IntegerIndex index, int component, BigInteger v) {
        if (this.indexOob(index, component)) {
            if (v.signum() != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            OctonionHighPrecisionMember tmp = tmpOct.get();
            this.v(index, tmp);
            if (component < 4) {
                if (component < 2) {
                    if (component == 0) {
                        tmp.setR(new BigDecimal(v));
                    } else {
                        tmp.setI(new BigDecimal(v));
                    }
                } else if (component == 2) {
                    tmp.setJ(new BigDecimal(v));
                } else {
                    tmp.setK(new BigDecimal(v));
                }
            } else if (component < 6) {
                if (component == 4) {
                    tmp.setL(new BigDecimal(v));
                } else {
                    tmp.setI0(new BigDecimal(v));
                }
            } else if (component == 6) {
                tmp.setJ0(new BigDecimal(v));
            } else {
                tmp.setK0(new BigDecimal(v));
            }
        }
    }

    @Override
    public void primComponentSetBigDecimalSafe(IntegerIndex index, int component, BigDecimal v) {
        if (this.indexOob(index, component)) {
            if (v.signum() != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            OctonionHighPrecisionMember tmp = tmpOct.get();
            this.v(index, tmp);
            if (component < 4) {
                if (component < 2) {
                    if (component == 0) {
                        tmp.setR(v);
                    } else {
                        tmp.setI(v);
                    }
                } else if (component == 2) {
                    tmp.setJ(v);
                } else {
                    tmp.setK(v);
                }
            } else if (component < 6) {
                if (component == 4) {
                    tmp.setL(v);
                } else {
                    tmp.setI0(v);
                }
            } else if (component == 6) {
                tmp.setJ0(v);
            } else {
                tmp.setK0(v);
            }
            this.setV(index, tmp);
        }
    }

    @Override
    public byte primComponentGetAsByte(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        OctonionHighPrecisionMember tmp = tmpOct.get();
        this.v(index, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return tmp.r().byteValue();
                }
                return tmp.i().byteValue();
            }
            if (component == 2) {
                return tmp.j().byteValue();
            }
            return tmp.k().byteValue();
        }
        if (component < 6) {
            if (component == 4) {
                return tmp.l().byteValue();
            }
            return tmp.i0().byteValue();
        }
        if (component == 6) {
            return tmp.j0().byteValue();
        }
        return tmp.k0().byteValue();
    }

    @Override
    public short primComponentGetAsShort(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        OctonionHighPrecisionMember tmp = tmpOct.get();
        this.v(index, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return tmp.r().shortValue();
                }
                return tmp.i().shortValue();
            }
            if (component == 2) {
                return tmp.j().shortValue();
            }
            return tmp.k().shortValue();
        }
        if (component < 6) {
            if (component == 4) {
                return tmp.l().shortValue();
            }
            return tmp.i0().shortValue();
        }
        if (component == 6) {
            return tmp.j0().shortValue();
        }
        return tmp.k0().shortValue();
    }

    @Override
    public int primComponentGetAsInt(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        OctonionHighPrecisionMember tmp = tmpOct.get();
        this.v(index, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return tmp.r().intValue();
                }
                return tmp.i().intValue();
            }
            if (component == 2) {
                return tmp.j().intValue();
            }
            return tmp.k().intValue();
        }
        if (component < 6) {
            if (component == 4) {
                return tmp.l().intValue();
            }
            return tmp.i0().intValue();
        }
        if (component == 6) {
            return tmp.j0().intValue();
        }
        return tmp.k0().intValue();
    }

    @Override
    public long primComponentGetAsLong(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        OctonionHighPrecisionMember tmp = tmpOct.get();
        this.v(index, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return tmp.r().longValue();
                }
                return tmp.i().longValue();
            }
            if (component == 2) {
                return tmp.j().longValue();
            }
            return tmp.k().longValue();
        }
        if (component < 6) {
            if (component == 4) {
                return tmp.l().longValue();
            }
            return tmp.i0().longValue();
        }
        if (component == 6) {
            return tmp.j0().longValue();
        }
        return tmp.k0().longValue();
    }

    @Override
    public float primComponentGetAsFloat(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        OctonionHighPrecisionMember tmp = tmpOct.get();
        this.v(index, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return tmp.r().floatValue();
                }
                return tmp.i().floatValue();
            }
            if (component == 2) {
                return tmp.j().floatValue();
            }
            return tmp.k().floatValue();
        }
        if (component < 6) {
            if (component == 4) {
                return tmp.l().floatValue();
            }
            return tmp.i0().floatValue();
        }
        if (component == 6) {
            return tmp.j0().floatValue();
        }
        return tmp.k0().floatValue();
    }

    @Override
    public double primComponentGetAsDouble(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        OctonionHighPrecisionMember tmp = tmpOct.get();
        this.v(index, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return tmp.r().doubleValue();
                }
                return tmp.i().doubleValue();
            }
            if (component == 2) {
                return tmp.j().doubleValue();
            }
            return tmp.k().doubleValue();
        }
        if (component < 6) {
            if (component == 4) {
                return tmp.l().doubleValue();
            }
            return tmp.i0().doubleValue();
        }
        if (component == 6) {
            return tmp.j0().doubleValue();
        }
        return tmp.k0().doubleValue();
    }

    @Override
    public BigInteger primComponentGetAsBigInteger(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        OctonionHighPrecisionMember tmp = tmpOct.get();
        this.v(index, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return tmp.r().toBigInteger();
                }
                return tmp.i().toBigInteger();
            }
            if (component == 2) {
                return tmp.j().toBigInteger();
            }
            return tmp.k().toBigInteger();
        }
        if (component < 6) {
            if (component == 4) {
                return tmp.l().toBigInteger();
            }
            return tmp.i0().toBigInteger();
        }
        if (component == 6) {
            return tmp.j0().toBigInteger();
        }
        return tmp.k0().toBigInteger();
    }

    @Override
    public BigDecimal primComponentGetAsBigDecimal(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        OctonionHighPrecisionMember tmp = tmpOct.get();
        this.v(index, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return tmp.r();
                }
                return tmp.i();
            }
            if (component == 2) {
                return tmp.j();
            }
            return tmp.k();
        }
        if (component < 6) {
            if (component == 4) {
                return tmp.l();
            }
            return tmp.i0();
        }
        if (component == 6) {
            return tmp.j0();
        }
        return tmp.k0();
    }

    @Override
    public byte primComponentGetAsByteSafe(IntegerIndex index, int component) {
        if (this.indexOob(index, component)) {
            return 0;
        }
        OctonionHighPrecisionMember tmp = tmpOct.get();
        this.v(index, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return tmp.r().byteValue();
                }
                return tmp.i().byteValue();
            }
            if (component == 2) {
                return tmp.j().byteValue();
            }
            return tmp.k().byteValue();
        }
        if (component < 6) {
            if (component == 4) {
                return tmp.l().byteValue();
            }
            return tmp.i0().byteValue();
        }
        if (component == 6) {
            return tmp.j0().byteValue();
        }
        return tmp.k0().byteValue();
    }

    @Override
    public short primComponentGetAsShortSafe(IntegerIndex index, int component) {
        if (this.indexOob(index, component)) {
            return 0;
        }
        OctonionHighPrecisionMember tmp = tmpOct.get();
        this.v(index, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return tmp.r().shortValue();
                }
                return tmp.i().shortValue();
            }
            if (component == 2) {
                return tmp.j().shortValue();
            }
            return tmp.k().shortValue();
        }
        if (component < 6) {
            if (component == 4) {
                return tmp.l().shortValue();
            }
            return tmp.i0().shortValue();
        }
        if (component == 6) {
            return tmp.j0().shortValue();
        }
        return tmp.k0().shortValue();
    }

    @Override
    public int primComponentGetAsIntSafe(IntegerIndex index, int component) {
        if (this.indexOob(index, component)) {
            return 0;
        }
        OctonionHighPrecisionMember tmp = tmpOct.get();
        this.v(index, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return tmp.r().intValue();
                }
                return tmp.i().intValue();
            }
            if (component == 2) {
                return tmp.j().intValue();
            }
            return tmp.k().intValue();
        }
        if (component < 6) {
            if (component == 4) {
                return tmp.l().intValue();
            }
            return tmp.i0().intValue();
        }
        if (component == 6) {
            return tmp.j0().intValue();
        }
        return tmp.k0().intValue();
    }

    @Override
    public long primComponentGetAsLongSafe(IntegerIndex index, int component) {
        if (this.indexOob(index, component)) {
            return 0L;
        }
        OctonionHighPrecisionMember tmp = tmpOct.get();
        this.v(index, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return tmp.r().longValue();
                }
                return tmp.i().longValue();
            }
            if (component == 2) {
                return tmp.j().longValue();
            }
            return tmp.k().longValue();
        }
        if (component < 6) {
            if (component == 4) {
                return tmp.l().longValue();
            }
            return tmp.i0().longValue();
        }
        if (component == 6) {
            return tmp.j0().longValue();
        }
        return tmp.k0().longValue();
    }

    @Override
    public float primComponentGetAsFloatSafe(IntegerIndex index, int component) {
        if (this.indexOob(index, component)) {
            return 0.0f;
        }
        OctonionHighPrecisionMember tmp = tmpOct.get();
        this.v(index, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return tmp.r().floatValue();
                }
                return tmp.i().floatValue();
            }
            if (component == 2) {
                return tmp.j().floatValue();
            }
            return tmp.k().floatValue();
        }
        if (component < 6) {
            if (component == 4) {
                return tmp.l().floatValue();
            }
            return tmp.i0().floatValue();
        }
        if (component == 6) {
            return tmp.j0().floatValue();
        }
        return tmp.k0().floatValue();
    }

    @Override
    public double primComponentGetAsDoubleSafe(IntegerIndex index, int component) {
        if (this.indexOob(index, component)) {
            return 0.0;
        }
        OctonionHighPrecisionMember tmp = tmpOct.get();
        this.v(index, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return tmp.r().doubleValue();
                }
                return tmp.i().doubleValue();
            }
            if (component == 2) {
                return tmp.j().doubleValue();
            }
            return tmp.k().doubleValue();
        }
        if (component < 6) {
            if (component == 4) {
                return tmp.l().doubleValue();
            }
            return tmp.i0().doubleValue();
        }
        if (component == 6) {
            return tmp.j0().doubleValue();
        }
        return tmp.k0().doubleValue();
    }

    @Override
    public BigInteger primComponentGetAsBigIntegerSafe(IntegerIndex index, int component) {
        if (this.indexOob(index, component)) {
            return BigInteger.ZERO;
        }
        OctonionHighPrecisionMember tmp = tmpOct.get();
        this.v(index, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return tmp.r().toBigInteger();
                }
                return tmp.i().toBigInteger();
            }
            if (component == 2) {
                return tmp.j().toBigInteger();
            }
            return tmp.k().toBigInteger();
        }
        if (component < 6) {
            if (component == 4) {
                return tmp.l().toBigInteger();
            }
            return tmp.i0().toBigInteger();
        }
        if (component == 6) {
            return tmp.j0().toBigInteger();
        }
        return tmp.k0().toBigInteger();
    }

    @Override
    public BigDecimal primComponentGetAsBigDecimalSafe(IntegerIndex index, int component) {
        if (this.indexOob(index, component)) {
            return BigDecimal.ZERO;
        }
        OctonionHighPrecisionMember tmp = tmpOct.get();
        this.v(index, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return tmp.r();
                }
                return tmp.i();
            }
            if (component == 2) {
                return tmp.j();
            }
            return tmp.k();
        }
        if (component < 6) {
            if (component == 4) {
                return tmp.l();
            }
            return tmp.i0();
        }
        if (component == 6) {
            return tmp.j0();
        }
        return tmp.k0();
    }

    @Override
    public void primitiveInit() {
        long storageSize = this.storage.size();
        for (long i = 0L; i < storageSize; ++i) {
            this.storage.set(i, ZERO);
        }
    }

    @Override
    public IndexedDataSource<OctonionHighPrecisionMember> rawData() {
        return this.storage;
    }
}

