/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.highprec.octonion;

import java.math.BigDecimal;
import java.math.BigInteger;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.MatrixReshape;
import nom.bdezonia.zorbage.misc.BigList;
import nom.bdezonia.zorbage.sampling.IntegerIndex;
import nom.bdezonia.zorbage.type.algebra.Gettable;
import nom.bdezonia.zorbage.type.algebra.MatrixMember;
import nom.bdezonia.zorbage.type.algebra.Settable;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.data.highprec.octonion.OctonionHighPrecisionMember;
import nom.bdezonia.zorbage.type.data.universal.OctonionRepresentation;
import nom.bdezonia.zorbage.type.data.universal.PrimitiveConversion;
import nom.bdezonia.zorbage.type.data.universal.PrimitiveRepresentation;
import nom.bdezonia.zorbage.type.data.universal.TensorOctonionRepresentation;
import nom.bdezonia.zorbage.type.data.universal.TensorStringRepresentation;
import nom.bdezonia.zorbage.type.data.universal.UniversalRepresentation;
import nom.bdezonia.zorbage.type.storage.Storage;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;
import nom.bdezonia.zorbage.type.storage.datasource.RawData;

public final class OctonionHighPrecisionMatrixMember
implements MatrixMember<OctonionHighPrecisionMember>,
Gettable<OctonionHighPrecisionMatrixMember>,
Settable<OctonionHighPrecisionMatrixMember>,
PrimitiveConversion,
UniversalRepresentation,
RawData<OctonionHighPrecisionMember> {
    private static final OctonionHighPrecisionMember ZERO = new OctonionHighPrecisionMember();
    private IndexedDataSource<OctonionHighPrecisionMember> storage;
    private long rows;
    private long cols;
    private StorageConstruction s;
    private static ThreadLocal<OctonionHighPrecisionMember> tmpOct = new ThreadLocal<OctonionHighPrecisionMember>(){

        @Override
        protected OctonionHighPrecisionMember initialValue() {
            return new OctonionHighPrecisionMember();
        }
    };

    public OctonionHighPrecisionMatrixMember() {
        this.rows = -1L;
        this.cols = -1L;
        this.s = StorageConstruction.MEM_ARRAY;
        this.init(0L, 0L);
    }

    public OctonionHighPrecisionMatrixMember(int r, int c, BigDecimal[] vals) {
        if (vals.length != r * c * 8) {
            throw new IllegalArgumentException("input values do not match declared shape");
        }
        this.rows = -1L;
        this.cols = -1L;
        this.s = StorageConstruction.MEM_ARRAY;
        this.init(r, c);
        OctonionHighPrecisionMember tmp = new OctonionHighPrecisionMember();
        int octCount = vals.length / 8;
        for (int i = 0; i < octCount; ++i) {
            tmp.setR(vals[8 * i]);
            tmp.setI(vals[8 * i + 1]);
            tmp.setJ(vals[8 * i + 2]);
            tmp.setK(vals[8 * i + 3]);
            tmp.setL(vals[8 * i + 4]);
            tmp.setI0(vals[8 * i + 5]);
            tmp.setJ0(vals[8 * i + 6]);
            tmp.setK0(vals[8 * i + 7]);
            this.storage.set(i, tmp);
        }
    }

    public OctonionHighPrecisionMatrixMember(OctonionHighPrecisionMatrixMember other) {
        this.set(other);
    }

    public OctonionHighPrecisionMatrixMember(String s) {
        TensorStringRepresentation rep = new TensorStringRepresentation(s);
        BigList<OctonionRepresentation> data = rep.firstMatrixValues();
        long[] dimensions = rep.dimensions();
        this.rows = -1L;
        this.cols = -1L;
        this.s = StorageConstruction.MEM_ARRAY;
        this.init(dimensions[1], dimensions[0]);
        OctonionHighPrecisionMember tmp = new OctonionHighPrecisionMember();
        long storageSize = this.storage.size();
        for (long i = 0L; i < storageSize; ++i) {
            OctonionRepresentation val = data.get(i);
            tmp.setR(val.r());
            tmp.setI(val.i());
            tmp.setJ(val.j());
            tmp.setK(val.k());
            tmp.setL(val.l());
            tmp.setI0(val.i0());
            tmp.setJ0(val.j0());
            tmp.setK0(val.k0());
            this.storage.set(i, tmp);
        }
    }

    public OctonionHighPrecisionMatrixMember(StorageConstruction s, long d1, long d2) {
        this.rows = -1L;
        this.cols = -1L;
        this.s = s;
        this.init(d2, d1);
    }

    @Override
    public StorageConstruction storageType() {
        return this.s;
    }

    @Override
    public long rows() {
        return this.rows;
    }

    @Override
    public long cols() {
        return this.cols;
    }

    @Override
    public boolean alloc(long r, long c) {
        if (this.rows != r || this.cols != c) {
            this.rows = r;
            this.cols = c;
        }
        if (this.storage == null || this.storage.size() != r * c) {
            this.storage = Storage.allocate(this.s, r * c, new OctonionHighPrecisionMember());
            return true;
        }
        return false;
    }

    @Override
    public void init(long r, long c) {
        if (!this.alloc(r, c)) {
            long storageSize = r * c;
            for (long i = 0L; i < storageSize; ++i) {
                this.storage.set(i, ZERO);
            }
        }
    }

    @Override
    public void v(long r, long c, OctonionHighPrecisionMember value) {
        if (r < 0L || r >= this.rows || c < 0L || c >= this.cols) {
            throw new IllegalArgumentException("matrix oob access");
        }
        long index = r * this.cols + c;
        this.storage.get(index, value);
    }

    @Override
    public void setV(long r, long c, OctonionHighPrecisionMember value) {
        if (r < 0L || r >= this.rows || c < 0L || c >= this.cols) {
            throw new IllegalArgumentException("matrix oob access");
        }
        long index = r * this.cols + c;
        this.storage.set(index, value);
    }

    @Override
    public void set(OctonionHighPrecisionMatrixMember other) {
        if (this == other) {
            return;
        }
        this.rows = other.rows;
        this.cols = other.cols;
        this.s = other.s;
        this.storage = (IndexedDataSource)other.storage.duplicate();
    }

    @Override
    public void get(OctonionHighPrecisionMatrixMember other) {
        if (this == other) {
            return;
        }
        other.rows = this.rows;
        other.cols = this.cols;
        other.s = this.s;
        other.storage = (IndexedDataSource)this.storage.duplicate();
    }

    @Override
    public void toRep(TensorOctonionRepresentation rep) {
        long storageSize = this.storage.size();
        OctonionHighPrecisionMember value = new OctonionHighPrecisionMember();
        BigList<OctonionRepresentation> values = new BigList<OctonionRepresentation>(storageSize);
        for (long i = 0L; i < storageSize; ++i) {
            this.storage.get(i, value);
            BigDecimal re = value.r();
            BigDecimal im = value.i();
            BigDecimal j = value.j();
            BigDecimal k = value.k();
            BigDecimal l = value.l();
            BigDecimal i0 = value.i0();
            BigDecimal j0 = value.j0();
            BigDecimal k0 = value.k0();
            OctonionRepresentation o = new OctonionRepresentation(re, im, j, k, l, i0, j0, k0);
            values.set(i, o);
        }
        rep.setMatrix(this.rows, this.cols, values);
    }

    @Override
    public void fromRep(TensorOctonionRepresentation rep) {
        OctonionHighPrecisionMember value = new OctonionHighPrecisionMember();
        BigList<OctonionRepresentation> mat = rep.getMatrix();
        this.alloc(rep.getMatrixRowDim(), rep.getMatrixColDim());
        long matSize = mat.size();
        for (long i = 0L; i < matSize; ++i) {
            OctonionRepresentation o = mat.get(i);
            value.setR(o.r());
            value.setI(o.i());
            value.setJ(o.j());
            value.setK(o.k());
            value.setL(o.l());
            value.setI0(o.i0());
            value.setJ0(o.j0());
            value.setK0(o.k0());
            this.storage.set(i, value);
        }
    }

    public String toString() {
        OctonionHighPrecisionMember tmp = new OctonionHighPrecisionMember();
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        for (long r = 0L; r < this.rows; ++r) {
            builder.append('[');
            for (long c = 0L; c < this.cols; ++c) {
                if (c != 0L) {
                    builder.append(',');
                }
                this.v(r, c, tmp);
                builder.append(tmp.toString());
            }
            builder.append(']');
        }
        builder.append(']');
        return builder.toString();
    }

    @Override
    public int numDimensions() {
        return 2;
    }

    @Override
    public void reshape(long rows, long cols) {
        MatrixReshape.compute(G.OHP_MAT, G.OHP, rows, cols, this);
    }

    @Override
    public long dimension(int d) {
        if (d < 0) {
            throw new IllegalArgumentException("can't query negative dimension");
        }
        if (d == 0) {
            return this.cols;
        }
        if (d == 1) {
            return this.rows;
        }
        return 1L;
    }

    @Override
    public PrimitiveRepresentation preferredRepresentation() {
        return PrimitiveRepresentation.BIGDECIMAL;
    }

    @Override
    public int componentCount() {
        return 8;
    }

    @Override
    public void primComponentSetByte(IntegerIndex index, int component, byte v) {
        long c = index.get(0);
        long r = index.get(1);
        OctonionHighPrecisionMember tmp = tmpOct.get();
        this.v(r, c, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    tmp.setR(BigDecimal.valueOf(v));
                } else {
                    tmp.setI(BigDecimal.valueOf(v));
                }
            } else if (component == 2) {
                tmp.setJ(BigDecimal.valueOf(v));
            } else {
                tmp.setK(BigDecimal.valueOf(v));
            }
        } else if (component < 6) {
            if (component == 4) {
                tmp.setL(BigDecimal.valueOf(v));
            } else {
                tmp.setI0(BigDecimal.valueOf(v));
            }
        } else if (component == 6) {
            tmp.setJ0(BigDecimal.valueOf(v));
        } else {
            tmp.setK0(BigDecimal.valueOf(v));
        }
        this.setV(r, c, tmp);
    }

    @Override
    public void primComponentSetShort(IntegerIndex index, int component, short v) {
        long c = index.get(0);
        long r = index.get(1);
        OctonionHighPrecisionMember tmp = tmpOct.get();
        this.v(r, c, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    tmp.setR(BigDecimal.valueOf(v));
                } else {
                    tmp.setI(BigDecimal.valueOf(v));
                }
            } else if (component == 2) {
                tmp.setJ(BigDecimal.valueOf(v));
            } else {
                tmp.setK(BigDecimal.valueOf(v));
            }
        } else if (component < 6) {
            if (component == 4) {
                tmp.setL(BigDecimal.valueOf(v));
            } else {
                tmp.setI0(BigDecimal.valueOf(v));
            }
        } else if (component == 6) {
            tmp.setJ0(BigDecimal.valueOf(v));
        } else {
            tmp.setK0(BigDecimal.valueOf(v));
        }
        this.setV(r, c, tmp);
    }

    @Override
    public void primComponentSetInt(IntegerIndex index, int component, int v) {
        long c = index.get(0);
        long r = index.get(1);
        OctonionHighPrecisionMember tmp = tmpOct.get();
        this.v(r, c, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    tmp.setR(BigDecimal.valueOf(v));
                } else {
                    tmp.setI(BigDecimal.valueOf(v));
                }
            } else if (component == 2) {
                tmp.setJ(BigDecimal.valueOf(v));
            } else {
                tmp.setK(BigDecimal.valueOf(v));
            }
        } else if (component < 6) {
            if (component == 4) {
                tmp.setL(BigDecimal.valueOf(v));
            } else {
                tmp.setI0(BigDecimal.valueOf(v));
            }
        } else if (component == 6) {
            tmp.setJ0(BigDecimal.valueOf(v));
        } else {
            tmp.setK0(BigDecimal.valueOf(v));
        }
        this.setV(r, c, tmp);
    }

    @Override
    public void primComponentSetLong(IntegerIndex index, int component, long v) {
        long c = index.get(0);
        long r = index.get(1);
        OctonionHighPrecisionMember tmp = tmpOct.get();
        this.v(r, c, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    tmp.setR(BigDecimal.valueOf(v));
                } else {
                    tmp.setI(BigDecimal.valueOf(v));
                }
            } else if (component == 2) {
                tmp.setJ(BigDecimal.valueOf(v));
            } else {
                tmp.setK(BigDecimal.valueOf(v));
            }
        } else if (component < 6) {
            if (component == 4) {
                tmp.setL(BigDecimal.valueOf(v));
            } else {
                tmp.setI0(BigDecimal.valueOf(v));
            }
        } else if (component == 6) {
            tmp.setJ0(BigDecimal.valueOf(v));
        } else {
            tmp.setK0(BigDecimal.valueOf(v));
        }
        this.setV(r, c, tmp);
    }

    @Override
    public void primComponentSetFloat(IntegerIndex index, int component, float v) {
        long c = index.get(0);
        long r = index.get(1);
        OctonionHighPrecisionMember tmp = tmpOct.get();
        this.v(r, c, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    tmp.setR(BigDecimal.valueOf(v));
                } else {
                    tmp.setI(BigDecimal.valueOf(v));
                }
            } else if (component == 2) {
                tmp.setJ(BigDecimal.valueOf(v));
            } else {
                tmp.setK(BigDecimal.valueOf(v));
            }
        } else if (component < 6) {
            if (component == 4) {
                tmp.setL(BigDecimal.valueOf(v));
            } else {
                tmp.setI0(BigDecimal.valueOf(v));
            }
        } else if (component == 6) {
            tmp.setJ0(BigDecimal.valueOf(v));
        } else {
            tmp.setK0(BigDecimal.valueOf(v));
        }
        this.setV(r, c, tmp);
    }

    @Override
    public void primComponentSetDouble(IntegerIndex index, int component, double v) {
        long c = index.get(0);
        long r = index.get(1);
        OctonionHighPrecisionMember tmp = tmpOct.get();
        this.v(r, c, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    tmp.setR(BigDecimal.valueOf(v));
                } else {
                    tmp.setI(BigDecimal.valueOf(v));
                }
            } else if (component == 2) {
                tmp.setJ(BigDecimal.valueOf(v));
            } else {
                tmp.setK(BigDecimal.valueOf(v));
            }
        } else if (component < 6) {
            if (component == 4) {
                tmp.setL(BigDecimal.valueOf(v));
            } else {
                tmp.setI0(BigDecimal.valueOf(v));
            }
        } else if (component == 6) {
            tmp.setJ0(BigDecimal.valueOf(v));
        } else {
            tmp.setK0(BigDecimal.valueOf(v));
        }
        this.setV(r, c, tmp);
    }

    @Override
    public void primComponentSetBigInteger(IntegerIndex index, int component, BigInteger v) {
        long c = index.get(0);
        long r = index.get(1);
        OctonionHighPrecisionMember tmp = tmpOct.get();
        this.v(r, c, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    tmp.setR(new BigDecimal(v));
                } else {
                    tmp.setI(new BigDecimal(v));
                }
            } else if (component == 2) {
                tmp.setJ(new BigDecimal(v));
            } else {
                tmp.setK(new BigDecimal(v));
            }
        } else if (component < 6) {
            if (component == 4) {
                tmp.setL(new BigDecimal(v));
            } else {
                tmp.setI0(new BigDecimal(v));
            }
        } else if (component == 6) {
            tmp.setJ0(new BigDecimal(v));
        } else {
            tmp.setK0(new BigDecimal(v));
        }
        this.setV(r, c, tmp);
    }

    @Override
    public void primComponentSetBigDecimal(IntegerIndex index, int component, BigDecimal v) {
        long c = index.get(0);
        long r = index.get(1);
        OctonionHighPrecisionMember tmp = tmpOct.get();
        this.v(r, c, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    tmp.setR(v);
                } else {
                    tmp.setI(v);
                }
            } else if (component == 2) {
                tmp.setJ(v);
            } else {
                tmp.setK(v);
            }
        } else if (component < 6) {
            if (component == 4) {
                tmp.setL(v);
            } else {
                tmp.setI0(v);
            }
        } else if (component == 6) {
            tmp.setJ0(v);
        } else {
            tmp.setK0(v);
        }
        this.setV(r, c, tmp);
    }

    @Override
    public void primComponentSetByteSafe(IntegerIndex index, int component, byte v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(0) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            long c = index.get(0);
            long r = index.get(1);
            OctonionHighPrecisionMember tmp = tmpOct.get();
            this.v(r, c, tmp);
            if (component < 4) {
                if (component < 2) {
                    if (component == 0) {
                        tmp.setR(BigDecimal.valueOf(v));
                    } else {
                        tmp.setI(BigDecimal.valueOf(v));
                    }
                } else if (component == 2) {
                    tmp.setJ(BigDecimal.valueOf(v));
                } else {
                    tmp.setK(BigDecimal.valueOf(v));
                }
            } else if (component < 6) {
                if (component == 4) {
                    tmp.setL(BigDecimal.valueOf(v));
                } else {
                    tmp.setI0(BigDecimal.valueOf(v));
                }
            } else if (component == 6) {
                tmp.setJ0(BigDecimal.valueOf(v));
            } else {
                tmp.setK0(BigDecimal.valueOf(v));
            }
            this.setV(r, c, tmp);
        }
    }

    @Override
    public void primComponentSetShortSafe(IntegerIndex index, int component, short v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(0) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            long c = index.get(0);
            long r = index.get(1);
            OctonionHighPrecisionMember tmp = tmpOct.get();
            this.v(r, c, tmp);
            if (component < 4) {
                if (component < 2) {
                    if (component == 0) {
                        tmp.setR(BigDecimal.valueOf(v));
                    } else {
                        tmp.setI(BigDecimal.valueOf(v));
                    }
                } else if (component == 2) {
                    tmp.setJ(BigDecimal.valueOf(v));
                } else {
                    tmp.setK(BigDecimal.valueOf(v));
                }
            } else if (component < 6) {
                if (component == 4) {
                    tmp.setL(BigDecimal.valueOf(v));
                } else {
                    tmp.setI0(BigDecimal.valueOf(v));
                }
            } else if (component == 6) {
                tmp.setJ0(BigDecimal.valueOf(v));
            } else {
                tmp.setK0(BigDecimal.valueOf(v));
            }
            this.setV(r, c, tmp);
        }
    }

    @Override
    public void primComponentSetIntSafe(IntegerIndex index, int component, int v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(0) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            long c = index.get(0);
            long r = index.get(1);
            OctonionHighPrecisionMember tmp = tmpOct.get();
            this.v(r, c, tmp);
            if (component < 4) {
                if (component < 2) {
                    if (component == 0) {
                        tmp.setR(BigDecimal.valueOf(v));
                    } else {
                        tmp.setI(BigDecimal.valueOf(v));
                    }
                } else if (component == 2) {
                    tmp.setJ(BigDecimal.valueOf(v));
                } else {
                    tmp.setK(BigDecimal.valueOf(v));
                }
            } else if (component < 6) {
                if (component == 4) {
                    tmp.setL(BigDecimal.valueOf(v));
                } else {
                    tmp.setI0(BigDecimal.valueOf(v));
                }
            } else if (component == 6) {
                tmp.setJ0(BigDecimal.valueOf(v));
            } else {
                tmp.setK0(BigDecimal.valueOf(v));
            }
            this.setV(r, c, tmp);
        }
    }

    @Override
    public void primComponentSetLongSafe(IntegerIndex index, int component, long v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0L) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            long c = index.get(0);
            long r = index.get(1);
            OctonionHighPrecisionMember tmp = tmpOct.get();
            this.v(r, c, tmp);
            if (component < 4) {
                if (component < 2) {
                    if (component == 0) {
                        tmp.setR(BigDecimal.valueOf(v));
                    } else {
                        tmp.setI(BigDecimal.valueOf(v));
                    }
                } else if (component == 2) {
                    tmp.setJ(BigDecimal.valueOf(v));
                } else {
                    tmp.setK(BigDecimal.valueOf(v));
                }
            } else if (component < 6) {
                if (component == 4) {
                    tmp.setL(BigDecimal.valueOf(v));
                } else {
                    tmp.setI0(BigDecimal.valueOf(v));
                }
            } else if (component == 6) {
                tmp.setJ0(BigDecimal.valueOf(v));
            } else {
                tmp.setK0(BigDecimal.valueOf(v));
            }
            this.setV(r, c, tmp);
        }
    }

    @Override
    public void primComponentSetFloatSafe(IntegerIndex index, int component, float v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(0) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0.0f) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            long c = index.get(0);
            long r = index.get(1);
            OctonionHighPrecisionMember tmp = tmpOct.get();
            this.v(r, c, tmp);
            if (component < 4) {
                if (component < 2) {
                    if (component == 0) {
                        tmp.setR(BigDecimal.valueOf(v));
                    } else {
                        tmp.setI(BigDecimal.valueOf(v));
                    }
                } else if (component == 2) {
                    tmp.setJ(BigDecimal.valueOf(v));
                } else {
                    tmp.setK(BigDecimal.valueOf(v));
                }
            } else if (component < 6) {
                if (component == 4) {
                    tmp.setL(BigDecimal.valueOf(v));
                } else {
                    tmp.setI0(BigDecimal.valueOf(v));
                }
            } else if (component == 6) {
                tmp.setJ0(BigDecimal.valueOf(v));
            } else {
                tmp.setK0(BigDecimal.valueOf(v));
            }
            this.setV(r, c, tmp);
        }
    }

    @Override
    public void primComponentSetDoubleSafe(IntegerIndex index, int component, double v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(0) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0.0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            long c = index.get(0);
            long r = index.get(1);
            OctonionHighPrecisionMember tmp = tmpOct.get();
            this.v(r, c, tmp);
            if (component < 4) {
                if (component < 2) {
                    if (component == 0) {
                        tmp.setR(BigDecimal.valueOf(v));
                    } else {
                        tmp.setI(BigDecimal.valueOf(v));
                    }
                } else if (component == 2) {
                    tmp.setJ(BigDecimal.valueOf(v));
                } else {
                    tmp.setK(BigDecimal.valueOf(v));
                }
            } else if (component < 6) {
                if (component == 4) {
                    tmp.setL(BigDecimal.valueOf(v));
                } else {
                    tmp.setI0(BigDecimal.valueOf(v));
                }
            } else if (component == 6) {
                tmp.setJ0(BigDecimal.valueOf(v));
            } else {
                tmp.setK0(BigDecimal.valueOf(v));
            }
            this.setV(r, c, tmp);
        }
    }

    @Override
    public void primComponentSetBigIntegerSafe(IntegerIndex index, int component, BigInteger v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(0) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v.signum() != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            long c = index.get(0);
            long r = index.get(1);
            OctonionHighPrecisionMember tmp = tmpOct.get();
            this.v(r, c, tmp);
            if (component < 4) {
                if (component < 2) {
                    if (component == 0) {
                        tmp.setR(new BigDecimal(v));
                    } else {
                        tmp.setI(new BigDecimal(v));
                    }
                } else if (component == 2) {
                    tmp.setJ(new BigDecimal(v));
                } else {
                    tmp.setK(new BigDecimal(v));
                }
            } else if (component < 6) {
                if (component == 4) {
                    tmp.setL(new BigDecimal(v));
                } else {
                    tmp.setI0(new BigDecimal(v));
                }
            } else if (component == 6) {
                tmp.setJ0(new BigDecimal(v));
            } else {
                tmp.setK0(new BigDecimal(v));
            }
            this.setV(r, c, tmp);
        }
    }

    @Override
    public void primComponentSetBigDecimalSafe(IntegerIndex index, int component, BigDecimal v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(0) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v.signum() != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            long c = index.get(0);
            long r = index.get(1);
            OctonionHighPrecisionMember tmp = tmpOct.get();
            this.v(r, c, tmp);
            if (component < 4) {
                if (component < 2) {
                    if (component == 0) {
                        tmp.setR(v);
                    } else {
                        tmp.setI(v);
                    }
                } else if (component == 2) {
                    tmp.setJ(v);
                } else {
                    tmp.setK(v);
                }
            } else if (component < 6) {
                if (component == 4) {
                    tmp.setL(v);
                } else {
                    tmp.setI0(v);
                }
            } else if (component == 6) {
                tmp.setJ0(v);
            } else {
                tmp.setK0(v);
            }
            this.setV(r, c, tmp);
        }
    }

    @Override
    public byte primComponentGetAsByte(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component > 7) {
            return 0;
        }
        OctonionHighPrecisionMember tmp = tmpOct.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return tmp.r().byteValue();
                }
                return tmp.i().byteValue();
            }
            if (component == 2) {
                return tmp.j().byteValue();
            }
            return tmp.k().byteValue();
        }
        if (component < 6) {
            if (component == 4) {
                return tmp.l().byteValue();
            }
            return tmp.i0().byteValue();
        }
        if (component == 6) {
            return tmp.j0().byteValue();
        }
        return tmp.k0().byteValue();
    }

    @Override
    public short primComponentGetAsShort(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component > 7) {
            return 0;
        }
        OctonionHighPrecisionMember tmp = tmpOct.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return tmp.r().shortValue();
                }
                return tmp.i().shortValue();
            }
            if (component == 2) {
                return tmp.j().shortValue();
            }
            return tmp.k().shortValue();
        }
        if (component < 6) {
            if (component == 4) {
                return tmp.l().shortValue();
            }
            return tmp.i0().shortValue();
        }
        if (component == 6) {
            return tmp.j0().shortValue();
        }
        return tmp.k0().shortValue();
    }

    @Override
    public int primComponentGetAsInt(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component > 7) {
            return 0;
        }
        OctonionHighPrecisionMember tmp = tmpOct.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return tmp.r().intValue();
                }
                return tmp.i().intValue();
            }
            if (component == 2) {
                return tmp.j().intValue();
            }
            return tmp.k().intValue();
        }
        if (component < 6) {
            if (component == 4) {
                return tmp.l().intValue();
            }
            return tmp.i0().intValue();
        }
        if (component == 6) {
            return tmp.j0().intValue();
        }
        return tmp.k0().intValue();
    }

    @Override
    public long primComponentGetAsLong(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component > 7) {
            return 0L;
        }
        OctonionHighPrecisionMember tmp = tmpOct.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return tmp.r().longValue();
                }
                return tmp.i().longValue();
            }
            if (component == 2) {
                return tmp.j().longValue();
            }
            return tmp.k().longValue();
        }
        if (component < 6) {
            if (component == 4) {
                return tmp.l().longValue();
            }
            return tmp.i0().longValue();
        }
        if (component == 6) {
            return tmp.j0().longValue();
        }
        return tmp.k0().longValue();
    }

    @Override
    public float primComponentGetAsFloat(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component > 7) {
            return 0.0f;
        }
        OctonionHighPrecisionMember tmp = tmpOct.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return tmp.r().floatValue();
                }
                return tmp.i().floatValue();
            }
            if (component == 2) {
                return tmp.j().floatValue();
            }
            return tmp.k().floatValue();
        }
        if (component < 6) {
            if (component == 4) {
                return tmp.l().floatValue();
            }
            return tmp.i0().floatValue();
        }
        if (component == 6) {
            return tmp.j0().floatValue();
        }
        return tmp.k0().floatValue();
    }

    @Override
    public double primComponentGetAsDouble(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component > 7) {
            return 0.0;
        }
        OctonionHighPrecisionMember tmp = tmpOct.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return tmp.r().doubleValue();
                }
                return tmp.i().doubleValue();
            }
            if (component == 2) {
                return tmp.j().doubleValue();
            }
            return tmp.k().doubleValue();
        }
        if (component < 6) {
            if (component == 4) {
                return tmp.l().doubleValue();
            }
            return tmp.i0().doubleValue();
        }
        if (component == 6) {
            return tmp.j0().doubleValue();
        }
        return tmp.k0().doubleValue();
    }

    @Override
    public BigInteger primComponentGetAsBigInteger(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component > 7) {
            return BigInteger.ZERO;
        }
        OctonionHighPrecisionMember tmp = tmpOct.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return tmp.r().toBigInteger();
                }
                return tmp.i().toBigInteger();
            }
            if (component == 2) {
                return tmp.j().toBigInteger();
            }
            return tmp.k().toBigInteger();
        }
        if (component < 6) {
            if (component == 4) {
                return tmp.l().toBigInteger();
            }
            return tmp.i0().toBigInteger();
        }
        if (component == 6) {
            return tmp.j0().toBigInteger();
        }
        return tmp.k0().toBigInteger();
    }

    @Override
    public BigDecimal primComponentGetAsBigDecimal(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component > 7) {
            return BigDecimal.ZERO;
        }
        OctonionHighPrecisionMember tmp = tmpOct.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return tmp.r();
                }
                return tmp.i();
            }
            if (component == 2) {
                return tmp.j();
            }
            return tmp.k();
        }
        if (component < 6) {
            if (component == 4) {
                return tmp.l();
            }
            return tmp.i0();
        }
        if (component == 6) {
            return tmp.j0();
        }
        return tmp.k0();
    }

    @Override
    public byte primComponentGetAsByteSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0;
        }
        OctonionHighPrecisionMember tmp = tmpOct.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return tmp.r().byteValue();
                }
                return tmp.i().byteValue();
            }
            if (component == 2) {
                return tmp.j().byteValue();
            }
            return tmp.k().byteValue();
        }
        if (component < 6) {
            if (component == 4) {
                return tmp.l().byteValue();
            }
            return tmp.i0().byteValue();
        }
        if (component == 6) {
            return tmp.j0().byteValue();
        }
        return tmp.k0().byteValue();
    }

    @Override
    public short primComponentGetAsShortSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0;
        }
        OctonionHighPrecisionMember tmp = tmpOct.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return tmp.r().shortValue();
                }
                return tmp.i().shortValue();
            }
            if (component == 2) {
                return tmp.j().shortValue();
            }
            return tmp.k().shortValue();
        }
        if (component < 6) {
            if (component == 4) {
                return tmp.l().shortValue();
            }
            return tmp.i0().shortValue();
        }
        if (component == 6) {
            return tmp.j0().shortValue();
        }
        return tmp.k0().shortValue();
    }

    @Override
    public int primComponentGetAsIntSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0;
        }
        OctonionHighPrecisionMember tmp = tmpOct.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return tmp.r().intValue();
                }
                return tmp.i().intValue();
            }
            if (component == 2) {
                return tmp.j().intValue();
            }
            return tmp.k().intValue();
        }
        if (component < 6) {
            if (component == 4) {
                return tmp.l().intValue();
            }
            return tmp.i0().intValue();
        }
        if (component == 6) {
            return tmp.j0().intValue();
        }
        return tmp.k0().intValue();
    }

    @Override
    public long primComponentGetAsLongSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0L;
        }
        OctonionHighPrecisionMember tmp = tmpOct.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return tmp.r().longValue();
                }
                return tmp.i().longValue();
            }
            if (component == 2) {
                return tmp.j().longValue();
            }
            return tmp.k().longValue();
        }
        if (component < 6) {
            if (component == 4) {
                return tmp.l().longValue();
            }
            return tmp.i0().longValue();
        }
        if (component == 6) {
            return tmp.j0().longValue();
        }
        return tmp.k0().longValue();
    }

    @Override
    public float primComponentGetAsFloatSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0.0f;
        }
        OctonionHighPrecisionMember tmp = tmpOct.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return tmp.r().floatValue();
                }
                return tmp.i().floatValue();
            }
            if (component == 2) {
                return tmp.j().floatValue();
            }
            return tmp.k().floatValue();
        }
        if (component < 6) {
            if (component == 4) {
                return tmp.l().floatValue();
            }
            return tmp.i0().floatValue();
        }
        if (component == 6) {
            return tmp.j0().floatValue();
        }
        return tmp.k0().floatValue();
    }

    @Override
    public double primComponentGetAsDoubleSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0.0;
        }
        OctonionHighPrecisionMember tmp = tmpOct.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return tmp.r().doubleValue();
                }
                return tmp.i().doubleValue();
            }
            if (component == 2) {
                return tmp.j().doubleValue();
            }
            return tmp.k().doubleValue();
        }
        if (component < 6) {
            if (component == 4) {
                return tmp.l().doubleValue();
            }
            return tmp.i0().doubleValue();
        }
        if (component == 6) {
            return tmp.j0().doubleValue();
        }
        return tmp.k0().doubleValue();
    }

    @Override
    public BigInteger primComponentGetAsBigIntegerSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return BigInteger.ZERO;
        }
        OctonionHighPrecisionMember tmp = tmpOct.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return tmp.r().toBigInteger();
                }
                return tmp.i().toBigInteger();
            }
            if (component == 2) {
                return tmp.j().toBigInteger();
            }
            return tmp.k().toBigInteger();
        }
        if (component < 6) {
            if (component == 4) {
                return tmp.l().toBigInteger();
            }
            return tmp.i0().toBigInteger();
        }
        if (component == 6) {
            return tmp.j0().toBigInteger();
        }
        return tmp.k0().toBigInteger();
    }

    @Override
    public BigDecimal primComponentGetAsBigDecimalSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return BigDecimal.ZERO;
        }
        OctonionHighPrecisionMember tmp = tmpOct.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return tmp.r();
                }
                return tmp.i();
            }
            if (component == 2) {
                return tmp.j();
            }
            return tmp.k();
        }
        if (component < 6) {
            if (component == 4) {
                return tmp.l();
            }
            return tmp.i0();
        }
        if (component == 6) {
            return tmp.j0();
        }
        return tmp.k0();
    }

    @Override
    public void primitiveInit() {
        long storageSize = this.storage.size();
        for (long i = 0L; i < storageSize; ++i) {
            this.storage.set(i, ZERO);
        }
    }

    @Override
    public IndexedDataSource<OctonionHighPrecisionMember> rawData() {
        return this.storage;
    }
}

