/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.highprec.quaternion;

import ch.obermuhlner.math.big.BigDecimalMath;
import java.math.BigDecimal;
import java.math.MathContext;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.PowerAny;
import nom.bdezonia.zorbage.algorithm.QuaternionNumberWithin;
import nom.bdezonia.zorbage.algorithm.Sinc;
import nom.bdezonia.zorbage.algorithm.Sinch;
import nom.bdezonia.zorbage.algorithm.Sinchpi;
import nom.bdezonia.zorbage.algorithm.Sincpi;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.type.algebra.Conjugate;
import nom.bdezonia.zorbage.type.algebra.Exponential;
import nom.bdezonia.zorbage.type.algebra.Hyperbolic;
import nom.bdezonia.zorbage.type.algebra.ImaginaryConstants;
import nom.bdezonia.zorbage.type.algebra.Norm;
import nom.bdezonia.zorbage.type.algebra.Power;
import nom.bdezonia.zorbage.type.algebra.QuaternionConstants;
import nom.bdezonia.zorbage.type.algebra.RealConstants;
import nom.bdezonia.zorbage.type.algebra.RealUnreal;
import nom.bdezonia.zorbage.type.algebra.Roots;
import nom.bdezonia.zorbage.type.algebra.Scale;
import nom.bdezonia.zorbage.type.algebra.ScaleByDouble;
import nom.bdezonia.zorbage.type.algebra.ScaleByHighPrec;
import nom.bdezonia.zorbage.type.algebra.ScaleByRational;
import nom.bdezonia.zorbage.type.algebra.ScaleComponents;
import nom.bdezonia.zorbage.type.algebra.SkewField;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.algebra.Trigonometric;
import nom.bdezonia.zorbage.type.data.highprec.quaternion.QuaternionHighPrecisionMember;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionAlgebra;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class QuaternionHighPrecisionAlgebra
implements SkewField<QuaternionHighPrecisionAlgebra, QuaternionHighPrecisionMember>,
RealConstants<QuaternionHighPrecisionMember>,
ImaginaryConstants<QuaternionHighPrecisionMember>,
QuaternionConstants<QuaternionHighPrecisionMember>,
Norm<QuaternionHighPrecisionMember, HighPrecisionMember>,
Conjugate<QuaternionHighPrecisionMember>,
Exponential<QuaternionHighPrecisionMember>,
Trigonometric<QuaternionHighPrecisionMember>,
Hyperbolic<QuaternionHighPrecisionMember>,
Power<QuaternionHighPrecisionMember>,
Roots<QuaternionHighPrecisionMember>,
RealUnreal<QuaternionHighPrecisionMember, HighPrecisionMember>,
Scale<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember>,
ScaleByHighPrec<QuaternionHighPrecisionMember>,
ScaleByRational<QuaternionHighPrecisionMember>,
ScaleByDouble<QuaternionHighPrecisionMember>,
ScaleComponents<QuaternionHighPrecisionMember, HighPrecisionMember>,
Tolerance<HighPrecisionMember, QuaternionHighPrecisionMember> {
    private static final QuaternionHighPrecisionMember ZERO = new QuaternionHighPrecisionMember();
    private static final QuaternionHighPrecisionMember ONE = new QuaternionHighPrecisionMember(BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
    private static final QuaternionHighPrecisionMember TWO = new QuaternionHighPrecisionMember(BigDecimal.valueOf(2L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
    private static final QuaternionHighPrecisionMember THREE = new QuaternionHighPrecisionMember(BigDecimal.valueOf(3L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
    private static final QuaternionHighPrecisionMember I = new QuaternionHighPrecisionMember(BigDecimal.ZERO, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO);
    private static final QuaternionHighPrecisionMember J = new QuaternionHighPrecisionMember(BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ONE, BigDecimal.ZERO);
    private static final QuaternionHighPrecisionMember K = new QuaternionHighPrecisionMember(BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ONE);
    private final Procedure1<QuaternionHighPrecisionMember> UNITY = new Procedure1<QuaternionHighPrecisionMember>(){

        @Override
        public void call(QuaternionHighPrecisionMember a) {
            QuaternionHighPrecisionAlgebra.this.assign().call(ONE, a);
        }
    };
    private final Procedure3<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> MUL = new Procedure3<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember, QuaternionHighPrecisionMember>(){

        @Override
        public void call(QuaternionHighPrecisionMember a, QuaternionHighPrecisionMember b, QuaternionHighPrecisionMember c) {
            BigDecimal r = a.r().multiply(b.r());
            r = r.subtract(a.i().multiply(b.i()));
            r = r.subtract(a.j().multiply(b.j()));
            r = r.subtract(a.k().multiply(b.k()));
            BigDecimal i = a.r().multiply(b.i());
            i = i.add(a.i().multiply(b.r()));
            i = i.add(a.j().multiply(b.k()));
            i = i.subtract(a.k().multiply(b.j()));
            BigDecimal j = a.r().multiply(b.j());
            j = j.subtract(a.i().multiply(b.k()));
            j = j.add(a.j().multiply(b.r()));
            j = j.add(a.k().multiply(b.i()));
            BigDecimal k = a.r().multiply(b.k());
            k = k.add(a.i().multiply(b.j()));
            k = k.subtract(a.j().multiply(b.i()));
            k = k.add(a.k().multiply(b.r()));
            c.setR(r);
            c.setI(i);
            c.setJ(j);
            c.setK(k);
        }
    };
    private final Procedure3<Integer, QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> POWER = new Procedure3<Integer, QuaternionHighPrecisionMember, QuaternionHighPrecisionMember>(){

        @Override
        public void call(Integer power, QuaternionHighPrecisionMember a, QuaternionHighPrecisionMember b) {
            PowerAny.compute(G.QHP, power, a, b);
        }
    };
    private final Procedure1<QuaternionHighPrecisionMember> ZER = new Procedure1<QuaternionHighPrecisionMember>(){

        @Override
        public void call(QuaternionHighPrecisionMember a) {
            a.primitiveInit();
        }
    };
    private final Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> NEG = new Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember>(){

        @Override
        public void call(QuaternionHighPrecisionMember a, QuaternionHighPrecisionMember b) {
            QuaternionHighPrecisionAlgebra.this.subtract().call(ZERO, a, b);
        }
    };
    private final Procedure3<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> ADD = new Procedure3<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember, QuaternionHighPrecisionMember>(){

        @Override
        public void call(QuaternionHighPrecisionMember a, QuaternionHighPrecisionMember b, QuaternionHighPrecisionMember c) {
            c.setR(a.r().add(b.r()));
            c.setI(a.i().add(b.i()));
            c.setJ(a.j().add(b.j()));
            c.setK(a.k().add(b.k()));
        }
    };
    private final Procedure3<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> SUB = new Procedure3<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember, QuaternionHighPrecisionMember>(){

        @Override
        public void call(QuaternionHighPrecisionMember a, QuaternionHighPrecisionMember b, QuaternionHighPrecisionMember c) {
            c.setR(a.r().subtract(b.r()));
            c.setI(a.i().subtract(b.i()));
            c.setJ(a.j().subtract(b.j()));
            c.setK(a.k().subtract(b.k()));
        }
    };
    private final Function2<Boolean, QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> EQ = new Function2<Boolean, QuaternionHighPrecisionMember, QuaternionHighPrecisionMember>(){

        @Override
        public Boolean call(QuaternionHighPrecisionMember a, QuaternionHighPrecisionMember b) {
            return a.r() == b.r() && a.i() == b.i() && a.j() == b.j() && a.k() == b.k();
        }
    };
    private final Function2<Boolean, QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> NEQ = new Function2<Boolean, QuaternionHighPrecisionMember, QuaternionHighPrecisionMember>(){

        @Override
        public Boolean call(QuaternionHighPrecisionMember a, QuaternionHighPrecisionMember b) {
            return QuaternionHighPrecisionAlgebra.this.isEqual().call(a, b) == false;
        }
    };
    private final Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> ASSIGN = new Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember>(){

        @Override
        public void call(QuaternionHighPrecisionMember from, QuaternionHighPrecisionMember to) {
            to.set(from);
        }
    };
    private final Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> INV = new Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember>(){

        @Override
        public void call(QuaternionHighPrecisionMember a, QuaternionHighPrecisionMember b) {
            QuaternionHighPrecisionMember c = new QuaternionHighPrecisionMember();
            QuaternionHighPrecisionMember scale = new QuaternionHighPrecisionMember();
            HighPrecisionMember nval = new HighPrecisionMember();
            QuaternionHighPrecisionAlgebra.this.norm().call(a, nval);
            scale.setR(BigDecimal.ONE.divide(nval.v().multiply(nval.v()), HighPrecisionAlgebra.getContext()));
            QuaternionHighPrecisionAlgebra.this.conjugate().call(a, c);
            QuaternionHighPrecisionAlgebra.this.multiply().call(scale, c, b);
        }
    };
    private final Procedure3<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> DIVIDE = new Procedure3<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember, QuaternionHighPrecisionMember>(){

        @Override
        public void call(QuaternionHighPrecisionMember a, QuaternionHighPrecisionMember b, QuaternionHighPrecisionMember c) {
            QuaternionHighPrecisionMember tmp = new QuaternionHighPrecisionMember();
            QuaternionHighPrecisionAlgebra.this.invert().call(b, tmp);
            QuaternionHighPrecisionAlgebra.this.multiply().call(a, tmp, c);
        }
    };
    private final Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> CONJ = new Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember>(){

        @Override
        public void call(QuaternionHighPrecisionMember a, QuaternionHighPrecisionMember b) {
            b.setR(a.r());
            b.setI(a.i().negate());
            b.setJ(a.j().negate());
            b.setK(a.k().negate());
        }
    };
    private final Procedure2<QuaternionHighPrecisionMember, HighPrecisionMember> NORM = new Procedure2<QuaternionHighPrecisionMember, HighPrecisionMember>(){

        @Override
        public void call(QuaternionHighPrecisionMember a, HighPrecisionMember b) {
            BigDecimal sum = a.r().multiply(a.r());
            sum = sum.add(a.i().multiply(a.i()));
            sum = sum.add(a.j().multiply(a.j()));
            sum = sum.add(a.k().multiply(a.k()));
            b.setV(BigDecimalMath.sqrt((BigDecimal)sum, (MathContext)HighPrecisionAlgebra.getContext()));
        }
    };
    private final Procedure1<QuaternionHighPrecisionMember> PI_ = new Procedure1<QuaternionHighPrecisionMember>(){

        @Override
        public void call(QuaternionHighPrecisionMember a) {
            HighPrecisionMember pi = G.HP.construct();
            G.HP.PI().call(pi);
            a.setR(pi.v());
            a.setI(BigDecimal.ZERO);
            a.setJ(BigDecimal.ZERO);
            a.setK(BigDecimal.ZERO);
        }
    };
    private final Procedure1<QuaternionHighPrecisionMember> E_ = new Procedure1<QuaternionHighPrecisionMember>(){

        @Override
        public void call(QuaternionHighPrecisionMember a) {
            HighPrecisionMember e = G.HP.construct();
            G.HP.E().call(e);
            a.setR(e.v());
            a.setI(BigDecimal.ZERO);
            a.setJ(BigDecimal.ZERO);
            a.setK(BigDecimal.ZERO);
        }
    };
    private final Procedure1<QuaternionHighPrecisionMember> GAMMA_ = new Procedure1<QuaternionHighPrecisionMember>(){

        @Override
        public void call(QuaternionHighPrecisionMember a) {
            HighPrecisionMember gamma = G.HP.construct();
            G.HP.GAMMA().call(gamma);
            a.setR(gamma.v());
            a.setI(BigDecimal.ZERO);
            a.setJ(BigDecimal.ZERO);
            a.setK(BigDecimal.ZERO);
        }
    };
    private final Procedure1<QuaternionHighPrecisionMember> PHI_ = new Procedure1<QuaternionHighPrecisionMember>(){

        @Override
        public void call(QuaternionHighPrecisionMember a) {
            HighPrecisionMember phi = G.HP.construct();
            G.HP.PHI().call(phi);
            a.setR(phi.v());
            a.setI(BigDecimal.ZERO);
            a.setJ(BigDecimal.ZERO);
            a.setK(BigDecimal.ZERO);
        }
    };
    private final Procedure1<QuaternionHighPrecisionMember> I_ = new Procedure1<QuaternionHighPrecisionMember>(){

        @Override
        public void call(QuaternionHighPrecisionMember a) {
            QuaternionHighPrecisionAlgebra.this.assign().call(I, a);
        }
    };
    private final Procedure1<QuaternionHighPrecisionMember> J_ = new Procedure1<QuaternionHighPrecisionMember>(){

        @Override
        public void call(QuaternionHighPrecisionMember a) {
            QuaternionHighPrecisionAlgebra.this.assign().call(J, a);
        }
    };
    private final Procedure1<QuaternionHighPrecisionMember> K_ = new Procedure1<QuaternionHighPrecisionMember>(){

        @Override
        public void call(QuaternionHighPrecisionMember a) {
            QuaternionHighPrecisionAlgebra.this.assign().call(K, a);
        }
    };
    private final Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> EXP = new Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember>(){

        @Override
        public void call(QuaternionHighPrecisionMember a, QuaternionHighPrecisionMember b) {
            HighPrecisionMember z = new HighPrecisionMember();
            HighPrecisionMember z2 = new HighPrecisionMember();
            QuaternionHighPrecisionMember tmp = new QuaternionHighPrecisionMember();
            BigDecimal u = BigDecimalMath.exp((BigDecimal)a.r(), (MathContext)HighPrecisionAlgebra.getContext());
            QuaternionHighPrecisionAlgebra.this.unreal().call(a, tmp);
            QuaternionHighPrecisionAlgebra.this.norm().call(tmp, z);
            G.HP.sinc().call(z, z2);
            BigDecimal w = z2.v();
            BigDecimal t = u.multiply(w);
            b.setR(u.multiply(BigDecimalMath.cos((BigDecimal)z.v(), (MathContext)HighPrecisionAlgebra.getContext())));
            b.setI(t.multiply(a.i()));
            b.setJ(t.multiply(a.j()));
            b.setK(t.multiply(a.k()));
        }
    };
    private final Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> LOG = new Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember>(){

        @Override
        public void call(QuaternionHighPrecisionMember a, QuaternionHighPrecisionMember b) {
            HighPrecisionMember norm = new HighPrecisionMember();
            HighPrecisionMember term = new HighPrecisionMember();
            HighPrecisionMember v1 = new HighPrecisionMember();
            HighPrecisionMember v2 = new HighPrecisionMember();
            HighPrecisionMember v3 = new HighPrecisionMember();
            QuaternionHighPrecisionAlgebra.this.norm().call(a, norm);
            HighPrecisionMember multiplier = new HighPrecisionMember(a.r().divide(norm.v(), HighPrecisionAlgebra.getContext()));
            v1.setV(a.i().multiply(multiplier.v()));
            v2.setV(a.j().multiply(multiplier.v()));
            v3.setV(a.k().multiply(multiplier.v()));
            G.HP.acos().call(multiplier, term);
            b.setR(BigDecimalMath.log((BigDecimal)norm.v(), (MathContext)HighPrecisionAlgebra.getContext()));
            b.setI(v1.v().multiply(term.v()));
            b.setJ(v2.v().multiply(term.v()));
            b.setK(v3.v().multiply(term.v()));
        }
    };
    private final Procedure2<QuaternionHighPrecisionMember, HighPrecisionMember> REAL = new Procedure2<QuaternionHighPrecisionMember, HighPrecisionMember>(){

        @Override
        public void call(QuaternionHighPrecisionMember a, HighPrecisionMember b) {
            b.setV(a.r());
        }
    };
    private final Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> UNREAL = new Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember>(){

        @Override
        public void call(QuaternionHighPrecisionMember a, QuaternionHighPrecisionMember b) {
            QuaternionHighPrecisionAlgebra.this.assign().call(a, b);
            b.setR(BigDecimal.ZERO);
        }
    };
    private final Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> SINH = new Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember>(){

        @Override
        public void call(QuaternionHighPrecisionMember a, QuaternionHighPrecisionMember b) {
            QuaternionHighPrecisionMember negA = new QuaternionHighPrecisionMember();
            QuaternionHighPrecisionMember sum = new QuaternionHighPrecisionMember();
            QuaternionHighPrecisionMember tmp1 = new QuaternionHighPrecisionMember();
            QuaternionHighPrecisionMember tmp2 = new QuaternionHighPrecisionMember();
            QuaternionHighPrecisionAlgebra.this.negate().call(a, negA);
            QuaternionHighPrecisionAlgebra.this.exp().call(a, tmp1);
            QuaternionHighPrecisionAlgebra.this.exp().call(negA, tmp2);
            QuaternionHighPrecisionAlgebra.this.subtract().call(tmp1, tmp2, sum);
            QuaternionHighPrecisionAlgebra.this.divide().call(sum, TWO, b);
        }
    };
    private final Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> COSH = new Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember>(){

        @Override
        public void call(QuaternionHighPrecisionMember a, QuaternionHighPrecisionMember b) {
            QuaternionHighPrecisionMember negA = new QuaternionHighPrecisionMember();
            QuaternionHighPrecisionMember sum = new QuaternionHighPrecisionMember();
            QuaternionHighPrecisionMember tmp1 = new QuaternionHighPrecisionMember();
            QuaternionHighPrecisionMember tmp2 = new QuaternionHighPrecisionMember();
            QuaternionHighPrecisionAlgebra.this.negate().call(a, negA);
            QuaternionHighPrecisionAlgebra.this.exp().call(a, tmp1);
            QuaternionHighPrecisionAlgebra.this.exp().call(negA, tmp2);
            QuaternionHighPrecisionAlgebra.this.add().call(tmp1, tmp2, sum);
            QuaternionHighPrecisionAlgebra.this.divide().call(sum, TWO, b);
        }
    };
    private final Procedure3<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> SINHANDCOSH = new Procedure3<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember, QuaternionHighPrecisionMember>(){

        @Override
        public void call(QuaternionHighPrecisionMember a, QuaternionHighPrecisionMember s, QuaternionHighPrecisionMember c) {
            QuaternionHighPrecisionMember negA = new QuaternionHighPrecisionMember();
            QuaternionHighPrecisionMember sum = new QuaternionHighPrecisionMember();
            QuaternionHighPrecisionMember tmp1 = new QuaternionHighPrecisionMember();
            QuaternionHighPrecisionMember tmp2 = new QuaternionHighPrecisionMember();
            QuaternionHighPrecisionAlgebra.this.negate().call(a, negA);
            QuaternionHighPrecisionAlgebra.this.exp().call(a, tmp1);
            QuaternionHighPrecisionAlgebra.this.exp().call(negA, tmp2);
            QuaternionHighPrecisionAlgebra.this.subtract().call(tmp1, tmp2, sum);
            QuaternionHighPrecisionAlgebra.this.divide().call(sum, TWO, s);
            QuaternionHighPrecisionAlgebra.this.add().call(tmp1, tmp2, sum);
            QuaternionHighPrecisionAlgebra.this.divide().call(sum, TWO, c);
        }
    };
    private final Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> TANH = new Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember>(){

        @Override
        public void call(QuaternionHighPrecisionMember a, QuaternionHighPrecisionMember b) {
            QuaternionHighPrecisionMember s = new QuaternionHighPrecisionMember();
            QuaternionHighPrecisionMember c = new QuaternionHighPrecisionMember();
            QuaternionHighPrecisionAlgebra.this.sinhAndCosh().call(a, s, c);
            QuaternionHighPrecisionAlgebra.this.divide().call(s, c, b);
        }
    };
    private final Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> SIN = new Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember>(){

        @Override
        public void call(QuaternionHighPrecisionMember a, QuaternionHighPrecisionMember b) {
            HighPrecisionMember z = new HighPrecisionMember();
            HighPrecisionMember z2 = new HighPrecisionMember();
            QuaternionHighPrecisionMember tmp = new QuaternionHighPrecisionMember();
            QuaternionHighPrecisionAlgebra.this.unreal().call(a, tmp);
            QuaternionHighPrecisionAlgebra.this.norm().call(tmp, z);
            G.HP.sinch().call(z, z2);
            BigDecimal cos = BigDecimalMath.cos((BigDecimal)a.r(), (MathContext)HighPrecisionAlgebra.getContext());
            BigDecimal sin = BigDecimalMath.sin((BigDecimal)a.r(), (MathContext)HighPrecisionAlgebra.getContext());
            BigDecimal sinhc_pi = z2.v();
            BigDecimal cosh = BigDecimalMath.cosh((BigDecimal)z.v(), (MathContext)HighPrecisionAlgebra.getContext());
            BigDecimal ws = cos.multiply(sinhc_pi);
            b.setR(sin.multiply(cosh));
            b.setI(ws.multiply(a.i()));
            b.setJ(ws.multiply(a.j()));
            b.setK(ws.multiply(a.k()));
        }
    };
    private final Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> COS = new Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember>(){

        @Override
        public void call(QuaternionHighPrecisionMember a, QuaternionHighPrecisionMember b) {
            HighPrecisionMember z = new HighPrecisionMember();
            HighPrecisionMember z2 = new HighPrecisionMember();
            QuaternionHighPrecisionMember tmp = new QuaternionHighPrecisionMember();
            QuaternionHighPrecisionAlgebra.this.unreal().call(a, tmp);
            QuaternionHighPrecisionAlgebra.this.norm().call(tmp, z);
            G.HP.sinch().call(z, z2);
            BigDecimal cos = BigDecimalMath.cos((BigDecimal)a.r(), (MathContext)HighPrecisionAlgebra.getContext());
            BigDecimal sin = BigDecimalMath.sin((BigDecimal)a.r(), (MathContext)HighPrecisionAlgebra.getContext());
            BigDecimal sinhc_pi = z2.v();
            BigDecimal cosh = BigDecimalMath.cosh((BigDecimal)z.v(), (MathContext)HighPrecisionAlgebra.getContext());
            BigDecimal wc = sin.negate().multiply(sinhc_pi);
            b.setR(cos.multiply(cosh));
            b.setI(wc.multiply(a.i()));
            b.setJ(wc.multiply(a.j()));
            b.setK(wc.multiply(a.k()));
        }
    };
    private final Procedure3<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> SINANDCOS = new Procedure3<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember, QuaternionHighPrecisionMember>(){

        @Override
        public void call(QuaternionHighPrecisionMember a, QuaternionHighPrecisionMember s, QuaternionHighPrecisionMember c) {
            HighPrecisionMember z = new HighPrecisionMember();
            HighPrecisionMember z2 = new HighPrecisionMember();
            QuaternionHighPrecisionMember tmp = new QuaternionHighPrecisionMember();
            QuaternionHighPrecisionAlgebra.this.unreal().call(a, tmp);
            QuaternionHighPrecisionAlgebra.this.norm().call(tmp, z);
            G.HP.sinch().call(z, z2);
            BigDecimal cos = BigDecimalMath.cos((BigDecimal)a.r(), (MathContext)HighPrecisionAlgebra.getContext());
            BigDecimal sin = BigDecimalMath.sin((BigDecimal)a.r(), (MathContext)HighPrecisionAlgebra.getContext());
            BigDecimal sinhc_pi = z2.v();
            BigDecimal cosh = BigDecimalMath.cosh((BigDecimal)z.v(), (MathContext)HighPrecisionAlgebra.getContext());
            BigDecimal ws = cos.multiply(sinhc_pi);
            BigDecimal wc = sin.negate().multiply(sinhc_pi);
            s.setR(sin.multiply(cosh));
            s.setI(ws.multiply(a.i()));
            s.setJ(ws.multiply(a.j()));
            s.setK(ws.multiply(a.k()));
            c.setR(cos.multiply(cosh));
            c.setI(wc.multiply(a.i()));
            c.setJ(wc.multiply(a.j()));
            c.setK(wc.multiply(a.k()));
        }
    };
    private final Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> TAN = new Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember>(){

        @Override
        public void call(QuaternionHighPrecisionMember a, QuaternionHighPrecisionMember b) {
            QuaternionHighPrecisionMember sin = new QuaternionHighPrecisionMember();
            QuaternionHighPrecisionMember cos = new QuaternionHighPrecisionMember();
            QuaternionHighPrecisionAlgebra.this.sinAndCos().call(a, sin, cos);
            QuaternionHighPrecisionAlgebra.this.divide().call(sin, cos, b);
        }
    };
    private final Procedure3<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> POW = new Procedure3<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember, QuaternionHighPrecisionMember>(){

        @Override
        public void call(QuaternionHighPrecisionMember a, QuaternionHighPrecisionMember b, QuaternionHighPrecisionMember c) {
            QuaternionHighPrecisionMember logA = new QuaternionHighPrecisionMember();
            QuaternionHighPrecisionMember bLogA = new QuaternionHighPrecisionMember();
            QuaternionHighPrecisionAlgebra.this.log().call(a, logA);
            QuaternionHighPrecisionAlgebra.this.multiply().call(b, logA, bLogA);
            QuaternionHighPrecisionAlgebra.this.exp().call(bLogA, c);
        }
    };
    private final Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> SINCH = new Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember>(){

        @Override
        public void call(QuaternionHighPrecisionMember a, QuaternionHighPrecisionMember b) {
            Sinch.compute(G.QHP, a, b);
        }
    };
    private final Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> SINCHPI = new Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember>(){

        @Override
        public void call(QuaternionHighPrecisionMember a, QuaternionHighPrecisionMember b) {
            Sinchpi.compute(G.QHP, a, b);
        }
    };
    private final Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> SINC = new Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember>(){

        @Override
        public void call(QuaternionHighPrecisionMember a, QuaternionHighPrecisionMember b) {
            Sinc.compute(G.QHP, a, b);
        }
    };
    private final Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> SINCPI = new Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember>(){

        @Override
        public void call(QuaternionHighPrecisionMember a, QuaternionHighPrecisionMember b) {
            Sincpi.compute(G.QHP, a, b);
        }
    };
    private final Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> SQRT = new Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember>(){

        @Override
        public void call(QuaternionHighPrecisionMember a, QuaternionHighPrecisionMember b) {
            QuaternionHighPrecisionMember ONE_HALF = G.QHP.construct();
            ONE_HALF.setR(BigDecimal.ONE.divide(TWO.r(), HighPrecisionAlgebra.getContext()));
            QuaternionHighPrecisionAlgebra.this.pow().call(a, ONE_HALF, b);
        }
    };
    private final Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> CBRT = new Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember>(){

        @Override
        public void call(QuaternionHighPrecisionMember a, QuaternionHighPrecisionMember b) {
            QuaternionHighPrecisionMember ONE_THIRD = G.QHP.construct();
            ONE_THIRD.setR(BigDecimal.ONE.divide(THREE.r(), HighPrecisionAlgebra.getContext()));
            QuaternionHighPrecisionAlgebra.this.pow().call(a, ONE_THIRD, b);
        }
    };
    private final Function1<Boolean, QuaternionHighPrecisionMember> ISZERO = new Function1<Boolean, QuaternionHighPrecisionMember>(){

        @Override
        public Boolean call(QuaternionHighPrecisionMember a) {
            return a.r().equals(BigDecimal.ZERO) && a.i().equals(BigDecimal.ZERO) && a.j().equals(BigDecimal.ZERO) && a.k().equals(BigDecimal.ZERO);
        }
    };
    private final Procedure3<HighPrecisionMember, QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> SBHP = new Procedure3<HighPrecisionMember, QuaternionHighPrecisionMember, QuaternionHighPrecisionMember>(){

        @Override
        public void call(HighPrecisionMember a, QuaternionHighPrecisionMember b, QuaternionHighPrecisionMember c) {
            BigDecimal tmp = a.v().multiply(b.r());
            c.setR(tmp);
            tmp = a.v().multiply(b.i());
            c.setI(tmp);
            tmp = a.v().multiply(b.j());
            c.setJ(tmp);
            tmp = a.v().multiply(b.k());
            c.setK(tmp);
        }
    };
    private final Procedure3<RationalMember, QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> SBR = new Procedure3<RationalMember, QuaternionHighPrecisionMember, QuaternionHighPrecisionMember>(){

        @Override
        public void call(RationalMember a, QuaternionHighPrecisionMember b, QuaternionHighPrecisionMember c) {
            BigDecimal n = new BigDecimal(a.n());
            BigDecimal d = new BigDecimal(a.d());
            BigDecimal tmp = b.r();
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setR(tmp);
            tmp = b.i();
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setI(tmp);
            tmp = b.j();
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setJ(tmp);
            tmp = b.k();
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setK(tmp);
        }
    };
    private final Procedure3<Double, QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> SBD = new Procedure3<Double, QuaternionHighPrecisionMember, QuaternionHighPrecisionMember>(){

        @Override
        public void call(Double a, QuaternionHighPrecisionMember b, QuaternionHighPrecisionMember c) {
            BigDecimal d = BigDecimal.valueOf(a);
            BigDecimal tmp = b.r();
            tmp = tmp.multiply(d);
            c.setR(tmp);
            tmp = b.i();
            tmp = tmp.multiply(d);
            c.setI(tmp);
            tmp = b.j();
            tmp = tmp.multiply(d);
            c.setJ(tmp);
            tmp = b.k();
            tmp = tmp.multiply(d);
            c.setK(tmp);
        }
    };
    private final Procedure3<HighPrecisionMember, QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> SC = new Procedure3<HighPrecisionMember, QuaternionHighPrecisionMember, QuaternionHighPrecisionMember>(){

        @Override
        public void call(HighPrecisionMember a, QuaternionHighPrecisionMember b, QuaternionHighPrecisionMember c) {
            c.setR(a.v().multiply(b.r()));
            c.setI(a.v().multiply(b.i()));
            c.setJ(a.v().multiply(b.j()));
            c.setK(a.v().multiply(b.k()));
        }
    };
    private final Function3<Boolean, HighPrecisionMember, QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> WITHIN = new Function3<Boolean, HighPrecisionMember, QuaternionHighPrecisionMember, QuaternionHighPrecisionMember>(){

        @Override
        public Boolean call(HighPrecisionMember tol, QuaternionHighPrecisionMember a, QuaternionHighPrecisionMember b) {
            return QuaternionNumberWithin.compute(G.HP, tol, a, b);
        }
    };

    @Override
    public Procedure1<QuaternionHighPrecisionMember> unity() {
        return this.UNITY;
    }

    @Override
    public Procedure3<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<Integer, QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<QuaternionHighPrecisionMember> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> subtract() {
        return this.SUB;
    }

    @Override
    public Function2<Boolean, QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public QuaternionHighPrecisionMember construct() {
        return new QuaternionHighPrecisionMember();
    }

    @Override
    public QuaternionHighPrecisionMember construct(QuaternionHighPrecisionMember other) {
        return new QuaternionHighPrecisionMember(other);
    }

    @Override
    public QuaternionHighPrecisionMember construct(String s) {
        return new QuaternionHighPrecisionMember(s);
    }

    @Override
    public Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> invert() {
        return this.INV;
    }

    @Override
    public Procedure3<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> divide() {
        return this.DIVIDE;
    }

    @Override
    public Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> conjugate() {
        return this.CONJ;
    }

    @Override
    public Procedure2<QuaternionHighPrecisionMember, HighPrecisionMember> norm() {
        return this.NORM;
    }

    @Override
    public Procedure1<QuaternionHighPrecisionMember> PI() {
        return this.PI_;
    }

    @Override
    public Procedure1<QuaternionHighPrecisionMember> E() {
        return this.E_;
    }

    @Override
    public Procedure1<QuaternionHighPrecisionMember> GAMMA() {
        return this.GAMMA_;
    }

    @Override
    public Procedure1<QuaternionHighPrecisionMember> PHI() {
        return this.PHI_;
    }

    @Override
    public Procedure1<QuaternionHighPrecisionMember> I() {
        return this.I_;
    }

    @Override
    public Procedure1<QuaternionHighPrecisionMember> J() {
        return this.J_;
    }

    @Override
    public Procedure1<QuaternionHighPrecisionMember> K() {
        return this.K_;
    }

    @Override
    public Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> exp() {
        return this.EXP;
    }

    @Override
    public Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> log() {
        return this.LOG;
    }

    @Override
    public Procedure2<QuaternionHighPrecisionMember, HighPrecisionMember> real() {
        return this.REAL;
    }

    @Override
    public Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> unreal() {
        return this.UNREAL;
    }

    @Override
    public Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> sinh() {
        return this.SINH;
    }

    @Override
    public Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> cosh() {
        return this.COSH;
    }

    @Override
    public Procedure3<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> sinhAndCosh() {
        return this.SINHANDCOSH;
    }

    @Override
    public Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> tanh() {
        return this.TANH;
    }

    @Override
    public Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> sin() {
        return this.SIN;
    }

    @Override
    public Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> cos() {
        return this.COS;
    }

    @Override
    public Procedure3<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> sinAndCos() {
        return this.SINANDCOS;
    }

    @Override
    public Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> tan() {
        return this.TAN;
    }

    @Override
    public Procedure3<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> pow() {
        return this.POW;
    }

    @Override
    public Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> sinch() {
        return this.SINCH;
    }

    @Override
    public Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> sinchpi() {
        return this.SINCHPI;
    }

    @Override
    public Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> sinc() {
        return this.SINC;
    }

    @Override
    public Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> sincpi() {
        return this.SINCPI;
    }

    @Override
    public Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> sqrt() {
        return this.SQRT;
    }

    @Override
    public Procedure2<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> cbrt() {
        return this.CBRT;
    }

    @Override
    public Function1<Boolean, QuaternionHighPrecisionMember> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<QuaternionHighPrecisionMember, QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> scale() {
        return this.MUL;
    }

    @Override
    public Procedure3<HighPrecisionMember, QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<RationalMember, QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<HighPrecisionMember, QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> scaleComponents() {
        return this.SC;
    }

    @Override
    public Function3<Boolean, HighPrecisionMember, QuaternionHighPrecisionMember, QuaternionHighPrecisionMember> within() {
        return this.WITHIN;
    }
}

