/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.highprec.quaternion;

import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.Copy;
import nom.bdezonia.zorbage.algorithm.FixedTransform2;
import nom.bdezonia.zorbage.algorithm.SequenceIsZero;
import nom.bdezonia.zorbage.algorithm.SequencesSimilar;
import nom.bdezonia.zorbage.algorithm.ShapesMatch;
import nom.bdezonia.zorbage.algorithm.TensorCommaDerivative;
import nom.bdezonia.zorbage.algorithm.TensorContract;
import nom.bdezonia.zorbage.algorithm.TensorNorm;
import nom.bdezonia.zorbage.algorithm.TensorOuterProduct;
import nom.bdezonia.zorbage.algorithm.TensorPower;
import nom.bdezonia.zorbage.algorithm.TensorSemicolonDerivative;
import nom.bdezonia.zorbage.algorithm.TensorShape;
import nom.bdezonia.zorbage.algorithm.TensorUnity;
import nom.bdezonia.zorbage.algorithm.Transform2;
import nom.bdezonia.zorbage.algorithm.Transform3;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.procedure.Procedure5;
import nom.bdezonia.zorbage.type.algebra.Norm;
import nom.bdezonia.zorbage.type.algebra.Scale;
import nom.bdezonia.zorbage.type.algebra.ScaleByDouble;
import nom.bdezonia.zorbage.type.algebra.ScaleByHighPrec;
import nom.bdezonia.zorbage.type.algebra.ScaleByRational;
import nom.bdezonia.zorbage.type.algebra.TensorLikeProduct;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.ctor.ConstructibleNdLong;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.data.highprec.quaternion.QuaternionHighPrecisionAlgebra;
import nom.bdezonia.zorbage.type.data.highprec.quaternion.QuaternionHighPrecisionCartesianTensorProductMember;
import nom.bdezonia.zorbage.type.data.highprec.quaternion.QuaternionHighPrecisionMember;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class QuaternionHighPrecisionCartesianTensorProduct
implements TensorLikeProduct<QuaternionHighPrecisionCartesianTensorProduct, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionAlgebra, QuaternionHighPrecisionMember>,
ConstructibleNdLong<QuaternionHighPrecisionCartesianTensorProductMember>,
Norm<QuaternionHighPrecisionCartesianTensorProductMember, HighPrecisionMember>,
Scale<QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionMember>,
ScaleByHighPrec<QuaternionHighPrecisionCartesianTensorProductMember>,
ScaleByRational<QuaternionHighPrecisionCartesianTensorProductMember>,
ScaleByDouble<QuaternionHighPrecisionCartesianTensorProductMember>,
Tolerance<HighPrecisionMember, QuaternionHighPrecisionCartesianTensorProductMember> {
    private final Function2<Boolean, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember> EQ = new Function2<Boolean, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember>(){

        @Override
        public Boolean call(QuaternionHighPrecisionCartesianTensorProductMember a, QuaternionHighPrecisionCartesianTensorProductMember b) {
            if (!ShapesMatch.compute(a, b)) {
                return false;
            }
            return SequencesSimilar.compute(G.QHP, G.HP.construct(), a.rawData(), b.rawData());
        }
    };
    private final Function2<Boolean, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember> NEQ = new Function2<Boolean, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember>(){

        @Override
        public Boolean call(QuaternionHighPrecisionCartesianTensorProductMember a, QuaternionHighPrecisionCartesianTensorProductMember b) {
            return QuaternionHighPrecisionCartesianTensorProduct.this.isEqual().call(a, b) == false;
        }
    };
    private final Procedure2<QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember> ASSIGN = new Procedure2<QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(QuaternionHighPrecisionCartesianTensorProductMember from, QuaternionHighPrecisionCartesianTensorProductMember to) {
            TensorShape.compute(from, to);
            Copy.compute(G.QHP, from.rawData(), to.rawData());
        }
    };
    private final Procedure1<QuaternionHighPrecisionCartesianTensorProductMember> ZER = new Procedure1<QuaternionHighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(QuaternionHighPrecisionCartesianTensorProductMember a) {
            a.primitiveInit();
        }
    };
    private final Procedure2<QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember> NEG = new Procedure2<QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(QuaternionHighPrecisionCartesianTensorProductMember a, QuaternionHighPrecisionCartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            Transform2.compute(G.QHP, G.QHP.negate(), a.rawData(), b.rawData());
        }
    };
    private final Procedure3<QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember> ADDEL = new Procedure3<QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(QuaternionHighPrecisionCartesianTensorProductMember a, QuaternionHighPrecisionCartesianTensorProductMember b, QuaternionHighPrecisionCartesianTensorProductMember c) {
            if (!ShapesMatch.compute(a, b)) {
                throw new IllegalArgumentException("tensor add shape mismatch");
            }
            TensorShape.compute(a, c);
            Transform3.compute(G.QHP, G.QHP.add(), a.rawData(), b.rawData(), c.rawData());
        }
    };
    private final Procedure3<QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember> SUBEL = new Procedure3<QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(QuaternionHighPrecisionCartesianTensorProductMember a, QuaternionHighPrecisionCartesianTensorProductMember b, QuaternionHighPrecisionCartesianTensorProductMember c) {
            if (!ShapesMatch.compute(a, b)) {
                throw new IllegalArgumentException("tensor subtract shape mismatch");
            }
            TensorShape.compute(a, c);
            Transform3.compute(G.QHP, G.QHP.subtract(), a.rawData(), b.rawData(), c.rawData());
        }
    };
    private final Procedure2<QuaternionHighPrecisionCartesianTensorProductMember, HighPrecisionMember> NORM = new Procedure2<QuaternionHighPrecisionCartesianTensorProductMember, HighPrecisionMember>(){

        @Override
        public void call(QuaternionHighPrecisionCartesianTensorProductMember a, HighPrecisionMember b) {
            TensorNorm.compute(G.QHP, G.HP, a.rawData(), b);
        }
    };
    private final Procedure2<QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember> CONJ = new Procedure2<QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(QuaternionHighPrecisionCartesianTensorProductMember a, QuaternionHighPrecisionCartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            Transform2.compute(G.QHP, G.QHP.conjugate(), a.rawData(), b.rawData());
        }
    };
    private final Procedure3<QuaternionHighPrecisionMember, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember> SCALE = new Procedure3<QuaternionHighPrecisionMember, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(QuaternionHighPrecisionMember scalar, QuaternionHighPrecisionCartesianTensorProductMember a, QuaternionHighPrecisionCartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            nom.bdezonia.zorbage.algorithm.Scale.compute(G.QHP, scalar, a.rawData(), b.rawData());
        }
    };
    private final Procedure3<QuaternionHighPrecisionMember, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember> ADDSCALAR = new Procedure3<QuaternionHighPrecisionMember, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(QuaternionHighPrecisionMember scalar, QuaternionHighPrecisionCartesianTensorProductMember a, QuaternionHighPrecisionCartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            FixedTransform2.compute(G.QHP, scalar, G.QHP.add(), a.rawData(), b.rawData());
        }
    };
    private final Procedure3<QuaternionHighPrecisionMember, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember> SUBSCALAR = new Procedure3<QuaternionHighPrecisionMember, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(QuaternionHighPrecisionMember scalar, QuaternionHighPrecisionCartesianTensorProductMember a, QuaternionHighPrecisionCartesianTensorProductMember b) {
            QuaternionHighPrecisionMember tmp = G.QHP.construct();
            G.QHP.negate().call(scalar, tmp);
            QuaternionHighPrecisionCartesianTensorProduct.this.addScalar().call(tmp, a, b);
        }
    };
    private Procedure3<QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember> MULEL = new Procedure3<QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(QuaternionHighPrecisionCartesianTensorProductMember a, QuaternionHighPrecisionCartesianTensorProductMember b, QuaternionHighPrecisionCartesianTensorProductMember c) {
            if (!ShapesMatch.compute(a, b)) {
                throw new IllegalArgumentException("mismatched shapes");
            }
            TensorShape.compute(a, c);
            Transform3.compute(G.QHP, G.QHP.multiply(), a.rawData(), b.rawData(), c.rawData());
        }
    };
    private Procedure3<QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember> DIVIDEEL = new Procedure3<QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(QuaternionHighPrecisionCartesianTensorProductMember a, QuaternionHighPrecisionCartesianTensorProductMember b, QuaternionHighPrecisionCartesianTensorProductMember c) {
            if (!ShapesMatch.compute(a, b)) {
                throw new IllegalArgumentException("mismatched shapes");
            }
            TensorShape.compute(a, c);
            Transform3.compute(G.QHP, G.QHP.divide(), a.rawData(), b.rawData(), c.rawData());
        }
    };
    private final Procedure3<QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember> MUL = new Procedure3<QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(QuaternionHighPrecisionCartesianTensorProductMember a, QuaternionHighPrecisionCartesianTensorProductMember b, QuaternionHighPrecisionCartesianTensorProductMember c) {
            QuaternionHighPrecisionCartesianTensorProduct.this.outerProduct().call(a, b, c);
        }
    };
    private final Procedure4<Integer, Integer, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember> CONTRACT = new Procedure4<Integer, Integer, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(Integer i, Integer j, QuaternionHighPrecisionCartesianTensorProductMember a, QuaternionHighPrecisionCartesianTensorProductMember b) {
            TensorContract.compute(G.QHP, a.rank(), i, j, a, b);
        }
    };
    private final Procedure3<Integer, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember> SEMI = new Procedure3<Integer, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(Integer index, QuaternionHighPrecisionCartesianTensorProductMember a, QuaternionHighPrecisionCartesianTensorProductMember b) {
            TensorSemicolonDerivative.compute(G.QHP_TEN, G.QHP, index, a, b);
        }
    };
    private final Procedure3<Integer, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember> COMMA = new Procedure3<Integer, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(Integer index, QuaternionHighPrecisionCartesianTensorProductMember a, QuaternionHighPrecisionCartesianTensorProductMember b) {
            TensorCommaDerivative.compute(G.QHP_TEN, G.QHP, index, a, b);
        }
    };
    private final Procedure3<Integer, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember> POWER = new Procedure3<Integer, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(Integer power, QuaternionHighPrecisionCartesianTensorProductMember a, QuaternionHighPrecisionCartesianTensorProductMember b) {
            TensorPower.compute(G.QHP_TEN, power, a, b);
        }
    };
    private final Procedure1<QuaternionHighPrecisionCartesianTensorProductMember> UNITY = new Procedure1<QuaternionHighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(QuaternionHighPrecisionCartesianTensorProductMember result) {
            TensorUnity.compute(G.QHP_TEN, G.QHP, result);
        }
    };
    private final Function1<Boolean, QuaternionHighPrecisionCartesianTensorProductMember> ISZERO = new Function1<Boolean, QuaternionHighPrecisionCartesianTensorProductMember>(){

        @Override
        public Boolean call(QuaternionHighPrecisionCartesianTensorProductMember a) {
            return SequenceIsZero.compute(G.QHP, a.rawData());
        }
    };
    private final Procedure3<RationalMember, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember> SBR = new Procedure3<RationalMember, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(RationalMember factor, QuaternionHighPrecisionCartesianTensorProductMember a, QuaternionHighPrecisionCartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            nom.bdezonia.zorbage.algorithm.ScaleByRational.compute(G.QHP, factor, a.rawData(), b.rawData());
        }
    };
    private final Procedure3<Double, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember> SBD = new Procedure3<Double, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(Double factor, QuaternionHighPrecisionCartesianTensorProductMember a, QuaternionHighPrecisionCartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            nom.bdezonia.zorbage.algorithm.ScaleByDouble.compute(G.QHP, factor, a.rawData(), b.rawData());
        }
    };
    private final Procedure3<HighPrecisionMember, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember> SBHP = new Procedure3<HighPrecisionMember, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(HighPrecisionMember factor, QuaternionHighPrecisionCartesianTensorProductMember a, QuaternionHighPrecisionCartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            nom.bdezonia.zorbage.algorithm.ScaleByHighPrec.compute(G.QHP, factor, a.rawData(), b.rawData());
        }
    };
    private final Function3<Boolean, HighPrecisionMember, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember> WITHIN = new Function3<Boolean, HighPrecisionMember, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember>(){

        @Override
        public Boolean call(HighPrecisionMember tol, QuaternionHighPrecisionCartesianTensorProductMember a, QuaternionHighPrecisionCartesianTensorProductMember b) {
            if (!ShapesMatch.compute(a, b)) {
                return false;
            }
            return SequencesSimilar.compute(G.QHP, tol, a.rawData(), b.rawData());
        }
    };
    private final Procedure3<QuaternionHighPrecisionMember, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember> MULBYSCALAR = new Procedure3<QuaternionHighPrecisionMember, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(QuaternionHighPrecisionMember factor, QuaternionHighPrecisionCartesianTensorProductMember a, QuaternionHighPrecisionCartesianTensorProductMember b) {
            QuaternionHighPrecisionCartesianTensorProduct.this.scale().call(factor, a, b);
        }
    };
    private final Procedure3<QuaternionHighPrecisionMember, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember> DIVBYSCALAR = new Procedure3<QuaternionHighPrecisionMember, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(QuaternionHighPrecisionMember factor, QuaternionHighPrecisionCartesianTensorProductMember a, QuaternionHighPrecisionCartesianTensorProductMember b) {
            QuaternionHighPrecisionMember invFactor = G.QHP.construct();
            G.QHP.invert().call(factor, invFactor);
            QuaternionHighPrecisionCartesianTensorProduct.this.scale().call(invFactor, a, b);
        }
    };
    private final Procedure3<Integer, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember> RAISE = new Procedure3<Integer, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(Integer idx, QuaternionHighPrecisionCartesianTensorProductMember a, QuaternionHighPrecisionCartesianTensorProductMember b) {
            throw new IllegalArgumentException("cannot raise index of a cartesian tensor");
        }
    };
    private final Procedure3<Integer, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember> LOWER = new Procedure3<Integer, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(Integer idx, QuaternionHighPrecisionCartesianTensorProductMember a, QuaternionHighPrecisionCartesianTensorProductMember b) {
            if (idx < 0 || idx >= a.rank()) {
                throw new IllegalArgumentException("index outside rank bounds in lowerIndex");
            }
            QuaternionHighPrecisionCartesianTensorProduct.this.assign().call(a, b);
        }
    };
    private final Procedure5<Integer, Integer, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember> INNER = new Procedure5<Integer, Integer, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(Integer aIndex, Integer bIndex, QuaternionHighPrecisionCartesianTensorProductMember a, QuaternionHighPrecisionCartesianTensorProductMember b, QuaternionHighPrecisionCartesianTensorProductMember c) {
            if (aIndex < 0 || bIndex < 0) {
                throw new IllegalArgumentException("tensor innerProduct() cannot handle negative indices");
            }
            if (aIndex >= a.rank() || bIndex >= b.rank()) {
                throw new IllegalArgumentException("tensor innerProduct() cannot handle out of bounds indices");
            }
            QuaternionHighPrecisionCartesianTensorProductMember tmp = QuaternionHighPrecisionCartesianTensorProduct.this.construct();
            QuaternionHighPrecisionCartesianTensorProduct.this.outerProduct().call(a, b, tmp);
            QuaternionHighPrecisionCartesianTensorProduct.this.contract().call(aIndex, a.rank() + bIndex, tmp, c);
        }
    };
    private final Procedure3<QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember> OUTER = new Procedure3<QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(QuaternionHighPrecisionCartesianTensorProductMember a, QuaternionHighPrecisionCartesianTensorProductMember b, QuaternionHighPrecisionCartesianTensorProductMember c) {
            TensorOuterProduct.compute(G.QHP_TEN, G.QHP, a, b, c);
        }
    };

    @Override
    public QuaternionHighPrecisionCartesianTensorProductMember construct() {
        return new QuaternionHighPrecisionCartesianTensorProductMember();
    }

    @Override
    public QuaternionHighPrecisionCartesianTensorProductMember construct(QuaternionHighPrecisionCartesianTensorProductMember other) {
        return new QuaternionHighPrecisionCartesianTensorProductMember(other);
    }

    @Override
    public QuaternionHighPrecisionCartesianTensorProductMember construct(String s) {
        return new QuaternionHighPrecisionCartesianTensorProductMember(s);
    }

    @Override
    public QuaternionHighPrecisionCartesianTensorProductMember construct(StorageConstruction s, long[] nd) {
        return new QuaternionHighPrecisionCartesianTensorProductMember(s, nd);
    }

    @Override
    public Function2<Boolean, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure1<QuaternionHighPrecisionCartesianTensorProductMember> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember> add() {
        return this.ADDEL;
    }

    @Override
    public Procedure3<QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember> subtract() {
        return this.SUBEL;
    }

    @Override
    public Procedure2<QuaternionHighPrecisionCartesianTensorProductMember, HighPrecisionMember> norm() {
        return this.NORM;
    }

    @Override
    public Procedure2<QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember> conjugate() {
        return this.CONJ;
    }

    @Override
    public Procedure3<QuaternionHighPrecisionMember, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember> scale() {
        return this.SCALE;
    }

    @Override
    public Procedure3<QuaternionHighPrecisionMember, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember> addScalar() {
        return this.ADDSCALAR;
    }

    @Override
    public Procedure3<QuaternionHighPrecisionMember, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember> subtractScalar() {
        return this.SUBSCALAR;
    }

    @Override
    public Procedure3<QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember> multiplyElements() {
        return this.MULEL;
    }

    @Override
    public Procedure3<QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember> divideElements() {
        return this.DIVIDEEL;
    }

    @Override
    public Procedure3<QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure4<Integer, Integer, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember> contract() {
        return this.CONTRACT;
    }

    @Override
    public Procedure3<Integer, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember> semicolonDerivative() {
        return this.SEMI;
    }

    @Override
    public Procedure3<Integer, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember> commaDerivative() {
        return this.COMMA;
    }

    @Override
    public Procedure3<Integer, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<QuaternionHighPrecisionCartesianTensorProductMember> unity() {
        return this.UNITY;
    }

    @Override
    public Function1<Boolean, QuaternionHighPrecisionCartesianTensorProductMember> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<RationalMember, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<HighPrecisionMember, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Function3<Boolean, HighPrecisionMember, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember> within() {
        return this.WITHIN;
    }

    @Override
    public Procedure3<QuaternionHighPrecisionMember, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember> multiplyByScalar() {
        return this.MULBYSCALAR;
    }

    @Override
    public Procedure3<QuaternionHighPrecisionMember, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember> divideByScalar() {
        return this.DIVBYSCALAR;
    }

    @Override
    public Procedure3<Integer, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember> raiseIndex() {
        return this.RAISE;
    }

    @Override
    public Procedure3<Integer, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember> lowerIndex() {
        return this.LOWER;
    }

    @Override
    public Procedure5<Integer, Integer, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember> innerProduct() {
        return this.INNER;
    }

    @Override
    public Procedure3<QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember, QuaternionHighPrecisionCartesianTensorProductMember> outerProduct() {
        return this.OUTER;
    }
}

