/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.highprec.quaternion;

import java.math.BigDecimal;
import java.math.BigInteger;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.MatrixReshape;
import nom.bdezonia.zorbage.misc.BigList;
import nom.bdezonia.zorbage.sampling.IntegerIndex;
import nom.bdezonia.zorbage.type.algebra.Gettable;
import nom.bdezonia.zorbage.type.algebra.MatrixMember;
import nom.bdezonia.zorbage.type.algebra.Settable;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.data.highprec.quaternion.QuaternionHighPrecisionMember;
import nom.bdezonia.zorbage.type.data.universal.OctonionRepresentation;
import nom.bdezonia.zorbage.type.data.universal.PrimitiveConversion;
import nom.bdezonia.zorbage.type.data.universal.PrimitiveRepresentation;
import nom.bdezonia.zorbage.type.data.universal.TensorOctonionRepresentation;
import nom.bdezonia.zorbage.type.data.universal.TensorStringRepresentation;
import nom.bdezonia.zorbage.type.data.universal.UniversalRepresentation;
import nom.bdezonia.zorbage.type.storage.Storage;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;
import nom.bdezonia.zorbage.type.storage.datasource.RawData;

public final class QuaternionHighPrecisionMatrixMember
implements MatrixMember<QuaternionHighPrecisionMember>,
Gettable<QuaternionHighPrecisionMatrixMember>,
Settable<QuaternionHighPrecisionMatrixMember>,
PrimitiveConversion,
UniversalRepresentation,
RawData<QuaternionHighPrecisionMember> {
    private static final QuaternionHighPrecisionMember ZERO = new QuaternionHighPrecisionMember();
    private IndexedDataSource<QuaternionHighPrecisionMember> storage;
    private long rows;
    private long cols;
    private StorageConstruction s;
    private static ThreadLocal<QuaternionHighPrecisionMember> tmpQuat = new ThreadLocal<QuaternionHighPrecisionMember>(){

        @Override
        protected QuaternionHighPrecisionMember initialValue() {
            return new QuaternionHighPrecisionMember();
        }
    };

    public QuaternionHighPrecisionMatrixMember() {
        this.rows = -1L;
        this.cols = -1L;
        this.s = StorageConstruction.MEM_ARRAY;
        this.init(0L, 0L);
    }

    public QuaternionHighPrecisionMatrixMember(int r, int c, BigDecimal[] vals) {
        if (vals.length != r * c * 4) {
            throw new IllegalArgumentException("input values do not match declared shape");
        }
        this.rows = -1L;
        this.cols = -1L;
        this.s = StorageConstruction.MEM_ARRAY;
        this.init(r, c);
        QuaternionHighPrecisionMember tmp = new QuaternionHighPrecisionMember();
        int quatCount = vals.length / 4;
        for (int i = 0; i < quatCount; ++i) {
            tmp.setR(vals[4 * i]);
            tmp.setI(vals[4 * i + 1]);
            tmp.setJ(vals[4 * i + 2]);
            tmp.setK(vals[4 * i + 3]);
            this.storage.set(i, tmp);
        }
    }

    public QuaternionHighPrecisionMatrixMember(QuaternionHighPrecisionMatrixMember other) {
        this.set(other);
    }

    public QuaternionHighPrecisionMatrixMember(String s) {
        TensorStringRepresentation rep = new TensorStringRepresentation(s);
        BigList<OctonionRepresentation> data = rep.firstMatrixValues();
        long[] dimensions = rep.dimensions();
        this.rows = -1L;
        this.cols = -1L;
        this.s = StorageConstruction.MEM_ARRAY;
        this.init(dimensions[1], dimensions[0]);
        QuaternionHighPrecisionMember tmp = new QuaternionHighPrecisionMember();
        long storageSize = this.storage.size();
        for (long i = 0L; i < storageSize; ++i) {
            OctonionRepresentation val = data.get(i);
            tmp.setR(val.r());
            tmp.setI(val.i());
            tmp.setJ(val.j());
            tmp.setK(val.k());
            this.storage.set(i, tmp);
        }
    }

    public QuaternionHighPrecisionMatrixMember(StorageConstruction s, long d1, long d2) {
        this.rows = -1L;
        this.cols = -1L;
        this.s = s;
        this.init(d2, d1);
    }

    @Override
    public StorageConstruction storageType() {
        return this.s;
    }

    @Override
    public long rows() {
        return this.rows;
    }

    @Override
    public long cols() {
        return this.cols;
    }

    @Override
    public boolean alloc(long r, long c) {
        if (this.rows != r || this.cols != c) {
            this.rows = r;
            this.cols = c;
        }
        if (this.storage == null || this.storage.size() != r * c) {
            this.storage = Storage.allocate(this.s, r * c, new QuaternionHighPrecisionMember());
            return true;
        }
        return false;
    }

    @Override
    public void init(long r, long c) {
        if (!this.alloc(r, c)) {
            long storageSize = r * c;
            for (long i = 0L; i < storageSize; ++i) {
                this.storage.set(i, ZERO);
            }
        }
    }

    @Override
    public void v(long r, long c, QuaternionHighPrecisionMember value) {
        if (r < 0L || r >= this.rows || c < 0L || c >= this.cols) {
            throw new IllegalArgumentException("matrix oob access");
        }
        long index = r * this.cols + c;
        this.storage.get(index, value);
    }

    @Override
    public void setV(long r, long c, QuaternionHighPrecisionMember value) {
        if (r < 0L || r >= this.rows || c < 0L || c >= this.cols) {
            throw new IllegalArgumentException("matrix oob access");
        }
        long index = r * this.cols + c;
        this.storage.set(index, value);
    }

    @Override
    public void set(QuaternionHighPrecisionMatrixMember other) {
        if (this == other) {
            return;
        }
        this.rows = other.rows;
        this.cols = other.cols;
        this.s = other.s;
        this.storage = (IndexedDataSource)other.storage.duplicate();
    }

    @Override
    public void get(QuaternionHighPrecisionMatrixMember other) {
        if (this == other) {
            return;
        }
        other.rows = this.rows;
        other.cols = this.cols;
        other.s = this.s;
        other.storage = (IndexedDataSource)this.storage.duplicate();
    }

    @Override
    public void toRep(TensorOctonionRepresentation rep) {
        long storageSize = this.storage.size();
        QuaternionHighPrecisionMember value = new QuaternionHighPrecisionMember();
        BigList<OctonionRepresentation> values = new BigList<OctonionRepresentation>(storageSize);
        for (long i = 0L; i < storageSize; ++i) {
            this.storage.get(i, value);
            BigDecimal re = value.r();
            BigDecimal im = value.i();
            BigDecimal j = value.j();
            BigDecimal k = value.k();
            OctonionRepresentation o = new OctonionRepresentation(re, im, j, k);
            values.set(i, o);
        }
        rep.setMatrix(this.rows, this.cols, values);
    }

    @Override
    public void fromRep(TensorOctonionRepresentation rep) {
        QuaternionHighPrecisionMember value = new QuaternionHighPrecisionMember();
        BigList<OctonionRepresentation> mat = rep.getMatrix();
        this.alloc(rep.getMatrixRowDim(), rep.getMatrixColDim());
        long matSize = mat.size();
        for (long i = 0L; i < matSize; ++i) {
            OctonionRepresentation o = mat.get(i);
            value.setR(o.r());
            value.setI(o.i());
            value.setJ(o.j());
            value.setK(o.k());
            this.storage.set(i, value);
        }
    }

    public String toString() {
        QuaternionHighPrecisionMember tmp = new QuaternionHighPrecisionMember();
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        for (long r = 0L; r < this.rows; ++r) {
            builder.append('[');
            for (long c = 0L; c < this.cols; ++c) {
                if (c != 0L) {
                    builder.append(',');
                }
                this.v(r, c, tmp);
                builder.append(tmp.toString());
            }
            builder.append(']');
        }
        builder.append(']');
        return builder.toString();
    }

    @Override
    public int numDimensions() {
        return 2;
    }

    @Override
    public void reshape(long rows, long cols) {
        MatrixReshape.compute(G.QHP_MAT, G.QHP, rows, cols, this);
    }

    @Override
    public long dimension(int d) {
        if (d < 0) {
            throw new IllegalArgumentException("can't query negative dimension");
        }
        if (d == 0) {
            return this.cols;
        }
        if (d == 1) {
            return this.rows;
        }
        return 1L;
    }

    @Override
    public PrimitiveRepresentation preferredRepresentation() {
        return PrimitiveRepresentation.BIGDECIMAL;
    }

    @Override
    public int componentCount() {
        return 4;
    }

    @Override
    public void primComponentSetByte(IntegerIndex index, int component, byte v) {
        QuaternionHighPrecisionMember tmp = tmpQuat.get();
        long c = index.get(0);
        long r = index.get(1);
        this.v(r, c, tmp);
        if (component < 2) {
            if (component == 0) {
                tmp.setR(BigDecimal.valueOf(v));
            } else {
                tmp.setI(BigDecimal.valueOf(v));
            }
        } else if (component == 2) {
            tmp.setJ(BigDecimal.valueOf(v));
        } else {
            tmp.setK(BigDecimal.valueOf(v));
        }
        this.setV(r, c, tmp);
    }

    @Override
    public void primComponentSetShort(IntegerIndex index, int component, short v) {
        QuaternionHighPrecisionMember tmp = tmpQuat.get();
        long c = index.get(0);
        long r = index.get(1);
        this.v(r, c, tmp);
        if (component < 2) {
            if (component == 0) {
                tmp.setR(BigDecimal.valueOf(v));
            } else {
                tmp.setI(BigDecimal.valueOf(v));
            }
        } else if (component == 2) {
            tmp.setJ(BigDecimal.valueOf(v));
        } else {
            tmp.setK(BigDecimal.valueOf(v));
        }
        this.setV(r, c, tmp);
    }

    @Override
    public void primComponentSetInt(IntegerIndex index, int component, int v) {
        QuaternionHighPrecisionMember tmp = tmpQuat.get();
        long c = index.get(0);
        long r = index.get(1);
        this.v(r, c, tmp);
        if (component < 2) {
            if (component == 0) {
                tmp.setR(BigDecimal.valueOf(v));
            } else {
                tmp.setI(BigDecimal.valueOf(v));
            }
        } else if (component == 2) {
            tmp.setJ(BigDecimal.valueOf(v));
        } else {
            tmp.setK(BigDecimal.valueOf(v));
        }
        this.setV(r, c, tmp);
    }

    @Override
    public void primComponentSetLong(IntegerIndex index, int component, long v) {
        QuaternionHighPrecisionMember tmp = tmpQuat.get();
        long c = index.get(0);
        long r = index.get(1);
        this.v(r, c, tmp);
        if (component < 2) {
            if (component == 0) {
                tmp.setR(BigDecimal.valueOf(v));
            } else {
                tmp.setI(BigDecimal.valueOf(v));
            }
        } else if (component == 2) {
            tmp.setJ(BigDecimal.valueOf(v));
        } else {
            tmp.setK(BigDecimal.valueOf(v));
        }
        this.setV(r, c, tmp);
    }

    @Override
    public void primComponentSetFloat(IntegerIndex index, int component, float v) {
        QuaternionHighPrecisionMember tmp = tmpQuat.get();
        long c = index.get(0);
        long r = index.get(1);
        this.v(r, c, tmp);
        if (component < 2) {
            if (component == 0) {
                tmp.setR(BigDecimal.valueOf(v));
            } else {
                tmp.setI(BigDecimal.valueOf(v));
            }
        } else if (component == 2) {
            tmp.setJ(BigDecimal.valueOf(v));
        } else {
            tmp.setK(BigDecimal.valueOf(v));
        }
        this.setV(r, c, tmp);
    }

    @Override
    public void primComponentSetDouble(IntegerIndex index, int component, double v) {
        QuaternionHighPrecisionMember tmp = tmpQuat.get();
        long c = index.get(0);
        long r = index.get(1);
        this.v(r, c, tmp);
        if (component < 2) {
            if (component == 0) {
                tmp.setR(BigDecimal.valueOf(v));
            } else {
                tmp.setI(BigDecimal.valueOf(v));
            }
        } else if (component == 2) {
            tmp.setJ(BigDecimal.valueOf(v));
        } else {
            tmp.setK(BigDecimal.valueOf(v));
        }
        this.setV(r, c, tmp);
    }

    @Override
    public void primComponentSetBigInteger(IntegerIndex index, int component, BigInteger v) {
        QuaternionHighPrecisionMember tmp = tmpQuat.get();
        long c = index.get(0);
        long r = index.get(1);
        this.v(r, c, tmp);
        if (component < 2) {
            if (component == 0) {
                tmp.setR(new BigDecimal(v));
            } else {
                tmp.setI(new BigDecimal(v));
            }
        } else if (component == 2) {
            tmp.setJ(new BigDecimal(v));
        } else {
            tmp.setK(new BigDecimal(v));
        }
        this.setV(r, c, tmp);
    }

    @Override
    public void primComponentSetBigDecimal(IntegerIndex index, int component, BigDecimal v) {
        QuaternionHighPrecisionMember tmp = tmpQuat.get();
        long c = index.get(0);
        long r = index.get(1);
        this.v(r, c, tmp);
        if (component < 2) {
            if (component == 0) {
                tmp.setR(v);
            } else {
                tmp.setI(v);
            }
        } else if (component == 2) {
            tmp.setJ(v);
        } else {
            tmp.setK(v);
        }
        this.setV(r, c, tmp);
    }

    @Override
    public void primComponentSetByteSafe(IntegerIndex index, int component, byte v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            QuaternionHighPrecisionMember tmp = tmpQuat.get();
            long c = index.get(0);
            long r = index.get(1);
            this.v(r, c, tmp);
            if (component < 2) {
                if (component == 0) {
                    tmp.setR(BigDecimal.valueOf(v));
                } else {
                    tmp.setI(BigDecimal.valueOf(v));
                }
            } else if (component == 2) {
                tmp.setJ(BigDecimal.valueOf(v));
            } else {
                tmp.setK(BigDecimal.valueOf(v));
            }
            this.setV(r, c, tmp);
        }
    }

    @Override
    public void primComponentSetShortSafe(IntegerIndex index, int component, short v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            QuaternionHighPrecisionMember tmp = tmpQuat.get();
            long c = index.get(0);
            long r = index.get(1);
            this.v(r, c, tmp);
            if (component < 2) {
                if (component == 0) {
                    tmp.setR(BigDecimal.valueOf(v));
                } else {
                    tmp.setI(BigDecimal.valueOf(v));
                }
            } else if (component == 2) {
                tmp.setJ(BigDecimal.valueOf(v));
            } else {
                tmp.setK(BigDecimal.valueOf(v));
            }
            this.setV(r, c, tmp);
        }
    }

    @Override
    public void primComponentSetIntSafe(IntegerIndex index, int component, int v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            QuaternionHighPrecisionMember tmp = tmpQuat.get();
            long c = index.get(0);
            long r = index.get(1);
            this.v(r, c, tmp);
            if (component < 2) {
                if (component == 0) {
                    tmp.setR(BigDecimal.valueOf(v));
                } else {
                    tmp.setI(BigDecimal.valueOf(v));
                }
            } else if (component == 2) {
                tmp.setJ(BigDecimal.valueOf(v));
            } else {
                tmp.setK(BigDecimal.valueOf(v));
            }
            this.setV(r, c, tmp);
        }
    }

    @Override
    public void primComponentSetLongSafe(IntegerIndex index, int component, long v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0L) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            QuaternionHighPrecisionMember tmp = tmpQuat.get();
            long c = index.get(0);
            long r = index.get(1);
            this.v(r, c, tmp);
            if (component < 2) {
                if (component == 0) {
                    tmp.setR(BigDecimal.valueOf(v));
                } else {
                    tmp.setI(BigDecimal.valueOf(v));
                }
            } else if (component == 2) {
                tmp.setJ(BigDecimal.valueOf(v));
            } else {
                tmp.setK(BigDecimal.valueOf(v));
            }
            this.setV(r, c, tmp);
        }
    }

    @Override
    public void primComponentSetFloatSafe(IntegerIndex index, int component, float v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0.0f) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            QuaternionHighPrecisionMember tmp = tmpQuat.get();
            long c = index.get(0);
            long r = index.get(1);
            this.v(r, c, tmp);
            if (component < 2) {
                if (component == 0) {
                    tmp.setR(BigDecimal.valueOf(v));
                } else {
                    tmp.setI(BigDecimal.valueOf(v));
                }
            } else if (component == 2) {
                tmp.setJ(BigDecimal.valueOf(v));
            } else {
                tmp.setK(BigDecimal.valueOf(v));
            }
            this.setV(r, c, tmp);
        }
    }

    @Override
    public void primComponentSetDoubleSafe(IntegerIndex index, int component, double v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0.0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            QuaternionHighPrecisionMember tmp = tmpQuat.get();
            long c = index.get(0);
            long r = index.get(1);
            this.v(r, c, tmp);
            if (component < 2) {
                if (component == 0) {
                    tmp.setR(BigDecimal.valueOf(v));
                } else {
                    tmp.setI(BigDecimal.valueOf(v));
                }
            } else if (component == 2) {
                tmp.setJ(BigDecimal.valueOf(v));
            } else {
                tmp.setK(BigDecimal.valueOf(v));
            }
            this.setV(r, c, tmp);
        }
    }

    @Override
    public void primComponentSetBigIntegerSafe(IntegerIndex index, int component, BigInteger v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v.signum() != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            QuaternionHighPrecisionMember tmp = tmpQuat.get();
            long c = index.get(0);
            long r = index.get(1);
            this.v(r, c, tmp);
            if (component < 2) {
                if (component == 0) {
                    tmp.setR(new BigDecimal(v));
                } else {
                    tmp.setI(new BigDecimal(v));
                }
            } else if (component == 2) {
                tmp.setJ(new BigDecimal(v));
            } else {
                tmp.setK(new BigDecimal(v));
            }
            this.setV(r, c, tmp);
        }
    }

    @Override
    public void primComponentSetBigDecimalSafe(IntegerIndex index, int component, BigDecimal v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v.signum() != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            QuaternionHighPrecisionMember tmp = tmpQuat.get();
            long c = index.get(0);
            long r = index.get(1);
            this.v(r, c, tmp);
            if (component < 2) {
                if (component == 0) {
                    tmp.setR(v);
                } else {
                    tmp.setI(v);
                }
            } else if (component == 2) {
                tmp.setJ(v);
            } else {
                tmp.setK(v);
            }
            this.setV(r, c, tmp);
        }
    }

    @Override
    public byte primComponentGetAsByte(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component > 3) {
            return 0;
        }
        QuaternionHighPrecisionMember tmp = tmpQuat.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component < 2) {
            if (component == 0) {
                return tmp.r().byteValue();
            }
            return tmp.i().byteValue();
        }
        if (component == 2) {
            return tmp.j().byteValue();
        }
        return tmp.k().byteValue();
    }

    @Override
    public short primComponentGetAsShort(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component > 3) {
            return 0;
        }
        QuaternionHighPrecisionMember tmp = tmpQuat.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component < 2) {
            if (component == 0) {
                return tmp.r().shortValue();
            }
            return tmp.i().shortValue();
        }
        if (component == 2) {
            return tmp.j().shortValue();
        }
        return tmp.k().shortValue();
    }

    @Override
    public int primComponentGetAsInt(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component > 3) {
            return 0;
        }
        QuaternionHighPrecisionMember tmp = tmpQuat.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component < 2) {
            if (component == 0) {
                return tmp.r().intValue();
            }
            return tmp.i().intValue();
        }
        if (component == 2) {
            return tmp.j().intValue();
        }
        return tmp.k().intValue();
    }

    @Override
    public long primComponentGetAsLong(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component > 3) {
            return 0L;
        }
        QuaternionHighPrecisionMember tmp = tmpQuat.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component < 2) {
            if (component == 0) {
                return tmp.r().longValue();
            }
            return tmp.i().longValue();
        }
        if (component == 2) {
            return tmp.j().longValue();
        }
        return tmp.k().longValue();
    }

    @Override
    public float primComponentGetAsFloat(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component > 3) {
            return 0.0f;
        }
        QuaternionHighPrecisionMember tmp = tmpQuat.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component < 2) {
            if (component == 0) {
                return tmp.r().floatValue();
            }
            return tmp.i().floatValue();
        }
        if (component == 2) {
            return tmp.j().floatValue();
        }
        return tmp.k().floatValue();
    }

    @Override
    public double primComponentGetAsDouble(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component > 3) {
            return 0.0;
        }
        QuaternionHighPrecisionMember tmp = tmpQuat.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component < 2) {
            if (component == 0) {
                return tmp.r().doubleValue();
            }
            return tmp.i().doubleValue();
        }
        if (component == 2) {
            return tmp.j().doubleValue();
        }
        return tmp.k().doubleValue();
    }

    @Override
    public BigInteger primComponentGetAsBigInteger(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component > 3) {
            return BigInteger.ZERO;
        }
        QuaternionHighPrecisionMember tmp = tmpQuat.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component < 2) {
            if (component == 0) {
                return tmp.r().toBigInteger();
            }
            return tmp.i().toBigInteger();
        }
        if (component == 2) {
            return tmp.j().toBigInteger();
        }
        return tmp.k().toBigInteger();
    }

    @Override
    public BigDecimal primComponentGetAsBigDecimal(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component > 3) {
            return BigDecimal.ZERO;
        }
        QuaternionHighPrecisionMember tmp = tmpQuat.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component < 2) {
            if (component == 0) {
                return tmp.r();
            }
            return tmp.i();
        }
        if (component == 2) {
            return tmp.j();
        }
        return tmp.k();
    }

    @Override
    public byte primComponentGetAsByteSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0;
        }
        QuaternionHighPrecisionMember tmp = tmpQuat.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component < 2) {
            if (component == 0) {
                return tmp.r().byteValue();
            }
            return tmp.i().byteValue();
        }
        if (component == 2) {
            return tmp.j().byteValue();
        }
        return tmp.k().byteValue();
    }

    @Override
    public short primComponentGetAsShortSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0;
        }
        QuaternionHighPrecisionMember tmp = tmpQuat.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component < 2) {
            if (component == 0) {
                return tmp.r().shortValue();
            }
            return tmp.i().shortValue();
        }
        if (component == 2) {
            return tmp.j().shortValue();
        }
        return tmp.k().shortValue();
    }

    @Override
    public int primComponentGetAsIntSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0;
        }
        QuaternionHighPrecisionMember tmp = tmpQuat.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component < 2) {
            if (component == 0) {
                return tmp.r().intValue();
            }
            return tmp.i().intValue();
        }
        if (component == 2) {
            return tmp.j().intValue();
        }
        return tmp.k().intValue();
    }

    @Override
    public long primComponentGetAsLongSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0L;
        }
        QuaternionHighPrecisionMember tmp = tmpQuat.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component < 2) {
            if (component == 0) {
                return tmp.r().longValue();
            }
            return tmp.i().longValue();
        }
        if (component == 2) {
            return tmp.j().longValue();
        }
        return tmp.k().longValue();
    }

    @Override
    public float primComponentGetAsFloatSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0.0f;
        }
        QuaternionHighPrecisionMember tmp = tmpQuat.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component < 2) {
            if (component == 0) {
                return tmp.r().floatValue();
            }
            return tmp.i().floatValue();
        }
        if (component == 2) {
            return tmp.j().floatValue();
        }
        return tmp.k().floatValue();
    }

    @Override
    public double primComponentGetAsDoubleSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0.0;
        }
        QuaternionHighPrecisionMember tmp = tmpQuat.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component < 2) {
            if (component == 0) {
                return tmp.r().doubleValue();
            }
            return tmp.i().doubleValue();
        }
        if (component == 2) {
            return tmp.j().doubleValue();
        }
        return tmp.k().doubleValue();
    }

    @Override
    public BigInteger primComponentGetAsBigIntegerSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return BigInteger.ZERO;
        }
        QuaternionHighPrecisionMember tmp = tmpQuat.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component < 2) {
            if (component == 0) {
                return tmp.r().toBigInteger();
            }
            return tmp.i().toBigInteger();
        }
        if (component == 2) {
            return tmp.j().toBigInteger();
        }
        return tmp.k().toBigInteger();
    }

    @Override
    public BigDecimal primComponentGetAsBigDecimalSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return BigDecimal.ZERO;
        }
        QuaternionHighPrecisionMember tmp = tmpQuat.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component < 2) {
            if (component == 0) {
                return tmp.r();
            }
            return tmp.i();
        }
        if (component == 2) {
            return tmp.j();
        }
        return tmp.k();
    }

    @Override
    public void primitiveInit() {
        long storageSize = this.storage.size();
        for (long i = 0L; i < storageSize; ++i) {
            this.storage.set(i, ZERO);
        }
    }

    @Override
    public IndexedDataSource<QuaternionHighPrecisionMember> rawData() {
        return this.storage;
    }
}

