/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.highprec.quaternion;

import java.math.BigDecimal;
import java.math.BigInteger;
import nom.bdezonia.zorbage.sampling.IntegerIndex;
import nom.bdezonia.zorbage.type.algebra.GetQuaternion;
import nom.bdezonia.zorbage.type.algebra.Gettable;
import nom.bdezonia.zorbage.type.algebra.NumberMember;
import nom.bdezonia.zorbage.type.algebra.SetQuaternion;
import nom.bdezonia.zorbage.type.algebra.Settable;
import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.ctor.Duplicatable;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.universal.OctonionRepresentation;
import nom.bdezonia.zorbage.type.data.universal.PrimitiveConversion;
import nom.bdezonia.zorbage.type.data.universal.PrimitiveRepresentation;
import nom.bdezonia.zorbage.type.data.universal.TensorOctonionRepresentation;
import nom.bdezonia.zorbage.type.data.universal.TensorStringRepresentation;
import nom.bdezonia.zorbage.type.data.universal.UniversalRepresentation;
import nom.bdezonia.zorbage.type.storage.coder.BigDecimalCoder;

public final class QuaternionHighPrecisionMember
implements NumberMember<QuaternionHighPrecisionMember>,
BigDecimalCoder,
Allocatable<QuaternionHighPrecisionMember>,
Duplicatable<QuaternionHighPrecisionMember>,
Settable<QuaternionHighPrecisionMember>,
Gettable<QuaternionHighPrecisionMember>,
PrimitiveConversion,
UniversalRepresentation,
SetQuaternion<HighPrecisionMember>,
GetQuaternion<HighPrecisionMember> {
    private BigDecimal r;
    private BigDecimal i;
    private BigDecimal j;
    private BigDecimal k;

    public QuaternionHighPrecisionMember() {
        this.primitiveInit();
    }

    public QuaternionHighPrecisionMember(BigDecimal r, BigDecimal i, BigDecimal j, BigDecimal k) {
        this.setR(r);
        this.setI(i);
        this.setJ(j);
        this.setK(k);
    }

    public QuaternionHighPrecisionMember(QuaternionHighPrecisionMember value) {
        this.set(value);
    }

    public QuaternionHighPrecisionMember(String value) {
        TensorStringRepresentation rep = new TensorStringRepresentation(value);
        OctonionRepresentation val = rep.firstValue();
        this.setR(val.r());
        this.setI(val.i());
        this.setJ(val.j());
        this.setK(val.k());
    }

    public BigDecimal r() {
        return this.r;
    }

    public BigDecimal i() {
        return this.i;
    }

    public BigDecimal j() {
        return this.j;
    }

    public BigDecimal k() {
        return this.k;
    }

    @Override
    public void setR(BigDecimal val) {
        this.r = val;
    }

    @Override
    public void setI(BigDecimal val) {
        this.i = val;
    }

    @Override
    public void setJ(BigDecimal val) {
        this.j = val;
    }

    @Override
    public void setK(BigDecimal val) {
        this.k = val;
    }

    @Override
    public void set(QuaternionHighPrecisionMember other) {
        this.r = other.r;
        this.i = other.i;
        this.j = other.j;
        this.k = other.k;
    }

    @Override
    public void get(QuaternionHighPrecisionMember other) {
        other.r = this.r;
        other.i = this.i;
        other.j = this.j;
        other.k = this.k;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        builder.append(this.r());
        builder.append(',');
        builder.append(this.i());
        builder.append(',');
        builder.append(this.j());
        builder.append(',');
        builder.append(this.k());
        builder.append('}');
        return builder.toString();
    }

    @Override
    public int bigDecimalCount() {
        return 4;
    }

    @Override
    public void fromBigDecimalArray(BigDecimal[] arr, int index) {
        this.r = arr[index];
        this.i = arr[index + 1];
        this.j = arr[index + 2];
        this.k = arr[index + 3];
    }

    @Override
    public void toBigDecimalArray(BigDecimal[] arr, int index) {
        arr[index] = this.r;
        arr[index + 1] = this.i;
        arr[index + 2] = this.j;
        arr[index + 3] = this.k;
    }

    @Override
    public QuaternionHighPrecisionMember allocate() {
        return new QuaternionHighPrecisionMember();
    }

    @Override
    public QuaternionHighPrecisionMember duplicate() {
        return new QuaternionHighPrecisionMember(this);
    }

    @Override
    public int numDimensions() {
        return 0;
    }

    @Override
    public void v(QuaternionHighPrecisionMember value) {
        this.get(value);
    }

    @Override
    public void setV(QuaternionHighPrecisionMember value) {
        this.set(value);
    }

    @Override
    public void toRep(TensorOctonionRepresentation rep) {
        rep.setValue(new OctonionRepresentation(this.r(), this.i(), this.j(), this.k()));
    }

    @Override
    public void fromRep(TensorOctonionRepresentation rep) {
        OctonionRepresentation v = rep.getValue();
        this.setR(v.r());
        this.setI(v.i());
        this.setJ(v.j());
        this.setK(v.k());
    }

    @Override
    public PrimitiveRepresentation preferredRepresentation() {
        return PrimitiveRepresentation.BIGDECIMAL;
    }

    @Override
    public long dimension(int i) {
        return 0L;
    }

    @Override
    public int componentCount() {
        return 4;
    }

    @Override
    public void primComponentSetByte(IntegerIndex index, int component, byte v) {
        if (component < 2) {
            if (component == 0) {
                this.setR(BigDecimal.valueOf(v));
            } else {
                this.setI(BigDecimal.valueOf(v));
            }
        } else if (component == 2) {
            this.setJ(BigDecimal.valueOf(v));
        } else {
            this.setK(BigDecimal.valueOf(v));
        }
    }

    @Override
    public void primComponentSetShort(IntegerIndex index, int component, short v) {
        if (component < 2) {
            if (component == 0) {
                this.setR(BigDecimal.valueOf(v));
            } else {
                this.setI(BigDecimal.valueOf(v));
            }
        } else if (component == 2) {
            this.setJ(BigDecimal.valueOf(v));
        } else {
            this.setK(BigDecimal.valueOf(v));
        }
    }

    @Override
    public void primComponentSetInt(IntegerIndex index, int component, int v) {
        if (component < 2) {
            if (component == 0) {
                this.setR(BigDecimal.valueOf(v));
            } else {
                this.setI(BigDecimal.valueOf(v));
            }
        } else if (component == 2) {
            this.setJ(BigDecimal.valueOf(v));
        } else {
            this.setK(BigDecimal.valueOf(v));
        }
    }

    @Override
    public void primComponentSetLong(IntegerIndex index, int component, long v) {
        if (component < 2) {
            if (component == 0) {
                this.setR(BigDecimal.valueOf(v));
            } else {
                this.setI(BigDecimal.valueOf(v));
            }
        } else if (component == 2) {
            this.setJ(BigDecimal.valueOf(v));
        } else {
            this.setK(BigDecimal.valueOf(v));
        }
    }

    @Override
    public void primComponentSetFloat(IntegerIndex index, int component, float v) {
        if (component < 2) {
            if (component == 0) {
                this.setR(BigDecimal.valueOf(v));
            } else {
                this.setI(BigDecimal.valueOf(v));
            }
        } else if (component == 2) {
            this.setJ(BigDecimal.valueOf(v));
        } else {
            this.setK(BigDecimal.valueOf(v));
        }
    }

    @Override
    public void primComponentSetDouble(IntegerIndex index, int component, double v) {
        if (component < 2) {
            if (component == 0) {
                this.setR(BigDecimal.valueOf(v));
            } else {
                this.setI(BigDecimal.valueOf(v));
            }
        } else if (component == 2) {
            this.setJ(BigDecimal.valueOf(v));
        } else {
            this.setK(BigDecimal.valueOf(v));
        }
    }

    @Override
    public void primComponentSetBigInteger(IntegerIndex index, int component, BigInteger v) {
        if (component < 2) {
            if (component == 0) {
                this.setR(new BigDecimal(v));
            } else {
                this.setI(new BigDecimal(v));
            }
        } else if (component == 2) {
            this.setJ(new BigDecimal(v));
        } else {
            this.setK(new BigDecimal(v));
        }
    }

    @Override
    public void primComponentSetBigDecimal(IntegerIndex index, int component, BigDecimal v) {
        if (component < 2) {
            if (component == 0) {
                this.setR(v);
            } else {
                this.setI(v);
            }
        } else if (component == 2) {
            this.setJ(v);
        } else {
            this.setK(v);
        }
    }

    @Override
    public void primComponentSetByteSafe(IntegerIndex index, int component, byte v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else if (component < 2) {
            if (component == 0) {
                this.setR(BigDecimal.valueOf(v));
            } else {
                this.setI(BigDecimal.valueOf(v));
            }
        } else if (component == 2) {
            this.setJ(BigDecimal.valueOf(v));
        } else {
            this.setK(BigDecimal.valueOf(v));
        }
    }

    @Override
    public void primComponentSetShortSafe(IntegerIndex index, int component, short v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else if (component < 2) {
            if (component == 0) {
                this.setR(BigDecimal.valueOf(v));
            } else {
                this.setI(BigDecimal.valueOf(v));
            }
        } else if (component == 2) {
            this.setJ(BigDecimal.valueOf(v));
        } else {
            this.setK(BigDecimal.valueOf(v));
        }
    }

    @Override
    public void primComponentSetIntSafe(IntegerIndex index, int component, int v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else if (component < 2) {
            if (component == 0) {
                this.setR(BigDecimal.valueOf(v));
            } else {
                this.setI(BigDecimal.valueOf(v));
            }
        } else if (component == 2) {
            this.setJ(BigDecimal.valueOf(v));
        } else {
            this.setK(BigDecimal.valueOf(v));
        }
    }

    @Override
    public void primComponentSetLongSafe(IntegerIndex index, int component, long v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0L) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else if (component < 2) {
            if (component == 0) {
                this.setR(BigDecimal.valueOf(v));
            } else {
                this.setI(BigDecimal.valueOf(v));
            }
        } else if (component == 2) {
            this.setJ(BigDecimal.valueOf(v));
        } else {
            this.setK(BigDecimal.valueOf(v));
        }
    }

    @Override
    public void primComponentSetFloatSafe(IntegerIndex index, int component, float v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0.0f) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else if (component < 2) {
            if (component == 0) {
                this.setR(BigDecimal.valueOf(v));
            } else {
                this.setI(BigDecimal.valueOf(v));
            }
        } else if (component == 2) {
            this.setJ(BigDecimal.valueOf(v));
        } else {
            this.setK(BigDecimal.valueOf(v));
        }
    }

    @Override
    public void primComponentSetDoubleSafe(IntegerIndex index, int component, double v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0.0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else if (component < 2) {
            if (component == 0) {
                this.setR(BigDecimal.valueOf(v));
            } else {
                this.setI(BigDecimal.valueOf(v));
            }
        } else if (component == 2) {
            this.setJ(BigDecimal.valueOf(v));
        } else {
            this.setK(BigDecimal.valueOf(v));
        }
    }

    @Override
    public void primComponentSetBigIntegerSafe(IntegerIndex index, int component, BigInteger v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v.signum() != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else if (component < 2) {
            if (component == 0) {
                this.setR(new BigDecimal(v));
            } else {
                this.setI(new BigDecimal(v));
            }
        } else if (component == 2) {
            this.setJ(new BigDecimal(v));
        } else {
            this.setK(new BigDecimal(v));
        }
    }

    @Override
    public void primComponentSetBigDecimalSafe(IntegerIndex index, int component, BigDecimal v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v.signum() != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else if (component < 2) {
            if (component == 0) {
                this.setR(v);
            } else {
                this.setI(v);
            }
        } else if (component == 2) {
            this.setJ(v);
        } else {
            this.setK(v);
        }
    }

    @Override
    public byte primComponentGetAsByte(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component < 2) {
            if (component == 0) {
                return this.r().byteValue();
            }
            return this.i().byteValue();
        }
        if (component == 2) {
            return this.j().byteValue();
        }
        return this.k().byteValue();
    }

    @Override
    public short primComponentGetAsShort(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component < 2) {
            if (component == 0) {
                return this.r().shortValue();
            }
            return this.i().shortValue();
        }
        if (component == 2) {
            return this.j().shortValue();
        }
        return this.k().shortValue();
    }

    @Override
    public int primComponentGetAsInt(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component < 2) {
            if (component == 0) {
                return this.r().intValue();
            }
            return this.i().intValue();
        }
        if (component == 2) {
            return this.j().intValue();
        }
        return this.k().intValue();
    }

    @Override
    public long primComponentGetAsLong(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component < 2) {
            if (component == 0) {
                return this.r().longValue();
            }
            return this.i().longValue();
        }
        if (component == 2) {
            return this.j().longValue();
        }
        return this.k().longValue();
    }

    @Override
    public float primComponentGetAsFloat(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component < 2) {
            if (component == 0) {
                return this.r().floatValue();
            }
            return this.i().floatValue();
        }
        if (component == 2) {
            return this.j().floatValue();
        }
        return this.k().floatValue();
    }

    @Override
    public double primComponentGetAsDouble(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component < 2) {
            if (component == 0) {
                return this.r().doubleValue();
            }
            return this.i().doubleValue();
        }
        if (component == 2) {
            return this.j().doubleValue();
        }
        return this.k().doubleValue();
    }

    @Override
    public BigInteger primComponentGetAsBigInteger(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component < 2) {
            if (component == 0) {
                return this.r().toBigInteger();
            }
            return this.i().toBigInteger();
        }
        if (component == 2) {
            return this.j().toBigInteger();
        }
        return this.k().toBigInteger();
    }

    @Override
    public BigDecimal primComponentGetAsBigDecimal(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component < 2) {
            if (component == 0) {
                return this.r();
            }
            return this.i();
        }
        if (component == 2) {
            return this.j();
        }
        return this.k();
    }

    @Override
    public byte primComponentGetAsByteSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0;
        }
        if (component < 2) {
            if (component == 0) {
                return this.r().byteValue();
            }
            return this.i().byteValue();
        }
        if (component == 2) {
            return this.j().byteValue();
        }
        return this.k().byteValue();
    }

    @Override
    public short primComponentGetAsShortSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0;
        }
        if (component < 2) {
            if (component == 0) {
                return this.r().shortValue();
            }
            return this.i().shortValue();
        }
        if (component == 2) {
            return this.j().shortValue();
        }
        return this.k().shortValue();
    }

    @Override
    public int primComponentGetAsIntSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0;
        }
        if (component < 2) {
            if (component == 0) {
                return this.r().intValue();
            }
            return this.i().intValue();
        }
        if (component == 2) {
            return this.j().intValue();
        }
        return this.k().intValue();
    }

    @Override
    public long primComponentGetAsLongSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0L;
        }
        if (component < 2) {
            if (component == 0) {
                return this.r().longValue();
            }
            return this.i().longValue();
        }
        if (component == 2) {
            return this.j().longValue();
        }
        return this.k().longValue();
    }

    @Override
    public float primComponentGetAsFloatSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0.0f;
        }
        if (component < 2) {
            if (component == 0) {
                return this.r().floatValue();
            }
            return this.i().floatValue();
        }
        if (component == 2) {
            return this.j().floatValue();
        }
        return this.k().floatValue();
    }

    @Override
    public double primComponentGetAsDoubleSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0.0;
        }
        if (component < 2) {
            if (component == 0) {
                return this.r().doubleValue();
            }
            return this.i().doubleValue();
        }
        if (component == 2) {
            return this.j().doubleValue();
        }
        return this.k().doubleValue();
    }

    @Override
    public BigInteger primComponentGetAsBigIntegerSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return BigInteger.ZERO;
        }
        if (component < 2) {
            if (component == 0) {
                return this.r().toBigInteger();
            }
            return this.i().toBigInteger();
        }
        if (component == 2) {
            return this.j().toBigInteger();
        }
        return this.k().toBigInteger();
    }

    @Override
    public BigDecimal primComponentGetAsBigDecimalSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return BigDecimal.ZERO;
        }
        if (component < 2) {
            if (component == 0) {
                return this.r();
            }
            return this.i();
        }
        if (component == 2) {
            return this.j();
        }
        return this.k();
    }

    @Override
    public void primitiveInit() {
        this.j = this.k = BigDecimal.ZERO;
        this.i = this.k;
        this.r = this.k;
    }

    @Override
    public void setR(HighPrecisionMember val) {
        this.setR(val.v());
    }

    @Override
    public void setI(HighPrecisionMember val) {
        this.setI(val.v());
    }

    @Override
    public void setJ(HighPrecisionMember val) {
        this.setJ(val.v());
    }

    @Override
    public void setK(HighPrecisionMember val) {
        this.setK(val.v());
    }

    @Override
    public void getR(HighPrecisionMember v) {
        v.setV(this.r);
    }

    @Override
    public void getI(HighPrecisionMember v) {
        v.setV(this.i);
    }

    @Override
    public void getJ(HighPrecisionMember v) {
        v.setV(this.j);
    }

    @Override
    public void getK(HighPrecisionMember v) {
        v.setV(this.k);
    }
}

