/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.highprec.real;

import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.Copy;
import nom.bdezonia.zorbage.algorithm.FixedTransform2;
import nom.bdezonia.zorbage.algorithm.SequenceIsZero;
import nom.bdezonia.zorbage.algorithm.SequencesSimilar;
import nom.bdezonia.zorbage.algorithm.ShapesMatch;
import nom.bdezonia.zorbage.algorithm.TensorCommaDerivative;
import nom.bdezonia.zorbage.algorithm.TensorContract;
import nom.bdezonia.zorbage.algorithm.TensorNorm;
import nom.bdezonia.zorbage.algorithm.TensorOuterProduct;
import nom.bdezonia.zorbage.algorithm.TensorPower;
import nom.bdezonia.zorbage.algorithm.TensorSemicolonDerivative;
import nom.bdezonia.zorbage.algorithm.TensorShape;
import nom.bdezonia.zorbage.algorithm.TensorUnity;
import nom.bdezonia.zorbage.algorithm.Transform2;
import nom.bdezonia.zorbage.algorithm.Transform3;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.procedure.Procedure5;
import nom.bdezonia.zorbage.type.algebra.Norm;
import nom.bdezonia.zorbage.type.algebra.Scale;
import nom.bdezonia.zorbage.type.algebra.ScaleByDouble;
import nom.bdezonia.zorbage.type.algebra.ScaleByHighPrec;
import nom.bdezonia.zorbage.type.algebra.ScaleByRational;
import nom.bdezonia.zorbage.type.algebra.TensorProduct;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.ctor.ConstructibleNdLong;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionAlgebra;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionCartesianTensorProductMember;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class HighPrecisionCartesianTensorProduct
implements TensorProduct<HighPrecisionCartesianTensorProduct, HighPrecisionCartesianTensorProductMember, HighPrecisionAlgebra, HighPrecisionMember>,
ConstructibleNdLong<HighPrecisionCartesianTensorProductMember>,
Norm<HighPrecisionCartesianTensorProductMember, HighPrecisionMember>,
Scale<HighPrecisionCartesianTensorProductMember, HighPrecisionMember>,
ScaleByHighPrec<HighPrecisionCartesianTensorProductMember>,
ScaleByRational<HighPrecisionCartesianTensorProductMember>,
ScaleByDouble<HighPrecisionCartesianTensorProductMember>,
Tolerance<HighPrecisionMember, HighPrecisionCartesianTensorProductMember> {
    private final Function2<Boolean, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember> EQ = new Function2<Boolean, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember>(){

        @Override
        public Boolean call(HighPrecisionCartesianTensorProductMember a, HighPrecisionCartesianTensorProductMember b) {
            if (!ShapesMatch.compute(a, b)) {
                return false;
            }
            return SequencesSimilar.compute(G.HP, G.HP.construct(), a.rawData(), b.rawData());
        }
    };
    private final Function2<Boolean, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember> NEQ = new Function2<Boolean, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember>(){

        @Override
        public Boolean call(HighPrecisionCartesianTensorProductMember a, HighPrecisionCartesianTensorProductMember b) {
            return HighPrecisionCartesianTensorProduct.this.isEqual().call(a, b) == false;
        }
    };
    private final Procedure2<HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember> ASSIGN = new Procedure2<HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(HighPrecisionCartesianTensorProductMember from, HighPrecisionCartesianTensorProductMember to) {
            TensorShape.compute(from, to);
            Copy.compute(G.HP, from.rawData(), to.rawData());
        }
    };
    private final Procedure1<HighPrecisionCartesianTensorProductMember> ZER = new Procedure1<HighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(HighPrecisionCartesianTensorProductMember a) {
            a.primitiveInit();
        }
    };
    private final Procedure2<HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember> NEG = new Procedure2<HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(HighPrecisionCartesianTensorProductMember a, HighPrecisionCartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            Transform2.compute(G.HP, G.HP.negate(), a.rawData(), b.rawData());
        }
    };
    private final Procedure3<HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember> ADDEL = new Procedure3<HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(HighPrecisionCartesianTensorProductMember a, HighPrecisionCartesianTensorProductMember b, HighPrecisionCartesianTensorProductMember c) {
            if (!ShapesMatch.compute(a, b)) {
                throw new IllegalArgumentException("tensor add shape mismatch");
            }
            TensorShape.compute(a, c);
            Transform3.compute(G.HP, G.HP.add(), a.rawData(), b.rawData(), c.rawData());
        }
    };
    private final Procedure3<HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember> SUBEL = new Procedure3<HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(HighPrecisionCartesianTensorProductMember a, HighPrecisionCartesianTensorProductMember b, HighPrecisionCartesianTensorProductMember c) {
            if (!ShapesMatch.compute(a, b)) {
                throw new IllegalArgumentException("tensor subtract shape mismatch");
            }
            TensorShape.compute(a, c);
            Transform3.compute(G.HP, G.HP.subtract(), a.rawData(), b.rawData(), c.rawData());
        }
    };
    private final Procedure2<HighPrecisionCartesianTensorProductMember, HighPrecisionMember> NORM = new Procedure2<HighPrecisionCartesianTensorProductMember, HighPrecisionMember>(){

        @Override
        public void call(HighPrecisionCartesianTensorProductMember a, HighPrecisionMember b) {
            TensorNorm.compute(G.HP, G.HP, a.rawData(), b);
        }
    };
    private final Procedure3<HighPrecisionMember, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember> SCALE = new Procedure3<HighPrecisionMember, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(HighPrecisionMember scalar, HighPrecisionCartesianTensorProductMember a, HighPrecisionCartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            nom.bdezonia.zorbage.algorithm.Scale.compute(G.HP, scalar, a.rawData(), b.rawData());
        }
    };
    private final Procedure3<HighPrecisionMember, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember> ADDSCALAR = new Procedure3<HighPrecisionMember, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(HighPrecisionMember scalar, HighPrecisionCartesianTensorProductMember a, HighPrecisionCartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            FixedTransform2.compute(G.HP, scalar, G.HP.add(), a.rawData(), b.rawData());
        }
    };
    private final Procedure3<HighPrecisionMember, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember> SUBSCALAR = new Procedure3<HighPrecisionMember, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(HighPrecisionMember scalar, HighPrecisionCartesianTensorProductMember a, HighPrecisionCartesianTensorProductMember b) {
            HighPrecisionMember tmp = G.HP.construct();
            G.HP.negate().call(scalar, tmp);
            HighPrecisionCartesianTensorProduct.this.addScalar().call(tmp, a, b);
        }
    };
    private Procedure3<HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember> MULEL = new Procedure3<HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(HighPrecisionCartesianTensorProductMember a, HighPrecisionCartesianTensorProductMember b, HighPrecisionCartesianTensorProductMember c) {
            if (!ShapesMatch.compute(a, b)) {
                throw new IllegalArgumentException("mismatched shapes");
            }
            TensorShape.compute(a, c);
            Transform3.compute(G.HP, G.HP.multiply(), a.rawData(), b.rawData(), c.rawData());
        }
    };
    private Procedure3<HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember> DIVIDEEL = new Procedure3<HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(HighPrecisionCartesianTensorProductMember a, HighPrecisionCartesianTensorProductMember b, HighPrecisionCartesianTensorProductMember c) {
            if (!ShapesMatch.compute(a, b)) {
                throw new IllegalArgumentException("mismatched shapes");
            }
            TensorShape.compute(a, c);
            Transform3.compute(G.HP, G.HP.divide(), a.rawData(), b.rawData(), c.rawData());
        }
    };
    private final Procedure3<HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember> MUL = new Procedure3<HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(HighPrecisionCartesianTensorProductMember a, HighPrecisionCartesianTensorProductMember b, HighPrecisionCartesianTensorProductMember c) {
            HighPrecisionCartesianTensorProduct.this.outerProduct().call(a, b, c);
        }
    };
    private final Procedure4<Integer, Integer, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember> CONTRACT = new Procedure4<Integer, Integer, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(Integer i, Integer j, HighPrecisionCartesianTensorProductMember a, HighPrecisionCartesianTensorProductMember b) {
            TensorContract.compute(G.HP, a.rank(), i, j, a, b);
        }
    };
    private final Procedure3<Integer, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember> SEMI = new Procedure3<Integer, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(Integer index, HighPrecisionCartesianTensorProductMember a, HighPrecisionCartesianTensorProductMember b) {
            TensorSemicolonDerivative.compute(G.HP_TEN, G.HP, index, a, b);
        }
    };
    private final Procedure3<Integer, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember> COMMA = new Procedure3<Integer, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(Integer index, HighPrecisionCartesianTensorProductMember a, HighPrecisionCartesianTensorProductMember b) {
            TensorCommaDerivative.compute(G.HP_TEN, G.HP, index, a, b);
        }
    };
    private final Procedure3<Integer, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember> POWER = new Procedure3<Integer, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(Integer power, HighPrecisionCartesianTensorProductMember a, HighPrecisionCartesianTensorProductMember b) {
            TensorPower.compute(G.HP_TEN, power, a, b);
        }
    };
    private final Procedure1<HighPrecisionCartesianTensorProductMember> UNITY = new Procedure1<HighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(HighPrecisionCartesianTensorProductMember result) {
            TensorUnity.compute(G.HP_TEN, G.HP, result);
        }
    };
    private final Function1<Boolean, HighPrecisionCartesianTensorProductMember> ISZERO = new Function1<Boolean, HighPrecisionCartesianTensorProductMember>(){

        @Override
        public Boolean call(HighPrecisionCartesianTensorProductMember a) {
            return SequenceIsZero.compute(G.HP, a.rawData());
        }
    };
    private final Procedure3<RationalMember, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember> SBR = new Procedure3<RationalMember, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(RationalMember factor, HighPrecisionCartesianTensorProductMember a, HighPrecisionCartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            nom.bdezonia.zorbage.algorithm.ScaleByRational.compute(G.HP, factor, a.rawData(), b.rawData());
        }
    };
    private final Procedure3<Double, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember> SBD = new Procedure3<Double, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(Double factor, HighPrecisionCartesianTensorProductMember a, HighPrecisionCartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            nom.bdezonia.zorbage.algorithm.ScaleByDouble.compute(G.HP, factor, a.rawData(), b.rawData());
        }
    };
    private final Procedure3<HighPrecisionMember, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember> SBHP = new Procedure3<HighPrecisionMember, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(HighPrecisionMember factor, HighPrecisionCartesianTensorProductMember a, HighPrecisionCartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            nom.bdezonia.zorbage.algorithm.ScaleByHighPrec.compute(G.HP, factor, a.rawData(), b.rawData());
        }
    };
    private final Function3<Boolean, HighPrecisionMember, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember> WITHIN = new Function3<Boolean, HighPrecisionMember, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember>(){

        @Override
        public Boolean call(HighPrecisionMember tol, HighPrecisionCartesianTensorProductMember a, HighPrecisionCartesianTensorProductMember b) {
            if (!ShapesMatch.compute(a, b)) {
                return false;
            }
            return SequencesSimilar.compute(G.HP, tol, a.rawData(), b.rawData());
        }
    };
    private final Procedure3<HighPrecisionMember, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember> MULBYSCALAR = new Procedure3<HighPrecisionMember, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(HighPrecisionMember factor, HighPrecisionCartesianTensorProductMember a, HighPrecisionCartesianTensorProductMember b) {
            HighPrecisionCartesianTensorProduct.this.scale().call(factor, a, b);
        }
    };
    private final Procedure3<HighPrecisionMember, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember> DIVBYSCALAR = new Procedure3<HighPrecisionMember, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(HighPrecisionMember factor, HighPrecisionCartesianTensorProductMember a, HighPrecisionCartesianTensorProductMember b) {
            HighPrecisionMember invFactor = G.HP.construct();
            G.HP.invert().call(factor, invFactor);
            HighPrecisionCartesianTensorProduct.this.scale().call(invFactor, a, b);
        }
    };
    private final Procedure3<Integer, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember> RAISE = new Procedure3<Integer, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(Integer idx, HighPrecisionCartesianTensorProductMember a, HighPrecisionCartesianTensorProductMember b) {
            throw new IllegalArgumentException("cannot raise index of a cartesian tensor");
        }
    };
    private final Procedure3<Integer, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember> LOWER = new Procedure3<Integer, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(Integer idx, HighPrecisionCartesianTensorProductMember a, HighPrecisionCartesianTensorProductMember b) {
            if (idx < 0 || idx >= a.rank()) {
                throw new IllegalArgumentException("index outside rank bounds in lowerIndex");
            }
            HighPrecisionCartesianTensorProduct.this.assign().call(a, b);
        }
    };
    private final Procedure5<Integer, Integer, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember> INNER = new Procedure5<Integer, Integer, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(Integer aIndex, Integer bIndex, HighPrecisionCartesianTensorProductMember a, HighPrecisionCartesianTensorProductMember b, HighPrecisionCartesianTensorProductMember c) {
            if (aIndex < 0 || bIndex < 0) {
                throw new IllegalArgumentException("tensor innerProduct() cannot handle negative indices");
            }
            if (aIndex >= a.rank() || bIndex >= b.rank()) {
                throw new IllegalArgumentException("tensor innerProduct() cannot handle out of bounds indices");
            }
            HighPrecisionCartesianTensorProductMember tmp = HighPrecisionCartesianTensorProduct.this.construct();
            HighPrecisionCartesianTensorProduct.this.outerProduct().call(a, b, tmp);
            HighPrecisionCartesianTensorProduct.this.contract().call(aIndex, a.rank() + bIndex, tmp, c);
        }
    };
    private final Procedure3<HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember> OUTER = new Procedure3<HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(HighPrecisionCartesianTensorProductMember a, HighPrecisionCartesianTensorProductMember b, HighPrecisionCartesianTensorProductMember c) {
            TensorOuterProduct.compute(G.HP_TEN, G.HP, a, b, c);
        }
    };

    @Override
    public HighPrecisionCartesianTensorProductMember construct() {
        return new HighPrecisionCartesianTensorProductMember();
    }

    @Override
    public HighPrecisionCartesianTensorProductMember construct(HighPrecisionCartesianTensorProductMember other) {
        return new HighPrecisionCartesianTensorProductMember(other);
    }

    @Override
    public HighPrecisionCartesianTensorProductMember construct(String s) {
        return new HighPrecisionCartesianTensorProductMember(s);
    }

    @Override
    public HighPrecisionCartesianTensorProductMember construct(StorageConstruction s, long[] nd) {
        return new HighPrecisionCartesianTensorProductMember(s, nd);
    }

    @Override
    public Function2<Boolean, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure1<HighPrecisionCartesianTensorProductMember> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember> add() {
        return this.ADDEL;
    }

    @Override
    public Procedure3<HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember> subtract() {
        return this.SUBEL;
    }

    @Override
    public Procedure2<HighPrecisionCartesianTensorProductMember, HighPrecisionMember> norm() {
        return this.NORM;
    }

    @Override
    public Procedure2<HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember> conjugate() {
        return this.ASSIGN;
    }

    @Override
    public Procedure3<HighPrecisionMember, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember> scale() {
        return this.SCALE;
    }

    @Override
    public Procedure3<HighPrecisionMember, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember> addScalar() {
        return this.ADDSCALAR;
    }

    @Override
    public Procedure3<HighPrecisionMember, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember> subtractScalar() {
        return this.SUBSCALAR;
    }

    @Override
    public Procedure3<HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember> multiplyElements() {
        return this.MULEL;
    }

    @Override
    public Procedure3<HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember> divideElements() {
        return this.DIVIDEEL;
    }

    @Override
    public Procedure3<HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure4<Integer, Integer, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember> contract() {
        return this.CONTRACT;
    }

    @Override
    public Procedure3<Integer, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember> semicolonDerivative() {
        return this.SEMI;
    }

    @Override
    public Procedure3<Integer, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember> commaDerivative() {
        return this.COMMA;
    }

    @Override
    public Procedure3<Integer, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<HighPrecisionCartesianTensorProductMember> unity() {
        return this.UNITY;
    }

    @Override
    public Function1<Boolean, HighPrecisionCartesianTensorProductMember> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<RationalMember, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<HighPrecisionMember, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Function3<Boolean, HighPrecisionMember, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember> within() {
        return this.WITHIN;
    }

    @Override
    public Procedure3<HighPrecisionMember, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember> multiplyByScalar() {
        return this.MULBYSCALAR;
    }

    @Override
    public Procedure3<HighPrecisionMember, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember> divideByScalar() {
        return this.DIVBYSCALAR;
    }

    @Override
    public Procedure3<Integer, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember> raiseIndex() {
        return this.RAISE;
    }

    @Override
    public Procedure3<Integer, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember> lowerIndex() {
        return this.LOWER;
    }

    @Override
    public Procedure5<Integer, Integer, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember> innerProduct() {
        return this.INNER;
    }

    @Override
    public Procedure3<HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember, HighPrecisionCartesianTensorProductMember> outerProduct() {
        return this.OUTER;
    }
}

