/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.highprec.real;

import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.MatrixAddition;
import nom.bdezonia.zorbage.algorithm.MatrixAssign;
import nom.bdezonia.zorbage.algorithm.MatrixConstantDiagonal;
import nom.bdezonia.zorbage.algorithm.MatrixDeterminant;
import nom.bdezonia.zorbage.algorithm.MatrixDirectProduct;
import nom.bdezonia.zorbage.algorithm.MatrixEqual;
import nom.bdezonia.zorbage.algorithm.MatrixInvert;
import nom.bdezonia.zorbage.algorithm.MatrixMultiply;
import nom.bdezonia.zorbage.algorithm.MatrixNegate;
import nom.bdezonia.zorbage.algorithm.MatrixPower;
import nom.bdezonia.zorbage.algorithm.MatrixScale;
import nom.bdezonia.zorbage.algorithm.MatrixScaleByDouble;
import nom.bdezonia.zorbage.algorithm.MatrixScaleByHighPrec;
import nom.bdezonia.zorbage.algorithm.MatrixScaleByRational;
import nom.bdezonia.zorbage.algorithm.MatrixSpectralNorm;
import nom.bdezonia.zorbage.algorithm.MatrixSubtraction;
import nom.bdezonia.zorbage.algorithm.MatrixTranspose;
import nom.bdezonia.zorbage.algorithm.MatrixUnity;
import nom.bdezonia.zorbage.algorithm.SequenceIsZero;
import nom.bdezonia.zorbage.algorithm.SequencesSimilar;
import nom.bdezonia.zorbage.algorithm.Sinc;
import nom.bdezonia.zorbage.algorithm.Sinch;
import nom.bdezonia.zorbage.algorithm.Sinchpi;
import nom.bdezonia.zorbage.algorithm.Sincpi;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateCos;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateCosh;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateExp;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateLog;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateSin;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateSinh;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.type.algebra.DirectProduct;
import nom.bdezonia.zorbage.type.algebra.Exponential;
import nom.bdezonia.zorbage.type.algebra.Hyperbolic;
import nom.bdezonia.zorbage.type.algebra.MatrixRing;
import nom.bdezonia.zorbage.type.algebra.Norm;
import nom.bdezonia.zorbage.type.algebra.RealConstants;
import nom.bdezonia.zorbage.type.algebra.RingWithUnity;
import nom.bdezonia.zorbage.type.algebra.ScaleByDouble;
import nom.bdezonia.zorbage.type.algebra.ScaleByHighPrec;
import nom.bdezonia.zorbage.type.algebra.ScaleByRational;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.algebra.Trigonometric;
import nom.bdezonia.zorbage.type.ctor.Constructible2dLong;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionAlgebra;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMatrixMember;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class HighPrecisionMatrix
implements RingWithUnity<HighPrecisionMatrix, HighPrecisionMatrixMember>,
MatrixRing<HighPrecisionMatrix, HighPrecisionMatrixMember, HighPrecisionAlgebra, HighPrecisionMember>,
Constructible2dLong<HighPrecisionMatrixMember>,
Norm<HighPrecisionMatrixMember, HighPrecisionMember>,
DirectProduct<HighPrecisionMatrixMember, HighPrecisionMatrixMember>,
Exponential<HighPrecisionMatrixMember>,
Trigonometric<HighPrecisionMatrixMember>,
Hyperbolic<HighPrecisionMatrixMember>,
RealConstants<HighPrecisionMatrixMember>,
ScaleByHighPrec<HighPrecisionMatrixMember>,
ScaleByRational<HighPrecisionMatrixMember>,
ScaleByDouble<HighPrecisionMatrixMember>,
Tolerance<HighPrecisionMember, HighPrecisionMatrixMember> {
    private final Procedure3<HighPrecisionMatrixMember, HighPrecisionMatrixMember, HighPrecisionMatrixMember> MUL = new Procedure3<HighPrecisionMatrixMember, HighPrecisionMatrixMember, HighPrecisionMatrixMember>(){

        @Override
        public void call(HighPrecisionMatrixMember a, HighPrecisionMatrixMember b, HighPrecisionMatrixMember c) {
            MatrixMultiply.compute(G.HP, a, b, c);
        }
    };
    private final Procedure3<Integer, HighPrecisionMatrixMember, HighPrecisionMatrixMember> POWER = new Procedure3<Integer, HighPrecisionMatrixMember, HighPrecisionMatrixMember>(){

        @Override
        public void call(Integer power, HighPrecisionMatrixMember a, HighPrecisionMatrixMember b) {
            MatrixPower.compute(power, G.HP, G.HP_VEC, G.HP_MAT, a, b);
        }
    };
    private final Procedure1<HighPrecisionMatrixMember> ZER = new Procedure1<HighPrecisionMatrixMember>(){

        @Override
        public void call(HighPrecisionMatrixMember a) {
            a.primitiveInit();
        }
    };
    private final Procedure2<HighPrecisionMatrixMember, HighPrecisionMatrixMember> NEG = new Procedure2<HighPrecisionMatrixMember, HighPrecisionMatrixMember>(){

        @Override
        public void call(HighPrecisionMatrixMember a, HighPrecisionMatrixMember b) {
            MatrixNegate.compute(G.HP, a, b);
        }
    };
    private final Procedure3<HighPrecisionMatrixMember, HighPrecisionMatrixMember, HighPrecisionMatrixMember> ADD = new Procedure3<HighPrecisionMatrixMember, HighPrecisionMatrixMember, HighPrecisionMatrixMember>(){

        @Override
        public void call(HighPrecisionMatrixMember a, HighPrecisionMatrixMember b, HighPrecisionMatrixMember c) {
            MatrixAddition.compute(G.HP, a, b, c);
        }
    };
    private final Procedure3<HighPrecisionMatrixMember, HighPrecisionMatrixMember, HighPrecisionMatrixMember> SUB = new Procedure3<HighPrecisionMatrixMember, HighPrecisionMatrixMember, HighPrecisionMatrixMember>(){

        @Override
        public void call(HighPrecisionMatrixMember a, HighPrecisionMatrixMember b, HighPrecisionMatrixMember c) {
            MatrixSubtraction.compute(G.HP, a, b, c);
        }
    };
    private final Function2<Boolean, HighPrecisionMatrixMember, HighPrecisionMatrixMember> EQ = new Function2<Boolean, HighPrecisionMatrixMember, HighPrecisionMatrixMember>(){

        @Override
        public Boolean call(HighPrecisionMatrixMember a, HighPrecisionMatrixMember b) {
            return MatrixEqual.compute(G.HP, a, b);
        }
    };
    private final Function2<Boolean, HighPrecisionMatrixMember, HighPrecisionMatrixMember> NEQ = new Function2<Boolean, HighPrecisionMatrixMember, HighPrecisionMatrixMember>(){

        @Override
        public Boolean call(HighPrecisionMatrixMember a, HighPrecisionMatrixMember b) {
            return HighPrecisionMatrix.this.isEqual().call(a, b) == false;
        }
    };
    private final Procedure2<HighPrecisionMatrixMember, HighPrecisionMatrixMember> ASSIGN = new Procedure2<HighPrecisionMatrixMember, HighPrecisionMatrixMember>(){

        @Override
        public void call(HighPrecisionMatrixMember from, HighPrecisionMatrixMember to) {
            MatrixAssign.compute(G.HP, from, to);
        }
    };
    private final Procedure2<HighPrecisionMatrixMember, HighPrecisionMember> NORM = new Procedure2<HighPrecisionMatrixMember, HighPrecisionMember>(){

        @Override
        public void call(HighPrecisionMatrixMember a, HighPrecisionMember b) {
            MatrixSpectralNorm.compute(G.HP_MAT, G.HP, a, b);
        }
    };
    private final Procedure2<HighPrecisionMatrixMember, HighPrecisionMatrixMember> TRANSP = new Procedure2<HighPrecisionMatrixMember, HighPrecisionMatrixMember>(){

        @Override
        public void call(HighPrecisionMatrixMember a, HighPrecisionMatrixMember b) {
            MatrixTranspose.compute(G.HP, a, b);
        }
    };
    private final Procedure2<HighPrecisionMatrixMember, HighPrecisionMatrixMember> CONJTRANSP = new Procedure2<HighPrecisionMatrixMember, HighPrecisionMatrixMember>(){

        @Override
        public void call(HighPrecisionMatrixMember a, HighPrecisionMatrixMember b) {
            HighPrecisionMatrix.this.transpose().call(a, b);
        }
    };
    private final Procedure2<HighPrecisionMatrixMember, HighPrecisionMember> DET = new Procedure2<HighPrecisionMatrixMember, HighPrecisionMember>(){

        @Override
        public void call(HighPrecisionMatrixMember a, HighPrecisionMember b) {
            MatrixDeterminant.compute(G.HP_MAT, G.HP, a, b);
        }
    };
    private final Procedure1<HighPrecisionMatrixMember> UNITY = new Procedure1<HighPrecisionMatrixMember>(){

        @Override
        public void call(HighPrecisionMatrixMember a) {
            MatrixUnity.compute(G.HP, a);
        }
    };
    private final Procedure2<HighPrecisionMatrixMember, HighPrecisionMatrixMember> INV = new Procedure2<HighPrecisionMatrixMember, HighPrecisionMatrixMember>(){

        @Override
        public void call(HighPrecisionMatrixMember a, HighPrecisionMatrixMember b) {
            MatrixInvert.compute(G.HP, G.HP_VEC, G.HP_MAT, a, b);
        }
    };
    private final Procedure3<HighPrecisionMatrixMember, HighPrecisionMatrixMember, HighPrecisionMatrixMember> DIVIDE = new Procedure3<HighPrecisionMatrixMember, HighPrecisionMatrixMember, HighPrecisionMatrixMember>(){

        @Override
        public void call(HighPrecisionMatrixMember a, HighPrecisionMatrixMember b, HighPrecisionMatrixMember c) {
            HighPrecisionMatrixMember invB = HighPrecisionMatrix.this.construct(b.storageType(), b.rows(), b.cols());
            HighPrecisionMatrix.this.invert().call(b, invB);
            HighPrecisionMatrix.this.multiply().call(a, invB, c);
        }
    };
    private final Procedure3<HighPrecisionMatrixMember, HighPrecisionMatrixMember, HighPrecisionMatrixMember> DP = new Procedure3<HighPrecisionMatrixMember, HighPrecisionMatrixMember, HighPrecisionMatrixMember>(){

        @Override
        public void call(HighPrecisionMatrixMember in1, HighPrecisionMatrixMember in2, HighPrecisionMatrixMember out) {
            MatrixDirectProduct.compute(G.HP, in1, in2, out);
        }
    };
    private final Procedure3<HighPrecisionMember, HighPrecisionMatrixMember, HighPrecisionMatrixMember> SCALE = new Procedure3<HighPrecisionMember, HighPrecisionMatrixMember, HighPrecisionMatrixMember>(){

        @Override
        public void call(HighPrecisionMember a, HighPrecisionMatrixMember b, HighPrecisionMatrixMember c) {
            MatrixScale.compute(G.HP, a, b, c);
        }
    };
    private final Procedure2<HighPrecisionMatrixMember, HighPrecisionMatrixMember> SINH = new Procedure2<HighPrecisionMatrixMember, HighPrecisionMatrixMember>(){

        @Override
        public void call(HighPrecisionMatrixMember a, HighPrecisionMatrixMember b) {
            TaylorEstimateSinh.compute(18, G.HP_MAT, G.HP, a, b);
        }
    };
    private final Procedure2<HighPrecisionMatrixMember, HighPrecisionMatrixMember> COSH = new Procedure2<HighPrecisionMatrixMember, HighPrecisionMatrixMember>(){

        @Override
        public void call(HighPrecisionMatrixMember a, HighPrecisionMatrixMember b) {
            TaylorEstimateCosh.compute(18, G.HP_MAT, G.HP, a, b);
        }
    };
    private final Procedure3<HighPrecisionMatrixMember, HighPrecisionMatrixMember, HighPrecisionMatrixMember> SINHANDCOSH = new Procedure3<HighPrecisionMatrixMember, HighPrecisionMatrixMember, HighPrecisionMatrixMember>(){

        @Override
        public void call(HighPrecisionMatrixMember a, HighPrecisionMatrixMember s, HighPrecisionMatrixMember c) {
            HighPrecisionMatrix.this.sinh().call(a, s);
            HighPrecisionMatrix.this.cosh().call(a, c);
        }
    };
    private final Procedure2<HighPrecisionMatrixMember, HighPrecisionMatrixMember> TANH = new Procedure2<HighPrecisionMatrixMember, HighPrecisionMatrixMember>(){

        @Override
        public void call(HighPrecisionMatrixMember a, HighPrecisionMatrixMember b) {
            HighPrecisionMatrixMember s = G.HP_MAT.construct();
            HighPrecisionMatrixMember c = G.HP_MAT.construct();
            HighPrecisionMatrix.this.sinhAndCosh().call(a, s, c);
            HighPrecisionMatrix.this.divide().call(s, c, b);
        }
    };
    private final Procedure2<HighPrecisionMatrixMember, HighPrecisionMatrixMember> SINCH = new Procedure2<HighPrecisionMatrixMember, HighPrecisionMatrixMember>(){

        @Override
        public void call(HighPrecisionMatrixMember a, HighPrecisionMatrixMember b) {
            Sinch.compute(G.HP_MAT, a, b);
        }
    };
    private final Procedure2<HighPrecisionMatrixMember, HighPrecisionMatrixMember> SINCHPI = new Procedure2<HighPrecisionMatrixMember, HighPrecisionMatrixMember>(){

        @Override
        public void call(HighPrecisionMatrixMember a, HighPrecisionMatrixMember b) {
            Sinchpi.compute(G.HP_MAT, a, b);
        }
    };
    private final Procedure2<HighPrecisionMatrixMember, HighPrecisionMatrixMember> SIN = new Procedure2<HighPrecisionMatrixMember, HighPrecisionMatrixMember>(){

        @Override
        public void call(HighPrecisionMatrixMember a, HighPrecisionMatrixMember b) {
            TaylorEstimateSin.compute(18, G.HP_MAT, G.HP, a, b);
        }
    };
    private final Procedure2<HighPrecisionMatrixMember, HighPrecisionMatrixMember> COS = new Procedure2<HighPrecisionMatrixMember, HighPrecisionMatrixMember>(){

        @Override
        public void call(HighPrecisionMatrixMember a, HighPrecisionMatrixMember b) {
            TaylorEstimateCos.compute(18, G.HP_MAT, G.HP, a, b);
        }
    };
    private final Procedure2<HighPrecisionMatrixMember, HighPrecisionMatrixMember> TAN = new Procedure2<HighPrecisionMatrixMember, HighPrecisionMatrixMember>(){

        @Override
        public void call(HighPrecisionMatrixMember a, HighPrecisionMatrixMember b) {
            HighPrecisionMatrixMember s = G.HP_MAT.construct();
            HighPrecisionMatrixMember c = G.HP_MAT.construct();
            HighPrecisionMatrix.this.sinAndCos().call(a, s, c);
            HighPrecisionMatrix.this.divide().call(s, c, b);
        }
    };
    private final Procedure3<HighPrecisionMatrixMember, HighPrecisionMatrixMember, HighPrecisionMatrixMember> SINANDCOS = new Procedure3<HighPrecisionMatrixMember, HighPrecisionMatrixMember, HighPrecisionMatrixMember>(){

        @Override
        public void call(HighPrecisionMatrixMember a, HighPrecisionMatrixMember s, HighPrecisionMatrixMember c) {
            HighPrecisionMatrix.this.sin().call(a, s);
            HighPrecisionMatrix.this.cos().call(a, c);
        }
    };
    private final Procedure2<HighPrecisionMatrixMember, HighPrecisionMatrixMember> SINC = new Procedure2<HighPrecisionMatrixMember, HighPrecisionMatrixMember>(){

        @Override
        public void call(HighPrecisionMatrixMember a, HighPrecisionMatrixMember b) {
            Sinc.compute(G.HP_MAT, a, b);
        }
    };
    private final Procedure2<HighPrecisionMatrixMember, HighPrecisionMatrixMember> SINCPI = new Procedure2<HighPrecisionMatrixMember, HighPrecisionMatrixMember>(){

        @Override
        public void call(HighPrecisionMatrixMember a, HighPrecisionMatrixMember b) {
            Sincpi.compute(G.HP_MAT, a, b);
        }
    };
    private final Procedure2<HighPrecisionMatrixMember, HighPrecisionMatrixMember> EXP = new Procedure2<HighPrecisionMatrixMember, HighPrecisionMatrixMember>(){

        @Override
        public void call(HighPrecisionMatrixMember a, HighPrecisionMatrixMember b) {
            TaylorEstimateExp.compute(35, G.HP_MAT, G.HP, a, b);
        }
    };
    private final Procedure2<HighPrecisionMatrixMember, HighPrecisionMatrixMember> LOG = new Procedure2<HighPrecisionMatrixMember, HighPrecisionMatrixMember>(){

        @Override
        public void call(HighPrecisionMatrixMember a, HighPrecisionMatrixMember b) {
            TaylorEstimateLog.compute(8, G.HP_MAT, G.HP, a, b);
        }
    };
    private final Function1<Boolean, HighPrecisionMatrixMember> ISZERO = new Function1<Boolean, HighPrecisionMatrixMember>(){

        @Override
        public Boolean call(HighPrecisionMatrixMember a) {
            return SequenceIsZero.compute(G.HP, a.rawData());
        }
    };
    private final Procedure1<HighPrecisionMatrixMember> PI = new Procedure1<HighPrecisionMatrixMember>(){

        @Override
        public void call(HighPrecisionMatrixMember a) {
            HighPrecisionMember pi = G.HP.construct();
            G.HP.PI().call(pi);
            MatrixConstantDiagonal.compute(G.HP, pi, a);
        }
    };
    private final Procedure1<HighPrecisionMatrixMember> E = new Procedure1<HighPrecisionMatrixMember>(){

        @Override
        public void call(HighPrecisionMatrixMember a) {
            HighPrecisionMember e = G.HP.construct();
            G.HP.E().call(e);
            MatrixConstantDiagonal.compute(G.HP, e, a);
        }
    };
    private final Procedure1<HighPrecisionMatrixMember> PHI = new Procedure1<HighPrecisionMatrixMember>(){

        @Override
        public void call(HighPrecisionMatrixMember a) {
            HighPrecisionMember phi = G.HP.construct();
            G.HP.PHI().call(phi);
            MatrixConstantDiagonal.compute(G.HP, phi, a);
        }
    };
    private final Procedure1<HighPrecisionMatrixMember> GAMMA = new Procedure1<HighPrecisionMatrixMember>(){

        @Override
        public void call(HighPrecisionMatrixMember a) {
            HighPrecisionMember gamma = G.HP.construct();
            G.HP.GAMMA().call(gamma);
            MatrixConstantDiagonal.compute(G.HP, gamma, a);
        }
    };
    private Procedure3<HighPrecisionMember, HighPrecisionMatrixMember, HighPrecisionMatrixMember> SBHP = new Procedure3<HighPrecisionMember, HighPrecisionMatrixMember, HighPrecisionMatrixMember>(){

        @Override
        public void call(HighPrecisionMember a, HighPrecisionMatrixMember b, HighPrecisionMatrixMember c) {
            MatrixScaleByHighPrec.compute(G.HP, a, b, c);
        }
    };
    private Procedure3<RationalMember, HighPrecisionMatrixMember, HighPrecisionMatrixMember> SBR = new Procedure3<RationalMember, HighPrecisionMatrixMember, HighPrecisionMatrixMember>(){

        @Override
        public void call(RationalMember a, HighPrecisionMatrixMember b, HighPrecisionMatrixMember c) {
            MatrixScaleByRational.compute(G.HP, a, b, c);
        }
    };
    private Procedure3<Double, HighPrecisionMatrixMember, HighPrecisionMatrixMember> SBD = new Procedure3<Double, HighPrecisionMatrixMember, HighPrecisionMatrixMember>(){

        @Override
        public void call(Double a, HighPrecisionMatrixMember b, HighPrecisionMatrixMember c) {
            MatrixScaleByDouble.compute(G.HP, a, b, c);
        }
    };
    private final Function3<Boolean, HighPrecisionMember, HighPrecisionMatrixMember, HighPrecisionMatrixMember> WITHIN = new Function3<Boolean, HighPrecisionMember, HighPrecisionMatrixMember, HighPrecisionMatrixMember>(){

        @Override
        public Boolean call(HighPrecisionMember tol, HighPrecisionMatrixMember a, HighPrecisionMatrixMember b) {
            if (a.rows() != b.rows() || a.cols() != b.cols()) {
                return false;
            }
            return SequencesSimilar.compute(G.HP, tol, a.rawData(), b.rawData());
        }
    };

    @Override
    public Procedure3<HighPrecisionMatrixMember, HighPrecisionMatrixMember, HighPrecisionMatrixMember> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<Integer, HighPrecisionMatrixMember, HighPrecisionMatrixMember> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<HighPrecisionMatrixMember> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<HighPrecisionMatrixMember, HighPrecisionMatrixMember> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<HighPrecisionMatrixMember, HighPrecisionMatrixMember, HighPrecisionMatrixMember> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<HighPrecisionMatrixMember, HighPrecisionMatrixMember, HighPrecisionMatrixMember> subtract() {
        return this.SUB;
    }

    @Override
    public Function2<Boolean, HighPrecisionMatrixMember, HighPrecisionMatrixMember> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, HighPrecisionMatrixMember, HighPrecisionMatrixMember> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<HighPrecisionMatrixMember, HighPrecisionMatrixMember> assign() {
        return this.ASSIGN;
    }

    @Override
    public HighPrecisionMatrixMember construct() {
        return new HighPrecisionMatrixMember();
    }

    @Override
    public HighPrecisionMatrixMember construct(HighPrecisionMatrixMember other) {
        return new HighPrecisionMatrixMember(other);
    }

    @Override
    public HighPrecisionMatrixMember construct(String s) {
        return new HighPrecisionMatrixMember(s);
    }

    @Override
    public HighPrecisionMatrixMember construct(StorageConstruction s, long d1, long d2) {
        return new HighPrecisionMatrixMember(s, d1, d2);
    }

    @Override
    public Procedure2<HighPrecisionMatrixMember, HighPrecisionMember> norm() {
        return this.NORM;
    }

    @Override
    public Procedure2<HighPrecisionMatrixMember, HighPrecisionMatrixMember> conjugate() {
        return this.ASSIGN;
    }

    @Override
    public Procedure2<HighPrecisionMatrixMember, HighPrecisionMatrixMember> transpose() {
        return this.TRANSP;
    }

    @Override
    public Procedure2<HighPrecisionMatrixMember, HighPrecisionMatrixMember> conjugateTranspose() {
        return this.CONJTRANSP;
    }

    @Override
    public Procedure2<HighPrecisionMatrixMember, HighPrecisionMember> det() {
        return this.DET;
    }

    @Override
    public Procedure1<HighPrecisionMatrixMember> unity() {
        return this.UNITY;
    }

    @Override
    public Procedure2<HighPrecisionMatrixMember, HighPrecisionMatrixMember> invert() {
        return this.INV;
    }

    @Override
    public Procedure3<HighPrecisionMatrixMember, HighPrecisionMatrixMember, HighPrecisionMatrixMember> divide() {
        return this.DIVIDE;
    }

    @Override
    public Procedure3<HighPrecisionMatrixMember, HighPrecisionMatrixMember, HighPrecisionMatrixMember> directProduct() {
        return this.DP;
    }

    @Override
    public Procedure3<HighPrecisionMember, HighPrecisionMatrixMember, HighPrecisionMatrixMember> scale() {
        return this.SCALE;
    }

    @Override
    public Procedure2<HighPrecisionMatrixMember, HighPrecisionMatrixMember> sinh() {
        return this.SINH;
    }

    @Override
    public Procedure2<HighPrecisionMatrixMember, HighPrecisionMatrixMember> cosh() {
        return this.COSH;
    }

    @Override
    public Procedure3<HighPrecisionMatrixMember, HighPrecisionMatrixMember, HighPrecisionMatrixMember> sinhAndCosh() {
        return this.SINHANDCOSH;
    }

    @Override
    public Procedure2<HighPrecisionMatrixMember, HighPrecisionMatrixMember> tanh() {
        return this.TANH;
    }

    @Override
    public Procedure2<HighPrecisionMatrixMember, HighPrecisionMatrixMember> sinch() {
        return this.SINCH;
    }

    @Override
    public Procedure2<HighPrecisionMatrixMember, HighPrecisionMatrixMember> sinchpi() {
        return this.SINCHPI;
    }

    @Override
    public Procedure2<HighPrecisionMatrixMember, HighPrecisionMatrixMember> sin() {
        return this.SIN;
    }

    @Override
    public Procedure2<HighPrecisionMatrixMember, HighPrecisionMatrixMember> cos() {
        return this.COS;
    }

    @Override
    public Procedure2<HighPrecisionMatrixMember, HighPrecisionMatrixMember> tan() {
        return this.TAN;
    }

    @Override
    public Procedure3<HighPrecisionMatrixMember, HighPrecisionMatrixMember, HighPrecisionMatrixMember> sinAndCos() {
        return this.SINANDCOS;
    }

    @Override
    public Procedure2<HighPrecisionMatrixMember, HighPrecisionMatrixMember> sinc() {
        return this.SINC;
    }

    @Override
    public Procedure2<HighPrecisionMatrixMember, HighPrecisionMatrixMember> sincpi() {
        return this.SINCPI;
    }

    @Override
    public Procedure2<HighPrecisionMatrixMember, HighPrecisionMatrixMember> exp() {
        return this.EXP;
    }

    @Override
    public Procedure2<HighPrecisionMatrixMember, HighPrecisionMatrixMember> log() {
        return this.LOG;
    }

    @Override
    public Function1<Boolean, HighPrecisionMatrixMember> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure1<HighPrecisionMatrixMember> PI() {
        return this.PI;
    }

    @Override
    public Procedure1<HighPrecisionMatrixMember> E() {
        return this.E;
    }

    @Override
    public Procedure1<HighPrecisionMatrixMember> PHI() {
        return this.PHI;
    }

    @Override
    public Procedure1<HighPrecisionMatrixMember> GAMMA() {
        return this.GAMMA;
    }

    @Override
    public Procedure3<HighPrecisionMember, HighPrecisionMatrixMember, HighPrecisionMatrixMember> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<RationalMember, HighPrecisionMatrixMember, HighPrecisionMatrixMember> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, HighPrecisionMatrixMember, HighPrecisionMatrixMember> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Function3<Boolean, HighPrecisionMember, HighPrecisionMatrixMember, HighPrecisionMatrixMember> within() {
        return this.WITHIN;
    }
}

