/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.int1;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.ThreadLocalRandom;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.type.algebra.AbsoluteValue;
import nom.bdezonia.zorbage.type.algebra.BitOperations;
import nom.bdezonia.zorbage.type.algebra.Bounded;
import nom.bdezonia.zorbage.type.algebra.EvenOdd;
import nom.bdezonia.zorbage.type.algebra.Ordered;
import nom.bdezonia.zorbage.type.algebra.PredSucc;
import nom.bdezonia.zorbage.type.algebra.Random;
import nom.bdezonia.zorbage.type.algebra.Ring;
import nom.bdezonia.zorbage.type.algebra.Scale;
import nom.bdezonia.zorbage.type.algebra.ScaleByDouble;
import nom.bdezonia.zorbage.type.algebra.ScaleByDoubleAndRound;
import nom.bdezonia.zorbage.type.algebra.ScaleByHighPrec;
import nom.bdezonia.zorbage.type.algebra.ScaleByHighPrecAndRound;
import nom.bdezonia.zorbage.type.algebra.ScaleByRational;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.int1.SignedInt1Member;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class SignedInt1Algebra
implements Ring<SignedInt1Algebra, SignedInt1Member>,
Ordered<SignedInt1Member>,
PredSucc<SignedInt1Member>,
EvenOdd<SignedInt1Member>,
Scale<SignedInt1Member, SignedInt1Member>,
Bounded<SignedInt1Member>,
AbsoluteValue<SignedInt1Member>,
BitOperations<SignedInt1Member>,
Random<SignedInt1Member>,
ScaleByHighPrec<SignedInt1Member>,
ScaleByHighPrecAndRound<SignedInt1Member>,
ScaleByRational<SignedInt1Member>,
ScaleByDouble<SignedInt1Member>,
ScaleByDoubleAndRound<SignedInt1Member> {
    private final Function2<Boolean, SignedInt1Member, SignedInt1Member> EQ = new Function2<Boolean, SignedInt1Member, SignedInt1Member>(){

        @Override
        public Boolean call(SignedInt1Member a, SignedInt1Member b) {
            return a.v == b.v;
        }
    };
    private final Function2<Boolean, SignedInt1Member, SignedInt1Member> NEQ = new Function2<Boolean, SignedInt1Member, SignedInt1Member>(){

        @Override
        public Boolean call(SignedInt1Member a, SignedInt1Member b) {
            return a.v != b.v;
        }
    };
    private final Procedure2<SignedInt1Member, SignedInt1Member> ASSIGN = new Procedure2<SignedInt1Member, SignedInt1Member>(){

        @Override
        public void call(SignedInt1Member a, SignedInt1Member b) {
            b.set(a);
        }
    };
    private final Procedure1<SignedInt1Member> ZER = new Procedure1<SignedInt1Member>(){

        @Override
        public void call(SignedInt1Member a) {
            a.v = 0;
        }
    };
    private final Procedure2<SignedInt1Member, SignedInt1Member> NEG = new Procedure2<SignedInt1Member, SignedInt1Member>(){

        @Override
        public void call(SignedInt1Member a, SignedInt1Member b) {
            if (a.v == -1) {
                throw new IllegalArgumentException("Cannot convert -minint symmetrically");
            }
            b.v = 0;
        }
    };
    private final Procedure3<SignedInt1Member, SignedInt1Member, SignedInt1Member> ADD = new Procedure3<SignedInt1Member, SignedInt1Member, SignedInt1Member>(){

        @Override
        public void call(SignedInt1Member a, SignedInt1Member b, SignedInt1Member c) {
            c.setV(a.v + b.v);
        }
    };
    private final Procedure3<SignedInt1Member, SignedInt1Member, SignedInt1Member> SUB = new Procedure3<SignedInt1Member, SignedInt1Member, SignedInt1Member>(){

        @Override
        public void call(SignedInt1Member a, SignedInt1Member b, SignedInt1Member c) {
            c.setV(a.v - b.v);
        }
    };
    private final Procedure3<SignedInt1Member, SignedInt1Member, SignedInt1Member> MUL = new Procedure3<SignedInt1Member, SignedInt1Member, SignedInt1Member>(){

        @Override
        public void call(SignedInt1Member a, SignedInt1Member b, SignedInt1Member c) {
            c.setV(a.v * b.v);
        }
    };
    private final Procedure3<Integer, SignedInt1Member, SignedInt1Member> POWER = new Procedure3<Integer, SignedInt1Member, SignedInt1Member>(){

        @Override
        public void call(Integer power, SignedInt1Member a, SignedInt1Member b) {
            if (power < 0) {
                throw new IllegalArgumentException("negative power of an integral type is impossible");
            }
            if (power == 0) {
                if (a.v == 0) {
                    throw new IllegalArgumentException("0^0 is not a number");
                }
                throw new IllegalArgumentException("1 bit signed int does not have the concept of 1");
            }
            b.v = power == 1 ? a.v : (byte)0;
        }
    };
    private final Function2<Boolean, SignedInt1Member, SignedInt1Member> LESS = new Function2<Boolean, SignedInt1Member, SignedInt1Member>(){

        @Override
        public Boolean call(SignedInt1Member a, SignedInt1Member b) {
            return a.v < b.v;
        }
    };
    private final Function2<Boolean, SignedInt1Member, SignedInt1Member> LE = new Function2<Boolean, SignedInt1Member, SignedInt1Member>(){

        @Override
        public Boolean call(SignedInt1Member a, SignedInt1Member b) {
            return a.v <= b.v;
        }
    };
    private final Function2<Boolean, SignedInt1Member, SignedInt1Member> GREAT = new Function2<Boolean, SignedInt1Member, SignedInt1Member>(){

        @Override
        public Boolean call(SignedInt1Member a, SignedInt1Member b) {
            return a.v > b.v;
        }
    };
    private final Function2<Boolean, SignedInt1Member, SignedInt1Member> GE = new Function2<Boolean, SignedInt1Member, SignedInt1Member>(){

        @Override
        public Boolean call(SignedInt1Member a, SignedInt1Member b) {
            return a.v >= b.v;
        }
    };
    private final Function2<Integer, SignedInt1Member, SignedInt1Member> CMP = new Function2<Integer, SignedInt1Member, SignedInt1Member>(){

        @Override
        public Integer call(SignedInt1Member a, SignedInt1Member b) {
            if (a.v < b.v) {
                return -1;
            }
            if (a.v > b.v) {
                return 1;
            }
            return 0;
        }
    };
    private final Function1<Integer, SignedInt1Member> SIG = new Function1<Integer, SignedInt1Member>(){

        @Override
        public Integer call(SignedInt1Member a) {
            if (a.v < 0) {
                return -1;
            }
            return 0;
        }
    };
    private final Procedure3<SignedInt1Member, SignedInt1Member, SignedInt1Member> MIN = new Procedure3<SignedInt1Member, SignedInt1Member, SignedInt1Member>(){

        @Override
        public void call(SignedInt1Member a, SignedInt1Member b, SignedInt1Member c) {
            if (a.v < b.v) {
                c.set(a);
            } else {
                c.set(b);
            }
        }
    };
    private final Procedure3<SignedInt1Member, SignedInt1Member, SignedInt1Member> MAX = new Procedure3<SignedInt1Member, SignedInt1Member, SignedInt1Member>(){

        @Override
        public void call(SignedInt1Member a, SignedInt1Member b, SignedInt1Member c) {
            if (a.v > b.v) {
                c.set(a);
            } else {
                c.set(b);
            }
        }
    };
    private final Procedure2<SignedInt1Member, SignedInt1Member> ABS = new Procedure2<SignedInt1Member, SignedInt1Member>(){

        @Override
        public void call(SignedInt1Member a, SignedInt1Member b) {
            if (a.v == -1) {
                throw new IllegalArgumentException("Cannot convert -minint symmetrically");
            }
            b.v = 0;
        }
    };
    private final Function1<Boolean, SignedInt1Member> EVEN = new Function1<Boolean, SignedInt1Member>(){

        @Override
        public Boolean call(SignedInt1Member a) {
            return a.v == 0;
        }
    };
    private final Function1<Boolean, SignedInt1Member> ODD = new Function1<Boolean, SignedInt1Member>(){

        @Override
        public Boolean call(SignedInt1Member a) {
            return a.v == -1;
        }
    };
    private final Procedure2<SignedInt1Member, SignedInt1Member> PRED = new Procedure2<SignedInt1Member, SignedInt1Member>(){

        @Override
        public void call(SignedInt1Member a, SignedInt1Member b) {
            b.v = a.v == 0 ? (byte)-1 : (byte)0;
        }
    };
    private final Procedure2<SignedInt1Member, SignedInt1Member> SUCC = new Procedure2<SignedInt1Member, SignedInt1Member>(){

        @Override
        public void call(SignedInt1Member a, SignedInt1Member b) {
            b.v = a.v == -1 ? (byte)0 : (byte)-1;
        }
    };
    private final Procedure1<SignedInt1Member> RAND = new Procedure1<SignedInt1Member>(){

        @Override
        public void call(SignedInt1Member a) {
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            a.v = rng.nextBoolean() ? (byte)-1 : (byte)0;
        }
    };
    private final Procedure3<SignedInt1Member, SignedInt1Member, SignedInt1Member> AND = new Procedure3<SignedInt1Member, SignedInt1Member, SignedInt1Member>(){

        @Override
        public void call(SignedInt1Member a, SignedInt1Member b, SignedInt1Member c) {
            c.setV(a.v & b.v);
        }
    };
    private final Procedure3<SignedInt1Member, SignedInt1Member, SignedInt1Member> OR = new Procedure3<SignedInt1Member, SignedInt1Member, SignedInt1Member>(){

        @Override
        public void call(SignedInt1Member a, SignedInt1Member b, SignedInt1Member c) {
            c.setV(a.v | b.v);
        }
    };
    private final Procedure3<SignedInt1Member, SignedInt1Member, SignedInt1Member> XOR = new Procedure3<SignedInt1Member, SignedInt1Member, SignedInt1Member>(){

        @Override
        public void call(SignedInt1Member a, SignedInt1Member b, SignedInt1Member c) {
            c.setV(a.v ^ b.v);
        }
    };
    private final Procedure2<SignedInt1Member, SignedInt1Member> NOT = new Procedure2<SignedInt1Member, SignedInt1Member>(){

        @Override
        public void call(SignedInt1Member a, SignedInt1Member b) {
            b.v = a.v == 0 ? (byte)-1 : (byte)0;
        }
    };
    private final Procedure3<SignedInt1Member, SignedInt1Member, SignedInt1Member> ANDNOT = new Procedure3<SignedInt1Member, SignedInt1Member, SignedInt1Member>(){

        @Override
        public void call(SignedInt1Member a, SignedInt1Member b, SignedInt1Member c) {
            c.v = a.v == 0 ? (byte)0 : (b.v == 0 ? (byte)-1 : (byte)0);
        }
    };
    private final Procedure3<Integer, SignedInt1Member, SignedInt1Member> SHL = new Procedure3<Integer, SignedInt1Member, SignedInt1Member>(){

        @Override
        public void call(Integer count, SignedInt1Member a, SignedInt1Member b) {
            if (count < 0) {
                SignedInt1Algebra.this.bitShiftRight().call(-count.intValue(), a, b);
            } else {
                count = count & 1;
                b.setV(a.v << count);
            }
        }
    };
    private final Procedure3<Integer, SignedInt1Member, SignedInt1Member> SHR = new Procedure3<Integer, SignedInt1Member, SignedInt1Member>(){

        @Override
        public void call(Integer count, SignedInt1Member a, SignedInt1Member b) {
            int val = a.v >> count;
            if (a.v < 0 && val == 0) {
                b.v = (byte)-1;
            } else {
                b.setV(val);
            }
        }
    };
    private final Procedure3<Integer, SignedInt1Member, SignedInt1Member> SHRZ = new Procedure3<Integer, SignedInt1Member, SignedInt1Member>(){

        @Override
        public void call(Integer count, SignedInt1Member a, SignedInt1Member b) {
            if (count < 0) {
                SignedInt1Algebra.this.bitShiftLeft().call(-count.intValue(), a, b);
            } else {
                b.setV(a.v >>> count);
            }
        }
    };
    private final Procedure1<SignedInt1Member> MAXBOUND = new Procedure1<SignedInt1Member>(){

        @Override
        public void call(SignedInt1Member a) {
            a.v = 0;
        }
    };
    private final Procedure1<SignedInt1Member> MINBOUND = new Procedure1<SignedInt1Member>(){

        @Override
        public void call(SignedInt1Member a) {
            a.v = (byte)-1;
        }
    };
    private final Function1<Boolean, SignedInt1Member> ISZERO = new Function1<Boolean, SignedInt1Member>(){

        @Override
        public Boolean call(SignedInt1Member a) {
            return a.v == 0;
        }
    };
    private final Procedure3<HighPrecisionMember, SignedInt1Member, SignedInt1Member> SBHP = new Procedure3<HighPrecisionMember, SignedInt1Member, SignedInt1Member>(){

        @Override
        public void call(HighPrecisionMember a, SignedInt1Member b, SignedInt1Member c) {
            BigDecimal tmp = a.v();
            tmp = tmp.multiply(new BigDecimal(b.v()));
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<HighPrecisionMember, SignedInt1Member, SignedInt1Member> SBHPR = new Procedure3<HighPrecisionMember, SignedInt1Member, SignedInt1Member>(){

        @Override
        public void call(HighPrecisionMember a, SignedInt1Member b, SignedInt1Member c) {
            BigDecimal tmp = a.v();
            int signum = (tmp = tmp.multiply(new BigDecimal(b.v()))).signum();
            tmp = signum < 0 ? tmp.subtract(G.ONE_HALF) : tmp.add(G.ONE_HALF);
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<RationalMember, SignedInt1Member, SignedInt1Member> SBR = new Procedure3<RationalMember, SignedInt1Member, SignedInt1Member>(){

        @Override
        public void call(RationalMember a, SignedInt1Member b, SignedInt1Member c) {
            BigInteger tmp = BigInteger.valueOf(b.v());
            tmp = tmp.multiply(a.n());
            tmp = tmp.divide(a.d());
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<Double, SignedInt1Member, SignedInt1Member> SBD = new Procedure3<Double, SignedInt1Member, SignedInt1Member>(){

        @Override
        public void call(Double a, SignedInt1Member b, SignedInt1Member c) {
            c.setV((int)(a * (double)b.v()));
        }
    };
    private final Procedure3<Double, SignedInt1Member, SignedInt1Member> SBDR = new Procedure3<Double, SignedInt1Member, SignedInt1Member>(){

        @Override
        public void call(Double a, SignedInt1Member b, SignedInt1Member c) {
            c.setV((int)Math.round(a * (double)b.v()));
        }
    };

    @Override
    public SignedInt1Member construct() {
        return new SignedInt1Member();
    }

    @Override
    public SignedInt1Member construct(SignedInt1Member other) {
        return new SignedInt1Member(other);
    }

    @Override
    public SignedInt1Member construct(String str) {
        return new SignedInt1Member(str);
    }

    @Override
    public Function2<Boolean, SignedInt1Member, SignedInt1Member> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, SignedInt1Member, SignedInt1Member> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<SignedInt1Member, SignedInt1Member> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure1<SignedInt1Member> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<SignedInt1Member, SignedInt1Member> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<SignedInt1Member, SignedInt1Member, SignedInt1Member> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<SignedInt1Member, SignedInt1Member, SignedInt1Member> subtract() {
        return this.SUB;
    }

    @Override
    public Procedure3<SignedInt1Member, SignedInt1Member, SignedInt1Member> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<Integer, SignedInt1Member, SignedInt1Member> power() {
        return this.POWER;
    }

    @Override
    public Function2<Boolean, SignedInt1Member, SignedInt1Member> isLess() {
        return this.LESS;
    }

    @Override
    public Function2<Boolean, SignedInt1Member, SignedInt1Member> isLessEqual() {
        return this.LE;
    }

    @Override
    public Function2<Boolean, SignedInt1Member, SignedInt1Member> isGreater() {
        return this.GREAT;
    }

    @Override
    public Function2<Boolean, SignedInt1Member, SignedInt1Member> isGreaterEqual() {
        return this.GE;
    }

    @Override
    public Function2<Integer, SignedInt1Member, SignedInt1Member> compare() {
        return this.CMP;
    }

    @Override
    public Function1<Integer, SignedInt1Member> signum() {
        return this.SIG;
    }

    @Override
    public Procedure3<SignedInt1Member, SignedInt1Member, SignedInt1Member> min() {
        return this.MIN;
    }

    @Override
    public Procedure3<SignedInt1Member, SignedInt1Member, SignedInt1Member> max() {
        return this.MAX;
    }

    @Override
    public Procedure2<SignedInt1Member, SignedInt1Member> abs() {
        return this.ABS;
    }

    @Override
    public Function1<Boolean, SignedInt1Member> isEven() {
        return this.EVEN;
    }

    @Override
    public Function1<Boolean, SignedInt1Member> isOdd() {
        return this.ODD;
    }

    @Override
    public Procedure2<SignedInt1Member, SignedInt1Member> pred() {
        return this.PRED;
    }

    @Override
    public Procedure2<SignedInt1Member, SignedInt1Member> succ() {
        return this.SUCC;
    }

    @Override
    public Procedure1<SignedInt1Member> random() {
        return this.RAND;
    }

    @Override
    public Procedure3<SignedInt1Member, SignedInt1Member, SignedInt1Member> bitAnd() {
        return this.AND;
    }

    @Override
    public Procedure3<SignedInt1Member, SignedInt1Member, SignedInt1Member> bitOr() {
        return this.OR;
    }

    @Override
    public Procedure3<SignedInt1Member, SignedInt1Member, SignedInt1Member> bitXor() {
        return this.XOR;
    }

    @Override
    public Procedure2<SignedInt1Member, SignedInt1Member> bitNot() {
        return this.NOT;
    }

    @Override
    public Procedure3<SignedInt1Member, SignedInt1Member, SignedInt1Member> bitAndNot() {
        return this.ANDNOT;
    }

    @Override
    public Procedure3<Integer, SignedInt1Member, SignedInt1Member> bitShiftLeft() {
        return this.SHL;
    }

    @Override
    public Procedure3<Integer, SignedInt1Member, SignedInt1Member> bitShiftRight() {
        return this.SHR;
    }

    @Override
    public Procedure3<Integer, SignedInt1Member, SignedInt1Member> bitShiftRightFillZero() {
        return this.SHRZ;
    }

    @Override
    public Procedure1<SignedInt1Member> maxBound() {
        return this.MAXBOUND;
    }

    @Override
    public Procedure1<SignedInt1Member> minBound() {
        return this.MINBOUND;
    }

    @Override
    public Function1<Boolean, SignedInt1Member> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<SignedInt1Member, SignedInt1Member, SignedInt1Member> scale() {
        return this.MUL;
    }

    @Override
    public Procedure3<HighPrecisionMember, SignedInt1Member, SignedInt1Member> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<HighPrecisionMember, SignedInt1Member, SignedInt1Member> scaleByHighPrecAndRound() {
        return this.SBHPR;
    }

    @Override
    public Procedure3<RationalMember, SignedInt1Member, SignedInt1Member> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, SignedInt1Member, SignedInt1Member> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<Double, SignedInt1Member, SignedInt1Member> scaleByDoubleAndRound() {
        return this.SBDR;
    }
}

