/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.int1;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.ThreadLocalRandom;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.Gcd;
import nom.bdezonia.zorbage.algorithm.Lcm;
import nom.bdezonia.zorbage.algorithm.NumberWithin;
import nom.bdezonia.zorbage.algorithm.PowerNonNegative;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.BitOperations;
import nom.bdezonia.zorbage.type.algebra.Bounded;
import nom.bdezonia.zorbage.type.algebra.Integer;
import nom.bdezonia.zorbage.type.algebra.LogicalOperations;
import nom.bdezonia.zorbage.type.algebra.Random;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.int1.UnsignedInt1Member;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class UnsignedInt1Algebra
implements Integer<UnsignedInt1Algebra, UnsignedInt1Member>,
Bounded<UnsignedInt1Member>,
BitOperations<UnsignedInt1Member>,
Random<UnsignedInt1Member>,
LogicalOperations<UnsignedInt1Member>,
Tolerance<UnsignedInt1Member, UnsignedInt1Member> {
    private final Function2<Boolean, UnsignedInt1Member, UnsignedInt1Member> EQ = new Function2<Boolean, UnsignedInt1Member, UnsignedInt1Member>(){

        @Override
        public Boolean call(UnsignedInt1Member a, UnsignedInt1Member b) {
            return a.v == b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt1Member, UnsignedInt1Member> NEQ = new Function2<Boolean, UnsignedInt1Member, UnsignedInt1Member>(){

        @Override
        public Boolean call(UnsignedInt1Member a, UnsignedInt1Member b) {
            return a.v != b.v;
        }
    };
    private final Procedure2<UnsignedInt1Member, UnsignedInt1Member> ASSIGN = new Procedure2<UnsignedInt1Member, UnsignedInt1Member>(){

        @Override
        public void call(UnsignedInt1Member a, UnsignedInt1Member b) {
            b.set(a);
        }
    };
    private final Procedure1<UnsignedInt1Member> ZER = new Procedure1<UnsignedInt1Member>(){

        @Override
        public void call(UnsignedInt1Member a) {
            a.v = 0;
        }
    };
    private final Procedure3<UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member> ADD = new Procedure3<UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member>(){

        @Override
        public void call(UnsignedInt1Member a, UnsignedInt1Member b, UnsignedInt1Member c) {
            c.setV(a.v + b.v);
        }
    };
    private final Procedure3<UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member> SUB = new Procedure3<UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member>(){

        @Override
        public void call(UnsignedInt1Member a, UnsignedInt1Member b, UnsignedInt1Member c) {
            c.setV(a.v - b.v);
        }
    };
    private final Procedure3<UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member> MUL = new Procedure3<UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member>(){

        @Override
        public void call(UnsignedInt1Member a, UnsignedInt1Member b, UnsignedInt1Member c) {
            c.setV(a.v * b.v);
        }
    };
    private final Procedure3<java.lang.Integer, UnsignedInt1Member, UnsignedInt1Member> POWER = new Procedure3<java.lang.Integer, UnsignedInt1Member, UnsignedInt1Member>(){

        @Override
        public void call(java.lang.Integer power, UnsignedInt1Member a, UnsignedInt1Member b) {
            PowerNonNegative.compute(G.UINT1, power, a, b);
        }
    };
    private final Procedure1<UnsignedInt1Member> UNITY = new Procedure1<UnsignedInt1Member>(){

        @Override
        public void call(UnsignedInt1Member a) {
            a.v = 1;
        }
    };
    private final Function2<Boolean, UnsignedInt1Member, UnsignedInt1Member> LESS = new Function2<Boolean, UnsignedInt1Member, UnsignedInt1Member>(){

        @Override
        public Boolean call(UnsignedInt1Member a, UnsignedInt1Member b) {
            return a.v < b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt1Member, UnsignedInt1Member> LE = new Function2<Boolean, UnsignedInt1Member, UnsignedInt1Member>(){

        @Override
        public Boolean call(UnsignedInt1Member a, UnsignedInt1Member b) {
            return a.v <= b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt1Member, UnsignedInt1Member> GREAT = new Function2<Boolean, UnsignedInt1Member, UnsignedInt1Member>(){

        @Override
        public Boolean call(UnsignedInt1Member a, UnsignedInt1Member b) {
            return a.v > b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt1Member, UnsignedInt1Member> GE = new Function2<Boolean, UnsignedInt1Member, UnsignedInt1Member>(){

        @Override
        public Boolean call(UnsignedInt1Member a, UnsignedInt1Member b) {
            return a.v >= b.v;
        }
    };
    private final Function2<java.lang.Integer, UnsignedInt1Member, UnsignedInt1Member> CMP = new Function2<java.lang.Integer, UnsignedInt1Member, UnsignedInt1Member>(){

        @Override
        public java.lang.Integer call(UnsignedInt1Member a, UnsignedInt1Member b) {
            if (a.v < b.v) {
                return -1;
            }
            if (a.v > b.v) {
                return 1;
            }
            return 0;
        }
    };
    private final Function1<java.lang.Integer, UnsignedInt1Member> SIG = new Function1<java.lang.Integer, UnsignedInt1Member>(){

        @Override
        public java.lang.Integer call(UnsignedInt1Member a) {
            if (a.v < 0) {
                return -1;
            }
            if (a.v > 0) {
                return 1;
            }
            return 0;
        }
    };
    private final Procedure3<UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member> MIN = new Procedure3<UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member>(){

        @Override
        public void call(UnsignedInt1Member a, UnsignedInt1Member b, UnsignedInt1Member c) {
            if (a.v < b.v) {
                c.set(a);
            } else {
                c.set(b);
            }
        }
    };
    private final Procedure3<UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member> MAX = new Procedure3<UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member>(){

        @Override
        public void call(UnsignedInt1Member a, UnsignedInt1Member b, UnsignedInt1Member c) {
            if (a.v > b.v) {
                c.set(a);
            } else {
                c.set(b);
            }
        }
    };
    private final Procedure3<UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member> GCD = new Procedure3<UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member>(){

        @Override
        public void call(UnsignedInt1Member a, UnsignedInt1Member b, UnsignedInt1Member c) {
            Gcd.compute(G.UINT1, a, b, c);
        }
    };
    private final Procedure3<UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member> LCM = new Procedure3<UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member>(){

        @Override
        public void call(UnsignedInt1Member a, UnsignedInt1Member b, UnsignedInt1Member c) {
            Lcm.compute(G.UINT1, a, b, c);
        }
    };
    private final Function1<Boolean, UnsignedInt1Member> EVEN = new Function1<Boolean, UnsignedInt1Member>(){

        @Override
        public Boolean call(UnsignedInt1Member a) {
            return (a.v & 1) == 0;
        }
    };
    private final Function1<Boolean, UnsignedInt1Member> ODD = new Function1<Boolean, UnsignedInt1Member>(){

        @Override
        public Boolean call(UnsignedInt1Member a) {
            return (a.v & 1) == 1;
        }
    };
    private final Procedure3<UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member> DIV = new Procedure3<UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member>(){

        @Override
        public void call(UnsignedInt1Member a, UnsignedInt1Member b, UnsignedInt1Member d) {
            d.setV(a.v / b.v);
        }
    };
    private final Procedure3<UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member> MOD = new Procedure3<UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member>(){

        @Override
        public void call(UnsignedInt1Member a, UnsignedInt1Member b, UnsignedInt1Member m) {
            m.setV(a.v % b.v);
        }
    };
    private final Procedure4<UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member> DIVMOD = new Procedure4<UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member>(){

        @Override
        public void call(UnsignedInt1Member a, UnsignedInt1Member b, UnsignedInt1Member d, UnsignedInt1Member m) {
            UnsignedInt1Algebra.this.div().call(a, b, d);
            UnsignedInt1Algebra.this.mod().call(a, b, m);
        }
    };
    private final Procedure2<UnsignedInt1Member, UnsignedInt1Member> PRED = new Procedure2<UnsignedInt1Member, UnsignedInt1Member>(){

        @Override
        public void call(UnsignedInt1Member a, UnsignedInt1Member b) {
            b.v = a.v == 0 ? (byte)1 : 0;
        }
    };
    private final Procedure2<UnsignedInt1Member, UnsignedInt1Member> SUCC = new Procedure2<UnsignedInt1Member, UnsignedInt1Member>(){

        @Override
        public void call(UnsignedInt1Member a, UnsignedInt1Member b) {
            b.v = a.v == 1 ? (byte)0 : 1;
        }
    };
    private final Procedure3<UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member> POW = new Procedure3<UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member>(){

        @Override
        public void call(UnsignedInt1Member a, UnsignedInt1Member b, UnsignedInt1Member c) {
            PowerNonNegative.compute(G.UINT1, b.v, a, c);
        }
    };
    private final Procedure1<UnsignedInt1Member> RAND = new Procedure1<UnsignedInt1Member>(){

        @Override
        public void call(UnsignedInt1Member a) {
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            a.setV(rng.nextInt(2));
        }
    };
    private final Procedure3<UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member> AND = new Procedure3<UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member>(){

        @Override
        public void call(UnsignedInt1Member a, UnsignedInt1Member b, UnsignedInt1Member c) {
            c.setV(a.v & b.v);
        }
    };
    private final Procedure3<UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member> OR = new Procedure3<UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member>(){

        @Override
        public void call(UnsignedInt1Member a, UnsignedInt1Member b, UnsignedInt1Member c) {
            c.setV(a.v | b.v);
        }
    };
    private final Procedure3<UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member> XOR = new Procedure3<UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member>(){

        @Override
        public void call(UnsignedInt1Member a, UnsignedInt1Member b, UnsignedInt1Member c) {
            c.setV(a.v ^ b.v);
        }
    };
    private final Procedure2<UnsignedInt1Member, UnsignedInt1Member> NOT = new Procedure2<UnsignedInt1Member, UnsignedInt1Member>(){

        @Override
        public void call(UnsignedInt1Member a, UnsignedInt1Member b) {
            b.v = a.v == 0 ? (byte)1 : 0;
        }
    };
    private final Procedure3<UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member> ANDNOT = new Procedure3<UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member>(){

        @Override
        public void call(UnsignedInt1Member a, UnsignedInt1Member b, UnsignedInt1Member c) {
            c.v = a.v == 0 ? (byte)0 : (b.v == 0 ? (byte)1 : 0);
        }
    };
    private final Procedure3<java.lang.Integer, UnsignedInt1Member, UnsignedInt1Member> SHL = new Procedure3<java.lang.Integer, UnsignedInt1Member, UnsignedInt1Member>(){

        @Override
        public void call(java.lang.Integer count, UnsignedInt1Member a, UnsignedInt1Member b) {
            if (count < 0) {
                UnsignedInt1Algebra.this.bitShiftRight().call(-count.intValue(), a, b);
            } else {
                count = count & 1;
                b.setV(a.v << count);
            }
        }
    };
    private final Procedure3<java.lang.Integer, UnsignedInt1Member, UnsignedInt1Member> SHRZ = new Procedure3<java.lang.Integer, UnsignedInt1Member, UnsignedInt1Member>(){

        @Override
        public void call(java.lang.Integer count, UnsignedInt1Member a, UnsignedInt1Member b) {
            if (count < 0) {
                UnsignedInt1Algebra.this.bitShiftLeft().call(-count.intValue(), a, b);
            } else {
                b.setV(a.v >>> count);
            }
        }
    };
    private final Procedure1<UnsignedInt1Member> MAXBOUND = new Procedure1<UnsignedInt1Member>(){

        @Override
        public void call(UnsignedInt1Member a) {
            a.v = 1;
        }
    };
    private final Procedure1<UnsignedInt1Member> MINBOUND = new Procedure1<UnsignedInt1Member>(){

        @Override
        public void call(UnsignedInt1Member a) {
            a.v = 0;
        }
    };
    private final Function1<Boolean, UnsignedInt1Member> ISZERO = new Function1<Boolean, UnsignedInt1Member>(){

        @Override
        public Boolean call(UnsignedInt1Member a) {
            return a.v == 0;
        }
    };
    private final Procedure3<HighPrecisionMember, UnsignedInt1Member, UnsignedInt1Member> SBHP = new Procedure3<HighPrecisionMember, UnsignedInt1Member, UnsignedInt1Member>(){

        @Override
        public void call(HighPrecisionMember a, UnsignedInt1Member b, UnsignedInt1Member c) {
            BigDecimal tmp = a.v();
            tmp = tmp.multiply(new BigDecimal(b.v()));
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<HighPrecisionMember, UnsignedInt1Member, UnsignedInt1Member> SBHPR = new Procedure3<HighPrecisionMember, UnsignedInt1Member, UnsignedInt1Member>(){

        @Override
        public void call(HighPrecisionMember a, UnsignedInt1Member b, UnsignedInt1Member c) {
            BigDecimal tmp = a.v();
            int signum = (tmp = tmp.multiply(new BigDecimal(b.v()))).signum();
            tmp = signum < 0 ? tmp.subtract(G.ONE_HALF) : tmp.add(G.ONE_HALF);
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<RationalMember, UnsignedInt1Member, UnsignedInt1Member> SBR = new Procedure3<RationalMember, UnsignedInt1Member, UnsignedInt1Member>(){

        @Override
        public void call(RationalMember a, UnsignedInt1Member b, UnsignedInt1Member c) {
            BigInteger tmp = BigInteger.valueOf(b.v());
            tmp = tmp.multiply(a.n());
            tmp = tmp.divide(a.d());
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<Double, UnsignedInt1Member, UnsignedInt1Member> SBD = new Procedure3<Double, UnsignedInt1Member, UnsignedInt1Member>(){

        @Override
        public void call(Double a, UnsignedInt1Member b, UnsignedInt1Member c) {
            c.setV((int)(a * (double)b.v()));
        }
    };
    private final Procedure3<Double, UnsignedInt1Member, UnsignedInt1Member> SBDR = new Procedure3<Double, UnsignedInt1Member, UnsignedInt1Member>(){

        @Override
        public void call(Double a, UnsignedInt1Member b, UnsignedInt1Member c) {
            c.setV((int)Math.round(a * (double)b.v()));
        }
    };
    private final Function3<Boolean, UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member> WITHIN = new Function3<Boolean, UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member>(){

        @Override
        public Boolean call(UnsignedInt1Member tol, UnsignedInt1Member a, UnsignedInt1Member b) {
            return NumberWithin.compute(G.UINT1, tol, a, b);
        }
    };

    @Override
    public UnsignedInt1Member construct() {
        return new UnsignedInt1Member();
    }

    @Override
    public UnsignedInt1Member construct(UnsignedInt1Member other) {
        return new UnsignedInt1Member(other);
    }

    @Override
    public UnsignedInt1Member construct(String str) {
        return new UnsignedInt1Member(str);
    }

    @Override
    public Function2<Boolean, UnsignedInt1Member, UnsignedInt1Member> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, UnsignedInt1Member, UnsignedInt1Member> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<UnsignedInt1Member, UnsignedInt1Member> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure1<UnsignedInt1Member> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<UnsignedInt1Member, UnsignedInt1Member> negate() {
        return this.ASSIGN;
    }

    @Override
    public Procedure3<UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member> subtract() {
        return this.SUB;
    }

    @Override
    public Procedure3<UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt1Member, UnsignedInt1Member> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<UnsignedInt1Member> unity() {
        return this.UNITY;
    }

    @Override
    public Function2<Boolean, UnsignedInt1Member, UnsignedInt1Member> isLess() {
        return this.LESS;
    }

    @Override
    public Function2<Boolean, UnsignedInt1Member, UnsignedInt1Member> isLessEqual() {
        return this.LE;
    }

    @Override
    public Function2<Boolean, UnsignedInt1Member, UnsignedInt1Member> isGreater() {
        return this.GREAT;
    }

    @Override
    public Function2<Boolean, UnsignedInt1Member, UnsignedInt1Member> isGreaterEqual() {
        return this.GE;
    }

    @Override
    public Function2<java.lang.Integer, UnsignedInt1Member, UnsignedInt1Member> compare() {
        return this.CMP;
    }

    @Override
    public Function1<java.lang.Integer, UnsignedInt1Member> signum() {
        return this.SIG;
    }

    @Override
    public Procedure3<UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member> min() {
        return this.MIN;
    }

    @Override
    public Procedure3<UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member> max() {
        return this.MAX;
    }

    @Override
    public Procedure2<UnsignedInt1Member, UnsignedInt1Member> abs() {
        return this.ASSIGN;
    }

    @Override
    public Procedure2<UnsignedInt1Member, UnsignedInt1Member> norm() {
        return this.ASSIGN;
    }

    @Override
    public Procedure3<UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member> gcd() {
        return this.GCD;
    }

    @Override
    public Procedure3<UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member> lcm() {
        return this.LCM;
    }

    @Override
    public Function1<Boolean, UnsignedInt1Member> isEven() {
        return this.EVEN;
    }

    @Override
    public Function1<Boolean, UnsignedInt1Member> isOdd() {
        return this.ODD;
    }

    @Override
    public Procedure3<UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member> div() {
        return this.DIV;
    }

    @Override
    public Procedure3<UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member> mod() {
        return this.MOD;
    }

    @Override
    public Procedure4<UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member> divMod() {
        return this.DIVMOD;
    }

    @Override
    public Procedure2<UnsignedInt1Member, UnsignedInt1Member> pred() {
        return this.PRED;
    }

    @Override
    public Procedure2<UnsignedInt1Member, UnsignedInt1Member> succ() {
        return this.SUCC;
    }

    @Override
    public Procedure3<UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member> pow() {
        return this.POW;
    }

    @Override
    public Procedure1<UnsignedInt1Member> random() {
        return this.RAND;
    }

    @Override
    public Procedure3<UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member> bitAnd() {
        return this.AND;
    }

    @Override
    public Procedure3<UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member> bitOr() {
        return this.OR;
    }

    @Override
    public Procedure3<UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member> bitXor() {
        return this.XOR;
    }

    @Override
    public Procedure2<UnsignedInt1Member, UnsignedInt1Member> bitNot() {
        return this.NOT;
    }

    @Override
    public Procedure3<UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member> bitAndNot() {
        return this.ANDNOT;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt1Member, UnsignedInt1Member> bitShiftLeft() {
        return this.SHL;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt1Member, UnsignedInt1Member> bitShiftRight() {
        return this.SHRZ;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt1Member, UnsignedInt1Member> bitShiftRightFillZero() {
        return this.SHRZ;
    }

    @Override
    public Procedure1<UnsignedInt1Member> maxBound() {
        return this.MAXBOUND;
    }

    @Override
    public Procedure1<UnsignedInt1Member> minBound() {
        return this.MINBOUND;
    }

    @Override
    public Function1<Boolean, UnsignedInt1Member> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member> scale() {
        return this.MUL;
    }

    @Override
    public Procedure3<UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member> logicalAnd() {
        return this.AND;
    }

    @Override
    public Procedure3<UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member> logicalOr() {
        return this.OR;
    }

    @Override
    public Procedure3<UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member> logicalXor() {
        return this.XOR;
    }

    @Override
    public Procedure2<UnsignedInt1Member, UnsignedInt1Member> logicalNot() {
        return this.NOT;
    }

    @Override
    public Procedure3<UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member> logicalAndNot() {
        return this.ANDNOT;
    }

    @Override
    public Procedure3<HighPrecisionMember, UnsignedInt1Member, UnsignedInt1Member> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<HighPrecisionMember, UnsignedInt1Member, UnsignedInt1Member> scaleByHighPrecAndRound() {
        return this.SBHPR;
    }

    @Override
    public Procedure3<RationalMember, UnsignedInt1Member, UnsignedInt1Member> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, UnsignedInt1Member, UnsignedInt1Member> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<Double, UnsignedInt1Member, UnsignedInt1Member> scaleByDoubleAndRound() {
        return this.SBDR;
    }

    @Override
    public Function3<Boolean, UnsignedInt1Member, UnsignedInt1Member, UnsignedInt1Member> within() {
        return this.WITHIN;
    }
}

