/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.int10;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.ThreadLocalRandom;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.Gcd;
import nom.bdezonia.zorbage.algorithm.Lcm;
import nom.bdezonia.zorbage.algorithm.NumberWithin;
import nom.bdezonia.zorbage.algorithm.PowerNonNegative;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.BitOperations;
import nom.bdezonia.zorbage.type.algebra.Bounded;
import nom.bdezonia.zorbage.type.algebra.Integer;
import nom.bdezonia.zorbage.type.algebra.Random;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.int10.SignedInt10Member;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class SignedInt10Algebra
implements Integer<SignedInt10Algebra, SignedInt10Member>,
Bounded<SignedInt10Member>,
BitOperations<SignedInt10Member>,
Random<SignedInt10Member>,
Tolerance<SignedInt10Member, SignedInt10Member> {
    private final Function2<Boolean, SignedInt10Member, SignedInt10Member> EQ = new Function2<Boolean, SignedInt10Member, SignedInt10Member>(){

        @Override
        public Boolean call(SignedInt10Member a, SignedInt10Member b) {
            return a.v == b.v;
        }
    };
    private final Function2<Boolean, SignedInt10Member, SignedInt10Member> NEQ = new Function2<Boolean, SignedInt10Member, SignedInt10Member>(){

        @Override
        public Boolean call(SignedInt10Member a, SignedInt10Member b) {
            return a.v != b.v;
        }
    };
    private final Procedure2<SignedInt10Member, SignedInt10Member> ASSIGN = new Procedure2<SignedInt10Member, SignedInt10Member>(){

        @Override
        public void call(SignedInt10Member a, SignedInt10Member b) {
            b.set(a);
        }
    };
    private final Procedure1<SignedInt10Member> ZER = new Procedure1<SignedInt10Member>(){

        @Override
        public void call(SignedInt10Member a) {
            a.v = 0;
        }
    };
    private final Procedure2<SignedInt10Member, SignedInt10Member> NEG = new Procedure2<SignedInt10Member, SignedInt10Member>(){

        @Override
        public void call(SignedInt10Member a, SignedInt10Member b) {
            if (a.v == -512) {
                throw new IllegalArgumentException("Cannot convert -minint symmetrically");
            }
            b.v = -a.v;
        }
    };
    private final Procedure3<SignedInt10Member, SignedInt10Member, SignedInt10Member> ADD = new Procedure3<SignedInt10Member, SignedInt10Member, SignedInt10Member>(){

        @Override
        public void call(SignedInt10Member a, SignedInt10Member b, SignedInt10Member c) {
            c.setV(a.v + b.v);
        }
    };
    private final Procedure3<SignedInt10Member, SignedInt10Member, SignedInt10Member> SUB = new Procedure3<SignedInt10Member, SignedInt10Member, SignedInt10Member>(){

        @Override
        public void call(SignedInt10Member a, SignedInt10Member b, SignedInt10Member c) {
            c.setV(a.v - b.v);
        }
    };
    private final Procedure3<SignedInt10Member, SignedInt10Member, SignedInt10Member> MUL = new Procedure3<SignedInt10Member, SignedInt10Member, SignedInt10Member>(){

        @Override
        public void call(SignedInt10Member a, SignedInt10Member b, SignedInt10Member c) {
            c.setV(a.v * b.v);
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt10Member, SignedInt10Member> POWER = new Procedure3<java.lang.Integer, SignedInt10Member, SignedInt10Member>(){

        @Override
        public void call(java.lang.Integer power, SignedInt10Member a, SignedInt10Member b) {
            PowerNonNegative.compute(G.INT10, power, a, b);
        }
    };
    private final Procedure1<SignedInt10Member> UNITY = new Procedure1<SignedInt10Member>(){

        @Override
        public void call(SignedInt10Member a) {
            a.v = 1;
        }
    };
    private final Function2<Boolean, SignedInt10Member, SignedInt10Member> LESS = new Function2<Boolean, SignedInt10Member, SignedInt10Member>(){

        @Override
        public Boolean call(SignedInt10Member a, SignedInt10Member b) {
            return a.v < b.v;
        }
    };
    private final Function2<Boolean, SignedInt10Member, SignedInt10Member> LE = new Function2<Boolean, SignedInt10Member, SignedInt10Member>(){

        @Override
        public Boolean call(SignedInt10Member a, SignedInt10Member b) {
            return a.v <= b.v;
        }
    };
    private final Function2<Boolean, SignedInt10Member, SignedInt10Member> GREAT = new Function2<Boolean, SignedInt10Member, SignedInt10Member>(){

        @Override
        public Boolean call(SignedInt10Member a, SignedInt10Member b) {
            return a.v > b.v;
        }
    };
    private final Function2<Boolean, SignedInt10Member, SignedInt10Member> GE = new Function2<Boolean, SignedInt10Member, SignedInt10Member>(){

        @Override
        public Boolean call(SignedInt10Member a, SignedInt10Member b) {
            return a.v >= b.v;
        }
    };
    private final Function2<java.lang.Integer, SignedInt10Member, SignedInt10Member> CMP = new Function2<java.lang.Integer, SignedInt10Member, SignedInt10Member>(){

        @Override
        public java.lang.Integer call(SignedInt10Member a, SignedInt10Member b) {
            if (a.v < b.v) {
                return -1;
            }
            if (a.v > b.v) {
                return 1;
            }
            return 0;
        }
    };
    private final Function1<java.lang.Integer, SignedInt10Member> SIG = new Function1<java.lang.Integer, SignedInt10Member>(){

        @Override
        public java.lang.Integer call(SignedInt10Member a) {
            if (a.v < 0) {
                return -1;
            }
            if (a.v > 0) {
                return 1;
            }
            return 0;
        }
    };
    private final Procedure3<SignedInt10Member, SignedInt10Member, SignedInt10Member> MIN = new Procedure3<SignedInt10Member, SignedInt10Member, SignedInt10Member>(){

        @Override
        public void call(SignedInt10Member a, SignedInt10Member b, SignedInt10Member c) {
            if (a.v < b.v) {
                c.set(a);
            } else {
                c.set(b);
            }
        }
    };
    private final Procedure3<SignedInt10Member, SignedInt10Member, SignedInt10Member> MAX = new Procedure3<SignedInt10Member, SignedInt10Member, SignedInt10Member>(){

        @Override
        public void call(SignedInt10Member a, SignedInt10Member b, SignedInt10Member c) {
            if (a.v > b.v) {
                c.set(a);
            } else {
                c.set(b);
            }
        }
    };
    private final Procedure2<SignedInt10Member, SignedInt10Member> ABS = new Procedure2<SignedInt10Member, SignedInt10Member>(){

        @Override
        public void call(SignedInt10Member a, SignedInt10Member b) {
            if (a.v == -512) {
                throw new IllegalArgumentException("Cannot convert -minint symmetrically");
            }
            b.v = a.v < 0 ? (short)(-a.v) : a.v;
        }
    };
    private final Procedure3<SignedInt10Member, SignedInt10Member, SignedInt10Member> GCD = new Procedure3<SignedInt10Member, SignedInt10Member, SignedInt10Member>(){

        @Override
        public void call(SignedInt10Member a, SignedInt10Member b, SignedInt10Member c) {
            Gcd.compute(G.INT10, a, b, c);
        }
    };
    private final Procedure3<SignedInt10Member, SignedInt10Member, SignedInt10Member> LCM = new Procedure3<SignedInt10Member, SignedInt10Member, SignedInt10Member>(){

        @Override
        public void call(SignedInt10Member a, SignedInt10Member b, SignedInt10Member c) {
            Lcm.compute(G.INT10, a, b, c);
        }
    };
    private final Function1<Boolean, SignedInt10Member> EVEN = new Function1<Boolean, SignedInt10Member>(){

        @Override
        public Boolean call(SignedInt10Member a) {
            return (a.v & 1) == 0;
        }
    };
    private final Function1<Boolean, SignedInt10Member> ODD = new Function1<Boolean, SignedInt10Member>(){

        @Override
        public Boolean call(SignedInt10Member a) {
            return (a.v & 1) == 1;
        }
    };
    private final Procedure3<SignedInt10Member, SignedInt10Member, SignedInt10Member> DIV = new Procedure3<SignedInt10Member, SignedInt10Member, SignedInt10Member>(){

        @Override
        public void call(SignedInt10Member a, SignedInt10Member b, SignedInt10Member d) {
            if (b.v == -1 && a.v == -512) {
                throw new IllegalArgumentException("cannot divide minint by -1");
            }
            d.setV(a.v / b.v);
        }
    };
    private final Procedure3<SignedInt10Member, SignedInt10Member, SignedInt10Member> MOD = new Procedure3<SignedInt10Member, SignedInt10Member, SignedInt10Member>(){

        @Override
        public void call(SignedInt10Member a, SignedInt10Member b, SignedInt10Member m) {
            m.setV(a.v % b.v);
        }
    };
    private final Procedure4<SignedInt10Member, SignedInt10Member, SignedInt10Member, SignedInt10Member> DIVMOD = new Procedure4<SignedInt10Member, SignedInt10Member, SignedInt10Member, SignedInt10Member>(){

        @Override
        public void call(SignedInt10Member a, SignedInt10Member b, SignedInt10Member d, SignedInt10Member m) {
            SignedInt10Algebra.this.div().call(a, b, d);
            SignedInt10Algebra.this.mod().call(a, b, m);
        }
    };
    private final Procedure2<SignedInt10Member, SignedInt10Member> PRED = new Procedure2<SignedInt10Member, SignedInt10Member>(){

        @Override
        public void call(SignedInt10Member a, SignedInt10Member b) {
            if (a.v == -512) {
                b.v = (short)511;
            } else {
                b.setV(a.v - 1);
            }
        }
    };
    private final Procedure2<SignedInt10Member, SignedInt10Member> SUCC = new Procedure2<SignedInt10Member, SignedInt10Member>(){

        @Override
        public void call(SignedInt10Member a, SignedInt10Member b) {
            if (a.v == 511) {
                b.v = (short)-512;
            } else {
                b.setV(a.v + 1);
            }
        }
    };
    private final Procedure3<SignedInt10Member, SignedInt10Member, SignedInt10Member> POW = new Procedure3<SignedInt10Member, SignedInt10Member, SignedInt10Member>(){

        @Override
        public void call(SignedInt10Member a, SignedInt10Member b, SignedInt10Member c) {
            PowerNonNegative.compute(G.INT10, b.v, a, c);
        }
    };
    private final Procedure1<SignedInt10Member> RAND = new Procedure1<SignedInt10Member>(){

        @Override
        public void call(SignedInt10Member a) {
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            a.setV(rng.nextInt(1024) - 512);
        }
    };
    private final Procedure3<SignedInt10Member, SignedInt10Member, SignedInt10Member> AND = new Procedure3<SignedInt10Member, SignedInt10Member, SignedInt10Member>(){

        @Override
        public void call(SignedInt10Member a, SignedInt10Member b, SignedInt10Member c) {
            c.setV(a.v & b.v);
        }
    };
    private final Procedure3<SignedInt10Member, SignedInt10Member, SignedInt10Member> OR = new Procedure3<SignedInt10Member, SignedInt10Member, SignedInt10Member>(){

        @Override
        public void call(SignedInt10Member a, SignedInt10Member b, SignedInt10Member c) {
            c.setV(a.v | b.v);
        }
    };
    private final Procedure3<SignedInt10Member, SignedInt10Member, SignedInt10Member> XOR = new Procedure3<SignedInt10Member, SignedInt10Member, SignedInt10Member>(){

        @Override
        public void call(SignedInt10Member a, SignedInt10Member b, SignedInt10Member c) {
            c.setV(a.v ^ b.v);
        }
    };
    private final Procedure2<SignedInt10Member, SignedInt10Member> NOT = new Procedure2<SignedInt10Member, SignedInt10Member>(){

        @Override
        public void call(SignedInt10Member a, SignedInt10Member b) {
            b.setV(~a.v);
        }
    };
    private final Procedure3<SignedInt10Member, SignedInt10Member, SignedInt10Member> ANDNOT = new Procedure3<SignedInt10Member, SignedInt10Member, SignedInt10Member>(){

        @Override
        public void call(SignedInt10Member a, SignedInt10Member b, SignedInt10Member c) {
            c.setV(a.v & ~b.v);
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt10Member, SignedInt10Member> SHL = new Procedure3<java.lang.Integer, SignedInt10Member, SignedInt10Member>(){

        @Override
        public void call(java.lang.Integer count, SignedInt10Member a, SignedInt10Member b) {
            if (count < 0) {
                SignedInt10Algebra.this.bitShiftRight().call(-count.intValue(), a, b);
            } else {
                count = count % 10;
                b.setV(a.v << count);
            }
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt10Member, SignedInt10Member> SHR = new Procedure3<java.lang.Integer, SignedInt10Member, SignedInt10Member>(){

        @Override
        public void call(java.lang.Integer count, SignedInt10Member a, SignedInt10Member b) {
            if (count < 0) {
                SignedInt10Algebra.this.bitShiftLeft().call(-count.intValue(), a, b);
            } else {
                int val = a.v >> count;
                if (a.v < 0 && val == 0) {
                    b.v = (short)-1;
                } else {
                    b.setV(val);
                }
            }
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt10Member, SignedInt10Member> SHRZ = new Procedure3<java.lang.Integer, SignedInt10Member, SignedInt10Member>(){

        @Override
        public void call(java.lang.Integer count, SignedInt10Member a, SignedInt10Member b) {
            if (count < 0) {
                SignedInt10Algebra.this.bitShiftLeft().call(-count.intValue(), a, b);
            } else {
                b.setV(a.v >>> count);
            }
        }
    };
    private final Procedure1<SignedInt10Member> MAXBOUND = new Procedure1<SignedInt10Member>(){

        @Override
        public void call(SignedInt10Member a) {
            a.v = (short)511;
        }
    };
    private final Procedure1<SignedInt10Member> MINBOUND = new Procedure1<SignedInt10Member>(){

        @Override
        public void call(SignedInt10Member a) {
            a.v = (short)-512;
        }
    };
    private final Function1<Boolean, SignedInt10Member> ISZERO = new Function1<Boolean, SignedInt10Member>(){

        @Override
        public Boolean call(SignedInt10Member a) {
            return a.v == 0;
        }
    };
    private final Procedure3<HighPrecisionMember, SignedInt10Member, SignedInt10Member> SBHP = new Procedure3<HighPrecisionMember, SignedInt10Member, SignedInt10Member>(){

        @Override
        public void call(HighPrecisionMember a, SignedInt10Member b, SignedInt10Member c) {
            BigDecimal tmp = a.v();
            tmp = tmp.multiply(new BigDecimal(b.v()));
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<HighPrecisionMember, SignedInt10Member, SignedInt10Member> SBHPR = new Procedure3<HighPrecisionMember, SignedInt10Member, SignedInt10Member>(){

        @Override
        public void call(HighPrecisionMember a, SignedInt10Member b, SignedInt10Member c) {
            BigDecimal tmp = a.v();
            int signum = (tmp = tmp.multiply(new BigDecimal(b.v()))).signum();
            tmp = signum < 0 ? tmp.subtract(G.ONE_HALF) : tmp.add(G.ONE_HALF);
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<RationalMember, SignedInt10Member, SignedInt10Member> SBR = new Procedure3<RationalMember, SignedInt10Member, SignedInt10Member>(){

        @Override
        public void call(RationalMember a, SignedInt10Member b, SignedInt10Member c) {
            BigInteger tmp = BigInteger.valueOf(b.v());
            tmp = tmp.multiply(a.n());
            tmp = tmp.divide(a.d());
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<Double, SignedInt10Member, SignedInt10Member> SBD = new Procedure3<Double, SignedInt10Member, SignedInt10Member>(){

        @Override
        public void call(Double a, SignedInt10Member b, SignedInt10Member c) {
            c.setV((int)(a * (double)b.v()));
        }
    };
    private final Procedure3<Double, SignedInt10Member, SignedInt10Member> SBDR = new Procedure3<Double, SignedInt10Member, SignedInt10Member>(){

        @Override
        public void call(Double a, SignedInt10Member b, SignedInt10Member c) {
            c.setV((int)Math.round(a * (double)b.v()));
        }
    };
    private final Function3<Boolean, SignedInt10Member, SignedInt10Member, SignedInt10Member> WITHIN = new Function3<Boolean, SignedInt10Member, SignedInt10Member, SignedInt10Member>(){

        @Override
        public Boolean call(SignedInt10Member tol, SignedInt10Member a, SignedInt10Member b) {
            return NumberWithin.compute(G.INT10, tol, a, b);
        }
    };

    @Override
    public SignedInt10Member construct() {
        return new SignedInt10Member();
    }

    @Override
    public SignedInt10Member construct(SignedInt10Member other) {
        return new SignedInt10Member(other);
    }

    @Override
    public SignedInt10Member construct(String str) {
        return new SignedInt10Member(str);
    }

    @Override
    public Function2<Boolean, SignedInt10Member, SignedInt10Member> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, SignedInt10Member, SignedInt10Member> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<SignedInt10Member, SignedInt10Member> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure1<SignedInt10Member> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<SignedInt10Member, SignedInt10Member> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<SignedInt10Member, SignedInt10Member, SignedInt10Member> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<SignedInt10Member, SignedInt10Member, SignedInt10Member> subtract() {
        return this.SUB;
    }

    @Override
    public Procedure3<SignedInt10Member, SignedInt10Member, SignedInt10Member> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt10Member, SignedInt10Member> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<SignedInt10Member> unity() {
        return this.UNITY;
    }

    @Override
    public Function2<Boolean, SignedInt10Member, SignedInt10Member> isLess() {
        return this.LESS;
    }

    @Override
    public Function2<Boolean, SignedInt10Member, SignedInt10Member> isLessEqual() {
        return this.LE;
    }

    @Override
    public Function2<Boolean, SignedInt10Member, SignedInt10Member> isGreater() {
        return this.GREAT;
    }

    @Override
    public Function2<Boolean, SignedInt10Member, SignedInt10Member> isGreaterEqual() {
        return this.GE;
    }

    @Override
    public Function2<java.lang.Integer, SignedInt10Member, SignedInt10Member> compare() {
        return this.CMP;
    }

    @Override
    public Function1<java.lang.Integer, SignedInt10Member> signum() {
        return this.SIG;
    }

    @Override
    public Procedure3<SignedInt10Member, SignedInt10Member, SignedInt10Member> min() {
        return this.MIN;
    }

    @Override
    public Procedure3<SignedInt10Member, SignedInt10Member, SignedInt10Member> max() {
        return this.MAX;
    }

    @Override
    public Procedure2<SignedInt10Member, SignedInt10Member> abs() {
        return this.ABS;
    }

    @Override
    public Procedure2<SignedInt10Member, SignedInt10Member> norm() {
        return this.ABS;
    }

    @Override
    public Procedure3<SignedInt10Member, SignedInt10Member, SignedInt10Member> gcd() {
        return this.GCD;
    }

    @Override
    public Procedure3<SignedInt10Member, SignedInt10Member, SignedInt10Member> lcm() {
        return this.LCM;
    }

    @Override
    public Function1<Boolean, SignedInt10Member> isEven() {
        return this.EVEN;
    }

    @Override
    public Function1<Boolean, SignedInt10Member> isOdd() {
        return this.ODD;
    }

    @Override
    public Procedure3<SignedInt10Member, SignedInt10Member, SignedInt10Member> div() {
        return this.DIV;
    }

    @Override
    public Procedure3<SignedInt10Member, SignedInt10Member, SignedInt10Member> mod() {
        return this.MOD;
    }

    @Override
    public Procedure4<SignedInt10Member, SignedInt10Member, SignedInt10Member, SignedInt10Member> divMod() {
        return this.DIVMOD;
    }

    @Override
    public Procedure2<SignedInt10Member, SignedInt10Member> pred() {
        return this.PRED;
    }

    @Override
    public Procedure2<SignedInt10Member, SignedInt10Member> succ() {
        return this.SUCC;
    }

    @Override
    public Procedure3<SignedInt10Member, SignedInt10Member, SignedInt10Member> pow() {
        return this.POW;
    }

    @Override
    public Procedure1<SignedInt10Member> random() {
        return this.RAND;
    }

    @Override
    public Procedure3<SignedInt10Member, SignedInt10Member, SignedInt10Member> bitAnd() {
        return this.AND;
    }

    @Override
    public Procedure3<SignedInt10Member, SignedInt10Member, SignedInt10Member> bitOr() {
        return this.OR;
    }

    @Override
    public Procedure3<SignedInt10Member, SignedInt10Member, SignedInt10Member> bitXor() {
        return this.XOR;
    }

    @Override
    public Procedure2<SignedInt10Member, SignedInt10Member> bitNot() {
        return this.NOT;
    }

    @Override
    public Procedure3<SignedInt10Member, SignedInt10Member, SignedInt10Member> bitAndNot() {
        return this.ANDNOT;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt10Member, SignedInt10Member> bitShiftLeft() {
        return this.SHL;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt10Member, SignedInt10Member> bitShiftRight() {
        return this.SHR;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt10Member, SignedInt10Member> bitShiftRightFillZero() {
        return this.SHRZ;
    }

    @Override
    public Procedure1<SignedInt10Member> maxBound() {
        return this.MAXBOUND;
    }

    @Override
    public Procedure1<SignedInt10Member> minBound() {
        return this.MINBOUND;
    }

    @Override
    public Function1<Boolean, SignedInt10Member> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<SignedInt10Member, SignedInt10Member, SignedInt10Member> scale() {
        return this.MUL;
    }

    @Override
    public Procedure3<HighPrecisionMember, SignedInt10Member, SignedInt10Member> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<HighPrecisionMember, SignedInt10Member, SignedInt10Member> scaleByHighPrecAndRound() {
        return this.SBHPR;
    }

    @Override
    public Procedure3<RationalMember, SignedInt10Member, SignedInt10Member> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, SignedInt10Member, SignedInt10Member> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<Double, SignedInt10Member, SignedInt10Member> scaleByDoubleAndRound() {
        return this.SBDR;
    }

    @Override
    public Function3<Boolean, SignedInt10Member, SignedInt10Member, SignedInt10Member> within() {
        return this.WITHIN;
    }
}

