/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.int10;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigDecimal;
import java.math.BigInteger;
import nom.bdezonia.zorbage.sampling.IntegerIndex;
import nom.bdezonia.zorbage.type.algebra.GetReal;
import nom.bdezonia.zorbage.type.algebra.Gettable;
import nom.bdezonia.zorbage.type.algebra.HighPrecRepresentation;
import nom.bdezonia.zorbage.type.algebra.NumberMember;
import nom.bdezonia.zorbage.type.algebra.SetReal;
import nom.bdezonia.zorbage.type.algebra.Settable;
import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.ctor.Duplicatable;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.int16.SignedInt16Member;
import nom.bdezonia.zorbage.type.data.universal.OctonionRepresentation;
import nom.bdezonia.zorbage.type.data.universal.PrimitiveConversion;
import nom.bdezonia.zorbage.type.data.universal.PrimitiveRepresentation;
import nom.bdezonia.zorbage.type.data.universal.TensorOctonionRepresentation;
import nom.bdezonia.zorbage.type.data.universal.TensorStringRepresentation;
import nom.bdezonia.zorbage.type.data.universal.UniversalRepresentation;
import nom.bdezonia.zorbage.type.storage.coder.BitCoder;
import nom.bdezonia.zorbage.type.storage.coder.ShortCoder;

public final class SignedInt10Member
implements BitCoder,
ShortCoder,
Allocatable<SignedInt10Member>,
Duplicatable<SignedInt10Member>,
Settable<SignedInt10Member>,
Gettable<SignedInt10Member>,
UniversalRepresentation,
NumberMember<SignedInt10Member>,
PrimitiveConversion,
HighPrecRepresentation,
SetReal<Integer>,
GetReal<SignedInt16Member> {
    short v;

    public SignedInt10Member() {
        this.v = 0;
    }

    public SignedInt10Member(SignedInt10Member other) {
        this.set(other);
    }

    public SignedInt10Member(String value) {
        TensorStringRepresentation rep = new TensorStringRepresentation(value);
        OctonionRepresentation val = rep.firstValue();
        int x = val.r().intValue();
        this.setV(x);
    }

    public SignedInt10Member(int v) {
        this.setV(v);
    }

    @Override
    public void v(SignedInt10Member value) {
        this.get(value);
    }

    public short v() {
        return this.v;
    }

    @Override
    public void setV(SignedInt10Member value) {
        this.set(value);
    }

    @Override
    public void setV(int val) {
        this.v = (short)(val % 1024);
        if (this.v < -512) {
            this.v = (short)(this.v + 1024);
        } else if (this.v > 511) {
            this.v = (short)(this.v - 1024);
        }
    }

    public String toString() {
        return String.valueOf(this.v);
    }

    @Override
    public void toRep(TensorOctonionRepresentation rep) {
        rep.setValue(new OctonionRepresentation(new BigDecimal(this.v)));
    }

    @Override
    public void fromRep(TensorOctonionRepresentation rep) {
        this.setV(rep.getValue().r().intValue());
    }

    @Override
    public void get(SignedInt10Member other) {
        other.v = this.v;
    }

    @Override
    public void set(SignedInt10Member other) {
        this.v = other.v;
    }

    @Override
    public SignedInt10Member duplicate() {
        return new SignedInt10Member(this);
    }

    @Override
    public SignedInt10Member allocate() {
        return new SignedInt10Member();
    }

    @Override
    public int bitCount() {
        return 10;
    }

    @Override
    public void fromBitArray(long[] arr, int index, int offset) {
        if (offset < 55) {
            long b1b2b3b4b5b6b7b8b9b10 = arr[index] >>> offset & 0x3FFL;
            this.setV((int)b1b2b3b4b5b6b7b8b9b10);
        } else if (offset == 63) {
            long b1 = arr[index] >>> 63 & 1L;
            long b2b3b4b5b6b7b8b9b10 = arr[index + 1] & 0x1FFL;
            this.setV((int)(b1 << 9 | b2b3b4b5b6b7b8b9b10));
        } else if (offset == 62) {
            long b1b2 = arr[index] >>> 62 & 3L;
            long b3b4b5b6b7b8b9b10 = arr[index + 1] & 0xFFL;
            this.setV((int)(b1b2 << 8 | b3b4b5b6b7b8b9b10));
        } else if (offset == 61) {
            long b1b2b3 = arr[index] >>> 61 & 7L;
            long b4b5b6b7b8b9b10 = arr[index + 1] & 0x7FL;
            this.setV((int)(b1b2b3 << 7 | b4b5b6b7b8b9b10));
        } else if (offset == 60) {
            long b1b2b3b4 = arr[index] >>> 60 & 0xFL;
            long b5b6b7b8b9b10 = arr[index + 1] & 0x3FL;
            this.setV((int)(b1b2b3b4 << 6 | b5b6b7b8b9b10));
        } else if (offset == 59) {
            long b1b2b3b4b5 = arr[index] >>> 59 & 0x1FL;
            long b6b7b8b9b10 = arr[index + 1] & 0x1FL;
            this.setV((int)(b1b2b3b4b5 << 5 | b6b7b8b9b10));
        } else if (offset == 58) {
            long b1b2b3b4b5b6 = arr[index] >>> 58 & 0x3FL;
            long b7b8b9b10 = arr[index + 1] & 0xFL;
            this.setV((int)(b1b2b3b4b5b6 << 4 | b7b8b9b10));
        } else if (offset == 57) {
            long b1b2b3b4b5b6b7 = arr[index] >>> 57 & 0x7FL;
            long b8b9b10 = arr[index + 1] & 7L;
            this.setV((int)(b1b2b3b4b5b6b7 << 3 | b8b9b10));
        } else if (offset == 56) {
            long b1b2b3b4b5b6b7b8 = arr[index] >>> 56 & 0xFFL;
            long b9b10 = arr[index + 1] & 3L;
            this.setV((int)(b1b2b3b4b5b6b7b8 << 2 | b9b10));
        } else {
            long b1b2b3b4b5b6b7b8b9 = arr[index] >>> 55 & 0x1FFL;
            long b10 = arr[index + 1] & 1L;
            this.setV((int)(b1b2b3b4b5b6b7b8b9 << 1 | b10));
        }
    }

    @Override
    public void toBitArray(long[] arr, int index, int offset) {
        if (offset < 55) {
            long oldVals = arr[index] & (1023L << offset ^ 0xFFFFFFFFFFFFFFFFL);
            long newVals = (long)this.v << offset;
            arr[index] = newVals | oldVals;
        } else if (offset == 63) {
            long b1 = ((long)this.v & 0x200L) >>> 9;
            long b2b3b4b5b6b7b8b9b10 = (long)this.v & 0x1FFL;
            long oldVals = arr[index] & Long.MAX_VALUE;
            long newVals = b1 << 63;
            arr[index] = newVals | oldVals;
            oldVals = arr[index + 1] & 0xFFFFFFFFFFFFFE00L;
            newVals = b2b3b4b5b6b7b8b9b10 << 0;
            arr[index + 1] = newVals | oldVals;
        } else if (offset == 62) {
            long b1b2 = ((long)this.v & 0x300L) >>> 8;
            long b3b4b5b6b7b8b9b10 = (long)this.v & 0xFFL;
            long oldVals = arr[index] & 0x3FFFFFFFFFFFFFFFL;
            long newVals = b1b2 << 62;
            arr[index] = newVals | oldVals;
            oldVals = arr[index + 1] & 0xFFFFFFFFFFFFFF00L;
            newVals = b3b4b5b6b7b8b9b10 << 0;
            arr[index + 1] = newVals | oldVals;
        } else if (offset == 61) {
            long b1b2b3 = ((long)this.v & 0x380L) >>> 7;
            long b4b5b6b7b8b9b10 = (long)this.v & 0x7FL;
            long oldVals = arr[index] & 0x1FFFFFFFFFFFFFFFL;
            long newVals = b1b2b3 << 61;
            arr[index] = newVals | oldVals;
            oldVals = arr[index + 1] & 0xFFFFFFFFFFFFFF80L;
            newVals = b4b5b6b7b8b9b10 << 0;
            arr[index + 1] = newVals | oldVals;
        } else if (offset == 60) {
            long b1b2b3b4 = ((long)this.v & 0x3C0L) >>> 6;
            long b5b6b7b8b9b10 = (long)this.v & 0x3FL;
            long oldVals = arr[index] & 0xFFFFFFFFFFFFFFFL;
            long newVals = b1b2b3b4 << 60;
            arr[index] = newVals | oldVals;
            oldVals = arr[index + 1] & 0xFFFFFFFFFFFFFFC0L;
            newVals = b5b6b7b8b9b10 << 0;
            arr[index + 1] = newVals | oldVals;
        } else if (offset == 59) {
            long b1b2b3b4b5 = ((long)this.v & 0x3E0L) >>> 5;
            long b6b7b8b9b10 = (long)this.v & 0x1FL;
            long oldVals = arr[index] & 0x7FFFFFFFFFFFFFFL;
            long newVals = b1b2b3b4b5 << 59;
            arr[index] = newVals | oldVals;
            oldVals = arr[index + 1] & 0xFFFFFFFFFFFFFFE0L;
            newVals = b6b7b8b9b10 << 0;
            arr[index + 1] = newVals | oldVals;
        } else if (offset == 58) {
            long b1b2b3b4b5b6 = ((long)this.v & 0x3F0L) >>> 4;
            long b7b8b9b10 = (long)this.v & 0xFL;
            long oldVals = arr[index] & 0x3FFFFFFFFFFFFFFL;
            long newVals = b1b2b3b4b5b6 << 58;
            arr[index] = newVals | oldVals;
            oldVals = arr[index + 1] & 0xFFFFFFFFFFFFFFF0L;
            newVals = b7b8b9b10 << 0;
            arr[index + 1] = newVals | oldVals;
        } else if (offset == 57) {
            long b1b2b3b4b5b6b7 = ((long)this.v & 0x3F8L) >>> 3;
            long b8b9b10 = (long)this.v & 7L;
            long oldVals = arr[index] & 0x1FFFFFFFFFFFFFFL;
            long newVals = b1b2b3b4b5b6b7 << 57;
            arr[index] = newVals | oldVals;
            oldVals = arr[index + 1] & 0xFFFFFFFFFFFFFFF8L;
            newVals = b8b9b10 << 0;
            arr[index + 1] = newVals | oldVals;
        } else if (offset == 56) {
            long b1b2b3b4b5b6b7b8 = ((long)this.v & 0x3FCL) >>> 2;
            long b9b10 = (long)this.v & 3L;
            long oldVals = arr[index] & 0xFFFFFFFFFFFFFFL;
            long newVals = b1b2b3b4b5b6b7b8 << 56;
            arr[index] = newVals | oldVals;
            oldVals = arr[index + 1] & 0xFFFFFFFFFFFFFFFCL;
            newVals = b9b10 << 0;
            arr[index + 1] = newVals | oldVals;
        } else {
            long b1b2b3b4b5b6b7b8b9 = ((long)this.v & 0x3FEL) >>> 1;
            long b10 = (long)this.v & 1L;
            long oldVals = arr[index] & 0x807FFFFFFFFFFFFFL;
            long newVals = b1b2b3b4b5b6b7b8b9 << 55;
            arr[index] = newVals | oldVals;
            oldVals = arr[index + 1] & 0xFFFFFFFFFFFFFFFEL;
            newVals = b10 << 0;
            arr[index + 1] = newVals | oldVals;
        }
    }

    @Override
    public int shortCount() {
        return 1;
    }

    @Override
    public void fromShortArray(short[] arr, int index) {
        this.setV(arr[index]);
    }

    @Override
    public void toShortArray(short[] arr, int index) {
        arr[index] = this.v;
    }

    @Override
    public void fromShortFile(RandomAccessFile raf) throws IOException {
        this.setV(raf.readShort());
    }

    @Override
    public void toShortFile(RandomAccessFile raf) throws IOException {
        raf.writeShort(this.v);
    }

    @Override
    public long dimension(int d) {
        return 0L;
    }

    @Override
    public int numDimensions() {
        return 0;
    }

    @Override
    public PrimitiveRepresentation preferredRepresentation() {
        return PrimitiveRepresentation.SHORT;
    }

    @Override
    public int componentCount() {
        return 1;
    }

    @Override
    public void primComponentSetByte(IntegerIndex index, int component, byte v) {
        this.setV(v);
    }

    @Override
    public void primComponentSetShort(IntegerIndex index, int component, short v) {
        this.setV(v);
    }

    @Override
    public void primComponentSetInt(IntegerIndex index, int component, int v) {
        this.setV(v);
    }

    @Override
    public void primComponentSetLong(IntegerIndex index, int component, long v) {
        this.setV((int)v);
    }

    @Override
    public void primComponentSetFloat(IntegerIndex index, int component, float v) {
        this.setV((int)v);
    }

    @Override
    public void primComponentSetDouble(IntegerIndex index, int component, double v) {
        this.setV((int)v);
    }

    @Override
    public void primComponentSetBigInteger(IntegerIndex index, int component, BigInteger v) {
        this.setV(v.intValue());
    }

    @Override
    public void primComponentSetBigDecimal(IntegerIndex index, int component, BigDecimal v) {
        this.primComponentSetBigInteger(index, component, v.toBigInteger());
    }

    @Override
    public void primComponentSetByteSafe(IntegerIndex index, int component, byte v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            this.setV(v);
        }
    }

    @Override
    public void primComponentSetShortSafe(IntegerIndex index, int component, short v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            this.setV(v);
        }
    }

    @Override
    public void primComponentSetIntSafe(IntegerIndex index, int component, int v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            this.setV(v);
        }
    }

    @Override
    public void primComponentSetLongSafe(IntegerIndex index, int component, long v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0L) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            this.setV((int)v);
        }
    }

    @Override
    public void primComponentSetFloatSafe(IntegerIndex index, int component, float v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0.0f) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            this.setV((int)v);
        }
    }

    @Override
    public void primComponentSetDoubleSafe(IntegerIndex index, int component, double v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0.0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            this.setV((int)v);
        }
    }

    @Override
    public void primComponentSetBigIntegerSafe(IntegerIndex index, int component, BigInteger v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v.signum() != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            this.setV(v.intValue());
        }
    }

    @Override
    public void primComponentSetBigDecimalSafe(IntegerIndex index, int component, BigDecimal v) {
        this.primComponentSetBigIntegerSafe(index, component, v.toBigInteger());
    }

    @Override
    public byte primComponentGetAsByte(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            return (byte)this.v;
        }
        return 0;
    }

    @Override
    public short primComponentGetAsShort(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            return this.v;
        }
        return 0;
    }

    @Override
    public int primComponentGetAsInt(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            return this.v;
        }
        return 0;
    }

    @Override
    public long primComponentGetAsLong(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            return this.v;
        }
        return 0L;
    }

    @Override
    public float primComponentGetAsFloat(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            return this.v;
        }
        return 0.0f;
    }

    @Override
    public double primComponentGetAsDouble(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            return this.v;
        }
        return 0.0;
    }

    @Override
    public BigInteger primComponentGetAsBigInteger(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            return BigInteger.valueOf(this.v);
        }
        return BigInteger.ZERO;
    }

    @Override
    public BigDecimal primComponentGetAsBigDecimal(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            return BigDecimal.valueOf(this.v);
        }
        return BigDecimal.ZERO;
    }

    @Override
    public byte primComponentGetAsByteSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0;
        }
        return (byte)this.v;
    }

    @Override
    public short primComponentGetAsShortSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0;
        }
        return this.v;
    }

    @Override
    public int primComponentGetAsIntSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0;
        }
        return this.v;
    }

    @Override
    public long primComponentGetAsLongSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0L;
        }
        return this.v;
    }

    @Override
    public float primComponentGetAsFloatSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0.0f;
        }
        return this.v;
    }

    @Override
    public double primComponentGetAsDoubleSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0.0;
        }
        return this.v;
    }

    @Override
    public BigInteger primComponentGetAsBigIntegerSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return BigInteger.ZERO;
        }
        return BigInteger.valueOf(this.v);
    }

    @Override
    public BigDecimal primComponentGetAsBigDecimalSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return BigDecimal.ZERO;
        }
        return BigDecimal.valueOf(this.v);
    }

    @Override
    public void primitiveInit() {
        this.v = 0;
    }

    @Override
    public void toHighPrec(HighPrecisionMember result) {
        result.setV(BigDecimal.valueOf(this.v()));
    }

    @Override
    public void fromHighPrec(HighPrecisionMember input) {
        this.setV(input.v().intValue());
    }

    @Override
    public void setR(Integer val) {
        this.setV(val);
    }

    @Override
    public void getR(SignedInt16Member val) {
        val.setV(this.v);
    }
}

