/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.int10;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.ThreadLocalRandom;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.Gcd;
import nom.bdezonia.zorbage.algorithm.Lcm;
import nom.bdezonia.zorbage.algorithm.NumberWithin;
import nom.bdezonia.zorbage.algorithm.PowerNonNegative;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.BitOperations;
import nom.bdezonia.zorbage.type.algebra.Bounded;
import nom.bdezonia.zorbage.type.algebra.Integer;
import nom.bdezonia.zorbage.type.algebra.Random;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.int10.UnsignedInt10Member;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class UnsignedInt10Algebra
implements Integer<UnsignedInt10Algebra, UnsignedInt10Member>,
Bounded<UnsignedInt10Member>,
BitOperations<UnsignedInt10Member>,
Random<UnsignedInt10Member>,
Tolerance<UnsignedInt10Member, UnsignedInt10Member> {
    private final Function2<Boolean, UnsignedInt10Member, UnsignedInt10Member> EQ = new Function2<Boolean, UnsignedInt10Member, UnsignedInt10Member>(){

        @Override
        public Boolean call(UnsignedInt10Member a, UnsignedInt10Member b) {
            return a.v == b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt10Member, UnsignedInt10Member> NEQ = new Function2<Boolean, UnsignedInt10Member, UnsignedInt10Member>(){

        @Override
        public Boolean call(UnsignedInt10Member a, UnsignedInt10Member b) {
            return a.v != b.v;
        }
    };
    private final Procedure2<UnsignedInt10Member, UnsignedInt10Member> ASSIGN = new Procedure2<UnsignedInt10Member, UnsignedInt10Member>(){

        @Override
        public void call(UnsignedInt10Member a, UnsignedInt10Member b) {
            b.set(a);
        }
    };
    private final Procedure1<UnsignedInt10Member> ZER = new Procedure1<UnsignedInt10Member>(){

        @Override
        public void call(UnsignedInt10Member a) {
            a.v = 0;
        }
    };
    private final Procedure3<UnsignedInt10Member, UnsignedInt10Member, UnsignedInt10Member> ADD = new Procedure3<UnsignedInt10Member, UnsignedInt10Member, UnsignedInt10Member>(){

        @Override
        public void call(UnsignedInt10Member a, UnsignedInt10Member b, UnsignedInt10Member c) {
            c.setV(a.v + b.v);
        }
    };
    private final Procedure3<UnsignedInt10Member, UnsignedInt10Member, UnsignedInt10Member> SUB = new Procedure3<UnsignedInt10Member, UnsignedInt10Member, UnsignedInt10Member>(){

        @Override
        public void call(UnsignedInt10Member a, UnsignedInt10Member b, UnsignedInt10Member c) {
            c.setV(a.v - b.v);
        }
    };
    private final Procedure3<UnsignedInt10Member, UnsignedInt10Member, UnsignedInt10Member> MUL = new Procedure3<UnsignedInt10Member, UnsignedInt10Member, UnsignedInt10Member>(){

        @Override
        public void call(UnsignedInt10Member a, UnsignedInt10Member b, UnsignedInt10Member c) {
            c.setV(a.v * b.v);
        }
    };
    private final Procedure3<java.lang.Integer, UnsignedInt10Member, UnsignedInt10Member> POWER = new Procedure3<java.lang.Integer, UnsignedInt10Member, UnsignedInt10Member>(){

        @Override
        public void call(java.lang.Integer power, UnsignedInt10Member a, UnsignedInt10Member b) {
            PowerNonNegative.compute(G.UINT10, power, a, b);
        }
    };
    private final Procedure1<UnsignedInt10Member> UNITY = new Procedure1<UnsignedInt10Member>(){

        @Override
        public void call(UnsignedInt10Member a) {
            a.v = 1;
        }
    };
    private final Function2<Boolean, UnsignedInt10Member, UnsignedInt10Member> LESS = new Function2<Boolean, UnsignedInt10Member, UnsignedInt10Member>(){

        @Override
        public Boolean call(UnsignedInt10Member a, UnsignedInt10Member b) {
            return a.v < b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt10Member, UnsignedInt10Member> LE = new Function2<Boolean, UnsignedInt10Member, UnsignedInt10Member>(){

        @Override
        public Boolean call(UnsignedInt10Member a, UnsignedInt10Member b) {
            return a.v <= b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt10Member, UnsignedInt10Member> GREAT = new Function2<Boolean, UnsignedInt10Member, UnsignedInt10Member>(){

        @Override
        public Boolean call(UnsignedInt10Member a, UnsignedInt10Member b) {
            return a.v > b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt10Member, UnsignedInt10Member> GE = new Function2<Boolean, UnsignedInt10Member, UnsignedInt10Member>(){

        @Override
        public Boolean call(UnsignedInt10Member a, UnsignedInt10Member b) {
            return a.v >= b.v;
        }
    };
    private final Function2<java.lang.Integer, UnsignedInt10Member, UnsignedInt10Member> CMP = new Function2<java.lang.Integer, UnsignedInt10Member, UnsignedInt10Member>(){

        @Override
        public java.lang.Integer call(UnsignedInt10Member a, UnsignedInt10Member b) {
            if (a.v < b.v) {
                return -1;
            }
            if (a.v > b.v) {
                return 1;
            }
            return 0;
        }
    };
    private final Function1<java.lang.Integer, UnsignedInt10Member> SIG = new Function1<java.lang.Integer, UnsignedInt10Member>(){

        @Override
        public java.lang.Integer call(UnsignedInt10Member a) {
            if (a.v < 0) {
                return -1;
            }
            if (a.v > 0) {
                return 1;
            }
            return 0;
        }
    };
    private final Procedure3<UnsignedInt10Member, UnsignedInt10Member, UnsignedInt10Member> MIN = new Procedure3<UnsignedInt10Member, UnsignedInt10Member, UnsignedInt10Member>(){

        @Override
        public void call(UnsignedInt10Member a, UnsignedInt10Member b, UnsignedInt10Member c) {
            if (a.v < b.v) {
                c.set(a);
            } else {
                c.set(b);
            }
        }
    };
    private final Procedure3<UnsignedInt10Member, UnsignedInt10Member, UnsignedInt10Member> MAX = new Procedure3<UnsignedInt10Member, UnsignedInt10Member, UnsignedInt10Member>(){

        @Override
        public void call(UnsignedInt10Member a, UnsignedInt10Member b, UnsignedInt10Member c) {
            if (a.v > b.v) {
                c.set(a);
            } else {
                c.set(b);
            }
        }
    };
    private final Procedure3<UnsignedInt10Member, UnsignedInt10Member, UnsignedInt10Member> GCD = new Procedure3<UnsignedInt10Member, UnsignedInt10Member, UnsignedInt10Member>(){

        @Override
        public void call(UnsignedInt10Member a, UnsignedInt10Member b, UnsignedInt10Member c) {
            Gcd.compute(G.UINT10, a, b, c);
        }
    };
    private final Procedure3<UnsignedInt10Member, UnsignedInt10Member, UnsignedInt10Member> LCM = new Procedure3<UnsignedInt10Member, UnsignedInt10Member, UnsignedInt10Member>(){

        @Override
        public void call(UnsignedInt10Member a, UnsignedInt10Member b, UnsignedInt10Member c) {
            Lcm.compute(G.UINT10, a, b, c);
        }
    };
    private final Function1<Boolean, UnsignedInt10Member> EVEN = new Function1<Boolean, UnsignedInt10Member>(){

        @Override
        public Boolean call(UnsignedInt10Member a) {
            return (a.v & 1) == 0;
        }
    };
    private final Function1<Boolean, UnsignedInt10Member> ODD = new Function1<Boolean, UnsignedInt10Member>(){

        @Override
        public Boolean call(UnsignedInt10Member a) {
            return (a.v & 1) == 1;
        }
    };
    private final Procedure3<UnsignedInt10Member, UnsignedInt10Member, UnsignedInt10Member> DIV = new Procedure3<UnsignedInt10Member, UnsignedInt10Member, UnsignedInt10Member>(){

        @Override
        public void call(UnsignedInt10Member a, UnsignedInt10Member b, UnsignedInt10Member d) {
            d.setV(a.v / b.v);
        }
    };
    private final Procedure3<UnsignedInt10Member, UnsignedInt10Member, UnsignedInt10Member> MOD = new Procedure3<UnsignedInt10Member, UnsignedInt10Member, UnsignedInt10Member>(){

        @Override
        public void call(UnsignedInt10Member a, UnsignedInt10Member b, UnsignedInt10Member m) {
            m.setV(a.v % b.v);
        }
    };
    private final Procedure4<UnsignedInt10Member, UnsignedInt10Member, UnsignedInt10Member, UnsignedInt10Member> DIVMOD = new Procedure4<UnsignedInt10Member, UnsignedInt10Member, UnsignedInt10Member, UnsignedInt10Member>(){

        @Override
        public void call(UnsignedInt10Member a, UnsignedInt10Member b, UnsignedInt10Member d, UnsignedInt10Member m) {
            UnsignedInt10Algebra.this.div().call(a, b, d);
            UnsignedInt10Algebra.this.mod().call(a, b, m);
        }
    };
    private final Procedure2<UnsignedInt10Member, UnsignedInt10Member> PRED = new Procedure2<UnsignedInt10Member, UnsignedInt10Member>(){

        @Override
        public void call(UnsignedInt10Member a, UnsignedInt10Member b) {
            if (a.v == 0) {
                b.v = (short)1023;
            } else {
                b.setV(a.v - 1);
            }
        }
    };
    private final Procedure2<UnsignedInt10Member, UnsignedInt10Member> SUCC = new Procedure2<UnsignedInt10Member, UnsignedInt10Member>(){

        @Override
        public void call(UnsignedInt10Member a, UnsignedInt10Member b) {
            if (a.v == 1023) {
                b.v = 0;
            } else {
                b.setV(a.v + 1);
            }
        }
    };
    private final Procedure3<UnsignedInt10Member, UnsignedInt10Member, UnsignedInt10Member> POW = new Procedure3<UnsignedInt10Member, UnsignedInt10Member, UnsignedInt10Member>(){

        @Override
        public void call(UnsignedInt10Member a, UnsignedInt10Member b, UnsignedInt10Member c) {
            PowerNonNegative.compute(G.UINT10, b.v, a, c);
        }
    };
    private final Procedure1<UnsignedInt10Member> RAND = new Procedure1<UnsignedInt10Member>(){

        @Override
        public void call(UnsignedInt10Member a) {
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            a.setV(rng.nextInt(1024));
        }
    };
    private final Procedure3<UnsignedInt10Member, UnsignedInt10Member, UnsignedInt10Member> AND = new Procedure3<UnsignedInt10Member, UnsignedInt10Member, UnsignedInt10Member>(){

        @Override
        public void call(UnsignedInt10Member a, UnsignedInt10Member b, UnsignedInt10Member c) {
            c.setV(a.v & b.v);
        }
    };
    private final Procedure3<UnsignedInt10Member, UnsignedInt10Member, UnsignedInt10Member> OR = new Procedure3<UnsignedInt10Member, UnsignedInt10Member, UnsignedInt10Member>(){

        @Override
        public void call(UnsignedInt10Member a, UnsignedInt10Member b, UnsignedInt10Member c) {
            c.setV(a.v | b.v);
        }
    };
    private final Procedure3<UnsignedInt10Member, UnsignedInt10Member, UnsignedInt10Member> XOR = new Procedure3<UnsignedInt10Member, UnsignedInt10Member, UnsignedInt10Member>(){

        @Override
        public void call(UnsignedInt10Member a, UnsignedInt10Member b, UnsignedInt10Member c) {
            c.setV(a.v ^ b.v);
        }
    };
    private final Procedure2<UnsignedInt10Member, UnsignedInt10Member> NOT = new Procedure2<UnsignedInt10Member, UnsignedInt10Member>(){

        @Override
        public void call(UnsignedInt10Member a, UnsignedInt10Member b) {
            b.setV(~a.v);
        }
    };
    private final Procedure3<UnsignedInt10Member, UnsignedInt10Member, UnsignedInt10Member> ANDNOT = new Procedure3<UnsignedInt10Member, UnsignedInt10Member, UnsignedInt10Member>(){

        @Override
        public void call(UnsignedInt10Member a, UnsignedInt10Member b, UnsignedInt10Member c) {
            c.setV(a.v & ~b.v);
        }
    };
    private final Procedure3<java.lang.Integer, UnsignedInt10Member, UnsignedInt10Member> SHL = new Procedure3<java.lang.Integer, UnsignedInt10Member, UnsignedInt10Member>(){

        @Override
        public void call(java.lang.Integer count, UnsignedInt10Member a, UnsignedInt10Member b) {
            if (count < 0) {
                UnsignedInt10Algebra.this.bitShiftRight().call(-count.intValue(), a, b);
            } else {
                count = count % 10;
                b.setV(a.v << count);
            }
        }
    };
    private final Procedure3<java.lang.Integer, UnsignedInt10Member, UnsignedInt10Member> SHRZ = new Procedure3<java.lang.Integer, UnsignedInt10Member, UnsignedInt10Member>(){

        @Override
        public void call(java.lang.Integer count, UnsignedInt10Member a, UnsignedInt10Member b) {
            if (count < 0) {
                UnsignedInt10Algebra.this.bitShiftLeft().call(-count.intValue(), a, b);
            } else {
                b.setV(a.v >>> count);
            }
        }
    };
    private final Procedure1<UnsignedInt10Member> MAXBOUND = new Procedure1<UnsignedInt10Member>(){

        @Override
        public void call(UnsignedInt10Member a) {
            a.v = (short)1023;
        }
    };
    private final Procedure1<UnsignedInt10Member> MINBOUND = new Procedure1<UnsignedInt10Member>(){

        @Override
        public void call(UnsignedInt10Member a) {
            a.v = 0;
        }
    };
    private final Function1<Boolean, UnsignedInt10Member> ISZERO = new Function1<Boolean, UnsignedInt10Member>(){

        @Override
        public Boolean call(UnsignedInt10Member a) {
            return a.v == 0;
        }
    };
    private final Procedure3<HighPrecisionMember, UnsignedInt10Member, UnsignedInt10Member> SBHP = new Procedure3<HighPrecisionMember, UnsignedInt10Member, UnsignedInt10Member>(){

        @Override
        public void call(HighPrecisionMember a, UnsignedInt10Member b, UnsignedInt10Member c) {
            BigDecimal tmp = a.v();
            tmp = tmp.multiply(new BigDecimal(b.v()));
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<HighPrecisionMember, UnsignedInt10Member, UnsignedInt10Member> SBHPR = new Procedure3<HighPrecisionMember, UnsignedInt10Member, UnsignedInt10Member>(){

        @Override
        public void call(HighPrecisionMember a, UnsignedInt10Member b, UnsignedInt10Member c) {
            BigDecimal tmp = a.v();
            int signum = (tmp = tmp.multiply(new BigDecimal(b.v()))).signum();
            tmp = signum < 0 ? tmp.subtract(G.ONE_HALF) : tmp.add(G.ONE_HALF);
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<RationalMember, UnsignedInt10Member, UnsignedInt10Member> SBR = new Procedure3<RationalMember, UnsignedInt10Member, UnsignedInt10Member>(){

        @Override
        public void call(RationalMember a, UnsignedInt10Member b, UnsignedInt10Member c) {
            BigInteger tmp = BigInteger.valueOf(b.v());
            tmp = tmp.multiply(a.n());
            tmp = tmp.divide(a.d());
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<Double, UnsignedInt10Member, UnsignedInt10Member> SBD = new Procedure3<Double, UnsignedInt10Member, UnsignedInt10Member>(){

        @Override
        public void call(Double a, UnsignedInt10Member b, UnsignedInt10Member c) {
            c.setV((int)(a * (double)b.v()));
        }
    };
    private final Procedure3<Double, UnsignedInt10Member, UnsignedInt10Member> SBDR = new Procedure3<Double, UnsignedInt10Member, UnsignedInt10Member>(){

        @Override
        public void call(Double a, UnsignedInt10Member b, UnsignedInt10Member c) {
            c.setV((int)Math.round(a * (double)b.v()));
        }
    };
    private final Function3<Boolean, UnsignedInt10Member, UnsignedInt10Member, UnsignedInt10Member> WITHIN = new Function3<Boolean, UnsignedInt10Member, UnsignedInt10Member, UnsignedInt10Member>(){

        @Override
        public Boolean call(UnsignedInt10Member tol, UnsignedInt10Member a, UnsignedInt10Member b) {
            return NumberWithin.compute(G.UINT10, tol, a, b);
        }
    };

    @Override
    public UnsignedInt10Member construct() {
        return new UnsignedInt10Member();
    }

    @Override
    public UnsignedInt10Member construct(UnsignedInt10Member other) {
        return new UnsignedInt10Member(other);
    }

    @Override
    public UnsignedInt10Member construct(String str) {
        return new UnsignedInt10Member(str);
    }

    @Override
    public Function2<Boolean, UnsignedInt10Member, UnsignedInt10Member> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, UnsignedInt10Member, UnsignedInt10Member> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<UnsignedInt10Member, UnsignedInt10Member> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure1<UnsignedInt10Member> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<UnsignedInt10Member, UnsignedInt10Member> negate() {
        return this.ASSIGN;
    }

    @Override
    public Procedure3<UnsignedInt10Member, UnsignedInt10Member, UnsignedInt10Member> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<UnsignedInt10Member, UnsignedInt10Member, UnsignedInt10Member> subtract() {
        return this.SUB;
    }

    @Override
    public Procedure3<UnsignedInt10Member, UnsignedInt10Member, UnsignedInt10Member> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt10Member, UnsignedInt10Member> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<UnsignedInt10Member> unity() {
        return this.UNITY;
    }

    @Override
    public Function2<Boolean, UnsignedInt10Member, UnsignedInt10Member> isLess() {
        return this.LESS;
    }

    @Override
    public Function2<Boolean, UnsignedInt10Member, UnsignedInt10Member> isLessEqual() {
        return this.LE;
    }

    @Override
    public Function2<Boolean, UnsignedInt10Member, UnsignedInt10Member> isGreater() {
        return this.GREAT;
    }

    @Override
    public Function2<Boolean, UnsignedInt10Member, UnsignedInt10Member> isGreaterEqual() {
        return this.GE;
    }

    @Override
    public Function2<java.lang.Integer, UnsignedInt10Member, UnsignedInt10Member> compare() {
        return this.CMP;
    }

    @Override
    public Function1<java.lang.Integer, UnsignedInt10Member> signum() {
        return this.SIG;
    }

    @Override
    public Procedure3<UnsignedInt10Member, UnsignedInt10Member, UnsignedInt10Member> min() {
        return this.MIN;
    }

    @Override
    public Procedure3<UnsignedInt10Member, UnsignedInt10Member, UnsignedInt10Member> max() {
        return this.MAX;
    }

    @Override
    public Procedure2<UnsignedInt10Member, UnsignedInt10Member> abs() {
        return this.ASSIGN;
    }

    @Override
    public Procedure2<UnsignedInt10Member, UnsignedInt10Member> norm() {
        return this.ASSIGN;
    }

    @Override
    public Procedure3<UnsignedInt10Member, UnsignedInt10Member, UnsignedInt10Member> gcd() {
        return this.GCD;
    }

    @Override
    public Procedure3<UnsignedInt10Member, UnsignedInt10Member, UnsignedInt10Member> lcm() {
        return this.LCM;
    }

    @Override
    public Function1<Boolean, UnsignedInt10Member> isEven() {
        return this.EVEN;
    }

    @Override
    public Function1<Boolean, UnsignedInt10Member> isOdd() {
        return this.ODD;
    }

    @Override
    public Procedure3<UnsignedInt10Member, UnsignedInt10Member, UnsignedInt10Member> div() {
        return this.DIV;
    }

    @Override
    public Procedure3<UnsignedInt10Member, UnsignedInt10Member, UnsignedInt10Member> mod() {
        return this.MOD;
    }

    @Override
    public Procedure4<UnsignedInt10Member, UnsignedInt10Member, UnsignedInt10Member, UnsignedInt10Member> divMod() {
        return this.DIVMOD;
    }

    @Override
    public Procedure2<UnsignedInt10Member, UnsignedInt10Member> pred() {
        return this.PRED;
    }

    @Override
    public Procedure2<UnsignedInt10Member, UnsignedInt10Member> succ() {
        return this.SUCC;
    }

    @Override
    public Procedure3<UnsignedInt10Member, UnsignedInt10Member, UnsignedInt10Member> pow() {
        return this.POW;
    }

    @Override
    public Procedure1<UnsignedInt10Member> random() {
        return this.RAND;
    }

    @Override
    public Procedure3<UnsignedInt10Member, UnsignedInt10Member, UnsignedInt10Member> bitAnd() {
        return this.AND;
    }

    @Override
    public Procedure3<UnsignedInt10Member, UnsignedInt10Member, UnsignedInt10Member> bitOr() {
        return this.OR;
    }

    @Override
    public Procedure3<UnsignedInt10Member, UnsignedInt10Member, UnsignedInt10Member> bitXor() {
        return this.XOR;
    }

    @Override
    public Procedure2<UnsignedInt10Member, UnsignedInt10Member> bitNot() {
        return this.NOT;
    }

    @Override
    public Procedure3<UnsignedInt10Member, UnsignedInt10Member, UnsignedInt10Member> bitAndNot() {
        return this.ANDNOT;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt10Member, UnsignedInt10Member> bitShiftLeft() {
        return this.SHL;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt10Member, UnsignedInt10Member> bitShiftRight() {
        return this.SHRZ;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt10Member, UnsignedInt10Member> bitShiftRightFillZero() {
        return this.SHRZ;
    }

    @Override
    public Procedure1<UnsignedInt10Member> maxBound() {
        return this.MAXBOUND;
    }

    @Override
    public Procedure1<UnsignedInt10Member> minBound() {
        return this.MINBOUND;
    }

    @Override
    public Function1<Boolean, UnsignedInt10Member> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<UnsignedInt10Member, UnsignedInt10Member, UnsignedInt10Member> scale() {
        return this.MUL;
    }

    @Override
    public Procedure3<HighPrecisionMember, UnsignedInt10Member, UnsignedInt10Member> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<HighPrecisionMember, UnsignedInt10Member, UnsignedInt10Member> scaleByHighPrecAndRound() {
        return this.SBHPR;
    }

    @Override
    public Procedure3<RationalMember, UnsignedInt10Member, UnsignedInt10Member> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, UnsignedInt10Member, UnsignedInt10Member> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<Double, UnsignedInt10Member, UnsignedInt10Member> scaleByDoubleAndRound() {
        return this.SBDR;
    }

    @Override
    public Function3<Boolean, UnsignedInt10Member, UnsignedInt10Member, UnsignedInt10Member> within() {
        return this.WITHIN;
    }
}

