/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.int11;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.ThreadLocalRandom;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.Gcd;
import nom.bdezonia.zorbage.algorithm.Lcm;
import nom.bdezonia.zorbage.algorithm.NumberWithin;
import nom.bdezonia.zorbage.algorithm.PowerNonNegative;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.BitOperations;
import nom.bdezonia.zorbage.type.algebra.Bounded;
import nom.bdezonia.zorbage.type.algebra.Integer;
import nom.bdezonia.zorbage.type.algebra.Random;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.int11.SignedInt11Member;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class SignedInt11Algebra
implements Integer<SignedInt11Algebra, SignedInt11Member>,
Bounded<SignedInt11Member>,
BitOperations<SignedInt11Member>,
Random<SignedInt11Member>,
Tolerance<SignedInt11Member, SignedInt11Member> {
    private final Function2<Boolean, SignedInt11Member, SignedInt11Member> EQ = new Function2<Boolean, SignedInt11Member, SignedInt11Member>(){

        @Override
        public Boolean call(SignedInt11Member a, SignedInt11Member b) {
            return a.v == b.v;
        }
    };
    private final Function2<Boolean, SignedInt11Member, SignedInt11Member> NEQ = new Function2<Boolean, SignedInt11Member, SignedInt11Member>(){

        @Override
        public Boolean call(SignedInt11Member a, SignedInt11Member b) {
            return a.v != b.v;
        }
    };
    private final Procedure2<SignedInt11Member, SignedInt11Member> ASSIGN = new Procedure2<SignedInt11Member, SignedInt11Member>(){

        @Override
        public void call(SignedInt11Member a, SignedInt11Member b) {
            b.set(a);
        }
    };
    private final Procedure1<SignedInt11Member> ZER = new Procedure1<SignedInt11Member>(){

        @Override
        public void call(SignedInt11Member a) {
            a.v = 0;
        }
    };
    private final Procedure2<SignedInt11Member, SignedInt11Member> NEG = new Procedure2<SignedInt11Member, SignedInt11Member>(){

        @Override
        public void call(SignedInt11Member a, SignedInt11Member b) {
            if (a.v == -1024) {
                throw new IllegalArgumentException("Cannot convert -minint symmetrically");
            }
            b.v = -a.v;
        }
    };
    private final Procedure3<SignedInt11Member, SignedInt11Member, SignedInt11Member> ADD = new Procedure3<SignedInt11Member, SignedInt11Member, SignedInt11Member>(){

        @Override
        public void call(SignedInt11Member a, SignedInt11Member b, SignedInt11Member c) {
            c.setV(a.v + b.v);
        }
    };
    private final Procedure3<SignedInt11Member, SignedInt11Member, SignedInt11Member> SUB = new Procedure3<SignedInt11Member, SignedInt11Member, SignedInt11Member>(){

        @Override
        public void call(SignedInt11Member a, SignedInt11Member b, SignedInt11Member c) {
            c.setV(a.v - b.v);
        }
    };
    private final Procedure3<SignedInt11Member, SignedInt11Member, SignedInt11Member> MUL = new Procedure3<SignedInt11Member, SignedInt11Member, SignedInt11Member>(){

        @Override
        public void call(SignedInt11Member a, SignedInt11Member b, SignedInt11Member c) {
            c.setV(a.v * b.v);
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt11Member, SignedInt11Member> POWER = new Procedure3<java.lang.Integer, SignedInt11Member, SignedInt11Member>(){

        @Override
        public void call(java.lang.Integer power, SignedInt11Member a, SignedInt11Member b) {
            PowerNonNegative.compute(G.INT11, power, a, b);
        }
    };
    private final Procedure1<SignedInt11Member> UNITY = new Procedure1<SignedInt11Member>(){

        @Override
        public void call(SignedInt11Member a) {
            a.v = 1;
        }
    };
    private final Function2<Boolean, SignedInt11Member, SignedInt11Member> LESS = new Function2<Boolean, SignedInt11Member, SignedInt11Member>(){

        @Override
        public Boolean call(SignedInt11Member a, SignedInt11Member b) {
            return a.v < b.v;
        }
    };
    private final Function2<Boolean, SignedInt11Member, SignedInt11Member> LE = new Function2<Boolean, SignedInt11Member, SignedInt11Member>(){

        @Override
        public Boolean call(SignedInt11Member a, SignedInt11Member b) {
            return a.v <= b.v;
        }
    };
    private final Function2<Boolean, SignedInt11Member, SignedInt11Member> GREAT = new Function2<Boolean, SignedInt11Member, SignedInt11Member>(){

        @Override
        public Boolean call(SignedInt11Member a, SignedInt11Member b) {
            return a.v > b.v;
        }
    };
    private final Function2<Boolean, SignedInt11Member, SignedInt11Member> GE = new Function2<Boolean, SignedInt11Member, SignedInt11Member>(){

        @Override
        public Boolean call(SignedInt11Member a, SignedInt11Member b) {
            return a.v >= b.v;
        }
    };
    private final Function2<java.lang.Integer, SignedInt11Member, SignedInt11Member> CMP = new Function2<java.lang.Integer, SignedInt11Member, SignedInt11Member>(){

        @Override
        public java.lang.Integer call(SignedInt11Member a, SignedInt11Member b) {
            if (a.v < b.v) {
                return -1;
            }
            if (a.v > b.v) {
                return 1;
            }
            return 0;
        }
    };
    private final Function1<java.lang.Integer, SignedInt11Member> SIG = new Function1<java.lang.Integer, SignedInt11Member>(){

        @Override
        public java.lang.Integer call(SignedInt11Member a) {
            if (a.v < 0) {
                return -1;
            }
            if (a.v > 0) {
                return 1;
            }
            return 0;
        }
    };
    private final Procedure3<SignedInt11Member, SignedInt11Member, SignedInt11Member> MIN = new Procedure3<SignedInt11Member, SignedInt11Member, SignedInt11Member>(){

        @Override
        public void call(SignedInt11Member a, SignedInt11Member b, SignedInt11Member c) {
            if (a.v < b.v) {
                c.set(a);
            } else {
                c.set(b);
            }
        }
    };
    private final Procedure3<SignedInt11Member, SignedInt11Member, SignedInt11Member> MAX = new Procedure3<SignedInt11Member, SignedInt11Member, SignedInt11Member>(){

        @Override
        public void call(SignedInt11Member a, SignedInt11Member b, SignedInt11Member c) {
            if (a.v > b.v) {
                c.set(a);
            } else {
                c.set(b);
            }
        }
    };
    private final Procedure2<SignedInt11Member, SignedInt11Member> ABS = new Procedure2<SignedInt11Member, SignedInt11Member>(){

        @Override
        public void call(SignedInt11Member a, SignedInt11Member b) {
            if (a.v == -1024) {
                throw new IllegalArgumentException("Cannot convert -minint symmetrically");
            }
            b.v = a.v < 0 ? (short)(-a.v) : a.v;
        }
    };
    private final Procedure3<SignedInt11Member, SignedInt11Member, SignedInt11Member> GCD = new Procedure3<SignedInt11Member, SignedInt11Member, SignedInt11Member>(){

        @Override
        public void call(SignedInt11Member a, SignedInt11Member b, SignedInt11Member c) {
            Gcd.compute(G.INT11, a, b, c);
        }
    };
    private final Procedure3<SignedInt11Member, SignedInt11Member, SignedInt11Member> LCM = new Procedure3<SignedInt11Member, SignedInt11Member, SignedInt11Member>(){

        @Override
        public void call(SignedInt11Member a, SignedInt11Member b, SignedInt11Member c) {
            Lcm.compute(G.INT11, a, b, c);
        }
    };
    private final Function1<Boolean, SignedInt11Member> EVEN = new Function1<Boolean, SignedInt11Member>(){

        @Override
        public Boolean call(SignedInt11Member a) {
            return (a.v & 1) == 0;
        }
    };
    private final Function1<Boolean, SignedInt11Member> ODD = new Function1<Boolean, SignedInt11Member>(){

        @Override
        public Boolean call(SignedInt11Member a) {
            return (a.v & 1) == 1;
        }
    };
    private final Procedure3<SignedInt11Member, SignedInt11Member, SignedInt11Member> DIV = new Procedure3<SignedInt11Member, SignedInt11Member, SignedInt11Member>(){

        @Override
        public void call(SignedInt11Member a, SignedInt11Member b, SignedInt11Member d) {
            if (b.v == -1 && a.v == -1024) {
                throw new IllegalArgumentException("cannot divide minint by -1");
            }
            d.setV(a.v / b.v);
        }
    };
    private final Procedure3<SignedInt11Member, SignedInt11Member, SignedInt11Member> MOD = new Procedure3<SignedInt11Member, SignedInt11Member, SignedInt11Member>(){

        @Override
        public void call(SignedInt11Member a, SignedInt11Member b, SignedInt11Member m) {
            m.setV(a.v % b.v);
        }
    };
    private final Procedure4<SignedInt11Member, SignedInt11Member, SignedInt11Member, SignedInt11Member> DIVMOD = new Procedure4<SignedInt11Member, SignedInt11Member, SignedInt11Member, SignedInt11Member>(){

        @Override
        public void call(SignedInt11Member a, SignedInt11Member b, SignedInt11Member d, SignedInt11Member m) {
            SignedInt11Algebra.this.div().call(a, b, d);
            SignedInt11Algebra.this.mod().call(a, b, m);
        }
    };
    private final Procedure2<SignedInt11Member, SignedInt11Member> PRED = new Procedure2<SignedInt11Member, SignedInt11Member>(){

        @Override
        public void call(SignedInt11Member a, SignedInt11Member b) {
            if (a.v == -1024) {
                b.v = (short)1023;
            } else {
                b.setV(a.v - 1);
            }
        }
    };
    private final Procedure2<SignedInt11Member, SignedInt11Member> SUCC = new Procedure2<SignedInt11Member, SignedInt11Member>(){

        @Override
        public void call(SignedInt11Member a, SignedInt11Member b) {
            if (a.v == 1023) {
                b.v = (short)-1024;
            } else {
                b.setV(a.v + 1);
            }
        }
    };
    private final Procedure3<SignedInt11Member, SignedInt11Member, SignedInt11Member> POW = new Procedure3<SignedInt11Member, SignedInt11Member, SignedInt11Member>(){

        @Override
        public void call(SignedInt11Member a, SignedInt11Member b, SignedInt11Member c) {
            PowerNonNegative.compute(G.INT11, b.v, a, c);
        }
    };
    private final Procedure1<SignedInt11Member> RAND = new Procedure1<SignedInt11Member>(){

        @Override
        public void call(SignedInt11Member a) {
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            a.setV(rng.nextInt(2048) - 1024);
        }
    };
    private final Procedure3<SignedInt11Member, SignedInt11Member, SignedInt11Member> AND = new Procedure3<SignedInt11Member, SignedInt11Member, SignedInt11Member>(){

        @Override
        public void call(SignedInt11Member a, SignedInt11Member b, SignedInt11Member c) {
            c.setV(a.v & b.v);
        }
    };
    private final Procedure3<SignedInt11Member, SignedInt11Member, SignedInt11Member> OR = new Procedure3<SignedInt11Member, SignedInt11Member, SignedInt11Member>(){

        @Override
        public void call(SignedInt11Member a, SignedInt11Member b, SignedInt11Member c) {
            c.setV(a.v | b.v);
        }
    };
    private final Procedure3<SignedInt11Member, SignedInt11Member, SignedInt11Member> XOR = new Procedure3<SignedInt11Member, SignedInt11Member, SignedInt11Member>(){

        @Override
        public void call(SignedInt11Member a, SignedInt11Member b, SignedInt11Member c) {
            c.setV(a.v ^ b.v);
        }
    };
    private final Procedure2<SignedInt11Member, SignedInt11Member> NOT = new Procedure2<SignedInt11Member, SignedInt11Member>(){

        @Override
        public void call(SignedInt11Member a, SignedInt11Member b) {
            b.setV(~a.v);
        }
    };
    private final Procedure3<SignedInt11Member, SignedInt11Member, SignedInt11Member> ANDNOT = new Procedure3<SignedInt11Member, SignedInt11Member, SignedInt11Member>(){

        @Override
        public void call(SignedInt11Member a, SignedInt11Member b, SignedInt11Member c) {
            c.setV(a.v & ~b.v);
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt11Member, SignedInt11Member> SHL = new Procedure3<java.lang.Integer, SignedInt11Member, SignedInt11Member>(){

        @Override
        public void call(java.lang.Integer count, SignedInt11Member a, SignedInt11Member b) {
            if (count < 0) {
                SignedInt11Algebra.this.bitShiftRight().call(-count.intValue(), a, b);
            } else {
                count = count % 11;
                b.setV(a.v << count);
            }
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt11Member, SignedInt11Member> SHR = new Procedure3<java.lang.Integer, SignedInt11Member, SignedInt11Member>(){

        @Override
        public void call(java.lang.Integer count, SignedInt11Member a, SignedInt11Member b) {
            if (count < 0) {
                SignedInt11Algebra.this.bitShiftLeft().call(-count.intValue(), a, b);
            } else {
                int val = a.v >> count;
                if (a.v < 0 && val == 0) {
                    b.v = (short)-1;
                } else {
                    b.setV(val);
                }
            }
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt11Member, SignedInt11Member> SHRZ = new Procedure3<java.lang.Integer, SignedInt11Member, SignedInt11Member>(){

        @Override
        public void call(java.lang.Integer count, SignedInt11Member a, SignedInt11Member b) {
            if (count < 0) {
                SignedInt11Algebra.this.bitShiftLeft().call(-count.intValue(), a, b);
            } else {
                b.setV(a.v >>> count);
            }
        }
    };
    private final Procedure1<SignedInt11Member> MAXBOUND = new Procedure1<SignedInt11Member>(){

        @Override
        public void call(SignedInt11Member a) {
            a.v = (short)1023;
        }
    };
    private final Procedure1<SignedInt11Member> MINBOUND = new Procedure1<SignedInt11Member>(){

        @Override
        public void call(SignedInt11Member a) {
            a.v = (short)-1024;
        }
    };
    private final Function1<Boolean, SignedInt11Member> ISZERO = new Function1<Boolean, SignedInt11Member>(){

        @Override
        public Boolean call(SignedInt11Member a) {
            return a.v == 0;
        }
    };
    private final Procedure3<HighPrecisionMember, SignedInt11Member, SignedInt11Member> SBHP = new Procedure3<HighPrecisionMember, SignedInt11Member, SignedInt11Member>(){

        @Override
        public void call(HighPrecisionMember a, SignedInt11Member b, SignedInt11Member c) {
            BigDecimal tmp = a.v();
            tmp = tmp.multiply(new BigDecimal(b.v()));
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<HighPrecisionMember, SignedInt11Member, SignedInt11Member> SBHPR = new Procedure3<HighPrecisionMember, SignedInt11Member, SignedInt11Member>(){

        @Override
        public void call(HighPrecisionMember a, SignedInt11Member b, SignedInt11Member c) {
            BigDecimal tmp = a.v();
            int signum = (tmp = tmp.multiply(new BigDecimal(b.v()))).signum();
            tmp = signum < 0 ? tmp.subtract(G.ONE_HALF) : tmp.add(G.ONE_HALF);
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<RationalMember, SignedInt11Member, SignedInt11Member> SBR = new Procedure3<RationalMember, SignedInt11Member, SignedInt11Member>(){

        @Override
        public void call(RationalMember a, SignedInt11Member b, SignedInt11Member c) {
            BigInteger tmp = BigInteger.valueOf(b.v());
            tmp = tmp.multiply(a.n());
            tmp = tmp.divide(a.d());
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<Double, SignedInt11Member, SignedInt11Member> SBD = new Procedure3<Double, SignedInt11Member, SignedInt11Member>(){

        @Override
        public void call(Double a, SignedInt11Member b, SignedInt11Member c) {
            c.setV((int)(a * (double)b.v()));
        }
    };
    private final Procedure3<Double, SignedInt11Member, SignedInt11Member> SBDR = new Procedure3<Double, SignedInt11Member, SignedInt11Member>(){

        @Override
        public void call(Double a, SignedInt11Member b, SignedInt11Member c) {
            c.setV((int)Math.round(a * (double)b.v()));
        }
    };
    private final Function3<Boolean, SignedInt11Member, SignedInt11Member, SignedInt11Member> WITHIN = new Function3<Boolean, SignedInt11Member, SignedInt11Member, SignedInt11Member>(){

        @Override
        public Boolean call(SignedInt11Member tol, SignedInt11Member a, SignedInt11Member b) {
            return NumberWithin.compute(G.INT11, tol, a, b);
        }
    };

    @Override
    public SignedInt11Member construct() {
        return new SignedInt11Member();
    }

    @Override
    public SignedInt11Member construct(SignedInt11Member other) {
        return new SignedInt11Member(other);
    }

    @Override
    public SignedInt11Member construct(String str) {
        return new SignedInt11Member(str);
    }

    @Override
    public Function2<Boolean, SignedInt11Member, SignedInt11Member> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, SignedInt11Member, SignedInt11Member> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<SignedInt11Member, SignedInt11Member> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure1<SignedInt11Member> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<SignedInt11Member, SignedInt11Member> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<SignedInt11Member, SignedInt11Member, SignedInt11Member> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<SignedInt11Member, SignedInt11Member, SignedInt11Member> subtract() {
        return this.SUB;
    }

    @Override
    public Procedure3<SignedInt11Member, SignedInt11Member, SignedInt11Member> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt11Member, SignedInt11Member> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<SignedInt11Member> unity() {
        return this.UNITY;
    }

    @Override
    public Function2<Boolean, SignedInt11Member, SignedInt11Member> isLess() {
        return this.LESS;
    }

    @Override
    public Function2<Boolean, SignedInt11Member, SignedInt11Member> isLessEqual() {
        return this.LE;
    }

    @Override
    public Function2<Boolean, SignedInt11Member, SignedInt11Member> isGreater() {
        return this.GREAT;
    }

    @Override
    public Function2<Boolean, SignedInt11Member, SignedInt11Member> isGreaterEqual() {
        return this.GE;
    }

    @Override
    public Function2<java.lang.Integer, SignedInt11Member, SignedInt11Member> compare() {
        return this.CMP;
    }

    @Override
    public Function1<java.lang.Integer, SignedInt11Member> signum() {
        return this.SIG;
    }

    @Override
    public Procedure3<SignedInt11Member, SignedInt11Member, SignedInt11Member> min() {
        return this.MIN;
    }

    @Override
    public Procedure3<SignedInt11Member, SignedInt11Member, SignedInt11Member> max() {
        return this.MAX;
    }

    @Override
    public Procedure2<SignedInt11Member, SignedInt11Member> abs() {
        return this.ABS;
    }

    @Override
    public Procedure2<SignedInt11Member, SignedInt11Member> norm() {
        return this.ABS;
    }

    @Override
    public Procedure3<SignedInt11Member, SignedInt11Member, SignedInt11Member> gcd() {
        return this.GCD;
    }

    @Override
    public Procedure3<SignedInt11Member, SignedInt11Member, SignedInt11Member> lcm() {
        return this.LCM;
    }

    @Override
    public Function1<Boolean, SignedInt11Member> isEven() {
        return this.EVEN;
    }

    @Override
    public Function1<Boolean, SignedInt11Member> isOdd() {
        return this.ODD;
    }

    @Override
    public Procedure3<SignedInt11Member, SignedInt11Member, SignedInt11Member> div() {
        return this.DIV;
    }

    @Override
    public Procedure3<SignedInt11Member, SignedInt11Member, SignedInt11Member> mod() {
        return this.MOD;
    }

    @Override
    public Procedure4<SignedInt11Member, SignedInt11Member, SignedInt11Member, SignedInt11Member> divMod() {
        return this.DIVMOD;
    }

    @Override
    public Procedure2<SignedInt11Member, SignedInt11Member> pred() {
        return this.PRED;
    }

    @Override
    public Procedure2<SignedInt11Member, SignedInt11Member> succ() {
        return this.SUCC;
    }

    @Override
    public Procedure3<SignedInt11Member, SignedInt11Member, SignedInt11Member> pow() {
        return this.POW;
    }

    @Override
    public Procedure1<SignedInt11Member> random() {
        return this.RAND;
    }

    @Override
    public Procedure3<SignedInt11Member, SignedInt11Member, SignedInt11Member> bitAnd() {
        return this.AND;
    }

    @Override
    public Procedure3<SignedInt11Member, SignedInt11Member, SignedInt11Member> bitOr() {
        return this.OR;
    }

    @Override
    public Procedure3<SignedInt11Member, SignedInt11Member, SignedInt11Member> bitXor() {
        return this.XOR;
    }

    @Override
    public Procedure2<SignedInt11Member, SignedInt11Member> bitNot() {
        return this.NOT;
    }

    @Override
    public Procedure3<SignedInt11Member, SignedInt11Member, SignedInt11Member> bitAndNot() {
        return this.ANDNOT;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt11Member, SignedInt11Member> bitShiftLeft() {
        return this.SHL;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt11Member, SignedInt11Member> bitShiftRight() {
        return this.SHR;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt11Member, SignedInt11Member> bitShiftRightFillZero() {
        return this.SHRZ;
    }

    @Override
    public Procedure1<SignedInt11Member> maxBound() {
        return this.MAXBOUND;
    }

    @Override
    public Procedure1<SignedInt11Member> minBound() {
        return this.MINBOUND;
    }

    @Override
    public Function1<Boolean, SignedInt11Member> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<SignedInt11Member, SignedInt11Member, SignedInt11Member> scale() {
        return this.MUL;
    }

    @Override
    public Procedure3<HighPrecisionMember, SignedInt11Member, SignedInt11Member> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<HighPrecisionMember, SignedInt11Member, SignedInt11Member> scaleByHighPrecAndRound() {
        return this.SBHPR;
    }

    @Override
    public Procedure3<RationalMember, SignedInt11Member, SignedInt11Member> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, SignedInt11Member, SignedInt11Member> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<Double, SignedInt11Member, SignedInt11Member> scaleByDoubleAndRound() {
        return this.SBDR;
    }

    @Override
    public Function3<Boolean, SignedInt11Member, SignedInt11Member, SignedInt11Member> within() {
        return this.WITHIN;
    }
}

