/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.int11;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.ThreadLocalRandom;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.Gcd;
import nom.bdezonia.zorbage.algorithm.Lcm;
import nom.bdezonia.zorbage.algorithm.NumberWithin;
import nom.bdezonia.zorbage.algorithm.PowerNonNegative;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.BitOperations;
import nom.bdezonia.zorbage.type.algebra.Bounded;
import nom.bdezonia.zorbage.type.algebra.Integer;
import nom.bdezonia.zorbage.type.algebra.Random;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.int11.UnsignedInt11Member;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class UnsignedInt11Algebra
implements Integer<UnsignedInt11Algebra, UnsignedInt11Member>,
Bounded<UnsignedInt11Member>,
BitOperations<UnsignedInt11Member>,
Random<UnsignedInt11Member>,
Tolerance<UnsignedInt11Member, UnsignedInt11Member> {
    private final Function2<Boolean, UnsignedInt11Member, UnsignedInt11Member> EQ = new Function2<Boolean, UnsignedInt11Member, UnsignedInt11Member>(){

        @Override
        public Boolean call(UnsignedInt11Member a, UnsignedInt11Member b) {
            return a.v == b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt11Member, UnsignedInt11Member> NEQ = new Function2<Boolean, UnsignedInt11Member, UnsignedInt11Member>(){

        @Override
        public Boolean call(UnsignedInt11Member a, UnsignedInt11Member b) {
            return a.v != b.v;
        }
    };
    private final Procedure2<UnsignedInt11Member, UnsignedInt11Member> ASSIGN = new Procedure2<UnsignedInt11Member, UnsignedInt11Member>(){

        @Override
        public void call(UnsignedInt11Member a, UnsignedInt11Member b) {
            b.set(a);
        }
    };
    private final Procedure1<UnsignedInt11Member> ZER = new Procedure1<UnsignedInt11Member>(){

        @Override
        public void call(UnsignedInt11Member a) {
            a.v = 0;
        }
    };
    private final Procedure3<UnsignedInt11Member, UnsignedInt11Member, UnsignedInt11Member> ADD = new Procedure3<UnsignedInt11Member, UnsignedInt11Member, UnsignedInt11Member>(){

        @Override
        public void call(UnsignedInt11Member a, UnsignedInt11Member b, UnsignedInt11Member c) {
            c.setV(a.v + b.v);
        }
    };
    private final Procedure3<UnsignedInt11Member, UnsignedInt11Member, UnsignedInt11Member> SUB = new Procedure3<UnsignedInt11Member, UnsignedInt11Member, UnsignedInt11Member>(){

        @Override
        public void call(UnsignedInt11Member a, UnsignedInt11Member b, UnsignedInt11Member c) {
            c.setV(a.v - b.v);
        }
    };
    private final Procedure3<UnsignedInt11Member, UnsignedInt11Member, UnsignedInt11Member> MUL = new Procedure3<UnsignedInt11Member, UnsignedInt11Member, UnsignedInt11Member>(){

        @Override
        public void call(UnsignedInt11Member a, UnsignedInt11Member b, UnsignedInt11Member c) {
            c.setV(a.v * b.v);
        }
    };
    private final Procedure3<java.lang.Integer, UnsignedInt11Member, UnsignedInt11Member> POWER = new Procedure3<java.lang.Integer, UnsignedInt11Member, UnsignedInt11Member>(){

        @Override
        public void call(java.lang.Integer power, UnsignedInt11Member a, UnsignedInt11Member b) {
            PowerNonNegative.compute(G.UINT11, power, a, b);
        }
    };
    private final Procedure1<UnsignedInt11Member> UNITY = new Procedure1<UnsignedInt11Member>(){

        @Override
        public void call(UnsignedInt11Member a) {
            a.v = 1;
        }
    };
    private final Function2<Boolean, UnsignedInt11Member, UnsignedInt11Member> LESS = new Function2<Boolean, UnsignedInt11Member, UnsignedInt11Member>(){

        @Override
        public Boolean call(UnsignedInt11Member a, UnsignedInt11Member b) {
            return a.v < b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt11Member, UnsignedInt11Member> LE = new Function2<Boolean, UnsignedInt11Member, UnsignedInt11Member>(){

        @Override
        public Boolean call(UnsignedInt11Member a, UnsignedInt11Member b) {
            return a.v <= b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt11Member, UnsignedInt11Member> GREAT = new Function2<Boolean, UnsignedInt11Member, UnsignedInt11Member>(){

        @Override
        public Boolean call(UnsignedInt11Member a, UnsignedInt11Member b) {
            return a.v > b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt11Member, UnsignedInt11Member> GE = new Function2<Boolean, UnsignedInt11Member, UnsignedInt11Member>(){

        @Override
        public Boolean call(UnsignedInt11Member a, UnsignedInt11Member b) {
            return a.v >= b.v;
        }
    };
    private final Function2<java.lang.Integer, UnsignedInt11Member, UnsignedInt11Member> CMP = new Function2<java.lang.Integer, UnsignedInt11Member, UnsignedInt11Member>(){

        @Override
        public java.lang.Integer call(UnsignedInt11Member a, UnsignedInt11Member b) {
            if (a.v < b.v) {
                return -1;
            }
            if (a.v > b.v) {
                return 1;
            }
            return 0;
        }
    };
    private final Function1<java.lang.Integer, UnsignedInt11Member> SIG = new Function1<java.lang.Integer, UnsignedInt11Member>(){

        @Override
        public java.lang.Integer call(UnsignedInt11Member a) {
            if (a.v < 0) {
                return -1;
            }
            if (a.v > 0) {
                return 1;
            }
            return 0;
        }
    };
    private final Procedure3<UnsignedInt11Member, UnsignedInt11Member, UnsignedInt11Member> MIN = new Procedure3<UnsignedInt11Member, UnsignedInt11Member, UnsignedInt11Member>(){

        @Override
        public void call(UnsignedInt11Member a, UnsignedInt11Member b, UnsignedInt11Member c) {
            if (a.v < b.v) {
                c.set(a);
            } else {
                c.set(b);
            }
        }
    };
    private final Procedure3<UnsignedInt11Member, UnsignedInt11Member, UnsignedInt11Member> MAX = new Procedure3<UnsignedInt11Member, UnsignedInt11Member, UnsignedInt11Member>(){

        @Override
        public void call(UnsignedInt11Member a, UnsignedInt11Member b, UnsignedInt11Member c) {
            if (a.v > b.v) {
                c.set(a);
            } else {
                c.set(b);
            }
        }
    };
    private final Procedure3<UnsignedInt11Member, UnsignedInt11Member, UnsignedInt11Member> GCD = new Procedure3<UnsignedInt11Member, UnsignedInt11Member, UnsignedInt11Member>(){

        @Override
        public void call(UnsignedInt11Member a, UnsignedInt11Member b, UnsignedInt11Member c) {
            Gcd.compute(G.UINT11, a, b, c);
        }
    };
    private final Procedure3<UnsignedInt11Member, UnsignedInt11Member, UnsignedInt11Member> LCM = new Procedure3<UnsignedInt11Member, UnsignedInt11Member, UnsignedInt11Member>(){

        @Override
        public void call(UnsignedInt11Member a, UnsignedInt11Member b, UnsignedInt11Member c) {
            Lcm.compute(G.UINT11, a, b, c);
        }
    };
    private final Function1<Boolean, UnsignedInt11Member> EVEN = new Function1<Boolean, UnsignedInt11Member>(){

        @Override
        public Boolean call(UnsignedInt11Member a) {
            return (a.v & 1) == 0;
        }
    };
    private final Function1<Boolean, UnsignedInt11Member> ODD = new Function1<Boolean, UnsignedInt11Member>(){

        @Override
        public Boolean call(UnsignedInt11Member a) {
            return (a.v & 1) == 1;
        }
    };
    private final Procedure3<UnsignedInt11Member, UnsignedInt11Member, UnsignedInt11Member> DIV = new Procedure3<UnsignedInt11Member, UnsignedInt11Member, UnsignedInt11Member>(){

        @Override
        public void call(UnsignedInt11Member a, UnsignedInt11Member b, UnsignedInt11Member d) {
            d.setV(a.v / b.v);
        }
    };
    private final Procedure3<UnsignedInt11Member, UnsignedInt11Member, UnsignedInt11Member> MOD = new Procedure3<UnsignedInt11Member, UnsignedInt11Member, UnsignedInt11Member>(){

        @Override
        public void call(UnsignedInt11Member a, UnsignedInt11Member b, UnsignedInt11Member m) {
            m.setV(a.v % b.v);
        }
    };
    private final Procedure4<UnsignedInt11Member, UnsignedInt11Member, UnsignedInt11Member, UnsignedInt11Member> DIVMOD = new Procedure4<UnsignedInt11Member, UnsignedInt11Member, UnsignedInt11Member, UnsignedInt11Member>(){

        @Override
        public void call(UnsignedInt11Member a, UnsignedInt11Member b, UnsignedInt11Member d, UnsignedInt11Member m) {
            UnsignedInt11Algebra.this.div().call(a, b, d);
            UnsignedInt11Algebra.this.mod().call(a, b, m);
        }
    };
    private final Procedure2<UnsignedInt11Member, UnsignedInt11Member> PRED = new Procedure2<UnsignedInt11Member, UnsignedInt11Member>(){

        @Override
        public void call(UnsignedInt11Member a, UnsignedInt11Member b) {
            if (a.v == 0) {
                b.v = (short)2047;
            } else {
                b.setV(a.v - 1);
            }
        }
    };
    private final Procedure2<UnsignedInt11Member, UnsignedInt11Member> SUCC = new Procedure2<UnsignedInt11Member, UnsignedInt11Member>(){

        @Override
        public void call(UnsignedInt11Member a, UnsignedInt11Member b) {
            if (a.v == 2047) {
                b.v = 0;
            } else {
                b.setV(a.v + 1);
            }
        }
    };
    private final Procedure3<UnsignedInt11Member, UnsignedInt11Member, UnsignedInt11Member> POW = new Procedure3<UnsignedInt11Member, UnsignedInt11Member, UnsignedInt11Member>(){

        @Override
        public void call(UnsignedInt11Member a, UnsignedInt11Member b, UnsignedInt11Member c) {
            PowerNonNegative.compute(G.UINT11, b.v, a, c);
        }
    };
    private final Procedure1<UnsignedInt11Member> RAND = new Procedure1<UnsignedInt11Member>(){

        @Override
        public void call(UnsignedInt11Member a) {
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            a.setV(rng.nextInt(2048));
        }
    };
    private final Procedure3<UnsignedInt11Member, UnsignedInt11Member, UnsignedInt11Member> AND = new Procedure3<UnsignedInt11Member, UnsignedInt11Member, UnsignedInt11Member>(){

        @Override
        public void call(UnsignedInt11Member a, UnsignedInt11Member b, UnsignedInt11Member c) {
            c.setV(a.v & b.v);
        }
    };
    private final Procedure3<UnsignedInt11Member, UnsignedInt11Member, UnsignedInt11Member> OR = new Procedure3<UnsignedInt11Member, UnsignedInt11Member, UnsignedInt11Member>(){

        @Override
        public void call(UnsignedInt11Member a, UnsignedInt11Member b, UnsignedInt11Member c) {
            c.setV(a.v | b.v);
        }
    };
    private final Procedure3<UnsignedInt11Member, UnsignedInt11Member, UnsignedInt11Member> XOR = new Procedure3<UnsignedInt11Member, UnsignedInt11Member, UnsignedInt11Member>(){

        @Override
        public void call(UnsignedInt11Member a, UnsignedInt11Member b, UnsignedInt11Member c) {
            c.setV(a.v ^ b.v);
        }
    };
    private final Procedure2<UnsignedInt11Member, UnsignedInt11Member> NOT = new Procedure2<UnsignedInt11Member, UnsignedInt11Member>(){

        @Override
        public void call(UnsignedInt11Member a, UnsignedInt11Member b) {
            b.setV(~a.v);
        }
    };
    private final Procedure3<UnsignedInt11Member, UnsignedInt11Member, UnsignedInt11Member> ANDNOT = new Procedure3<UnsignedInt11Member, UnsignedInt11Member, UnsignedInt11Member>(){

        @Override
        public void call(UnsignedInt11Member a, UnsignedInt11Member b, UnsignedInt11Member c) {
            c.setV(a.v & ~b.v);
        }
    };
    private final Procedure3<java.lang.Integer, UnsignedInt11Member, UnsignedInt11Member> SHL = new Procedure3<java.lang.Integer, UnsignedInt11Member, UnsignedInt11Member>(){

        @Override
        public void call(java.lang.Integer count, UnsignedInt11Member a, UnsignedInt11Member b) {
            if (count < 0) {
                UnsignedInt11Algebra.this.bitShiftRight().call(-count.intValue(), a, b);
            } else {
                count = count % 11;
                b.setV(a.v << count);
            }
        }
    };
    private final Procedure3<java.lang.Integer, UnsignedInt11Member, UnsignedInt11Member> SHRZ = new Procedure3<java.lang.Integer, UnsignedInt11Member, UnsignedInt11Member>(){

        @Override
        public void call(java.lang.Integer count, UnsignedInt11Member a, UnsignedInt11Member b) {
            if (count < 0) {
                UnsignedInt11Algebra.this.bitShiftLeft().call(-count.intValue(), a, b);
            } else {
                b.setV(a.v >>> count);
            }
        }
    };
    private final Procedure1<UnsignedInt11Member> MAXBOUND = new Procedure1<UnsignedInt11Member>(){

        @Override
        public void call(UnsignedInt11Member a) {
            a.v = (short)2047;
        }
    };
    private final Procedure1<UnsignedInt11Member> MINBOUND = new Procedure1<UnsignedInt11Member>(){

        @Override
        public void call(UnsignedInt11Member a) {
            a.v = 0;
        }
    };
    private final Function1<Boolean, UnsignedInt11Member> ISZERO = new Function1<Boolean, UnsignedInt11Member>(){

        @Override
        public Boolean call(UnsignedInt11Member a) {
            return a.v == 0;
        }
    };
    private final Procedure3<HighPrecisionMember, UnsignedInt11Member, UnsignedInt11Member> SBHP = new Procedure3<HighPrecisionMember, UnsignedInt11Member, UnsignedInt11Member>(){

        @Override
        public void call(HighPrecisionMember a, UnsignedInt11Member b, UnsignedInt11Member c) {
            BigDecimal tmp = a.v();
            tmp = tmp.multiply(new BigDecimal(b.v()));
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<HighPrecisionMember, UnsignedInt11Member, UnsignedInt11Member> SBHPR = new Procedure3<HighPrecisionMember, UnsignedInt11Member, UnsignedInt11Member>(){

        @Override
        public void call(HighPrecisionMember a, UnsignedInt11Member b, UnsignedInt11Member c) {
            BigDecimal tmp = a.v();
            int signum = (tmp = tmp.multiply(new BigDecimal(b.v()))).signum();
            tmp = signum < 0 ? tmp.subtract(G.ONE_HALF) : tmp.add(G.ONE_HALF);
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<RationalMember, UnsignedInt11Member, UnsignedInt11Member> SBR = new Procedure3<RationalMember, UnsignedInt11Member, UnsignedInt11Member>(){

        @Override
        public void call(RationalMember a, UnsignedInt11Member b, UnsignedInt11Member c) {
            BigInteger tmp = BigInteger.valueOf(b.v());
            tmp = tmp.multiply(a.n());
            tmp = tmp.divide(a.d());
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<Double, UnsignedInt11Member, UnsignedInt11Member> SBD = new Procedure3<Double, UnsignedInt11Member, UnsignedInt11Member>(){

        @Override
        public void call(Double a, UnsignedInt11Member b, UnsignedInt11Member c) {
            c.setV((int)(a * (double)b.v()));
        }
    };
    private final Procedure3<Double, UnsignedInt11Member, UnsignedInt11Member> SBDR = new Procedure3<Double, UnsignedInt11Member, UnsignedInt11Member>(){

        @Override
        public void call(Double a, UnsignedInt11Member b, UnsignedInt11Member c) {
            c.setV((int)Math.round(a * (double)b.v()));
        }
    };
    private final Function3<Boolean, UnsignedInt11Member, UnsignedInt11Member, UnsignedInt11Member> WITHIN = new Function3<Boolean, UnsignedInt11Member, UnsignedInt11Member, UnsignedInt11Member>(){

        @Override
        public Boolean call(UnsignedInt11Member tol, UnsignedInt11Member a, UnsignedInt11Member b) {
            return NumberWithin.compute(G.UINT11, tol, a, b);
        }
    };

    @Override
    public UnsignedInt11Member construct() {
        return new UnsignedInt11Member();
    }

    @Override
    public UnsignedInt11Member construct(UnsignedInt11Member other) {
        return new UnsignedInt11Member(other);
    }

    @Override
    public UnsignedInt11Member construct(String str) {
        return new UnsignedInt11Member(str);
    }

    @Override
    public Function2<Boolean, UnsignedInt11Member, UnsignedInt11Member> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, UnsignedInt11Member, UnsignedInt11Member> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<UnsignedInt11Member, UnsignedInt11Member> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure1<UnsignedInt11Member> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<UnsignedInt11Member, UnsignedInt11Member> negate() {
        return this.ASSIGN;
    }

    @Override
    public Procedure3<UnsignedInt11Member, UnsignedInt11Member, UnsignedInt11Member> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<UnsignedInt11Member, UnsignedInt11Member, UnsignedInt11Member> subtract() {
        return this.SUB;
    }

    @Override
    public Procedure3<UnsignedInt11Member, UnsignedInt11Member, UnsignedInt11Member> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt11Member, UnsignedInt11Member> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<UnsignedInt11Member> unity() {
        return this.UNITY;
    }

    @Override
    public Function2<Boolean, UnsignedInt11Member, UnsignedInt11Member> isLess() {
        return this.LESS;
    }

    @Override
    public Function2<Boolean, UnsignedInt11Member, UnsignedInt11Member> isLessEqual() {
        return this.LE;
    }

    @Override
    public Function2<Boolean, UnsignedInt11Member, UnsignedInt11Member> isGreater() {
        return this.GREAT;
    }

    @Override
    public Function2<Boolean, UnsignedInt11Member, UnsignedInt11Member> isGreaterEqual() {
        return this.GE;
    }

    @Override
    public Function2<java.lang.Integer, UnsignedInt11Member, UnsignedInt11Member> compare() {
        return this.CMP;
    }

    @Override
    public Function1<java.lang.Integer, UnsignedInt11Member> signum() {
        return this.SIG;
    }

    @Override
    public Procedure3<UnsignedInt11Member, UnsignedInt11Member, UnsignedInt11Member> min() {
        return this.MIN;
    }

    @Override
    public Procedure3<UnsignedInt11Member, UnsignedInt11Member, UnsignedInt11Member> max() {
        return this.MAX;
    }

    @Override
    public Procedure2<UnsignedInt11Member, UnsignedInt11Member> abs() {
        return this.ASSIGN;
    }

    @Override
    public Procedure2<UnsignedInt11Member, UnsignedInt11Member> norm() {
        return this.ASSIGN;
    }

    @Override
    public Procedure3<UnsignedInt11Member, UnsignedInt11Member, UnsignedInt11Member> gcd() {
        return this.GCD;
    }

    @Override
    public Procedure3<UnsignedInt11Member, UnsignedInt11Member, UnsignedInt11Member> lcm() {
        return this.LCM;
    }

    @Override
    public Function1<Boolean, UnsignedInt11Member> isEven() {
        return this.EVEN;
    }

    @Override
    public Function1<Boolean, UnsignedInt11Member> isOdd() {
        return this.ODD;
    }

    @Override
    public Procedure3<UnsignedInt11Member, UnsignedInt11Member, UnsignedInt11Member> div() {
        return this.DIV;
    }

    @Override
    public Procedure3<UnsignedInt11Member, UnsignedInt11Member, UnsignedInt11Member> mod() {
        return this.MOD;
    }

    @Override
    public Procedure4<UnsignedInt11Member, UnsignedInt11Member, UnsignedInt11Member, UnsignedInt11Member> divMod() {
        return this.DIVMOD;
    }

    @Override
    public Procedure2<UnsignedInt11Member, UnsignedInt11Member> pred() {
        return this.PRED;
    }

    @Override
    public Procedure2<UnsignedInt11Member, UnsignedInt11Member> succ() {
        return this.SUCC;
    }

    @Override
    public Procedure3<UnsignedInt11Member, UnsignedInt11Member, UnsignedInt11Member> pow() {
        return this.POW;
    }

    @Override
    public Procedure1<UnsignedInt11Member> random() {
        return this.RAND;
    }

    @Override
    public Procedure3<UnsignedInt11Member, UnsignedInt11Member, UnsignedInt11Member> bitAnd() {
        return this.AND;
    }

    @Override
    public Procedure3<UnsignedInt11Member, UnsignedInt11Member, UnsignedInt11Member> bitOr() {
        return this.OR;
    }

    @Override
    public Procedure3<UnsignedInt11Member, UnsignedInt11Member, UnsignedInt11Member> bitXor() {
        return this.XOR;
    }

    @Override
    public Procedure2<UnsignedInt11Member, UnsignedInt11Member> bitNot() {
        return this.NOT;
    }

    @Override
    public Procedure3<UnsignedInt11Member, UnsignedInt11Member, UnsignedInt11Member> bitAndNot() {
        return this.ANDNOT;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt11Member, UnsignedInt11Member> bitShiftLeft() {
        return this.SHL;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt11Member, UnsignedInt11Member> bitShiftRight() {
        return this.SHRZ;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt11Member, UnsignedInt11Member> bitShiftRightFillZero() {
        return this.SHRZ;
    }

    @Override
    public Procedure1<UnsignedInt11Member> maxBound() {
        return this.MAXBOUND;
    }

    @Override
    public Procedure1<UnsignedInt11Member> minBound() {
        return this.MINBOUND;
    }

    @Override
    public Function1<Boolean, UnsignedInt11Member> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<UnsignedInt11Member, UnsignedInt11Member, UnsignedInt11Member> scale() {
        return this.MUL;
    }

    @Override
    public Procedure3<HighPrecisionMember, UnsignedInt11Member, UnsignedInt11Member> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<HighPrecisionMember, UnsignedInt11Member, UnsignedInt11Member> scaleByHighPrecAndRound() {
        return this.SBHPR;
    }

    @Override
    public Procedure3<RationalMember, UnsignedInt11Member, UnsignedInt11Member> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, UnsignedInt11Member, UnsignedInt11Member> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<Double, UnsignedInt11Member, UnsignedInt11Member> scaleByDoubleAndRound() {
        return this.SBDR;
    }

    @Override
    public Function3<Boolean, UnsignedInt11Member, UnsignedInt11Member, UnsignedInt11Member> within() {
        return this.WITHIN;
    }
}

