/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.int12;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.ThreadLocalRandom;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.Gcd;
import nom.bdezonia.zorbage.algorithm.Lcm;
import nom.bdezonia.zorbage.algorithm.NumberWithin;
import nom.bdezonia.zorbage.algorithm.PowerNonNegative;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.BitOperations;
import nom.bdezonia.zorbage.type.algebra.Bounded;
import nom.bdezonia.zorbage.type.algebra.Integer;
import nom.bdezonia.zorbage.type.algebra.Random;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.int12.SignedInt12Member;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class SignedInt12Algebra
implements Integer<SignedInt12Algebra, SignedInt12Member>,
Bounded<SignedInt12Member>,
BitOperations<SignedInt12Member>,
Random<SignedInt12Member>,
Tolerance<SignedInt12Member, SignedInt12Member> {
    private final Function2<Boolean, SignedInt12Member, SignedInt12Member> EQ = new Function2<Boolean, SignedInt12Member, SignedInt12Member>(){

        @Override
        public Boolean call(SignedInt12Member a, SignedInt12Member b) {
            return a.v == b.v;
        }
    };
    private final Function2<Boolean, SignedInt12Member, SignedInt12Member> NEQ = new Function2<Boolean, SignedInt12Member, SignedInt12Member>(){

        @Override
        public Boolean call(SignedInt12Member a, SignedInt12Member b) {
            return a.v != b.v;
        }
    };
    private final Procedure2<SignedInt12Member, SignedInt12Member> ASSIGN = new Procedure2<SignedInt12Member, SignedInt12Member>(){

        @Override
        public void call(SignedInt12Member a, SignedInt12Member b) {
            b.set(a);
        }
    };
    private final Procedure1<SignedInt12Member> ZER = new Procedure1<SignedInt12Member>(){

        @Override
        public void call(SignedInt12Member a) {
            a.v = 0;
        }
    };
    private final Procedure2<SignedInt12Member, SignedInt12Member> NEG = new Procedure2<SignedInt12Member, SignedInt12Member>(){

        @Override
        public void call(SignedInt12Member a, SignedInt12Member b) {
            if (a.v == -2048) {
                throw new IllegalArgumentException("Cannot convert -minint symmetrically");
            }
            b.v = -a.v;
        }
    };
    private final Procedure3<SignedInt12Member, SignedInt12Member, SignedInt12Member> ADD = new Procedure3<SignedInt12Member, SignedInt12Member, SignedInt12Member>(){

        @Override
        public void call(SignedInt12Member a, SignedInt12Member b, SignedInt12Member c) {
            c.setV(a.v + b.v);
        }
    };
    private final Procedure3<SignedInt12Member, SignedInt12Member, SignedInt12Member> SUB = new Procedure3<SignedInt12Member, SignedInt12Member, SignedInt12Member>(){

        @Override
        public void call(SignedInt12Member a, SignedInt12Member b, SignedInt12Member c) {
            c.setV(a.v - b.v);
        }
    };
    private final Procedure3<SignedInt12Member, SignedInt12Member, SignedInt12Member> MUL = new Procedure3<SignedInt12Member, SignedInt12Member, SignedInt12Member>(){

        @Override
        public void call(SignedInt12Member a, SignedInt12Member b, SignedInt12Member c) {
            c.setV(a.v * b.v);
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt12Member, SignedInt12Member> POWER = new Procedure3<java.lang.Integer, SignedInt12Member, SignedInt12Member>(){

        @Override
        public void call(java.lang.Integer power, SignedInt12Member a, SignedInt12Member b) {
            PowerNonNegative.compute(G.INT12, power, a, b);
        }
    };
    private final Procedure1<SignedInt12Member> UNITY = new Procedure1<SignedInt12Member>(){

        @Override
        public void call(SignedInt12Member a) {
            a.v = 1;
        }
    };
    private final Function2<Boolean, SignedInt12Member, SignedInt12Member> LESS = new Function2<Boolean, SignedInt12Member, SignedInt12Member>(){

        @Override
        public Boolean call(SignedInt12Member a, SignedInt12Member b) {
            return a.v < b.v;
        }
    };
    private final Function2<Boolean, SignedInt12Member, SignedInt12Member> LE = new Function2<Boolean, SignedInt12Member, SignedInt12Member>(){

        @Override
        public Boolean call(SignedInt12Member a, SignedInt12Member b) {
            return a.v <= b.v;
        }
    };
    private final Function2<Boolean, SignedInt12Member, SignedInt12Member> GREAT = new Function2<Boolean, SignedInt12Member, SignedInt12Member>(){

        @Override
        public Boolean call(SignedInt12Member a, SignedInt12Member b) {
            return a.v > b.v;
        }
    };
    private final Function2<Boolean, SignedInt12Member, SignedInt12Member> GE = new Function2<Boolean, SignedInt12Member, SignedInt12Member>(){

        @Override
        public Boolean call(SignedInt12Member a, SignedInt12Member b) {
            return a.v >= b.v;
        }
    };
    private final Function2<java.lang.Integer, SignedInt12Member, SignedInt12Member> CMP = new Function2<java.lang.Integer, SignedInt12Member, SignedInt12Member>(){

        @Override
        public java.lang.Integer call(SignedInt12Member a, SignedInt12Member b) {
            if (a.v < b.v) {
                return -1;
            }
            if (a.v > b.v) {
                return 1;
            }
            return 0;
        }
    };
    private final Function1<java.lang.Integer, SignedInt12Member> SIG = new Function1<java.lang.Integer, SignedInt12Member>(){

        @Override
        public java.lang.Integer call(SignedInt12Member a) {
            if (a.v < 0) {
                return -1;
            }
            if (a.v > 0) {
                return 1;
            }
            return 0;
        }
    };
    private final Procedure3<SignedInt12Member, SignedInt12Member, SignedInt12Member> MIN = new Procedure3<SignedInt12Member, SignedInt12Member, SignedInt12Member>(){

        @Override
        public void call(SignedInt12Member a, SignedInt12Member b, SignedInt12Member c) {
            if (a.v < b.v) {
                c.set(a);
            } else {
                c.set(b);
            }
        }
    };
    private final Procedure3<SignedInt12Member, SignedInt12Member, SignedInt12Member> MAX = new Procedure3<SignedInt12Member, SignedInt12Member, SignedInt12Member>(){

        @Override
        public void call(SignedInt12Member a, SignedInt12Member b, SignedInt12Member c) {
            if (a.v > b.v) {
                c.set(a);
            } else {
                c.set(b);
            }
        }
    };
    private final Procedure2<SignedInt12Member, SignedInt12Member> ABS = new Procedure2<SignedInt12Member, SignedInt12Member>(){

        @Override
        public void call(SignedInt12Member a, SignedInt12Member b) {
            if (a.v == -2048) {
                throw new IllegalArgumentException("Cannot convert -minint symmetrically");
            }
            b.v = a.v < 0 ? (short)(-a.v) : a.v;
        }
    };
    private final Procedure3<SignedInt12Member, SignedInt12Member, SignedInt12Member> GCD = new Procedure3<SignedInt12Member, SignedInt12Member, SignedInt12Member>(){

        @Override
        public void call(SignedInt12Member a, SignedInt12Member b, SignedInt12Member c) {
            Gcd.compute(G.INT12, a, b, c);
        }
    };
    private final Procedure3<SignedInt12Member, SignedInt12Member, SignedInt12Member> LCM = new Procedure3<SignedInt12Member, SignedInt12Member, SignedInt12Member>(){

        @Override
        public void call(SignedInt12Member a, SignedInt12Member b, SignedInt12Member c) {
            Lcm.compute(G.INT12, a, b, c);
        }
    };
    private final Function1<Boolean, SignedInt12Member> EVEN = new Function1<Boolean, SignedInt12Member>(){

        @Override
        public Boolean call(SignedInt12Member a) {
            return (a.v & 1) == 0;
        }
    };
    private final Function1<Boolean, SignedInt12Member> ODD = new Function1<Boolean, SignedInt12Member>(){

        @Override
        public Boolean call(SignedInt12Member a) {
            return (a.v & 1) == 1;
        }
    };
    private final Procedure3<SignedInt12Member, SignedInt12Member, SignedInt12Member> DIV = new Procedure3<SignedInt12Member, SignedInt12Member, SignedInt12Member>(){

        @Override
        public void call(SignedInt12Member a, SignedInt12Member b, SignedInt12Member d) {
            if (b.v == -1 && a.v == -2048) {
                throw new IllegalArgumentException("cannot divide minint by -1");
            }
            d.setV(a.v / b.v);
        }
    };
    private final Procedure3<SignedInt12Member, SignedInt12Member, SignedInt12Member> MOD = new Procedure3<SignedInt12Member, SignedInt12Member, SignedInt12Member>(){

        @Override
        public void call(SignedInt12Member a, SignedInt12Member b, SignedInt12Member m) {
            m.setV(a.v % b.v);
        }
    };
    private final Procedure4<SignedInt12Member, SignedInt12Member, SignedInt12Member, SignedInt12Member> DIVMOD = new Procedure4<SignedInt12Member, SignedInt12Member, SignedInt12Member, SignedInt12Member>(){

        @Override
        public void call(SignedInt12Member a, SignedInt12Member b, SignedInt12Member d, SignedInt12Member m) {
            SignedInt12Algebra.this.div().call(a, b, d);
            SignedInt12Algebra.this.mod().call(a, b, m);
        }
    };
    private final Procedure2<SignedInt12Member, SignedInt12Member> PRED = new Procedure2<SignedInt12Member, SignedInt12Member>(){

        @Override
        public void call(SignedInt12Member a, SignedInt12Member b) {
            if (a.v == -2048) {
                b.v = (short)2047;
            } else {
                b.setV(a.v - 1);
            }
        }
    };
    private final Procedure2<SignedInt12Member, SignedInt12Member> SUCC = new Procedure2<SignedInt12Member, SignedInt12Member>(){

        @Override
        public void call(SignedInt12Member a, SignedInt12Member b) {
            if (a.v == 2047) {
                b.v = (short)-2048;
            } else {
                b.setV(a.v + 1);
            }
        }
    };
    private final Procedure3<SignedInt12Member, SignedInt12Member, SignedInt12Member> POW = new Procedure3<SignedInt12Member, SignedInt12Member, SignedInt12Member>(){

        @Override
        public void call(SignedInt12Member a, SignedInt12Member b, SignedInt12Member c) {
            PowerNonNegative.compute(G.INT12, b.v, a, c);
        }
    };
    private final Procedure1<SignedInt12Member> RAND = new Procedure1<SignedInt12Member>(){

        @Override
        public void call(SignedInt12Member a) {
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            a.setV(rng.nextInt(4096) - 2048);
        }
    };
    private final Procedure3<SignedInt12Member, SignedInt12Member, SignedInt12Member> AND = new Procedure3<SignedInt12Member, SignedInt12Member, SignedInt12Member>(){

        @Override
        public void call(SignedInt12Member a, SignedInt12Member b, SignedInt12Member c) {
            c.setV(a.v & b.v);
        }
    };
    private final Procedure3<SignedInt12Member, SignedInt12Member, SignedInt12Member> OR = new Procedure3<SignedInt12Member, SignedInt12Member, SignedInt12Member>(){

        @Override
        public void call(SignedInt12Member a, SignedInt12Member b, SignedInt12Member c) {
            c.setV(a.v | b.v);
        }
    };
    private final Procedure3<SignedInt12Member, SignedInt12Member, SignedInt12Member> XOR = new Procedure3<SignedInt12Member, SignedInt12Member, SignedInt12Member>(){

        @Override
        public void call(SignedInt12Member a, SignedInt12Member b, SignedInt12Member c) {
            c.setV(a.v ^ b.v);
        }
    };
    private final Procedure2<SignedInt12Member, SignedInt12Member> NOT = new Procedure2<SignedInt12Member, SignedInt12Member>(){

        @Override
        public void call(SignedInt12Member a, SignedInt12Member b) {
            b.setV(~a.v);
        }
    };
    private final Procedure3<SignedInt12Member, SignedInt12Member, SignedInt12Member> ANDNOT = new Procedure3<SignedInt12Member, SignedInt12Member, SignedInt12Member>(){

        @Override
        public void call(SignedInt12Member a, SignedInt12Member b, SignedInt12Member c) {
            c.setV(a.v & ~b.v);
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt12Member, SignedInt12Member> SHL = new Procedure3<java.lang.Integer, SignedInt12Member, SignedInt12Member>(){

        @Override
        public void call(java.lang.Integer count, SignedInt12Member a, SignedInt12Member b) {
            if (count < 0) {
                SignedInt12Algebra.this.bitShiftRight().call(-count.intValue(), a, b);
            } else {
                count = count % 12;
                b.setV(a.v << count);
            }
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt12Member, SignedInt12Member> SHR = new Procedure3<java.lang.Integer, SignedInt12Member, SignedInt12Member>(){

        @Override
        public void call(java.lang.Integer count, SignedInt12Member a, SignedInt12Member b) {
            if (count < 0) {
                SignedInt12Algebra.this.bitShiftLeft().call(-count.intValue(), a, b);
            } else {
                int val = a.v >> count;
                if (a.v < 0 && val == 0) {
                    b.v = (short)-1;
                } else {
                    b.setV(val);
                }
            }
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt12Member, SignedInt12Member> SHRZ = new Procedure3<java.lang.Integer, SignedInt12Member, SignedInt12Member>(){

        @Override
        public void call(java.lang.Integer count, SignedInt12Member a, SignedInt12Member b) {
            if (count < 0) {
                SignedInt12Algebra.this.bitShiftLeft().call(-count.intValue(), a, b);
            } else {
                b.setV(a.v >>> count);
            }
        }
    };
    private final Procedure1<SignedInt12Member> MAXBOUND = new Procedure1<SignedInt12Member>(){

        @Override
        public void call(SignedInt12Member a) {
            a.v = (short)2047;
        }
    };
    private final Procedure1<SignedInt12Member> MINBOUND = new Procedure1<SignedInt12Member>(){

        @Override
        public void call(SignedInt12Member a) {
            a.v = (short)-2048;
        }
    };
    private final Function1<Boolean, SignedInt12Member> ISZERO = new Function1<Boolean, SignedInt12Member>(){

        @Override
        public Boolean call(SignedInt12Member a) {
            return a.v == 0;
        }
    };
    private final Procedure3<HighPrecisionMember, SignedInt12Member, SignedInt12Member> SBHP = new Procedure3<HighPrecisionMember, SignedInt12Member, SignedInt12Member>(){

        @Override
        public void call(HighPrecisionMember a, SignedInt12Member b, SignedInt12Member c) {
            BigDecimal tmp = a.v();
            tmp = tmp.multiply(new BigDecimal(b.v()));
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<HighPrecisionMember, SignedInt12Member, SignedInt12Member> SBHPR = new Procedure3<HighPrecisionMember, SignedInt12Member, SignedInt12Member>(){

        @Override
        public void call(HighPrecisionMember a, SignedInt12Member b, SignedInt12Member c) {
            BigDecimal tmp = a.v();
            int signum = (tmp = tmp.multiply(new BigDecimal(b.v()))).signum();
            tmp = signum < 0 ? tmp.subtract(G.ONE_HALF) : tmp.add(G.ONE_HALF);
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<RationalMember, SignedInt12Member, SignedInt12Member> SBR = new Procedure3<RationalMember, SignedInt12Member, SignedInt12Member>(){

        @Override
        public void call(RationalMember a, SignedInt12Member b, SignedInt12Member c) {
            BigInteger tmp = BigInteger.valueOf(b.v());
            tmp = tmp.multiply(a.n());
            tmp = tmp.divide(a.d());
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<Double, SignedInt12Member, SignedInt12Member> SBD = new Procedure3<Double, SignedInt12Member, SignedInt12Member>(){

        @Override
        public void call(Double a, SignedInt12Member b, SignedInt12Member c) {
            c.setV((int)(a * (double)b.v()));
        }
    };
    private final Procedure3<Double, SignedInt12Member, SignedInt12Member> SBDR = new Procedure3<Double, SignedInt12Member, SignedInt12Member>(){

        @Override
        public void call(Double a, SignedInt12Member b, SignedInt12Member c) {
            c.setV((int)Math.round(a * (double)b.v()));
        }
    };
    private final Function3<Boolean, SignedInt12Member, SignedInt12Member, SignedInt12Member> WITHIN = new Function3<Boolean, SignedInt12Member, SignedInt12Member, SignedInt12Member>(){

        @Override
        public Boolean call(SignedInt12Member tol, SignedInt12Member a, SignedInt12Member b) {
            return NumberWithin.compute(G.INT12, tol, a, b);
        }
    };

    @Override
    public SignedInt12Member construct() {
        return new SignedInt12Member();
    }

    @Override
    public SignedInt12Member construct(SignedInt12Member other) {
        return new SignedInt12Member(other);
    }

    @Override
    public SignedInt12Member construct(String str) {
        return new SignedInt12Member(str);
    }

    @Override
    public Function2<Boolean, SignedInt12Member, SignedInt12Member> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, SignedInt12Member, SignedInt12Member> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<SignedInt12Member, SignedInt12Member> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure1<SignedInt12Member> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<SignedInt12Member, SignedInt12Member> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<SignedInt12Member, SignedInt12Member, SignedInt12Member> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<SignedInt12Member, SignedInt12Member, SignedInt12Member> subtract() {
        return this.SUB;
    }

    @Override
    public Procedure3<SignedInt12Member, SignedInt12Member, SignedInt12Member> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt12Member, SignedInt12Member> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<SignedInt12Member> unity() {
        return this.UNITY;
    }

    @Override
    public Function2<Boolean, SignedInt12Member, SignedInt12Member> isLess() {
        return this.LESS;
    }

    @Override
    public Function2<Boolean, SignedInt12Member, SignedInt12Member> isLessEqual() {
        return this.LE;
    }

    @Override
    public Function2<Boolean, SignedInt12Member, SignedInt12Member> isGreater() {
        return this.GREAT;
    }

    @Override
    public Function2<Boolean, SignedInt12Member, SignedInt12Member> isGreaterEqual() {
        return this.GE;
    }

    @Override
    public Function2<java.lang.Integer, SignedInt12Member, SignedInt12Member> compare() {
        return this.CMP;
    }

    @Override
    public Function1<java.lang.Integer, SignedInt12Member> signum() {
        return this.SIG;
    }

    @Override
    public Procedure3<SignedInt12Member, SignedInt12Member, SignedInt12Member> min() {
        return this.MIN;
    }

    @Override
    public Procedure3<SignedInt12Member, SignedInt12Member, SignedInt12Member> max() {
        return this.MAX;
    }

    @Override
    public Procedure2<SignedInt12Member, SignedInt12Member> abs() {
        return this.ABS;
    }

    @Override
    public Procedure2<SignedInt12Member, SignedInt12Member> norm() {
        return this.ABS;
    }

    @Override
    public Procedure3<SignedInt12Member, SignedInt12Member, SignedInt12Member> gcd() {
        return this.GCD;
    }

    @Override
    public Procedure3<SignedInt12Member, SignedInt12Member, SignedInt12Member> lcm() {
        return this.LCM;
    }

    @Override
    public Function1<Boolean, SignedInt12Member> isEven() {
        return this.EVEN;
    }

    @Override
    public Function1<Boolean, SignedInt12Member> isOdd() {
        return this.ODD;
    }

    @Override
    public Procedure3<SignedInt12Member, SignedInt12Member, SignedInt12Member> div() {
        return this.DIV;
    }

    @Override
    public Procedure3<SignedInt12Member, SignedInt12Member, SignedInt12Member> mod() {
        return this.MOD;
    }

    @Override
    public Procedure4<SignedInt12Member, SignedInt12Member, SignedInt12Member, SignedInt12Member> divMod() {
        return this.DIVMOD;
    }

    @Override
    public Procedure2<SignedInt12Member, SignedInt12Member> pred() {
        return this.PRED;
    }

    @Override
    public Procedure2<SignedInt12Member, SignedInt12Member> succ() {
        return this.SUCC;
    }

    @Override
    public Procedure3<SignedInt12Member, SignedInt12Member, SignedInt12Member> pow() {
        return this.POW;
    }

    @Override
    public Procedure1<SignedInt12Member> random() {
        return this.RAND;
    }

    @Override
    public Procedure3<SignedInt12Member, SignedInt12Member, SignedInt12Member> bitAnd() {
        return this.AND;
    }

    @Override
    public Procedure3<SignedInt12Member, SignedInt12Member, SignedInt12Member> bitOr() {
        return this.OR;
    }

    @Override
    public Procedure3<SignedInt12Member, SignedInt12Member, SignedInt12Member> bitXor() {
        return this.XOR;
    }

    @Override
    public Procedure2<SignedInt12Member, SignedInt12Member> bitNot() {
        return this.NOT;
    }

    @Override
    public Procedure3<SignedInt12Member, SignedInt12Member, SignedInt12Member> bitAndNot() {
        return this.ANDNOT;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt12Member, SignedInt12Member> bitShiftLeft() {
        return this.SHL;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt12Member, SignedInt12Member> bitShiftRight() {
        return this.SHR;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt12Member, SignedInt12Member> bitShiftRightFillZero() {
        return this.SHRZ;
    }

    @Override
    public Procedure1<SignedInt12Member> maxBound() {
        return this.MAXBOUND;
    }

    @Override
    public Procedure1<SignedInt12Member> minBound() {
        return this.MINBOUND;
    }

    @Override
    public Function1<Boolean, SignedInt12Member> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<SignedInt12Member, SignedInt12Member, SignedInt12Member> scale() {
        return this.MUL;
    }

    @Override
    public Procedure3<HighPrecisionMember, SignedInt12Member, SignedInt12Member> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<HighPrecisionMember, SignedInt12Member, SignedInt12Member> scaleByHighPrecAndRound() {
        return this.SBHPR;
    }

    @Override
    public Procedure3<RationalMember, SignedInt12Member, SignedInt12Member> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, SignedInt12Member, SignedInt12Member> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<Double, SignedInt12Member, SignedInt12Member> scaleByDoubleAndRound() {
        return this.SBDR;
    }

    @Override
    public Function3<Boolean, SignedInt12Member, SignedInt12Member, SignedInt12Member> within() {
        return this.WITHIN;
    }
}

