/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.int12;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.ThreadLocalRandom;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.Gcd;
import nom.bdezonia.zorbage.algorithm.Lcm;
import nom.bdezonia.zorbage.algorithm.NumberWithin;
import nom.bdezonia.zorbage.algorithm.PowerNonNegative;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.BitOperations;
import nom.bdezonia.zorbage.type.algebra.Bounded;
import nom.bdezonia.zorbage.type.algebra.Integer;
import nom.bdezonia.zorbage.type.algebra.Random;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.int12.UnsignedInt12Member;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class UnsignedInt12Algebra
implements Integer<UnsignedInt12Algebra, UnsignedInt12Member>,
Bounded<UnsignedInt12Member>,
BitOperations<UnsignedInt12Member>,
Random<UnsignedInt12Member>,
Tolerance<UnsignedInt12Member, UnsignedInt12Member> {
    private final Function2<Boolean, UnsignedInt12Member, UnsignedInt12Member> EQ = new Function2<Boolean, UnsignedInt12Member, UnsignedInt12Member>(){

        @Override
        public Boolean call(UnsignedInt12Member a, UnsignedInt12Member b) {
            return a.v == b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt12Member, UnsignedInt12Member> NEQ = new Function2<Boolean, UnsignedInt12Member, UnsignedInt12Member>(){

        @Override
        public Boolean call(UnsignedInt12Member a, UnsignedInt12Member b) {
            return a.v != b.v;
        }
    };
    private final Procedure2<UnsignedInt12Member, UnsignedInt12Member> ASSIGN = new Procedure2<UnsignedInt12Member, UnsignedInt12Member>(){

        @Override
        public void call(UnsignedInt12Member a, UnsignedInt12Member b) {
            b.set(a);
        }
    };
    private final Procedure1<UnsignedInt12Member> ZER = new Procedure1<UnsignedInt12Member>(){

        @Override
        public void call(UnsignedInt12Member a) {
            a.v = 0;
        }
    };
    private final Procedure3<UnsignedInt12Member, UnsignedInt12Member, UnsignedInt12Member> ADD = new Procedure3<UnsignedInt12Member, UnsignedInt12Member, UnsignedInt12Member>(){

        @Override
        public void call(UnsignedInt12Member a, UnsignedInt12Member b, UnsignedInt12Member c) {
            c.setV(a.v + b.v);
        }
    };
    private final Procedure3<UnsignedInt12Member, UnsignedInt12Member, UnsignedInt12Member> SUB = new Procedure3<UnsignedInt12Member, UnsignedInt12Member, UnsignedInt12Member>(){

        @Override
        public void call(UnsignedInt12Member a, UnsignedInt12Member b, UnsignedInt12Member c) {
            c.setV(a.v - b.v);
        }
    };
    private final Procedure3<UnsignedInt12Member, UnsignedInt12Member, UnsignedInt12Member> MUL = new Procedure3<UnsignedInt12Member, UnsignedInt12Member, UnsignedInt12Member>(){

        @Override
        public void call(UnsignedInt12Member a, UnsignedInt12Member b, UnsignedInt12Member c) {
            c.setV(a.v * b.v);
        }
    };
    private final Procedure3<java.lang.Integer, UnsignedInt12Member, UnsignedInt12Member> POWER = new Procedure3<java.lang.Integer, UnsignedInt12Member, UnsignedInt12Member>(){

        @Override
        public void call(java.lang.Integer power, UnsignedInt12Member a, UnsignedInt12Member b) {
            PowerNonNegative.compute(G.UINT12, power, a, b);
        }
    };
    private final Procedure1<UnsignedInt12Member> UNITY = new Procedure1<UnsignedInt12Member>(){

        @Override
        public void call(UnsignedInt12Member a) {
            a.v = 1;
        }
    };
    private final Function2<Boolean, UnsignedInt12Member, UnsignedInt12Member> LESS = new Function2<Boolean, UnsignedInt12Member, UnsignedInt12Member>(){

        @Override
        public Boolean call(UnsignedInt12Member a, UnsignedInt12Member b) {
            return a.v < b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt12Member, UnsignedInt12Member> LE = new Function2<Boolean, UnsignedInt12Member, UnsignedInt12Member>(){

        @Override
        public Boolean call(UnsignedInt12Member a, UnsignedInt12Member b) {
            return a.v <= b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt12Member, UnsignedInt12Member> GREAT = new Function2<Boolean, UnsignedInt12Member, UnsignedInt12Member>(){

        @Override
        public Boolean call(UnsignedInt12Member a, UnsignedInt12Member b) {
            return a.v > b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt12Member, UnsignedInt12Member> GE = new Function2<Boolean, UnsignedInt12Member, UnsignedInt12Member>(){

        @Override
        public Boolean call(UnsignedInt12Member a, UnsignedInt12Member b) {
            return a.v >= b.v;
        }
    };
    private final Function2<java.lang.Integer, UnsignedInt12Member, UnsignedInt12Member> CMP = new Function2<java.lang.Integer, UnsignedInt12Member, UnsignedInt12Member>(){

        @Override
        public java.lang.Integer call(UnsignedInt12Member a, UnsignedInt12Member b) {
            if (a.v < b.v) {
                return -1;
            }
            if (a.v > b.v) {
                return 1;
            }
            return 0;
        }
    };
    private final Function1<java.lang.Integer, UnsignedInt12Member> SIG = new Function1<java.lang.Integer, UnsignedInt12Member>(){

        @Override
        public java.lang.Integer call(UnsignedInt12Member a) {
            if (a.v < 0) {
                return -1;
            }
            if (a.v > 0) {
                return 1;
            }
            return 0;
        }
    };
    private final Procedure3<UnsignedInt12Member, UnsignedInt12Member, UnsignedInt12Member> MIN = new Procedure3<UnsignedInt12Member, UnsignedInt12Member, UnsignedInt12Member>(){

        @Override
        public void call(UnsignedInt12Member a, UnsignedInt12Member b, UnsignedInt12Member c) {
            if (a.v < b.v) {
                c.set(a);
            } else {
                c.set(b);
            }
        }
    };
    private final Procedure3<UnsignedInt12Member, UnsignedInt12Member, UnsignedInt12Member> MAX = new Procedure3<UnsignedInt12Member, UnsignedInt12Member, UnsignedInt12Member>(){

        @Override
        public void call(UnsignedInt12Member a, UnsignedInt12Member b, UnsignedInt12Member c) {
            if (a.v > b.v) {
                c.set(a);
            } else {
                c.set(b);
            }
        }
    };
    private final Procedure3<UnsignedInt12Member, UnsignedInt12Member, UnsignedInt12Member> GCD = new Procedure3<UnsignedInt12Member, UnsignedInt12Member, UnsignedInt12Member>(){

        @Override
        public void call(UnsignedInt12Member a, UnsignedInt12Member b, UnsignedInt12Member c) {
            Gcd.compute(G.UINT12, a, b, c);
        }
    };
    private final Procedure3<UnsignedInt12Member, UnsignedInt12Member, UnsignedInt12Member> LCM = new Procedure3<UnsignedInt12Member, UnsignedInt12Member, UnsignedInt12Member>(){

        @Override
        public void call(UnsignedInt12Member a, UnsignedInt12Member b, UnsignedInt12Member c) {
            Lcm.compute(G.UINT12, a, b, c);
        }
    };
    private final Function1<Boolean, UnsignedInt12Member> EVEN = new Function1<Boolean, UnsignedInt12Member>(){

        @Override
        public Boolean call(UnsignedInt12Member a) {
            return (a.v & 1) == 0;
        }
    };
    private final Function1<Boolean, UnsignedInt12Member> ODD = new Function1<Boolean, UnsignedInt12Member>(){

        @Override
        public Boolean call(UnsignedInt12Member a) {
            return (a.v & 1) == 1;
        }
    };
    private final Procedure3<UnsignedInt12Member, UnsignedInt12Member, UnsignedInt12Member> DIV = new Procedure3<UnsignedInt12Member, UnsignedInt12Member, UnsignedInt12Member>(){

        @Override
        public void call(UnsignedInt12Member a, UnsignedInt12Member b, UnsignedInt12Member d) {
            d.setV(a.v / b.v);
        }
    };
    private final Procedure3<UnsignedInt12Member, UnsignedInt12Member, UnsignedInt12Member> MOD = new Procedure3<UnsignedInt12Member, UnsignedInt12Member, UnsignedInt12Member>(){

        @Override
        public void call(UnsignedInt12Member a, UnsignedInt12Member b, UnsignedInt12Member m) {
            m.setV(a.v % b.v);
        }
    };
    private final Procedure4<UnsignedInt12Member, UnsignedInt12Member, UnsignedInt12Member, UnsignedInt12Member> DIVMOD = new Procedure4<UnsignedInt12Member, UnsignedInt12Member, UnsignedInt12Member, UnsignedInt12Member>(){

        @Override
        public void call(UnsignedInt12Member a, UnsignedInt12Member b, UnsignedInt12Member d, UnsignedInt12Member m) {
            UnsignedInt12Algebra.this.div().call(a, b, d);
            UnsignedInt12Algebra.this.mod().call(a, b, m);
        }
    };
    private final Procedure2<UnsignedInt12Member, UnsignedInt12Member> PRED = new Procedure2<UnsignedInt12Member, UnsignedInt12Member>(){

        @Override
        public void call(UnsignedInt12Member a, UnsignedInt12Member b) {
            if (a.v == 0) {
                b.v = (short)4095;
            } else {
                b.setV(a.v - 1);
            }
        }
    };
    private final Procedure2<UnsignedInt12Member, UnsignedInt12Member> SUCC = new Procedure2<UnsignedInt12Member, UnsignedInt12Member>(){

        @Override
        public void call(UnsignedInt12Member a, UnsignedInt12Member b) {
            if (a.v == 4095) {
                b.v = 0;
            } else {
                b.setV(a.v + 1);
            }
        }
    };
    private final Procedure3<UnsignedInt12Member, UnsignedInt12Member, UnsignedInt12Member> POW = new Procedure3<UnsignedInt12Member, UnsignedInt12Member, UnsignedInt12Member>(){

        @Override
        public void call(UnsignedInt12Member a, UnsignedInt12Member b, UnsignedInt12Member c) {
            PowerNonNegative.compute(G.UINT12, b.v, a, c);
        }
    };
    private final Procedure1<UnsignedInt12Member> RAND = new Procedure1<UnsignedInt12Member>(){

        @Override
        public void call(UnsignedInt12Member a) {
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            a.setV(rng.nextInt(4096));
        }
    };
    private final Procedure3<UnsignedInt12Member, UnsignedInt12Member, UnsignedInt12Member> AND = new Procedure3<UnsignedInt12Member, UnsignedInt12Member, UnsignedInt12Member>(){

        @Override
        public void call(UnsignedInt12Member a, UnsignedInt12Member b, UnsignedInt12Member c) {
            c.setV(a.v & b.v);
        }
    };
    private final Procedure3<UnsignedInt12Member, UnsignedInt12Member, UnsignedInt12Member> OR = new Procedure3<UnsignedInt12Member, UnsignedInt12Member, UnsignedInt12Member>(){

        @Override
        public void call(UnsignedInt12Member a, UnsignedInt12Member b, UnsignedInt12Member c) {
            c.setV(a.v | b.v);
        }
    };
    private final Procedure3<UnsignedInt12Member, UnsignedInt12Member, UnsignedInt12Member> XOR = new Procedure3<UnsignedInt12Member, UnsignedInt12Member, UnsignedInt12Member>(){

        @Override
        public void call(UnsignedInt12Member a, UnsignedInt12Member b, UnsignedInt12Member c) {
            c.setV(a.v ^ b.v);
        }
    };
    private final Procedure2<UnsignedInt12Member, UnsignedInt12Member> NOT = new Procedure2<UnsignedInt12Member, UnsignedInt12Member>(){

        @Override
        public void call(UnsignedInt12Member a, UnsignedInt12Member b) {
            b.setV(~a.v);
        }
    };
    private final Procedure3<UnsignedInt12Member, UnsignedInt12Member, UnsignedInt12Member> ANDNOT = new Procedure3<UnsignedInt12Member, UnsignedInt12Member, UnsignedInt12Member>(){

        @Override
        public void call(UnsignedInt12Member a, UnsignedInt12Member b, UnsignedInt12Member c) {
            c.setV(a.v & ~b.v);
        }
    };
    private final Procedure3<java.lang.Integer, UnsignedInt12Member, UnsignedInt12Member> SHL = new Procedure3<java.lang.Integer, UnsignedInt12Member, UnsignedInt12Member>(){

        @Override
        public void call(java.lang.Integer count, UnsignedInt12Member a, UnsignedInt12Member b) {
            if (count < 0) {
                UnsignedInt12Algebra.this.bitShiftRight().call(-count.intValue(), a, b);
            } else {
                count = count % 12;
                b.setV(a.v << count);
            }
        }
    };
    private final Procedure3<java.lang.Integer, UnsignedInt12Member, UnsignedInt12Member> SHRZ = new Procedure3<java.lang.Integer, UnsignedInt12Member, UnsignedInt12Member>(){

        @Override
        public void call(java.lang.Integer count, UnsignedInt12Member a, UnsignedInt12Member b) {
            if (count < 0) {
                UnsignedInt12Algebra.this.bitShiftLeft().call(-count.intValue(), a, b);
            } else {
                b.setV(a.v >>> count);
            }
        }
    };
    private final Procedure1<UnsignedInt12Member> MAXBOUND = new Procedure1<UnsignedInt12Member>(){

        @Override
        public void call(UnsignedInt12Member a) {
            a.v = (short)4095;
        }
    };
    private final Procedure1<UnsignedInt12Member> MINBOUND = new Procedure1<UnsignedInt12Member>(){

        @Override
        public void call(UnsignedInt12Member a) {
            a.v = 0;
        }
    };
    private final Function1<Boolean, UnsignedInt12Member> ISZERO = new Function1<Boolean, UnsignedInt12Member>(){

        @Override
        public Boolean call(UnsignedInt12Member a) {
            return a.v == 0;
        }
    };
    private final Procedure3<HighPrecisionMember, UnsignedInt12Member, UnsignedInt12Member> SBHP = new Procedure3<HighPrecisionMember, UnsignedInt12Member, UnsignedInt12Member>(){

        @Override
        public void call(HighPrecisionMember a, UnsignedInt12Member b, UnsignedInt12Member c) {
            BigDecimal tmp = a.v();
            tmp = tmp.multiply(new BigDecimal(b.v()));
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<HighPrecisionMember, UnsignedInt12Member, UnsignedInt12Member> SBHPR = new Procedure3<HighPrecisionMember, UnsignedInt12Member, UnsignedInt12Member>(){

        @Override
        public void call(HighPrecisionMember a, UnsignedInt12Member b, UnsignedInt12Member c) {
            BigDecimal tmp = a.v();
            int signum = (tmp = tmp.multiply(new BigDecimal(b.v()))).signum();
            tmp = signum < 0 ? tmp.subtract(G.ONE_HALF) : tmp.add(G.ONE_HALF);
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<RationalMember, UnsignedInt12Member, UnsignedInt12Member> SBR = new Procedure3<RationalMember, UnsignedInt12Member, UnsignedInt12Member>(){

        @Override
        public void call(RationalMember a, UnsignedInt12Member b, UnsignedInt12Member c) {
            BigInteger tmp = BigInteger.valueOf(b.v());
            tmp = tmp.multiply(a.n());
            tmp = tmp.divide(a.d());
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<Double, UnsignedInt12Member, UnsignedInt12Member> SBD = new Procedure3<Double, UnsignedInt12Member, UnsignedInt12Member>(){

        @Override
        public void call(Double a, UnsignedInt12Member b, UnsignedInt12Member c) {
            c.setV((int)(a * (double)b.v()));
        }
    };
    private final Procedure3<Double, UnsignedInt12Member, UnsignedInt12Member> SBDR = new Procedure3<Double, UnsignedInt12Member, UnsignedInt12Member>(){

        @Override
        public void call(Double a, UnsignedInt12Member b, UnsignedInt12Member c) {
            c.setV((int)Math.round(a * (double)b.v()));
        }
    };
    private final Function3<Boolean, UnsignedInt12Member, UnsignedInt12Member, UnsignedInt12Member> WITHIN = new Function3<Boolean, UnsignedInt12Member, UnsignedInt12Member, UnsignedInt12Member>(){

        @Override
        public Boolean call(UnsignedInt12Member tol, UnsignedInt12Member a, UnsignedInt12Member b) {
            return NumberWithin.compute(G.UINT12, tol, a, b);
        }
    };

    @Override
    public UnsignedInt12Member construct() {
        return new UnsignedInt12Member();
    }

    @Override
    public UnsignedInt12Member construct(UnsignedInt12Member other) {
        return new UnsignedInt12Member(other);
    }

    @Override
    public UnsignedInt12Member construct(String str) {
        return new UnsignedInt12Member(str);
    }

    @Override
    public Function2<Boolean, UnsignedInt12Member, UnsignedInt12Member> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, UnsignedInt12Member, UnsignedInt12Member> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<UnsignedInt12Member, UnsignedInt12Member> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure1<UnsignedInt12Member> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<UnsignedInt12Member, UnsignedInt12Member> negate() {
        return this.ASSIGN;
    }

    @Override
    public Procedure3<UnsignedInt12Member, UnsignedInt12Member, UnsignedInt12Member> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<UnsignedInt12Member, UnsignedInt12Member, UnsignedInt12Member> subtract() {
        return this.SUB;
    }

    @Override
    public Procedure3<UnsignedInt12Member, UnsignedInt12Member, UnsignedInt12Member> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt12Member, UnsignedInt12Member> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<UnsignedInt12Member> unity() {
        return this.UNITY;
    }

    @Override
    public Function2<Boolean, UnsignedInt12Member, UnsignedInt12Member> isLess() {
        return this.LESS;
    }

    @Override
    public Function2<Boolean, UnsignedInt12Member, UnsignedInt12Member> isLessEqual() {
        return this.LE;
    }

    @Override
    public Function2<Boolean, UnsignedInt12Member, UnsignedInt12Member> isGreater() {
        return this.GREAT;
    }

    @Override
    public Function2<Boolean, UnsignedInt12Member, UnsignedInt12Member> isGreaterEqual() {
        return this.GE;
    }

    @Override
    public Function2<java.lang.Integer, UnsignedInt12Member, UnsignedInt12Member> compare() {
        return this.CMP;
    }

    @Override
    public Function1<java.lang.Integer, UnsignedInt12Member> signum() {
        return this.SIG;
    }

    @Override
    public Procedure3<UnsignedInt12Member, UnsignedInt12Member, UnsignedInt12Member> min() {
        return this.MIN;
    }

    @Override
    public Procedure3<UnsignedInt12Member, UnsignedInt12Member, UnsignedInt12Member> max() {
        return this.MAX;
    }

    @Override
    public Procedure2<UnsignedInt12Member, UnsignedInt12Member> abs() {
        return this.ASSIGN;
    }

    @Override
    public Procedure2<UnsignedInt12Member, UnsignedInt12Member> norm() {
        return this.ASSIGN;
    }

    @Override
    public Procedure3<UnsignedInt12Member, UnsignedInt12Member, UnsignedInt12Member> gcd() {
        return this.GCD;
    }

    @Override
    public Procedure3<UnsignedInt12Member, UnsignedInt12Member, UnsignedInt12Member> lcm() {
        return this.LCM;
    }

    @Override
    public Function1<Boolean, UnsignedInt12Member> isEven() {
        return this.EVEN;
    }

    @Override
    public Function1<Boolean, UnsignedInt12Member> isOdd() {
        return this.ODD;
    }

    @Override
    public Procedure3<UnsignedInt12Member, UnsignedInt12Member, UnsignedInt12Member> div() {
        return this.DIV;
    }

    @Override
    public Procedure3<UnsignedInt12Member, UnsignedInt12Member, UnsignedInt12Member> mod() {
        return this.MOD;
    }

    @Override
    public Procedure4<UnsignedInt12Member, UnsignedInt12Member, UnsignedInt12Member, UnsignedInt12Member> divMod() {
        return this.DIVMOD;
    }

    @Override
    public Procedure2<UnsignedInt12Member, UnsignedInt12Member> pred() {
        return this.PRED;
    }

    @Override
    public Procedure2<UnsignedInt12Member, UnsignedInt12Member> succ() {
        return this.SUCC;
    }

    @Override
    public Procedure3<UnsignedInt12Member, UnsignedInt12Member, UnsignedInt12Member> pow() {
        return this.POW;
    }

    @Override
    public Procedure1<UnsignedInt12Member> random() {
        return this.RAND;
    }

    @Override
    public Procedure3<UnsignedInt12Member, UnsignedInt12Member, UnsignedInt12Member> bitAnd() {
        return this.AND;
    }

    @Override
    public Procedure3<UnsignedInt12Member, UnsignedInt12Member, UnsignedInt12Member> bitOr() {
        return this.OR;
    }

    @Override
    public Procedure3<UnsignedInt12Member, UnsignedInt12Member, UnsignedInt12Member> bitXor() {
        return this.XOR;
    }

    @Override
    public Procedure2<UnsignedInt12Member, UnsignedInt12Member> bitNot() {
        return this.NOT;
    }

    @Override
    public Procedure3<UnsignedInt12Member, UnsignedInt12Member, UnsignedInt12Member> bitAndNot() {
        return this.ANDNOT;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt12Member, UnsignedInt12Member> bitShiftLeft() {
        return this.SHL;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt12Member, UnsignedInt12Member> bitShiftRight() {
        return this.SHRZ;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt12Member, UnsignedInt12Member> bitShiftRightFillZero() {
        return this.SHRZ;
    }

    @Override
    public Procedure1<UnsignedInt12Member> maxBound() {
        return this.MAXBOUND;
    }

    @Override
    public Procedure1<UnsignedInt12Member> minBound() {
        return this.MINBOUND;
    }

    @Override
    public Function1<Boolean, UnsignedInt12Member> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<UnsignedInt12Member, UnsignedInt12Member, UnsignedInt12Member> scale() {
        return this.MUL;
    }

    @Override
    public Procedure3<HighPrecisionMember, UnsignedInt12Member, UnsignedInt12Member> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<HighPrecisionMember, UnsignedInt12Member, UnsignedInt12Member> scaleByHighPrecAndRound() {
        return this.SBHPR;
    }

    @Override
    public Procedure3<RationalMember, UnsignedInt12Member, UnsignedInt12Member> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, UnsignedInt12Member, UnsignedInt12Member> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<Double, UnsignedInt12Member, UnsignedInt12Member> scaleByDoubleAndRound() {
        return this.SBDR;
    }

    @Override
    public Function3<Boolean, UnsignedInt12Member, UnsignedInt12Member, UnsignedInt12Member> within() {
        return this.WITHIN;
    }
}

