/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.int128;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.ThreadLocalRandom;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.DivMod;
import nom.bdezonia.zorbage.algorithm.Gcd;
import nom.bdezonia.zorbage.algorithm.Lcm;
import nom.bdezonia.zorbage.algorithm.Max;
import nom.bdezonia.zorbage.algorithm.Min;
import nom.bdezonia.zorbage.algorithm.Multiply;
import nom.bdezonia.zorbage.algorithm.NumberWithin;
import nom.bdezonia.zorbage.algorithm.PowerNonNegative;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.BitOperations;
import nom.bdezonia.zorbage.type.algebra.Bounded;
import nom.bdezonia.zorbage.type.algebra.Integer;
import nom.bdezonia.zorbage.type.algebra.Random;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.int128.SignedInt128Member;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class SignedInt128Algebra
implements Integer<SignedInt128Algebra, SignedInt128Member>,
Bounded<SignedInt128Member>,
BitOperations<SignedInt128Member>,
Random<SignedInt128Member>,
Tolerance<SignedInt128Member, SignedInt128Member> {
    private static final SignedInt128Member ZERO = new SignedInt128Member();
    private static final SignedInt128Member ONE = new SignedInt128Member(0L, 1L);
    private final Function2<Boolean, SignedInt128Member, SignedInt128Member> EQ = new Function2<Boolean, SignedInt128Member, SignedInt128Member>(){

        @Override
        public Boolean call(SignedInt128Member a, SignedInt128Member b) {
            return a.lo == b.lo && a.hi == b.hi;
        }
    };
    private final Function2<Boolean, SignedInt128Member, SignedInt128Member> NEQ = new Function2<Boolean, SignedInt128Member, SignedInt128Member>(){

        @Override
        public Boolean call(SignedInt128Member a, SignedInt128Member b) {
            return SignedInt128Algebra.this.isEqual().call(a, b) == false;
        }
    };
    private Procedure2<SignedInt128Member, SignedInt128Member> ASSIGN = new Procedure2<SignedInt128Member, SignedInt128Member>(){

        @Override
        public void call(SignedInt128Member from, SignedInt128Member to) {
            to.set(from);
        }
    };
    private Procedure1<SignedInt128Member> ZER = new Procedure1<SignedInt128Member>(){

        @Override
        public void call(SignedInt128Member a) {
            a.lo = 0L;
            a.hi = 0L;
        }
    };
    private final Procedure2<SignedInt128Member, SignedInt128Member> NEG = new Procedure2<SignedInt128Member, SignedInt128Member>(){

        @Override
        public void call(SignedInt128Member a, SignedInt128Member b) {
            if (a.hi == Long.MIN_VALUE && a.lo == 0L) {
                throw new IllegalArgumentException("can't negate -minint");
            }
            SignedInt128Algebra.this.subtract().call(ZERO, a, b);
        }
    };
    private final Procedure3<SignedInt128Member, SignedInt128Member, SignedInt128Member> ADD = new Procedure3<SignedInt128Member, SignedInt128Member, SignedInt128Member>(){

        @Override
        public void call(SignedInt128Member a, SignedInt128Member b, SignedInt128Member c) {
            long bll;
            long all;
            long cLo = a.lo + b.lo;
            long cHi = a.hi + b.hi;
            int correction = 0;
            long alh = a.lo & Long.MIN_VALUE;
            long blh = b.lo & Long.MIN_VALUE;
            if (alh != 0L && blh != 0L) {
                correction = 1;
            } else if ((alh != 0L && blh == 0L || alh == 0L && blh != 0L) && (all = a.lo & Long.MAX_VALUE) + (bll = b.lo & Long.MAX_VALUE) < 0L) {
                correction = 1;
            }
            c.lo = cLo;
            c.hi = cHi += (long)correction;
        }
    };
    private final Procedure3<SignedInt128Member, SignedInt128Member, SignedInt128Member> SUB = new Procedure3<SignedInt128Member, SignedInt128Member, SignedInt128Member>(){

        @Override
        public void call(SignedInt128Member a, SignedInt128Member b, SignedInt128Member c) {
            long bll;
            long all;
            long cHi = a.hi - b.hi;
            long cLo = a.lo - b.lo;
            long alh = a.lo & Long.MIN_VALUE;
            long blh = b.lo & Long.MIN_VALUE;
            int correction = alh == 0L && blh != 0L ? 1 : (alh != 0L && blh == 0L ? 0 : ((all = a.lo & Long.MAX_VALUE) < (bll = b.lo & Long.MAX_VALUE) ? 1 : 0));
            c.lo = cLo;
            c.hi = cHi -= (long)correction;
        }
    };
    private final Procedure3<SignedInt128Member, SignedInt128Member, SignedInt128Member> MUL = new Procedure3<SignedInt128Member, SignedInt128Member, SignedInt128Member>(){

        @Override
        public void call(SignedInt128Member a, SignedInt128Member b, SignedInt128Member c) {
            Multiply.compute(G.INT128, a, b, c);
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt128Member, SignedInt128Member> POWER = new Procedure3<java.lang.Integer, SignedInt128Member, SignedInt128Member>(){

        @Override
        public void call(java.lang.Integer power, SignedInt128Member a, SignedInt128Member b) {
            PowerNonNegative.compute(G.INT128, power, a, b);
        }
    };
    private Procedure1<SignedInt128Member> UNITY = new Procedure1<SignedInt128Member>(){

        @Override
        public void call(SignedInt128Member a) {
            SignedInt128Algebra.this.assign().call(ONE, a);
        }
    };
    private final Function2<Boolean, SignedInt128Member, SignedInt128Member> LESS = new Function2<Boolean, SignedInt128Member, SignedInt128Member>(){

        @Override
        public Boolean call(SignedInt128Member a, SignedInt128Member b) {
            return SignedInt128Algebra.this.compare().call(a, b) < 0;
        }
    };
    private final Function2<Boolean, SignedInt128Member, SignedInt128Member> LE = new Function2<Boolean, SignedInt128Member, SignedInt128Member>(){

        @Override
        public Boolean call(SignedInt128Member a, SignedInt128Member b) {
            return SignedInt128Algebra.this.compare().call(a, b) <= 0;
        }
    };
    private final Function2<Boolean, SignedInt128Member, SignedInt128Member> GREAT = new Function2<Boolean, SignedInt128Member, SignedInt128Member>(){

        @Override
        public Boolean call(SignedInt128Member a, SignedInt128Member b) {
            return SignedInt128Algebra.this.compare().call(a, b) > 0;
        }
    };
    private final Function2<Boolean, SignedInt128Member, SignedInt128Member> GE = new Function2<Boolean, SignedInt128Member, SignedInt128Member>(){

        @Override
        public Boolean call(SignedInt128Member a, SignedInt128Member b) {
            return SignedInt128Algebra.this.compare().call(a, b) >= 0;
        }
    };
    private final Function2<java.lang.Integer, SignedInt128Member, SignedInt128Member> CMP = new Function2<java.lang.Integer, SignedInt128Member, SignedInt128Member>(){

        @Override
        public java.lang.Integer call(SignedInt128Member a, SignedInt128Member b) {
            long ab = a.hi & Long.MIN_VALUE;
            long bb = b.hi & Long.MIN_VALUE;
            if (ab == 0L && bb != 0L) {
                return 1;
            }
            if (ab != 0L && bb == 0L) {
                return -1;
            }
            long along = a.hi & Long.MAX_VALUE;
            long blong = b.hi & Long.MAX_VALUE;
            if (along < blong) {
                return -1;
            }
            if (along > blong) {
                return 1;
            }
            ab = a.lo & Long.MIN_VALUE;
            bb = b.lo & Long.MIN_VALUE;
            if (ab == 0L && bb != 0L) {
                return -1;
            }
            if (ab != 0L && bb == 0L) {
                return 1;
            }
            along = a.lo & Long.MAX_VALUE;
            blong = b.lo & Long.MAX_VALUE;
            if (along < blong) {
                return -1;
            }
            if (along > blong) {
                return 1;
            }
            return 0;
        }
    };
    private final Function1<java.lang.Integer, SignedInt128Member> SIG = new Function1<java.lang.Integer, SignedInt128Member>(){

        @Override
        public java.lang.Integer call(SignedInt128Member a) {
            if (SignedInt128Algebra.this.isEqual().call(a, ZERO).booleanValue()) {
                return 0;
            }
            if ((a.hi & Long.MIN_VALUE) != 0L) {
                return -1;
            }
            return 1;
        }
    };
    private final Procedure3<SignedInt128Member, SignedInt128Member, SignedInt128Member> MIN = new Procedure3<SignedInt128Member, SignedInt128Member, SignedInt128Member>(){

        @Override
        public void call(SignedInt128Member a, SignedInt128Member b, SignedInt128Member c) {
            Min.compute(G.INT128, a, b, c);
        }
    };
    private final Procedure3<SignedInt128Member, SignedInt128Member, SignedInt128Member> MAX = new Procedure3<SignedInt128Member, SignedInt128Member, SignedInt128Member>(){

        @Override
        public void call(SignedInt128Member a, SignedInt128Member b, SignedInt128Member c) {
            Max.compute(G.INT128, a, b, c);
        }
    };
    private final Procedure2<SignedInt128Member, SignedInt128Member> ABS = new Procedure2<SignedInt128Member, SignedInt128Member>(){

        @Override
        public void call(SignedInt128Member a, SignedInt128Member b) {
            if (SignedInt128Algebra.this.compare().call(a, ZERO) < 0) {
                SignedInt128Algebra.this.negate().call(a, b);
            } else {
                SignedInt128Algebra.this.assign().call(a, b);
            }
        }
    };
    private final Procedure3<SignedInt128Member, SignedInt128Member, SignedInt128Member> DIV = new Procedure3<SignedInt128Member, SignedInt128Member, SignedInt128Member>(){

        @Override
        public void call(SignedInt128Member a, SignedInt128Member b, SignedInt128Member d) {
            SignedInt128Member m = new SignedInt128Member();
            SignedInt128Algebra.this.divMod().call(a, b, d, m);
        }
    };
    private final Procedure3<SignedInt128Member, SignedInt128Member, SignedInt128Member> MOD = new Procedure3<SignedInt128Member, SignedInt128Member, SignedInt128Member>(){

        @Override
        public void call(SignedInt128Member a, SignedInt128Member b, SignedInt128Member m) {
            SignedInt128Member d = new SignedInt128Member();
            SignedInt128Algebra.this.divMod().call(a, b, d, m);
        }
    };
    private final Procedure4<SignedInt128Member, SignedInt128Member, SignedInt128Member, SignedInt128Member> DIVMOD = new Procedure4<SignedInt128Member, SignedInt128Member, SignedInt128Member, SignedInt128Member>(){

        @Override
        public void call(SignedInt128Member a, SignedInt128Member b, SignedInt128Member d, SignedInt128Member m) {
            if (a.hi == Long.MIN_VALUE && a.lo == 0L && b.hi == -1L && b.lo == -1L) {
                throw new IllegalArgumentException("cannot divide -minint by -1");
            }
            DivMod.compute(G.INT128, a, b, d, m);
        }
    };
    private final Procedure3<SignedInt128Member, SignedInt128Member, SignedInt128Member> GCD = new Procedure3<SignedInt128Member, SignedInt128Member, SignedInt128Member>(){

        @Override
        public void call(SignedInt128Member a, SignedInt128Member b, SignedInt128Member c) {
            Gcd.compute(G.INT128, a, b, c);
        }
    };
    private final Procedure3<SignedInt128Member, SignedInt128Member, SignedInt128Member> LCM = new Procedure3<SignedInt128Member, SignedInt128Member, SignedInt128Member>(){

        @Override
        public void call(SignedInt128Member a, SignedInt128Member b, SignedInt128Member c) {
            Lcm.compute(G.INT128, a, b, c);
        }
    };
    private final Function1<Boolean, SignedInt128Member> EVEN = new Function1<Boolean, SignedInt128Member>(){

        @Override
        public Boolean call(SignedInt128Member a) {
            return (a.lo & 1L) == 0L;
        }
    };
    private final Function1<Boolean, SignedInt128Member> ODD = new Function1<Boolean, SignedInt128Member>(){

        @Override
        public Boolean call(SignedInt128Member a) {
            return (a.lo & 1L) == 1L;
        }
    };
    private Procedure2<SignedInt128Member, SignedInt128Member> PRED = new Procedure2<SignedInt128Member, SignedInt128Member>(){

        @Override
        public void call(SignedInt128Member a, SignedInt128Member b) {
            SignedInt128Algebra.this.subtract().call(a, ONE, b);
        }
    };
    private Procedure2<SignedInt128Member, SignedInt128Member> SUCC = new Procedure2<SignedInt128Member, SignedInt128Member>(){

        @Override
        public void call(SignedInt128Member a, SignedInt128Member b) {
            SignedInt128Algebra.this.add().call(a, ONE, b);
        }
    };
    private final Procedure3<SignedInt128Member, SignedInt128Member, SignedInt128Member> POW = new Procedure3<SignedInt128Member, SignedInt128Member, SignedInt128Member>(){

        @Override
        public void call(SignedInt128Member a, SignedInt128Member b, SignedInt128Member c) {
            if (SignedInt128Algebra.this.signum().call(a) == 0 && SignedInt128Algebra.this.signum().call(b) == 0) {
                throw new IllegalArgumentException("0^0 is not a number");
            }
            SignedInt128Member tmp = new SignedInt128Member(ONE);
            SignedInt128Member pow = new SignedInt128Member(b);
            while (!SignedInt128Algebra.this.isEqual().call(pow, ZERO).booleanValue()) {
                SignedInt128Algebra.this.multiply().call(tmp, a, tmp);
                SignedInt128Algebra.this.pred().call(pow, pow);
            }
            SignedInt128Algebra.this.assign().call(tmp, c);
        }
    };
    private Procedure1<SignedInt128Member> RAND = new Procedure1<SignedInt128Member>(){

        @Override
        public void call(SignedInt128Member a) {
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            a.lo = rng.nextLong();
            a.hi = rng.nextLong();
        }
    };
    private final Procedure3<SignedInt128Member, SignedInt128Member, SignedInt128Member> BITAND = new Procedure3<SignedInt128Member, SignedInt128Member, SignedInt128Member>(){

        @Override
        public void call(SignedInt128Member a, SignedInt128Member b, SignedInt128Member c) {
            c.lo = a.lo & b.lo;
            c.hi = a.hi & b.hi;
        }
    };
    private final Procedure3<SignedInt128Member, SignedInt128Member, SignedInt128Member> BITOR = new Procedure3<SignedInt128Member, SignedInt128Member, SignedInt128Member>(){

        @Override
        public void call(SignedInt128Member a, SignedInt128Member b, SignedInt128Member c) {
            c.lo = a.lo | b.lo;
            c.hi = a.hi | b.hi;
        }
    };
    private final Procedure3<SignedInt128Member, SignedInt128Member, SignedInt128Member> BITXOR = new Procedure3<SignedInt128Member, SignedInt128Member, SignedInt128Member>(){

        @Override
        public void call(SignedInt128Member a, SignedInt128Member b, SignedInt128Member c) {
            c.lo = a.lo ^ b.lo;
            c.hi = a.hi ^ b.hi;
        }
    };
    private Procedure2<SignedInt128Member, SignedInt128Member> BITNOT = new Procedure2<SignedInt128Member, SignedInt128Member>(){

        @Override
        public void call(SignedInt128Member a, SignedInt128Member b) {
            b.lo = a.lo ^ 0xFFFFFFFFFFFFFFFFL;
            b.hi = a.hi ^ 0xFFFFFFFFFFFFFFFFL;
        }
    };
    private final Procedure3<SignedInt128Member, SignedInt128Member, SignedInt128Member> BITANDNOT = new Procedure3<SignedInt128Member, SignedInt128Member, SignedInt128Member>(){

        @Override
        public void call(SignedInt128Member a, SignedInt128Member b, SignedInt128Member c) {
            c.lo = a.lo & (b.lo ^ 0xFFFFFFFFFFFFFFFFL);
            c.hi = a.hi & (b.hi ^ 0xFFFFFFFFFFFFFFFFL);
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt128Member, SignedInt128Member> BITSHL = new Procedure3<java.lang.Integer, SignedInt128Member, SignedInt128Member>(){

        @Override
        public void call(java.lang.Integer count, SignedInt128Member a, SignedInt128Member b) {
            if (count < 0) {
                SignedInt128Algebra.this.bitShiftRight().call(-count.intValue(), a, b);
            } else {
                count = count % 128;
                SignedInt128Member tmp = new SignedInt128Member(a);
                for (int i = 0; i < count; ++i) {
                    SignedInt128Algebra.this.shiftLeftOneBit(tmp);
                }
                SignedInt128Algebra.this.assign().call(tmp, b);
            }
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt128Member, SignedInt128Member> BITSHR = new Procedure3<java.lang.Integer, SignedInt128Member, SignedInt128Member>(){

        @Override
        public void call(java.lang.Integer count, SignedInt128Member a, SignedInt128Member b) {
            if (count < 0) {
                SignedInt128Algebra.this.bitShiftLeft().call(-count.intValue(), a, b);
            } else {
                SignedInt128Member tmp = new SignedInt128Member(a);
                for (int i = 0; !(i >= count || tmp.hi == 0L && tmp.lo == 0L || tmp.hi == -1L && tmp.lo == -1L); ++i) {
                    SignedInt128Algebra.this.shiftRightOneBit(tmp);
                }
                SignedInt128Algebra.this.assign().call(tmp, b);
            }
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt128Member, SignedInt128Member> BITSHRZ = new Procedure3<java.lang.Integer, SignedInt128Member, SignedInt128Member>(){

        @Override
        public void call(java.lang.Integer count, SignedInt128Member a, SignedInt128Member b) {
            if (count < 0) {
                SignedInt128Algebra.this.bitShiftLeft().call(-count.intValue(), a, b);
            } else if (count > 127) {
                SignedInt128Algebra.this.assign().call(ZERO, b);
            } else {
                SignedInt128Member tmp = new SignedInt128Member(a);
                for (int i = 0; i < count; ++i) {
                    SignedInt128Algebra.this.shiftRightOneBit(tmp);
                }
                SignedInt128Algebra.this.assign().call(tmp, b);
            }
        }
    };
    private Procedure1<SignedInt128Member> MAXBOUND = new Procedure1<SignedInt128Member>(){

        @Override
        public void call(SignedInt128Member a) {
            a.lo = -1L;
            a.hi = Long.MAX_VALUE;
        }
    };
    private Procedure1<SignedInt128Member> MINBOUND = new Procedure1<SignedInt128Member>(){

        @Override
        public void call(SignedInt128Member a) {
            a.lo = 0L;
            a.hi = Long.MIN_VALUE;
        }
    };
    private final Function1<Boolean, SignedInt128Member> ISZERO = new Function1<Boolean, SignedInt128Member>(){

        @Override
        public Boolean call(SignedInt128Member a) {
            return a.lo == 0L && a.hi == 0L;
        }
    };
    private final Procedure3<HighPrecisionMember, SignedInt128Member, SignedInt128Member> SBHP = new Procedure3<HighPrecisionMember, SignedInt128Member, SignedInt128Member>(){

        @Override
        public void call(HighPrecisionMember a, SignedInt128Member b, SignedInt128Member c) {
            BigDecimal tmp = a.v();
            tmp = tmp.multiply(new BigDecimal(b.v()));
            c.setV(tmp.toBigInteger());
        }
    };
    private final Procedure3<HighPrecisionMember, SignedInt128Member, SignedInt128Member> SBHPR = new Procedure3<HighPrecisionMember, SignedInt128Member, SignedInt128Member>(){

        @Override
        public void call(HighPrecisionMember a, SignedInt128Member b, SignedInt128Member c) {
            BigDecimal tmp = a.v();
            int signum = (tmp = tmp.multiply(new BigDecimal(b.v()))).signum();
            tmp = signum < 0 ? tmp.subtract(G.ONE_HALF) : tmp.add(G.ONE_HALF);
            c.setV(tmp.toBigInteger());
        }
    };
    private final Procedure3<RationalMember, SignedInt128Member, SignedInt128Member> SBR = new Procedure3<RationalMember, SignedInt128Member, SignedInt128Member>(){

        @Override
        public void call(RationalMember a, SignedInt128Member b, SignedInt128Member c) {
            BigInteger tmp = b.v();
            tmp = tmp.multiply(a.n());
            tmp = tmp.divide(a.d());
            c.setV(tmp);
        }
    };
    private final Procedure3<Double, SignedInt128Member, SignedInt128Member> SBD = new Procedure3<Double, SignedInt128Member, SignedInt128Member>(){

        @Override
        public void call(Double a, SignedInt128Member b, SignedInt128Member c) {
            BigDecimal tmp = new BigDecimal(b.v());
            tmp = tmp.multiply(BigDecimal.valueOf(a));
            c.setV(tmp.toBigInteger());
        }
    };
    private final Procedure3<Double, SignedInt128Member, SignedInt128Member> SBDR = new Procedure3<Double, SignedInt128Member, SignedInt128Member>(){

        @Override
        public void call(Double a, SignedInt128Member b, SignedInt128Member c) {
            BigDecimal tmp = new BigDecimal(b.v());
            int signum = (tmp = tmp.multiply(BigDecimal.valueOf(a))).signum();
            tmp = signum < 0 ? tmp.subtract(G.ONE_HALF) : tmp.add(G.ONE_HALF);
            c.setV(tmp.toBigInteger());
        }
    };
    private final Function3<Boolean, SignedInt128Member, SignedInt128Member, SignedInt128Member> WITHIN = new Function3<Boolean, SignedInt128Member, SignedInt128Member, SignedInt128Member>(){

        @Override
        public Boolean call(SignedInt128Member tol, SignedInt128Member a, SignedInt128Member b) {
            return NumberWithin.compute(G.INT128, tol, a, b);
        }
    };

    @Override
    public SignedInt128Member construct() {
        return new SignedInt128Member();
    }

    @Override
    public SignedInt128Member construct(SignedInt128Member other) {
        return new SignedInt128Member(other);
    }

    @Override
    public SignedInt128Member construct(String str) {
        return new SignedInt128Member(str);
    }

    @Override
    public Function2<Boolean, SignedInt128Member, SignedInt128Member> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, SignedInt128Member, SignedInt128Member> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<SignedInt128Member, SignedInt128Member> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure1<SignedInt128Member> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<SignedInt128Member, SignedInt128Member> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<SignedInt128Member, SignedInt128Member, SignedInt128Member> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<SignedInt128Member, SignedInt128Member, SignedInt128Member> subtract() {
        return this.SUB;
    }

    @Override
    public Procedure3<SignedInt128Member, SignedInt128Member, SignedInt128Member> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt128Member, SignedInt128Member> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<SignedInt128Member> unity() {
        return this.UNITY;
    }

    @Override
    public Function2<Boolean, SignedInt128Member, SignedInt128Member> isLess() {
        return this.LESS;
    }

    @Override
    public Function2<Boolean, SignedInt128Member, SignedInt128Member> isLessEqual() {
        return this.LE;
    }

    @Override
    public Function2<Boolean, SignedInt128Member, SignedInt128Member> isGreater() {
        return this.GREAT;
    }

    @Override
    public Function2<Boolean, SignedInt128Member, SignedInt128Member> isGreaterEqual() {
        return this.GE;
    }

    @Override
    public Function2<java.lang.Integer, SignedInt128Member, SignedInt128Member> compare() {
        return this.CMP;
    }

    @Override
    public Function1<java.lang.Integer, SignedInt128Member> signum() {
        return this.SIG;
    }

    @Override
    public final Procedure3<SignedInt128Member, SignedInt128Member, SignedInt128Member> min() {
        return this.MIN;
    }

    @Override
    public Procedure3<SignedInt128Member, SignedInt128Member, SignedInt128Member> max() {
        return this.MAX;
    }

    @Override
    public Procedure2<SignedInt128Member, SignedInt128Member> abs() {
        return this.ABS;
    }

    @Override
    public Procedure2<SignedInt128Member, SignedInt128Member> norm() {
        return this.ABS;
    }

    @Override
    public Procedure3<SignedInt128Member, SignedInt128Member, SignedInt128Member> div() {
        return this.DIV;
    }

    @Override
    public Procedure3<SignedInt128Member, SignedInt128Member, SignedInt128Member> mod() {
        return this.MOD;
    }

    @Override
    public Procedure4<SignedInt128Member, SignedInt128Member, SignedInt128Member, SignedInt128Member> divMod() {
        return this.DIVMOD;
    }

    @Override
    public Procedure3<SignedInt128Member, SignedInt128Member, SignedInt128Member> gcd() {
        return this.GCD;
    }

    @Override
    public Procedure3<SignedInt128Member, SignedInt128Member, SignedInt128Member> lcm() {
        return this.LCM;
    }

    @Override
    public Function1<Boolean, SignedInt128Member> isEven() {
        return this.EVEN;
    }

    @Override
    public Function1<Boolean, SignedInt128Member> isOdd() {
        return this.ODD;
    }

    @Override
    public Procedure2<SignedInt128Member, SignedInt128Member> pred() {
        return this.PRED;
    }

    @Override
    public Procedure2<SignedInt128Member, SignedInt128Member> succ() {
        return this.SUCC;
    }

    @Override
    public Procedure3<SignedInt128Member, SignedInt128Member, SignedInt128Member> pow() {
        return this.POW;
    }

    @Override
    public Procedure1<SignedInt128Member> random() {
        return this.RAND;
    }

    @Override
    public Procedure3<SignedInt128Member, SignedInt128Member, SignedInt128Member> bitAnd() {
        return this.BITAND;
    }

    @Override
    public Procedure3<SignedInt128Member, SignedInt128Member, SignedInt128Member> bitOr() {
        return this.BITOR;
    }

    @Override
    public Procedure3<SignedInt128Member, SignedInt128Member, SignedInt128Member> bitXor() {
        return this.BITXOR;
    }

    @Override
    public Procedure2<SignedInt128Member, SignedInt128Member> bitNot() {
        return this.BITNOT;
    }

    @Override
    public Procedure3<SignedInt128Member, SignedInt128Member, SignedInt128Member> bitAndNot() {
        return this.BITANDNOT;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt128Member, SignedInt128Member> bitShiftLeft() {
        return this.BITSHL;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt128Member, SignedInt128Member> bitShiftRight() {
        return this.BITSHR;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt128Member, SignedInt128Member> bitShiftRightFillZero() {
        return this.BITSHRZ;
    }

    @Override
    public Procedure1<SignedInt128Member> maxBound() {
        return this.MAXBOUND;
    }

    @Override
    public Procedure1<SignedInt128Member> minBound() {
        return this.MINBOUND;
    }

    @Override
    public Function1<Boolean, SignedInt128Member> isZero() {
        return this.ISZERO;
    }

    private void shiftLeftOneBit(SignedInt128Member val) {
        boolean transitionBit = (val.lo & Long.MIN_VALUE) != 0L;
        val.lo <<= 1;
        val.hi <<= 1;
        if (transitionBit) {
            val.hi |= 1L;
        }
    }

    private void shiftRightOneBit(SignedInt128Member val) {
        boolean neg = (val.hi & Long.MIN_VALUE) != 0L;
        boolean transitionBit = (val.hi & 1L) != 0L;
        boolean loHBit = (val.lo & Long.MIN_VALUE) != 0L;
        val.lo = (val.lo & Long.MAX_VALUE) >>> 1;
        if (loHBit) {
            val.lo |= 0x4000000000000000L;
        }
        boolean hiHBit = (val.hi & Long.MIN_VALUE) != 0L;
        val.hi = (val.hi & Long.MAX_VALUE) >>> 1;
        if (hiHBit) {
            val.hi |= 0x4000000000000000L;
        }
        if (transitionBit) {
            val.lo |= Long.MIN_VALUE;
        }
        if (neg) {
            val.hi |= Long.MIN_VALUE;
        }
    }

    @Override
    public Procedure3<SignedInt128Member, SignedInt128Member, SignedInt128Member> scale() {
        return this.MUL;
    }

    @Override
    public Procedure3<HighPrecisionMember, SignedInt128Member, SignedInt128Member> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<HighPrecisionMember, SignedInt128Member, SignedInt128Member> scaleByHighPrecAndRound() {
        return this.SBHPR;
    }

    @Override
    public Procedure3<RationalMember, SignedInt128Member, SignedInt128Member> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, SignedInt128Member, SignedInt128Member> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<Double, SignedInt128Member, SignedInt128Member> scaleByDoubleAndRound() {
        return this.SBDR;
    }

    @Override
    public Function3<Boolean, SignedInt128Member, SignedInt128Member, SignedInt128Member> within() {
        return this.WITHIN;
    }
}

