/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.int128;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.ThreadLocalRandom;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.DivMod;
import nom.bdezonia.zorbage.algorithm.Gcd;
import nom.bdezonia.zorbage.algorithm.Lcm;
import nom.bdezonia.zorbage.algorithm.Max;
import nom.bdezonia.zorbage.algorithm.Min;
import nom.bdezonia.zorbage.algorithm.Multiply;
import nom.bdezonia.zorbage.algorithm.NumberWithin;
import nom.bdezonia.zorbage.algorithm.PowerNonNegative;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.BitOperations;
import nom.bdezonia.zorbage.type.algebra.Bounded;
import nom.bdezonia.zorbage.type.algebra.Integer;
import nom.bdezonia.zorbage.type.algebra.Random;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.int128.UnsignedInt128Member;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class UnsignedInt128Algebra
implements Integer<UnsignedInt128Algebra, UnsignedInt128Member>,
Bounded<UnsignedInt128Member>,
BitOperations<UnsignedInt128Member>,
Random<UnsignedInt128Member>,
Tolerance<UnsignedInt128Member, UnsignedInt128Member> {
    private static final UnsignedInt128Member ZERO = new UnsignedInt128Member();
    private static final UnsignedInt128Member ONE = new UnsignedInt128Member(0L, 1L);
    private final Function2<Boolean, UnsignedInt128Member, UnsignedInt128Member> EQ = new Function2<Boolean, UnsignedInt128Member, UnsignedInt128Member>(){

        @Override
        public Boolean call(UnsignedInt128Member a, UnsignedInt128Member b) {
            return a.lo == b.lo && a.hi == b.hi;
        }
    };
    private final Function2<Boolean, UnsignedInt128Member, UnsignedInt128Member> NEQ = new Function2<Boolean, UnsignedInt128Member, UnsignedInt128Member>(){

        @Override
        public Boolean call(UnsignedInt128Member a, UnsignedInt128Member b) {
            return UnsignedInt128Algebra.this.isEqual().call(a, b) == false;
        }
    };
    private Procedure2<UnsignedInt128Member, UnsignedInt128Member> ASSIGN = new Procedure2<UnsignedInt128Member, UnsignedInt128Member>(){

        @Override
        public void call(UnsignedInt128Member from, UnsignedInt128Member to) {
            to.set(from);
        }
    };
    private Procedure1<UnsignedInt128Member> ZER = new Procedure1<UnsignedInt128Member>(){

        @Override
        public void call(UnsignedInt128Member a) {
            a.lo = 0L;
            a.hi = 0L;
        }
    };
    private final Procedure3<UnsignedInt128Member, UnsignedInt128Member, UnsignedInt128Member> ADD = new Procedure3<UnsignedInt128Member, UnsignedInt128Member, UnsignedInt128Member>(){

        @Override
        public void call(UnsignedInt128Member a, UnsignedInt128Member b, UnsignedInt128Member c) {
            long bll;
            long all;
            long cLo = a.lo + b.lo;
            long cHi = a.hi + b.hi;
            int correction = 0;
            long alh = a.lo & Long.MIN_VALUE;
            long blh = b.lo & Long.MIN_VALUE;
            if (alh != 0L && blh != 0L) {
                correction = 1;
            } else if ((alh != 0L && blh == 0L || alh == 0L && blh != 0L) && (all = a.lo & Long.MAX_VALUE) + (bll = b.lo & Long.MAX_VALUE) < 0L) {
                correction = 1;
            }
            c.lo = cLo;
            c.hi = cHi += (long)correction;
        }
    };
    private final Procedure3<UnsignedInt128Member, UnsignedInt128Member, UnsignedInt128Member> SUB = new Procedure3<UnsignedInt128Member, UnsignedInt128Member, UnsignedInt128Member>(){

        @Override
        public void call(UnsignedInt128Member a, UnsignedInt128Member b, UnsignedInt128Member c) {
            long bll;
            long all;
            long cHi = a.hi - b.hi;
            long cLo = a.lo - b.lo;
            long alh = a.lo & Long.MIN_VALUE;
            long blh = b.lo & Long.MIN_VALUE;
            int correction = alh == 0L && blh != 0L ? 1 : (alh != 0L && blh == 0L ? 0 : ((all = a.lo & Long.MAX_VALUE) < (bll = b.lo & Long.MAX_VALUE) ? 1 : 0));
            c.lo = cLo;
            c.hi = cHi -= (long)correction;
        }
    };
    private final Procedure3<UnsignedInt128Member, UnsignedInt128Member, UnsignedInt128Member> MUL = new Procedure3<UnsignedInt128Member, UnsignedInt128Member, UnsignedInt128Member>(){

        @Override
        public void call(UnsignedInt128Member a, UnsignedInt128Member b, UnsignedInt128Member c) {
            Multiply.compute(G.UINT128, a, b, c);
        }
    };
    private final Procedure3<java.lang.Integer, UnsignedInt128Member, UnsignedInt128Member> POWER = new Procedure3<java.lang.Integer, UnsignedInt128Member, UnsignedInt128Member>(){

        @Override
        public void call(java.lang.Integer power, UnsignedInt128Member a, UnsignedInt128Member b) {
            PowerNonNegative.compute(G.UINT128, power, a, b);
        }
    };
    private Procedure1<UnsignedInt128Member> UNITY = new Procedure1<UnsignedInt128Member>(){

        @Override
        public void call(UnsignedInt128Member a) {
            UnsignedInt128Algebra.this.assign().call(ONE, a);
        }
    };
    private final Function2<Boolean, UnsignedInt128Member, UnsignedInt128Member> LESS = new Function2<Boolean, UnsignedInt128Member, UnsignedInt128Member>(){

        @Override
        public Boolean call(UnsignedInt128Member a, UnsignedInt128Member b) {
            return UnsignedInt128Algebra.this.compare().call(a, b) < 0;
        }
    };
    private final Function2<Boolean, UnsignedInt128Member, UnsignedInt128Member> LE = new Function2<Boolean, UnsignedInt128Member, UnsignedInt128Member>(){

        @Override
        public Boolean call(UnsignedInt128Member a, UnsignedInt128Member b) {
            return UnsignedInt128Algebra.this.compare().call(a, b) <= 0;
        }
    };
    private final Function2<Boolean, UnsignedInt128Member, UnsignedInt128Member> GREAT = new Function2<Boolean, UnsignedInt128Member, UnsignedInt128Member>(){

        @Override
        public Boolean call(UnsignedInt128Member a, UnsignedInt128Member b) {
            return UnsignedInt128Algebra.this.compare().call(a, b) > 0;
        }
    };
    private final Function2<Boolean, UnsignedInt128Member, UnsignedInt128Member> GE = new Function2<Boolean, UnsignedInt128Member, UnsignedInt128Member>(){

        @Override
        public Boolean call(UnsignedInt128Member a, UnsignedInt128Member b) {
            return UnsignedInt128Algebra.this.compare().call(a, b) >= 0;
        }
    };
    private final Function2<java.lang.Integer, UnsignedInt128Member, UnsignedInt128Member> CMP = new Function2<java.lang.Integer, UnsignedInt128Member, UnsignedInt128Member>(){

        @Override
        public java.lang.Integer call(UnsignedInt128Member a, UnsignedInt128Member b) {
            long ab = a.hi & Long.MIN_VALUE;
            long bb = b.hi & Long.MIN_VALUE;
            if (ab == 0L && bb != 0L) {
                return -1;
            }
            if (ab != 0L && bb == 0L) {
                return 1;
            }
            long along = a.hi & Long.MAX_VALUE;
            long blong = b.hi & Long.MAX_VALUE;
            if (along < blong) {
                return -1;
            }
            if (along > blong) {
                return 1;
            }
            ab = a.lo & Long.MIN_VALUE;
            bb = b.lo & Long.MIN_VALUE;
            if (ab == 0L && bb != 0L) {
                return -1;
            }
            if (ab != 0L && bb == 0L) {
                return 1;
            }
            along = a.lo & Long.MAX_VALUE;
            blong = b.lo & Long.MAX_VALUE;
            if (along < blong) {
                return -1;
            }
            if (along > blong) {
                return 1;
            }
            return 0;
        }
    };
    private final Function1<java.lang.Integer, UnsignedInt128Member> SIG = new Function1<java.lang.Integer, UnsignedInt128Member>(){

        @Override
        public java.lang.Integer call(UnsignedInt128Member a) {
            if (UnsignedInt128Algebra.this.isEqual().call(a, ZERO).booleanValue()) {
                return 0;
            }
            return 1;
        }
    };
    private final Procedure3<UnsignedInt128Member, UnsignedInt128Member, UnsignedInt128Member> MIN = new Procedure3<UnsignedInt128Member, UnsignedInt128Member, UnsignedInt128Member>(){

        @Override
        public void call(UnsignedInt128Member a, UnsignedInt128Member b, UnsignedInt128Member c) {
            Min.compute(G.UINT128, a, b, c);
        }
    };
    private final Procedure3<UnsignedInt128Member, UnsignedInt128Member, UnsignedInt128Member> MAX = new Procedure3<UnsignedInt128Member, UnsignedInt128Member, UnsignedInt128Member>(){

        @Override
        public void call(UnsignedInt128Member a, UnsignedInt128Member b, UnsignedInt128Member c) {
            Max.compute(G.UINT128, a, b, c);
        }
    };
    private final Procedure3<UnsignedInt128Member, UnsignedInt128Member, UnsignedInt128Member> DIV = new Procedure3<UnsignedInt128Member, UnsignedInt128Member, UnsignedInt128Member>(){

        @Override
        public void call(UnsignedInt128Member a, UnsignedInt128Member b, UnsignedInt128Member d) {
            UnsignedInt128Member m = new UnsignedInt128Member();
            UnsignedInt128Algebra.this.divMod().call(a, b, d, m);
        }
    };
    private final Procedure3<UnsignedInt128Member, UnsignedInt128Member, UnsignedInt128Member> MOD = new Procedure3<UnsignedInt128Member, UnsignedInt128Member, UnsignedInt128Member>(){

        @Override
        public void call(UnsignedInt128Member a, UnsignedInt128Member b, UnsignedInt128Member m) {
            UnsignedInt128Member d = new UnsignedInt128Member();
            UnsignedInt128Algebra.this.divMod().call(a, b, d, m);
        }
    };
    private final Procedure4<UnsignedInt128Member, UnsignedInt128Member, UnsignedInt128Member, UnsignedInt128Member> DIVMOD = new Procedure4<UnsignedInt128Member, UnsignedInt128Member, UnsignedInt128Member, UnsignedInt128Member>(){

        @Override
        public void call(UnsignedInt128Member a, UnsignedInt128Member b, UnsignedInt128Member d, UnsignedInt128Member m) {
            DivMod.compute(G.UINT128, a, b, d, m);
        }
    };
    private final Procedure3<UnsignedInt128Member, UnsignedInt128Member, UnsignedInt128Member> GCD = new Procedure3<UnsignedInt128Member, UnsignedInt128Member, UnsignedInt128Member>(){

        @Override
        public void call(UnsignedInt128Member a, UnsignedInt128Member b, UnsignedInt128Member c) {
            Gcd.compute(G.UINT128, a, b, c);
        }
    };
    private final Procedure3<UnsignedInt128Member, UnsignedInt128Member, UnsignedInt128Member> LCM = new Procedure3<UnsignedInt128Member, UnsignedInt128Member, UnsignedInt128Member>(){

        @Override
        public void call(UnsignedInt128Member a, UnsignedInt128Member b, UnsignedInt128Member c) {
            Lcm.compute(G.UINT128, a, b, c);
        }
    };
    private final Function1<Boolean, UnsignedInt128Member> EVEN = new Function1<Boolean, UnsignedInt128Member>(){

        @Override
        public Boolean call(UnsignedInt128Member a) {
            return (a.lo & 1L) == 0L;
        }
    };
    private final Function1<Boolean, UnsignedInt128Member> ODD = new Function1<Boolean, UnsignedInt128Member>(){

        @Override
        public Boolean call(UnsignedInt128Member a) {
            return (a.lo & 1L) == 1L;
        }
    };
    private Procedure2<UnsignedInt128Member, UnsignedInt128Member> PRED = new Procedure2<UnsignedInt128Member, UnsignedInt128Member>(){

        @Override
        public void call(UnsignedInt128Member a, UnsignedInt128Member b) {
            UnsignedInt128Algebra.this.subtract().call(a, ONE, b);
        }
    };
    private Procedure2<UnsignedInt128Member, UnsignedInt128Member> SUCC = new Procedure2<UnsignedInt128Member, UnsignedInt128Member>(){

        @Override
        public void call(UnsignedInt128Member a, UnsignedInt128Member b) {
            UnsignedInt128Algebra.this.add().call(a, ONE, b);
        }
    };
    private final Procedure3<UnsignedInt128Member, UnsignedInt128Member, UnsignedInt128Member> POW = new Procedure3<UnsignedInt128Member, UnsignedInt128Member, UnsignedInt128Member>(){

        @Override
        public void call(UnsignedInt128Member a, UnsignedInt128Member b, UnsignedInt128Member c) {
            if (UnsignedInt128Algebra.this.signum().call(a) == 0 && UnsignedInt128Algebra.this.signum().call(b) == 0) {
                throw new IllegalArgumentException("0^0 is not a number");
            }
            UnsignedInt128Member tmp = new UnsignedInt128Member(ONE);
            UnsignedInt128Member pow = new UnsignedInt128Member(b);
            while (!UnsignedInt128Algebra.this.isEqual().call(pow, ZERO).booleanValue()) {
                UnsignedInt128Algebra.this.multiply().call(tmp, a, tmp);
                UnsignedInt128Algebra.this.pred().call(pow, pow);
            }
            UnsignedInt128Algebra.this.assign().call(tmp, c);
        }
    };
    private Procedure1<UnsignedInt128Member> RAND = new Procedure1<UnsignedInt128Member>(){

        @Override
        public void call(UnsignedInt128Member a) {
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            a.lo = rng.nextLong();
            a.hi = rng.nextLong();
        }
    };
    private final Procedure3<UnsignedInt128Member, UnsignedInt128Member, UnsignedInt128Member> BITAND = new Procedure3<UnsignedInt128Member, UnsignedInt128Member, UnsignedInt128Member>(){

        @Override
        public void call(UnsignedInt128Member a, UnsignedInt128Member b, UnsignedInt128Member c) {
            c.lo = a.lo & b.lo;
            c.hi = a.hi & b.hi;
        }
    };
    private final Procedure3<UnsignedInt128Member, UnsignedInt128Member, UnsignedInt128Member> BITOR = new Procedure3<UnsignedInt128Member, UnsignedInt128Member, UnsignedInt128Member>(){

        @Override
        public void call(UnsignedInt128Member a, UnsignedInt128Member b, UnsignedInt128Member c) {
            c.lo = a.lo | b.lo;
            c.hi = a.hi | b.hi;
        }
    };
    private final Procedure3<UnsignedInt128Member, UnsignedInt128Member, UnsignedInt128Member> BITXOR = new Procedure3<UnsignedInt128Member, UnsignedInt128Member, UnsignedInt128Member>(){

        @Override
        public void call(UnsignedInt128Member a, UnsignedInt128Member b, UnsignedInt128Member c) {
            c.lo = a.lo ^ b.lo;
            c.hi = a.hi ^ b.hi;
        }
    };
    private Procedure2<UnsignedInt128Member, UnsignedInt128Member> BITNOT = new Procedure2<UnsignedInt128Member, UnsignedInt128Member>(){

        @Override
        public void call(UnsignedInt128Member a, UnsignedInt128Member b) {
            b.lo = a.lo ^ 0xFFFFFFFFFFFFFFFFL;
            b.hi = a.hi ^ 0xFFFFFFFFFFFFFFFFL;
        }
    };
    private final Procedure3<UnsignedInt128Member, UnsignedInt128Member, UnsignedInt128Member> BITANDNOT = new Procedure3<UnsignedInt128Member, UnsignedInt128Member, UnsignedInt128Member>(){

        @Override
        public void call(UnsignedInt128Member a, UnsignedInt128Member b, UnsignedInt128Member c) {
            c.lo = a.lo & (b.lo ^ 0xFFFFFFFFFFFFFFFFL);
            c.hi = a.hi & (b.hi ^ 0xFFFFFFFFFFFFFFFFL);
        }
    };
    private final Procedure3<java.lang.Integer, UnsignedInt128Member, UnsignedInt128Member> BITSHL = new Procedure3<java.lang.Integer, UnsignedInt128Member, UnsignedInt128Member>(){

        @Override
        public void call(java.lang.Integer count, UnsignedInt128Member a, UnsignedInt128Member b) {
            if (count < 0) {
                UnsignedInt128Algebra.this.bitShiftRight().call(-count.intValue(), a, b);
            } else {
                count = count % 128;
                UnsignedInt128Member tmp = new UnsignedInt128Member(a);
                for (int i = 0; i < count; ++i) {
                    UnsignedInt128Algebra.this.shiftLeftOneBit(tmp);
                }
                UnsignedInt128Algebra.this.assign().call(tmp, b);
            }
        }
    };
    private final Procedure3<java.lang.Integer, UnsignedInt128Member, UnsignedInt128Member> BITSHRZ = new Procedure3<java.lang.Integer, UnsignedInt128Member, UnsignedInt128Member>(){

        @Override
        public void call(java.lang.Integer count, UnsignedInt128Member a, UnsignedInt128Member b) {
            if (count < 0) {
                UnsignedInt128Algebra.this.bitShiftLeft().call(-count.intValue(), a, b);
            } else if (count > 127) {
                UnsignedInt128Algebra.this.assign().call(ZERO, b);
            } else {
                UnsignedInt128Member tmp = new UnsignedInt128Member(a);
                for (int i = 0; i < count; ++i) {
                    UnsignedInt128Algebra.this.shiftRightOneBit(tmp);
                }
                UnsignedInt128Algebra.this.assign().call(tmp, b);
            }
        }
    };
    private Procedure1<UnsignedInt128Member> MAXBOUND = new Procedure1<UnsignedInt128Member>(){

        @Override
        public void call(UnsignedInt128Member a) {
            a.lo = -1L;
            a.hi = -1L;
        }
    };
    private Procedure1<UnsignedInt128Member> MINBOUND = new Procedure1<UnsignedInt128Member>(){

        @Override
        public void call(UnsignedInt128Member a) {
            a.lo = 0L;
            a.hi = 0L;
        }
    };
    private final Function1<Boolean, UnsignedInt128Member> ISZERO = new Function1<Boolean, UnsignedInt128Member>(){

        @Override
        public Boolean call(UnsignedInt128Member a) {
            return a.lo == 0L && a.hi == 0L;
        }
    };
    private final Procedure3<HighPrecisionMember, UnsignedInt128Member, UnsignedInt128Member> SBHP = new Procedure3<HighPrecisionMember, UnsignedInt128Member, UnsignedInt128Member>(){

        @Override
        public void call(HighPrecisionMember a, UnsignedInt128Member b, UnsignedInt128Member c) {
            BigDecimal tmp = a.v();
            tmp = tmp.multiply(new BigDecimal(b.v()));
            c.setV(tmp.toBigInteger());
        }
    };
    private final Procedure3<HighPrecisionMember, UnsignedInt128Member, UnsignedInt128Member> SBHPR = new Procedure3<HighPrecisionMember, UnsignedInt128Member, UnsignedInt128Member>(){

        @Override
        public void call(HighPrecisionMember a, UnsignedInt128Member b, UnsignedInt128Member c) {
            BigDecimal tmp = a.v();
            int signum = (tmp = tmp.multiply(new BigDecimal(b.v()))).signum();
            tmp = signum < 0 ? tmp.subtract(G.ONE_HALF) : tmp.add(G.ONE_HALF);
            c.setV(tmp.toBigInteger());
        }
    };
    private final Procedure3<RationalMember, UnsignedInt128Member, UnsignedInt128Member> SBR = new Procedure3<RationalMember, UnsignedInt128Member, UnsignedInt128Member>(){

        @Override
        public void call(RationalMember a, UnsignedInt128Member b, UnsignedInt128Member c) {
            BigInteger tmp = b.v();
            tmp = tmp.multiply(a.n());
            tmp = tmp.divide(a.d());
            c.setV(tmp);
        }
    };
    private final Procedure3<Double, UnsignedInt128Member, UnsignedInt128Member> SBD = new Procedure3<Double, UnsignedInt128Member, UnsignedInt128Member>(){

        @Override
        public void call(Double a, UnsignedInt128Member b, UnsignedInt128Member c) {
            BigDecimal tmp = new BigDecimal(b.v());
            tmp = tmp.multiply(BigDecimal.valueOf(a));
            c.setV(tmp.toBigInteger());
        }
    };
    private final Procedure3<Double, UnsignedInt128Member, UnsignedInt128Member> SBDR = new Procedure3<Double, UnsignedInt128Member, UnsignedInt128Member>(){

        @Override
        public void call(Double a, UnsignedInt128Member b, UnsignedInt128Member c) {
            BigDecimal tmp = new BigDecimal(b.v());
            int signum = (tmp = tmp.multiply(BigDecimal.valueOf(a))).signum();
            tmp = signum < 0 ? tmp.subtract(G.ONE_HALF) : tmp.add(G.ONE_HALF);
            c.setV(tmp.toBigInteger());
        }
    };
    private final Function3<Boolean, UnsignedInt128Member, UnsignedInt128Member, UnsignedInt128Member> WITHIN = new Function3<Boolean, UnsignedInt128Member, UnsignedInt128Member, UnsignedInt128Member>(){

        @Override
        public Boolean call(UnsignedInt128Member tol, UnsignedInt128Member a, UnsignedInt128Member b) {
            return NumberWithin.compute(G.UINT128, tol, a, b);
        }
    };

    @Override
    public UnsignedInt128Member construct() {
        return new UnsignedInt128Member();
    }

    @Override
    public UnsignedInt128Member construct(UnsignedInt128Member other) {
        return new UnsignedInt128Member(other);
    }

    @Override
    public UnsignedInt128Member construct(String str) {
        return new UnsignedInt128Member(str);
    }

    @Override
    public Function2<Boolean, UnsignedInt128Member, UnsignedInt128Member> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, UnsignedInt128Member, UnsignedInt128Member> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<UnsignedInt128Member, UnsignedInt128Member> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure1<UnsignedInt128Member> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<UnsignedInt128Member, UnsignedInt128Member> negate() {
        return this.ASSIGN;
    }

    @Override
    public Procedure3<UnsignedInt128Member, UnsignedInt128Member, UnsignedInt128Member> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<UnsignedInt128Member, UnsignedInt128Member, UnsignedInt128Member> subtract() {
        return this.SUB;
    }

    @Override
    public Procedure3<UnsignedInt128Member, UnsignedInt128Member, UnsignedInt128Member> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt128Member, UnsignedInt128Member> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<UnsignedInt128Member> unity() {
        return this.UNITY;
    }

    @Override
    public Function2<Boolean, UnsignedInt128Member, UnsignedInt128Member> isLess() {
        return this.LESS;
    }

    @Override
    public Function2<Boolean, UnsignedInt128Member, UnsignedInt128Member> isLessEqual() {
        return this.LE;
    }

    @Override
    public Function2<Boolean, UnsignedInt128Member, UnsignedInt128Member> isGreater() {
        return this.GREAT;
    }

    @Override
    public Function2<Boolean, UnsignedInt128Member, UnsignedInt128Member> isGreaterEqual() {
        return this.GE;
    }

    @Override
    public Function2<java.lang.Integer, UnsignedInt128Member, UnsignedInt128Member> compare() {
        return this.CMP;
    }

    @Override
    public Function1<java.lang.Integer, UnsignedInt128Member> signum() {
        return this.SIG;
    }

    @Override
    public final Procedure3<UnsignedInt128Member, UnsignedInt128Member, UnsignedInt128Member> min() {
        return this.MIN;
    }

    @Override
    public Procedure3<UnsignedInt128Member, UnsignedInt128Member, UnsignedInt128Member> max() {
        return this.MAX;
    }

    @Override
    public Procedure2<UnsignedInt128Member, UnsignedInt128Member> abs() {
        return this.ASSIGN;
    }

    @Override
    public Procedure2<UnsignedInt128Member, UnsignedInt128Member> norm() {
        return this.ASSIGN;
    }

    @Override
    public Procedure3<UnsignedInt128Member, UnsignedInt128Member, UnsignedInt128Member> div() {
        return this.DIV;
    }

    @Override
    public Procedure3<UnsignedInt128Member, UnsignedInt128Member, UnsignedInt128Member> mod() {
        return this.MOD;
    }

    @Override
    public Procedure4<UnsignedInt128Member, UnsignedInt128Member, UnsignedInt128Member, UnsignedInt128Member> divMod() {
        return this.DIVMOD;
    }

    @Override
    public Procedure3<UnsignedInt128Member, UnsignedInt128Member, UnsignedInt128Member> gcd() {
        return this.GCD;
    }

    @Override
    public Procedure3<UnsignedInt128Member, UnsignedInt128Member, UnsignedInt128Member> lcm() {
        return this.LCM;
    }

    @Override
    public Function1<Boolean, UnsignedInt128Member> isEven() {
        return this.EVEN;
    }

    @Override
    public Function1<Boolean, UnsignedInt128Member> isOdd() {
        return this.ODD;
    }

    @Override
    public Procedure2<UnsignedInt128Member, UnsignedInt128Member> pred() {
        return this.PRED;
    }

    @Override
    public Procedure2<UnsignedInt128Member, UnsignedInt128Member> succ() {
        return this.SUCC;
    }

    @Override
    public Procedure3<UnsignedInt128Member, UnsignedInt128Member, UnsignedInt128Member> pow() {
        return this.POW;
    }

    @Override
    public Procedure1<UnsignedInt128Member> random() {
        return this.RAND;
    }

    @Override
    public Procedure3<UnsignedInt128Member, UnsignedInt128Member, UnsignedInt128Member> bitAnd() {
        return this.BITAND;
    }

    @Override
    public Procedure3<UnsignedInt128Member, UnsignedInt128Member, UnsignedInt128Member> bitOr() {
        return this.BITOR;
    }

    @Override
    public Procedure3<UnsignedInt128Member, UnsignedInt128Member, UnsignedInt128Member> bitXor() {
        return this.BITXOR;
    }

    @Override
    public Procedure2<UnsignedInt128Member, UnsignedInt128Member> bitNot() {
        return this.BITNOT;
    }

    @Override
    public Procedure3<UnsignedInt128Member, UnsignedInt128Member, UnsignedInt128Member> bitAndNot() {
        return this.BITANDNOT;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt128Member, UnsignedInt128Member> bitShiftLeft() {
        return this.BITSHL;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt128Member, UnsignedInt128Member> bitShiftRight() {
        return this.BITSHRZ;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt128Member, UnsignedInt128Member> bitShiftRightFillZero() {
        return this.BITSHRZ;
    }

    @Override
    public Procedure1<UnsignedInt128Member> maxBound() {
        return this.MAXBOUND;
    }

    @Override
    public Procedure1<UnsignedInt128Member> minBound() {
        return this.MINBOUND;
    }

    @Override
    public Function1<Boolean, UnsignedInt128Member> isZero() {
        return this.ISZERO;
    }

    private void shiftLeftOneBit(UnsignedInt128Member val) {
        boolean transitionBit = (val.lo & Long.MIN_VALUE) != 0L;
        val.lo <<= 1;
        val.hi <<= 1;
        if (transitionBit) {
            val.hi |= 1L;
        }
    }

    private void shiftRightOneBit(UnsignedInt128Member val) {
        boolean transitionBit = (val.hi & 1L) != 0L;
        val.lo >>>= 1;
        val.hi >>>= 1;
        if (transitionBit) {
            val.lo |= Long.MIN_VALUE;
        }
    }

    @Override
    public Procedure3<UnsignedInt128Member, UnsignedInt128Member, UnsignedInt128Member> scale() {
        return this.MUL;
    }

    @Override
    public Procedure3<HighPrecisionMember, UnsignedInt128Member, UnsignedInt128Member> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<HighPrecisionMember, UnsignedInt128Member, UnsignedInt128Member> scaleByHighPrecAndRound() {
        return this.SBHPR;
    }

    @Override
    public Procedure3<RationalMember, UnsignedInt128Member, UnsignedInt128Member> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, UnsignedInt128Member, UnsignedInt128Member> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<Double, UnsignedInt128Member, UnsignedInt128Member> scaleByDoubleAndRound() {
        return this.SBDR;
    }

    @Override
    public Function3<Boolean, UnsignedInt128Member, UnsignedInt128Member, UnsignedInt128Member> within() {
        return this.WITHIN;
    }
}

