/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.int13;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.ThreadLocalRandom;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.Gcd;
import nom.bdezonia.zorbage.algorithm.Lcm;
import nom.bdezonia.zorbage.algorithm.NumberWithin;
import nom.bdezonia.zorbage.algorithm.PowerNonNegative;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.BitOperations;
import nom.bdezonia.zorbage.type.algebra.Bounded;
import nom.bdezonia.zorbage.type.algebra.Integer;
import nom.bdezonia.zorbage.type.algebra.Random;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.int13.SignedInt13Member;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class SignedInt13Algebra
implements Integer<SignedInt13Algebra, SignedInt13Member>,
Bounded<SignedInt13Member>,
BitOperations<SignedInt13Member>,
Random<SignedInt13Member>,
Tolerance<SignedInt13Member, SignedInt13Member> {
    private final Function2<Boolean, SignedInt13Member, SignedInt13Member> EQ = new Function2<Boolean, SignedInt13Member, SignedInt13Member>(){

        @Override
        public Boolean call(SignedInt13Member a, SignedInt13Member b) {
            return a.v == b.v;
        }
    };
    private final Function2<Boolean, SignedInt13Member, SignedInt13Member> NEQ = new Function2<Boolean, SignedInt13Member, SignedInt13Member>(){

        @Override
        public Boolean call(SignedInt13Member a, SignedInt13Member b) {
            return a.v != b.v;
        }
    };
    private final Procedure2<SignedInt13Member, SignedInt13Member> ASSIGN = new Procedure2<SignedInt13Member, SignedInt13Member>(){

        @Override
        public void call(SignedInt13Member a, SignedInt13Member b) {
            b.set(a);
        }
    };
    private final Procedure1<SignedInt13Member> ZER = new Procedure1<SignedInt13Member>(){

        @Override
        public void call(SignedInt13Member a) {
            a.v = 0;
        }
    };
    private final Procedure2<SignedInt13Member, SignedInt13Member> NEG = new Procedure2<SignedInt13Member, SignedInt13Member>(){

        @Override
        public void call(SignedInt13Member a, SignedInt13Member b) {
            if (a.v == -4096) {
                throw new IllegalArgumentException("Cannot convert -minint symmetrically");
            }
            b.v = -a.v;
        }
    };
    private final Procedure3<SignedInt13Member, SignedInt13Member, SignedInt13Member> ADD = new Procedure3<SignedInt13Member, SignedInt13Member, SignedInt13Member>(){

        @Override
        public void call(SignedInt13Member a, SignedInt13Member b, SignedInt13Member c) {
            c.setV(a.v + b.v);
        }
    };
    private final Procedure3<SignedInt13Member, SignedInt13Member, SignedInt13Member> SUB = new Procedure3<SignedInt13Member, SignedInt13Member, SignedInt13Member>(){

        @Override
        public void call(SignedInt13Member a, SignedInt13Member b, SignedInt13Member c) {
            c.setV(a.v - b.v);
        }
    };
    private final Procedure3<SignedInt13Member, SignedInt13Member, SignedInt13Member> MUL = new Procedure3<SignedInt13Member, SignedInt13Member, SignedInt13Member>(){

        @Override
        public void call(SignedInt13Member a, SignedInt13Member b, SignedInt13Member c) {
            c.setV(a.v * b.v);
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt13Member, SignedInt13Member> POWER = new Procedure3<java.lang.Integer, SignedInt13Member, SignedInt13Member>(){

        @Override
        public void call(java.lang.Integer power, SignedInt13Member a, SignedInt13Member b) {
            PowerNonNegative.compute(G.INT13, power, a, b);
        }
    };
    private final Procedure1<SignedInt13Member> UNITY = new Procedure1<SignedInt13Member>(){

        @Override
        public void call(SignedInt13Member a) {
            a.v = 1;
        }
    };
    private final Function2<Boolean, SignedInt13Member, SignedInt13Member> LESS = new Function2<Boolean, SignedInt13Member, SignedInt13Member>(){

        @Override
        public Boolean call(SignedInt13Member a, SignedInt13Member b) {
            return a.v < b.v;
        }
    };
    private final Function2<Boolean, SignedInt13Member, SignedInt13Member> LE = new Function2<Boolean, SignedInt13Member, SignedInt13Member>(){

        @Override
        public Boolean call(SignedInt13Member a, SignedInt13Member b) {
            return a.v <= b.v;
        }
    };
    private final Function2<Boolean, SignedInt13Member, SignedInt13Member> GREAT = new Function2<Boolean, SignedInt13Member, SignedInt13Member>(){

        @Override
        public Boolean call(SignedInt13Member a, SignedInt13Member b) {
            return a.v > b.v;
        }
    };
    private final Function2<Boolean, SignedInt13Member, SignedInt13Member> GE = new Function2<Boolean, SignedInt13Member, SignedInt13Member>(){

        @Override
        public Boolean call(SignedInt13Member a, SignedInt13Member b) {
            return a.v >= b.v;
        }
    };
    private final Function2<java.lang.Integer, SignedInt13Member, SignedInt13Member> CMP = new Function2<java.lang.Integer, SignedInt13Member, SignedInt13Member>(){

        @Override
        public java.lang.Integer call(SignedInt13Member a, SignedInt13Member b) {
            if (a.v < b.v) {
                return -1;
            }
            if (a.v > b.v) {
                return 1;
            }
            return 0;
        }
    };
    private final Function1<java.lang.Integer, SignedInt13Member> SIG = new Function1<java.lang.Integer, SignedInt13Member>(){

        @Override
        public java.lang.Integer call(SignedInt13Member a) {
            if (a.v < 0) {
                return -1;
            }
            if (a.v > 0) {
                return 1;
            }
            return 0;
        }
    };
    private final Procedure3<SignedInt13Member, SignedInt13Member, SignedInt13Member> MIN = new Procedure3<SignedInt13Member, SignedInt13Member, SignedInt13Member>(){

        @Override
        public void call(SignedInt13Member a, SignedInt13Member b, SignedInt13Member c) {
            if (a.v < b.v) {
                c.set(a);
            } else {
                c.set(b);
            }
        }
    };
    private final Procedure3<SignedInt13Member, SignedInt13Member, SignedInt13Member> MAX = new Procedure3<SignedInt13Member, SignedInt13Member, SignedInt13Member>(){

        @Override
        public void call(SignedInt13Member a, SignedInt13Member b, SignedInt13Member c) {
            if (a.v > b.v) {
                c.set(a);
            } else {
                c.set(b);
            }
        }
    };
    private final Procedure2<SignedInt13Member, SignedInt13Member> ABS = new Procedure2<SignedInt13Member, SignedInt13Member>(){

        @Override
        public void call(SignedInt13Member a, SignedInt13Member b) {
            if (a.v == -4096) {
                throw new IllegalArgumentException("Cannot convert -minint symmetrically");
            }
            b.v = a.v < 0 ? (short)(-a.v) : a.v;
        }
    };
    private final Procedure3<SignedInt13Member, SignedInt13Member, SignedInt13Member> GCD = new Procedure3<SignedInt13Member, SignedInt13Member, SignedInt13Member>(){

        @Override
        public void call(SignedInt13Member a, SignedInt13Member b, SignedInt13Member c) {
            Gcd.compute(G.INT13, a, b, c);
        }
    };
    private final Procedure3<SignedInt13Member, SignedInt13Member, SignedInt13Member> LCM = new Procedure3<SignedInt13Member, SignedInt13Member, SignedInt13Member>(){

        @Override
        public void call(SignedInt13Member a, SignedInt13Member b, SignedInt13Member c) {
            Lcm.compute(G.INT13, a, b, c);
        }
    };
    private final Function1<Boolean, SignedInt13Member> EVEN = new Function1<Boolean, SignedInt13Member>(){

        @Override
        public Boolean call(SignedInt13Member a) {
            return (a.v & 1) == 0;
        }
    };
    private final Function1<Boolean, SignedInt13Member> ODD = new Function1<Boolean, SignedInt13Member>(){

        @Override
        public Boolean call(SignedInt13Member a) {
            return (a.v & 1) == 1;
        }
    };
    private final Procedure3<SignedInt13Member, SignedInt13Member, SignedInt13Member> DIV = new Procedure3<SignedInt13Member, SignedInt13Member, SignedInt13Member>(){

        @Override
        public void call(SignedInt13Member a, SignedInt13Member b, SignedInt13Member d) {
            if (b.v == -1 && a.v == -4096) {
                throw new IllegalArgumentException("cannot divide minint by -1");
            }
            d.setV(a.v / b.v);
        }
    };
    private final Procedure3<SignedInt13Member, SignedInt13Member, SignedInt13Member> MOD = new Procedure3<SignedInt13Member, SignedInt13Member, SignedInt13Member>(){

        @Override
        public void call(SignedInt13Member a, SignedInt13Member b, SignedInt13Member m) {
            m.setV(a.v % b.v);
        }
    };
    private final Procedure4<SignedInt13Member, SignedInt13Member, SignedInt13Member, SignedInt13Member> DIVMOD = new Procedure4<SignedInt13Member, SignedInt13Member, SignedInt13Member, SignedInt13Member>(){

        @Override
        public void call(SignedInt13Member a, SignedInt13Member b, SignedInt13Member d, SignedInt13Member m) {
            SignedInt13Algebra.this.div().call(a, b, d);
            SignedInt13Algebra.this.mod().call(a, b, m);
        }
    };
    private final Procedure2<SignedInt13Member, SignedInt13Member> PRED = new Procedure2<SignedInt13Member, SignedInt13Member>(){

        @Override
        public void call(SignedInt13Member a, SignedInt13Member b) {
            if (a.v == -4096) {
                b.v = (short)4095;
            } else {
                b.setV(a.v - 1);
            }
        }
    };
    private final Procedure2<SignedInt13Member, SignedInt13Member> SUCC = new Procedure2<SignedInt13Member, SignedInt13Member>(){

        @Override
        public void call(SignedInt13Member a, SignedInt13Member b) {
            if (a.v == 4095) {
                b.v = (short)-4096;
            } else {
                b.setV(a.v + 1);
            }
        }
    };
    private final Procedure3<SignedInt13Member, SignedInt13Member, SignedInt13Member> POW = new Procedure3<SignedInt13Member, SignedInt13Member, SignedInt13Member>(){

        @Override
        public void call(SignedInt13Member a, SignedInt13Member b, SignedInt13Member c) {
            PowerNonNegative.compute(G.INT13, b.v, a, c);
        }
    };
    private final Procedure1<SignedInt13Member> RAND = new Procedure1<SignedInt13Member>(){

        @Override
        public void call(SignedInt13Member a) {
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            a.setV(rng.nextInt(8192) - 4096);
        }
    };
    private final Procedure3<SignedInt13Member, SignedInt13Member, SignedInt13Member> AND = new Procedure3<SignedInt13Member, SignedInt13Member, SignedInt13Member>(){

        @Override
        public void call(SignedInt13Member a, SignedInt13Member b, SignedInt13Member c) {
            c.setV(a.v & b.v);
        }
    };
    private final Procedure3<SignedInt13Member, SignedInt13Member, SignedInt13Member> OR = new Procedure3<SignedInt13Member, SignedInt13Member, SignedInt13Member>(){

        @Override
        public void call(SignedInt13Member a, SignedInt13Member b, SignedInt13Member c) {
            c.setV(a.v | b.v);
        }
    };
    private final Procedure3<SignedInt13Member, SignedInt13Member, SignedInt13Member> XOR = new Procedure3<SignedInt13Member, SignedInt13Member, SignedInt13Member>(){

        @Override
        public void call(SignedInt13Member a, SignedInt13Member b, SignedInt13Member c) {
            c.setV(a.v ^ b.v);
        }
    };
    private final Procedure2<SignedInt13Member, SignedInt13Member> NOT = new Procedure2<SignedInt13Member, SignedInt13Member>(){

        @Override
        public void call(SignedInt13Member a, SignedInt13Member b) {
            b.setV(~a.v);
        }
    };
    private final Procedure3<SignedInt13Member, SignedInt13Member, SignedInt13Member> ANDNOT = new Procedure3<SignedInt13Member, SignedInt13Member, SignedInt13Member>(){

        @Override
        public void call(SignedInt13Member a, SignedInt13Member b, SignedInt13Member c) {
            c.setV(a.v & ~b.v);
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt13Member, SignedInt13Member> SHL = new Procedure3<java.lang.Integer, SignedInt13Member, SignedInt13Member>(){

        @Override
        public void call(java.lang.Integer count, SignedInt13Member a, SignedInt13Member b) {
            if (count < 0) {
                SignedInt13Algebra.this.bitShiftRight().call(-count.intValue(), a, b);
            } else {
                count = count % 13;
                b.setV(a.v << count);
            }
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt13Member, SignedInt13Member> SHR = new Procedure3<java.lang.Integer, SignedInt13Member, SignedInt13Member>(){

        @Override
        public void call(java.lang.Integer count, SignedInt13Member a, SignedInt13Member b) {
            if (count < 0) {
                SignedInt13Algebra.this.bitShiftLeft().call(-count.intValue(), a, b);
            } else {
                int val = a.v >> count;
                if (a.v < 0 && val == 0) {
                    b.v = (short)-1;
                } else {
                    b.setV(val);
                }
            }
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt13Member, SignedInt13Member> SHRZ = new Procedure3<java.lang.Integer, SignedInt13Member, SignedInt13Member>(){

        @Override
        public void call(java.lang.Integer count, SignedInt13Member a, SignedInt13Member b) {
            if (count < 0) {
                SignedInt13Algebra.this.bitShiftLeft().call(-count.intValue(), a, b);
            } else {
                b.setV(a.v >>> count);
            }
        }
    };
    private final Procedure1<SignedInt13Member> MAXBOUND = new Procedure1<SignedInt13Member>(){

        @Override
        public void call(SignedInt13Member a) {
            a.v = (short)4095;
        }
    };
    private final Procedure1<SignedInt13Member> MINBOUND = new Procedure1<SignedInt13Member>(){

        @Override
        public void call(SignedInt13Member a) {
            a.v = (short)-4096;
        }
    };
    private final Function1<Boolean, SignedInt13Member> ISZERO = new Function1<Boolean, SignedInt13Member>(){

        @Override
        public Boolean call(SignedInt13Member a) {
            return a.v == 0;
        }
    };
    private final Procedure3<HighPrecisionMember, SignedInt13Member, SignedInt13Member> SBHP = new Procedure3<HighPrecisionMember, SignedInt13Member, SignedInt13Member>(){

        @Override
        public void call(HighPrecisionMember a, SignedInt13Member b, SignedInt13Member c) {
            BigDecimal tmp = a.v();
            tmp = tmp.multiply(new BigDecimal(b.v()));
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<HighPrecisionMember, SignedInt13Member, SignedInt13Member> SBHPR = new Procedure3<HighPrecisionMember, SignedInt13Member, SignedInt13Member>(){

        @Override
        public void call(HighPrecisionMember a, SignedInt13Member b, SignedInt13Member c) {
            BigDecimal tmp = a.v();
            int signum = (tmp = tmp.multiply(new BigDecimal(b.v()))).signum();
            tmp = signum < 0 ? tmp.subtract(G.ONE_HALF) : tmp.add(G.ONE_HALF);
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<RationalMember, SignedInt13Member, SignedInt13Member> SBR = new Procedure3<RationalMember, SignedInt13Member, SignedInt13Member>(){

        @Override
        public void call(RationalMember a, SignedInt13Member b, SignedInt13Member c) {
            BigInteger tmp = BigInteger.valueOf(b.v());
            tmp = tmp.multiply(a.n());
            tmp = tmp.divide(a.d());
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<Double, SignedInt13Member, SignedInt13Member> SBD = new Procedure3<Double, SignedInt13Member, SignedInt13Member>(){

        @Override
        public void call(Double a, SignedInt13Member b, SignedInt13Member c) {
            c.setV((int)(a * (double)b.v()));
        }
    };
    private final Procedure3<Double, SignedInt13Member, SignedInt13Member> SBDR = new Procedure3<Double, SignedInt13Member, SignedInt13Member>(){

        @Override
        public void call(Double a, SignedInt13Member b, SignedInt13Member c) {
            c.setV((int)Math.round(a * (double)b.v()));
        }
    };
    private final Function3<Boolean, SignedInt13Member, SignedInt13Member, SignedInt13Member> WITHIN = new Function3<Boolean, SignedInt13Member, SignedInt13Member, SignedInt13Member>(){

        @Override
        public Boolean call(SignedInt13Member tol, SignedInt13Member a, SignedInt13Member b) {
            return NumberWithin.compute(G.INT13, tol, a, b);
        }
    };

    @Override
    public SignedInt13Member construct() {
        return new SignedInt13Member();
    }

    @Override
    public SignedInt13Member construct(SignedInt13Member other) {
        return new SignedInt13Member(other);
    }

    @Override
    public SignedInt13Member construct(String str) {
        return new SignedInt13Member(str);
    }

    @Override
    public Function2<Boolean, SignedInt13Member, SignedInt13Member> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, SignedInt13Member, SignedInt13Member> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<SignedInt13Member, SignedInt13Member> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure1<SignedInt13Member> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<SignedInt13Member, SignedInt13Member> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<SignedInt13Member, SignedInt13Member, SignedInt13Member> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<SignedInt13Member, SignedInt13Member, SignedInt13Member> subtract() {
        return this.SUB;
    }

    @Override
    public Procedure3<SignedInt13Member, SignedInt13Member, SignedInt13Member> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt13Member, SignedInt13Member> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<SignedInt13Member> unity() {
        return this.UNITY;
    }

    @Override
    public Function2<Boolean, SignedInt13Member, SignedInt13Member> isLess() {
        return this.LESS;
    }

    @Override
    public Function2<Boolean, SignedInt13Member, SignedInt13Member> isLessEqual() {
        return this.LE;
    }

    @Override
    public Function2<Boolean, SignedInt13Member, SignedInt13Member> isGreater() {
        return this.GREAT;
    }

    @Override
    public Function2<Boolean, SignedInt13Member, SignedInt13Member> isGreaterEqual() {
        return this.GE;
    }

    @Override
    public Function2<java.lang.Integer, SignedInt13Member, SignedInt13Member> compare() {
        return this.CMP;
    }

    @Override
    public Function1<java.lang.Integer, SignedInt13Member> signum() {
        return this.SIG;
    }

    @Override
    public Procedure3<SignedInt13Member, SignedInt13Member, SignedInt13Member> min() {
        return this.MIN;
    }

    @Override
    public Procedure3<SignedInt13Member, SignedInt13Member, SignedInt13Member> max() {
        return this.MAX;
    }

    @Override
    public Procedure2<SignedInt13Member, SignedInt13Member> abs() {
        return this.ABS;
    }

    @Override
    public Procedure2<SignedInt13Member, SignedInt13Member> norm() {
        return this.ABS;
    }

    @Override
    public Procedure3<SignedInt13Member, SignedInt13Member, SignedInt13Member> gcd() {
        return this.GCD;
    }

    @Override
    public Procedure3<SignedInt13Member, SignedInt13Member, SignedInt13Member> lcm() {
        return this.LCM;
    }

    @Override
    public Function1<Boolean, SignedInt13Member> isEven() {
        return this.EVEN;
    }

    @Override
    public Function1<Boolean, SignedInt13Member> isOdd() {
        return this.ODD;
    }

    @Override
    public Procedure3<SignedInt13Member, SignedInt13Member, SignedInt13Member> div() {
        return this.DIV;
    }

    @Override
    public Procedure3<SignedInt13Member, SignedInt13Member, SignedInt13Member> mod() {
        return this.MOD;
    }

    @Override
    public Procedure4<SignedInt13Member, SignedInt13Member, SignedInt13Member, SignedInt13Member> divMod() {
        return this.DIVMOD;
    }

    @Override
    public Procedure2<SignedInt13Member, SignedInt13Member> pred() {
        return this.PRED;
    }

    @Override
    public Procedure2<SignedInt13Member, SignedInt13Member> succ() {
        return this.SUCC;
    }

    @Override
    public Procedure3<SignedInt13Member, SignedInt13Member, SignedInt13Member> pow() {
        return this.POW;
    }

    @Override
    public Procedure1<SignedInt13Member> random() {
        return this.RAND;
    }

    @Override
    public Procedure3<SignedInt13Member, SignedInt13Member, SignedInt13Member> bitAnd() {
        return this.AND;
    }

    @Override
    public Procedure3<SignedInt13Member, SignedInt13Member, SignedInt13Member> bitOr() {
        return this.OR;
    }

    @Override
    public Procedure3<SignedInt13Member, SignedInt13Member, SignedInt13Member> bitXor() {
        return this.XOR;
    }

    @Override
    public Procedure2<SignedInt13Member, SignedInt13Member> bitNot() {
        return this.NOT;
    }

    @Override
    public Procedure3<SignedInt13Member, SignedInt13Member, SignedInt13Member> bitAndNot() {
        return this.ANDNOT;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt13Member, SignedInt13Member> bitShiftLeft() {
        return this.SHL;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt13Member, SignedInt13Member> bitShiftRight() {
        return this.SHR;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt13Member, SignedInt13Member> bitShiftRightFillZero() {
        return this.SHRZ;
    }

    @Override
    public Procedure1<SignedInt13Member> maxBound() {
        return this.MAXBOUND;
    }

    @Override
    public Procedure1<SignedInt13Member> minBound() {
        return this.MINBOUND;
    }

    @Override
    public Function1<Boolean, SignedInt13Member> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<SignedInt13Member, SignedInt13Member, SignedInt13Member> scale() {
        return this.MUL;
    }

    @Override
    public Procedure3<HighPrecisionMember, SignedInt13Member, SignedInt13Member> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<HighPrecisionMember, SignedInt13Member, SignedInt13Member> scaleByHighPrecAndRound() {
        return this.SBHPR;
    }

    @Override
    public Procedure3<RationalMember, SignedInt13Member, SignedInt13Member> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, SignedInt13Member, SignedInt13Member> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<Double, SignedInt13Member, SignedInt13Member> scaleByDoubleAndRound() {
        return this.SBDR;
    }

    @Override
    public Function3<Boolean, SignedInt13Member, SignedInt13Member, SignedInt13Member> within() {
        return this.WITHIN;
    }
}

