/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.int13;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.ThreadLocalRandom;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.Gcd;
import nom.bdezonia.zorbage.algorithm.Lcm;
import nom.bdezonia.zorbage.algorithm.NumberWithin;
import nom.bdezonia.zorbage.algorithm.PowerNonNegative;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.BitOperations;
import nom.bdezonia.zorbage.type.algebra.Bounded;
import nom.bdezonia.zorbage.type.algebra.Integer;
import nom.bdezonia.zorbage.type.algebra.Random;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.int13.UnsignedInt13Member;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class UnsignedInt13Algebra
implements Integer<UnsignedInt13Algebra, UnsignedInt13Member>,
Bounded<UnsignedInt13Member>,
BitOperations<UnsignedInt13Member>,
Random<UnsignedInt13Member>,
Tolerance<UnsignedInt13Member, UnsignedInt13Member> {
    private final Function2<Boolean, UnsignedInt13Member, UnsignedInt13Member> EQ = new Function2<Boolean, UnsignedInt13Member, UnsignedInt13Member>(){

        @Override
        public Boolean call(UnsignedInt13Member a, UnsignedInt13Member b) {
            return a.v == b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt13Member, UnsignedInt13Member> NEQ = new Function2<Boolean, UnsignedInt13Member, UnsignedInt13Member>(){

        @Override
        public Boolean call(UnsignedInt13Member a, UnsignedInt13Member b) {
            return a.v != b.v;
        }
    };
    private final Procedure2<UnsignedInt13Member, UnsignedInt13Member> ASSIGN = new Procedure2<UnsignedInt13Member, UnsignedInt13Member>(){

        @Override
        public void call(UnsignedInt13Member a, UnsignedInt13Member b) {
            b.set(a);
        }
    };
    private final Procedure1<UnsignedInt13Member> ZER = new Procedure1<UnsignedInt13Member>(){

        @Override
        public void call(UnsignedInt13Member a) {
            a.v = 0;
        }
    };
    private final Procedure3<UnsignedInt13Member, UnsignedInt13Member, UnsignedInt13Member> ADD = new Procedure3<UnsignedInt13Member, UnsignedInt13Member, UnsignedInt13Member>(){

        @Override
        public void call(UnsignedInt13Member a, UnsignedInt13Member b, UnsignedInt13Member c) {
            c.setV(a.v + b.v);
        }
    };
    private final Procedure3<UnsignedInt13Member, UnsignedInt13Member, UnsignedInt13Member> SUB = new Procedure3<UnsignedInt13Member, UnsignedInt13Member, UnsignedInt13Member>(){

        @Override
        public void call(UnsignedInt13Member a, UnsignedInt13Member b, UnsignedInt13Member c) {
            c.setV(a.v - b.v);
        }
    };
    private final Procedure3<UnsignedInt13Member, UnsignedInt13Member, UnsignedInt13Member> MUL = new Procedure3<UnsignedInt13Member, UnsignedInt13Member, UnsignedInt13Member>(){

        @Override
        public void call(UnsignedInt13Member a, UnsignedInt13Member b, UnsignedInt13Member c) {
            c.setV(a.v * b.v);
        }
    };
    private final Procedure3<java.lang.Integer, UnsignedInt13Member, UnsignedInt13Member> POWER = new Procedure3<java.lang.Integer, UnsignedInt13Member, UnsignedInt13Member>(){

        @Override
        public void call(java.lang.Integer power, UnsignedInt13Member a, UnsignedInt13Member b) {
            PowerNonNegative.compute(G.UINT13, power, a, b);
        }
    };
    private final Procedure1<UnsignedInt13Member> UNITY = new Procedure1<UnsignedInt13Member>(){

        @Override
        public void call(UnsignedInt13Member a) {
            a.v = 1;
        }
    };
    private final Function2<Boolean, UnsignedInt13Member, UnsignedInt13Member> LESS = new Function2<Boolean, UnsignedInt13Member, UnsignedInt13Member>(){

        @Override
        public Boolean call(UnsignedInt13Member a, UnsignedInt13Member b) {
            return a.v < b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt13Member, UnsignedInt13Member> LE = new Function2<Boolean, UnsignedInt13Member, UnsignedInt13Member>(){

        @Override
        public Boolean call(UnsignedInt13Member a, UnsignedInt13Member b) {
            return a.v <= b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt13Member, UnsignedInt13Member> GREAT = new Function2<Boolean, UnsignedInt13Member, UnsignedInt13Member>(){

        @Override
        public Boolean call(UnsignedInt13Member a, UnsignedInt13Member b) {
            return a.v > b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt13Member, UnsignedInt13Member> GE = new Function2<Boolean, UnsignedInt13Member, UnsignedInt13Member>(){

        @Override
        public Boolean call(UnsignedInt13Member a, UnsignedInt13Member b) {
            return a.v >= b.v;
        }
    };
    private final Function2<java.lang.Integer, UnsignedInt13Member, UnsignedInt13Member> CMP = new Function2<java.lang.Integer, UnsignedInt13Member, UnsignedInt13Member>(){

        @Override
        public java.lang.Integer call(UnsignedInt13Member a, UnsignedInt13Member b) {
            if (a.v < b.v) {
                return -1;
            }
            if (a.v > b.v) {
                return 1;
            }
            return 0;
        }
    };
    private final Function1<java.lang.Integer, UnsignedInt13Member> SIG = new Function1<java.lang.Integer, UnsignedInt13Member>(){

        @Override
        public java.lang.Integer call(UnsignedInt13Member a) {
            if (a.v < 0) {
                return -1;
            }
            if (a.v > 0) {
                return 1;
            }
            return 0;
        }
    };
    private final Procedure3<UnsignedInt13Member, UnsignedInt13Member, UnsignedInt13Member> MIN = new Procedure3<UnsignedInt13Member, UnsignedInt13Member, UnsignedInt13Member>(){

        @Override
        public void call(UnsignedInt13Member a, UnsignedInt13Member b, UnsignedInt13Member c) {
            if (a.v < b.v) {
                c.set(a);
            } else {
                c.set(b);
            }
        }
    };
    private final Procedure3<UnsignedInt13Member, UnsignedInt13Member, UnsignedInt13Member> MAX = new Procedure3<UnsignedInt13Member, UnsignedInt13Member, UnsignedInt13Member>(){

        @Override
        public void call(UnsignedInt13Member a, UnsignedInt13Member b, UnsignedInt13Member c) {
            if (a.v > b.v) {
                c.set(a);
            } else {
                c.set(b);
            }
        }
    };
    private final Procedure3<UnsignedInt13Member, UnsignedInt13Member, UnsignedInt13Member> GCD = new Procedure3<UnsignedInt13Member, UnsignedInt13Member, UnsignedInt13Member>(){

        @Override
        public void call(UnsignedInt13Member a, UnsignedInt13Member b, UnsignedInt13Member c) {
            Gcd.compute(G.UINT13, a, b, c);
        }
    };
    private final Procedure3<UnsignedInt13Member, UnsignedInt13Member, UnsignedInt13Member> LCM = new Procedure3<UnsignedInt13Member, UnsignedInt13Member, UnsignedInt13Member>(){

        @Override
        public void call(UnsignedInt13Member a, UnsignedInt13Member b, UnsignedInt13Member c) {
            Lcm.compute(G.UINT13, a, b, c);
        }
    };
    private final Function1<Boolean, UnsignedInt13Member> EVEN = new Function1<Boolean, UnsignedInt13Member>(){

        @Override
        public Boolean call(UnsignedInt13Member a) {
            return (a.v & 1) == 0;
        }
    };
    private final Function1<Boolean, UnsignedInt13Member> ODD = new Function1<Boolean, UnsignedInt13Member>(){

        @Override
        public Boolean call(UnsignedInt13Member a) {
            return (a.v & 1) == 1;
        }
    };
    private final Procedure3<UnsignedInt13Member, UnsignedInt13Member, UnsignedInt13Member> DIV = new Procedure3<UnsignedInt13Member, UnsignedInt13Member, UnsignedInt13Member>(){

        @Override
        public void call(UnsignedInt13Member a, UnsignedInt13Member b, UnsignedInt13Member d) {
            d.setV(a.v / b.v);
        }
    };
    private final Procedure3<UnsignedInt13Member, UnsignedInt13Member, UnsignedInt13Member> MOD = new Procedure3<UnsignedInt13Member, UnsignedInt13Member, UnsignedInt13Member>(){

        @Override
        public void call(UnsignedInt13Member a, UnsignedInt13Member b, UnsignedInt13Member m) {
            m.setV(a.v % b.v);
        }
    };
    private final Procedure4<UnsignedInt13Member, UnsignedInt13Member, UnsignedInt13Member, UnsignedInt13Member> DIVMOD = new Procedure4<UnsignedInt13Member, UnsignedInt13Member, UnsignedInt13Member, UnsignedInt13Member>(){

        @Override
        public void call(UnsignedInt13Member a, UnsignedInt13Member b, UnsignedInt13Member d, UnsignedInt13Member m) {
            UnsignedInt13Algebra.this.div().call(a, b, d);
            UnsignedInt13Algebra.this.mod().call(a, b, m);
        }
    };
    private final Procedure2<UnsignedInt13Member, UnsignedInt13Member> PRED = new Procedure2<UnsignedInt13Member, UnsignedInt13Member>(){

        @Override
        public void call(UnsignedInt13Member a, UnsignedInt13Member b) {
            if (a.v == 0) {
                b.v = (short)8191;
            } else {
                b.setV(a.v - 1);
            }
        }
    };
    private final Procedure2<UnsignedInt13Member, UnsignedInt13Member> SUCC = new Procedure2<UnsignedInt13Member, UnsignedInt13Member>(){

        @Override
        public void call(UnsignedInt13Member a, UnsignedInt13Member b) {
            if (a.v == 8191) {
                b.v = 0;
            } else {
                b.setV(a.v + 1);
            }
        }
    };
    private final Procedure3<UnsignedInt13Member, UnsignedInt13Member, UnsignedInt13Member> POW = new Procedure3<UnsignedInt13Member, UnsignedInt13Member, UnsignedInt13Member>(){

        @Override
        public void call(UnsignedInt13Member a, UnsignedInt13Member b, UnsignedInt13Member c) {
            PowerNonNegative.compute(G.UINT13, b.v, a, c);
        }
    };
    private final Procedure1<UnsignedInt13Member> RAND = new Procedure1<UnsignedInt13Member>(){

        @Override
        public void call(UnsignedInt13Member a) {
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            a.setV(rng.nextInt(8192));
        }
    };
    private final Procedure3<UnsignedInt13Member, UnsignedInt13Member, UnsignedInt13Member> AND = new Procedure3<UnsignedInt13Member, UnsignedInt13Member, UnsignedInt13Member>(){

        @Override
        public void call(UnsignedInt13Member a, UnsignedInt13Member b, UnsignedInt13Member c) {
            c.setV(a.v & b.v);
        }
    };
    private final Procedure3<UnsignedInt13Member, UnsignedInt13Member, UnsignedInt13Member> OR = new Procedure3<UnsignedInt13Member, UnsignedInt13Member, UnsignedInt13Member>(){

        @Override
        public void call(UnsignedInt13Member a, UnsignedInt13Member b, UnsignedInt13Member c) {
            c.setV(a.v | b.v);
        }
    };
    private final Procedure3<UnsignedInt13Member, UnsignedInt13Member, UnsignedInt13Member> XOR = new Procedure3<UnsignedInt13Member, UnsignedInt13Member, UnsignedInt13Member>(){

        @Override
        public void call(UnsignedInt13Member a, UnsignedInt13Member b, UnsignedInt13Member c) {
            c.setV(a.v ^ b.v);
        }
    };
    private final Procedure2<UnsignedInt13Member, UnsignedInt13Member> NOT = new Procedure2<UnsignedInt13Member, UnsignedInt13Member>(){

        @Override
        public void call(UnsignedInt13Member a, UnsignedInt13Member b) {
            b.setV(~a.v);
        }
    };
    private final Procedure3<UnsignedInt13Member, UnsignedInt13Member, UnsignedInt13Member> ANDNOT = new Procedure3<UnsignedInt13Member, UnsignedInt13Member, UnsignedInt13Member>(){

        @Override
        public void call(UnsignedInt13Member a, UnsignedInt13Member b, UnsignedInt13Member c) {
            c.setV(a.v & ~b.v);
        }
    };
    private final Procedure3<java.lang.Integer, UnsignedInt13Member, UnsignedInt13Member> SHL = new Procedure3<java.lang.Integer, UnsignedInt13Member, UnsignedInt13Member>(){

        @Override
        public void call(java.lang.Integer count, UnsignedInt13Member a, UnsignedInt13Member b) {
            if (count < 0) {
                UnsignedInt13Algebra.this.bitShiftRight().call(-count.intValue(), a, b);
            } else {
                count = count % 13;
                b.setV(a.v << count);
            }
        }
    };
    private final Procedure3<java.lang.Integer, UnsignedInt13Member, UnsignedInt13Member> SHRZ = new Procedure3<java.lang.Integer, UnsignedInt13Member, UnsignedInt13Member>(){

        @Override
        public void call(java.lang.Integer count, UnsignedInt13Member a, UnsignedInt13Member b) {
            if (count < 0) {
                UnsignedInt13Algebra.this.bitShiftLeft().call(-count.intValue(), a, b);
            } else {
                b.setV(a.v >>> count);
            }
        }
    };
    private final Procedure1<UnsignedInt13Member> MAXBOUND = new Procedure1<UnsignedInt13Member>(){

        @Override
        public void call(UnsignedInt13Member a) {
            a.v = (short)8191;
        }
    };
    private final Procedure1<UnsignedInt13Member> MINBOUND = new Procedure1<UnsignedInt13Member>(){

        @Override
        public void call(UnsignedInt13Member a) {
            a.v = 0;
        }
    };
    private final Function1<Boolean, UnsignedInt13Member> ISZERO = new Function1<Boolean, UnsignedInt13Member>(){

        @Override
        public Boolean call(UnsignedInt13Member a) {
            return a.v == 0;
        }
    };
    private final Procedure3<HighPrecisionMember, UnsignedInt13Member, UnsignedInt13Member> SBHP = new Procedure3<HighPrecisionMember, UnsignedInt13Member, UnsignedInt13Member>(){

        @Override
        public void call(HighPrecisionMember a, UnsignedInt13Member b, UnsignedInt13Member c) {
            BigDecimal tmp = a.v();
            tmp = tmp.multiply(new BigDecimal(b.v()));
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<HighPrecisionMember, UnsignedInt13Member, UnsignedInt13Member> SBHPR = new Procedure3<HighPrecisionMember, UnsignedInt13Member, UnsignedInt13Member>(){

        @Override
        public void call(HighPrecisionMember a, UnsignedInt13Member b, UnsignedInt13Member c) {
            BigDecimal tmp = a.v();
            int signum = (tmp = tmp.multiply(new BigDecimal(b.v()))).signum();
            tmp = signum < 0 ? tmp.subtract(G.ONE_HALF) : tmp.add(G.ONE_HALF);
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<RationalMember, UnsignedInt13Member, UnsignedInt13Member> SBR = new Procedure3<RationalMember, UnsignedInt13Member, UnsignedInt13Member>(){

        @Override
        public void call(RationalMember a, UnsignedInt13Member b, UnsignedInt13Member c) {
            BigInteger tmp = BigInteger.valueOf(b.v());
            tmp = tmp.multiply(a.n());
            tmp = tmp.divide(a.d());
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<Double, UnsignedInt13Member, UnsignedInt13Member> SBD = new Procedure3<Double, UnsignedInt13Member, UnsignedInt13Member>(){

        @Override
        public void call(Double a, UnsignedInt13Member b, UnsignedInt13Member c) {
            c.setV((int)(a * (double)b.v()));
        }
    };
    private final Procedure3<Double, UnsignedInt13Member, UnsignedInt13Member> SBDR = new Procedure3<Double, UnsignedInt13Member, UnsignedInt13Member>(){

        @Override
        public void call(Double a, UnsignedInt13Member b, UnsignedInt13Member c) {
            c.setV((int)Math.round(a * (double)b.v()));
        }
    };
    private final Function3<Boolean, UnsignedInt13Member, UnsignedInt13Member, UnsignedInt13Member> WITHIN = new Function3<Boolean, UnsignedInt13Member, UnsignedInt13Member, UnsignedInt13Member>(){

        @Override
        public Boolean call(UnsignedInt13Member tol, UnsignedInt13Member a, UnsignedInt13Member b) {
            return NumberWithin.compute(G.UINT13, tol, a, b);
        }
    };

    @Override
    public UnsignedInt13Member construct() {
        return new UnsignedInt13Member();
    }

    @Override
    public UnsignedInt13Member construct(UnsignedInt13Member other) {
        return new UnsignedInt13Member(other);
    }

    @Override
    public UnsignedInt13Member construct(String str) {
        return new UnsignedInt13Member(str);
    }

    @Override
    public Function2<Boolean, UnsignedInt13Member, UnsignedInt13Member> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, UnsignedInt13Member, UnsignedInt13Member> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<UnsignedInt13Member, UnsignedInt13Member> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure1<UnsignedInt13Member> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<UnsignedInt13Member, UnsignedInt13Member> negate() {
        return this.ASSIGN;
    }

    @Override
    public Procedure3<UnsignedInt13Member, UnsignedInt13Member, UnsignedInt13Member> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<UnsignedInt13Member, UnsignedInt13Member, UnsignedInt13Member> subtract() {
        return this.SUB;
    }

    @Override
    public Procedure3<UnsignedInt13Member, UnsignedInt13Member, UnsignedInt13Member> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt13Member, UnsignedInt13Member> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<UnsignedInt13Member> unity() {
        return this.UNITY;
    }

    @Override
    public Function2<Boolean, UnsignedInt13Member, UnsignedInt13Member> isLess() {
        return this.LESS;
    }

    @Override
    public Function2<Boolean, UnsignedInt13Member, UnsignedInt13Member> isLessEqual() {
        return this.LE;
    }

    @Override
    public Function2<Boolean, UnsignedInt13Member, UnsignedInt13Member> isGreater() {
        return this.GREAT;
    }

    @Override
    public Function2<Boolean, UnsignedInt13Member, UnsignedInt13Member> isGreaterEqual() {
        return this.GE;
    }

    @Override
    public Function2<java.lang.Integer, UnsignedInt13Member, UnsignedInt13Member> compare() {
        return this.CMP;
    }

    @Override
    public Function1<java.lang.Integer, UnsignedInt13Member> signum() {
        return this.SIG;
    }

    @Override
    public Procedure3<UnsignedInt13Member, UnsignedInt13Member, UnsignedInt13Member> min() {
        return this.MIN;
    }

    @Override
    public Procedure3<UnsignedInt13Member, UnsignedInt13Member, UnsignedInt13Member> max() {
        return this.MAX;
    }

    @Override
    public Procedure2<UnsignedInt13Member, UnsignedInt13Member> abs() {
        return this.ASSIGN;
    }

    @Override
    public Procedure2<UnsignedInt13Member, UnsignedInt13Member> norm() {
        return this.ASSIGN;
    }

    @Override
    public Procedure3<UnsignedInt13Member, UnsignedInt13Member, UnsignedInt13Member> gcd() {
        return this.GCD;
    }

    @Override
    public Procedure3<UnsignedInt13Member, UnsignedInt13Member, UnsignedInt13Member> lcm() {
        return this.LCM;
    }

    @Override
    public Function1<Boolean, UnsignedInt13Member> isEven() {
        return this.EVEN;
    }

    @Override
    public Function1<Boolean, UnsignedInt13Member> isOdd() {
        return this.ODD;
    }

    @Override
    public Procedure3<UnsignedInt13Member, UnsignedInt13Member, UnsignedInt13Member> div() {
        return this.DIV;
    }

    @Override
    public Procedure3<UnsignedInt13Member, UnsignedInt13Member, UnsignedInt13Member> mod() {
        return this.MOD;
    }

    @Override
    public Procedure4<UnsignedInt13Member, UnsignedInt13Member, UnsignedInt13Member, UnsignedInt13Member> divMod() {
        return this.DIVMOD;
    }

    @Override
    public Procedure2<UnsignedInt13Member, UnsignedInt13Member> pred() {
        return this.PRED;
    }

    @Override
    public Procedure2<UnsignedInt13Member, UnsignedInt13Member> succ() {
        return this.SUCC;
    }

    @Override
    public Procedure3<UnsignedInt13Member, UnsignedInt13Member, UnsignedInt13Member> pow() {
        return this.POW;
    }

    @Override
    public Procedure1<UnsignedInt13Member> random() {
        return this.RAND;
    }

    @Override
    public Procedure3<UnsignedInt13Member, UnsignedInt13Member, UnsignedInt13Member> bitAnd() {
        return this.AND;
    }

    @Override
    public Procedure3<UnsignedInt13Member, UnsignedInt13Member, UnsignedInt13Member> bitOr() {
        return this.OR;
    }

    @Override
    public Procedure3<UnsignedInt13Member, UnsignedInt13Member, UnsignedInt13Member> bitXor() {
        return this.XOR;
    }

    @Override
    public Procedure2<UnsignedInt13Member, UnsignedInt13Member> bitNot() {
        return this.NOT;
    }

    @Override
    public Procedure3<UnsignedInt13Member, UnsignedInt13Member, UnsignedInt13Member> bitAndNot() {
        return this.ANDNOT;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt13Member, UnsignedInt13Member> bitShiftLeft() {
        return this.SHL;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt13Member, UnsignedInt13Member> bitShiftRight() {
        return this.SHRZ;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt13Member, UnsignedInt13Member> bitShiftRightFillZero() {
        return this.SHRZ;
    }

    @Override
    public Procedure1<UnsignedInt13Member> maxBound() {
        return this.MAXBOUND;
    }

    @Override
    public Procedure1<UnsignedInt13Member> minBound() {
        return this.MINBOUND;
    }

    @Override
    public Function1<Boolean, UnsignedInt13Member> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<UnsignedInt13Member, UnsignedInt13Member, UnsignedInt13Member> scale() {
        return this.MUL;
    }

    @Override
    public Procedure3<HighPrecisionMember, UnsignedInt13Member, UnsignedInt13Member> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<HighPrecisionMember, UnsignedInt13Member, UnsignedInt13Member> scaleByHighPrecAndRound() {
        return this.SBHPR;
    }

    @Override
    public Procedure3<RationalMember, UnsignedInt13Member, UnsignedInt13Member> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, UnsignedInt13Member, UnsignedInt13Member> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<Double, UnsignedInt13Member, UnsignedInt13Member> scaleByDoubleAndRound() {
        return this.SBDR;
    }

    @Override
    public Function3<Boolean, UnsignedInt13Member, UnsignedInt13Member, UnsignedInt13Member> within() {
        return this.WITHIN;
    }
}

