/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.int14;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.ThreadLocalRandom;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.Gcd;
import nom.bdezonia.zorbage.algorithm.Lcm;
import nom.bdezonia.zorbage.algorithm.NumberWithin;
import nom.bdezonia.zorbage.algorithm.PowerNonNegative;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.BitOperations;
import nom.bdezonia.zorbage.type.algebra.Bounded;
import nom.bdezonia.zorbage.type.algebra.Integer;
import nom.bdezonia.zorbage.type.algebra.Random;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.int14.SignedInt14Member;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class SignedInt14Algebra
implements Integer<SignedInt14Algebra, SignedInt14Member>,
Bounded<SignedInt14Member>,
BitOperations<SignedInt14Member>,
Random<SignedInt14Member>,
Tolerance<SignedInt14Member, SignedInt14Member> {
    private final Function2<Boolean, SignedInt14Member, SignedInt14Member> EQ = new Function2<Boolean, SignedInt14Member, SignedInt14Member>(){

        @Override
        public Boolean call(SignedInt14Member a, SignedInt14Member b) {
            return a.v == b.v;
        }
    };
    private final Function2<Boolean, SignedInt14Member, SignedInt14Member> NEQ = new Function2<Boolean, SignedInt14Member, SignedInt14Member>(){

        @Override
        public Boolean call(SignedInt14Member a, SignedInt14Member b) {
            return a.v != b.v;
        }
    };
    private final Procedure2<SignedInt14Member, SignedInt14Member> ASSIGN = new Procedure2<SignedInt14Member, SignedInt14Member>(){

        @Override
        public void call(SignedInt14Member a, SignedInt14Member b) {
            b.set(a);
        }
    };
    private final Procedure1<SignedInt14Member> ZER = new Procedure1<SignedInt14Member>(){

        @Override
        public void call(SignedInt14Member a) {
            a.v = 0;
        }
    };
    private final Procedure2<SignedInt14Member, SignedInt14Member> NEG = new Procedure2<SignedInt14Member, SignedInt14Member>(){

        @Override
        public void call(SignedInt14Member a, SignedInt14Member b) {
            if (a.v == -8192) {
                throw new IllegalArgumentException("Cannot convert -minint symmetrically");
            }
            b.v = -a.v;
        }
    };
    private final Procedure3<SignedInt14Member, SignedInt14Member, SignedInt14Member> ADD = new Procedure3<SignedInt14Member, SignedInt14Member, SignedInt14Member>(){

        @Override
        public void call(SignedInt14Member a, SignedInt14Member b, SignedInt14Member c) {
            c.setV(a.v + b.v);
        }
    };
    private final Procedure3<SignedInt14Member, SignedInt14Member, SignedInt14Member> SUB = new Procedure3<SignedInt14Member, SignedInt14Member, SignedInt14Member>(){

        @Override
        public void call(SignedInt14Member a, SignedInt14Member b, SignedInt14Member c) {
            c.setV(a.v - b.v);
        }
    };
    private final Procedure3<SignedInt14Member, SignedInt14Member, SignedInt14Member> MUL = new Procedure3<SignedInt14Member, SignedInt14Member, SignedInt14Member>(){

        @Override
        public void call(SignedInt14Member a, SignedInt14Member b, SignedInt14Member c) {
            c.setV(a.v * b.v);
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt14Member, SignedInt14Member> POWER = new Procedure3<java.lang.Integer, SignedInt14Member, SignedInt14Member>(){

        @Override
        public void call(java.lang.Integer power, SignedInt14Member a, SignedInt14Member b) {
            PowerNonNegative.compute(G.INT14, power, a, b);
        }
    };
    private final Procedure1<SignedInt14Member> UNITY = new Procedure1<SignedInt14Member>(){

        @Override
        public void call(SignedInt14Member a) {
            a.v = 1;
        }
    };
    private final Function2<Boolean, SignedInt14Member, SignedInt14Member> LESS = new Function2<Boolean, SignedInt14Member, SignedInt14Member>(){

        @Override
        public Boolean call(SignedInt14Member a, SignedInt14Member b) {
            return a.v < b.v;
        }
    };
    private final Function2<Boolean, SignedInt14Member, SignedInt14Member> LE = new Function2<Boolean, SignedInt14Member, SignedInt14Member>(){

        @Override
        public Boolean call(SignedInt14Member a, SignedInt14Member b) {
            return a.v <= b.v;
        }
    };
    private final Function2<Boolean, SignedInt14Member, SignedInt14Member> GREAT = new Function2<Boolean, SignedInt14Member, SignedInt14Member>(){

        @Override
        public Boolean call(SignedInt14Member a, SignedInt14Member b) {
            return a.v > b.v;
        }
    };
    private final Function2<Boolean, SignedInt14Member, SignedInt14Member> GE = new Function2<Boolean, SignedInt14Member, SignedInt14Member>(){

        @Override
        public Boolean call(SignedInt14Member a, SignedInt14Member b) {
            return a.v >= b.v;
        }
    };
    private final Function2<java.lang.Integer, SignedInt14Member, SignedInt14Member> CMP = new Function2<java.lang.Integer, SignedInt14Member, SignedInt14Member>(){

        @Override
        public java.lang.Integer call(SignedInt14Member a, SignedInt14Member b) {
            if (a.v < b.v) {
                return -1;
            }
            if (a.v > b.v) {
                return 1;
            }
            return 0;
        }
    };
    private final Function1<java.lang.Integer, SignedInt14Member> SIG = new Function1<java.lang.Integer, SignedInt14Member>(){

        @Override
        public java.lang.Integer call(SignedInt14Member a) {
            if (a.v < 0) {
                return -1;
            }
            if (a.v > 0) {
                return 1;
            }
            return 0;
        }
    };
    private final Procedure3<SignedInt14Member, SignedInt14Member, SignedInt14Member> MIN = new Procedure3<SignedInt14Member, SignedInt14Member, SignedInt14Member>(){

        @Override
        public void call(SignedInt14Member a, SignedInt14Member b, SignedInt14Member c) {
            if (a.v < b.v) {
                c.set(a);
            } else {
                c.set(b);
            }
        }
    };
    private final Procedure3<SignedInt14Member, SignedInt14Member, SignedInt14Member> MAX = new Procedure3<SignedInt14Member, SignedInt14Member, SignedInt14Member>(){

        @Override
        public void call(SignedInt14Member a, SignedInt14Member b, SignedInt14Member c) {
            if (a.v > b.v) {
                c.set(a);
            } else {
                c.set(b);
            }
        }
    };
    private final Procedure2<SignedInt14Member, SignedInt14Member> ABS = new Procedure2<SignedInt14Member, SignedInt14Member>(){

        @Override
        public void call(SignedInt14Member a, SignedInt14Member b) {
            if (a.v == -8192) {
                throw new IllegalArgumentException("Cannot convert -minint symmetrically");
            }
            b.v = a.v < 0 ? (short)(-a.v) : a.v;
        }
    };
    private final Procedure3<SignedInt14Member, SignedInt14Member, SignedInt14Member> GCD = new Procedure3<SignedInt14Member, SignedInt14Member, SignedInt14Member>(){

        @Override
        public void call(SignedInt14Member a, SignedInt14Member b, SignedInt14Member c) {
            Gcd.compute(G.INT14, a, b, c);
        }
    };
    private final Procedure3<SignedInt14Member, SignedInt14Member, SignedInt14Member> LCM = new Procedure3<SignedInt14Member, SignedInt14Member, SignedInt14Member>(){

        @Override
        public void call(SignedInt14Member a, SignedInt14Member b, SignedInt14Member c) {
            Lcm.compute(G.INT14, a, b, c);
        }
    };
    private final Function1<Boolean, SignedInt14Member> EVEN = new Function1<Boolean, SignedInt14Member>(){

        @Override
        public Boolean call(SignedInt14Member a) {
            return (a.v & 1) == 0;
        }
    };
    private final Function1<Boolean, SignedInt14Member> ODD = new Function1<Boolean, SignedInt14Member>(){

        @Override
        public Boolean call(SignedInt14Member a) {
            return (a.v & 1) == 1;
        }
    };
    private final Procedure3<SignedInt14Member, SignedInt14Member, SignedInt14Member> DIV = new Procedure3<SignedInt14Member, SignedInt14Member, SignedInt14Member>(){

        @Override
        public void call(SignedInt14Member a, SignedInt14Member b, SignedInt14Member d) {
            if (b.v == -1 && a.v == -8192) {
                throw new IllegalArgumentException("cannot divide minint by -1");
            }
            d.setV(a.v / b.v);
        }
    };
    private final Procedure3<SignedInt14Member, SignedInt14Member, SignedInt14Member> MOD = new Procedure3<SignedInt14Member, SignedInt14Member, SignedInt14Member>(){

        @Override
        public void call(SignedInt14Member a, SignedInt14Member b, SignedInt14Member m) {
            m.setV(a.v % b.v);
        }
    };
    private final Procedure4<SignedInt14Member, SignedInt14Member, SignedInt14Member, SignedInt14Member> DIVMOD = new Procedure4<SignedInt14Member, SignedInt14Member, SignedInt14Member, SignedInt14Member>(){

        @Override
        public void call(SignedInt14Member a, SignedInt14Member b, SignedInt14Member d, SignedInt14Member m) {
            SignedInt14Algebra.this.div().call(a, b, d);
            SignedInt14Algebra.this.mod().call(a, b, m);
        }
    };
    private final Procedure2<SignedInt14Member, SignedInt14Member> PRED = new Procedure2<SignedInt14Member, SignedInt14Member>(){

        @Override
        public void call(SignedInt14Member a, SignedInt14Member b) {
            if (a.v == -8192) {
                b.v = (short)8191;
            } else {
                b.setV(a.v - 1);
            }
        }
    };
    private final Procedure2<SignedInt14Member, SignedInt14Member> SUCC = new Procedure2<SignedInt14Member, SignedInt14Member>(){

        @Override
        public void call(SignedInt14Member a, SignedInt14Member b) {
            if (a.v == 8191) {
                b.v = (short)-8192;
            } else {
                b.setV(a.v + 1);
            }
        }
    };
    private final Procedure3<SignedInt14Member, SignedInt14Member, SignedInt14Member> POW = new Procedure3<SignedInt14Member, SignedInt14Member, SignedInt14Member>(){

        @Override
        public void call(SignedInt14Member a, SignedInt14Member b, SignedInt14Member c) {
            PowerNonNegative.compute(G.INT14, b.v, a, c);
        }
    };
    private final Procedure1<SignedInt14Member> RAND = new Procedure1<SignedInt14Member>(){

        @Override
        public void call(SignedInt14Member a) {
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            a.setV(rng.nextInt(16384) - 8192);
        }
    };
    private final Procedure3<SignedInt14Member, SignedInt14Member, SignedInt14Member> AND = new Procedure3<SignedInt14Member, SignedInt14Member, SignedInt14Member>(){

        @Override
        public void call(SignedInt14Member a, SignedInt14Member b, SignedInt14Member c) {
            c.setV(a.v & b.v);
        }
    };
    private final Procedure3<SignedInt14Member, SignedInt14Member, SignedInt14Member> OR = new Procedure3<SignedInt14Member, SignedInt14Member, SignedInt14Member>(){

        @Override
        public void call(SignedInt14Member a, SignedInt14Member b, SignedInt14Member c) {
            c.setV(a.v | b.v);
        }
    };
    private final Procedure3<SignedInt14Member, SignedInt14Member, SignedInt14Member> XOR = new Procedure3<SignedInt14Member, SignedInt14Member, SignedInt14Member>(){

        @Override
        public void call(SignedInt14Member a, SignedInt14Member b, SignedInt14Member c) {
            c.setV(a.v ^ b.v);
        }
    };
    private final Procedure2<SignedInt14Member, SignedInt14Member> NOT = new Procedure2<SignedInt14Member, SignedInt14Member>(){

        @Override
        public void call(SignedInt14Member a, SignedInt14Member b) {
            b.setV(~a.v);
        }
    };
    private final Procedure3<SignedInt14Member, SignedInt14Member, SignedInt14Member> ANDNOT = new Procedure3<SignedInt14Member, SignedInt14Member, SignedInt14Member>(){

        @Override
        public void call(SignedInt14Member a, SignedInt14Member b, SignedInt14Member c) {
            c.setV(a.v & ~b.v);
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt14Member, SignedInt14Member> SHL = new Procedure3<java.lang.Integer, SignedInt14Member, SignedInt14Member>(){

        @Override
        public void call(java.lang.Integer count, SignedInt14Member a, SignedInt14Member b) {
            if (count < 0) {
                SignedInt14Algebra.this.bitShiftRight().call(-count.intValue(), a, b);
            } else {
                count = count % 14;
                b.setV(a.v << count);
            }
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt14Member, SignedInt14Member> SHR = new Procedure3<java.lang.Integer, SignedInt14Member, SignedInt14Member>(){

        @Override
        public void call(java.lang.Integer count, SignedInt14Member a, SignedInt14Member b) {
            if (count < 0) {
                SignedInt14Algebra.this.bitShiftLeft().call(-count.intValue(), a, b);
            } else {
                int val = a.v >> count;
                if (a.v < 0 && val == 0) {
                    b.v = (short)-1;
                } else {
                    b.setV(val);
                }
            }
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt14Member, SignedInt14Member> SHRZ = new Procedure3<java.lang.Integer, SignedInt14Member, SignedInt14Member>(){

        @Override
        public void call(java.lang.Integer count, SignedInt14Member a, SignedInt14Member b) {
            if (count < 0) {
                SignedInt14Algebra.this.bitShiftLeft().call(-count.intValue(), a, b);
            } else {
                b.setV(a.v >>> count);
            }
        }
    };
    private final Procedure1<SignedInt14Member> MAXBOUND = new Procedure1<SignedInt14Member>(){

        @Override
        public void call(SignedInt14Member a) {
            a.v = (short)8191;
        }
    };
    private final Procedure1<SignedInt14Member> MINBOUND = new Procedure1<SignedInt14Member>(){

        @Override
        public void call(SignedInt14Member a) {
            a.v = (short)-8192;
        }
    };
    private final Function1<Boolean, SignedInt14Member> ISZERO = new Function1<Boolean, SignedInt14Member>(){

        @Override
        public Boolean call(SignedInt14Member a) {
            return a.v == 0;
        }
    };
    private final Procedure3<HighPrecisionMember, SignedInt14Member, SignedInt14Member> SBHP = new Procedure3<HighPrecisionMember, SignedInt14Member, SignedInt14Member>(){

        @Override
        public void call(HighPrecisionMember a, SignedInt14Member b, SignedInt14Member c) {
            BigDecimal tmp = a.v();
            tmp = tmp.multiply(new BigDecimal(b.v()));
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<HighPrecisionMember, SignedInt14Member, SignedInt14Member> SBHPR = new Procedure3<HighPrecisionMember, SignedInt14Member, SignedInt14Member>(){

        @Override
        public void call(HighPrecisionMember a, SignedInt14Member b, SignedInt14Member c) {
            BigDecimal tmp = a.v();
            int signum = (tmp = tmp.multiply(new BigDecimal(b.v()))).signum();
            tmp = signum < 0 ? tmp.subtract(G.ONE_HALF) : tmp.add(G.ONE_HALF);
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<RationalMember, SignedInt14Member, SignedInt14Member> SBR = new Procedure3<RationalMember, SignedInt14Member, SignedInt14Member>(){

        @Override
        public void call(RationalMember a, SignedInt14Member b, SignedInt14Member c) {
            BigInteger tmp = BigInteger.valueOf(b.v());
            tmp = tmp.multiply(a.n());
            tmp = tmp.divide(a.d());
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<Double, SignedInt14Member, SignedInt14Member> SBD = new Procedure3<Double, SignedInt14Member, SignedInt14Member>(){

        @Override
        public void call(Double a, SignedInt14Member b, SignedInt14Member c) {
            c.setV((int)(a * (double)b.v()));
        }
    };
    private final Procedure3<Double, SignedInt14Member, SignedInt14Member> SBDR = new Procedure3<Double, SignedInt14Member, SignedInt14Member>(){

        @Override
        public void call(Double a, SignedInt14Member b, SignedInt14Member c) {
            c.setV((int)Math.round(a * (double)b.v()));
        }
    };
    private final Function3<Boolean, SignedInt14Member, SignedInt14Member, SignedInt14Member> WITHIN = new Function3<Boolean, SignedInt14Member, SignedInt14Member, SignedInt14Member>(){

        @Override
        public Boolean call(SignedInt14Member tol, SignedInt14Member a, SignedInt14Member b) {
            return NumberWithin.compute(G.INT14, tol, a, b);
        }
    };

    @Override
    public SignedInt14Member construct() {
        return new SignedInt14Member();
    }

    @Override
    public SignedInt14Member construct(SignedInt14Member other) {
        return new SignedInt14Member(other);
    }

    @Override
    public SignedInt14Member construct(String str) {
        return new SignedInt14Member(str);
    }

    @Override
    public Function2<Boolean, SignedInt14Member, SignedInt14Member> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, SignedInt14Member, SignedInt14Member> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<SignedInt14Member, SignedInt14Member> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure1<SignedInt14Member> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<SignedInt14Member, SignedInt14Member> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<SignedInt14Member, SignedInt14Member, SignedInt14Member> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<SignedInt14Member, SignedInt14Member, SignedInt14Member> subtract() {
        return this.SUB;
    }

    @Override
    public Procedure3<SignedInt14Member, SignedInt14Member, SignedInt14Member> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt14Member, SignedInt14Member> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<SignedInt14Member> unity() {
        return this.UNITY;
    }

    @Override
    public Function2<Boolean, SignedInt14Member, SignedInt14Member> isLess() {
        return this.LESS;
    }

    @Override
    public Function2<Boolean, SignedInt14Member, SignedInt14Member> isLessEqual() {
        return this.LE;
    }

    @Override
    public Function2<Boolean, SignedInt14Member, SignedInt14Member> isGreater() {
        return this.GREAT;
    }

    @Override
    public Function2<Boolean, SignedInt14Member, SignedInt14Member> isGreaterEqual() {
        return this.GE;
    }

    @Override
    public Function2<java.lang.Integer, SignedInt14Member, SignedInt14Member> compare() {
        return this.CMP;
    }

    @Override
    public Function1<java.lang.Integer, SignedInt14Member> signum() {
        return this.SIG;
    }

    @Override
    public Procedure3<SignedInt14Member, SignedInt14Member, SignedInt14Member> min() {
        return this.MIN;
    }

    @Override
    public Procedure3<SignedInt14Member, SignedInt14Member, SignedInt14Member> max() {
        return this.MAX;
    }

    @Override
    public Procedure2<SignedInt14Member, SignedInt14Member> abs() {
        return this.ABS;
    }

    @Override
    public Procedure2<SignedInt14Member, SignedInt14Member> norm() {
        return this.ABS;
    }

    @Override
    public Procedure3<SignedInt14Member, SignedInt14Member, SignedInt14Member> gcd() {
        return this.GCD;
    }

    @Override
    public Procedure3<SignedInt14Member, SignedInt14Member, SignedInt14Member> lcm() {
        return this.LCM;
    }

    @Override
    public Function1<Boolean, SignedInt14Member> isEven() {
        return this.EVEN;
    }

    @Override
    public Function1<Boolean, SignedInt14Member> isOdd() {
        return this.ODD;
    }

    @Override
    public Procedure3<SignedInt14Member, SignedInt14Member, SignedInt14Member> div() {
        return this.DIV;
    }

    @Override
    public Procedure3<SignedInt14Member, SignedInt14Member, SignedInt14Member> mod() {
        return this.MOD;
    }

    @Override
    public Procedure4<SignedInt14Member, SignedInt14Member, SignedInt14Member, SignedInt14Member> divMod() {
        return this.DIVMOD;
    }

    @Override
    public Procedure2<SignedInt14Member, SignedInt14Member> pred() {
        return this.PRED;
    }

    @Override
    public Procedure2<SignedInt14Member, SignedInt14Member> succ() {
        return this.SUCC;
    }

    @Override
    public Procedure3<SignedInt14Member, SignedInt14Member, SignedInt14Member> pow() {
        return this.POW;
    }

    @Override
    public Procedure1<SignedInt14Member> random() {
        return this.RAND;
    }

    @Override
    public Procedure3<SignedInt14Member, SignedInt14Member, SignedInt14Member> bitAnd() {
        return this.AND;
    }

    @Override
    public Procedure3<SignedInt14Member, SignedInt14Member, SignedInt14Member> bitOr() {
        return this.OR;
    }

    @Override
    public Procedure3<SignedInt14Member, SignedInt14Member, SignedInt14Member> bitXor() {
        return this.XOR;
    }

    @Override
    public Procedure2<SignedInt14Member, SignedInt14Member> bitNot() {
        return this.NOT;
    }

    @Override
    public Procedure3<SignedInt14Member, SignedInt14Member, SignedInt14Member> bitAndNot() {
        return this.ANDNOT;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt14Member, SignedInt14Member> bitShiftLeft() {
        return this.SHL;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt14Member, SignedInt14Member> bitShiftRight() {
        return this.SHR;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt14Member, SignedInt14Member> bitShiftRightFillZero() {
        return this.SHRZ;
    }

    @Override
    public Procedure1<SignedInt14Member> maxBound() {
        return this.MAXBOUND;
    }

    @Override
    public Procedure1<SignedInt14Member> minBound() {
        return this.MINBOUND;
    }

    @Override
    public Function1<Boolean, SignedInt14Member> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<SignedInt14Member, SignedInt14Member, SignedInt14Member> scale() {
        return this.MUL;
    }

    @Override
    public Procedure3<HighPrecisionMember, SignedInt14Member, SignedInt14Member> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<HighPrecisionMember, SignedInt14Member, SignedInt14Member> scaleByHighPrecAndRound() {
        return this.SBHPR;
    }

    @Override
    public Procedure3<RationalMember, SignedInt14Member, SignedInt14Member> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, SignedInt14Member, SignedInt14Member> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<Double, SignedInt14Member, SignedInt14Member> scaleByDoubleAndRound() {
        return this.SBDR;
    }

    @Override
    public Function3<Boolean, SignedInt14Member, SignedInt14Member, SignedInt14Member> within() {
        return this.WITHIN;
    }
}

