/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.int14;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigDecimal;
import java.math.BigInteger;
import nom.bdezonia.zorbage.sampling.IntegerIndex;
import nom.bdezonia.zorbage.type.algebra.GetReal;
import nom.bdezonia.zorbage.type.algebra.Gettable;
import nom.bdezonia.zorbage.type.algebra.HighPrecRepresentation;
import nom.bdezonia.zorbage.type.algebra.NumberMember;
import nom.bdezonia.zorbage.type.algebra.SetReal;
import nom.bdezonia.zorbage.type.algebra.Settable;
import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.ctor.Duplicatable;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.int16.SignedInt16Member;
import nom.bdezonia.zorbage.type.data.universal.OctonionRepresentation;
import nom.bdezonia.zorbage.type.data.universal.PrimitiveConversion;
import nom.bdezonia.zorbage.type.data.universal.PrimitiveRepresentation;
import nom.bdezonia.zorbage.type.data.universal.TensorOctonionRepresentation;
import nom.bdezonia.zorbage.type.data.universal.TensorStringRepresentation;
import nom.bdezonia.zorbage.type.data.universal.UniversalRepresentation;
import nom.bdezonia.zorbage.type.storage.coder.BitCoder;
import nom.bdezonia.zorbage.type.storage.coder.ShortCoder;

public final class SignedInt14Member
implements BitCoder,
ShortCoder,
Allocatable<SignedInt14Member>,
Duplicatable<SignedInt14Member>,
Settable<SignedInt14Member>,
Gettable<SignedInt14Member>,
UniversalRepresentation,
NumberMember<SignedInt14Member>,
PrimitiveConversion,
HighPrecRepresentation,
SetReal<Integer>,
GetReal<SignedInt16Member> {
    short v;

    public SignedInt14Member() {
        this.v = 0;
    }

    public SignedInt14Member(SignedInt14Member other) {
        this.set(other);
    }

    public SignedInt14Member(String value) {
        TensorStringRepresentation rep = new TensorStringRepresentation(value);
        OctonionRepresentation val = rep.firstValue();
        int x = val.r().intValue();
        this.setV(x);
    }

    public SignedInt14Member(int v) {
        this.setV(v);
    }

    @Override
    public void v(SignedInt14Member value) {
        this.get(value);
    }

    public short v() {
        return this.v;
    }

    @Override
    public void setV(SignedInt14Member value) {
        this.set(value);
    }

    @Override
    public void setV(int val) {
        this.v = (short)(val % 16384);
        if (this.v < -8192) {
            this.v = (short)(this.v + 16384);
        } else if (this.v > 8191) {
            this.v = (short)(this.v - 16384);
        }
    }

    public String toString() {
        return String.valueOf(this.v);
    }

    @Override
    public void toRep(TensorOctonionRepresentation rep) {
        rep.setValue(new OctonionRepresentation(new BigDecimal(this.v)));
    }

    @Override
    public void fromRep(TensorOctonionRepresentation rep) {
        this.setV(rep.getValue().r().intValue());
    }

    @Override
    public void get(SignedInt14Member other) {
        other.v = this.v;
    }

    @Override
    public void set(SignedInt14Member other) {
        this.v = other.v;
    }

    @Override
    public SignedInt14Member duplicate() {
        return new SignedInt14Member(this);
    }

    @Override
    public SignedInt14Member allocate() {
        return new SignedInt14Member();
    }

    @Override
    public int bitCount() {
        return 14;
    }

    @Override
    public void fromBitArray(long[] arr, int index, int offset) {
        if (offset < 51) {
            long b1b2b3b4b5b6b7b8b9b10b11b12b13b14 = arr[index] >>> offset & 0x3FFFL;
            this.setV((int)b1b2b3b4b5b6b7b8b9b10b11b12b13b14);
        } else if (offset == 63) {
            long b1 = arr[index] >>> 63 & 1L;
            long b2b3b4b5b6b7b8b9b10b11b12b13b14 = arr[index + 1] & 0x1FFFL;
            this.setV((int)(b1 << 13 | b2b3b4b5b6b7b8b9b10b11b12b13b14));
        } else if (offset == 62) {
            long b1b2 = arr[index] >>> 62 & 3L;
            long b3b4b5b6b7b8b9b10b11b12b13b14 = arr[index + 1] & 0xFFFL;
            this.setV((int)(b1b2 << 12 | b3b4b5b6b7b8b9b10b11b12b13b14));
        } else if (offset == 61) {
            long b1b2b3 = arr[index] >>> 61 & 7L;
            long b4b5b6b7b8b9b10b11b12b13b14 = arr[index + 1] & 0x7FFL;
            this.setV((int)(b1b2b3 << 11 | b4b5b6b7b8b9b10b11b12b13b14));
        } else if (offset == 60) {
            long b1b2b3b4 = arr[index] >>> 60 & 0xFL;
            long b5b6b7b8b9b10b11b12b13b14 = arr[index + 1] & 0x3FFL;
            this.setV((int)(b1b2b3b4 << 10 | b5b6b7b8b9b10b11b12b13b14));
        } else if (offset == 59) {
            long b1b2b3b4b5 = arr[index] >>> 59 & 0x1FL;
            long b6b7b8b9b10b11b12b13b14 = arr[index + 1] & 0x1FFL;
            this.setV((int)(b1b2b3b4b5 << 9 | b6b7b8b9b10b11b12b13b14));
        } else if (offset == 58) {
            long b1b2b3b4b5b6 = arr[index] >>> 58 & 0x3FL;
            long b7b8b9b10b11b12b13b14 = arr[index + 1] & 0xFFL;
            this.setV((int)(b1b2b3b4b5b6 << 8 | b7b8b9b10b11b12b13b14));
        } else if (offset == 57) {
            long b1b2b3b4b5b6b7 = arr[index] >>> 57 & 0x7FL;
            long b8b9b10b11b12b13b14 = arr[index + 1] & 0x7FL;
            this.setV((int)(b1b2b3b4b5b6b7 << 7 | b8b9b10b11b12b13b14));
        } else if (offset == 56) {
            long b1b2b3b4b5b6b7b8 = arr[index] >>> 56 & 0xFFL;
            long b9b10b11b12b13b14 = arr[index + 1] & 0x3FL;
            this.setV((int)(b1b2b3b4b5b6b7b8 << 6 | b9b10b11b12b13b14));
        } else if (offset == 55) {
            long b1b2b3b4b5b6b7b8b9 = arr[index] >>> 55 & 0x1FFL;
            long b10b11b12b13b14 = arr[index + 1] & 0x1FL;
            this.setV((int)(b1b2b3b4b5b6b7b8b9 << 5 | b10b11b12b13b14));
        } else if (offset == 54) {
            long b1b2b3b4b5b6b7b8b9b10 = arr[index] >>> 54 & 0x3FFL;
            long b11b12b13b14 = arr[index + 1] & 0xFL;
            this.setV((int)(b1b2b3b4b5b6b7b8b9b10 << 4 | b11b12b13b14));
        } else if (offset == 53) {
            long b1b2b3b4b5b6b7b8b9b10b11 = arr[index] >>> 53 & 0x7FFL;
            long b12b13b14 = arr[index + 1] & 7L;
            this.setV((int)(b1b2b3b4b5b6b7b8b9b10b11 << 3 | b12b13b14));
        } else if (offset == 52) {
            long b1b2b3b4b5b6b7b8b9b10b11b12 = arr[index] >>> 52 & 0xFFFL;
            long b13b14 = arr[index + 1] & 3L;
            this.setV((int)(b1b2b3b4b5b6b7b8b9b10b11b12 << 2 | b13b14));
        } else {
            long b1b2b3b4b5b6b7b8b9b10b11b1213 = arr[index] >>> 51 & 0x1FFFL;
            long b14 = arr[index + 1] & 1L;
            this.setV((int)(b1b2b3b4b5b6b7b8b9b10b11b1213 << 1 | b14));
        }
    }

    @Override
    public void toBitArray(long[] arr, int index, int offset) {
        if (offset < 51) {
            long oldVals = arr[index] & (16383L << offset ^ 0xFFFFFFFFFFFFFFFFL);
            long newVals = (long)this.v << offset;
            arr[index] = newVals | oldVals;
        } else if (offset == 63) {
            long b1 = ((long)this.v & 0x2000L) >>> 13;
            long b2b3b4b5b6b7b8b9b10b11b12b13b14 = (long)this.v & 0x1FFFL;
            long oldVals = arr[index] & Long.MAX_VALUE;
            long newVals = b1 << 63;
            arr[index] = newVals | oldVals;
            oldVals = arr[index + 1] & 0xFFFFFFFFFFFFE000L;
            newVals = b2b3b4b5b6b7b8b9b10b11b12b13b14 << 0;
            arr[index + 1] = newVals | oldVals;
        } else if (offset == 62) {
            long b1b2 = (this.v & 0x3000) >>> 12;
            long b3b4b5b6b7b8b9b10b11b12b13b14 = (long)this.v & 0xFFFL;
            long oldVals = arr[index] & 0x3FFFFFFFFFFFFFFFL;
            long newVals = b1b2 << 62;
            arr[index] = newVals | oldVals;
            oldVals = arr[index + 1] & 0xFFFFFFFFFFFFF000L;
            newVals = b3b4b5b6b7b8b9b10b11b12b13b14 << 0;
            arr[index + 1] = newVals | oldVals;
        } else if (offset == 61) {
            long b1b2b3 = (this.v & 0x3800) >>> 11;
            long b4b5b6b7b8b9b10b11b12b13b14 = (long)this.v & 0x7FFL;
            long oldVals = arr[index] & 0x1FFFFFFFFFFFFFFFL;
            long newVals = b1b2b3 << 61;
            arr[index] = newVals | oldVals;
            oldVals = arr[index + 1] & 0xFFFFFFFFFFFFF800L;
            newVals = b4b5b6b7b8b9b10b11b12b13b14 << 0;
            arr[index + 1] = newVals | oldVals;
        } else if (offset == 60) {
            long b1b2b3b4 = (this.v & 0x3C00) >>> 10;
            long b5b6b7b8b9b10b11b12b13b14 = (long)this.v & 0x3FFL;
            long oldVals = arr[index] & 0xFFFFFFFFFFFFFFFL;
            long newVals = b1b2b3b4 << 60;
            arr[index] = newVals | oldVals;
            oldVals = arr[index + 1] & 0xFFFFFFFFFFFFFC00L;
            newVals = b5b6b7b8b9b10b11b12b13b14 << 0;
            arr[index + 1] = newVals | oldVals;
        } else if (offset == 59) {
            long b1b2b3b4b5 = (this.v & 0x3E00) >>> 9;
            long b6b7b8b9b10b11b12b13b14 = (long)this.v & 0x1FFL;
            long oldVals = arr[index] & 0x7FFFFFFFFFFFFFFL;
            long newVals = b1b2b3b4b5 << 59;
            arr[index] = newVals | oldVals;
            oldVals = arr[index + 1] & 0xFFFFFFFFFFFFFE00L;
            newVals = b6b7b8b9b10b11b12b13b14 << 0;
            arr[index + 1] = newVals | oldVals;
        } else if (offset == 58) {
            long b1b2b3b4b5b6 = (this.v & 0x3F00) >>> 8;
            long b7b8b9b10b11b12b13b14 = (long)this.v & 0xFFL;
            long oldVals = arr[index] & 0x3FFFFFFFFFFFFFFL;
            long newVals = b1b2b3b4b5b6 << 58;
            arr[index] = newVals | oldVals;
            oldVals = arr[index + 1] & 0xFFFFFFFFFFFFFF00L;
            newVals = b7b8b9b10b11b12b13b14 << 0;
            arr[index + 1] = newVals | oldVals;
        } else if (offset == 57) {
            long b1b2b3b4b5b6b7 = (this.v & 0x3F80) >>> 7;
            long b8b9b10b11b12b13b14 = (long)this.v & 0x7FL;
            long oldVals = arr[index] & 0x1FFFFFFFFFFFFFFL;
            long newVals = b1b2b3b4b5b6b7 << 57;
            arr[index] = newVals | oldVals;
            oldVals = arr[index + 1] & 0xFFFFFFFFFFFFFF80L;
            newVals = b8b9b10b11b12b13b14 << 0;
            arr[index + 1] = newVals | oldVals;
        } else if (offset == 56) {
            long b1b2b3b4b5b6b7b8 = (this.v & 0x3FC0) >>> 6;
            long b9b10b11b12b13b14 = (long)this.v & 0x3FL;
            long oldVals = arr[index] & 0xFFFFFFFFFFFFFFL;
            long newVals = b1b2b3b4b5b6b7b8 << 56;
            arr[index] = newVals | oldVals;
            oldVals = arr[index + 1] & 0xFFFFFFFFFFFFFFC0L;
            newVals = b9b10b11b12b13b14 << 0;
            arr[index + 1] = newVals | oldVals;
        } else if (offset == 55) {
            long b1b2b3b4b5b6b7b8b9 = (this.v & 0x3FE0) >>> 5;
            long b10b11b12b13b14 = (long)this.v & 0x1FL;
            long oldVals = arr[index] & 0x7FFFFFFFFFFFFFL;
            long newVals = b1b2b3b4b5b6b7b8b9 << 55;
            arr[index] = newVals | oldVals;
            oldVals = arr[index + 1] & 0xFFFFFFFFFFFFFFE0L;
            newVals = b10b11b12b13b14 << 0;
            arr[index + 1] = newVals | oldVals;
        } else if (offset == 54) {
            long b1b2b3b4b5b6b7b8b9b10 = (this.v & 0x3FF0) >>> 4;
            long b11b12b13b14 = (long)this.v & 0xFL;
            long oldVals = arr[index] & 0x3FFFFFFFFFFFFFL;
            long newVals = b1b2b3b4b5b6b7b8b9b10 << 54;
            arr[index] = newVals | oldVals;
            oldVals = arr[index + 1] & 0xFFFFFFFFFFFFFFF0L;
            newVals = b11b12b13b14 << 0;
            arr[index + 1] = newVals | oldVals;
        } else if (offset == 53) {
            long b1b2b3b4b5b6b7b8b9b10b11 = (this.v & 0x3FF8) >>> 3;
            long b12b13b14 = (long)this.v & 7L;
            long oldVals = arr[index] & 0x1FFFFFFFFFFFFFL;
            long newVals = b1b2b3b4b5b6b7b8b9b10b11 << 53;
            arr[index] = newVals | oldVals;
            oldVals = arr[index + 1] & 0xFFFFFFFFFFFFFFF8L;
            newVals = b12b13b14 << 0;
            arr[index + 1] = newVals | oldVals;
        } else if (offset == 52) {
            long b1b2b3b4b5b6b7b8b9b10b11b12 = (this.v & 0x3FFC) >>> 2;
            long b13b14 = (long)this.v & 3L;
            long oldVals = arr[index] & 0xFFFFFFFFFFFFFL;
            long newVals = b1b2b3b4b5b6b7b8b9b10b11b12 << 52;
            arr[index] = newVals | oldVals;
            oldVals = arr[index + 1] & 0xFFFFFFFFFFFFFFFCL;
            newVals = b13b14 << 0;
            arr[index + 1] = newVals | oldVals;
        } else {
            long b1b2b3b4b5b6b7b8b9b10b11b12b13 = (this.v & 0x3FFE) >>> 1;
            long b14 = (long)this.v & 1L;
            long oldVals = arr[index] & 0x7FFFFFFFFFFFFL;
            long newVals = b1b2b3b4b5b6b7b8b9b10b11b12b13 << 51;
            arr[index] = newVals | oldVals;
            oldVals = arr[index + 1] & 0xFFFFFFFFFFFFFFFEL;
            newVals = b14 << 0;
            arr[index + 1] = newVals | oldVals;
        }
    }

    @Override
    public int shortCount() {
        return 1;
    }

    @Override
    public void fromShortArray(short[] arr, int index) {
        this.setV(arr[index]);
    }

    @Override
    public void toShortArray(short[] arr, int index) {
        arr[index] = this.v;
    }

    @Override
    public void fromShortFile(RandomAccessFile raf) throws IOException {
        this.setV(raf.readShort());
    }

    @Override
    public void toShortFile(RandomAccessFile raf) throws IOException {
        raf.writeShort(this.v);
    }

    @Override
    public long dimension(int d) {
        return 0L;
    }

    @Override
    public int numDimensions() {
        return 0;
    }

    @Override
    public PrimitiveRepresentation preferredRepresentation() {
        return PrimitiveRepresentation.SHORT;
    }

    @Override
    public int componentCount() {
        return 1;
    }

    @Override
    public void primComponentSetByte(IntegerIndex index, int component, byte v) {
        this.setV(v);
    }

    @Override
    public void primComponentSetShort(IntegerIndex index, int component, short v) {
        this.setV(v);
    }

    @Override
    public void primComponentSetInt(IntegerIndex index, int component, int v) {
        this.setV(v);
    }

    @Override
    public void primComponentSetLong(IntegerIndex index, int component, long v) {
        this.setV((int)v);
    }

    @Override
    public void primComponentSetFloat(IntegerIndex index, int component, float v) {
        this.setV((int)v);
    }

    @Override
    public void primComponentSetDouble(IntegerIndex index, int component, double v) {
        this.setV((int)v);
    }

    @Override
    public void primComponentSetBigInteger(IntegerIndex index, int component, BigInteger v) {
        this.setV(v.intValue());
    }

    @Override
    public void primComponentSetBigDecimal(IntegerIndex index, int component, BigDecimal v) {
        this.primComponentSetBigInteger(index, component, v.toBigInteger());
    }

    @Override
    public void primComponentSetByteSafe(IntegerIndex index, int component, byte v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            this.setV(v);
        }
    }

    @Override
    public void primComponentSetShortSafe(IntegerIndex index, int component, short v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            this.setV(v);
        }
    }

    @Override
    public void primComponentSetIntSafe(IntegerIndex index, int component, int v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            this.setV(v);
        }
    }

    @Override
    public void primComponentSetLongSafe(IntegerIndex index, int component, long v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0L) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            this.setV((int)v);
        }
    }

    @Override
    public void primComponentSetFloatSafe(IntegerIndex index, int component, float v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0.0f) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            this.setV((int)v);
        }
    }

    @Override
    public void primComponentSetDoubleSafe(IntegerIndex index, int component, double v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0.0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            this.setV((int)v);
        }
    }

    @Override
    public void primComponentSetBigIntegerSafe(IntegerIndex index, int component, BigInteger v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v.signum() != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            this.setV(v.intValue());
        }
    }

    @Override
    public void primComponentSetBigDecimalSafe(IntegerIndex index, int component, BigDecimal v) {
        this.primComponentSetBigIntegerSafe(index, component, v.toBigInteger());
    }

    @Override
    public byte primComponentGetAsByte(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            return (byte)this.v;
        }
        return 0;
    }

    @Override
    public short primComponentGetAsShort(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            return this.v;
        }
        return 0;
    }

    @Override
    public int primComponentGetAsInt(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            return this.v;
        }
        return 0;
    }

    @Override
    public long primComponentGetAsLong(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            return this.v;
        }
        return 0L;
    }

    @Override
    public float primComponentGetAsFloat(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            return this.v;
        }
        return 0.0f;
    }

    @Override
    public double primComponentGetAsDouble(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            return this.v;
        }
        return 0.0;
    }

    @Override
    public BigInteger primComponentGetAsBigInteger(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            return BigInteger.valueOf(this.v);
        }
        return BigInteger.ZERO;
    }

    @Override
    public BigDecimal primComponentGetAsBigDecimal(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            return BigDecimal.valueOf(this.v);
        }
        return BigDecimal.ZERO;
    }

    @Override
    public byte primComponentGetAsByteSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0;
        }
        return (byte)this.v;
    }

    @Override
    public short primComponentGetAsShortSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0;
        }
        return this.v;
    }

    @Override
    public int primComponentGetAsIntSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0;
        }
        return this.v;
    }

    @Override
    public long primComponentGetAsLongSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0L;
        }
        return this.v;
    }

    @Override
    public float primComponentGetAsFloatSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0.0f;
        }
        return this.v;
    }

    @Override
    public double primComponentGetAsDoubleSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0.0;
        }
        return this.v;
    }

    @Override
    public BigInteger primComponentGetAsBigIntegerSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return BigInteger.ZERO;
        }
        return BigInteger.valueOf(this.v);
    }

    @Override
    public BigDecimal primComponentGetAsBigDecimalSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return BigDecimal.ZERO;
        }
        return BigDecimal.valueOf(this.v);
    }

    @Override
    public void primitiveInit() {
        this.v = 0;
    }

    @Override
    public void toHighPrec(HighPrecisionMember result) {
        result.setV(BigDecimal.valueOf(this.v()));
    }

    @Override
    public void fromHighPrec(HighPrecisionMember input) {
        this.setV(input.v().intValue());
    }

    @Override
    public void setR(Integer val) {
        this.setV(val);
    }

    @Override
    public void getR(SignedInt16Member val) {
        val.setV(this.v);
    }
}

