/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.int14;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.ThreadLocalRandom;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.Gcd;
import nom.bdezonia.zorbage.algorithm.Lcm;
import nom.bdezonia.zorbage.algorithm.NumberWithin;
import nom.bdezonia.zorbage.algorithm.PowerNonNegative;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.BitOperations;
import nom.bdezonia.zorbage.type.algebra.Bounded;
import nom.bdezonia.zorbage.type.algebra.Integer;
import nom.bdezonia.zorbage.type.algebra.Random;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.int14.UnsignedInt14Member;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class UnsignedInt14Algebra
implements Integer<UnsignedInt14Algebra, UnsignedInt14Member>,
Bounded<UnsignedInt14Member>,
BitOperations<UnsignedInt14Member>,
Random<UnsignedInt14Member>,
Tolerance<UnsignedInt14Member, UnsignedInt14Member> {
    private final Function2<Boolean, UnsignedInt14Member, UnsignedInt14Member> EQ = new Function2<Boolean, UnsignedInt14Member, UnsignedInt14Member>(){

        @Override
        public Boolean call(UnsignedInt14Member a, UnsignedInt14Member b) {
            return a.v == b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt14Member, UnsignedInt14Member> NEQ = new Function2<Boolean, UnsignedInt14Member, UnsignedInt14Member>(){

        @Override
        public Boolean call(UnsignedInt14Member a, UnsignedInt14Member b) {
            return a.v != b.v;
        }
    };
    private final Procedure2<UnsignedInt14Member, UnsignedInt14Member> ASSIGN = new Procedure2<UnsignedInt14Member, UnsignedInt14Member>(){

        @Override
        public void call(UnsignedInt14Member a, UnsignedInt14Member b) {
            b.set(a);
        }
    };
    private final Procedure1<UnsignedInt14Member> ZER = new Procedure1<UnsignedInt14Member>(){

        @Override
        public void call(UnsignedInt14Member a) {
            a.v = 0;
        }
    };
    private final Procedure3<UnsignedInt14Member, UnsignedInt14Member, UnsignedInt14Member> ADD = new Procedure3<UnsignedInt14Member, UnsignedInt14Member, UnsignedInt14Member>(){

        @Override
        public void call(UnsignedInt14Member a, UnsignedInt14Member b, UnsignedInt14Member c) {
            c.setV(a.v + b.v);
        }
    };
    private final Procedure3<UnsignedInt14Member, UnsignedInt14Member, UnsignedInt14Member> SUB = new Procedure3<UnsignedInt14Member, UnsignedInt14Member, UnsignedInt14Member>(){

        @Override
        public void call(UnsignedInt14Member a, UnsignedInt14Member b, UnsignedInt14Member c) {
            c.setV(a.v - b.v);
        }
    };
    private final Procedure3<UnsignedInt14Member, UnsignedInt14Member, UnsignedInt14Member> MUL = new Procedure3<UnsignedInt14Member, UnsignedInt14Member, UnsignedInt14Member>(){

        @Override
        public void call(UnsignedInt14Member a, UnsignedInt14Member b, UnsignedInt14Member c) {
            c.setV(a.v * b.v);
        }
    };
    private final Procedure3<java.lang.Integer, UnsignedInt14Member, UnsignedInt14Member> POWER = new Procedure3<java.lang.Integer, UnsignedInt14Member, UnsignedInt14Member>(){

        @Override
        public void call(java.lang.Integer power, UnsignedInt14Member a, UnsignedInt14Member b) {
            PowerNonNegative.compute(G.UINT14, power, a, b);
        }
    };
    private final Procedure1<UnsignedInt14Member> UNITY = new Procedure1<UnsignedInt14Member>(){

        @Override
        public void call(UnsignedInt14Member a) {
            a.v = 1;
        }
    };
    private final Function2<Boolean, UnsignedInt14Member, UnsignedInt14Member> LESS = new Function2<Boolean, UnsignedInt14Member, UnsignedInt14Member>(){

        @Override
        public Boolean call(UnsignedInt14Member a, UnsignedInt14Member b) {
            return a.v < b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt14Member, UnsignedInt14Member> LE = new Function2<Boolean, UnsignedInt14Member, UnsignedInt14Member>(){

        @Override
        public Boolean call(UnsignedInt14Member a, UnsignedInt14Member b) {
            return a.v <= b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt14Member, UnsignedInt14Member> GREAT = new Function2<Boolean, UnsignedInt14Member, UnsignedInt14Member>(){

        @Override
        public Boolean call(UnsignedInt14Member a, UnsignedInt14Member b) {
            return a.v > b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt14Member, UnsignedInt14Member> GE = new Function2<Boolean, UnsignedInt14Member, UnsignedInt14Member>(){

        @Override
        public Boolean call(UnsignedInt14Member a, UnsignedInt14Member b) {
            return a.v >= b.v;
        }
    };
    private final Function2<java.lang.Integer, UnsignedInt14Member, UnsignedInt14Member> CMP = new Function2<java.lang.Integer, UnsignedInt14Member, UnsignedInt14Member>(){

        @Override
        public java.lang.Integer call(UnsignedInt14Member a, UnsignedInt14Member b) {
            if (a.v < b.v) {
                return -1;
            }
            if (a.v > b.v) {
                return 1;
            }
            return 0;
        }
    };
    private final Function1<java.lang.Integer, UnsignedInt14Member> SIG = new Function1<java.lang.Integer, UnsignedInt14Member>(){

        @Override
        public java.lang.Integer call(UnsignedInt14Member a) {
            if (a.v > 0) {
                return 1;
            }
            return 0;
        }
    };
    private final Procedure3<UnsignedInt14Member, UnsignedInt14Member, UnsignedInt14Member> MIN = new Procedure3<UnsignedInt14Member, UnsignedInt14Member, UnsignedInt14Member>(){

        @Override
        public void call(UnsignedInt14Member a, UnsignedInt14Member b, UnsignedInt14Member c) {
            if (a.v < b.v) {
                c.set(a);
            } else {
                c.set(b);
            }
        }
    };
    private final Procedure3<UnsignedInt14Member, UnsignedInt14Member, UnsignedInt14Member> MAX = new Procedure3<UnsignedInt14Member, UnsignedInt14Member, UnsignedInt14Member>(){

        @Override
        public void call(UnsignedInt14Member a, UnsignedInt14Member b, UnsignedInt14Member c) {
            if (a.v > b.v) {
                c.set(a);
            } else {
                c.set(b);
            }
        }
    };
    private final Procedure3<UnsignedInt14Member, UnsignedInt14Member, UnsignedInt14Member> GCD = new Procedure3<UnsignedInt14Member, UnsignedInt14Member, UnsignedInt14Member>(){

        @Override
        public void call(UnsignedInt14Member a, UnsignedInt14Member b, UnsignedInt14Member c) {
            Gcd.compute(G.UINT14, a, b, c);
        }
    };
    private final Procedure3<UnsignedInt14Member, UnsignedInt14Member, UnsignedInt14Member> LCM = new Procedure3<UnsignedInt14Member, UnsignedInt14Member, UnsignedInt14Member>(){

        @Override
        public void call(UnsignedInt14Member a, UnsignedInt14Member b, UnsignedInt14Member c) {
            Lcm.compute(G.UINT14, a, b, c);
        }
    };
    private final Function1<Boolean, UnsignedInt14Member> EVEN = new Function1<Boolean, UnsignedInt14Member>(){

        @Override
        public Boolean call(UnsignedInt14Member a) {
            return (a.v & 1) == 0;
        }
    };
    private final Function1<Boolean, UnsignedInt14Member> ODD = new Function1<Boolean, UnsignedInt14Member>(){

        @Override
        public Boolean call(UnsignedInt14Member a) {
            return (a.v & 1) == 1;
        }
    };
    private final Procedure3<UnsignedInt14Member, UnsignedInt14Member, UnsignedInt14Member> DIV = new Procedure3<UnsignedInt14Member, UnsignedInt14Member, UnsignedInt14Member>(){

        @Override
        public void call(UnsignedInt14Member a, UnsignedInt14Member b, UnsignedInt14Member d) {
            d.setV(a.v / b.v);
        }
    };
    private final Procedure3<UnsignedInt14Member, UnsignedInt14Member, UnsignedInt14Member> MOD = new Procedure3<UnsignedInt14Member, UnsignedInt14Member, UnsignedInt14Member>(){

        @Override
        public void call(UnsignedInt14Member a, UnsignedInt14Member b, UnsignedInt14Member m) {
            m.setV(a.v % b.v);
        }
    };
    private final Procedure4<UnsignedInt14Member, UnsignedInt14Member, UnsignedInt14Member, UnsignedInt14Member> DIVMOD = new Procedure4<UnsignedInt14Member, UnsignedInt14Member, UnsignedInt14Member, UnsignedInt14Member>(){

        @Override
        public void call(UnsignedInt14Member a, UnsignedInt14Member b, UnsignedInt14Member d, UnsignedInt14Member m) {
            UnsignedInt14Algebra.this.div().call(a, b, d);
            UnsignedInt14Algebra.this.mod().call(a, b, m);
        }
    };
    private final Procedure2<UnsignedInt14Member, UnsignedInt14Member> PRED = new Procedure2<UnsignedInt14Member, UnsignedInt14Member>(){

        @Override
        public void call(UnsignedInt14Member a, UnsignedInt14Member b) {
            if (a.v == 0) {
                b.v = (short)16383;
            } else {
                b.setV(a.v - 1);
            }
        }
    };
    private final Procedure2<UnsignedInt14Member, UnsignedInt14Member> SUCC = new Procedure2<UnsignedInt14Member, UnsignedInt14Member>(){

        @Override
        public void call(UnsignedInt14Member a, UnsignedInt14Member b) {
            if (a.v == 16383) {
                b.v = 0;
            } else {
                b.setV(a.v + 1);
            }
        }
    };
    private final Procedure3<UnsignedInt14Member, UnsignedInt14Member, UnsignedInt14Member> POW = new Procedure3<UnsignedInt14Member, UnsignedInt14Member, UnsignedInt14Member>(){

        @Override
        public void call(UnsignedInt14Member a, UnsignedInt14Member b, UnsignedInt14Member c) {
            PowerNonNegative.compute(G.UINT14, b.v, a, c);
        }
    };
    private final Procedure1<UnsignedInt14Member> RAND = new Procedure1<UnsignedInt14Member>(){

        @Override
        public void call(UnsignedInt14Member a) {
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            a.setV(rng.nextInt(16384));
        }
    };
    private final Procedure3<UnsignedInt14Member, UnsignedInt14Member, UnsignedInt14Member> AND = new Procedure3<UnsignedInt14Member, UnsignedInt14Member, UnsignedInt14Member>(){

        @Override
        public void call(UnsignedInt14Member a, UnsignedInt14Member b, UnsignedInt14Member c) {
            c.setV(a.v & b.v);
        }
    };
    private final Procedure3<UnsignedInt14Member, UnsignedInt14Member, UnsignedInt14Member> OR = new Procedure3<UnsignedInt14Member, UnsignedInt14Member, UnsignedInt14Member>(){

        @Override
        public void call(UnsignedInt14Member a, UnsignedInt14Member b, UnsignedInt14Member c) {
            c.setV(a.v | b.v);
        }
    };
    private final Procedure3<UnsignedInt14Member, UnsignedInt14Member, UnsignedInt14Member> XOR = new Procedure3<UnsignedInt14Member, UnsignedInt14Member, UnsignedInt14Member>(){

        @Override
        public void call(UnsignedInt14Member a, UnsignedInt14Member b, UnsignedInt14Member c) {
            c.setV(a.v ^ b.v);
        }
    };
    private final Procedure2<UnsignedInt14Member, UnsignedInt14Member> NOT = new Procedure2<UnsignedInt14Member, UnsignedInt14Member>(){

        @Override
        public void call(UnsignedInt14Member a, UnsignedInt14Member b) {
            b.setV(~a.v);
        }
    };
    private final Procedure3<UnsignedInt14Member, UnsignedInt14Member, UnsignedInt14Member> ANDNOT = new Procedure3<UnsignedInt14Member, UnsignedInt14Member, UnsignedInt14Member>(){

        @Override
        public void call(UnsignedInt14Member a, UnsignedInt14Member b, UnsignedInt14Member c) {
            c.setV(a.v & ~b.v);
        }
    };
    private final Procedure3<java.lang.Integer, UnsignedInt14Member, UnsignedInt14Member> SHL = new Procedure3<java.lang.Integer, UnsignedInt14Member, UnsignedInt14Member>(){

        @Override
        public void call(java.lang.Integer count, UnsignedInt14Member a, UnsignedInt14Member b) {
            if (count < 0) {
                UnsignedInt14Algebra.this.bitShiftRight().call(-count.intValue(), a, b);
            } else {
                count = count % 14;
                b.setV(a.v << count);
            }
        }
    };
    private final Procedure3<java.lang.Integer, UnsignedInt14Member, UnsignedInt14Member> SHRZ = new Procedure3<java.lang.Integer, UnsignedInt14Member, UnsignedInt14Member>(){

        @Override
        public void call(java.lang.Integer count, UnsignedInt14Member a, UnsignedInt14Member b) {
            if (count < 0) {
                UnsignedInt14Algebra.this.bitShiftLeft().call(-count.intValue(), a, b);
            } else {
                b.setV(a.v >>> count);
            }
        }
    };
    private final Procedure1<UnsignedInt14Member> MAXBOUND = new Procedure1<UnsignedInt14Member>(){

        @Override
        public void call(UnsignedInt14Member a) {
            a.v = (short)16383;
        }
    };
    private final Procedure1<UnsignedInt14Member> MINBOUND = new Procedure1<UnsignedInt14Member>(){

        @Override
        public void call(UnsignedInt14Member a) {
            a.v = 0;
        }
    };
    private final Function1<Boolean, UnsignedInt14Member> ISZERO = new Function1<Boolean, UnsignedInt14Member>(){

        @Override
        public Boolean call(UnsignedInt14Member a) {
            return a.v == 0;
        }
    };
    private final Procedure3<HighPrecisionMember, UnsignedInt14Member, UnsignedInt14Member> SBHP = new Procedure3<HighPrecisionMember, UnsignedInt14Member, UnsignedInt14Member>(){

        @Override
        public void call(HighPrecisionMember a, UnsignedInt14Member b, UnsignedInt14Member c) {
            BigDecimal tmp = a.v();
            tmp = tmp.multiply(new BigDecimal(b.v()));
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<HighPrecisionMember, UnsignedInt14Member, UnsignedInt14Member> SBHPR = new Procedure3<HighPrecisionMember, UnsignedInt14Member, UnsignedInt14Member>(){

        @Override
        public void call(HighPrecisionMember a, UnsignedInt14Member b, UnsignedInt14Member c) {
            BigDecimal tmp = a.v();
            int signum = (tmp = tmp.multiply(new BigDecimal(b.v()))).signum();
            tmp = signum < 0 ? tmp.subtract(G.ONE_HALF) : tmp.add(G.ONE_HALF);
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<RationalMember, UnsignedInt14Member, UnsignedInt14Member> SBR = new Procedure3<RationalMember, UnsignedInt14Member, UnsignedInt14Member>(){

        @Override
        public void call(RationalMember a, UnsignedInt14Member b, UnsignedInt14Member c) {
            BigInteger tmp = BigInteger.valueOf(b.v());
            tmp = tmp.multiply(a.n());
            tmp = tmp.divide(a.d());
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<Double, UnsignedInt14Member, UnsignedInt14Member> SBD = new Procedure3<Double, UnsignedInt14Member, UnsignedInt14Member>(){

        @Override
        public void call(Double a, UnsignedInt14Member b, UnsignedInt14Member c) {
            c.setV((int)(a * (double)b.v()));
        }
    };
    private final Procedure3<Double, UnsignedInt14Member, UnsignedInt14Member> SBDR = new Procedure3<Double, UnsignedInt14Member, UnsignedInt14Member>(){

        @Override
        public void call(Double a, UnsignedInt14Member b, UnsignedInt14Member c) {
            c.setV((int)Math.round(a * (double)b.v()));
        }
    };
    private final Function3<Boolean, UnsignedInt14Member, UnsignedInt14Member, UnsignedInt14Member> WITHIN = new Function3<Boolean, UnsignedInt14Member, UnsignedInt14Member, UnsignedInt14Member>(){

        @Override
        public Boolean call(UnsignedInt14Member tol, UnsignedInt14Member a, UnsignedInt14Member b) {
            return NumberWithin.compute(G.UINT14, tol, a, b);
        }
    };

    @Override
    public UnsignedInt14Member construct() {
        return new UnsignedInt14Member();
    }

    @Override
    public UnsignedInt14Member construct(UnsignedInt14Member other) {
        return new UnsignedInt14Member(other);
    }

    @Override
    public UnsignedInt14Member construct(String str) {
        return new UnsignedInt14Member(str);
    }

    @Override
    public Function2<Boolean, UnsignedInt14Member, UnsignedInt14Member> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, UnsignedInt14Member, UnsignedInt14Member> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<UnsignedInt14Member, UnsignedInt14Member> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure1<UnsignedInt14Member> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<UnsignedInt14Member, UnsignedInt14Member> negate() {
        return this.ASSIGN;
    }

    @Override
    public Procedure3<UnsignedInt14Member, UnsignedInt14Member, UnsignedInt14Member> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<UnsignedInt14Member, UnsignedInt14Member, UnsignedInt14Member> subtract() {
        return this.SUB;
    }

    @Override
    public Procedure3<UnsignedInt14Member, UnsignedInt14Member, UnsignedInt14Member> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt14Member, UnsignedInt14Member> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<UnsignedInt14Member> unity() {
        return this.UNITY;
    }

    @Override
    public Function2<Boolean, UnsignedInt14Member, UnsignedInt14Member> isLess() {
        return this.LESS;
    }

    @Override
    public Function2<Boolean, UnsignedInt14Member, UnsignedInt14Member> isLessEqual() {
        return this.LE;
    }

    @Override
    public Function2<Boolean, UnsignedInt14Member, UnsignedInt14Member> isGreater() {
        return this.GREAT;
    }

    @Override
    public Function2<Boolean, UnsignedInt14Member, UnsignedInt14Member> isGreaterEqual() {
        return this.GE;
    }

    @Override
    public Function2<java.lang.Integer, UnsignedInt14Member, UnsignedInt14Member> compare() {
        return this.CMP;
    }

    @Override
    public Function1<java.lang.Integer, UnsignedInt14Member> signum() {
        return this.SIG;
    }

    @Override
    public Procedure3<UnsignedInt14Member, UnsignedInt14Member, UnsignedInt14Member> min() {
        return this.MIN;
    }

    @Override
    public Procedure3<UnsignedInt14Member, UnsignedInt14Member, UnsignedInt14Member> max() {
        return this.MAX;
    }

    @Override
    public Procedure2<UnsignedInt14Member, UnsignedInt14Member> abs() {
        return this.ASSIGN;
    }

    @Override
    public Procedure2<UnsignedInt14Member, UnsignedInt14Member> norm() {
        return this.ASSIGN;
    }

    @Override
    public Procedure3<UnsignedInt14Member, UnsignedInt14Member, UnsignedInt14Member> gcd() {
        return this.GCD;
    }

    @Override
    public Procedure3<UnsignedInt14Member, UnsignedInt14Member, UnsignedInt14Member> lcm() {
        return this.LCM;
    }

    @Override
    public Function1<Boolean, UnsignedInt14Member> isEven() {
        return this.EVEN;
    }

    @Override
    public Function1<Boolean, UnsignedInt14Member> isOdd() {
        return this.ODD;
    }

    @Override
    public Procedure3<UnsignedInt14Member, UnsignedInt14Member, UnsignedInt14Member> div() {
        return this.DIV;
    }

    @Override
    public Procedure3<UnsignedInt14Member, UnsignedInt14Member, UnsignedInt14Member> mod() {
        return this.MOD;
    }

    @Override
    public Procedure4<UnsignedInt14Member, UnsignedInt14Member, UnsignedInt14Member, UnsignedInt14Member> divMod() {
        return this.DIVMOD;
    }

    @Override
    public Procedure2<UnsignedInt14Member, UnsignedInt14Member> pred() {
        return this.PRED;
    }

    @Override
    public Procedure2<UnsignedInt14Member, UnsignedInt14Member> succ() {
        return this.SUCC;
    }

    @Override
    public Procedure3<UnsignedInt14Member, UnsignedInt14Member, UnsignedInt14Member> pow() {
        return this.POW;
    }

    @Override
    public Procedure1<UnsignedInt14Member> random() {
        return this.RAND;
    }

    @Override
    public Procedure3<UnsignedInt14Member, UnsignedInt14Member, UnsignedInt14Member> bitAnd() {
        return this.AND;
    }

    @Override
    public Procedure3<UnsignedInt14Member, UnsignedInt14Member, UnsignedInt14Member> bitOr() {
        return this.OR;
    }

    @Override
    public Procedure3<UnsignedInt14Member, UnsignedInt14Member, UnsignedInt14Member> bitXor() {
        return this.XOR;
    }

    @Override
    public Procedure2<UnsignedInt14Member, UnsignedInt14Member> bitNot() {
        return this.NOT;
    }

    @Override
    public Procedure3<UnsignedInt14Member, UnsignedInt14Member, UnsignedInt14Member> bitAndNot() {
        return this.ANDNOT;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt14Member, UnsignedInt14Member> bitShiftLeft() {
        return this.SHL;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt14Member, UnsignedInt14Member> bitShiftRight() {
        return this.SHRZ;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt14Member, UnsignedInt14Member> bitShiftRightFillZero() {
        return this.SHRZ;
    }

    @Override
    public Procedure1<UnsignedInt14Member> maxBound() {
        return this.MAXBOUND;
    }

    @Override
    public Procedure1<UnsignedInt14Member> minBound() {
        return this.MINBOUND;
    }

    @Override
    public Function1<Boolean, UnsignedInt14Member> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<UnsignedInt14Member, UnsignedInt14Member, UnsignedInt14Member> scale() {
        return this.MUL;
    }

    @Override
    public Procedure3<HighPrecisionMember, UnsignedInt14Member, UnsignedInt14Member> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<HighPrecisionMember, UnsignedInt14Member, UnsignedInt14Member> scaleByHighPrecAndRound() {
        return this.SBHPR;
    }

    @Override
    public Procedure3<RationalMember, UnsignedInt14Member, UnsignedInt14Member> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, UnsignedInt14Member, UnsignedInt14Member> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<Double, UnsignedInt14Member, UnsignedInt14Member> scaleByDoubleAndRound() {
        return this.SBDR;
    }

    @Override
    public Function3<Boolean, UnsignedInt14Member, UnsignedInt14Member, UnsignedInt14Member> within() {
        return this.WITHIN;
    }
}

