/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.int15;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.ThreadLocalRandom;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.Gcd;
import nom.bdezonia.zorbage.algorithm.Lcm;
import nom.bdezonia.zorbage.algorithm.NumberWithin;
import nom.bdezonia.zorbage.algorithm.PowerNonNegative;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.BitOperations;
import nom.bdezonia.zorbage.type.algebra.Bounded;
import nom.bdezonia.zorbage.type.algebra.Integer;
import nom.bdezonia.zorbage.type.algebra.Random;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.int15.SignedInt15Member;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class SignedInt15Algebra
implements Integer<SignedInt15Algebra, SignedInt15Member>,
Bounded<SignedInt15Member>,
BitOperations<SignedInt15Member>,
Random<SignedInt15Member>,
Tolerance<SignedInt15Member, SignedInt15Member> {
    private final Function2<Boolean, SignedInt15Member, SignedInt15Member> EQ = new Function2<Boolean, SignedInt15Member, SignedInt15Member>(){

        @Override
        public Boolean call(SignedInt15Member a, SignedInt15Member b) {
            return a.v == b.v;
        }
    };
    private final Function2<Boolean, SignedInt15Member, SignedInt15Member> NEQ = new Function2<Boolean, SignedInt15Member, SignedInt15Member>(){

        @Override
        public Boolean call(SignedInt15Member a, SignedInt15Member b) {
            return a.v != b.v;
        }
    };
    private final Procedure2<SignedInt15Member, SignedInt15Member> ASSIGN = new Procedure2<SignedInt15Member, SignedInt15Member>(){

        @Override
        public void call(SignedInt15Member a, SignedInt15Member b) {
            b.set(a);
        }
    };
    private final Procedure1<SignedInt15Member> ZER = new Procedure1<SignedInt15Member>(){

        @Override
        public void call(SignedInt15Member a) {
            a.v = 0;
        }
    };
    private final Procedure2<SignedInt15Member, SignedInt15Member> NEG = new Procedure2<SignedInt15Member, SignedInt15Member>(){

        @Override
        public void call(SignedInt15Member a, SignedInt15Member b) {
            if (a.v == -16384) {
                throw new IllegalArgumentException("Cannot convert -minint symmetrically");
            }
            b.v = -a.v;
        }
    };
    private final Procedure3<SignedInt15Member, SignedInt15Member, SignedInt15Member> ADD = new Procedure3<SignedInt15Member, SignedInt15Member, SignedInt15Member>(){

        @Override
        public void call(SignedInt15Member a, SignedInt15Member b, SignedInt15Member c) {
            c.setV(a.v + b.v);
        }
    };
    private final Procedure3<SignedInt15Member, SignedInt15Member, SignedInt15Member> SUB = new Procedure3<SignedInt15Member, SignedInt15Member, SignedInt15Member>(){

        @Override
        public void call(SignedInt15Member a, SignedInt15Member b, SignedInt15Member c) {
            c.setV(a.v - b.v);
        }
    };
    private final Procedure3<SignedInt15Member, SignedInt15Member, SignedInt15Member> MUL = new Procedure3<SignedInt15Member, SignedInt15Member, SignedInt15Member>(){

        @Override
        public void call(SignedInt15Member a, SignedInt15Member b, SignedInt15Member c) {
            c.setV(a.v * b.v);
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt15Member, SignedInt15Member> POWER = new Procedure3<java.lang.Integer, SignedInt15Member, SignedInt15Member>(){

        @Override
        public void call(java.lang.Integer power, SignedInt15Member a, SignedInt15Member b) {
            PowerNonNegative.compute(G.INT15, power, a, b);
        }
    };
    private final Procedure1<SignedInt15Member> UNITY = new Procedure1<SignedInt15Member>(){

        @Override
        public void call(SignedInt15Member a) {
            a.v = 1;
        }
    };
    private final Function2<Boolean, SignedInt15Member, SignedInt15Member> LESS = new Function2<Boolean, SignedInt15Member, SignedInt15Member>(){

        @Override
        public Boolean call(SignedInt15Member a, SignedInt15Member b) {
            return a.v < b.v;
        }
    };
    private final Function2<Boolean, SignedInt15Member, SignedInt15Member> LE = new Function2<Boolean, SignedInt15Member, SignedInt15Member>(){

        @Override
        public Boolean call(SignedInt15Member a, SignedInt15Member b) {
            return a.v <= b.v;
        }
    };
    private final Function2<Boolean, SignedInt15Member, SignedInt15Member> GREAT = new Function2<Boolean, SignedInt15Member, SignedInt15Member>(){

        @Override
        public Boolean call(SignedInt15Member a, SignedInt15Member b) {
            return a.v > b.v;
        }
    };
    private final Function2<Boolean, SignedInt15Member, SignedInt15Member> GE = new Function2<Boolean, SignedInt15Member, SignedInt15Member>(){

        @Override
        public Boolean call(SignedInt15Member a, SignedInt15Member b) {
            return a.v >= b.v;
        }
    };
    private final Function2<java.lang.Integer, SignedInt15Member, SignedInt15Member> CMP = new Function2<java.lang.Integer, SignedInt15Member, SignedInt15Member>(){

        @Override
        public java.lang.Integer call(SignedInt15Member a, SignedInt15Member b) {
            if (a.v < b.v) {
                return -1;
            }
            if (a.v > b.v) {
                return 1;
            }
            return 0;
        }
    };
    private final Function1<java.lang.Integer, SignedInt15Member> SIG = new Function1<java.lang.Integer, SignedInt15Member>(){

        @Override
        public java.lang.Integer call(SignedInt15Member a) {
            if (a.v < 0) {
                return -1;
            }
            if (a.v > 0) {
                return 1;
            }
            return 0;
        }
    };
    private final Procedure3<SignedInt15Member, SignedInt15Member, SignedInt15Member> MIN = new Procedure3<SignedInt15Member, SignedInt15Member, SignedInt15Member>(){

        @Override
        public void call(SignedInt15Member a, SignedInt15Member b, SignedInt15Member c) {
            if (a.v < b.v) {
                c.set(a);
            } else {
                c.set(b);
            }
        }
    };
    private final Procedure3<SignedInt15Member, SignedInt15Member, SignedInt15Member> MAX = new Procedure3<SignedInt15Member, SignedInt15Member, SignedInt15Member>(){

        @Override
        public void call(SignedInt15Member a, SignedInt15Member b, SignedInt15Member c) {
            if (a.v > b.v) {
                c.set(a);
            } else {
                c.set(b);
            }
        }
    };
    private final Procedure2<SignedInt15Member, SignedInt15Member> ABS = new Procedure2<SignedInt15Member, SignedInt15Member>(){

        @Override
        public void call(SignedInt15Member a, SignedInt15Member b) {
            if (a.v == -16384) {
                throw new IllegalArgumentException("Cannot convert -minint symmetrically");
            }
            b.v = a.v < 0 ? (short)(-a.v) : a.v;
        }
    };
    private final Procedure3<SignedInt15Member, SignedInt15Member, SignedInt15Member> GCD = new Procedure3<SignedInt15Member, SignedInt15Member, SignedInt15Member>(){

        @Override
        public void call(SignedInt15Member a, SignedInt15Member b, SignedInt15Member c) {
            Gcd.compute(G.INT15, a, b, c);
        }
    };
    private final Procedure3<SignedInt15Member, SignedInt15Member, SignedInt15Member> LCM = new Procedure3<SignedInt15Member, SignedInt15Member, SignedInt15Member>(){

        @Override
        public void call(SignedInt15Member a, SignedInt15Member b, SignedInt15Member c) {
            Lcm.compute(G.INT15, a, b, c);
        }
    };
    private final Function1<Boolean, SignedInt15Member> EVEN = new Function1<Boolean, SignedInt15Member>(){

        @Override
        public Boolean call(SignedInt15Member a) {
            return (a.v & 1) == 0;
        }
    };
    private final Function1<Boolean, SignedInt15Member> ODD = new Function1<Boolean, SignedInt15Member>(){

        @Override
        public Boolean call(SignedInt15Member a) {
            return (a.v & 1) == 1;
        }
    };
    private final Procedure3<SignedInt15Member, SignedInt15Member, SignedInt15Member> DIV = new Procedure3<SignedInt15Member, SignedInt15Member, SignedInt15Member>(){

        @Override
        public void call(SignedInt15Member a, SignedInt15Member b, SignedInt15Member d) {
            if (b.v == -1 && a.v == -16384) {
                throw new IllegalArgumentException("cannot divide minint by -1");
            }
            d.setV(a.v / b.v);
        }
    };
    private final Procedure3<SignedInt15Member, SignedInt15Member, SignedInt15Member> MOD = new Procedure3<SignedInt15Member, SignedInt15Member, SignedInt15Member>(){

        @Override
        public void call(SignedInt15Member a, SignedInt15Member b, SignedInt15Member m) {
            m.setV(a.v % b.v);
        }
    };
    private final Procedure4<SignedInt15Member, SignedInt15Member, SignedInt15Member, SignedInt15Member> DIVMOD = new Procedure4<SignedInt15Member, SignedInt15Member, SignedInt15Member, SignedInt15Member>(){

        @Override
        public void call(SignedInt15Member a, SignedInt15Member b, SignedInt15Member d, SignedInt15Member m) {
            SignedInt15Algebra.this.div().call(a, b, d);
            SignedInt15Algebra.this.mod().call(a, b, m);
        }
    };
    private final Procedure2<SignedInt15Member, SignedInt15Member> PRED = new Procedure2<SignedInt15Member, SignedInt15Member>(){

        @Override
        public void call(SignedInt15Member a, SignedInt15Member b) {
            if (a.v == -16384) {
                b.v = (short)16383;
            } else {
                b.setV(a.v - 1);
            }
        }
    };
    private final Procedure2<SignedInt15Member, SignedInt15Member> SUCC = new Procedure2<SignedInt15Member, SignedInt15Member>(){

        @Override
        public void call(SignedInt15Member a, SignedInt15Member b) {
            if (a.v == 16383) {
                b.v = (short)-16384;
            } else {
                b.setV(a.v + 1);
            }
        }
    };
    private final Procedure3<SignedInt15Member, SignedInt15Member, SignedInt15Member> POW = new Procedure3<SignedInt15Member, SignedInt15Member, SignedInt15Member>(){

        @Override
        public void call(SignedInt15Member a, SignedInt15Member b, SignedInt15Member c) {
            PowerNonNegative.compute(G.INT15, b.v, a, c);
        }
    };
    private final Procedure1<SignedInt15Member> RAND = new Procedure1<SignedInt15Member>(){

        @Override
        public void call(SignedInt15Member a) {
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            a.setV(rng.nextInt(32768) - 16384);
        }
    };
    private final Procedure3<SignedInt15Member, SignedInt15Member, SignedInt15Member> AND = new Procedure3<SignedInt15Member, SignedInt15Member, SignedInt15Member>(){

        @Override
        public void call(SignedInt15Member a, SignedInt15Member b, SignedInt15Member c) {
            c.setV(a.v & b.v);
        }
    };
    private final Procedure3<SignedInt15Member, SignedInt15Member, SignedInt15Member> OR = new Procedure3<SignedInt15Member, SignedInt15Member, SignedInt15Member>(){

        @Override
        public void call(SignedInt15Member a, SignedInt15Member b, SignedInt15Member c) {
            c.setV(a.v | b.v);
        }
    };
    private final Procedure3<SignedInt15Member, SignedInt15Member, SignedInt15Member> XOR = new Procedure3<SignedInt15Member, SignedInt15Member, SignedInt15Member>(){

        @Override
        public void call(SignedInt15Member a, SignedInt15Member b, SignedInt15Member c) {
            c.setV(a.v ^ b.v);
        }
    };
    private final Procedure2<SignedInt15Member, SignedInt15Member> NOT = new Procedure2<SignedInt15Member, SignedInt15Member>(){

        @Override
        public void call(SignedInt15Member a, SignedInt15Member b) {
            b.setV(~a.v);
        }
    };
    private final Procedure3<SignedInt15Member, SignedInt15Member, SignedInt15Member> ANDNOT = new Procedure3<SignedInt15Member, SignedInt15Member, SignedInt15Member>(){

        @Override
        public void call(SignedInt15Member a, SignedInt15Member b, SignedInt15Member c) {
            c.setV(a.v & ~b.v);
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt15Member, SignedInt15Member> SHL = new Procedure3<java.lang.Integer, SignedInt15Member, SignedInt15Member>(){

        @Override
        public void call(java.lang.Integer count, SignedInt15Member a, SignedInt15Member b) {
            if (count < 0) {
                SignedInt15Algebra.this.bitShiftRight().call(-count.intValue(), a, b);
            } else {
                count = count % 15;
                b.setV(a.v << count);
            }
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt15Member, SignedInt15Member> SHR = new Procedure3<java.lang.Integer, SignedInt15Member, SignedInt15Member>(){

        @Override
        public void call(java.lang.Integer count, SignedInt15Member a, SignedInt15Member b) {
            if (count < 0) {
                SignedInt15Algebra.this.bitShiftLeft().call(-count.intValue(), a, b);
            } else {
                int val = a.v >> count;
                if (a.v < 0 && val == 0) {
                    b.v = (short)-1;
                } else {
                    b.setV(val);
                }
            }
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt15Member, SignedInt15Member> SHRZ = new Procedure3<java.lang.Integer, SignedInt15Member, SignedInt15Member>(){

        @Override
        public void call(java.lang.Integer count, SignedInt15Member a, SignedInt15Member b) {
            if (count < 0) {
                SignedInt15Algebra.this.bitShiftLeft().call(-count.intValue(), a, b);
            } else {
                b.setV(a.v >>> count);
            }
        }
    };
    private final Procedure1<SignedInt15Member> MAXBOUND = new Procedure1<SignedInt15Member>(){

        @Override
        public void call(SignedInt15Member a) {
            a.v = (short)16383;
        }
    };
    private final Procedure1<SignedInt15Member> MINBOUND = new Procedure1<SignedInt15Member>(){

        @Override
        public void call(SignedInt15Member a) {
            a.v = (short)-16384;
        }
    };
    private final Function1<Boolean, SignedInt15Member> ISZERO = new Function1<Boolean, SignedInt15Member>(){

        @Override
        public Boolean call(SignedInt15Member a) {
            return a.v == 0;
        }
    };
    private final Procedure3<HighPrecisionMember, SignedInt15Member, SignedInt15Member> SBHP = new Procedure3<HighPrecisionMember, SignedInt15Member, SignedInt15Member>(){

        @Override
        public void call(HighPrecisionMember a, SignedInt15Member b, SignedInt15Member c) {
            BigDecimal tmp = a.v();
            tmp = tmp.multiply(new BigDecimal(b.v()));
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<HighPrecisionMember, SignedInt15Member, SignedInt15Member> SBHPR = new Procedure3<HighPrecisionMember, SignedInt15Member, SignedInt15Member>(){

        @Override
        public void call(HighPrecisionMember a, SignedInt15Member b, SignedInt15Member c) {
            BigDecimal tmp = a.v();
            int signum = (tmp = tmp.multiply(new BigDecimal(b.v()))).signum();
            tmp = signum < 0 ? tmp.subtract(G.ONE_HALF) : tmp.add(G.ONE_HALF);
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<RationalMember, SignedInt15Member, SignedInt15Member> SBR = new Procedure3<RationalMember, SignedInt15Member, SignedInt15Member>(){

        @Override
        public void call(RationalMember a, SignedInt15Member b, SignedInt15Member c) {
            BigInteger tmp = BigInteger.valueOf(b.v());
            tmp = tmp.multiply(a.n());
            tmp = tmp.divide(a.d());
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<Double, SignedInt15Member, SignedInt15Member> SBD = new Procedure3<Double, SignedInt15Member, SignedInt15Member>(){

        @Override
        public void call(Double a, SignedInt15Member b, SignedInt15Member c) {
            c.setV((int)(a * (double)b.v()));
        }
    };
    private final Procedure3<Double, SignedInt15Member, SignedInt15Member> SBDR = new Procedure3<Double, SignedInt15Member, SignedInt15Member>(){

        @Override
        public void call(Double a, SignedInt15Member b, SignedInt15Member c) {
            c.setV((int)Math.round(a * (double)b.v()));
        }
    };
    private final Function3<Boolean, SignedInt15Member, SignedInt15Member, SignedInt15Member> WITHIN = new Function3<Boolean, SignedInt15Member, SignedInt15Member, SignedInt15Member>(){

        @Override
        public Boolean call(SignedInt15Member tol, SignedInt15Member a, SignedInt15Member b) {
            return NumberWithin.compute(G.INT15, tol, a, b);
        }
    };

    @Override
    public SignedInt15Member construct() {
        return new SignedInt15Member();
    }

    @Override
    public SignedInt15Member construct(SignedInt15Member other) {
        return new SignedInt15Member(other);
    }

    @Override
    public SignedInt15Member construct(String str) {
        return new SignedInt15Member(str);
    }

    @Override
    public Function2<Boolean, SignedInt15Member, SignedInt15Member> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, SignedInt15Member, SignedInt15Member> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<SignedInt15Member, SignedInt15Member> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure1<SignedInt15Member> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<SignedInt15Member, SignedInt15Member> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<SignedInt15Member, SignedInt15Member, SignedInt15Member> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<SignedInt15Member, SignedInt15Member, SignedInt15Member> subtract() {
        return this.SUB;
    }

    @Override
    public Procedure3<SignedInt15Member, SignedInt15Member, SignedInt15Member> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt15Member, SignedInt15Member> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<SignedInt15Member> unity() {
        return this.UNITY;
    }

    @Override
    public Function2<Boolean, SignedInt15Member, SignedInt15Member> isLess() {
        return this.LESS;
    }

    @Override
    public Function2<Boolean, SignedInt15Member, SignedInt15Member> isLessEqual() {
        return this.LE;
    }

    @Override
    public Function2<Boolean, SignedInt15Member, SignedInt15Member> isGreater() {
        return this.GREAT;
    }

    @Override
    public Function2<Boolean, SignedInt15Member, SignedInt15Member> isGreaterEqual() {
        return this.GE;
    }

    @Override
    public Function2<java.lang.Integer, SignedInt15Member, SignedInt15Member> compare() {
        return this.CMP;
    }

    @Override
    public Function1<java.lang.Integer, SignedInt15Member> signum() {
        return this.SIG;
    }

    @Override
    public Procedure3<SignedInt15Member, SignedInt15Member, SignedInt15Member> min() {
        return this.MIN;
    }

    @Override
    public Procedure3<SignedInt15Member, SignedInt15Member, SignedInt15Member> max() {
        return this.MAX;
    }

    @Override
    public Procedure2<SignedInt15Member, SignedInt15Member> abs() {
        return this.ABS;
    }

    @Override
    public Procedure2<SignedInt15Member, SignedInt15Member> norm() {
        return this.ABS;
    }

    @Override
    public Procedure3<SignedInt15Member, SignedInt15Member, SignedInt15Member> gcd() {
        return this.GCD;
    }

    @Override
    public Procedure3<SignedInt15Member, SignedInt15Member, SignedInt15Member> lcm() {
        return this.LCM;
    }

    @Override
    public Function1<Boolean, SignedInt15Member> isEven() {
        return this.EVEN;
    }

    @Override
    public Function1<Boolean, SignedInt15Member> isOdd() {
        return this.ODD;
    }

    @Override
    public Procedure3<SignedInt15Member, SignedInt15Member, SignedInt15Member> div() {
        return this.DIV;
    }

    @Override
    public Procedure3<SignedInt15Member, SignedInt15Member, SignedInt15Member> mod() {
        return this.MOD;
    }

    @Override
    public Procedure4<SignedInt15Member, SignedInt15Member, SignedInt15Member, SignedInt15Member> divMod() {
        return this.DIVMOD;
    }

    @Override
    public Procedure2<SignedInt15Member, SignedInt15Member> pred() {
        return this.PRED;
    }

    @Override
    public Procedure2<SignedInt15Member, SignedInt15Member> succ() {
        return this.SUCC;
    }

    @Override
    public Procedure3<SignedInt15Member, SignedInt15Member, SignedInt15Member> pow() {
        return this.POW;
    }

    @Override
    public Procedure1<SignedInt15Member> random() {
        return this.RAND;
    }

    @Override
    public Procedure3<SignedInt15Member, SignedInt15Member, SignedInt15Member> bitAnd() {
        return this.AND;
    }

    @Override
    public Procedure3<SignedInt15Member, SignedInt15Member, SignedInt15Member> bitOr() {
        return this.OR;
    }

    @Override
    public Procedure3<SignedInt15Member, SignedInt15Member, SignedInt15Member> bitXor() {
        return this.XOR;
    }

    @Override
    public Procedure2<SignedInt15Member, SignedInt15Member> bitNot() {
        return this.NOT;
    }

    @Override
    public Procedure3<SignedInt15Member, SignedInt15Member, SignedInt15Member> bitAndNot() {
        return this.ANDNOT;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt15Member, SignedInt15Member> bitShiftLeft() {
        return this.SHL;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt15Member, SignedInt15Member> bitShiftRight() {
        return this.SHR;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt15Member, SignedInt15Member> bitShiftRightFillZero() {
        return this.SHRZ;
    }

    @Override
    public Procedure1<SignedInt15Member> maxBound() {
        return this.MAXBOUND;
    }

    @Override
    public Procedure1<SignedInt15Member> minBound() {
        return this.MINBOUND;
    }

    @Override
    public Function1<Boolean, SignedInt15Member> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<SignedInt15Member, SignedInt15Member, SignedInt15Member> scale() {
        return this.MUL;
    }

    @Override
    public Procedure3<HighPrecisionMember, SignedInt15Member, SignedInt15Member> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<HighPrecisionMember, SignedInt15Member, SignedInt15Member> scaleByHighPrecAndRound() {
        return this.SBHPR;
    }

    @Override
    public Procedure3<RationalMember, SignedInt15Member, SignedInt15Member> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, SignedInt15Member, SignedInt15Member> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<Double, SignedInt15Member, SignedInt15Member> scaleByDoubleAndRound() {
        return this.SBDR;
    }

    @Override
    public Function3<Boolean, SignedInt15Member, SignedInt15Member, SignedInt15Member> within() {
        return this.WITHIN;
    }
}

