/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.int15;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.ThreadLocalRandom;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.Gcd;
import nom.bdezonia.zorbage.algorithm.Lcm;
import nom.bdezonia.zorbage.algorithm.NumberWithin;
import nom.bdezonia.zorbage.algorithm.PowerNonNegative;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.BitOperations;
import nom.bdezonia.zorbage.type.algebra.Bounded;
import nom.bdezonia.zorbage.type.algebra.Integer;
import nom.bdezonia.zorbage.type.algebra.Random;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.int15.UnsignedInt15Member;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class UnsignedInt15Algebra
implements Integer<UnsignedInt15Algebra, UnsignedInt15Member>,
Bounded<UnsignedInt15Member>,
BitOperations<UnsignedInt15Member>,
Random<UnsignedInt15Member>,
Tolerance<UnsignedInt15Member, UnsignedInt15Member> {
    private final Function2<Boolean, UnsignedInt15Member, UnsignedInt15Member> EQ = new Function2<Boolean, UnsignedInt15Member, UnsignedInt15Member>(){

        @Override
        public Boolean call(UnsignedInt15Member a, UnsignedInt15Member b) {
            return a.v == b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt15Member, UnsignedInt15Member> NEQ = new Function2<Boolean, UnsignedInt15Member, UnsignedInt15Member>(){

        @Override
        public Boolean call(UnsignedInt15Member a, UnsignedInt15Member b) {
            return a.v != b.v;
        }
    };
    private final Procedure2<UnsignedInt15Member, UnsignedInt15Member> ASSIGN = new Procedure2<UnsignedInt15Member, UnsignedInt15Member>(){

        @Override
        public void call(UnsignedInt15Member a, UnsignedInt15Member b) {
            b.set(a);
        }
    };
    private final Procedure1<UnsignedInt15Member> ZER = new Procedure1<UnsignedInt15Member>(){

        @Override
        public void call(UnsignedInt15Member a) {
            a.v = 0;
        }
    };
    private final Procedure3<UnsignedInt15Member, UnsignedInt15Member, UnsignedInt15Member> ADD = new Procedure3<UnsignedInt15Member, UnsignedInt15Member, UnsignedInt15Member>(){

        @Override
        public void call(UnsignedInt15Member a, UnsignedInt15Member b, UnsignedInt15Member c) {
            c.setV(a.v + b.v);
        }
    };
    private final Procedure3<UnsignedInt15Member, UnsignedInt15Member, UnsignedInt15Member> SUB = new Procedure3<UnsignedInt15Member, UnsignedInt15Member, UnsignedInt15Member>(){

        @Override
        public void call(UnsignedInt15Member a, UnsignedInt15Member b, UnsignedInt15Member c) {
            c.setV(a.v - b.v);
        }
    };
    private final Procedure3<UnsignedInt15Member, UnsignedInt15Member, UnsignedInt15Member> MUL = new Procedure3<UnsignedInt15Member, UnsignedInt15Member, UnsignedInt15Member>(){

        @Override
        public void call(UnsignedInt15Member a, UnsignedInt15Member b, UnsignedInt15Member c) {
            c.setV(a.v * b.v);
        }
    };
    private final Procedure3<java.lang.Integer, UnsignedInt15Member, UnsignedInt15Member> POWER = new Procedure3<java.lang.Integer, UnsignedInt15Member, UnsignedInt15Member>(){

        @Override
        public void call(java.lang.Integer power, UnsignedInt15Member a, UnsignedInt15Member b) {
            PowerNonNegative.compute(G.UINT15, power, a, b);
        }
    };
    private final Procedure1<UnsignedInt15Member> UNITY = new Procedure1<UnsignedInt15Member>(){

        @Override
        public void call(UnsignedInt15Member a) {
            a.v = 1;
        }
    };
    private final Function2<Boolean, UnsignedInt15Member, UnsignedInt15Member> LESS = new Function2<Boolean, UnsignedInt15Member, UnsignedInt15Member>(){

        @Override
        public Boolean call(UnsignedInt15Member a, UnsignedInt15Member b) {
            return a.v < b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt15Member, UnsignedInt15Member> LE = new Function2<Boolean, UnsignedInt15Member, UnsignedInt15Member>(){

        @Override
        public Boolean call(UnsignedInt15Member a, UnsignedInt15Member b) {
            return a.v <= b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt15Member, UnsignedInt15Member> GREAT = new Function2<Boolean, UnsignedInt15Member, UnsignedInt15Member>(){

        @Override
        public Boolean call(UnsignedInt15Member a, UnsignedInt15Member b) {
            return a.v > b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt15Member, UnsignedInt15Member> GE = new Function2<Boolean, UnsignedInt15Member, UnsignedInt15Member>(){

        @Override
        public Boolean call(UnsignedInt15Member a, UnsignedInt15Member b) {
            return a.v >= b.v;
        }
    };
    private final Function2<java.lang.Integer, UnsignedInt15Member, UnsignedInt15Member> CMP = new Function2<java.lang.Integer, UnsignedInt15Member, UnsignedInt15Member>(){

        @Override
        public java.lang.Integer call(UnsignedInt15Member a, UnsignedInt15Member b) {
            if (a.v < b.v) {
                return -1;
            }
            if (a.v > b.v) {
                return 1;
            }
            return 0;
        }
    };
    private final Function1<java.lang.Integer, UnsignedInt15Member> SIG = new Function1<java.lang.Integer, UnsignedInt15Member>(){

        @Override
        public java.lang.Integer call(UnsignedInt15Member a) {
            if (a.v > 0) {
                return 1;
            }
            return 0;
        }
    };
    private final Procedure3<UnsignedInt15Member, UnsignedInt15Member, UnsignedInt15Member> MIN = new Procedure3<UnsignedInt15Member, UnsignedInt15Member, UnsignedInt15Member>(){

        @Override
        public void call(UnsignedInt15Member a, UnsignedInt15Member b, UnsignedInt15Member c) {
            if (a.v < b.v) {
                c.set(a);
            } else {
                c.set(b);
            }
        }
    };
    private final Procedure3<UnsignedInt15Member, UnsignedInt15Member, UnsignedInt15Member> MAX = new Procedure3<UnsignedInt15Member, UnsignedInt15Member, UnsignedInt15Member>(){

        @Override
        public void call(UnsignedInt15Member a, UnsignedInt15Member b, UnsignedInt15Member c) {
            if (a.v > b.v) {
                c.set(a);
            } else {
                c.set(b);
            }
        }
    };
    private final Procedure3<UnsignedInt15Member, UnsignedInt15Member, UnsignedInt15Member> GCD = new Procedure3<UnsignedInt15Member, UnsignedInt15Member, UnsignedInt15Member>(){

        @Override
        public void call(UnsignedInt15Member a, UnsignedInt15Member b, UnsignedInt15Member c) {
            Gcd.compute(G.UINT15, a, b, c);
        }
    };
    private final Procedure3<UnsignedInt15Member, UnsignedInt15Member, UnsignedInt15Member> LCM = new Procedure3<UnsignedInt15Member, UnsignedInt15Member, UnsignedInt15Member>(){

        @Override
        public void call(UnsignedInt15Member a, UnsignedInt15Member b, UnsignedInt15Member c) {
            Lcm.compute(G.UINT15, a, b, c);
        }
    };
    private final Function1<Boolean, UnsignedInt15Member> EVEN = new Function1<Boolean, UnsignedInt15Member>(){

        @Override
        public Boolean call(UnsignedInt15Member a) {
            return (a.v & 1) == 0;
        }
    };
    private final Function1<Boolean, UnsignedInt15Member> ODD = new Function1<Boolean, UnsignedInt15Member>(){

        @Override
        public Boolean call(UnsignedInt15Member a) {
            return (a.v & 1) == 1;
        }
    };
    private final Procedure3<UnsignedInt15Member, UnsignedInt15Member, UnsignedInt15Member> DIV = new Procedure3<UnsignedInt15Member, UnsignedInt15Member, UnsignedInt15Member>(){

        @Override
        public void call(UnsignedInt15Member a, UnsignedInt15Member b, UnsignedInt15Member d) {
            d.setV(a.v / b.v);
        }
    };
    private final Procedure3<UnsignedInt15Member, UnsignedInt15Member, UnsignedInt15Member> MOD = new Procedure3<UnsignedInt15Member, UnsignedInt15Member, UnsignedInt15Member>(){

        @Override
        public void call(UnsignedInt15Member a, UnsignedInt15Member b, UnsignedInt15Member m) {
            m.setV(a.v % b.v);
        }
    };
    private final Procedure4<UnsignedInt15Member, UnsignedInt15Member, UnsignedInt15Member, UnsignedInt15Member> DIVMOD = new Procedure4<UnsignedInt15Member, UnsignedInt15Member, UnsignedInt15Member, UnsignedInt15Member>(){

        @Override
        public void call(UnsignedInt15Member a, UnsignedInt15Member b, UnsignedInt15Member d, UnsignedInt15Member m) {
            UnsignedInt15Algebra.this.div().call(a, b, d);
            UnsignedInt15Algebra.this.mod().call(a, b, m);
        }
    };
    private final Procedure2<UnsignedInt15Member, UnsignedInt15Member> PRED = new Procedure2<UnsignedInt15Member, UnsignedInt15Member>(){

        @Override
        public void call(UnsignedInt15Member a, UnsignedInt15Member b) {
            if (a.v == 0) {
                b.v = Short.MAX_VALUE;
            } else {
                b.setV(a.v - 1);
            }
        }
    };
    private final Procedure2<UnsignedInt15Member, UnsignedInt15Member> SUCC = new Procedure2<UnsignedInt15Member, UnsignedInt15Member>(){

        @Override
        public void call(UnsignedInt15Member a, UnsignedInt15Member b) {
            if (a.v == Short.MAX_VALUE) {
                b.v = 0;
            } else {
                b.setV(a.v + 1);
            }
        }
    };
    private final Procedure3<UnsignedInt15Member, UnsignedInt15Member, UnsignedInt15Member> POW = new Procedure3<UnsignedInt15Member, UnsignedInt15Member, UnsignedInt15Member>(){

        @Override
        public void call(UnsignedInt15Member a, UnsignedInt15Member b, UnsignedInt15Member c) {
            PowerNonNegative.compute(G.UINT15, b.v, a, c);
        }
    };
    private final Procedure1<UnsignedInt15Member> RAND = new Procedure1<UnsignedInt15Member>(){

        @Override
        public void call(UnsignedInt15Member a) {
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            a.setV(rng.nextInt(32768));
        }
    };
    private final Procedure3<UnsignedInt15Member, UnsignedInt15Member, UnsignedInt15Member> AND = new Procedure3<UnsignedInt15Member, UnsignedInt15Member, UnsignedInt15Member>(){

        @Override
        public void call(UnsignedInt15Member a, UnsignedInt15Member b, UnsignedInt15Member c) {
            c.setV(a.v & b.v);
        }
    };
    private final Procedure3<UnsignedInt15Member, UnsignedInt15Member, UnsignedInt15Member> OR = new Procedure3<UnsignedInt15Member, UnsignedInt15Member, UnsignedInt15Member>(){

        @Override
        public void call(UnsignedInt15Member a, UnsignedInt15Member b, UnsignedInt15Member c) {
            c.setV(a.v | b.v);
        }
    };
    private final Procedure3<UnsignedInt15Member, UnsignedInt15Member, UnsignedInt15Member> XOR = new Procedure3<UnsignedInt15Member, UnsignedInt15Member, UnsignedInt15Member>(){

        @Override
        public void call(UnsignedInt15Member a, UnsignedInt15Member b, UnsignedInt15Member c) {
            c.setV(a.v ^ b.v);
        }
    };
    private final Procedure2<UnsignedInt15Member, UnsignedInt15Member> NOT = new Procedure2<UnsignedInt15Member, UnsignedInt15Member>(){

        @Override
        public void call(UnsignedInt15Member a, UnsignedInt15Member b) {
            b.setV(~a.v);
        }
    };
    private final Procedure3<UnsignedInt15Member, UnsignedInt15Member, UnsignedInt15Member> ANDNOT = new Procedure3<UnsignedInt15Member, UnsignedInt15Member, UnsignedInt15Member>(){

        @Override
        public void call(UnsignedInt15Member a, UnsignedInt15Member b, UnsignedInt15Member c) {
            c.setV(a.v & ~b.v);
        }
    };
    private final Procedure3<java.lang.Integer, UnsignedInt15Member, UnsignedInt15Member> SHL = new Procedure3<java.lang.Integer, UnsignedInt15Member, UnsignedInt15Member>(){

        @Override
        public void call(java.lang.Integer count, UnsignedInt15Member a, UnsignedInt15Member b) {
            if (count < 0) {
                UnsignedInt15Algebra.this.bitShiftRight().call(-count.intValue(), a, b);
            } else {
                count = count % 15;
                b.setV(a.v << count);
            }
        }
    };
    private final Procedure3<java.lang.Integer, UnsignedInt15Member, UnsignedInt15Member> SHRZ = new Procedure3<java.lang.Integer, UnsignedInt15Member, UnsignedInt15Member>(){

        @Override
        public void call(java.lang.Integer count, UnsignedInt15Member a, UnsignedInt15Member b) {
            if (count < 0) {
                UnsignedInt15Algebra.this.bitShiftLeft().call(-count.intValue(), a, b);
            } else {
                b.setV(a.v >>> count);
            }
        }
    };
    private final Procedure1<UnsignedInt15Member> MAXBOUND = new Procedure1<UnsignedInt15Member>(){

        @Override
        public void call(UnsignedInt15Member a) {
            a.v = Short.MAX_VALUE;
        }
    };
    private final Procedure1<UnsignedInt15Member> MINBOUND = new Procedure1<UnsignedInt15Member>(){

        @Override
        public void call(UnsignedInt15Member a) {
            a.v = 0;
        }
    };
    private final Function1<Boolean, UnsignedInt15Member> ISZERO = new Function1<Boolean, UnsignedInt15Member>(){

        @Override
        public Boolean call(UnsignedInt15Member a) {
            return a.v == 0;
        }
    };
    private final Procedure3<HighPrecisionMember, UnsignedInt15Member, UnsignedInt15Member> SBHP = new Procedure3<HighPrecisionMember, UnsignedInt15Member, UnsignedInt15Member>(){

        @Override
        public void call(HighPrecisionMember a, UnsignedInt15Member b, UnsignedInt15Member c) {
            BigDecimal tmp = a.v();
            tmp = tmp.multiply(new BigDecimal(b.v()));
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<HighPrecisionMember, UnsignedInt15Member, UnsignedInt15Member> SBHPR = new Procedure3<HighPrecisionMember, UnsignedInt15Member, UnsignedInt15Member>(){

        @Override
        public void call(HighPrecisionMember a, UnsignedInt15Member b, UnsignedInt15Member c) {
            BigDecimal tmp = a.v();
            int signum = (tmp = tmp.multiply(new BigDecimal(b.v()))).signum();
            tmp = signum < 0 ? tmp.subtract(G.ONE_HALF) : tmp.add(G.ONE_HALF);
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<RationalMember, UnsignedInt15Member, UnsignedInt15Member> SBR = new Procedure3<RationalMember, UnsignedInt15Member, UnsignedInt15Member>(){

        @Override
        public void call(RationalMember a, UnsignedInt15Member b, UnsignedInt15Member c) {
            BigInteger tmp = BigInteger.valueOf(b.v());
            tmp = tmp.multiply(a.n());
            tmp = tmp.divide(a.d());
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<Double, UnsignedInt15Member, UnsignedInt15Member> SBD = new Procedure3<Double, UnsignedInt15Member, UnsignedInt15Member>(){

        @Override
        public void call(Double a, UnsignedInt15Member b, UnsignedInt15Member c) {
            c.setV((int)(a * (double)b.v()));
        }
    };
    private final Procedure3<Double, UnsignedInt15Member, UnsignedInt15Member> SBDR = new Procedure3<Double, UnsignedInt15Member, UnsignedInt15Member>(){

        @Override
        public void call(Double a, UnsignedInt15Member b, UnsignedInt15Member c) {
            c.setV((int)Math.round(a * (double)b.v()));
        }
    };
    private final Function3<Boolean, UnsignedInt15Member, UnsignedInt15Member, UnsignedInt15Member> WITHIN = new Function3<Boolean, UnsignedInt15Member, UnsignedInt15Member, UnsignedInt15Member>(){

        @Override
        public Boolean call(UnsignedInt15Member tol, UnsignedInt15Member a, UnsignedInt15Member b) {
            return NumberWithin.compute(G.UINT15, tol, a, b);
        }
    };

    @Override
    public UnsignedInt15Member construct() {
        return new UnsignedInt15Member();
    }

    @Override
    public UnsignedInt15Member construct(UnsignedInt15Member other) {
        return new UnsignedInt15Member(other);
    }

    @Override
    public UnsignedInt15Member construct(String str) {
        return new UnsignedInt15Member(str);
    }

    @Override
    public Function2<Boolean, UnsignedInt15Member, UnsignedInt15Member> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, UnsignedInt15Member, UnsignedInt15Member> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<UnsignedInt15Member, UnsignedInt15Member> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure1<UnsignedInt15Member> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<UnsignedInt15Member, UnsignedInt15Member> negate() {
        return this.ASSIGN;
    }

    @Override
    public Procedure3<UnsignedInt15Member, UnsignedInt15Member, UnsignedInt15Member> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<UnsignedInt15Member, UnsignedInt15Member, UnsignedInt15Member> subtract() {
        return this.SUB;
    }

    @Override
    public Procedure3<UnsignedInt15Member, UnsignedInt15Member, UnsignedInt15Member> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt15Member, UnsignedInt15Member> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<UnsignedInt15Member> unity() {
        return this.UNITY;
    }

    @Override
    public Function2<Boolean, UnsignedInt15Member, UnsignedInt15Member> isLess() {
        return this.LESS;
    }

    @Override
    public Function2<Boolean, UnsignedInt15Member, UnsignedInt15Member> isLessEqual() {
        return this.LE;
    }

    @Override
    public Function2<Boolean, UnsignedInt15Member, UnsignedInt15Member> isGreater() {
        return this.GREAT;
    }

    @Override
    public Function2<Boolean, UnsignedInt15Member, UnsignedInt15Member> isGreaterEqual() {
        return this.GE;
    }

    @Override
    public Function2<java.lang.Integer, UnsignedInt15Member, UnsignedInt15Member> compare() {
        return this.CMP;
    }

    @Override
    public Function1<java.lang.Integer, UnsignedInt15Member> signum() {
        return this.SIG;
    }

    @Override
    public Procedure3<UnsignedInt15Member, UnsignedInt15Member, UnsignedInt15Member> min() {
        return this.MIN;
    }

    @Override
    public Procedure3<UnsignedInt15Member, UnsignedInt15Member, UnsignedInt15Member> max() {
        return this.MAX;
    }

    @Override
    public Procedure2<UnsignedInt15Member, UnsignedInt15Member> abs() {
        return this.ASSIGN;
    }

    @Override
    public Procedure2<UnsignedInt15Member, UnsignedInt15Member> norm() {
        return this.ASSIGN;
    }

    @Override
    public Procedure3<UnsignedInt15Member, UnsignedInt15Member, UnsignedInt15Member> gcd() {
        return this.GCD;
    }

    @Override
    public Procedure3<UnsignedInt15Member, UnsignedInt15Member, UnsignedInt15Member> lcm() {
        return this.LCM;
    }

    @Override
    public Function1<Boolean, UnsignedInt15Member> isEven() {
        return this.EVEN;
    }

    @Override
    public Function1<Boolean, UnsignedInt15Member> isOdd() {
        return this.ODD;
    }

    @Override
    public Procedure3<UnsignedInt15Member, UnsignedInt15Member, UnsignedInt15Member> div() {
        return this.DIV;
    }

    @Override
    public Procedure3<UnsignedInt15Member, UnsignedInt15Member, UnsignedInt15Member> mod() {
        return this.MOD;
    }

    @Override
    public Procedure4<UnsignedInt15Member, UnsignedInt15Member, UnsignedInt15Member, UnsignedInt15Member> divMod() {
        return this.DIVMOD;
    }

    @Override
    public Procedure2<UnsignedInt15Member, UnsignedInt15Member> pred() {
        return this.PRED;
    }

    @Override
    public Procedure2<UnsignedInt15Member, UnsignedInt15Member> succ() {
        return this.SUCC;
    }

    @Override
    public Procedure3<UnsignedInt15Member, UnsignedInt15Member, UnsignedInt15Member> pow() {
        return this.POW;
    }

    @Override
    public Procedure1<UnsignedInt15Member> random() {
        return this.RAND;
    }

    @Override
    public Procedure3<UnsignedInt15Member, UnsignedInt15Member, UnsignedInt15Member> bitAnd() {
        return this.AND;
    }

    @Override
    public Procedure3<UnsignedInt15Member, UnsignedInt15Member, UnsignedInt15Member> bitOr() {
        return this.OR;
    }

    @Override
    public Procedure3<UnsignedInt15Member, UnsignedInt15Member, UnsignedInt15Member> bitXor() {
        return this.XOR;
    }

    @Override
    public Procedure2<UnsignedInt15Member, UnsignedInt15Member> bitNot() {
        return this.NOT;
    }

    @Override
    public Procedure3<UnsignedInt15Member, UnsignedInt15Member, UnsignedInt15Member> bitAndNot() {
        return this.ANDNOT;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt15Member, UnsignedInt15Member> bitShiftLeft() {
        return this.SHL;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt15Member, UnsignedInt15Member> bitShiftRight() {
        return this.SHRZ;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt15Member, UnsignedInt15Member> bitShiftRightFillZero() {
        return this.SHRZ;
    }

    @Override
    public Procedure1<UnsignedInt15Member> maxBound() {
        return this.MAXBOUND;
    }

    @Override
    public Procedure1<UnsignedInt15Member> minBound() {
        return this.MINBOUND;
    }

    @Override
    public Function1<Boolean, UnsignedInt15Member> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<UnsignedInt15Member, UnsignedInt15Member, UnsignedInt15Member> scale() {
        return this.MUL;
    }

    @Override
    public Procedure3<HighPrecisionMember, UnsignedInt15Member, UnsignedInt15Member> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<HighPrecisionMember, UnsignedInt15Member, UnsignedInt15Member> scaleByHighPrecAndRound() {
        return this.SBHPR;
    }

    @Override
    public Procedure3<RationalMember, UnsignedInt15Member, UnsignedInt15Member> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, UnsignedInt15Member, UnsignedInt15Member> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<Double, UnsignedInt15Member, UnsignedInt15Member> scaleByDoubleAndRound() {
        return this.SBDR;
    }

    @Override
    public Function3<Boolean, UnsignedInt15Member, UnsignedInt15Member, UnsignedInt15Member> within() {
        return this.WITHIN;
    }
}

