/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.int16;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.ThreadLocalRandom;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.Gcd;
import nom.bdezonia.zorbage.algorithm.Lcm;
import nom.bdezonia.zorbage.algorithm.Max;
import nom.bdezonia.zorbage.algorithm.Min;
import nom.bdezonia.zorbage.algorithm.NumberWithin;
import nom.bdezonia.zorbage.algorithm.PowerNonNegative;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.BitOperations;
import nom.bdezonia.zorbage.type.algebra.Bounded;
import nom.bdezonia.zorbage.type.algebra.Integer;
import nom.bdezonia.zorbage.type.algebra.Random;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.int16.SignedInt16Member;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class SignedInt16Algebra
implements Integer<SignedInt16Algebra, SignedInt16Member>,
Bounded<SignedInt16Member>,
BitOperations<SignedInt16Member>,
Random<SignedInt16Member>,
Tolerance<SignedInt16Member, SignedInt16Member> {
    private final Function2<Boolean, SignedInt16Member, SignedInt16Member> EQ = new Function2<Boolean, SignedInt16Member, SignedInt16Member>(){

        @Override
        public Boolean call(SignedInt16Member a, SignedInt16Member b) {
            return a.v() == b.v();
        }
    };
    private final Function2<Boolean, SignedInt16Member, SignedInt16Member> NEQ = new Function2<Boolean, SignedInt16Member, SignedInt16Member>(){

        @Override
        public Boolean call(SignedInt16Member a, SignedInt16Member b) {
            return a.v() != b.v();
        }
    };
    private final Procedure2<SignedInt16Member, SignedInt16Member> ASSIGN = new Procedure2<SignedInt16Member, SignedInt16Member>(){

        @Override
        public void call(SignedInt16Member from, SignedInt16Member to) {
            to.v = from.v;
        }
    };
    private final Procedure2<SignedInt16Member, SignedInt16Member> ABS = new Procedure2<SignedInt16Member, SignedInt16Member>(){

        @Override
        public void call(SignedInt16Member a, SignedInt16Member b) {
            if (a.v() == Short.MIN_VALUE) {
                throw new IllegalArgumentException("Cannot convert -minint symmetrically");
            }
            b.setV(Math.abs(a.v()));
        }
    };
    private final Procedure3<SignedInt16Member, SignedInt16Member, SignedInt16Member> MUL = new Procedure3<SignedInt16Member, SignedInt16Member, SignedInt16Member>(){

        @Override
        public void call(SignedInt16Member a, SignedInt16Member b, SignedInt16Member c) {
            c.setV(a.v() * b.v());
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt16Member, SignedInt16Member> POWER = new Procedure3<java.lang.Integer, SignedInt16Member, SignedInt16Member>(){

        @Override
        public void call(java.lang.Integer power, SignedInt16Member a, SignedInt16Member b) {
            PowerNonNegative.compute(G.INT16, power, a, b);
        }
    };
    private final Procedure1<SignedInt16Member> ZER = new Procedure1<SignedInt16Member>(){

        @Override
        public void call(SignedInt16Member a) {
            a.v = 0;
        }
    };
    private final Procedure2<SignedInt16Member, SignedInt16Member> NEG = new Procedure2<SignedInt16Member, SignedInt16Member>(){

        @Override
        public void call(SignedInt16Member a, SignedInt16Member b) {
            if (a.v() == Short.MIN_VALUE) {
                throw new IllegalArgumentException("Cannot convert -minint symmetrically");
            }
            b.setV(-a.v());
        }
    };
    private final Procedure3<SignedInt16Member, SignedInt16Member, SignedInt16Member> ADD = new Procedure3<SignedInt16Member, SignedInt16Member, SignedInt16Member>(){

        @Override
        public void call(SignedInt16Member a, SignedInt16Member b, SignedInt16Member c) {
            c.setV(a.v() + b.v());
        }
    };
    private final Procedure3<SignedInt16Member, SignedInt16Member, SignedInt16Member> SUB = new Procedure3<SignedInt16Member, SignedInt16Member, SignedInt16Member>(){

        @Override
        public void call(SignedInt16Member a, SignedInt16Member b, SignedInt16Member c) {
            c.setV(a.v() - b.v());
        }
    };
    private final Procedure1<SignedInt16Member> UNITY = new Procedure1<SignedInt16Member>(){

        @Override
        public void call(SignedInt16Member a) {
            a.v = 1;
        }
    };
    private final Function2<Boolean, SignedInt16Member, SignedInt16Member> LESS = new Function2<Boolean, SignedInt16Member, SignedInt16Member>(){

        @Override
        public Boolean call(SignedInt16Member a, SignedInt16Member b) {
            return a.v() < b.v();
        }
    };
    private final Function2<Boolean, SignedInt16Member, SignedInt16Member> LE = new Function2<Boolean, SignedInt16Member, SignedInt16Member>(){

        @Override
        public Boolean call(SignedInt16Member a, SignedInt16Member b) {
            return a.v() <= b.v();
        }
    };
    private final Function2<Boolean, SignedInt16Member, SignedInt16Member> GREAT = new Function2<Boolean, SignedInt16Member, SignedInt16Member>(){

        @Override
        public Boolean call(SignedInt16Member a, SignedInt16Member b) {
            return a.v() > b.v();
        }
    };
    private final Function2<Boolean, SignedInt16Member, SignedInt16Member> GE = new Function2<Boolean, SignedInt16Member, SignedInt16Member>(){

        @Override
        public Boolean call(SignedInt16Member a, SignedInt16Member b) {
            return a.v() >= b.v();
        }
    };
    private final Function2<java.lang.Integer, SignedInt16Member, SignedInt16Member> CMP = new Function2<java.lang.Integer, SignedInt16Member, SignedInt16Member>(){

        @Override
        public java.lang.Integer call(SignedInt16Member a, SignedInt16Member b) {
            if (a.v() < b.v()) {
                return -1;
            }
            if (a.v() > b.v()) {
                return 1;
            }
            return 0;
        }
    };
    private final Function1<java.lang.Integer, SignedInt16Member> SIG = new Function1<java.lang.Integer, SignedInt16Member>(){

        @Override
        public java.lang.Integer call(SignedInt16Member a) {
            if (a.v() < 0) {
                return -1;
            }
            if (a.v() > 0) {
                return 1;
            }
            return 0;
        }
    };
    private final Procedure3<SignedInt16Member, SignedInt16Member, SignedInt16Member> DIV = new Procedure3<SignedInt16Member, SignedInt16Member, SignedInt16Member>(){

        @Override
        public void call(SignedInt16Member a, SignedInt16Member b, SignedInt16Member d) {
            if (b.v() == -1 && a.v() == Short.MIN_VALUE) {
                throw new IllegalArgumentException("cannot divide minint by -1");
            }
            d.setV(a.v() / b.v());
        }
    };
    private final Procedure3<SignedInt16Member, SignedInt16Member, SignedInt16Member> MOD = new Procedure3<SignedInt16Member, SignedInt16Member, SignedInt16Member>(){

        @Override
        public void call(SignedInt16Member a, SignedInt16Member b, SignedInt16Member m) {
            m.setV(a.v() % b.v());
        }
    };
    private final Procedure4<SignedInt16Member, SignedInt16Member, SignedInt16Member, SignedInt16Member> DIVMOD = new Procedure4<SignedInt16Member, SignedInt16Member, SignedInt16Member, SignedInt16Member>(){

        @Override
        public void call(SignedInt16Member a, SignedInt16Member b, SignedInt16Member d, SignedInt16Member m) {
            SignedInt16Algebra.this.div().call(a, b, d);
            SignedInt16Algebra.this.mod().call(a, b, m);
        }
    };
    private final Procedure3<SignedInt16Member, SignedInt16Member, SignedInt16Member> GCD = new Procedure3<SignedInt16Member, SignedInt16Member, SignedInt16Member>(){

        @Override
        public void call(SignedInt16Member a, SignedInt16Member b, SignedInt16Member c) {
            Gcd.compute(G.INT16, a, b, c);
        }
    };
    private final Procedure3<SignedInt16Member, SignedInt16Member, SignedInt16Member> LCM = new Procedure3<SignedInt16Member, SignedInt16Member, SignedInt16Member>(){

        @Override
        public void call(SignedInt16Member a, SignedInt16Member b, SignedInt16Member c) {
            Lcm.compute(G.INT16, a, b, c);
        }
    };
    private final Function1<Boolean, SignedInt16Member> EVEN = new Function1<Boolean, SignedInt16Member>(){

        @Override
        public Boolean call(SignedInt16Member a) {
            return (a.v() & 1) == 0;
        }
    };
    private final Function1<Boolean, SignedInt16Member> ODD = new Function1<Boolean, SignedInt16Member>(){

        @Override
        public Boolean call(SignedInt16Member a) {
            return (a.v() & 1) == 1;
        }
    };
    private final Procedure2<SignedInt16Member, SignedInt16Member> PRED = new Procedure2<SignedInt16Member, SignedInt16Member>(){

        @Override
        public void call(SignedInt16Member a, SignedInt16Member b) {
            b.setV(a.v() - 1);
        }
    };
    private final Procedure2<SignedInt16Member, SignedInt16Member> SUCC = new Procedure2<SignedInt16Member, SignedInt16Member>(){

        @Override
        public void call(SignedInt16Member a, SignedInt16Member b) {
            b.setV(a.v() + 1);
        }
    };
    private final Procedure1<SignedInt16Member> MAXBOUND = new Procedure1<SignedInt16Member>(){

        @Override
        public void call(SignedInt16Member a) {
            a.v = Short.MAX_VALUE;
        }
    };
    private final Procedure1<SignedInt16Member> MINBOUND = new Procedure1<SignedInt16Member>(){

        @Override
        public void call(SignedInt16Member a) {
            a.v = Short.MIN_VALUE;
        }
    };
    private final Procedure3<SignedInt16Member, SignedInt16Member, SignedInt16Member> BITAND = new Procedure3<SignedInt16Member, SignedInt16Member, SignedInt16Member>(){

        @Override
        public void call(SignedInt16Member a, SignedInt16Member b, SignedInt16Member c) {
            c.setV(a.v() & b.v());
        }
    };
    private final Procedure3<SignedInt16Member, SignedInt16Member, SignedInt16Member> BITOR = new Procedure3<SignedInt16Member, SignedInt16Member, SignedInt16Member>(){

        @Override
        public void call(SignedInt16Member a, SignedInt16Member b, SignedInt16Member c) {
            c.setV(a.v() | b.v());
        }
    };
    private final Procedure3<SignedInt16Member, SignedInt16Member, SignedInt16Member> BITXOR = new Procedure3<SignedInt16Member, SignedInt16Member, SignedInt16Member>(){

        @Override
        public void call(SignedInt16Member a, SignedInt16Member b, SignedInt16Member c) {
            c.setV(a.v() ^ b.v());
        }
    };
    private final Procedure2<SignedInt16Member, SignedInt16Member> BITNOT = new Procedure2<SignedInt16Member, SignedInt16Member>(){

        @Override
        public void call(SignedInt16Member a, SignedInt16Member b) {
            b.setV(~a.v());
        }
    };
    private final Procedure3<SignedInt16Member, SignedInt16Member, SignedInt16Member> BITANDNOT = new Procedure3<SignedInt16Member, SignedInt16Member, SignedInt16Member>(){

        @Override
        public void call(SignedInt16Member a, SignedInt16Member b, SignedInt16Member c) {
            c.setV(a.v() & ~b.v());
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt16Member, SignedInt16Member> BITSHL = new Procedure3<java.lang.Integer, SignedInt16Member, SignedInt16Member>(){

        @Override
        public void call(java.lang.Integer count, SignedInt16Member a, SignedInt16Member b) {
            if (count < 0) {
                SignedInt16Algebra.this.bitShiftRight().call(-count.intValue(), a, b);
            } else {
                count = count % 16;
                b.setV(a.v() << count);
            }
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt16Member, SignedInt16Member> BITSHR = new Procedure3<java.lang.Integer, SignedInt16Member, SignedInt16Member>(){

        @Override
        public void call(java.lang.Integer count, SignedInt16Member a, SignedInt16Member b) {
            if (count < 0) {
                SignedInt16Algebra.this.bitShiftLeft().call(-count.intValue(), a, b);
            } else {
                b.setV(a.v() >> count);
            }
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt16Member, SignedInt16Member> BITSHRZ = new Procedure3<java.lang.Integer, SignedInt16Member, SignedInt16Member>(){

        @Override
        public void call(java.lang.Integer count, SignedInt16Member a, SignedInt16Member b) {
            if (count < 0) {
                SignedInt16Algebra.this.bitShiftLeft().call(-count.intValue(), a, b);
            } else {
                b.setV(a.v() >>> count);
            }
        }
    };
    private final Procedure3<SignedInt16Member, SignedInt16Member, SignedInt16Member> MIN = new Procedure3<SignedInt16Member, SignedInt16Member, SignedInt16Member>(){

        @Override
        public void call(SignedInt16Member a, SignedInt16Member b, SignedInt16Member c) {
            Min.compute(G.INT16, a, b, c);
        }
    };
    private final Procedure3<SignedInt16Member, SignedInt16Member, SignedInt16Member> MAX = new Procedure3<SignedInt16Member, SignedInt16Member, SignedInt16Member>(){

        @Override
        public void call(SignedInt16Member a, SignedInt16Member b, SignedInt16Member c) {
            Max.compute(G.INT16, a, b, c);
        }
    };
    private final Procedure1<SignedInt16Member> RAND = new Procedure1<SignedInt16Member>(){

        @Override
        public void call(SignedInt16Member a) {
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            a.setV(rng.nextInt(65536) - 32768);
        }
    };
    private final Procedure3<SignedInt16Member, SignedInt16Member, SignedInt16Member> POW = new Procedure3<SignedInt16Member, SignedInt16Member, SignedInt16Member>(){

        @Override
        public void call(SignedInt16Member a, SignedInt16Member b, SignedInt16Member c) {
            SignedInt16Algebra.this.power().call(java.lang.Integer.valueOf(b.v()), a, c);
        }
    };
    private final Function1<Boolean, SignedInt16Member> ISZERO = new Function1<Boolean, SignedInt16Member>(){

        @Override
        public Boolean call(SignedInt16Member a) {
            return a.v() == 0;
        }
    };
    private final Procedure3<HighPrecisionMember, SignedInt16Member, SignedInt16Member> SBHP = new Procedure3<HighPrecisionMember, SignedInt16Member, SignedInt16Member>(){

        @Override
        public void call(HighPrecisionMember a, SignedInt16Member b, SignedInt16Member c) {
            BigDecimal tmp = a.v();
            tmp = tmp.multiply(new BigDecimal(b.v()));
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<HighPrecisionMember, SignedInt16Member, SignedInt16Member> SBHPR = new Procedure3<HighPrecisionMember, SignedInt16Member, SignedInt16Member>(){

        @Override
        public void call(HighPrecisionMember a, SignedInt16Member b, SignedInt16Member c) {
            BigDecimal tmp = a.v();
            int signum = (tmp = tmp.multiply(new BigDecimal(b.v()))).signum();
            tmp = signum < 0 ? tmp.subtract(G.ONE_HALF) : tmp.add(G.ONE_HALF);
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<RationalMember, SignedInt16Member, SignedInt16Member> SBR = new Procedure3<RationalMember, SignedInt16Member, SignedInt16Member>(){

        @Override
        public void call(RationalMember a, SignedInt16Member b, SignedInt16Member c) {
            BigInteger tmp = BigInteger.valueOf(b.v());
            tmp = tmp.multiply(a.n());
            tmp = tmp.divide(a.d());
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<Double, SignedInt16Member, SignedInt16Member> SBD = new Procedure3<Double, SignedInt16Member, SignedInt16Member>(){

        @Override
        public void call(Double a, SignedInt16Member b, SignedInt16Member c) {
            c.setV((int)(a * (double)b.v()));
        }
    };
    private final Procedure3<Double, SignedInt16Member, SignedInt16Member> SBDR = new Procedure3<Double, SignedInt16Member, SignedInt16Member>(){

        @Override
        public void call(Double a, SignedInt16Member b, SignedInt16Member c) {
            c.setV((int)Math.round(a * (double)b.v()));
        }
    };
    private final Function3<Boolean, SignedInt16Member, SignedInt16Member, SignedInt16Member> WITHIN = new Function3<Boolean, SignedInt16Member, SignedInt16Member, SignedInt16Member>(){

        @Override
        public Boolean call(SignedInt16Member tol, SignedInt16Member a, SignedInt16Member b) {
            return NumberWithin.compute(G.INT16, tol, a, b);
        }
    };

    @Override
    public Function2<Boolean, SignedInt16Member, SignedInt16Member> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, SignedInt16Member, SignedInt16Member> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public SignedInt16Member construct() {
        return new SignedInt16Member();
    }

    @Override
    public SignedInt16Member construct(SignedInt16Member other) {
        return new SignedInt16Member(other);
    }

    @Override
    public SignedInt16Member construct(String s) {
        return new SignedInt16Member(s);
    }

    @Override
    public Procedure2<SignedInt16Member, SignedInt16Member> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure2<SignedInt16Member, SignedInt16Member> abs() {
        return this.ABS;
    }

    @Override
    public Procedure3<SignedInt16Member, SignedInt16Member, SignedInt16Member> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt16Member, SignedInt16Member> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<SignedInt16Member> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<SignedInt16Member, SignedInt16Member> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<SignedInt16Member, SignedInt16Member, SignedInt16Member> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<SignedInt16Member, SignedInt16Member, SignedInt16Member> subtract() {
        return this.SUB;
    }

    @Override
    public Procedure1<SignedInt16Member> unity() {
        return this.UNITY;
    }

    @Override
    public Function2<Boolean, SignedInt16Member, SignedInt16Member> isLess() {
        return this.LESS;
    }

    @Override
    public Function2<Boolean, SignedInt16Member, SignedInt16Member> isLessEqual() {
        return this.LE;
    }

    @Override
    public Function2<Boolean, SignedInt16Member, SignedInt16Member> isGreater() {
        return this.GREAT;
    }

    @Override
    public Function2<Boolean, SignedInt16Member, SignedInt16Member> isGreaterEqual() {
        return this.GE;
    }

    @Override
    public Function2<java.lang.Integer, SignedInt16Member, SignedInt16Member> compare() {
        return this.CMP;
    }

    @Override
    public Function1<java.lang.Integer, SignedInt16Member> signum() {
        return this.SIG;
    }

    @Override
    public Procedure3<SignedInt16Member, SignedInt16Member, SignedInt16Member> div() {
        return this.DIV;
    }

    @Override
    public Procedure3<SignedInt16Member, SignedInt16Member, SignedInt16Member> mod() {
        return this.MOD;
    }

    @Override
    public Procedure4<SignedInt16Member, SignedInt16Member, SignedInt16Member, SignedInt16Member> divMod() {
        return this.DIVMOD;
    }

    @Override
    public Procedure3<SignedInt16Member, SignedInt16Member, SignedInt16Member> gcd() {
        return this.GCD;
    }

    @Override
    public Procedure3<SignedInt16Member, SignedInt16Member, SignedInt16Member> lcm() {
        return this.LCM;
    }

    @Override
    public Procedure2<SignedInt16Member, SignedInt16Member> norm() {
        return this.ABS;
    }

    @Override
    public Function1<Boolean, SignedInt16Member> isEven() {
        return this.EVEN;
    }

    @Override
    public Function1<Boolean, SignedInt16Member> isOdd() {
        return this.ODD;
    }

    @Override
    public Procedure2<SignedInt16Member, SignedInt16Member> pred() {
        return this.PRED;
    }

    @Override
    public final Procedure2<SignedInt16Member, SignedInt16Member> succ() {
        return this.SUCC;
    }

    @Override
    public Procedure1<SignedInt16Member> maxBound() {
        return this.MAXBOUND;
    }

    @Override
    public Procedure1<SignedInt16Member> minBound() {
        return this.MINBOUND;
    }

    @Override
    public Procedure3<SignedInt16Member, SignedInt16Member, SignedInt16Member> bitAnd() {
        return this.BITAND;
    }

    @Override
    public Procedure3<SignedInt16Member, SignedInt16Member, SignedInt16Member> bitOr() {
        return this.BITOR;
    }

    @Override
    public Procedure3<SignedInt16Member, SignedInt16Member, SignedInt16Member> bitXor() {
        return this.BITXOR;
    }

    @Override
    public Procedure2<SignedInt16Member, SignedInt16Member> bitNot() {
        return this.BITNOT;
    }

    @Override
    public Procedure3<SignedInt16Member, SignedInt16Member, SignedInt16Member> bitAndNot() {
        return this.BITANDNOT;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt16Member, SignedInt16Member> bitShiftLeft() {
        return this.BITSHL;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt16Member, SignedInt16Member> bitShiftRight() {
        return this.BITSHR;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt16Member, SignedInt16Member> bitShiftRightFillZero() {
        return this.BITSHRZ;
    }

    @Override
    public Procedure3<SignedInt16Member, SignedInt16Member, SignedInt16Member> min() {
        return this.MIN;
    }

    @Override
    public Procedure3<SignedInt16Member, SignedInt16Member, SignedInt16Member> max() {
        return this.MAX;
    }

    @Override
    public Procedure1<SignedInt16Member> random() {
        return this.RAND;
    }

    @Override
    public Procedure3<SignedInt16Member, SignedInt16Member, SignedInt16Member> pow() {
        return this.POW;
    }

    @Override
    public Function1<Boolean, SignedInt16Member> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<SignedInt16Member, SignedInt16Member, SignedInt16Member> scale() {
        return this.MUL;
    }

    @Override
    public Procedure3<HighPrecisionMember, SignedInt16Member, SignedInt16Member> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<HighPrecisionMember, SignedInt16Member, SignedInt16Member> scaleByHighPrecAndRound() {
        return this.SBHPR;
    }

    @Override
    public Procedure3<RationalMember, SignedInt16Member, SignedInt16Member> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, SignedInt16Member, SignedInt16Member> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<Double, SignedInt16Member, SignedInt16Member> scaleByDoubleAndRound() {
        return this.SBDR;
    }

    @Override
    public Function3<Boolean, SignedInt16Member, SignedInt16Member, SignedInt16Member> within() {
        return this.WITHIN;
    }
}

