/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.int16;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.ThreadLocalRandom;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.Gcd;
import nom.bdezonia.zorbage.algorithm.Lcm;
import nom.bdezonia.zorbage.algorithm.Max;
import nom.bdezonia.zorbage.algorithm.Min;
import nom.bdezonia.zorbage.algorithm.NumberWithin;
import nom.bdezonia.zorbage.algorithm.PowerNonNegative;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.BitOperations;
import nom.bdezonia.zorbage.type.algebra.Bounded;
import nom.bdezonia.zorbage.type.algebra.Integer;
import nom.bdezonia.zorbage.type.algebra.Random;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.int16.UnsignedInt16Member;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class UnsignedInt16Algebra
implements Integer<UnsignedInt16Algebra, UnsignedInt16Member>,
Bounded<UnsignedInt16Member>,
BitOperations<UnsignedInt16Member>,
Random<UnsignedInt16Member>,
Tolerance<UnsignedInt16Member, UnsignedInt16Member> {
    private final Function2<Boolean, UnsignedInt16Member, UnsignedInt16Member> EQ = new Function2<Boolean, UnsignedInt16Member, UnsignedInt16Member>(){

        @Override
        public Boolean call(UnsignedInt16Member a, UnsignedInt16Member b) {
            return a.v == b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt16Member, UnsignedInt16Member> NEQ = new Function2<Boolean, UnsignedInt16Member, UnsignedInt16Member>(){

        @Override
        public Boolean call(UnsignedInt16Member a, UnsignedInt16Member b) {
            return a.v != b.v;
        }
    };
    private Procedure2<UnsignedInt16Member, UnsignedInt16Member> ASSIGN = new Procedure2<UnsignedInt16Member, UnsignedInt16Member>(){

        @Override
        public void call(UnsignedInt16Member from, UnsignedInt16Member to) {
            to.set(from);
        }
    };
    private final Procedure3<UnsignedInt16Member, UnsignedInt16Member, UnsignedInt16Member> MUL = new Procedure3<UnsignedInt16Member, UnsignedInt16Member, UnsignedInt16Member>(){

        @Override
        public void call(UnsignedInt16Member a, UnsignedInt16Member b, UnsignedInt16Member c) {
            c.setV(a.v() * b.v());
        }
    };
    private final Procedure3<java.lang.Integer, UnsignedInt16Member, UnsignedInt16Member> POWER = new Procedure3<java.lang.Integer, UnsignedInt16Member, UnsignedInt16Member>(){

        @Override
        public void call(java.lang.Integer power, UnsignedInt16Member a, UnsignedInt16Member b) {
            PowerNonNegative.compute(G.UINT16, power, a, b);
        }
    };
    private final Procedure1<UnsignedInt16Member> ZER = new Procedure1<UnsignedInt16Member>(){

        @Override
        public void call(UnsignedInt16Member a) {
            a.setV(0);
        }
    };
    private final Procedure3<UnsignedInt16Member, UnsignedInt16Member, UnsignedInt16Member> ADD = new Procedure3<UnsignedInt16Member, UnsignedInt16Member, UnsignedInt16Member>(){

        @Override
        public void call(UnsignedInt16Member a, UnsignedInt16Member b, UnsignedInt16Member c) {
            c.setV(a.v + b.v);
        }
    };
    private final Procedure3<UnsignedInt16Member, UnsignedInt16Member, UnsignedInt16Member> SUB = new Procedure3<UnsignedInt16Member, UnsignedInt16Member, UnsignedInt16Member>(){

        @Override
        public void call(UnsignedInt16Member a, UnsignedInt16Member b, UnsignedInt16Member c) {
            c.setV(a.v - b.v);
        }
    };
    private final Procedure1<UnsignedInt16Member> UNITY = new Procedure1<UnsignedInt16Member>(){

        @Override
        public void call(UnsignedInt16Member a) {
            a.setV(1);
        }
    };
    private final Function2<Boolean, UnsignedInt16Member, UnsignedInt16Member> LESS = new Function2<Boolean, UnsignedInt16Member, UnsignedInt16Member>(){

        @Override
        public Boolean call(UnsignedInt16Member a, UnsignedInt16Member b) {
            return UnsignedInt16Algebra.this.compare().call(a, b) < 0;
        }
    };
    private final Function2<Boolean, UnsignedInt16Member, UnsignedInt16Member> LE = new Function2<Boolean, UnsignedInt16Member, UnsignedInt16Member>(){

        @Override
        public Boolean call(UnsignedInt16Member a, UnsignedInt16Member b) {
            return UnsignedInt16Algebra.this.compare().call(a, b) <= 0;
        }
    };
    private final Function2<Boolean, UnsignedInt16Member, UnsignedInt16Member> GREAT = new Function2<Boolean, UnsignedInt16Member, UnsignedInt16Member>(){

        @Override
        public Boolean call(UnsignedInt16Member a, UnsignedInt16Member b) {
            return UnsignedInt16Algebra.this.compare().call(a, b) > 0;
        }
    };
    private final Function2<Boolean, UnsignedInt16Member, UnsignedInt16Member> GE = new Function2<Boolean, UnsignedInt16Member, UnsignedInt16Member>(){

        @Override
        public Boolean call(UnsignedInt16Member a, UnsignedInt16Member b) {
            return UnsignedInt16Algebra.this.compare().call(a, b) >= 0;
        }
    };
    private final Function2<java.lang.Integer, UnsignedInt16Member, UnsignedInt16Member> CMP = new Function2<java.lang.Integer, UnsignedInt16Member, UnsignedInt16Member>(){

        @Override
        public java.lang.Integer call(UnsignedInt16Member a, UnsignedInt16Member b) {
            int bv;
            int av = a.v();
            if (av < (bv = b.v())) {
                return -1;
            }
            if (av > bv) {
                return 1;
            }
            return 0;
        }
    };
    private final Function1<java.lang.Integer, UnsignedInt16Member> SIG = new Function1<java.lang.Integer, UnsignedInt16Member>(){

        @Override
        public java.lang.Integer call(UnsignedInt16Member a) {
            if (a.v == 0) {
                return 0;
            }
            return 1;
        }
    };
    private final Procedure3<UnsignedInt16Member, UnsignedInt16Member, UnsignedInt16Member> DIV = new Procedure3<UnsignedInt16Member, UnsignedInt16Member, UnsignedInt16Member>(){

        @Override
        public void call(UnsignedInt16Member a, UnsignedInt16Member b, UnsignedInt16Member d) {
            d.setV(a.v() / b.v());
        }
    };
    private final Procedure3<UnsignedInt16Member, UnsignedInt16Member, UnsignedInt16Member> MOD = new Procedure3<UnsignedInt16Member, UnsignedInt16Member, UnsignedInt16Member>(){

        @Override
        public void call(UnsignedInt16Member a, UnsignedInt16Member b, UnsignedInt16Member m) {
            m.setV(a.v() % b.v());
        }
    };
    private final Procedure4<UnsignedInt16Member, UnsignedInt16Member, UnsignedInt16Member, UnsignedInt16Member> DIVMOD = new Procedure4<UnsignedInt16Member, UnsignedInt16Member, UnsignedInt16Member, UnsignedInt16Member>(){

        @Override
        public void call(UnsignedInt16Member a, UnsignedInt16Member b, UnsignedInt16Member d, UnsignedInt16Member m) {
            UnsignedInt16Algebra.this.div().call(a, b, d);
            UnsignedInt16Algebra.this.mod().call(a, b, m);
        }
    };
    private final Procedure3<UnsignedInt16Member, UnsignedInt16Member, UnsignedInt16Member> GCD = new Procedure3<UnsignedInt16Member, UnsignedInt16Member, UnsignedInt16Member>(){

        @Override
        public void call(UnsignedInt16Member a, UnsignedInt16Member b, UnsignedInt16Member c) {
            Gcd.compute(G.UINT16, a, b, c);
        }
    };
    private final Procedure3<UnsignedInt16Member, UnsignedInt16Member, UnsignedInt16Member> LCM = new Procedure3<UnsignedInt16Member, UnsignedInt16Member, UnsignedInt16Member>(){

        @Override
        public void call(UnsignedInt16Member a, UnsignedInt16Member b, UnsignedInt16Member c) {
            Lcm.compute(G.UINT16, a, b, c);
        }
    };
    private final Function1<Boolean, UnsignedInt16Member> EVEN = new Function1<Boolean, UnsignedInt16Member>(){

        @Override
        public Boolean call(UnsignedInt16Member a) {
            return (a.v & 1) == 0;
        }
    };
    private final Function1<Boolean, UnsignedInt16Member> ODD = new Function1<Boolean, UnsignedInt16Member>(){

        @Override
        public Boolean call(UnsignedInt16Member a) {
            return (a.v & 1) == 1;
        }
    };
    private Procedure2<UnsignedInt16Member, UnsignedInt16Member> PRED = new Procedure2<UnsignedInt16Member, UnsignedInt16Member>(){

        @Override
        public void call(UnsignedInt16Member a, UnsignedInt16Member b) {
            if (a.v == 0) {
                b.setV(65535);
            } else {
                b.setV(a.v() - 1);
            }
        }
    };
    private Procedure2<UnsignedInt16Member, UnsignedInt16Member> SUCC = new Procedure2<UnsignedInt16Member, UnsignedInt16Member>(){

        @Override
        public void call(UnsignedInt16Member a, UnsignedInt16Member b) {
            if (a.v == -1) {
                b.setV(0);
            } else {
                b.setV(a.v() + 1);
            }
        }
    };
    private final Procedure1<UnsignedInt16Member> MAXBOUND = new Procedure1<UnsignedInt16Member>(){

        @Override
        public void call(UnsignedInt16Member a) {
            a.setV(65535);
        }
    };
    private final Procedure1<UnsignedInt16Member> MINBOUND = new Procedure1<UnsignedInt16Member>(){

        @Override
        public void call(UnsignedInt16Member a) {
            a.setV(0);
        }
    };
    private final Procedure3<UnsignedInt16Member, UnsignedInt16Member, UnsignedInt16Member> BITAND = new Procedure3<UnsignedInt16Member, UnsignedInt16Member, UnsignedInt16Member>(){

        @Override
        public void call(UnsignedInt16Member a, UnsignedInt16Member b, UnsignedInt16Member c) {
            c.setV(a.v & b.v);
        }
    };
    private final Procedure3<UnsignedInt16Member, UnsignedInt16Member, UnsignedInt16Member> BITOR = new Procedure3<UnsignedInt16Member, UnsignedInt16Member, UnsignedInt16Member>(){

        @Override
        public void call(UnsignedInt16Member a, UnsignedInt16Member b, UnsignedInt16Member c) {
            c.setV(a.v | b.v);
        }
    };
    private final Procedure3<UnsignedInt16Member, UnsignedInt16Member, UnsignedInt16Member> BITXOR = new Procedure3<UnsignedInt16Member, UnsignedInt16Member, UnsignedInt16Member>(){

        @Override
        public void call(UnsignedInt16Member a, UnsignedInt16Member b, UnsignedInt16Member c) {
            c.setV(a.v ^ b.v);
        }
    };
    private Procedure2<UnsignedInt16Member, UnsignedInt16Member> BITNOT = new Procedure2<UnsignedInt16Member, UnsignedInt16Member>(){

        @Override
        public void call(UnsignedInt16Member a, UnsignedInt16Member b) {
            b.setV(~a.v);
        }
    };
    private final Procedure3<UnsignedInt16Member, UnsignedInt16Member, UnsignedInt16Member> BITANDNOT = new Procedure3<UnsignedInt16Member, UnsignedInt16Member, UnsignedInt16Member>(){

        @Override
        public void call(UnsignedInt16Member a, UnsignedInt16Member b, UnsignedInt16Member c) {
            c.setV(a.v & ~b.v);
        }
    };
    private final Procedure3<java.lang.Integer, UnsignedInt16Member, UnsignedInt16Member> BITSHL = new Procedure3<java.lang.Integer, UnsignedInt16Member, UnsignedInt16Member>(){

        @Override
        public void call(java.lang.Integer count, UnsignedInt16Member a, UnsignedInt16Member b) {
            if (count < 0) {
                UnsignedInt16Algebra.this.bitShiftRight().call(-count.intValue(), a, b);
            } else {
                count = count % 16;
                b.setV(a.v() << count);
            }
        }
    };
    private final Procedure3<java.lang.Integer, UnsignedInt16Member, UnsignedInt16Member> BITSHRZ = new Procedure3<java.lang.Integer, UnsignedInt16Member, UnsignedInt16Member>(){

        @Override
        public void call(java.lang.Integer count, UnsignedInt16Member a, UnsignedInt16Member b) {
            if (count < 0) {
                UnsignedInt16Algebra.this.bitShiftLeft().call(-count.intValue(), a, b);
            } else {
                b.setV(a.v() >>> count);
            }
        }
    };
    private final Procedure3<UnsignedInt16Member, UnsignedInt16Member, UnsignedInt16Member> MIN = new Procedure3<UnsignedInt16Member, UnsignedInt16Member, UnsignedInt16Member>(){

        @Override
        public void call(UnsignedInt16Member a, UnsignedInt16Member b, UnsignedInt16Member c) {
            Min.compute(G.UINT16, a, b, c);
        }
    };
    private final Procedure3<UnsignedInt16Member, UnsignedInt16Member, UnsignedInt16Member> MAX = new Procedure3<UnsignedInt16Member, UnsignedInt16Member, UnsignedInt16Member>(){

        @Override
        public void call(UnsignedInt16Member a, UnsignedInt16Member b, UnsignedInt16Member c) {
            Max.compute(G.UINT16, a, b, c);
        }
    };
    private final Procedure1<UnsignedInt16Member> RAND = new Procedure1<UnsignedInt16Member>(){

        @Override
        public void call(UnsignedInt16Member a) {
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            a.setV(rng.nextInt(65536));
        }
    };
    private final Procedure3<UnsignedInt16Member, UnsignedInt16Member, UnsignedInt16Member> POW = new Procedure3<UnsignedInt16Member, UnsignedInt16Member, UnsignedInt16Member>(){

        @Override
        public void call(UnsignedInt16Member a, UnsignedInt16Member b, UnsignedInt16Member c) {
            UnsignedInt16Algebra.this.power().call(b.v(), a, c);
        }
    };
    private final Function1<Boolean, UnsignedInt16Member> ISZERO = new Function1<Boolean, UnsignedInt16Member>(){

        @Override
        public Boolean call(UnsignedInt16Member a) {
            return a.v == 0;
        }
    };
    private final Procedure3<HighPrecisionMember, UnsignedInt16Member, UnsignedInt16Member> SBHP = new Procedure3<HighPrecisionMember, UnsignedInt16Member, UnsignedInt16Member>(){

        @Override
        public void call(HighPrecisionMember a, UnsignedInt16Member b, UnsignedInt16Member c) {
            BigDecimal tmp = a.v();
            tmp = tmp.multiply(new BigDecimal(b.v()));
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<HighPrecisionMember, UnsignedInt16Member, UnsignedInt16Member> SBHPR = new Procedure3<HighPrecisionMember, UnsignedInt16Member, UnsignedInt16Member>(){

        @Override
        public void call(HighPrecisionMember a, UnsignedInt16Member b, UnsignedInt16Member c) {
            BigDecimal tmp = a.v();
            int signum = (tmp = tmp.multiply(new BigDecimal(b.v()))).signum();
            tmp = signum < 0 ? tmp.subtract(G.ONE_HALF) : tmp.add(G.ONE_HALF);
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<RationalMember, UnsignedInt16Member, UnsignedInt16Member> SBR = new Procedure3<RationalMember, UnsignedInt16Member, UnsignedInt16Member>(){

        @Override
        public void call(RationalMember a, UnsignedInt16Member b, UnsignedInt16Member c) {
            BigInteger tmp = BigInteger.valueOf(b.v());
            tmp = tmp.multiply(a.n());
            tmp = tmp.divide(a.d());
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<Double, UnsignedInt16Member, UnsignedInt16Member> SBD = new Procedure3<Double, UnsignedInt16Member, UnsignedInt16Member>(){

        @Override
        public void call(Double a, UnsignedInt16Member b, UnsignedInt16Member c) {
            c.setV((int)(a * (double)b.v()));
        }
    };
    private final Procedure3<Double, UnsignedInt16Member, UnsignedInt16Member> SBDR = new Procedure3<Double, UnsignedInt16Member, UnsignedInt16Member>(){

        @Override
        public void call(Double a, UnsignedInt16Member b, UnsignedInt16Member c) {
            c.setV((int)Math.round(a * (double)b.v()));
        }
    };
    private final Function3<Boolean, UnsignedInt16Member, UnsignedInt16Member, UnsignedInt16Member> WITHIN = new Function3<Boolean, UnsignedInt16Member, UnsignedInt16Member, UnsignedInt16Member>(){

        @Override
        public Boolean call(UnsignedInt16Member tol, UnsignedInt16Member a, UnsignedInt16Member b) {
            return NumberWithin.compute(G.UINT16, tol, a, b);
        }
    };

    @Override
    public Function2<Boolean, UnsignedInt16Member, UnsignedInt16Member> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, UnsignedInt16Member, UnsignedInt16Member> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public UnsignedInt16Member construct() {
        return new UnsignedInt16Member();
    }

    @Override
    public UnsignedInt16Member construct(UnsignedInt16Member other) {
        return new UnsignedInt16Member(other);
    }

    @Override
    public UnsignedInt16Member construct(String s) {
        return new UnsignedInt16Member(s);
    }

    @Override
    public Procedure2<UnsignedInt16Member, UnsignedInt16Member> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure2<UnsignedInt16Member, UnsignedInt16Member> abs() {
        return this.ASSIGN;
    }

    @Override
    public Procedure3<UnsignedInt16Member, UnsignedInt16Member, UnsignedInt16Member> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt16Member, UnsignedInt16Member> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<UnsignedInt16Member> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<UnsignedInt16Member, UnsignedInt16Member> negate() {
        return this.ASSIGN;
    }

    @Override
    public Procedure3<UnsignedInt16Member, UnsignedInt16Member, UnsignedInt16Member> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<UnsignedInt16Member, UnsignedInt16Member, UnsignedInt16Member> subtract() {
        return this.SUB;
    }

    @Override
    public Procedure1<UnsignedInt16Member> unity() {
        return this.UNITY;
    }

    @Override
    public Function2<Boolean, UnsignedInt16Member, UnsignedInt16Member> isLess() {
        return this.LESS;
    }

    @Override
    public Function2<Boolean, UnsignedInt16Member, UnsignedInt16Member> isLessEqual() {
        return this.LE;
    }

    @Override
    public Function2<Boolean, UnsignedInt16Member, UnsignedInt16Member> isGreater() {
        return this.GREAT;
    }

    @Override
    public Function2<Boolean, UnsignedInt16Member, UnsignedInt16Member> isGreaterEqual() {
        return this.GE;
    }

    @Override
    public Function2<java.lang.Integer, UnsignedInt16Member, UnsignedInt16Member> compare() {
        return this.CMP;
    }

    @Override
    public Function1<java.lang.Integer, UnsignedInt16Member> signum() {
        return this.SIG;
    }

    @Override
    public Procedure3<UnsignedInt16Member, UnsignedInt16Member, UnsignedInt16Member> div() {
        return this.DIV;
    }

    @Override
    public Procedure3<UnsignedInt16Member, UnsignedInt16Member, UnsignedInt16Member> mod() {
        return this.MOD;
    }

    @Override
    public Procedure4<UnsignedInt16Member, UnsignedInt16Member, UnsignedInt16Member, UnsignedInt16Member> divMod() {
        return this.DIVMOD;
    }

    @Override
    public Procedure3<UnsignedInt16Member, UnsignedInt16Member, UnsignedInt16Member> gcd() {
        return this.GCD;
    }

    @Override
    public Procedure3<UnsignedInt16Member, UnsignedInt16Member, UnsignedInt16Member> lcm() {
        return this.LCM;
    }

    @Override
    public Procedure2<UnsignedInt16Member, UnsignedInt16Member> norm() {
        return this.ASSIGN;
    }

    @Override
    public Function1<Boolean, UnsignedInt16Member> isEven() {
        return this.EVEN;
    }

    @Override
    public Function1<Boolean, UnsignedInt16Member> isOdd() {
        return this.ODD;
    }

    @Override
    public Procedure2<UnsignedInt16Member, UnsignedInt16Member> pred() {
        return this.PRED;
    }

    @Override
    public Procedure2<UnsignedInt16Member, UnsignedInt16Member> succ() {
        return this.SUCC;
    }

    @Override
    public Procedure1<UnsignedInt16Member> maxBound() {
        return this.MAXBOUND;
    }

    @Override
    public Procedure1<UnsignedInt16Member> minBound() {
        return this.MINBOUND;
    }

    @Override
    public Procedure3<UnsignedInt16Member, UnsignedInt16Member, UnsignedInt16Member> bitAnd() {
        return this.BITAND;
    }

    @Override
    public Procedure3<UnsignedInt16Member, UnsignedInt16Member, UnsignedInt16Member> bitOr() {
        return this.BITOR;
    }

    @Override
    public Procedure3<UnsignedInt16Member, UnsignedInt16Member, UnsignedInt16Member> bitXor() {
        return this.BITXOR;
    }

    @Override
    public Procedure2<UnsignedInt16Member, UnsignedInt16Member> bitNot() {
        return this.BITNOT;
    }

    @Override
    public Procedure3<UnsignedInt16Member, UnsignedInt16Member, UnsignedInt16Member> bitAndNot() {
        return this.BITANDNOT;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt16Member, UnsignedInt16Member> bitShiftLeft() {
        return this.BITSHL;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt16Member, UnsignedInt16Member> bitShiftRight() {
        return this.BITSHRZ;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt16Member, UnsignedInt16Member> bitShiftRightFillZero() {
        return this.BITSHRZ;
    }

    @Override
    public Procedure3<UnsignedInt16Member, UnsignedInt16Member, UnsignedInt16Member> min() {
        return this.MIN;
    }

    @Override
    public Procedure3<UnsignedInt16Member, UnsignedInt16Member, UnsignedInt16Member> max() {
        return this.MAX;
    }

    @Override
    public Procedure1<UnsignedInt16Member> random() {
        return this.RAND;
    }

    @Override
    public Procedure3<UnsignedInt16Member, UnsignedInt16Member, UnsignedInt16Member> pow() {
        return this.POW;
    }

    @Override
    public Function1<Boolean, UnsignedInt16Member> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<UnsignedInt16Member, UnsignedInt16Member, UnsignedInt16Member> scale() {
        return this.MUL;
    }

    @Override
    public Procedure3<HighPrecisionMember, UnsignedInt16Member, UnsignedInt16Member> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<HighPrecisionMember, UnsignedInt16Member, UnsignedInt16Member> scaleByHighPrecAndRound() {
        return this.SBHPR;
    }

    @Override
    public Procedure3<RationalMember, UnsignedInt16Member, UnsignedInt16Member> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, UnsignedInt16Member, UnsignedInt16Member> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<Double, UnsignedInt16Member, UnsignedInt16Member> scaleByDoubleAndRound() {
        return this.SBDR;
    }

    @Override
    public Function3<Boolean, UnsignedInt16Member, UnsignedInt16Member, UnsignedInt16Member> within() {
        return this.WITHIN;
    }
}

