/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.int2;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.ThreadLocalRandom;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.Gcd;
import nom.bdezonia.zorbage.algorithm.Lcm;
import nom.bdezonia.zorbage.algorithm.NumberWithin;
import nom.bdezonia.zorbage.algorithm.PowerNonNegative;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.BitOperations;
import nom.bdezonia.zorbage.type.algebra.Bounded;
import nom.bdezonia.zorbage.type.algebra.Integer;
import nom.bdezonia.zorbage.type.algebra.Random;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.int2.UnsignedInt2Member;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class UnsignedInt2Algebra
implements Integer<UnsignedInt2Algebra, UnsignedInt2Member>,
Bounded<UnsignedInt2Member>,
BitOperations<UnsignedInt2Member>,
Random<UnsignedInt2Member>,
Tolerance<UnsignedInt2Member, UnsignedInt2Member> {
    private final Function2<Boolean, UnsignedInt2Member, UnsignedInt2Member> EQ = new Function2<Boolean, UnsignedInt2Member, UnsignedInt2Member>(){

        @Override
        public Boolean call(UnsignedInt2Member a, UnsignedInt2Member b) {
            return a.v == b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt2Member, UnsignedInt2Member> NEQ = new Function2<Boolean, UnsignedInt2Member, UnsignedInt2Member>(){

        @Override
        public Boolean call(UnsignedInt2Member a, UnsignedInt2Member b) {
            return a.v != b.v;
        }
    };
    private final Procedure2<UnsignedInt2Member, UnsignedInt2Member> ASSIGN = new Procedure2<UnsignedInt2Member, UnsignedInt2Member>(){

        @Override
        public void call(UnsignedInt2Member a, UnsignedInt2Member b) {
            b.set(a);
        }
    };
    private final Procedure1<UnsignedInt2Member> ZER = new Procedure1<UnsignedInt2Member>(){

        @Override
        public void call(UnsignedInt2Member a) {
            a.v = 0;
        }
    };
    private final Procedure3<UnsignedInt2Member, UnsignedInt2Member, UnsignedInt2Member> ADD = new Procedure3<UnsignedInt2Member, UnsignedInt2Member, UnsignedInt2Member>(){

        @Override
        public void call(UnsignedInt2Member a, UnsignedInt2Member b, UnsignedInt2Member c) {
            c.setV(a.v + b.v);
        }
    };
    private final Procedure3<UnsignedInt2Member, UnsignedInt2Member, UnsignedInt2Member> SUB = new Procedure3<UnsignedInt2Member, UnsignedInt2Member, UnsignedInt2Member>(){

        @Override
        public void call(UnsignedInt2Member a, UnsignedInt2Member b, UnsignedInt2Member c) {
            c.setV(a.v - b.v);
        }
    };
    private final Procedure3<UnsignedInt2Member, UnsignedInt2Member, UnsignedInt2Member> MUL = new Procedure3<UnsignedInt2Member, UnsignedInt2Member, UnsignedInt2Member>(){

        @Override
        public void call(UnsignedInt2Member a, UnsignedInt2Member b, UnsignedInt2Member c) {
            c.setV(a.v * b.v);
        }
    };
    private final Procedure3<java.lang.Integer, UnsignedInt2Member, UnsignedInt2Member> POWER = new Procedure3<java.lang.Integer, UnsignedInt2Member, UnsignedInt2Member>(){

        @Override
        public void call(java.lang.Integer power, UnsignedInt2Member a, UnsignedInt2Member b) {
            PowerNonNegative.compute(G.UINT2, power, a, b);
        }
    };
    private final Procedure1<UnsignedInt2Member> UNITY = new Procedure1<UnsignedInt2Member>(){

        @Override
        public void call(UnsignedInt2Member a) {
            a.v = 1;
        }
    };
    private final Function2<Boolean, UnsignedInt2Member, UnsignedInt2Member> LESS = new Function2<Boolean, UnsignedInt2Member, UnsignedInt2Member>(){

        @Override
        public Boolean call(UnsignedInt2Member a, UnsignedInt2Member b) {
            return a.v < b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt2Member, UnsignedInt2Member> LE = new Function2<Boolean, UnsignedInt2Member, UnsignedInt2Member>(){

        @Override
        public Boolean call(UnsignedInt2Member a, UnsignedInt2Member b) {
            return a.v <= b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt2Member, UnsignedInt2Member> GREAT = new Function2<Boolean, UnsignedInt2Member, UnsignedInt2Member>(){

        @Override
        public Boolean call(UnsignedInt2Member a, UnsignedInt2Member b) {
            return a.v > b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt2Member, UnsignedInt2Member> GE = new Function2<Boolean, UnsignedInt2Member, UnsignedInt2Member>(){

        @Override
        public Boolean call(UnsignedInt2Member a, UnsignedInt2Member b) {
            return a.v >= b.v;
        }
    };
    private final Function2<java.lang.Integer, UnsignedInt2Member, UnsignedInt2Member> CMP = new Function2<java.lang.Integer, UnsignedInt2Member, UnsignedInt2Member>(){

        @Override
        public java.lang.Integer call(UnsignedInt2Member a, UnsignedInt2Member b) {
            if (a.v < b.v) {
                return -1;
            }
            if (a.v > b.v) {
                return 1;
            }
            return 0;
        }
    };
    private final Function1<java.lang.Integer, UnsignedInt2Member> SIG = new Function1<java.lang.Integer, UnsignedInt2Member>(){

        @Override
        public java.lang.Integer call(UnsignedInt2Member a) {
            if (a.v < 0) {
                return -1;
            }
            if (a.v > 0) {
                return 1;
            }
            return 0;
        }
    };
    private final Procedure3<UnsignedInt2Member, UnsignedInt2Member, UnsignedInt2Member> MIN = new Procedure3<UnsignedInt2Member, UnsignedInt2Member, UnsignedInt2Member>(){

        @Override
        public void call(UnsignedInt2Member a, UnsignedInt2Member b, UnsignedInt2Member c) {
            if (a.v < b.v) {
                c.set(a);
            } else {
                c.set(b);
            }
        }
    };
    private final Procedure3<UnsignedInt2Member, UnsignedInt2Member, UnsignedInt2Member> MAX = new Procedure3<UnsignedInt2Member, UnsignedInt2Member, UnsignedInt2Member>(){

        @Override
        public void call(UnsignedInt2Member a, UnsignedInt2Member b, UnsignedInt2Member c) {
            if (a.v > b.v) {
                c.set(a);
            } else {
                c.set(b);
            }
        }
    };
    private final Procedure3<UnsignedInt2Member, UnsignedInt2Member, UnsignedInt2Member> GCD = new Procedure3<UnsignedInt2Member, UnsignedInt2Member, UnsignedInt2Member>(){

        @Override
        public void call(UnsignedInt2Member a, UnsignedInt2Member b, UnsignedInt2Member c) {
            Gcd.compute(G.UINT2, a, b, c);
        }
    };
    private final Procedure3<UnsignedInt2Member, UnsignedInt2Member, UnsignedInt2Member> LCM = new Procedure3<UnsignedInt2Member, UnsignedInt2Member, UnsignedInt2Member>(){

        @Override
        public void call(UnsignedInt2Member a, UnsignedInt2Member b, UnsignedInt2Member c) {
            Lcm.compute(G.UINT2, a, b, c);
        }
    };
    private final Function1<Boolean, UnsignedInt2Member> EVEN = new Function1<Boolean, UnsignedInt2Member>(){

        @Override
        public Boolean call(UnsignedInt2Member a) {
            return (a.v & 1) == 0;
        }
    };
    private final Function1<Boolean, UnsignedInt2Member> ODD = new Function1<Boolean, UnsignedInt2Member>(){

        @Override
        public Boolean call(UnsignedInt2Member a) {
            return (a.v & 1) == 1;
        }
    };
    private final Procedure3<UnsignedInt2Member, UnsignedInt2Member, UnsignedInt2Member> DIV = new Procedure3<UnsignedInt2Member, UnsignedInt2Member, UnsignedInt2Member>(){

        @Override
        public void call(UnsignedInt2Member a, UnsignedInt2Member b, UnsignedInt2Member d) {
            d.setV(a.v / b.v);
        }
    };
    private final Procedure3<UnsignedInt2Member, UnsignedInt2Member, UnsignedInt2Member> MOD = new Procedure3<UnsignedInt2Member, UnsignedInt2Member, UnsignedInt2Member>(){

        @Override
        public void call(UnsignedInt2Member a, UnsignedInt2Member b, UnsignedInt2Member m) {
            m.setV(a.v % b.v);
        }
    };
    private final Procedure4<UnsignedInt2Member, UnsignedInt2Member, UnsignedInt2Member, UnsignedInt2Member> DIVMOD = new Procedure4<UnsignedInt2Member, UnsignedInt2Member, UnsignedInt2Member, UnsignedInt2Member>(){

        @Override
        public void call(UnsignedInt2Member a, UnsignedInt2Member b, UnsignedInt2Member d, UnsignedInt2Member m) {
            UnsignedInt2Algebra.this.div().call(a, b, d);
            UnsignedInt2Algebra.this.mod().call(a, b, m);
        }
    };
    private final Procedure2<UnsignedInt2Member, UnsignedInt2Member> PRED = new Procedure2<UnsignedInt2Member, UnsignedInt2Member>(){

        @Override
        public void call(UnsignedInt2Member a, UnsignedInt2Member b) {
            if (a.v == 0) {
                b.v = (byte)3;
            } else {
                b.setV(a.v - 1);
            }
        }
    };
    private final Procedure2<UnsignedInt2Member, UnsignedInt2Member> SUCC = new Procedure2<UnsignedInt2Member, UnsignedInt2Member>(){

        @Override
        public void call(UnsignedInt2Member a, UnsignedInt2Member b) {
            if (a.v == 3) {
                b.v = 0;
            } else {
                b.setV(a.v + 1);
            }
        }
    };
    private final Procedure3<UnsignedInt2Member, UnsignedInt2Member, UnsignedInt2Member> POW = new Procedure3<UnsignedInt2Member, UnsignedInt2Member, UnsignedInt2Member>(){

        @Override
        public void call(UnsignedInt2Member a, UnsignedInt2Member b, UnsignedInt2Member c) {
            PowerNonNegative.compute(G.UINT2, b.v, a, c);
        }
    };
    private final Procedure1<UnsignedInt2Member> RAND = new Procedure1<UnsignedInt2Member>(){

        @Override
        public void call(UnsignedInt2Member a) {
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            a.setV(rng.nextInt(4));
        }
    };
    private final Procedure3<UnsignedInt2Member, UnsignedInt2Member, UnsignedInt2Member> AND = new Procedure3<UnsignedInt2Member, UnsignedInt2Member, UnsignedInt2Member>(){

        @Override
        public void call(UnsignedInt2Member a, UnsignedInt2Member b, UnsignedInt2Member c) {
            c.setV(a.v & b.v);
        }
    };
    private final Procedure3<UnsignedInt2Member, UnsignedInt2Member, UnsignedInt2Member> OR = new Procedure3<UnsignedInt2Member, UnsignedInt2Member, UnsignedInt2Member>(){

        @Override
        public void call(UnsignedInt2Member a, UnsignedInt2Member b, UnsignedInt2Member c) {
            c.setV(a.v | b.v);
        }
    };
    private final Procedure3<UnsignedInt2Member, UnsignedInt2Member, UnsignedInt2Member> XOR = new Procedure3<UnsignedInt2Member, UnsignedInt2Member, UnsignedInt2Member>(){

        @Override
        public void call(UnsignedInt2Member a, UnsignedInt2Member b, UnsignedInt2Member c) {
            c.setV(a.v ^ b.v);
        }
    };
    private final Procedure2<UnsignedInt2Member, UnsignedInt2Member> NOT = new Procedure2<UnsignedInt2Member, UnsignedInt2Member>(){

        @Override
        public void call(UnsignedInt2Member a, UnsignedInt2Member b) {
            b.setV(~a.v);
        }
    };
    private final Procedure3<UnsignedInt2Member, UnsignedInt2Member, UnsignedInt2Member> ANDNOT = new Procedure3<UnsignedInt2Member, UnsignedInt2Member, UnsignedInt2Member>(){

        @Override
        public void call(UnsignedInt2Member a, UnsignedInt2Member b, UnsignedInt2Member c) {
            c.setV(a.v & ~b.v);
        }
    };
    private final Procedure3<java.lang.Integer, UnsignedInt2Member, UnsignedInt2Member> SHL = new Procedure3<java.lang.Integer, UnsignedInt2Member, UnsignedInt2Member>(){

        @Override
        public void call(java.lang.Integer count, UnsignedInt2Member a, UnsignedInt2Member b) {
            if (count < 0) {
                UnsignedInt2Algebra.this.bitShiftRight().call(-count.intValue(), a, b);
            } else {
                count = count % 2;
                b.setV(a.v << count);
            }
        }
    };
    private final Procedure3<java.lang.Integer, UnsignedInt2Member, UnsignedInt2Member> SHRZ = new Procedure3<java.lang.Integer, UnsignedInt2Member, UnsignedInt2Member>(){

        @Override
        public void call(java.lang.Integer count, UnsignedInt2Member a, UnsignedInt2Member b) {
            if (count < 0) {
                UnsignedInt2Algebra.this.bitShiftLeft().call(-count.intValue(), a, b);
            } else {
                b.setV(a.v >>> count);
            }
        }
    };
    private final Procedure1<UnsignedInt2Member> MAXBOUND = new Procedure1<UnsignedInt2Member>(){

        @Override
        public void call(UnsignedInt2Member a) {
            a.v = (byte)3;
        }
    };
    private final Procedure1<UnsignedInt2Member> MINBOUND = new Procedure1<UnsignedInt2Member>(){

        @Override
        public void call(UnsignedInt2Member a) {
            a.v = 0;
        }
    };
    private final Function1<Boolean, UnsignedInt2Member> ISZERO = new Function1<Boolean, UnsignedInt2Member>(){

        @Override
        public Boolean call(UnsignedInt2Member a) {
            return a.v == 0;
        }
    };
    private final Procedure3<HighPrecisionMember, UnsignedInt2Member, UnsignedInt2Member> SBHP = new Procedure3<HighPrecisionMember, UnsignedInt2Member, UnsignedInt2Member>(){

        @Override
        public void call(HighPrecisionMember a, UnsignedInt2Member b, UnsignedInt2Member c) {
            BigDecimal tmp = a.v();
            tmp = tmp.multiply(new BigDecimal(b.v()));
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<HighPrecisionMember, UnsignedInt2Member, UnsignedInt2Member> SBHPR = new Procedure3<HighPrecisionMember, UnsignedInt2Member, UnsignedInt2Member>(){

        @Override
        public void call(HighPrecisionMember a, UnsignedInt2Member b, UnsignedInt2Member c) {
            BigDecimal tmp = a.v();
            int signum = (tmp = tmp.multiply(new BigDecimal(b.v()))).signum();
            tmp = signum < 0 ? tmp.subtract(G.ONE_HALF) : tmp.add(G.ONE_HALF);
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<RationalMember, UnsignedInt2Member, UnsignedInt2Member> SBR = new Procedure3<RationalMember, UnsignedInt2Member, UnsignedInt2Member>(){

        @Override
        public void call(RationalMember a, UnsignedInt2Member b, UnsignedInt2Member c) {
            BigInteger tmp = BigInteger.valueOf(b.v());
            tmp = tmp.multiply(a.n());
            tmp = tmp.divide(a.d());
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<Double, UnsignedInt2Member, UnsignedInt2Member> SBD = new Procedure3<Double, UnsignedInt2Member, UnsignedInt2Member>(){

        @Override
        public void call(Double a, UnsignedInt2Member b, UnsignedInt2Member c) {
            c.setV((int)(a * (double)b.v()));
        }
    };
    private final Procedure3<Double, UnsignedInt2Member, UnsignedInt2Member> SBDR = new Procedure3<Double, UnsignedInt2Member, UnsignedInt2Member>(){

        @Override
        public void call(Double a, UnsignedInt2Member b, UnsignedInt2Member c) {
            c.setV((int)Math.round(a * (double)b.v()));
        }
    };
    private final Function3<Boolean, UnsignedInt2Member, UnsignedInt2Member, UnsignedInt2Member> WITHIN = new Function3<Boolean, UnsignedInt2Member, UnsignedInt2Member, UnsignedInt2Member>(){

        @Override
        public Boolean call(UnsignedInt2Member tol, UnsignedInt2Member a, UnsignedInt2Member b) {
            return NumberWithin.compute(G.UINT2, tol, a, b);
        }
    };

    @Override
    public UnsignedInt2Member construct() {
        return new UnsignedInt2Member();
    }

    @Override
    public UnsignedInt2Member construct(UnsignedInt2Member other) {
        return new UnsignedInt2Member(other);
    }

    @Override
    public UnsignedInt2Member construct(String str) {
        return new UnsignedInt2Member(str);
    }

    @Override
    public Function2<Boolean, UnsignedInt2Member, UnsignedInt2Member> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, UnsignedInt2Member, UnsignedInt2Member> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<UnsignedInt2Member, UnsignedInt2Member> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure1<UnsignedInt2Member> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<UnsignedInt2Member, UnsignedInt2Member> negate() {
        return this.ASSIGN;
    }

    @Override
    public Procedure3<UnsignedInt2Member, UnsignedInt2Member, UnsignedInt2Member> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<UnsignedInt2Member, UnsignedInt2Member, UnsignedInt2Member> subtract() {
        return this.SUB;
    }

    @Override
    public Procedure3<UnsignedInt2Member, UnsignedInt2Member, UnsignedInt2Member> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt2Member, UnsignedInt2Member> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<UnsignedInt2Member> unity() {
        return this.UNITY;
    }

    @Override
    public Function2<Boolean, UnsignedInt2Member, UnsignedInt2Member> isLess() {
        return this.LESS;
    }

    @Override
    public Function2<Boolean, UnsignedInt2Member, UnsignedInt2Member> isLessEqual() {
        return this.LE;
    }

    @Override
    public Function2<Boolean, UnsignedInt2Member, UnsignedInt2Member> isGreater() {
        return this.GREAT;
    }

    @Override
    public Function2<Boolean, UnsignedInt2Member, UnsignedInt2Member> isGreaterEqual() {
        return this.GE;
    }

    @Override
    public Function2<java.lang.Integer, UnsignedInt2Member, UnsignedInt2Member> compare() {
        return this.CMP;
    }

    @Override
    public Function1<java.lang.Integer, UnsignedInt2Member> signum() {
        return this.SIG;
    }

    @Override
    public Procedure3<UnsignedInt2Member, UnsignedInt2Member, UnsignedInt2Member> min() {
        return this.MIN;
    }

    @Override
    public Procedure3<UnsignedInt2Member, UnsignedInt2Member, UnsignedInt2Member> max() {
        return this.MAX;
    }

    @Override
    public Procedure2<UnsignedInt2Member, UnsignedInt2Member> abs() {
        return this.ASSIGN;
    }

    @Override
    public Procedure2<UnsignedInt2Member, UnsignedInt2Member> norm() {
        return this.ASSIGN;
    }

    @Override
    public Procedure3<UnsignedInt2Member, UnsignedInt2Member, UnsignedInt2Member> gcd() {
        return this.GCD;
    }

    @Override
    public Procedure3<UnsignedInt2Member, UnsignedInt2Member, UnsignedInt2Member> lcm() {
        return this.LCM;
    }

    @Override
    public Function1<Boolean, UnsignedInt2Member> isEven() {
        return this.EVEN;
    }

    @Override
    public Function1<Boolean, UnsignedInt2Member> isOdd() {
        return this.ODD;
    }

    @Override
    public Procedure3<UnsignedInt2Member, UnsignedInt2Member, UnsignedInt2Member> div() {
        return this.DIV;
    }

    @Override
    public Procedure3<UnsignedInt2Member, UnsignedInt2Member, UnsignedInt2Member> mod() {
        return this.MOD;
    }

    @Override
    public Procedure4<UnsignedInt2Member, UnsignedInt2Member, UnsignedInt2Member, UnsignedInt2Member> divMod() {
        return this.DIVMOD;
    }

    @Override
    public Procedure2<UnsignedInt2Member, UnsignedInt2Member> pred() {
        return this.PRED;
    }

    @Override
    public Procedure2<UnsignedInt2Member, UnsignedInt2Member> succ() {
        return this.SUCC;
    }

    @Override
    public Procedure3<UnsignedInt2Member, UnsignedInt2Member, UnsignedInt2Member> pow() {
        return this.POW;
    }

    @Override
    public Procedure1<UnsignedInt2Member> random() {
        return this.RAND;
    }

    @Override
    public Procedure3<UnsignedInt2Member, UnsignedInt2Member, UnsignedInt2Member> bitAnd() {
        return this.AND;
    }

    @Override
    public Procedure3<UnsignedInt2Member, UnsignedInt2Member, UnsignedInt2Member> bitOr() {
        return this.OR;
    }

    @Override
    public Procedure3<UnsignedInt2Member, UnsignedInt2Member, UnsignedInt2Member> bitXor() {
        return this.XOR;
    }

    @Override
    public Procedure2<UnsignedInt2Member, UnsignedInt2Member> bitNot() {
        return this.NOT;
    }

    @Override
    public Procedure3<UnsignedInt2Member, UnsignedInt2Member, UnsignedInt2Member> bitAndNot() {
        return this.ANDNOT;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt2Member, UnsignedInt2Member> bitShiftLeft() {
        return this.SHL;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt2Member, UnsignedInt2Member> bitShiftRight() {
        return this.SHRZ;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt2Member, UnsignedInt2Member> bitShiftRightFillZero() {
        return this.SHRZ;
    }

    @Override
    public Procedure1<UnsignedInt2Member> maxBound() {
        return this.MAXBOUND;
    }

    @Override
    public Procedure1<UnsignedInt2Member> minBound() {
        return this.MINBOUND;
    }

    @Override
    public Function1<Boolean, UnsignedInt2Member> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<UnsignedInt2Member, UnsignedInt2Member, UnsignedInt2Member> scale() {
        return this.MUL;
    }

    @Override
    public Procedure3<HighPrecisionMember, UnsignedInt2Member, UnsignedInt2Member> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<HighPrecisionMember, UnsignedInt2Member, UnsignedInt2Member> scaleByHighPrecAndRound() {
        return this.SBHPR;
    }

    @Override
    public Procedure3<RationalMember, UnsignedInt2Member, UnsignedInt2Member> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, UnsignedInt2Member, UnsignedInt2Member> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<Double, UnsignedInt2Member, UnsignedInt2Member> scaleByDoubleAndRound() {
        return this.SBDR;
    }

    @Override
    public Function3<Boolean, UnsignedInt2Member, UnsignedInt2Member, UnsignedInt2Member> within() {
        return this.WITHIN;
    }
}

