/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.int3;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.ThreadLocalRandom;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.Gcd;
import nom.bdezonia.zorbage.algorithm.Lcm;
import nom.bdezonia.zorbage.algorithm.NumberWithin;
import nom.bdezonia.zorbage.algorithm.PowerNonNegative;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.BitOperations;
import nom.bdezonia.zorbage.type.algebra.Bounded;
import nom.bdezonia.zorbage.type.algebra.Integer;
import nom.bdezonia.zorbage.type.algebra.Random;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.int3.SignedInt3Member;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class SignedInt3Algebra
implements Integer<SignedInt3Algebra, SignedInt3Member>,
Bounded<SignedInt3Member>,
BitOperations<SignedInt3Member>,
Random<SignedInt3Member>,
Tolerance<SignedInt3Member, SignedInt3Member> {
    private final Function2<Boolean, SignedInt3Member, SignedInt3Member> EQ = new Function2<Boolean, SignedInt3Member, SignedInt3Member>(){

        @Override
        public Boolean call(SignedInt3Member a, SignedInt3Member b) {
            return a.v == b.v;
        }
    };
    private final Function2<Boolean, SignedInt3Member, SignedInt3Member> NEQ = new Function2<Boolean, SignedInt3Member, SignedInt3Member>(){

        @Override
        public Boolean call(SignedInt3Member a, SignedInt3Member b) {
            return a.v != b.v;
        }
    };
    private final Procedure2<SignedInt3Member, SignedInt3Member> ASSIGN = new Procedure2<SignedInt3Member, SignedInt3Member>(){

        @Override
        public void call(SignedInt3Member a, SignedInt3Member b) {
            b.set(a);
        }
    };
    private final Procedure1<SignedInt3Member> ZER = new Procedure1<SignedInt3Member>(){

        @Override
        public void call(SignedInt3Member a) {
            a.v = 0;
        }
    };
    private final Procedure2<SignedInt3Member, SignedInt3Member> NEG = new Procedure2<SignedInt3Member, SignedInt3Member>(){

        @Override
        public void call(SignedInt3Member a, SignedInt3Member b) {
            if (a.v == -4) {
                throw new IllegalArgumentException("Cannot convert -minint symmetrically");
            }
            b.v = -a.v;
        }
    };
    private final Procedure3<SignedInt3Member, SignedInt3Member, SignedInt3Member> ADD = new Procedure3<SignedInt3Member, SignedInt3Member, SignedInt3Member>(){

        @Override
        public void call(SignedInt3Member a, SignedInt3Member b, SignedInt3Member c) {
            c.setV(a.v + b.v);
        }
    };
    private final Procedure3<SignedInt3Member, SignedInt3Member, SignedInt3Member> SUB = new Procedure3<SignedInt3Member, SignedInt3Member, SignedInt3Member>(){

        @Override
        public void call(SignedInt3Member a, SignedInt3Member b, SignedInt3Member c) {
            c.setV(a.v - b.v);
        }
    };
    private final Procedure3<SignedInt3Member, SignedInt3Member, SignedInt3Member> MUL = new Procedure3<SignedInt3Member, SignedInt3Member, SignedInt3Member>(){

        @Override
        public void call(SignedInt3Member a, SignedInt3Member b, SignedInt3Member c) {
            c.setV(a.v * b.v);
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt3Member, SignedInt3Member> POWER = new Procedure3<java.lang.Integer, SignedInt3Member, SignedInt3Member>(){

        @Override
        public void call(java.lang.Integer power, SignedInt3Member a, SignedInt3Member b) {
            PowerNonNegative.compute(G.INT3, power, a, b);
        }
    };
    private final Procedure1<SignedInt3Member> UNITY = new Procedure1<SignedInt3Member>(){

        @Override
        public void call(SignedInt3Member a) {
            a.v = 1;
        }
    };
    private final Function2<Boolean, SignedInt3Member, SignedInt3Member> LESS = new Function2<Boolean, SignedInt3Member, SignedInt3Member>(){

        @Override
        public Boolean call(SignedInt3Member a, SignedInt3Member b) {
            return a.v < b.v;
        }
    };
    private final Function2<Boolean, SignedInt3Member, SignedInt3Member> LE = new Function2<Boolean, SignedInt3Member, SignedInt3Member>(){

        @Override
        public Boolean call(SignedInt3Member a, SignedInt3Member b) {
            return a.v <= b.v;
        }
    };
    private final Function2<Boolean, SignedInt3Member, SignedInt3Member> GREAT = new Function2<Boolean, SignedInt3Member, SignedInt3Member>(){

        @Override
        public Boolean call(SignedInt3Member a, SignedInt3Member b) {
            return a.v > b.v;
        }
    };
    private final Function2<Boolean, SignedInt3Member, SignedInt3Member> GE = new Function2<Boolean, SignedInt3Member, SignedInt3Member>(){

        @Override
        public Boolean call(SignedInt3Member a, SignedInt3Member b) {
            return a.v >= b.v;
        }
    };
    private final Function2<java.lang.Integer, SignedInt3Member, SignedInt3Member> CMP = new Function2<java.lang.Integer, SignedInt3Member, SignedInt3Member>(){

        @Override
        public java.lang.Integer call(SignedInt3Member a, SignedInt3Member b) {
            if (a.v < b.v) {
                return -1;
            }
            if (a.v > b.v) {
                return 1;
            }
            return 0;
        }
    };
    private final Function1<java.lang.Integer, SignedInt3Member> SIG = new Function1<java.lang.Integer, SignedInt3Member>(){

        @Override
        public java.lang.Integer call(SignedInt3Member a) {
            if (a.v < 0) {
                return -1;
            }
            if (a.v > 0) {
                return 1;
            }
            return 0;
        }
    };
    private final Procedure3<SignedInt3Member, SignedInt3Member, SignedInt3Member> MIN = new Procedure3<SignedInt3Member, SignedInt3Member, SignedInt3Member>(){

        @Override
        public void call(SignedInt3Member a, SignedInt3Member b, SignedInt3Member c) {
            if (a.v < b.v) {
                c.set(a);
            } else {
                c.set(b);
            }
        }
    };
    private final Procedure3<SignedInt3Member, SignedInt3Member, SignedInt3Member> MAX = new Procedure3<SignedInt3Member, SignedInt3Member, SignedInt3Member>(){

        @Override
        public void call(SignedInt3Member a, SignedInt3Member b, SignedInt3Member c) {
            if (a.v > b.v) {
                c.set(a);
            } else {
                c.set(b);
            }
        }
    };
    private final Procedure2<SignedInt3Member, SignedInt3Member> ABS = new Procedure2<SignedInt3Member, SignedInt3Member>(){

        @Override
        public void call(SignedInt3Member a, SignedInt3Member b) {
            if (a.v == -4) {
                throw new IllegalArgumentException("Cannot convert -minint symmetrically");
            }
            b.v = a.v < 0 ? (byte)(-a.v) : a.v;
        }
    };
    private final Procedure3<SignedInt3Member, SignedInt3Member, SignedInt3Member> GCD = new Procedure3<SignedInt3Member, SignedInt3Member, SignedInt3Member>(){

        @Override
        public void call(SignedInt3Member a, SignedInt3Member b, SignedInt3Member c) {
            Gcd.compute(G.INT3, a, b, c);
        }
    };
    private final Procedure3<SignedInt3Member, SignedInt3Member, SignedInt3Member> LCM = new Procedure3<SignedInt3Member, SignedInt3Member, SignedInt3Member>(){

        @Override
        public void call(SignedInt3Member a, SignedInt3Member b, SignedInt3Member c) {
            Lcm.compute(G.INT3, a, b, c);
        }
    };
    private final Function1<Boolean, SignedInt3Member> EVEN = new Function1<Boolean, SignedInt3Member>(){

        @Override
        public Boolean call(SignedInt3Member a) {
            return (a.v & 1) == 0;
        }
    };
    private final Function1<Boolean, SignedInt3Member> ODD = new Function1<Boolean, SignedInt3Member>(){

        @Override
        public Boolean call(SignedInt3Member a) {
            return (a.v & 1) == 1;
        }
    };
    private final Procedure3<SignedInt3Member, SignedInt3Member, SignedInt3Member> DIV = new Procedure3<SignedInt3Member, SignedInt3Member, SignedInt3Member>(){

        @Override
        public void call(SignedInt3Member a, SignedInt3Member b, SignedInt3Member d) {
            if (b.v == -1 && a.v == -4) {
                throw new IllegalArgumentException("cannot divide minint by -1");
            }
            d.setV(a.v / b.v);
        }
    };
    private final Procedure3<SignedInt3Member, SignedInt3Member, SignedInt3Member> MOD = new Procedure3<SignedInt3Member, SignedInt3Member, SignedInt3Member>(){

        @Override
        public void call(SignedInt3Member a, SignedInt3Member b, SignedInt3Member m) {
            m.setV(a.v % b.v);
        }
    };
    private final Procedure4<SignedInt3Member, SignedInt3Member, SignedInt3Member, SignedInt3Member> DIVMOD = new Procedure4<SignedInt3Member, SignedInt3Member, SignedInt3Member, SignedInt3Member>(){

        @Override
        public void call(SignedInt3Member a, SignedInt3Member b, SignedInt3Member d, SignedInt3Member m) {
            SignedInt3Algebra.this.div().call(a, b, d);
            SignedInt3Algebra.this.mod().call(a, b, m);
        }
    };
    private final Procedure2<SignedInt3Member, SignedInt3Member> PRED = new Procedure2<SignedInt3Member, SignedInt3Member>(){

        @Override
        public void call(SignedInt3Member a, SignedInt3Member b) {
            if (a.v == -4) {
                b.v = (byte)3;
            } else {
                b.setV(a.v - 1);
            }
        }
    };
    private final Procedure2<SignedInt3Member, SignedInt3Member> SUCC = new Procedure2<SignedInt3Member, SignedInt3Member>(){

        @Override
        public void call(SignedInt3Member a, SignedInt3Member b) {
            if (a.v == 3) {
                b.v = (byte)-4;
            } else {
                b.setV(a.v + 1);
            }
        }
    };
    private final Procedure3<SignedInt3Member, SignedInt3Member, SignedInt3Member> POW = new Procedure3<SignedInt3Member, SignedInt3Member, SignedInt3Member>(){

        @Override
        public void call(SignedInt3Member a, SignedInt3Member b, SignedInt3Member c) {
            PowerNonNegative.compute(G.INT3, b.v, a, c);
        }
    };
    private final Procedure1<SignedInt3Member> RAND = new Procedure1<SignedInt3Member>(){

        @Override
        public void call(SignedInt3Member a) {
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            a.setV(rng.nextInt(8) - 4);
        }
    };
    private final Procedure3<SignedInt3Member, SignedInt3Member, SignedInt3Member> AND = new Procedure3<SignedInt3Member, SignedInt3Member, SignedInt3Member>(){

        @Override
        public void call(SignedInt3Member a, SignedInt3Member b, SignedInt3Member c) {
            c.setV(a.v & b.v);
        }
    };
    private final Procedure3<SignedInt3Member, SignedInt3Member, SignedInt3Member> OR = new Procedure3<SignedInt3Member, SignedInt3Member, SignedInt3Member>(){

        @Override
        public void call(SignedInt3Member a, SignedInt3Member b, SignedInt3Member c) {
            c.setV(a.v | b.v);
        }
    };
    private final Procedure3<SignedInt3Member, SignedInt3Member, SignedInt3Member> XOR = new Procedure3<SignedInt3Member, SignedInt3Member, SignedInt3Member>(){

        @Override
        public void call(SignedInt3Member a, SignedInt3Member b, SignedInt3Member c) {
            c.setV(a.v ^ b.v);
        }
    };
    private final Procedure2<SignedInt3Member, SignedInt3Member> NOT = new Procedure2<SignedInt3Member, SignedInt3Member>(){

        @Override
        public void call(SignedInt3Member a, SignedInt3Member b) {
            b.setV(~a.v);
        }
    };
    private final Procedure3<SignedInt3Member, SignedInt3Member, SignedInt3Member> ANDNOT = new Procedure3<SignedInt3Member, SignedInt3Member, SignedInt3Member>(){

        @Override
        public void call(SignedInt3Member a, SignedInt3Member b, SignedInt3Member c) {
            c.setV(a.v & ~b.v);
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt3Member, SignedInt3Member> SHL = new Procedure3<java.lang.Integer, SignedInt3Member, SignedInt3Member>(){

        @Override
        public void call(java.lang.Integer count, SignedInt3Member a, SignedInt3Member b) {
            if (count < 0) {
                SignedInt3Algebra.this.bitShiftRight().call(-count.intValue(), a, b);
            } else {
                count = count % 3;
                b.setV(a.v << count);
            }
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt3Member, SignedInt3Member> SHR = new Procedure3<java.lang.Integer, SignedInt3Member, SignedInt3Member>(){

        @Override
        public void call(java.lang.Integer count, SignedInt3Member a, SignedInt3Member b) {
            if (count < 0) {
                SignedInt3Algebra.this.bitShiftLeft().call(-count.intValue(), a, b);
            } else {
                int val = a.v >> count;
                if (a.v < 0 && val == 0) {
                    b.v = (byte)-1;
                } else {
                    b.setV(val);
                }
            }
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt3Member, SignedInt3Member> SHRZ = new Procedure3<java.lang.Integer, SignedInt3Member, SignedInt3Member>(){

        @Override
        public void call(java.lang.Integer count, SignedInt3Member a, SignedInt3Member b) {
            if (count < 0) {
                SignedInt3Algebra.this.bitShiftLeft().call(-count.intValue(), a, b);
            } else {
                b.setV(a.v >>> count);
            }
        }
    };
    private final Procedure1<SignedInt3Member> MAXBOUND = new Procedure1<SignedInt3Member>(){

        @Override
        public void call(SignedInt3Member a) {
            a.v = (byte)3;
        }
    };
    private final Procedure1<SignedInt3Member> MINBOUND = new Procedure1<SignedInt3Member>(){

        @Override
        public void call(SignedInt3Member a) {
            a.v = (byte)-4;
        }
    };
    private final Function1<Boolean, SignedInt3Member> ISZERO = new Function1<Boolean, SignedInt3Member>(){

        @Override
        public Boolean call(SignedInt3Member a) {
            return a.v == 0;
        }
    };
    private final Procedure3<HighPrecisionMember, SignedInt3Member, SignedInt3Member> SBHP = new Procedure3<HighPrecisionMember, SignedInt3Member, SignedInt3Member>(){

        @Override
        public void call(HighPrecisionMember a, SignedInt3Member b, SignedInt3Member c) {
            BigDecimal tmp = a.v();
            tmp = tmp.multiply(new BigDecimal(b.v()));
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<HighPrecisionMember, SignedInt3Member, SignedInt3Member> SBHPR = new Procedure3<HighPrecisionMember, SignedInt3Member, SignedInt3Member>(){

        @Override
        public void call(HighPrecisionMember a, SignedInt3Member b, SignedInt3Member c) {
            BigDecimal tmp = a.v();
            int signum = (tmp = tmp.multiply(new BigDecimal(b.v()))).signum();
            tmp = signum < 0 ? tmp.subtract(G.ONE_HALF) : tmp.add(G.ONE_HALF);
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<RationalMember, SignedInt3Member, SignedInt3Member> SBR = new Procedure3<RationalMember, SignedInt3Member, SignedInt3Member>(){

        @Override
        public void call(RationalMember a, SignedInt3Member b, SignedInt3Member c) {
            BigInteger tmp = BigInteger.valueOf(b.v());
            tmp = tmp.multiply(a.n());
            tmp = tmp.divide(a.d());
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<Double, SignedInt3Member, SignedInt3Member> SBD = new Procedure3<Double, SignedInt3Member, SignedInt3Member>(){

        @Override
        public void call(Double a, SignedInt3Member b, SignedInt3Member c) {
            c.setV((int)(a * (double)b.v()));
        }
    };
    private final Procedure3<Double, SignedInt3Member, SignedInt3Member> SBDR = new Procedure3<Double, SignedInt3Member, SignedInt3Member>(){

        @Override
        public void call(Double a, SignedInt3Member b, SignedInt3Member c) {
            c.setV((int)Math.round(a * (double)b.v()));
        }
    };
    private final Function3<Boolean, SignedInt3Member, SignedInt3Member, SignedInt3Member> WITHIN = new Function3<Boolean, SignedInt3Member, SignedInt3Member, SignedInt3Member>(){

        @Override
        public Boolean call(SignedInt3Member tol, SignedInt3Member a, SignedInt3Member b) {
            return NumberWithin.compute(G.INT3, tol, a, b);
        }
    };

    @Override
    public SignedInt3Member construct() {
        return new SignedInt3Member();
    }

    @Override
    public SignedInt3Member construct(SignedInt3Member other) {
        return new SignedInt3Member(other);
    }

    @Override
    public SignedInt3Member construct(String str) {
        return new SignedInt3Member(str);
    }

    @Override
    public Function2<Boolean, SignedInt3Member, SignedInt3Member> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, SignedInt3Member, SignedInt3Member> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<SignedInt3Member, SignedInt3Member> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure1<SignedInt3Member> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<SignedInt3Member, SignedInt3Member> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<SignedInt3Member, SignedInt3Member, SignedInt3Member> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<SignedInt3Member, SignedInt3Member, SignedInt3Member> subtract() {
        return this.SUB;
    }

    @Override
    public Procedure3<SignedInt3Member, SignedInt3Member, SignedInt3Member> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt3Member, SignedInt3Member> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<SignedInt3Member> unity() {
        return this.UNITY;
    }

    @Override
    public Function2<Boolean, SignedInt3Member, SignedInt3Member> isLess() {
        return this.LESS;
    }

    @Override
    public Function2<Boolean, SignedInt3Member, SignedInt3Member> isLessEqual() {
        return this.LE;
    }

    @Override
    public Function2<Boolean, SignedInt3Member, SignedInt3Member> isGreater() {
        return this.GREAT;
    }

    @Override
    public Function2<Boolean, SignedInt3Member, SignedInt3Member> isGreaterEqual() {
        return this.GE;
    }

    @Override
    public Function2<java.lang.Integer, SignedInt3Member, SignedInt3Member> compare() {
        return this.CMP;
    }

    @Override
    public Function1<java.lang.Integer, SignedInt3Member> signum() {
        return this.SIG;
    }

    @Override
    public Procedure3<SignedInt3Member, SignedInt3Member, SignedInt3Member> min() {
        return this.MIN;
    }

    @Override
    public Procedure3<SignedInt3Member, SignedInt3Member, SignedInt3Member> max() {
        return this.MAX;
    }

    @Override
    public Procedure2<SignedInt3Member, SignedInt3Member> abs() {
        return this.ABS;
    }

    @Override
    public Procedure2<SignedInt3Member, SignedInt3Member> norm() {
        return this.ABS;
    }

    @Override
    public Procedure3<SignedInt3Member, SignedInt3Member, SignedInt3Member> gcd() {
        return this.GCD;
    }

    @Override
    public Procedure3<SignedInt3Member, SignedInt3Member, SignedInt3Member> lcm() {
        return this.LCM;
    }

    @Override
    public Function1<Boolean, SignedInt3Member> isEven() {
        return this.EVEN;
    }

    @Override
    public Function1<Boolean, SignedInt3Member> isOdd() {
        return this.ODD;
    }

    @Override
    public Procedure3<SignedInt3Member, SignedInt3Member, SignedInt3Member> div() {
        return this.DIV;
    }

    @Override
    public Procedure3<SignedInt3Member, SignedInt3Member, SignedInt3Member> mod() {
        return this.MOD;
    }

    @Override
    public Procedure4<SignedInt3Member, SignedInt3Member, SignedInt3Member, SignedInt3Member> divMod() {
        return this.DIVMOD;
    }

    @Override
    public Procedure2<SignedInt3Member, SignedInt3Member> pred() {
        return this.PRED;
    }

    @Override
    public Procedure2<SignedInt3Member, SignedInt3Member> succ() {
        return this.SUCC;
    }

    @Override
    public Procedure3<SignedInt3Member, SignedInt3Member, SignedInt3Member> pow() {
        return this.POW;
    }

    @Override
    public Procedure1<SignedInt3Member> random() {
        return this.RAND;
    }

    @Override
    public Procedure3<SignedInt3Member, SignedInt3Member, SignedInt3Member> bitAnd() {
        return this.AND;
    }

    @Override
    public Procedure3<SignedInt3Member, SignedInt3Member, SignedInt3Member> bitOr() {
        return this.OR;
    }

    @Override
    public Procedure3<SignedInt3Member, SignedInt3Member, SignedInt3Member> bitXor() {
        return this.XOR;
    }

    @Override
    public Procedure2<SignedInt3Member, SignedInt3Member> bitNot() {
        return this.NOT;
    }

    @Override
    public Procedure3<SignedInt3Member, SignedInt3Member, SignedInt3Member> bitAndNot() {
        return this.ANDNOT;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt3Member, SignedInt3Member> bitShiftLeft() {
        return this.SHL;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt3Member, SignedInt3Member> bitShiftRight() {
        return this.SHR;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt3Member, SignedInt3Member> bitShiftRightFillZero() {
        return this.SHRZ;
    }

    @Override
    public Procedure1<SignedInt3Member> maxBound() {
        return this.MAXBOUND;
    }

    @Override
    public Procedure1<SignedInt3Member> minBound() {
        return this.MINBOUND;
    }

    @Override
    public Function1<Boolean, SignedInt3Member> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<SignedInt3Member, SignedInt3Member, SignedInt3Member> scale() {
        return this.MUL;
    }

    @Override
    public Procedure3<HighPrecisionMember, SignedInt3Member, SignedInt3Member> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<HighPrecisionMember, SignedInt3Member, SignedInt3Member> scaleByHighPrecAndRound() {
        return this.SBHPR;
    }

    @Override
    public Procedure3<RationalMember, SignedInt3Member, SignedInt3Member> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, SignedInt3Member, SignedInt3Member> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<Double, SignedInt3Member, SignedInt3Member> scaleByDoubleAndRound() {
        return this.SBDR;
    }

    @Override
    public Function3<Boolean, SignedInt3Member, SignedInt3Member, SignedInt3Member> within() {
        return this.WITHIN;
    }
}

