/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.int32;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.ThreadLocalRandom;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.Gcd;
import nom.bdezonia.zorbage.algorithm.Lcm;
import nom.bdezonia.zorbage.algorithm.Max;
import nom.bdezonia.zorbage.algorithm.Min;
import nom.bdezonia.zorbage.algorithm.NumberWithin;
import nom.bdezonia.zorbage.algorithm.PowerNonNegative;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.BitOperations;
import nom.bdezonia.zorbage.type.algebra.Bounded;
import nom.bdezonia.zorbage.type.algebra.Integer;
import nom.bdezonia.zorbage.type.algebra.Random;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.int32.SignedInt32Member;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class SignedInt32Algebra
implements Integer<SignedInt32Algebra, SignedInt32Member>,
Bounded<SignedInt32Member>,
BitOperations<SignedInt32Member>,
Random<SignedInt32Member>,
Tolerance<SignedInt32Member, SignedInt32Member> {
    private final Function2<Boolean, SignedInt32Member, SignedInt32Member> EQ = new Function2<Boolean, SignedInt32Member, SignedInt32Member>(){

        @Override
        public Boolean call(SignedInt32Member a, SignedInt32Member b) {
            return a.v() == b.v();
        }
    };
    private final Function2<Boolean, SignedInt32Member, SignedInt32Member> NEQ = new Function2<Boolean, SignedInt32Member, SignedInt32Member>(){

        @Override
        public Boolean call(SignedInt32Member a, SignedInt32Member b) {
            return a.v() != b.v();
        }
    };
    private Procedure2<SignedInt32Member, SignedInt32Member> ASSIGN = new Procedure2<SignedInt32Member, SignedInt32Member>(){

        @Override
        public void call(SignedInt32Member from, SignedInt32Member to) {
            to.v = from.v;
        }
    };
    private Procedure2<SignedInt32Member, SignedInt32Member> ABS = new Procedure2<SignedInt32Member, SignedInt32Member>(){

        @Override
        public void call(SignedInt32Member a, SignedInt32Member b) {
            if (a.v() == java.lang.Integer.MIN_VALUE) {
                throw new IllegalArgumentException("Cannot convert -minint symmetrically");
            }
            b.setV(Math.abs(a.v()));
        }
    };
    private final Procedure3<SignedInt32Member, SignedInt32Member, SignedInt32Member> MUL = new Procedure3<SignedInt32Member, SignedInt32Member, SignedInt32Member>(){

        @Override
        public void call(SignedInt32Member a, SignedInt32Member b, SignedInt32Member c) {
            c.setV(a.v() * b.v());
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt32Member, SignedInt32Member> POWER = new Procedure3<java.lang.Integer, SignedInt32Member, SignedInt32Member>(){

        @Override
        public void call(java.lang.Integer power, SignedInt32Member a, SignedInt32Member b) {
            PowerNonNegative.compute(G.INT32, power, a, b);
        }
    };
    private final Procedure1<SignedInt32Member> ZER = new Procedure1<SignedInt32Member>(){

        @Override
        public void call(SignedInt32Member a) {
            a.v = 0;
        }
    };
    private Procedure2<SignedInt32Member, SignedInt32Member> NEG = new Procedure2<SignedInt32Member, SignedInt32Member>(){

        @Override
        public void call(SignedInt32Member a, SignedInt32Member b) {
            if (a.v() == java.lang.Integer.MIN_VALUE) {
                throw new IllegalArgumentException("Cannot convert -minint symmetrically");
            }
            b.setV(-a.v());
        }
    };
    private final Procedure3<SignedInt32Member, SignedInt32Member, SignedInt32Member> ADD = new Procedure3<SignedInt32Member, SignedInt32Member, SignedInt32Member>(){

        @Override
        public void call(SignedInt32Member a, SignedInt32Member b, SignedInt32Member c) {
            c.setV(a.v() + b.v());
        }
    };
    private final Procedure3<SignedInt32Member, SignedInt32Member, SignedInt32Member> SUB = new Procedure3<SignedInt32Member, SignedInt32Member, SignedInt32Member>(){

        @Override
        public void call(SignedInt32Member a, SignedInt32Member b, SignedInt32Member c) {
            c.setV(a.v() - b.v());
        }
    };
    private final Procedure1<SignedInt32Member> UNITY = new Procedure1<SignedInt32Member>(){

        @Override
        public void call(SignedInt32Member a) {
            a.v = 1;
        }
    };
    private final Function2<Boolean, SignedInt32Member, SignedInt32Member> LESS = new Function2<Boolean, SignedInt32Member, SignedInt32Member>(){

        @Override
        public Boolean call(SignedInt32Member a, SignedInt32Member b) {
            return a.v() < b.v();
        }
    };
    private final Function2<Boolean, SignedInt32Member, SignedInt32Member> LE = new Function2<Boolean, SignedInt32Member, SignedInt32Member>(){

        @Override
        public Boolean call(SignedInt32Member a, SignedInt32Member b) {
            return a.v() <= b.v();
        }
    };
    private final Function2<Boolean, SignedInt32Member, SignedInt32Member> GREAT = new Function2<Boolean, SignedInt32Member, SignedInt32Member>(){

        @Override
        public Boolean call(SignedInt32Member a, SignedInt32Member b) {
            return a.v() > b.v();
        }
    };
    private final Function2<Boolean, SignedInt32Member, SignedInt32Member> GE = new Function2<Boolean, SignedInt32Member, SignedInt32Member>(){

        @Override
        public Boolean call(SignedInt32Member a, SignedInt32Member b) {
            return a.v() >= b.v();
        }
    };
    private final Function2<java.lang.Integer, SignedInt32Member, SignedInt32Member> CMP = new Function2<java.lang.Integer, SignedInt32Member, SignedInt32Member>(){

        @Override
        public java.lang.Integer call(SignedInt32Member a, SignedInt32Member b) {
            if (a.v() < b.v()) {
                return -1;
            }
            if (a.v() > b.v()) {
                return 1;
            }
            return 0;
        }
    };
    private final Function1<java.lang.Integer, SignedInt32Member> SIG = new Function1<java.lang.Integer, SignedInt32Member>(){

        @Override
        public java.lang.Integer call(SignedInt32Member a) {
            if (a.v() < 0) {
                return -1;
            }
            if (a.v() > 0) {
                return 1;
            }
            return 0;
        }
    };
    private final Procedure3<SignedInt32Member, SignedInt32Member, SignedInt32Member> DIV = new Procedure3<SignedInt32Member, SignedInt32Member, SignedInt32Member>(){

        @Override
        public void call(SignedInt32Member a, SignedInt32Member b, SignedInt32Member d) {
            if (b.v() == -1 && a.v() == java.lang.Integer.MIN_VALUE) {
                throw new IllegalArgumentException("cannot divide minint by -1");
            }
            d.setV(a.v() / b.v());
        }
    };
    private final Procedure3<SignedInt32Member, SignedInt32Member, SignedInt32Member> MOD = new Procedure3<SignedInt32Member, SignedInt32Member, SignedInt32Member>(){

        @Override
        public void call(SignedInt32Member a, SignedInt32Member b, SignedInt32Member m) {
            m.setV(a.v() % b.v());
        }
    };
    private final Procedure4<SignedInt32Member, SignedInt32Member, SignedInt32Member, SignedInt32Member> DIVMOD = new Procedure4<SignedInt32Member, SignedInt32Member, SignedInt32Member, SignedInt32Member>(){

        @Override
        public void call(SignedInt32Member a, SignedInt32Member b, SignedInt32Member d, SignedInt32Member m) {
            SignedInt32Algebra.this.div().call(a, b, d);
            SignedInt32Algebra.this.mod().call(a, b, m);
        }
    };
    private final Procedure3<SignedInt32Member, SignedInt32Member, SignedInt32Member> GCD = new Procedure3<SignedInt32Member, SignedInt32Member, SignedInt32Member>(){

        @Override
        public void call(SignedInt32Member a, SignedInt32Member b, SignedInt32Member c) {
            Gcd.compute(G.INT32, a, b, c);
        }
    };
    private final Procedure3<SignedInt32Member, SignedInt32Member, SignedInt32Member> LCM = new Procedure3<SignedInt32Member, SignedInt32Member, SignedInt32Member>(){

        @Override
        public void call(SignedInt32Member a, SignedInt32Member b, SignedInt32Member c) {
            Lcm.compute(G.INT32, a, b, c);
        }
    };
    private final Function1<Boolean, SignedInt32Member> EVEN = new Function1<Boolean, SignedInt32Member>(){

        @Override
        public Boolean call(SignedInt32Member a) {
            return (a.v() & 1) == 0;
        }
    };
    private final Function1<Boolean, SignedInt32Member> ODD = new Function1<Boolean, SignedInt32Member>(){

        @Override
        public Boolean call(SignedInt32Member a) {
            return (a.v() & 1) == 1;
        }
    };
    private Procedure2<SignedInt32Member, SignedInt32Member> PRED = new Procedure2<SignedInt32Member, SignedInt32Member>(){

        @Override
        public void call(SignedInt32Member a, SignedInt32Member b) {
            b.setV(a.v() - 1);
        }
    };
    private Procedure2<SignedInt32Member, SignedInt32Member> SUCC = new Procedure2<SignedInt32Member, SignedInt32Member>(){

        @Override
        public void call(SignedInt32Member a, SignedInt32Member b) {
            b.setV(a.v() + 1);
        }
    };
    private final Procedure1<SignedInt32Member> MAXBOUND = new Procedure1<SignedInt32Member>(){

        @Override
        public void call(SignedInt32Member a) {
            a.v = java.lang.Integer.MAX_VALUE;
        }
    };
    private final Procedure1<SignedInt32Member> MINBOUND = new Procedure1<SignedInt32Member>(){

        @Override
        public void call(SignedInt32Member a) {
            a.v = java.lang.Integer.MIN_VALUE;
        }
    };
    private final Procedure3<SignedInt32Member, SignedInt32Member, SignedInt32Member> BITAND = new Procedure3<SignedInt32Member, SignedInt32Member, SignedInt32Member>(){

        @Override
        public void call(SignedInt32Member a, SignedInt32Member b, SignedInt32Member c) {
            c.setV(a.v() & b.v());
        }
    };
    private final Procedure3<SignedInt32Member, SignedInt32Member, SignedInt32Member> BITOR = new Procedure3<SignedInt32Member, SignedInt32Member, SignedInt32Member>(){

        @Override
        public void call(SignedInt32Member a, SignedInt32Member b, SignedInt32Member c) {
            c.setV(a.v() | b.v());
        }
    };
    private final Procedure3<SignedInt32Member, SignedInt32Member, SignedInt32Member> BITXOR = new Procedure3<SignedInt32Member, SignedInt32Member, SignedInt32Member>(){

        @Override
        public void call(SignedInt32Member a, SignedInt32Member b, SignedInt32Member c) {
            c.setV(a.v() ^ b.v());
        }
    };
    private Procedure2<SignedInt32Member, SignedInt32Member> BITNOT = new Procedure2<SignedInt32Member, SignedInt32Member>(){

        @Override
        public void call(SignedInt32Member a, SignedInt32Member b) {
            b.setV(~a.v());
        }
    };
    private final Procedure3<SignedInt32Member, SignedInt32Member, SignedInt32Member> BITANDNOT = new Procedure3<SignedInt32Member, SignedInt32Member, SignedInt32Member>(){

        @Override
        public void call(SignedInt32Member a, SignedInt32Member b, SignedInt32Member c) {
            c.setV(a.v() & ~b.v());
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt32Member, SignedInt32Member> BITSHL = new Procedure3<java.lang.Integer, SignedInt32Member, SignedInt32Member>(){

        @Override
        public void call(java.lang.Integer count, SignedInt32Member a, SignedInt32Member b) {
            if (count < 0) {
                SignedInt32Algebra.this.bitShiftRight().call(-count.intValue(), a, b);
            } else {
                count = count % 32;
                b.setV(a.v() << count);
            }
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt32Member, SignedInt32Member> BITSHR = new Procedure3<java.lang.Integer, SignedInt32Member, SignedInt32Member>(){

        @Override
        public void call(java.lang.Integer count, SignedInt32Member a, SignedInt32Member b) {
            if (count < 0) {
                SignedInt32Algebra.this.bitShiftLeft().call(-count.intValue(), a, b);
            } else {
                b.setV(a.v() >> count);
            }
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt32Member, SignedInt32Member> BITSHRZ = new Procedure3<java.lang.Integer, SignedInt32Member, SignedInt32Member>(){

        @Override
        public void call(java.lang.Integer count, SignedInt32Member a, SignedInt32Member b) {
            if (count < 0) {
                SignedInt32Algebra.this.bitShiftLeft().call(-count.intValue(), a, b);
            } else {
                b.setV(a.v() >>> count);
            }
        }
    };
    private final Procedure3<SignedInt32Member, SignedInt32Member, SignedInt32Member> MIN = new Procedure3<SignedInt32Member, SignedInt32Member, SignedInt32Member>(){

        @Override
        public void call(SignedInt32Member a, SignedInt32Member b, SignedInt32Member c) {
            Min.compute(G.INT32, a, b, c);
        }
    };
    private final Procedure3<SignedInt32Member, SignedInt32Member, SignedInt32Member> MAX = new Procedure3<SignedInt32Member, SignedInt32Member, SignedInt32Member>(){

        @Override
        public void call(SignedInt32Member a, SignedInt32Member b, SignedInt32Member c) {
            Max.compute(G.INT32, a, b, c);
        }
    };
    private final Procedure1<SignedInt32Member> RAND = new Procedure1<SignedInt32Member>(){

        @Override
        public void call(SignedInt32Member a) {
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            a.v = rng.nextInt();
        }
    };
    private final Procedure3<SignedInt32Member, SignedInt32Member, SignedInt32Member> POW = new Procedure3<SignedInt32Member, SignedInt32Member, SignedInt32Member>(){

        @Override
        public void call(SignedInt32Member a, SignedInt32Member b, SignedInt32Member c) {
            SignedInt32Algebra.this.power().call(b.v(), a, c);
        }
    };
    private final Function1<Boolean, SignedInt32Member> ISZERO = new Function1<Boolean, SignedInt32Member>(){

        @Override
        public Boolean call(SignedInt32Member a) {
            return a.v() == 0;
        }
    };
    private final Procedure3<HighPrecisionMember, SignedInt32Member, SignedInt32Member> SBHP = new Procedure3<HighPrecisionMember, SignedInt32Member, SignedInt32Member>(){

        @Override
        public void call(HighPrecisionMember a, SignedInt32Member b, SignedInt32Member c) {
            BigDecimal tmp = a.v();
            tmp = tmp.multiply(new BigDecimal(b.v()));
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<HighPrecisionMember, SignedInt32Member, SignedInt32Member> SBHPR = new Procedure3<HighPrecisionMember, SignedInt32Member, SignedInt32Member>(){

        @Override
        public void call(HighPrecisionMember a, SignedInt32Member b, SignedInt32Member c) {
            BigDecimal tmp = a.v();
            int signum = (tmp = tmp.multiply(new BigDecimal(b.v()))).signum();
            tmp = signum < 0 ? tmp.subtract(G.ONE_HALF) : tmp.add(G.ONE_HALF);
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<RationalMember, SignedInt32Member, SignedInt32Member> SBR = new Procedure3<RationalMember, SignedInt32Member, SignedInt32Member>(){

        @Override
        public void call(RationalMember a, SignedInt32Member b, SignedInt32Member c) {
            BigInteger tmp = BigInteger.valueOf(b.v());
            tmp = tmp.multiply(a.n());
            tmp = tmp.divide(a.d());
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<Double, SignedInt32Member, SignedInt32Member> SBD = new Procedure3<Double, SignedInt32Member, SignedInt32Member>(){

        @Override
        public void call(Double a, SignedInt32Member b, SignedInt32Member c) {
            c.setV((int)(a * (double)b.v()));
        }
    };
    private final Procedure3<Double, SignedInt32Member, SignedInt32Member> SBDR = new Procedure3<Double, SignedInt32Member, SignedInt32Member>(){

        @Override
        public void call(Double a, SignedInt32Member b, SignedInt32Member c) {
            c.setV((int)Math.round(a * (double)b.v()));
        }
    };
    private final Function3<Boolean, SignedInt32Member, SignedInt32Member, SignedInt32Member> WITHIN = new Function3<Boolean, SignedInt32Member, SignedInt32Member, SignedInt32Member>(){

        @Override
        public Boolean call(SignedInt32Member tol, SignedInt32Member a, SignedInt32Member b) {
            return NumberWithin.compute(G.INT32, tol, a, b);
        }
    };

    @Override
    public Function2<Boolean, SignedInt32Member, SignedInt32Member> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, SignedInt32Member, SignedInt32Member> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public SignedInt32Member construct() {
        return new SignedInt32Member();
    }

    @Override
    public SignedInt32Member construct(SignedInt32Member other) {
        return new SignedInt32Member(other);
    }

    @Override
    public SignedInt32Member construct(String s) {
        return new SignedInt32Member(s);
    }

    @Override
    public Procedure2<SignedInt32Member, SignedInt32Member> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure2<SignedInt32Member, SignedInt32Member> abs() {
        return this.ABS;
    }

    @Override
    public Procedure3<SignedInt32Member, SignedInt32Member, SignedInt32Member> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt32Member, SignedInt32Member> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<SignedInt32Member> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<SignedInt32Member, SignedInt32Member> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<SignedInt32Member, SignedInt32Member, SignedInt32Member> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<SignedInt32Member, SignedInt32Member, SignedInt32Member> subtract() {
        return this.SUB;
    }

    @Override
    public Procedure1<SignedInt32Member> unity() {
        return this.UNITY;
    }

    @Override
    public Function2<Boolean, SignedInt32Member, SignedInt32Member> isLess() {
        return this.LESS;
    }

    @Override
    public Function2<Boolean, SignedInt32Member, SignedInt32Member> isLessEqual() {
        return this.LE;
    }

    @Override
    public Function2<Boolean, SignedInt32Member, SignedInt32Member> isGreater() {
        return this.GREAT;
    }

    @Override
    public Function2<Boolean, SignedInt32Member, SignedInt32Member> isGreaterEqual() {
        return this.GE;
    }

    @Override
    public Function2<java.lang.Integer, SignedInt32Member, SignedInt32Member> compare() {
        return this.CMP;
    }

    @Override
    public Function1<java.lang.Integer, SignedInt32Member> signum() {
        return this.SIG;
    }

    @Override
    public Procedure3<SignedInt32Member, SignedInt32Member, SignedInt32Member> div() {
        return this.DIV;
    }

    @Override
    public Procedure3<SignedInt32Member, SignedInt32Member, SignedInt32Member> mod() {
        return this.MOD;
    }

    @Override
    public Procedure4<SignedInt32Member, SignedInt32Member, SignedInt32Member, SignedInt32Member> divMod() {
        return this.DIVMOD;
    }

    @Override
    public Procedure3<SignedInt32Member, SignedInt32Member, SignedInt32Member> gcd() {
        return this.GCD;
    }

    @Override
    public Procedure3<SignedInt32Member, SignedInt32Member, SignedInt32Member> lcm() {
        return this.LCM;
    }

    @Override
    public Procedure2<SignedInt32Member, SignedInt32Member> norm() {
        return this.ABS;
    }

    @Override
    public Function1<Boolean, SignedInt32Member> isEven() {
        return this.EVEN;
    }

    @Override
    public Function1<Boolean, SignedInt32Member> isOdd() {
        return this.ODD;
    }

    @Override
    public Procedure2<SignedInt32Member, SignedInt32Member> pred() {
        return this.PRED;
    }

    @Override
    public Procedure2<SignedInt32Member, SignedInt32Member> succ() {
        return this.SUCC;
    }

    @Override
    public Procedure1<SignedInt32Member> maxBound() {
        return this.MAXBOUND;
    }

    @Override
    public Procedure1<SignedInt32Member> minBound() {
        return this.MINBOUND;
    }

    @Override
    public Procedure3<SignedInt32Member, SignedInt32Member, SignedInt32Member> bitAnd() {
        return this.BITAND;
    }

    @Override
    public Procedure3<SignedInt32Member, SignedInt32Member, SignedInt32Member> bitOr() {
        return this.BITOR;
    }

    @Override
    public Procedure3<SignedInt32Member, SignedInt32Member, SignedInt32Member> bitXor() {
        return this.BITXOR;
    }

    @Override
    public Procedure2<SignedInt32Member, SignedInt32Member> bitNot() {
        return this.BITNOT;
    }

    @Override
    public Procedure3<SignedInt32Member, SignedInt32Member, SignedInt32Member> bitAndNot() {
        return this.BITANDNOT;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt32Member, SignedInt32Member> bitShiftLeft() {
        return this.BITSHL;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt32Member, SignedInt32Member> bitShiftRight() {
        return this.BITSHR;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt32Member, SignedInt32Member> bitShiftRightFillZero() {
        return this.BITSHRZ;
    }

    @Override
    public Procedure3<SignedInt32Member, SignedInt32Member, SignedInt32Member> min() {
        return this.MIN;
    }

    @Override
    public Procedure3<SignedInt32Member, SignedInt32Member, SignedInt32Member> max() {
        return this.MAX;
    }

    @Override
    public Procedure1<SignedInt32Member> random() {
        return this.RAND;
    }

    @Override
    public Procedure3<SignedInt32Member, SignedInt32Member, SignedInt32Member> pow() {
        return this.POW;
    }

    @Override
    public Function1<Boolean, SignedInt32Member> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<SignedInt32Member, SignedInt32Member, SignedInt32Member> scale() {
        return this.MUL;
    }

    @Override
    public Procedure3<HighPrecisionMember, SignedInt32Member, SignedInt32Member> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<HighPrecisionMember, SignedInt32Member, SignedInt32Member> scaleByHighPrecAndRound() {
        return this.SBHPR;
    }

    @Override
    public Procedure3<RationalMember, SignedInt32Member, SignedInt32Member> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, SignedInt32Member, SignedInt32Member> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<Double, SignedInt32Member, SignedInt32Member> scaleByDoubleAndRound() {
        return this.SBDR;
    }

    @Override
    public Function3<Boolean, SignedInt32Member, SignedInt32Member, SignedInt32Member> within() {
        return this.WITHIN;
    }
}

