/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.int32;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.ThreadLocalRandom;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.Gcd;
import nom.bdezonia.zorbage.algorithm.Lcm;
import nom.bdezonia.zorbage.algorithm.Max;
import nom.bdezonia.zorbage.algorithm.Min;
import nom.bdezonia.zorbage.algorithm.NumberWithin;
import nom.bdezonia.zorbage.algorithm.PowerNonNegative;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.BitOperations;
import nom.bdezonia.zorbage.type.algebra.Bounded;
import nom.bdezonia.zorbage.type.algebra.Integer;
import nom.bdezonia.zorbage.type.algebra.Random;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.int32.UnsignedInt32Member;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class UnsignedInt32Algebra
implements Integer<UnsignedInt32Algebra, UnsignedInt32Member>,
Bounded<UnsignedInt32Member>,
BitOperations<UnsignedInt32Member>,
Random<UnsignedInt32Member>,
Tolerance<UnsignedInt32Member, UnsignedInt32Member> {
    private static final UnsignedInt32Member ONE = new UnsignedInt32Member(1L);
    private static final UnsignedInt32Member ZERO = new UnsignedInt32Member();
    private final Function2<Boolean, UnsignedInt32Member, UnsignedInt32Member> EQ = new Function2<Boolean, UnsignedInt32Member, UnsignedInt32Member>(){

        @Override
        public Boolean call(UnsignedInt32Member a, UnsignedInt32Member b) {
            return a.v == b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt32Member, UnsignedInt32Member> NEQ = new Function2<Boolean, UnsignedInt32Member, UnsignedInt32Member>(){

        @Override
        public Boolean call(UnsignedInt32Member a, UnsignedInt32Member b) {
            return a.v != b.v;
        }
    };
    private final Procedure2<UnsignedInt32Member, UnsignedInt32Member> ASSIGN = new Procedure2<UnsignedInt32Member, UnsignedInt32Member>(){

        @Override
        public void call(UnsignedInt32Member from, UnsignedInt32Member to) {
            to.set(from);
        }
    };
    private final Procedure3<UnsignedInt32Member, UnsignedInt32Member, UnsignedInt32Member> MUL = new Procedure3<UnsignedInt32Member, UnsignedInt32Member, UnsignedInt32Member>(){

        @Override
        public void call(UnsignedInt32Member a, UnsignedInt32Member b, UnsignedInt32Member c) {
            c.setV(a.v() * b.v());
        }
    };
    private final Procedure3<java.lang.Integer, UnsignedInt32Member, UnsignedInt32Member> POWER = new Procedure3<java.lang.Integer, UnsignedInt32Member, UnsignedInt32Member>(){

        @Override
        public void call(java.lang.Integer power, UnsignedInt32Member a, UnsignedInt32Member b) {
            PowerNonNegative.compute(G.UINT32, power, a, b);
        }
    };
    private Procedure1<UnsignedInt32Member> ZER = new Procedure1<UnsignedInt32Member>(){

        @Override
        public void call(UnsignedInt32Member a) {
            a.setV(0L);
        }
    };
    private final Procedure3<UnsignedInt32Member, UnsignedInt32Member, UnsignedInt32Member> ADD = new Procedure3<UnsignedInt32Member, UnsignedInt32Member, UnsignedInt32Member>(){

        @Override
        public void call(UnsignedInt32Member a, UnsignedInt32Member b, UnsignedInt32Member c) {
            c.setV(a.v + b.v);
        }
    };
    private final Procedure3<UnsignedInt32Member, UnsignedInt32Member, UnsignedInt32Member> SUB = new Procedure3<UnsignedInt32Member, UnsignedInt32Member, UnsignedInt32Member>(){

        @Override
        public void call(UnsignedInt32Member a, UnsignedInt32Member b, UnsignedInt32Member c) {
            c.setV(a.v - b.v);
        }
    };
    private Procedure1<UnsignedInt32Member> UNITY = new Procedure1<UnsignedInt32Member>(){

        @Override
        public void call(UnsignedInt32Member a) {
            a.setV(1L);
        }
    };
    private final Function2<Boolean, UnsignedInt32Member, UnsignedInt32Member> LESS = new Function2<Boolean, UnsignedInt32Member, UnsignedInt32Member>(){

        @Override
        public Boolean call(UnsignedInt32Member a, UnsignedInt32Member b) {
            return UnsignedInt32Algebra.this.compare().call(a, b) < 0;
        }
    };
    private final Function2<Boolean, UnsignedInt32Member, UnsignedInt32Member> LE = new Function2<Boolean, UnsignedInt32Member, UnsignedInt32Member>(){

        @Override
        public Boolean call(UnsignedInt32Member a, UnsignedInt32Member b) {
            return UnsignedInt32Algebra.this.compare().call(a, b) <= 0;
        }
    };
    private final Function2<Boolean, UnsignedInt32Member, UnsignedInt32Member> GREAT = new Function2<Boolean, UnsignedInt32Member, UnsignedInt32Member>(){

        @Override
        public Boolean call(UnsignedInt32Member a, UnsignedInt32Member b) {
            return UnsignedInt32Algebra.this.compare().call(a, b) > 0;
        }
    };
    private final Function2<Boolean, UnsignedInt32Member, UnsignedInt32Member> GE = new Function2<Boolean, UnsignedInt32Member, UnsignedInt32Member>(){

        @Override
        public Boolean call(UnsignedInt32Member a, UnsignedInt32Member b) {
            return UnsignedInt32Algebra.this.compare().call(a, b) >= 0;
        }
    };
    private final Function2<java.lang.Integer, UnsignedInt32Member, UnsignedInt32Member> CMP = new Function2<java.lang.Integer, UnsignedInt32Member, UnsignedInt32Member>(){

        @Override
        public java.lang.Integer call(UnsignedInt32Member a, UnsignedInt32Member b) {
            long bv;
            long av = a.v();
            if (av < (bv = b.v())) {
                return -1;
            }
            if (av > bv) {
                return 1;
            }
            return 0;
        }
    };
    private final Function1<java.lang.Integer, UnsignedInt32Member> SIG = new Function1<java.lang.Integer, UnsignedInt32Member>(){

        @Override
        public java.lang.Integer call(UnsignedInt32Member a) {
            if (a.v == 0) {
                return 0;
            }
            return 1;
        }
    };
    private final Procedure3<UnsignedInt32Member, UnsignedInt32Member, UnsignedInt32Member> DIV = new Procedure3<UnsignedInt32Member, UnsignedInt32Member, UnsignedInt32Member>(){

        @Override
        public void call(UnsignedInt32Member a, UnsignedInt32Member b, UnsignedInt32Member d) {
            d.setV(a.v() / b.v());
        }
    };
    private final Procedure3<UnsignedInt32Member, UnsignedInt32Member, UnsignedInt32Member> MOD = new Procedure3<UnsignedInt32Member, UnsignedInt32Member, UnsignedInt32Member>(){

        @Override
        public void call(UnsignedInt32Member a, UnsignedInt32Member b, UnsignedInt32Member m) {
            m.setV(a.v() % b.v());
        }
    };
    private final Procedure4<UnsignedInt32Member, UnsignedInt32Member, UnsignedInt32Member, UnsignedInt32Member> DIVMOD = new Procedure4<UnsignedInt32Member, UnsignedInt32Member, UnsignedInt32Member, UnsignedInt32Member>(){

        @Override
        public void call(UnsignedInt32Member a, UnsignedInt32Member b, UnsignedInt32Member d, UnsignedInt32Member m) {
            UnsignedInt32Algebra.this.div().call(a, b, d);
            UnsignedInt32Algebra.this.mod().call(a, b, m);
        }
    };
    private final Procedure3<UnsignedInt32Member, UnsignedInt32Member, UnsignedInt32Member> GCD = new Procedure3<UnsignedInt32Member, UnsignedInt32Member, UnsignedInt32Member>(){

        @Override
        public void call(UnsignedInt32Member a, UnsignedInt32Member b, UnsignedInt32Member c) {
            Gcd.compute(G.UINT32, a, b, c);
        }
    };
    private final Procedure3<UnsignedInt32Member, UnsignedInt32Member, UnsignedInt32Member> LCM = new Procedure3<UnsignedInt32Member, UnsignedInt32Member, UnsignedInt32Member>(){

        @Override
        public void call(UnsignedInt32Member a, UnsignedInt32Member b, UnsignedInt32Member c) {
            Lcm.compute(G.UINT32, a, b, c);
        }
    };
    private final Function1<Boolean, UnsignedInt32Member> EVEN = new Function1<Boolean, UnsignedInt32Member>(){

        @Override
        public Boolean call(UnsignedInt32Member a) {
            return (a.v & 1) == 0;
        }
    };
    private final Function1<Boolean, UnsignedInt32Member> ODD = new Function1<Boolean, UnsignedInt32Member>(){

        @Override
        public Boolean call(UnsignedInt32Member a) {
            return (a.v & 1) == 1;
        }
    };
    private final Procedure2<UnsignedInt32Member, UnsignedInt32Member> PRED = new Procedure2<UnsignedInt32Member, UnsignedInt32Member>(){

        @Override
        public void call(UnsignedInt32Member a, UnsignedInt32Member b) {
            if (a.v == 0) {
                b.setV(-1L);
            } else {
                b.setV(a.v() - 1L);
            }
        }
    };
    private final Procedure2<UnsignedInt32Member, UnsignedInt32Member> SUCC = new Procedure2<UnsignedInt32Member, UnsignedInt32Member>(){

        @Override
        public void call(UnsignedInt32Member a, UnsignedInt32Member b) {
            if (a.v == -1) {
                b.setV(0L);
            } else {
                b.setV(a.v() + 1L);
            }
        }
    };
    private Procedure1<UnsignedInt32Member> MAXBOUND = new Procedure1<UnsignedInt32Member>(){

        @Override
        public void call(UnsignedInt32Member a) {
            a.setV(-1L);
        }
    };
    private Procedure1<UnsignedInt32Member> MINBOUND = new Procedure1<UnsignedInt32Member>(){

        @Override
        public void call(UnsignedInt32Member a) {
            a.setV(0L);
        }
    };
    private final Procedure3<UnsignedInt32Member, UnsignedInt32Member, UnsignedInt32Member> BITAND = new Procedure3<UnsignedInt32Member, UnsignedInt32Member, UnsignedInt32Member>(){

        @Override
        public void call(UnsignedInt32Member a, UnsignedInt32Member b, UnsignedInt32Member c) {
            c.setV(a.v & b.v);
        }
    };
    private final Procedure3<UnsignedInt32Member, UnsignedInt32Member, UnsignedInt32Member> BITOR = new Procedure3<UnsignedInt32Member, UnsignedInt32Member, UnsignedInt32Member>(){

        @Override
        public void call(UnsignedInt32Member a, UnsignedInt32Member b, UnsignedInt32Member c) {
            c.setV(a.v | b.v);
        }
    };
    private final Procedure3<UnsignedInt32Member, UnsignedInt32Member, UnsignedInt32Member> BITXOR = new Procedure3<UnsignedInt32Member, UnsignedInt32Member, UnsignedInt32Member>(){

        @Override
        public void call(UnsignedInt32Member a, UnsignedInt32Member b, UnsignedInt32Member c) {
            c.setV(a.v ^ b.v);
        }
    };
    private final Procedure2<UnsignedInt32Member, UnsignedInt32Member> BITNOT = new Procedure2<UnsignedInt32Member, UnsignedInt32Member>(){

        @Override
        public void call(UnsignedInt32Member a, UnsignedInt32Member b) {
            b.setV(~a.v);
        }
    };
    private final Procedure3<UnsignedInt32Member, UnsignedInt32Member, UnsignedInt32Member> BITANDNOT = new Procedure3<UnsignedInt32Member, UnsignedInt32Member, UnsignedInt32Member>(){

        @Override
        public void call(UnsignedInt32Member a, UnsignedInt32Member b, UnsignedInt32Member c) {
            c.setV(a.v & ~b.v);
        }
    };
    private final Procedure3<java.lang.Integer, UnsignedInt32Member, UnsignedInt32Member> BITSHL = new Procedure3<java.lang.Integer, UnsignedInt32Member, UnsignedInt32Member>(){

        @Override
        public void call(java.lang.Integer count, UnsignedInt32Member a, UnsignedInt32Member b) {
            if (count < 0) {
                UnsignedInt32Algebra.this.bitShiftRight().call(-count.intValue(), a, b);
            } else {
                count = count % 32;
                b.setV(a.v() << count);
            }
        }
    };
    private final Procedure3<java.lang.Integer, UnsignedInt32Member, UnsignedInt32Member> BITSHRZ = new Procedure3<java.lang.Integer, UnsignedInt32Member, UnsignedInt32Member>(){

        @Override
        public void call(java.lang.Integer count, UnsignedInt32Member a, UnsignedInt32Member b) {
            if (count < 0) {
                UnsignedInt32Algebra.this.bitShiftLeft().call(-count.intValue(), a, b);
            } else {
                b.setV(a.v() >>> count);
            }
        }
    };
    private final Procedure3<UnsignedInt32Member, UnsignedInt32Member, UnsignedInt32Member> MIN = new Procedure3<UnsignedInt32Member, UnsignedInt32Member, UnsignedInt32Member>(){

        @Override
        public void call(UnsignedInt32Member a, UnsignedInt32Member b, UnsignedInt32Member c) {
            Min.compute(G.UINT32, a, b, c);
        }
    };
    private final Procedure3<UnsignedInt32Member, UnsignedInt32Member, UnsignedInt32Member> MAX = new Procedure3<UnsignedInt32Member, UnsignedInt32Member, UnsignedInt32Member>(){

        @Override
        public void call(UnsignedInt32Member a, UnsignedInt32Member b, UnsignedInt32Member c) {
            Max.compute(G.UINT32, a, b, c);
        }
    };
    private Procedure1<UnsignedInt32Member> RAND = new Procedure1<UnsignedInt32Member>(){

        @Override
        public void call(UnsignedInt32Member a) {
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            a.setV(rng.nextInt());
        }
    };
    private final Procedure3<UnsignedInt32Member, UnsignedInt32Member, UnsignedInt32Member> POW = new Procedure3<UnsignedInt32Member, UnsignedInt32Member, UnsignedInt32Member>(){

        @Override
        public void call(UnsignedInt32Member a, UnsignedInt32Member b, UnsignedInt32Member c) {
            if (UnsignedInt32Algebra.this.signum().call(a) == 0 && UnsignedInt32Algebra.this.signum().call(b) == 0) {
                throw new IllegalArgumentException("0^0 is not a number");
            }
            UnsignedInt32Member tmp = new UnsignedInt32Member(ONE);
            UnsignedInt32Member pow = new UnsignedInt32Member(b);
            while (!UnsignedInt32Algebra.this.isEqual().call(pow, ZERO).booleanValue()) {
                UnsignedInt32Algebra.this.multiply().call(tmp, a, tmp);
                UnsignedInt32Algebra.this.pred().call(pow, pow);
            }
            UnsignedInt32Algebra.this.assign().call(tmp, c);
        }
    };
    private final Function1<Boolean, UnsignedInt32Member> ISZERO = new Function1<Boolean, UnsignedInt32Member>(){

        @Override
        public Boolean call(UnsignedInt32Member a) {
            return a.v == 0;
        }
    };
    private final Procedure3<HighPrecisionMember, UnsignedInt32Member, UnsignedInt32Member> SBHP = new Procedure3<HighPrecisionMember, UnsignedInt32Member, UnsignedInt32Member>(){

        @Override
        public void call(HighPrecisionMember a, UnsignedInt32Member b, UnsignedInt32Member c) {
            BigDecimal tmp = a.v();
            tmp = tmp.multiply(new BigDecimal(b.v()));
            c.setV(tmp.longValue());
        }
    };
    private final Procedure3<HighPrecisionMember, UnsignedInt32Member, UnsignedInt32Member> SBHPR = new Procedure3<HighPrecisionMember, UnsignedInt32Member, UnsignedInt32Member>(){

        @Override
        public void call(HighPrecisionMember a, UnsignedInt32Member b, UnsignedInt32Member c) {
            BigDecimal tmp = a.v();
            int signum = (tmp = tmp.multiply(new BigDecimal(b.v()))).signum();
            tmp = signum < 0 ? tmp.subtract(G.ONE_HALF) : tmp.add(G.ONE_HALF);
            c.setV(tmp.longValue());
        }
    };
    private final Procedure3<RationalMember, UnsignedInt32Member, UnsignedInt32Member> SBR = new Procedure3<RationalMember, UnsignedInt32Member, UnsignedInt32Member>(){

        @Override
        public void call(RationalMember a, UnsignedInt32Member b, UnsignedInt32Member c) {
            BigInteger tmp = BigInteger.valueOf(b.v());
            tmp = tmp.multiply(a.n());
            tmp = tmp.divide(a.d());
            c.setV(tmp.longValue());
        }
    };
    private final Procedure3<Double, UnsignedInt32Member, UnsignedInt32Member> SBD = new Procedure3<Double, UnsignedInt32Member, UnsignedInt32Member>(){

        @Override
        public void call(Double a, UnsignedInt32Member b, UnsignedInt32Member c) {
            c.setV((long)(a * (double)b.v()));
        }
    };
    private final Procedure3<Double, UnsignedInt32Member, UnsignedInt32Member> SBDR = new Procedure3<Double, UnsignedInt32Member, UnsignedInt32Member>(){

        @Override
        public void call(Double a, UnsignedInt32Member b, UnsignedInt32Member c) {
            c.setV(Math.round(a * (double)b.v()));
        }
    };
    private final Function3<Boolean, UnsignedInt32Member, UnsignedInt32Member, UnsignedInt32Member> WITHIN = new Function3<Boolean, UnsignedInt32Member, UnsignedInt32Member, UnsignedInt32Member>(){

        @Override
        public Boolean call(UnsignedInt32Member tol, UnsignedInt32Member a, UnsignedInt32Member b) {
            return NumberWithin.compute(G.UINT32, tol, a, b);
        }
    };

    @Override
    public Function2<Boolean, UnsignedInt32Member, UnsignedInt32Member> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, UnsignedInt32Member, UnsignedInt32Member> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public UnsignedInt32Member construct() {
        return new UnsignedInt32Member();
    }

    @Override
    public UnsignedInt32Member construct(UnsignedInt32Member other) {
        return new UnsignedInt32Member(other);
    }

    @Override
    public UnsignedInt32Member construct(String s) {
        return new UnsignedInt32Member(s);
    }

    @Override
    public Procedure2<UnsignedInt32Member, UnsignedInt32Member> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure2<UnsignedInt32Member, UnsignedInt32Member> abs() {
        return this.ASSIGN;
    }

    @Override
    public Procedure3<UnsignedInt32Member, UnsignedInt32Member, UnsignedInt32Member> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt32Member, UnsignedInt32Member> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<UnsignedInt32Member> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<UnsignedInt32Member, UnsignedInt32Member> negate() {
        return this.ASSIGN;
    }

    @Override
    public Procedure3<UnsignedInt32Member, UnsignedInt32Member, UnsignedInt32Member> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<UnsignedInt32Member, UnsignedInt32Member, UnsignedInt32Member> subtract() {
        return this.SUB;
    }

    @Override
    public Procedure1<UnsignedInt32Member> unity() {
        return this.UNITY;
    }

    @Override
    public Function2<Boolean, UnsignedInt32Member, UnsignedInt32Member> isLess() {
        return this.LESS;
    }

    @Override
    public Function2<Boolean, UnsignedInt32Member, UnsignedInt32Member> isLessEqual() {
        return this.LE;
    }

    @Override
    public Function2<Boolean, UnsignedInt32Member, UnsignedInt32Member> isGreater() {
        return this.GREAT;
    }

    @Override
    public Function2<Boolean, UnsignedInt32Member, UnsignedInt32Member> isGreaterEqual() {
        return this.GE;
    }

    @Override
    public Function2<java.lang.Integer, UnsignedInt32Member, UnsignedInt32Member> compare() {
        return this.CMP;
    }

    @Override
    public Function1<java.lang.Integer, UnsignedInt32Member> signum() {
        return this.SIG;
    }

    @Override
    public Procedure3<UnsignedInt32Member, UnsignedInt32Member, UnsignedInt32Member> div() {
        return this.DIV;
    }

    @Override
    public Procedure3<UnsignedInt32Member, UnsignedInt32Member, UnsignedInt32Member> mod() {
        return this.MOD;
    }

    @Override
    public Procedure4<UnsignedInt32Member, UnsignedInt32Member, UnsignedInt32Member, UnsignedInt32Member> divMod() {
        return this.DIVMOD;
    }

    @Override
    public Procedure3<UnsignedInt32Member, UnsignedInt32Member, UnsignedInt32Member> gcd() {
        return this.GCD;
    }

    @Override
    public Procedure3<UnsignedInt32Member, UnsignedInt32Member, UnsignedInt32Member> lcm() {
        return this.LCM;
    }

    @Override
    public Procedure2<UnsignedInt32Member, UnsignedInt32Member> norm() {
        return this.ASSIGN;
    }

    @Override
    public Function1<Boolean, UnsignedInt32Member> isEven() {
        return this.EVEN;
    }

    @Override
    public Function1<Boolean, UnsignedInt32Member> isOdd() {
        return this.ODD;
    }

    @Override
    public Procedure2<UnsignedInt32Member, UnsignedInt32Member> pred() {
        return this.PRED;
    }

    @Override
    public Procedure2<UnsignedInt32Member, UnsignedInt32Member> succ() {
        return this.SUCC;
    }

    @Override
    public Procedure1<UnsignedInt32Member> maxBound() {
        return this.MAXBOUND;
    }

    @Override
    public Procedure1<UnsignedInt32Member> minBound() {
        return this.MINBOUND;
    }

    @Override
    public Procedure3<UnsignedInt32Member, UnsignedInt32Member, UnsignedInt32Member> bitAnd() {
        return this.BITAND;
    }

    @Override
    public Procedure3<UnsignedInt32Member, UnsignedInt32Member, UnsignedInt32Member> bitOr() {
        return this.BITOR;
    }

    @Override
    public Procedure3<UnsignedInt32Member, UnsignedInt32Member, UnsignedInt32Member> bitXor() {
        return this.BITXOR;
    }

    @Override
    public Procedure2<UnsignedInt32Member, UnsignedInt32Member> bitNot() {
        return this.BITNOT;
    }

    @Override
    public Procedure3<UnsignedInt32Member, UnsignedInt32Member, UnsignedInt32Member> bitAndNot() {
        return this.BITANDNOT;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt32Member, UnsignedInt32Member> bitShiftLeft() {
        return this.BITSHL;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt32Member, UnsignedInt32Member> bitShiftRight() {
        return this.BITSHRZ;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt32Member, UnsignedInt32Member> bitShiftRightFillZero() {
        return this.BITSHRZ;
    }

    @Override
    public Procedure3<UnsignedInt32Member, UnsignedInt32Member, UnsignedInt32Member> min() {
        return this.MIN;
    }

    @Override
    public Procedure3<UnsignedInt32Member, UnsignedInt32Member, UnsignedInt32Member> max() {
        return this.MAX;
    }

    @Override
    public Procedure1<UnsignedInt32Member> random() {
        return this.RAND;
    }

    @Override
    public Procedure3<UnsignedInt32Member, UnsignedInt32Member, UnsignedInt32Member> pow() {
        return this.POW;
    }

    @Override
    public Function1<Boolean, UnsignedInt32Member> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<UnsignedInt32Member, UnsignedInt32Member, UnsignedInt32Member> scale() {
        return this.MUL;
    }

    @Override
    public Procedure3<HighPrecisionMember, UnsignedInt32Member, UnsignedInt32Member> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<HighPrecisionMember, UnsignedInt32Member, UnsignedInt32Member> scaleByHighPrecAndRound() {
        return this.SBHPR;
    }

    @Override
    public Procedure3<RationalMember, UnsignedInt32Member, UnsignedInt32Member> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, UnsignedInt32Member, UnsignedInt32Member> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<Double, UnsignedInt32Member, UnsignedInt32Member> scaleByDoubleAndRound() {
        return this.SBDR;
    }

    @Override
    public Function3<Boolean, UnsignedInt32Member, UnsignedInt32Member, UnsignedInt32Member> within() {
        return this.WITHIN;
    }
}

