/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.int4;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.ThreadLocalRandom;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.Gcd;
import nom.bdezonia.zorbage.algorithm.Lcm;
import nom.bdezonia.zorbage.algorithm.NumberWithin;
import nom.bdezonia.zorbage.algorithm.PowerNonNegative;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.BitOperations;
import nom.bdezonia.zorbage.type.algebra.Bounded;
import nom.bdezonia.zorbage.type.algebra.Integer;
import nom.bdezonia.zorbage.type.algebra.Random;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.int4.SignedInt4Member;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class SignedInt4Algebra
implements Integer<SignedInt4Algebra, SignedInt4Member>,
Bounded<SignedInt4Member>,
BitOperations<SignedInt4Member>,
Random<SignedInt4Member>,
Tolerance<SignedInt4Member, SignedInt4Member> {
    private final Function2<Boolean, SignedInt4Member, SignedInt4Member> EQ = new Function2<Boolean, SignedInt4Member, SignedInt4Member>(){

        @Override
        public Boolean call(SignedInt4Member a, SignedInt4Member b) {
            return a.v == b.v;
        }
    };
    private final Function2<Boolean, SignedInt4Member, SignedInt4Member> NEQ = new Function2<Boolean, SignedInt4Member, SignedInt4Member>(){

        @Override
        public Boolean call(SignedInt4Member a, SignedInt4Member b) {
            return a.v != b.v;
        }
    };
    private final Procedure2<SignedInt4Member, SignedInt4Member> ASSIGN = new Procedure2<SignedInt4Member, SignedInt4Member>(){

        @Override
        public void call(SignedInt4Member a, SignedInt4Member b) {
            b.set(a);
        }
    };
    private final Procedure1<SignedInt4Member> ZER = new Procedure1<SignedInt4Member>(){

        @Override
        public void call(SignedInt4Member a) {
            a.v = 0;
        }
    };
    private final Procedure2<SignedInt4Member, SignedInt4Member> NEG = new Procedure2<SignedInt4Member, SignedInt4Member>(){

        @Override
        public void call(SignedInt4Member a, SignedInt4Member b) {
            if (a.v == -8) {
                throw new IllegalArgumentException("Cannot convert -minint symmetrically");
            }
            b.v = -a.v;
        }
    };
    private final Procedure3<SignedInt4Member, SignedInt4Member, SignedInt4Member> ADD = new Procedure3<SignedInt4Member, SignedInt4Member, SignedInt4Member>(){

        @Override
        public void call(SignedInt4Member a, SignedInt4Member b, SignedInt4Member c) {
            c.setV(a.v + b.v);
        }
    };
    private final Procedure3<SignedInt4Member, SignedInt4Member, SignedInt4Member> SUB = new Procedure3<SignedInt4Member, SignedInt4Member, SignedInt4Member>(){

        @Override
        public void call(SignedInt4Member a, SignedInt4Member b, SignedInt4Member c) {
            c.setV(a.v - b.v);
        }
    };
    private final Procedure3<SignedInt4Member, SignedInt4Member, SignedInt4Member> MUL = new Procedure3<SignedInt4Member, SignedInt4Member, SignedInt4Member>(){

        @Override
        public void call(SignedInt4Member a, SignedInt4Member b, SignedInt4Member c) {
            c.setV(a.v * b.v);
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt4Member, SignedInt4Member> POWER = new Procedure3<java.lang.Integer, SignedInt4Member, SignedInt4Member>(){

        @Override
        public void call(java.lang.Integer power, SignedInt4Member a, SignedInt4Member b) {
            PowerNonNegative.compute(G.INT4, power, a, b);
        }
    };
    private final Procedure1<SignedInt4Member> UNITY = new Procedure1<SignedInt4Member>(){

        @Override
        public void call(SignedInt4Member a) {
            a.v = 1;
        }
    };
    private final Function2<Boolean, SignedInt4Member, SignedInt4Member> LESS = new Function2<Boolean, SignedInt4Member, SignedInt4Member>(){

        @Override
        public Boolean call(SignedInt4Member a, SignedInt4Member b) {
            return a.v < b.v;
        }
    };
    private final Function2<Boolean, SignedInt4Member, SignedInt4Member> LE = new Function2<Boolean, SignedInt4Member, SignedInt4Member>(){

        @Override
        public Boolean call(SignedInt4Member a, SignedInt4Member b) {
            return a.v <= b.v;
        }
    };
    private final Function2<Boolean, SignedInt4Member, SignedInt4Member> GREAT = new Function2<Boolean, SignedInt4Member, SignedInt4Member>(){

        @Override
        public Boolean call(SignedInt4Member a, SignedInt4Member b) {
            return a.v > b.v;
        }
    };
    private final Function2<Boolean, SignedInt4Member, SignedInt4Member> GE = new Function2<Boolean, SignedInt4Member, SignedInt4Member>(){

        @Override
        public Boolean call(SignedInt4Member a, SignedInt4Member b) {
            return a.v >= b.v;
        }
    };
    private final Function2<java.lang.Integer, SignedInt4Member, SignedInt4Member> CMP = new Function2<java.lang.Integer, SignedInt4Member, SignedInt4Member>(){

        @Override
        public java.lang.Integer call(SignedInt4Member a, SignedInt4Member b) {
            if (a.v < b.v) {
                return -1;
            }
            if (a.v > b.v) {
                return 1;
            }
            return 0;
        }
    };
    private final Function1<java.lang.Integer, SignedInt4Member> SIG = new Function1<java.lang.Integer, SignedInt4Member>(){

        @Override
        public java.lang.Integer call(SignedInt4Member a) {
            if (a.v < 0) {
                return -1;
            }
            if (a.v > 0) {
                return 1;
            }
            return 0;
        }
    };
    private final Procedure3<SignedInt4Member, SignedInt4Member, SignedInt4Member> MIN = new Procedure3<SignedInt4Member, SignedInt4Member, SignedInt4Member>(){

        @Override
        public void call(SignedInt4Member a, SignedInt4Member b, SignedInt4Member c) {
            if (a.v < b.v) {
                c.set(a);
            } else {
                c.set(b);
            }
        }
    };
    private final Procedure3<SignedInt4Member, SignedInt4Member, SignedInt4Member> MAX = new Procedure3<SignedInt4Member, SignedInt4Member, SignedInt4Member>(){

        @Override
        public void call(SignedInt4Member a, SignedInt4Member b, SignedInt4Member c) {
            if (a.v > b.v) {
                c.set(a);
            } else {
                c.set(b);
            }
        }
    };
    private final Procedure2<SignedInt4Member, SignedInt4Member> ABS = new Procedure2<SignedInt4Member, SignedInt4Member>(){

        @Override
        public void call(SignedInt4Member a, SignedInt4Member b) {
            if (a.v == -8) {
                throw new IllegalArgumentException("Cannot convert -minint symmetrically");
            }
            b.v = a.v < 0 ? (byte)(-a.v) : a.v;
        }
    };
    private final Procedure3<SignedInt4Member, SignedInt4Member, SignedInt4Member> GCD = new Procedure3<SignedInt4Member, SignedInt4Member, SignedInt4Member>(){

        @Override
        public void call(SignedInt4Member a, SignedInt4Member b, SignedInt4Member c) {
            Gcd.compute(G.INT4, a, b, c);
        }
    };
    private final Procedure3<SignedInt4Member, SignedInt4Member, SignedInt4Member> LCM = new Procedure3<SignedInt4Member, SignedInt4Member, SignedInt4Member>(){

        @Override
        public void call(SignedInt4Member a, SignedInt4Member b, SignedInt4Member c) {
            Lcm.compute(G.INT4, a, b, c);
        }
    };
    private final Function1<Boolean, SignedInt4Member> EVEN = new Function1<Boolean, SignedInt4Member>(){

        @Override
        public Boolean call(SignedInt4Member a) {
            return (a.v & 1) == 0;
        }
    };
    private final Function1<Boolean, SignedInt4Member> ODD = new Function1<Boolean, SignedInt4Member>(){

        @Override
        public Boolean call(SignedInt4Member a) {
            return (a.v & 1) == 1;
        }
    };
    private final Procedure3<SignedInt4Member, SignedInt4Member, SignedInt4Member> DIV = new Procedure3<SignedInt4Member, SignedInt4Member, SignedInt4Member>(){

        @Override
        public void call(SignedInt4Member a, SignedInt4Member b, SignedInt4Member d) {
            if (b.v == -1 && a.v == -8) {
                throw new IllegalArgumentException("cannot divide minint by -1");
            }
            d.setV(a.v / b.v);
        }
    };
    private final Procedure3<SignedInt4Member, SignedInt4Member, SignedInt4Member> MOD = new Procedure3<SignedInt4Member, SignedInt4Member, SignedInt4Member>(){

        @Override
        public void call(SignedInt4Member a, SignedInt4Member b, SignedInt4Member m) {
            m.setV(a.v % b.v);
        }
    };
    private final Procedure4<SignedInt4Member, SignedInt4Member, SignedInt4Member, SignedInt4Member> DIVMOD = new Procedure4<SignedInt4Member, SignedInt4Member, SignedInt4Member, SignedInt4Member>(){

        @Override
        public void call(SignedInt4Member a, SignedInt4Member b, SignedInt4Member d, SignedInt4Member m) {
            SignedInt4Algebra.this.div().call(a, b, d);
            SignedInt4Algebra.this.mod().call(a, b, m);
        }
    };
    private final Procedure2<SignedInt4Member, SignedInt4Member> PRED = new Procedure2<SignedInt4Member, SignedInt4Member>(){

        @Override
        public void call(SignedInt4Member a, SignedInt4Member b) {
            if (a.v == -8) {
                b.v = (byte)7;
            } else {
                b.setV(a.v - 1);
            }
        }
    };
    private final Procedure2<SignedInt4Member, SignedInt4Member> SUCC = new Procedure2<SignedInt4Member, SignedInt4Member>(){

        @Override
        public void call(SignedInt4Member a, SignedInt4Member b) {
            if (a.v == 7) {
                b.v = (byte)-8;
            } else {
                b.setV(a.v + 1);
            }
        }
    };
    private final Procedure3<SignedInt4Member, SignedInt4Member, SignedInt4Member> POW = new Procedure3<SignedInt4Member, SignedInt4Member, SignedInt4Member>(){

        @Override
        public void call(SignedInt4Member a, SignedInt4Member b, SignedInt4Member c) {
            PowerNonNegative.compute(G.INT4, b.v, a, c);
        }
    };
    private final Procedure1<SignedInt4Member> RAND = new Procedure1<SignedInt4Member>(){

        @Override
        public void call(SignedInt4Member a) {
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            a.setV(rng.nextInt(16) - 8);
        }
    };
    private final Procedure3<SignedInt4Member, SignedInt4Member, SignedInt4Member> AND = new Procedure3<SignedInt4Member, SignedInt4Member, SignedInt4Member>(){

        @Override
        public void call(SignedInt4Member a, SignedInt4Member b, SignedInt4Member c) {
            c.setV(a.v & b.v);
        }
    };
    private final Procedure3<SignedInt4Member, SignedInt4Member, SignedInt4Member> OR = new Procedure3<SignedInt4Member, SignedInt4Member, SignedInt4Member>(){

        @Override
        public void call(SignedInt4Member a, SignedInt4Member b, SignedInt4Member c) {
            c.setV(a.v | b.v);
        }
    };
    private final Procedure3<SignedInt4Member, SignedInt4Member, SignedInt4Member> XOR = new Procedure3<SignedInt4Member, SignedInt4Member, SignedInt4Member>(){

        @Override
        public void call(SignedInt4Member a, SignedInt4Member b, SignedInt4Member c) {
            c.setV(a.v ^ b.v);
        }
    };
    private final Procedure2<SignedInt4Member, SignedInt4Member> NOT = new Procedure2<SignedInt4Member, SignedInt4Member>(){

        @Override
        public void call(SignedInt4Member a, SignedInt4Member b) {
            b.setV(~a.v);
        }
    };
    private final Procedure3<SignedInt4Member, SignedInt4Member, SignedInt4Member> ANDNOT = new Procedure3<SignedInt4Member, SignedInt4Member, SignedInt4Member>(){

        @Override
        public void call(SignedInt4Member a, SignedInt4Member b, SignedInt4Member c) {
            c.setV(a.v & ~b.v);
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt4Member, SignedInt4Member> SHL = new Procedure3<java.lang.Integer, SignedInt4Member, SignedInt4Member>(){

        @Override
        public void call(java.lang.Integer count, SignedInt4Member a, SignedInt4Member b) {
            if (count < 0) {
                SignedInt4Algebra.this.bitShiftRight().call(-count.intValue(), a, b);
            } else {
                count = count % 4;
                b.setV(a.v << count);
            }
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt4Member, SignedInt4Member> SHR = new Procedure3<java.lang.Integer, SignedInt4Member, SignedInt4Member>(){

        @Override
        public void call(java.lang.Integer count, SignedInt4Member a, SignedInt4Member b) {
            if (count < 0) {
                SignedInt4Algebra.this.bitShiftLeft().call(-count.intValue(), a, b);
            } else {
                int val = a.v >> count;
                if (a.v < 0 && val == 0) {
                    b.v = (byte)-1;
                } else {
                    b.setV(val);
                }
            }
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt4Member, SignedInt4Member> SHRZ = new Procedure3<java.lang.Integer, SignedInt4Member, SignedInt4Member>(){

        @Override
        public void call(java.lang.Integer count, SignedInt4Member a, SignedInt4Member b) {
            if (count < 0) {
                SignedInt4Algebra.this.bitShiftLeft().call(-count.intValue(), a, b);
            } else {
                b.setV(a.v >>> count);
            }
        }
    };
    private final Procedure1<SignedInt4Member> MAXBOUND = new Procedure1<SignedInt4Member>(){

        @Override
        public void call(SignedInt4Member a) {
            a.v = (byte)7;
        }
    };
    private final Procedure1<SignedInt4Member> MINBOUND = new Procedure1<SignedInt4Member>(){

        @Override
        public void call(SignedInt4Member a) {
            a.v = (byte)-8;
        }
    };
    private final Function1<Boolean, SignedInt4Member> ISZERO = new Function1<Boolean, SignedInt4Member>(){

        @Override
        public Boolean call(SignedInt4Member a) {
            return a.v == 0;
        }
    };
    private final Procedure3<HighPrecisionMember, SignedInt4Member, SignedInt4Member> SBHP = new Procedure3<HighPrecisionMember, SignedInt4Member, SignedInt4Member>(){

        @Override
        public void call(HighPrecisionMember a, SignedInt4Member b, SignedInt4Member c) {
            BigDecimal tmp = a.v();
            tmp = tmp.multiply(new BigDecimal(b.v()));
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<HighPrecisionMember, SignedInt4Member, SignedInt4Member> SBHPR = new Procedure3<HighPrecisionMember, SignedInt4Member, SignedInt4Member>(){

        @Override
        public void call(HighPrecisionMember a, SignedInt4Member b, SignedInt4Member c) {
            BigDecimal tmp = a.v();
            int signum = (tmp = tmp.multiply(new BigDecimal(b.v()))).signum();
            tmp = signum < 0 ? tmp.subtract(G.ONE_HALF) : tmp.add(G.ONE_HALF);
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<RationalMember, SignedInt4Member, SignedInt4Member> SBR = new Procedure3<RationalMember, SignedInt4Member, SignedInt4Member>(){

        @Override
        public void call(RationalMember a, SignedInt4Member b, SignedInt4Member c) {
            BigInteger tmp = BigInteger.valueOf(b.v());
            tmp = tmp.multiply(a.n());
            tmp = tmp.divide(a.d());
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<Double, SignedInt4Member, SignedInt4Member> SBD = new Procedure3<Double, SignedInt4Member, SignedInt4Member>(){

        @Override
        public void call(Double a, SignedInt4Member b, SignedInt4Member c) {
            c.setV((int)(a * (double)b.v()));
        }
    };
    private final Procedure3<Double, SignedInt4Member, SignedInt4Member> SBDR = new Procedure3<Double, SignedInt4Member, SignedInt4Member>(){

        @Override
        public void call(Double a, SignedInt4Member b, SignedInt4Member c) {
            c.setV((int)Math.round(a * (double)b.v()));
        }
    };
    private final Function3<Boolean, SignedInt4Member, SignedInt4Member, SignedInt4Member> WITHIN = new Function3<Boolean, SignedInt4Member, SignedInt4Member, SignedInt4Member>(){

        @Override
        public Boolean call(SignedInt4Member tol, SignedInt4Member a, SignedInt4Member b) {
            return NumberWithin.compute(G.INT4, tol, a, b);
        }
    };

    @Override
    public SignedInt4Member construct() {
        return new SignedInt4Member();
    }

    @Override
    public SignedInt4Member construct(SignedInt4Member other) {
        return new SignedInt4Member(other);
    }

    @Override
    public SignedInt4Member construct(String str) {
        return new SignedInt4Member(str);
    }

    @Override
    public Function2<Boolean, SignedInt4Member, SignedInt4Member> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, SignedInt4Member, SignedInt4Member> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<SignedInt4Member, SignedInt4Member> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure1<SignedInt4Member> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<SignedInt4Member, SignedInt4Member> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<SignedInt4Member, SignedInt4Member, SignedInt4Member> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<SignedInt4Member, SignedInt4Member, SignedInt4Member> subtract() {
        return this.SUB;
    }

    @Override
    public Procedure3<SignedInt4Member, SignedInt4Member, SignedInt4Member> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt4Member, SignedInt4Member> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<SignedInt4Member> unity() {
        return this.UNITY;
    }

    @Override
    public Function2<Boolean, SignedInt4Member, SignedInt4Member> isLess() {
        return this.LESS;
    }

    @Override
    public Function2<Boolean, SignedInt4Member, SignedInt4Member> isLessEqual() {
        return this.LE;
    }

    @Override
    public Function2<Boolean, SignedInt4Member, SignedInt4Member> isGreater() {
        return this.GREAT;
    }

    @Override
    public Function2<Boolean, SignedInt4Member, SignedInt4Member> isGreaterEqual() {
        return this.GE;
    }

    @Override
    public Function2<java.lang.Integer, SignedInt4Member, SignedInt4Member> compare() {
        return this.CMP;
    }

    @Override
    public Function1<java.lang.Integer, SignedInt4Member> signum() {
        return this.SIG;
    }

    @Override
    public Procedure3<SignedInt4Member, SignedInt4Member, SignedInt4Member> min() {
        return this.MIN;
    }

    @Override
    public Procedure3<SignedInt4Member, SignedInt4Member, SignedInt4Member> max() {
        return this.MAX;
    }

    @Override
    public Procedure2<SignedInt4Member, SignedInt4Member> abs() {
        return this.ABS;
    }

    @Override
    public Procedure2<SignedInt4Member, SignedInt4Member> norm() {
        return this.ABS;
    }

    @Override
    public Procedure3<SignedInt4Member, SignedInt4Member, SignedInt4Member> gcd() {
        return this.GCD;
    }

    @Override
    public Procedure3<SignedInt4Member, SignedInt4Member, SignedInt4Member> lcm() {
        return this.LCM;
    }

    @Override
    public Function1<Boolean, SignedInt4Member> isEven() {
        return this.EVEN;
    }

    @Override
    public Function1<Boolean, SignedInt4Member> isOdd() {
        return this.ODD;
    }

    @Override
    public Procedure3<SignedInt4Member, SignedInt4Member, SignedInt4Member> div() {
        return this.DIV;
    }

    @Override
    public Procedure3<SignedInt4Member, SignedInt4Member, SignedInt4Member> mod() {
        return this.MOD;
    }

    @Override
    public Procedure4<SignedInt4Member, SignedInt4Member, SignedInt4Member, SignedInt4Member> divMod() {
        return this.DIVMOD;
    }

    @Override
    public Procedure2<SignedInt4Member, SignedInt4Member> pred() {
        return this.PRED;
    }

    @Override
    public Procedure2<SignedInt4Member, SignedInt4Member> succ() {
        return this.SUCC;
    }

    @Override
    public Procedure3<SignedInt4Member, SignedInt4Member, SignedInt4Member> pow() {
        return this.POW;
    }

    @Override
    public Procedure1<SignedInt4Member> random() {
        return this.RAND;
    }

    @Override
    public Procedure3<SignedInt4Member, SignedInt4Member, SignedInt4Member> bitAnd() {
        return this.AND;
    }

    @Override
    public Procedure3<SignedInt4Member, SignedInt4Member, SignedInt4Member> bitOr() {
        return this.OR;
    }

    @Override
    public Procedure3<SignedInt4Member, SignedInt4Member, SignedInt4Member> bitXor() {
        return this.XOR;
    }

    @Override
    public Procedure2<SignedInt4Member, SignedInt4Member> bitNot() {
        return this.NOT;
    }

    @Override
    public Procedure3<SignedInt4Member, SignedInt4Member, SignedInt4Member> bitAndNot() {
        return this.ANDNOT;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt4Member, SignedInt4Member> bitShiftLeft() {
        return this.SHL;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt4Member, SignedInt4Member> bitShiftRight() {
        return this.SHR;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt4Member, SignedInt4Member> bitShiftRightFillZero() {
        return this.SHRZ;
    }

    @Override
    public Procedure1<SignedInt4Member> maxBound() {
        return this.MAXBOUND;
    }

    @Override
    public Procedure1<SignedInt4Member> minBound() {
        return this.MINBOUND;
    }

    @Override
    public Function1<Boolean, SignedInt4Member> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<SignedInt4Member, SignedInt4Member, SignedInt4Member> scale() {
        return this.MUL;
    }

    @Override
    public Procedure3<HighPrecisionMember, SignedInt4Member, SignedInt4Member> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<HighPrecisionMember, SignedInt4Member, SignedInt4Member> scaleByHighPrecAndRound() {
        return this.SBHPR;
    }

    @Override
    public Procedure3<RationalMember, SignedInt4Member, SignedInt4Member> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, SignedInt4Member, SignedInt4Member> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<Double, SignedInt4Member, SignedInt4Member> scaleByDoubleAndRound() {
        return this.SBDR;
    }

    @Override
    public Function3<Boolean, SignedInt4Member, SignedInt4Member, SignedInt4Member> within() {
        return this.WITHIN;
    }
}

