/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.int4;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.ThreadLocalRandom;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.Gcd;
import nom.bdezonia.zorbage.algorithm.Lcm;
import nom.bdezonia.zorbage.algorithm.NumberWithin;
import nom.bdezonia.zorbage.algorithm.PowerNonNegative;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.BitOperations;
import nom.bdezonia.zorbage.type.algebra.Bounded;
import nom.bdezonia.zorbage.type.algebra.Integer;
import nom.bdezonia.zorbage.type.algebra.Random;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.int4.UnsignedInt4Member;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class UnsignedInt4Algebra
implements Integer<UnsignedInt4Algebra, UnsignedInt4Member>,
Bounded<UnsignedInt4Member>,
BitOperations<UnsignedInt4Member>,
Random<UnsignedInt4Member>,
Tolerance<UnsignedInt4Member, UnsignedInt4Member> {
    private final Function2<Boolean, UnsignedInt4Member, UnsignedInt4Member> EQ = new Function2<Boolean, UnsignedInt4Member, UnsignedInt4Member>(){

        @Override
        public Boolean call(UnsignedInt4Member a, UnsignedInt4Member b) {
            return a.v == b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt4Member, UnsignedInt4Member> NEQ = new Function2<Boolean, UnsignedInt4Member, UnsignedInt4Member>(){

        @Override
        public Boolean call(UnsignedInt4Member a, UnsignedInt4Member b) {
            return a.v != b.v;
        }
    };
    private final Procedure2<UnsignedInt4Member, UnsignedInt4Member> ASSIGN = new Procedure2<UnsignedInt4Member, UnsignedInt4Member>(){

        @Override
        public void call(UnsignedInt4Member a, UnsignedInt4Member b) {
            b.set(a);
        }
    };
    private final Procedure1<UnsignedInt4Member> ZER = new Procedure1<UnsignedInt4Member>(){

        @Override
        public void call(UnsignedInt4Member a) {
            a.v = 0;
        }
    };
    private final Procedure3<UnsignedInt4Member, UnsignedInt4Member, UnsignedInt4Member> ADD = new Procedure3<UnsignedInt4Member, UnsignedInt4Member, UnsignedInt4Member>(){

        @Override
        public void call(UnsignedInt4Member a, UnsignedInt4Member b, UnsignedInt4Member c) {
            c.setV(a.v + b.v);
        }
    };
    private final Procedure3<UnsignedInt4Member, UnsignedInt4Member, UnsignedInt4Member> SUB = new Procedure3<UnsignedInt4Member, UnsignedInt4Member, UnsignedInt4Member>(){

        @Override
        public void call(UnsignedInt4Member a, UnsignedInt4Member b, UnsignedInt4Member c) {
            c.setV(a.v - b.v);
        }
    };
    private final Procedure3<UnsignedInt4Member, UnsignedInt4Member, UnsignedInt4Member> MUL = new Procedure3<UnsignedInt4Member, UnsignedInt4Member, UnsignedInt4Member>(){

        @Override
        public void call(UnsignedInt4Member a, UnsignedInt4Member b, UnsignedInt4Member c) {
            c.setV(a.v * b.v);
        }
    };
    private final Procedure3<java.lang.Integer, UnsignedInt4Member, UnsignedInt4Member> POWER = new Procedure3<java.lang.Integer, UnsignedInt4Member, UnsignedInt4Member>(){

        @Override
        public void call(java.lang.Integer power, UnsignedInt4Member a, UnsignedInt4Member b) {
            PowerNonNegative.compute(G.UINT4, power, a, b);
        }
    };
    private final Procedure1<UnsignedInt4Member> UNITY = new Procedure1<UnsignedInt4Member>(){

        @Override
        public void call(UnsignedInt4Member a) {
            a.v = 1;
        }
    };
    private final Function2<Boolean, UnsignedInt4Member, UnsignedInt4Member> LESS = new Function2<Boolean, UnsignedInt4Member, UnsignedInt4Member>(){

        @Override
        public Boolean call(UnsignedInt4Member a, UnsignedInt4Member b) {
            return a.v < b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt4Member, UnsignedInt4Member> LE = new Function2<Boolean, UnsignedInt4Member, UnsignedInt4Member>(){

        @Override
        public Boolean call(UnsignedInt4Member a, UnsignedInt4Member b) {
            return a.v <= b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt4Member, UnsignedInt4Member> GREAT = new Function2<Boolean, UnsignedInt4Member, UnsignedInt4Member>(){

        @Override
        public Boolean call(UnsignedInt4Member a, UnsignedInt4Member b) {
            return a.v > b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt4Member, UnsignedInt4Member> GE = new Function2<Boolean, UnsignedInt4Member, UnsignedInt4Member>(){

        @Override
        public Boolean call(UnsignedInt4Member a, UnsignedInt4Member b) {
            return a.v >= b.v;
        }
    };
    private final Function2<java.lang.Integer, UnsignedInt4Member, UnsignedInt4Member> CMP = new Function2<java.lang.Integer, UnsignedInt4Member, UnsignedInt4Member>(){

        @Override
        public java.lang.Integer call(UnsignedInt4Member a, UnsignedInt4Member b) {
            if (a.v < b.v) {
                return -1;
            }
            if (a.v > b.v) {
                return 1;
            }
            return 0;
        }
    };
    private final Function1<java.lang.Integer, UnsignedInt4Member> SIG = new Function1<java.lang.Integer, UnsignedInt4Member>(){

        @Override
        public java.lang.Integer call(UnsignedInt4Member a) {
            if (a.v < 0) {
                return -1;
            }
            if (a.v > 0) {
                return 1;
            }
            return 0;
        }
    };
    private final Procedure3<UnsignedInt4Member, UnsignedInt4Member, UnsignedInt4Member> MIN = new Procedure3<UnsignedInt4Member, UnsignedInt4Member, UnsignedInt4Member>(){

        @Override
        public void call(UnsignedInt4Member a, UnsignedInt4Member b, UnsignedInt4Member c) {
            if (a.v < b.v) {
                c.set(a);
            } else {
                c.set(b);
            }
        }
    };
    private final Procedure3<UnsignedInt4Member, UnsignedInt4Member, UnsignedInt4Member> MAX = new Procedure3<UnsignedInt4Member, UnsignedInt4Member, UnsignedInt4Member>(){

        @Override
        public void call(UnsignedInt4Member a, UnsignedInt4Member b, UnsignedInt4Member c) {
            if (a.v > b.v) {
                c.set(a);
            } else {
                c.set(b);
            }
        }
    };
    private final Procedure3<UnsignedInt4Member, UnsignedInt4Member, UnsignedInt4Member> GCD = new Procedure3<UnsignedInt4Member, UnsignedInt4Member, UnsignedInt4Member>(){

        @Override
        public void call(UnsignedInt4Member a, UnsignedInt4Member b, UnsignedInt4Member c) {
            Gcd.compute(G.UINT4, a, b, c);
        }
    };
    private final Procedure3<UnsignedInt4Member, UnsignedInt4Member, UnsignedInt4Member> LCM = new Procedure3<UnsignedInt4Member, UnsignedInt4Member, UnsignedInt4Member>(){

        @Override
        public void call(UnsignedInt4Member a, UnsignedInt4Member b, UnsignedInt4Member c) {
            Lcm.compute(G.UINT4, a, b, c);
        }
    };
    private final Function1<Boolean, UnsignedInt4Member> EVEN = new Function1<Boolean, UnsignedInt4Member>(){

        @Override
        public Boolean call(UnsignedInt4Member a) {
            return (a.v & 1) == 0;
        }
    };
    private final Function1<Boolean, UnsignedInt4Member> ODD = new Function1<Boolean, UnsignedInt4Member>(){

        @Override
        public Boolean call(UnsignedInt4Member a) {
            return (a.v & 1) == 1;
        }
    };
    private final Procedure3<UnsignedInt4Member, UnsignedInt4Member, UnsignedInt4Member> DIV = new Procedure3<UnsignedInt4Member, UnsignedInt4Member, UnsignedInt4Member>(){

        @Override
        public void call(UnsignedInt4Member a, UnsignedInt4Member b, UnsignedInt4Member d) {
            d.setV(a.v / b.v);
        }
    };
    private final Procedure3<UnsignedInt4Member, UnsignedInt4Member, UnsignedInt4Member> MOD = new Procedure3<UnsignedInt4Member, UnsignedInt4Member, UnsignedInt4Member>(){

        @Override
        public void call(UnsignedInt4Member a, UnsignedInt4Member b, UnsignedInt4Member m) {
            m.setV(a.v % b.v);
        }
    };
    private final Procedure4<UnsignedInt4Member, UnsignedInt4Member, UnsignedInt4Member, UnsignedInt4Member> DIVMOD = new Procedure4<UnsignedInt4Member, UnsignedInt4Member, UnsignedInt4Member, UnsignedInt4Member>(){

        @Override
        public void call(UnsignedInt4Member a, UnsignedInt4Member b, UnsignedInt4Member d, UnsignedInt4Member m) {
            UnsignedInt4Algebra.this.div().call(a, b, d);
            UnsignedInt4Algebra.this.mod().call(a, b, m);
        }
    };
    private final Procedure2<UnsignedInt4Member, UnsignedInt4Member> PRED = new Procedure2<UnsignedInt4Member, UnsignedInt4Member>(){

        @Override
        public void call(UnsignedInt4Member a, UnsignedInt4Member b) {
            if (a.v == 0) {
                b.v = (byte)15;
            } else {
                b.setV(a.v - 1);
            }
        }
    };
    private final Procedure2<UnsignedInt4Member, UnsignedInt4Member> SUCC = new Procedure2<UnsignedInt4Member, UnsignedInt4Member>(){

        @Override
        public void call(UnsignedInt4Member a, UnsignedInt4Member b) {
            if (a.v == 15) {
                b.v = 0;
            } else {
                b.setV(a.v + 1);
            }
        }
    };
    private final Procedure3<UnsignedInt4Member, UnsignedInt4Member, UnsignedInt4Member> POW = new Procedure3<UnsignedInt4Member, UnsignedInt4Member, UnsignedInt4Member>(){

        @Override
        public void call(UnsignedInt4Member a, UnsignedInt4Member b, UnsignedInt4Member c) {
            PowerNonNegative.compute(G.UINT4, b.v, a, c);
        }
    };
    private final Procedure1<UnsignedInt4Member> RAND = new Procedure1<UnsignedInt4Member>(){

        @Override
        public void call(UnsignedInt4Member a) {
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            a.setV(rng.nextInt(16));
        }
    };
    private final Procedure3<UnsignedInt4Member, UnsignedInt4Member, UnsignedInt4Member> AND = new Procedure3<UnsignedInt4Member, UnsignedInt4Member, UnsignedInt4Member>(){

        @Override
        public void call(UnsignedInt4Member a, UnsignedInt4Member b, UnsignedInt4Member c) {
            c.setV(a.v & b.v);
        }
    };
    private final Procedure3<UnsignedInt4Member, UnsignedInt4Member, UnsignedInt4Member> OR = new Procedure3<UnsignedInt4Member, UnsignedInt4Member, UnsignedInt4Member>(){

        @Override
        public void call(UnsignedInt4Member a, UnsignedInt4Member b, UnsignedInt4Member c) {
            c.setV(a.v | b.v);
        }
    };
    private final Procedure3<UnsignedInt4Member, UnsignedInt4Member, UnsignedInt4Member> XOR = new Procedure3<UnsignedInt4Member, UnsignedInt4Member, UnsignedInt4Member>(){

        @Override
        public void call(UnsignedInt4Member a, UnsignedInt4Member b, UnsignedInt4Member c) {
            c.setV(a.v ^ b.v);
        }
    };
    private final Procedure2<UnsignedInt4Member, UnsignedInt4Member> NOT = new Procedure2<UnsignedInt4Member, UnsignedInt4Member>(){

        @Override
        public void call(UnsignedInt4Member a, UnsignedInt4Member b) {
            b.setV(~a.v);
        }
    };
    private final Procedure3<UnsignedInt4Member, UnsignedInt4Member, UnsignedInt4Member> ANDNOT = new Procedure3<UnsignedInt4Member, UnsignedInt4Member, UnsignedInt4Member>(){

        @Override
        public void call(UnsignedInt4Member a, UnsignedInt4Member b, UnsignedInt4Member c) {
            c.setV(a.v & ~b.v);
        }
    };
    private final Procedure3<java.lang.Integer, UnsignedInt4Member, UnsignedInt4Member> SHL = new Procedure3<java.lang.Integer, UnsignedInt4Member, UnsignedInt4Member>(){

        @Override
        public void call(java.lang.Integer count, UnsignedInt4Member a, UnsignedInt4Member b) {
            if (count < 0) {
                UnsignedInt4Algebra.this.bitShiftRight().call(-count.intValue(), a, b);
            } else {
                count = count % 4;
                b.setV(a.v << count);
            }
        }
    };
    private final Procedure3<java.lang.Integer, UnsignedInt4Member, UnsignedInt4Member> SHRZ = new Procedure3<java.lang.Integer, UnsignedInt4Member, UnsignedInt4Member>(){

        @Override
        public void call(java.lang.Integer count, UnsignedInt4Member a, UnsignedInt4Member b) {
            if (count < 0) {
                UnsignedInt4Algebra.this.bitShiftLeft().call(-count.intValue(), a, b);
            } else {
                b.setV(a.v >>> count);
            }
        }
    };
    private final Procedure1<UnsignedInt4Member> MAXBOUND = new Procedure1<UnsignedInt4Member>(){

        @Override
        public void call(UnsignedInt4Member a) {
            a.v = (byte)15;
        }
    };
    private final Procedure1<UnsignedInt4Member> MINBOUND = new Procedure1<UnsignedInt4Member>(){

        @Override
        public void call(UnsignedInt4Member a) {
            a.v = 0;
        }
    };
    private final Function1<Boolean, UnsignedInt4Member> ISZERO = new Function1<Boolean, UnsignedInt4Member>(){

        @Override
        public Boolean call(UnsignedInt4Member a) {
            return a.v == 0;
        }
    };
    private final Procedure3<HighPrecisionMember, UnsignedInt4Member, UnsignedInt4Member> SBHP = new Procedure3<HighPrecisionMember, UnsignedInt4Member, UnsignedInt4Member>(){

        @Override
        public void call(HighPrecisionMember a, UnsignedInt4Member b, UnsignedInt4Member c) {
            BigDecimal tmp = a.v();
            tmp = tmp.multiply(new BigDecimal(b.v()));
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<HighPrecisionMember, UnsignedInt4Member, UnsignedInt4Member> SBHPR = new Procedure3<HighPrecisionMember, UnsignedInt4Member, UnsignedInt4Member>(){

        @Override
        public void call(HighPrecisionMember a, UnsignedInt4Member b, UnsignedInt4Member c) {
            BigDecimal tmp = a.v();
            int signum = (tmp = tmp.multiply(new BigDecimal(b.v()))).signum();
            tmp = signum < 0 ? tmp.subtract(G.ONE_HALF) : tmp.add(G.ONE_HALF);
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<RationalMember, UnsignedInt4Member, UnsignedInt4Member> SBR = new Procedure3<RationalMember, UnsignedInt4Member, UnsignedInt4Member>(){

        @Override
        public void call(RationalMember a, UnsignedInt4Member b, UnsignedInt4Member c) {
            BigInteger tmp = BigInteger.valueOf(b.v());
            tmp = tmp.multiply(a.n());
            tmp = tmp.divide(a.d());
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<Double, UnsignedInt4Member, UnsignedInt4Member> SBD = new Procedure3<Double, UnsignedInt4Member, UnsignedInt4Member>(){

        @Override
        public void call(Double a, UnsignedInt4Member b, UnsignedInt4Member c) {
            c.setV((int)(a * (double)b.v()));
        }
    };
    private final Procedure3<Double, UnsignedInt4Member, UnsignedInt4Member> SBDR = new Procedure3<Double, UnsignedInt4Member, UnsignedInt4Member>(){

        @Override
        public void call(Double a, UnsignedInt4Member b, UnsignedInt4Member c) {
            c.setV((int)Math.round(a * (double)b.v()));
        }
    };
    private final Function3<Boolean, UnsignedInt4Member, UnsignedInt4Member, UnsignedInt4Member> WITHIN = new Function3<Boolean, UnsignedInt4Member, UnsignedInt4Member, UnsignedInt4Member>(){

        @Override
        public Boolean call(UnsignedInt4Member tol, UnsignedInt4Member a, UnsignedInt4Member b) {
            return NumberWithin.compute(G.UINT4, tol, a, b);
        }
    };

    @Override
    public UnsignedInt4Member construct() {
        return new UnsignedInt4Member();
    }

    @Override
    public UnsignedInt4Member construct(UnsignedInt4Member other) {
        return new UnsignedInt4Member(other);
    }

    @Override
    public UnsignedInt4Member construct(String str) {
        return new UnsignedInt4Member(str);
    }

    @Override
    public Function2<Boolean, UnsignedInt4Member, UnsignedInt4Member> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, UnsignedInt4Member, UnsignedInt4Member> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<UnsignedInt4Member, UnsignedInt4Member> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure1<UnsignedInt4Member> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<UnsignedInt4Member, UnsignedInt4Member> negate() {
        return this.ASSIGN;
    }

    @Override
    public Procedure3<UnsignedInt4Member, UnsignedInt4Member, UnsignedInt4Member> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<UnsignedInt4Member, UnsignedInt4Member, UnsignedInt4Member> subtract() {
        return this.SUB;
    }

    @Override
    public Procedure3<UnsignedInt4Member, UnsignedInt4Member, UnsignedInt4Member> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt4Member, UnsignedInt4Member> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<UnsignedInt4Member> unity() {
        return this.UNITY;
    }

    @Override
    public Function2<Boolean, UnsignedInt4Member, UnsignedInt4Member> isLess() {
        return this.LESS;
    }

    @Override
    public Function2<Boolean, UnsignedInt4Member, UnsignedInt4Member> isLessEqual() {
        return this.LE;
    }

    @Override
    public Function2<Boolean, UnsignedInt4Member, UnsignedInt4Member> isGreater() {
        return this.GREAT;
    }

    @Override
    public Function2<Boolean, UnsignedInt4Member, UnsignedInt4Member> isGreaterEqual() {
        return this.GE;
    }

    @Override
    public Function2<java.lang.Integer, UnsignedInt4Member, UnsignedInt4Member> compare() {
        return this.CMP;
    }

    @Override
    public Function1<java.lang.Integer, UnsignedInt4Member> signum() {
        return this.SIG;
    }

    @Override
    public Procedure3<UnsignedInt4Member, UnsignedInt4Member, UnsignedInt4Member> min() {
        return this.MIN;
    }

    @Override
    public Procedure3<UnsignedInt4Member, UnsignedInt4Member, UnsignedInt4Member> max() {
        return this.MAX;
    }

    @Override
    public Procedure2<UnsignedInt4Member, UnsignedInt4Member> abs() {
        return this.ASSIGN;
    }

    @Override
    public Procedure2<UnsignedInt4Member, UnsignedInt4Member> norm() {
        return this.ASSIGN;
    }

    @Override
    public Procedure3<UnsignedInt4Member, UnsignedInt4Member, UnsignedInt4Member> gcd() {
        return this.GCD;
    }

    @Override
    public Procedure3<UnsignedInt4Member, UnsignedInt4Member, UnsignedInt4Member> lcm() {
        return this.LCM;
    }

    @Override
    public Function1<Boolean, UnsignedInt4Member> isEven() {
        return this.EVEN;
    }

    @Override
    public Function1<Boolean, UnsignedInt4Member> isOdd() {
        return this.ODD;
    }

    @Override
    public Procedure3<UnsignedInt4Member, UnsignedInt4Member, UnsignedInt4Member> div() {
        return this.DIV;
    }

    @Override
    public Procedure3<UnsignedInt4Member, UnsignedInt4Member, UnsignedInt4Member> mod() {
        return this.MOD;
    }

    @Override
    public Procedure4<UnsignedInt4Member, UnsignedInt4Member, UnsignedInt4Member, UnsignedInt4Member> divMod() {
        return this.DIVMOD;
    }

    @Override
    public Procedure2<UnsignedInt4Member, UnsignedInt4Member> pred() {
        return this.PRED;
    }

    @Override
    public Procedure2<UnsignedInt4Member, UnsignedInt4Member> succ() {
        return this.SUCC;
    }

    @Override
    public Procedure3<UnsignedInt4Member, UnsignedInt4Member, UnsignedInt4Member> pow() {
        return this.POW;
    }

    @Override
    public Procedure1<UnsignedInt4Member> random() {
        return this.RAND;
    }

    @Override
    public Procedure3<UnsignedInt4Member, UnsignedInt4Member, UnsignedInt4Member> bitAnd() {
        return this.AND;
    }

    @Override
    public Procedure3<UnsignedInt4Member, UnsignedInt4Member, UnsignedInt4Member> bitOr() {
        return this.OR;
    }

    @Override
    public Procedure3<UnsignedInt4Member, UnsignedInt4Member, UnsignedInt4Member> bitXor() {
        return this.XOR;
    }

    @Override
    public Procedure2<UnsignedInt4Member, UnsignedInt4Member> bitNot() {
        return this.NOT;
    }

    @Override
    public Procedure3<UnsignedInt4Member, UnsignedInt4Member, UnsignedInt4Member> bitAndNot() {
        return this.ANDNOT;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt4Member, UnsignedInt4Member> bitShiftLeft() {
        return this.SHL;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt4Member, UnsignedInt4Member> bitShiftRight() {
        return this.SHRZ;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt4Member, UnsignedInt4Member> bitShiftRightFillZero() {
        return this.SHRZ;
    }

    @Override
    public Procedure1<UnsignedInt4Member> maxBound() {
        return this.MAXBOUND;
    }

    @Override
    public Procedure1<UnsignedInt4Member> minBound() {
        return this.MINBOUND;
    }

    @Override
    public Function1<Boolean, UnsignedInt4Member> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<UnsignedInt4Member, UnsignedInt4Member, UnsignedInt4Member> scale() {
        return this.MUL;
    }

    @Override
    public Procedure3<HighPrecisionMember, UnsignedInt4Member, UnsignedInt4Member> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<HighPrecisionMember, UnsignedInt4Member, UnsignedInt4Member> scaleByHighPrecAndRound() {
        return this.SBHPR;
    }

    @Override
    public Procedure3<RationalMember, UnsignedInt4Member, UnsignedInt4Member> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, UnsignedInt4Member, UnsignedInt4Member> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<Double, UnsignedInt4Member, UnsignedInt4Member> scaleByDoubleAndRound() {
        return this.SBDR;
    }

    @Override
    public Function3<Boolean, UnsignedInt4Member, UnsignedInt4Member, UnsignedInt4Member> within() {
        return this.WITHIN;
    }
}

