/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.int5;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.ThreadLocalRandom;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.Gcd;
import nom.bdezonia.zorbage.algorithm.Lcm;
import nom.bdezonia.zorbage.algorithm.NumberWithin;
import nom.bdezonia.zorbage.algorithm.PowerNonNegative;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.BitOperations;
import nom.bdezonia.zorbage.type.algebra.Bounded;
import nom.bdezonia.zorbage.type.algebra.Integer;
import nom.bdezonia.zorbage.type.algebra.Random;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.int5.UnsignedInt5Member;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class UnsignedInt5Algebra
implements Integer<UnsignedInt5Algebra, UnsignedInt5Member>,
Bounded<UnsignedInt5Member>,
BitOperations<UnsignedInt5Member>,
Random<UnsignedInt5Member>,
Tolerance<UnsignedInt5Member, UnsignedInt5Member> {
    private final Function2<Boolean, UnsignedInt5Member, UnsignedInt5Member> EQ = new Function2<Boolean, UnsignedInt5Member, UnsignedInt5Member>(){

        @Override
        public Boolean call(UnsignedInt5Member a, UnsignedInt5Member b) {
            return a.v == b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt5Member, UnsignedInt5Member> NEQ = new Function2<Boolean, UnsignedInt5Member, UnsignedInt5Member>(){

        @Override
        public Boolean call(UnsignedInt5Member a, UnsignedInt5Member b) {
            return a.v != b.v;
        }
    };
    private final Procedure2<UnsignedInt5Member, UnsignedInt5Member> ASSIGN = new Procedure2<UnsignedInt5Member, UnsignedInt5Member>(){

        @Override
        public void call(UnsignedInt5Member a, UnsignedInt5Member b) {
            b.set(a);
        }
    };
    private final Procedure1<UnsignedInt5Member> ZER = new Procedure1<UnsignedInt5Member>(){

        @Override
        public void call(UnsignedInt5Member a) {
            a.v = 0;
        }
    };
    private final Procedure3<UnsignedInt5Member, UnsignedInt5Member, UnsignedInt5Member> ADD = new Procedure3<UnsignedInt5Member, UnsignedInt5Member, UnsignedInt5Member>(){

        @Override
        public void call(UnsignedInt5Member a, UnsignedInt5Member b, UnsignedInt5Member c) {
            c.setV(a.v + b.v);
        }
    };
    private final Procedure3<UnsignedInt5Member, UnsignedInt5Member, UnsignedInt5Member> SUB = new Procedure3<UnsignedInt5Member, UnsignedInt5Member, UnsignedInt5Member>(){

        @Override
        public void call(UnsignedInt5Member a, UnsignedInt5Member b, UnsignedInt5Member c) {
            c.setV(a.v - b.v);
        }
    };
    private final Procedure3<UnsignedInt5Member, UnsignedInt5Member, UnsignedInt5Member> MUL = new Procedure3<UnsignedInt5Member, UnsignedInt5Member, UnsignedInt5Member>(){

        @Override
        public void call(UnsignedInt5Member a, UnsignedInt5Member b, UnsignedInt5Member c) {
            c.setV(a.v * b.v);
        }
    };
    private final Procedure3<java.lang.Integer, UnsignedInt5Member, UnsignedInt5Member> POWER = new Procedure3<java.lang.Integer, UnsignedInt5Member, UnsignedInt5Member>(){

        @Override
        public void call(java.lang.Integer power, UnsignedInt5Member a, UnsignedInt5Member b) {
            PowerNonNegative.compute(G.UINT5, power, a, b);
        }
    };
    private final Procedure1<UnsignedInt5Member> UNITY = new Procedure1<UnsignedInt5Member>(){

        @Override
        public void call(UnsignedInt5Member a) {
            a.v = 1;
        }
    };
    private final Function2<Boolean, UnsignedInt5Member, UnsignedInt5Member> LESS = new Function2<Boolean, UnsignedInt5Member, UnsignedInt5Member>(){

        @Override
        public Boolean call(UnsignedInt5Member a, UnsignedInt5Member b) {
            return a.v < b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt5Member, UnsignedInt5Member> LE = new Function2<Boolean, UnsignedInt5Member, UnsignedInt5Member>(){

        @Override
        public Boolean call(UnsignedInt5Member a, UnsignedInt5Member b) {
            return a.v <= b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt5Member, UnsignedInt5Member> GREAT = new Function2<Boolean, UnsignedInt5Member, UnsignedInt5Member>(){

        @Override
        public Boolean call(UnsignedInt5Member a, UnsignedInt5Member b) {
            return a.v > b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt5Member, UnsignedInt5Member> GE = new Function2<Boolean, UnsignedInt5Member, UnsignedInt5Member>(){

        @Override
        public Boolean call(UnsignedInt5Member a, UnsignedInt5Member b) {
            return a.v >= b.v;
        }
    };
    private final Function2<java.lang.Integer, UnsignedInt5Member, UnsignedInt5Member> CMP = new Function2<java.lang.Integer, UnsignedInt5Member, UnsignedInt5Member>(){

        @Override
        public java.lang.Integer call(UnsignedInt5Member a, UnsignedInt5Member b) {
            if (a.v < b.v) {
                return -1;
            }
            if (a.v > b.v) {
                return 1;
            }
            return 0;
        }
    };
    private final Function1<java.lang.Integer, UnsignedInt5Member> SIG = new Function1<java.lang.Integer, UnsignedInt5Member>(){

        @Override
        public java.lang.Integer call(UnsignedInt5Member a) {
            if (a.v > 0) {
                return 1;
            }
            return 0;
        }
    };
    private final Procedure3<UnsignedInt5Member, UnsignedInt5Member, UnsignedInt5Member> MIN = new Procedure3<UnsignedInt5Member, UnsignedInt5Member, UnsignedInt5Member>(){

        @Override
        public void call(UnsignedInt5Member a, UnsignedInt5Member b, UnsignedInt5Member c) {
            if (a.v < b.v) {
                c.set(a);
            } else {
                c.set(b);
            }
        }
    };
    private final Procedure3<UnsignedInt5Member, UnsignedInt5Member, UnsignedInt5Member> MAX = new Procedure3<UnsignedInt5Member, UnsignedInt5Member, UnsignedInt5Member>(){

        @Override
        public void call(UnsignedInt5Member a, UnsignedInt5Member b, UnsignedInt5Member c) {
            if (a.v > b.v) {
                c.set(a);
            } else {
                c.set(b);
            }
        }
    };
    private final Procedure3<UnsignedInt5Member, UnsignedInt5Member, UnsignedInt5Member> GCD = new Procedure3<UnsignedInt5Member, UnsignedInt5Member, UnsignedInt5Member>(){

        @Override
        public void call(UnsignedInt5Member a, UnsignedInt5Member b, UnsignedInt5Member c) {
            Gcd.compute(G.UINT5, a, b, c);
        }
    };
    private final Procedure3<UnsignedInt5Member, UnsignedInt5Member, UnsignedInt5Member> LCM = new Procedure3<UnsignedInt5Member, UnsignedInt5Member, UnsignedInt5Member>(){

        @Override
        public void call(UnsignedInt5Member a, UnsignedInt5Member b, UnsignedInt5Member c) {
            Lcm.compute(G.UINT5, a, b, c);
        }
    };
    private final Function1<Boolean, UnsignedInt5Member> EVEN = new Function1<Boolean, UnsignedInt5Member>(){

        @Override
        public Boolean call(UnsignedInt5Member a) {
            return (a.v & 1) == 0;
        }
    };
    private final Function1<Boolean, UnsignedInt5Member> ODD = new Function1<Boolean, UnsignedInt5Member>(){

        @Override
        public Boolean call(UnsignedInt5Member a) {
            return (a.v & 1) == 1;
        }
    };
    private final Procedure3<UnsignedInt5Member, UnsignedInt5Member, UnsignedInt5Member> DIV = new Procedure3<UnsignedInt5Member, UnsignedInt5Member, UnsignedInt5Member>(){

        @Override
        public void call(UnsignedInt5Member a, UnsignedInt5Member b, UnsignedInt5Member d) {
            d.setV(a.v / b.v);
        }
    };
    private final Procedure3<UnsignedInt5Member, UnsignedInt5Member, UnsignedInt5Member> MOD = new Procedure3<UnsignedInt5Member, UnsignedInt5Member, UnsignedInt5Member>(){

        @Override
        public void call(UnsignedInt5Member a, UnsignedInt5Member b, UnsignedInt5Member m) {
            m.setV(a.v % b.v);
        }
    };
    private final Procedure4<UnsignedInt5Member, UnsignedInt5Member, UnsignedInt5Member, UnsignedInt5Member> DIVMOD = new Procedure4<UnsignedInt5Member, UnsignedInt5Member, UnsignedInt5Member, UnsignedInt5Member>(){

        @Override
        public void call(UnsignedInt5Member a, UnsignedInt5Member b, UnsignedInt5Member d, UnsignedInt5Member m) {
            UnsignedInt5Algebra.this.div().call(a, b, d);
            UnsignedInt5Algebra.this.mod().call(a, b, m);
        }
    };
    private final Procedure2<UnsignedInt5Member, UnsignedInt5Member> PRED = new Procedure2<UnsignedInt5Member, UnsignedInt5Member>(){

        @Override
        public void call(UnsignedInt5Member a, UnsignedInt5Member b) {
            if (a.v == 0) {
                b.v = (byte)31;
            } else {
                b.setV(a.v - 1);
            }
        }
    };
    private final Procedure2<UnsignedInt5Member, UnsignedInt5Member> SUCC = new Procedure2<UnsignedInt5Member, UnsignedInt5Member>(){

        @Override
        public void call(UnsignedInt5Member a, UnsignedInt5Member b) {
            if (a.v == 31) {
                b.v = 0;
            } else {
                b.setV(a.v + 1);
            }
        }
    };
    private final Procedure3<UnsignedInt5Member, UnsignedInt5Member, UnsignedInt5Member> POW = new Procedure3<UnsignedInt5Member, UnsignedInt5Member, UnsignedInt5Member>(){

        @Override
        public void call(UnsignedInt5Member a, UnsignedInt5Member b, UnsignedInt5Member c) {
            PowerNonNegative.compute(G.UINT5, b.v, a, c);
        }
    };
    private final Procedure1<UnsignedInt5Member> RAND = new Procedure1<UnsignedInt5Member>(){

        @Override
        public void call(UnsignedInt5Member a) {
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            a.setV(rng.nextInt(32));
        }
    };
    private final Procedure3<UnsignedInt5Member, UnsignedInt5Member, UnsignedInt5Member> AND = new Procedure3<UnsignedInt5Member, UnsignedInt5Member, UnsignedInt5Member>(){

        @Override
        public void call(UnsignedInt5Member a, UnsignedInt5Member b, UnsignedInt5Member c) {
            c.setV(a.v & b.v);
        }
    };
    private final Procedure3<UnsignedInt5Member, UnsignedInt5Member, UnsignedInt5Member> OR = new Procedure3<UnsignedInt5Member, UnsignedInt5Member, UnsignedInt5Member>(){

        @Override
        public void call(UnsignedInt5Member a, UnsignedInt5Member b, UnsignedInt5Member c) {
            c.setV(a.v | b.v);
        }
    };
    private final Procedure3<UnsignedInt5Member, UnsignedInt5Member, UnsignedInt5Member> XOR = new Procedure3<UnsignedInt5Member, UnsignedInt5Member, UnsignedInt5Member>(){

        @Override
        public void call(UnsignedInt5Member a, UnsignedInt5Member b, UnsignedInt5Member c) {
            c.setV(a.v ^ b.v);
        }
    };
    private final Procedure2<UnsignedInt5Member, UnsignedInt5Member> NOT = new Procedure2<UnsignedInt5Member, UnsignedInt5Member>(){

        @Override
        public void call(UnsignedInt5Member a, UnsignedInt5Member b) {
            b.setV(~a.v);
        }
    };
    private final Procedure3<UnsignedInt5Member, UnsignedInt5Member, UnsignedInt5Member> ANDNOT = new Procedure3<UnsignedInt5Member, UnsignedInt5Member, UnsignedInt5Member>(){

        @Override
        public void call(UnsignedInt5Member a, UnsignedInt5Member b, UnsignedInt5Member c) {
            c.setV(a.v & ~b.v);
        }
    };
    private final Procedure3<java.lang.Integer, UnsignedInt5Member, UnsignedInt5Member> SHL = new Procedure3<java.lang.Integer, UnsignedInt5Member, UnsignedInt5Member>(){

        @Override
        public void call(java.lang.Integer count, UnsignedInt5Member a, UnsignedInt5Member b) {
            if (count < 0) {
                UnsignedInt5Algebra.this.bitShiftRight().call(-count.intValue(), a, b);
            } else {
                count = count % 5;
                b.setV(a.v << count);
            }
        }
    };
    private final Procedure3<java.lang.Integer, UnsignedInt5Member, UnsignedInt5Member> SHRZ = new Procedure3<java.lang.Integer, UnsignedInt5Member, UnsignedInt5Member>(){

        @Override
        public void call(java.lang.Integer count, UnsignedInt5Member a, UnsignedInt5Member b) {
            if (count < 0) {
                UnsignedInt5Algebra.this.bitShiftLeft().call(-count.intValue(), a, b);
            } else {
                b.setV(a.v >>> count);
            }
        }
    };
    private final Procedure1<UnsignedInt5Member> MAXBOUND = new Procedure1<UnsignedInt5Member>(){

        @Override
        public void call(UnsignedInt5Member a) {
            a.v = (byte)31;
        }
    };
    private final Procedure1<UnsignedInt5Member> MINBOUND = new Procedure1<UnsignedInt5Member>(){

        @Override
        public void call(UnsignedInt5Member a) {
            a.v = 0;
        }
    };
    private final Function1<Boolean, UnsignedInt5Member> ISZERO = new Function1<Boolean, UnsignedInt5Member>(){

        @Override
        public Boolean call(UnsignedInt5Member a) {
            return a.v == 0;
        }
    };
    private final Procedure3<HighPrecisionMember, UnsignedInt5Member, UnsignedInt5Member> SBHP = new Procedure3<HighPrecisionMember, UnsignedInt5Member, UnsignedInt5Member>(){

        @Override
        public void call(HighPrecisionMember a, UnsignedInt5Member b, UnsignedInt5Member c) {
            BigDecimal tmp = a.v();
            tmp = tmp.multiply(new BigDecimal(b.v()));
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<HighPrecisionMember, UnsignedInt5Member, UnsignedInt5Member> SBHPR = new Procedure3<HighPrecisionMember, UnsignedInt5Member, UnsignedInt5Member>(){

        @Override
        public void call(HighPrecisionMember a, UnsignedInt5Member b, UnsignedInt5Member c) {
            BigDecimal tmp = a.v();
            int signum = (tmp = tmp.multiply(new BigDecimal(b.v()))).signum();
            tmp = signum < 0 ? tmp.subtract(G.ONE_HALF) : tmp.add(G.ONE_HALF);
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<RationalMember, UnsignedInt5Member, UnsignedInt5Member> SBR = new Procedure3<RationalMember, UnsignedInt5Member, UnsignedInt5Member>(){

        @Override
        public void call(RationalMember a, UnsignedInt5Member b, UnsignedInt5Member c) {
            BigInteger tmp = BigInteger.valueOf(b.v());
            tmp = tmp.multiply(a.n());
            tmp = tmp.divide(a.d());
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<Double, UnsignedInt5Member, UnsignedInt5Member> SBD = new Procedure3<Double, UnsignedInt5Member, UnsignedInt5Member>(){

        @Override
        public void call(Double a, UnsignedInt5Member b, UnsignedInt5Member c) {
            c.setV((int)(a * (double)b.v()));
        }
    };
    private final Procedure3<Double, UnsignedInt5Member, UnsignedInt5Member> SBDR = new Procedure3<Double, UnsignedInt5Member, UnsignedInt5Member>(){

        @Override
        public void call(Double a, UnsignedInt5Member b, UnsignedInt5Member c) {
            c.setV((int)Math.round(a * (double)b.v()));
        }
    };
    private final Function3<Boolean, UnsignedInt5Member, UnsignedInt5Member, UnsignedInt5Member> WITHIN = new Function3<Boolean, UnsignedInt5Member, UnsignedInt5Member, UnsignedInt5Member>(){

        @Override
        public Boolean call(UnsignedInt5Member tol, UnsignedInt5Member a, UnsignedInt5Member b) {
            return NumberWithin.compute(G.UINT5, tol, a, b);
        }
    };

    @Override
    public UnsignedInt5Member construct() {
        return new UnsignedInt5Member();
    }

    @Override
    public UnsignedInt5Member construct(UnsignedInt5Member other) {
        return new UnsignedInt5Member(other);
    }

    @Override
    public UnsignedInt5Member construct(String str) {
        return new UnsignedInt5Member(str);
    }

    @Override
    public Function2<Boolean, UnsignedInt5Member, UnsignedInt5Member> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, UnsignedInt5Member, UnsignedInt5Member> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<UnsignedInt5Member, UnsignedInt5Member> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure1<UnsignedInt5Member> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<UnsignedInt5Member, UnsignedInt5Member> negate() {
        return this.ASSIGN;
    }

    @Override
    public Procedure3<UnsignedInt5Member, UnsignedInt5Member, UnsignedInt5Member> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<UnsignedInt5Member, UnsignedInt5Member, UnsignedInt5Member> subtract() {
        return this.SUB;
    }

    @Override
    public Procedure3<UnsignedInt5Member, UnsignedInt5Member, UnsignedInt5Member> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt5Member, UnsignedInt5Member> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<UnsignedInt5Member> unity() {
        return this.UNITY;
    }

    @Override
    public Function2<Boolean, UnsignedInt5Member, UnsignedInt5Member> isLess() {
        return this.LESS;
    }

    @Override
    public Function2<Boolean, UnsignedInt5Member, UnsignedInt5Member> isLessEqual() {
        return this.LE;
    }

    @Override
    public Function2<Boolean, UnsignedInt5Member, UnsignedInt5Member> isGreater() {
        return this.GREAT;
    }

    @Override
    public Function2<Boolean, UnsignedInt5Member, UnsignedInt5Member> isGreaterEqual() {
        return this.GE;
    }

    @Override
    public Function2<java.lang.Integer, UnsignedInt5Member, UnsignedInt5Member> compare() {
        return this.CMP;
    }

    @Override
    public Function1<java.lang.Integer, UnsignedInt5Member> signum() {
        return this.SIG;
    }

    @Override
    public Procedure3<UnsignedInt5Member, UnsignedInt5Member, UnsignedInt5Member> min() {
        return this.MIN;
    }

    @Override
    public Procedure3<UnsignedInt5Member, UnsignedInt5Member, UnsignedInt5Member> max() {
        return this.MAX;
    }

    @Override
    public Procedure2<UnsignedInt5Member, UnsignedInt5Member> abs() {
        return this.ASSIGN;
    }

    @Override
    public Procedure2<UnsignedInt5Member, UnsignedInt5Member> norm() {
        return this.ASSIGN;
    }

    @Override
    public Procedure3<UnsignedInt5Member, UnsignedInt5Member, UnsignedInt5Member> gcd() {
        return this.GCD;
    }

    @Override
    public Procedure3<UnsignedInt5Member, UnsignedInt5Member, UnsignedInt5Member> lcm() {
        return this.LCM;
    }

    @Override
    public Function1<Boolean, UnsignedInt5Member> isEven() {
        return this.EVEN;
    }

    @Override
    public Function1<Boolean, UnsignedInt5Member> isOdd() {
        return this.ODD;
    }

    @Override
    public Procedure3<UnsignedInt5Member, UnsignedInt5Member, UnsignedInt5Member> div() {
        return this.DIV;
    }

    @Override
    public Procedure3<UnsignedInt5Member, UnsignedInt5Member, UnsignedInt5Member> mod() {
        return this.MOD;
    }

    @Override
    public Procedure4<UnsignedInt5Member, UnsignedInt5Member, UnsignedInt5Member, UnsignedInt5Member> divMod() {
        return this.DIVMOD;
    }

    @Override
    public Procedure2<UnsignedInt5Member, UnsignedInt5Member> pred() {
        return this.PRED;
    }

    @Override
    public Procedure2<UnsignedInt5Member, UnsignedInt5Member> succ() {
        return this.SUCC;
    }

    @Override
    public Procedure3<UnsignedInt5Member, UnsignedInt5Member, UnsignedInt5Member> pow() {
        return this.POW;
    }

    @Override
    public Procedure1<UnsignedInt5Member> random() {
        return this.RAND;
    }

    @Override
    public Procedure3<UnsignedInt5Member, UnsignedInt5Member, UnsignedInt5Member> bitAnd() {
        return this.AND;
    }

    @Override
    public Procedure3<UnsignedInt5Member, UnsignedInt5Member, UnsignedInt5Member> bitOr() {
        return this.OR;
    }

    @Override
    public Procedure3<UnsignedInt5Member, UnsignedInt5Member, UnsignedInt5Member> bitXor() {
        return this.XOR;
    }

    @Override
    public Procedure2<UnsignedInt5Member, UnsignedInt5Member> bitNot() {
        return this.NOT;
    }

    @Override
    public Procedure3<UnsignedInt5Member, UnsignedInt5Member, UnsignedInt5Member> bitAndNot() {
        return this.ANDNOT;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt5Member, UnsignedInt5Member> bitShiftLeft() {
        return this.SHL;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt5Member, UnsignedInt5Member> bitShiftRight() {
        return this.SHRZ;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt5Member, UnsignedInt5Member> bitShiftRightFillZero() {
        return this.SHRZ;
    }

    @Override
    public Procedure1<UnsignedInt5Member> maxBound() {
        return this.MAXBOUND;
    }

    @Override
    public Procedure1<UnsignedInt5Member> minBound() {
        return this.MINBOUND;
    }

    @Override
    public Function1<Boolean, UnsignedInt5Member> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<UnsignedInt5Member, UnsignedInt5Member, UnsignedInt5Member> scale() {
        return this.MUL;
    }

    @Override
    public Procedure3<HighPrecisionMember, UnsignedInt5Member, UnsignedInt5Member> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<HighPrecisionMember, UnsignedInt5Member, UnsignedInt5Member> scaleByHighPrecAndRound() {
        return this.SBHPR;
    }

    @Override
    public Procedure3<RationalMember, UnsignedInt5Member, UnsignedInt5Member> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, UnsignedInt5Member, UnsignedInt5Member> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<Double, UnsignedInt5Member, UnsignedInt5Member> scaleByDoubleAndRound() {
        return this.SBDR;
    }

    @Override
    public Function3<Boolean, UnsignedInt5Member, UnsignedInt5Member, UnsignedInt5Member> within() {
        return this.WITHIN;
    }
}

