/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.int6;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.ThreadLocalRandom;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.Gcd;
import nom.bdezonia.zorbage.algorithm.Lcm;
import nom.bdezonia.zorbage.algorithm.NumberWithin;
import nom.bdezonia.zorbage.algorithm.PowerNonNegative;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.BitOperations;
import nom.bdezonia.zorbage.type.algebra.Bounded;
import nom.bdezonia.zorbage.type.algebra.Integer;
import nom.bdezonia.zorbage.type.algebra.Random;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.int6.SignedInt6Member;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class SignedInt6Algebra
implements Integer<SignedInt6Algebra, SignedInt6Member>,
Bounded<SignedInt6Member>,
BitOperations<SignedInt6Member>,
Random<SignedInt6Member>,
Tolerance<SignedInt6Member, SignedInt6Member> {
    private final Function2<Boolean, SignedInt6Member, SignedInt6Member> EQ = new Function2<Boolean, SignedInt6Member, SignedInt6Member>(){

        @Override
        public Boolean call(SignedInt6Member a, SignedInt6Member b) {
            return a.v == b.v;
        }
    };
    private final Function2<Boolean, SignedInt6Member, SignedInt6Member> NEQ = new Function2<Boolean, SignedInt6Member, SignedInt6Member>(){

        @Override
        public Boolean call(SignedInt6Member a, SignedInt6Member b) {
            return a.v != b.v;
        }
    };
    private final Procedure2<SignedInt6Member, SignedInt6Member> ASSIGN = new Procedure2<SignedInt6Member, SignedInt6Member>(){

        @Override
        public void call(SignedInt6Member a, SignedInt6Member b) {
            b.set(a);
        }
    };
    private final Procedure1<SignedInt6Member> ZER = new Procedure1<SignedInt6Member>(){

        @Override
        public void call(SignedInt6Member a) {
            a.v = 0;
        }
    };
    private final Procedure2<SignedInt6Member, SignedInt6Member> NEG = new Procedure2<SignedInt6Member, SignedInt6Member>(){

        @Override
        public void call(SignedInt6Member a, SignedInt6Member b) {
            if (a.v == -32) {
                throw new IllegalArgumentException("Cannot convert -minint symmetrically");
            }
            b.v = -a.v;
        }
    };
    private final Procedure3<SignedInt6Member, SignedInt6Member, SignedInt6Member> ADD = new Procedure3<SignedInt6Member, SignedInt6Member, SignedInt6Member>(){

        @Override
        public void call(SignedInt6Member a, SignedInt6Member b, SignedInt6Member c) {
            c.setV(a.v + b.v);
        }
    };
    private final Procedure3<SignedInt6Member, SignedInt6Member, SignedInt6Member> SUB = new Procedure3<SignedInt6Member, SignedInt6Member, SignedInt6Member>(){

        @Override
        public void call(SignedInt6Member a, SignedInt6Member b, SignedInt6Member c) {
            c.setV(a.v - b.v);
        }
    };
    private final Procedure3<SignedInt6Member, SignedInt6Member, SignedInt6Member> MUL = new Procedure3<SignedInt6Member, SignedInt6Member, SignedInt6Member>(){

        @Override
        public void call(SignedInt6Member a, SignedInt6Member b, SignedInt6Member c) {
            c.setV(a.v * b.v);
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt6Member, SignedInt6Member> POWER = new Procedure3<java.lang.Integer, SignedInt6Member, SignedInt6Member>(){

        @Override
        public void call(java.lang.Integer power, SignedInt6Member a, SignedInt6Member b) {
            PowerNonNegative.compute(G.INT6, power, a, b);
        }
    };
    private final Procedure1<SignedInt6Member> UNITY = new Procedure1<SignedInt6Member>(){

        @Override
        public void call(SignedInt6Member a) {
            a.v = 1;
        }
    };
    private final Function2<Boolean, SignedInt6Member, SignedInt6Member> LESS = new Function2<Boolean, SignedInt6Member, SignedInt6Member>(){

        @Override
        public Boolean call(SignedInt6Member a, SignedInt6Member b) {
            return a.v < b.v;
        }
    };
    private final Function2<Boolean, SignedInt6Member, SignedInt6Member> LE = new Function2<Boolean, SignedInt6Member, SignedInt6Member>(){

        @Override
        public Boolean call(SignedInt6Member a, SignedInt6Member b) {
            return a.v <= b.v;
        }
    };
    private final Function2<Boolean, SignedInt6Member, SignedInt6Member> GREAT = new Function2<Boolean, SignedInt6Member, SignedInt6Member>(){

        @Override
        public Boolean call(SignedInt6Member a, SignedInt6Member b) {
            return a.v > b.v;
        }
    };
    private final Function2<Boolean, SignedInt6Member, SignedInt6Member> GE = new Function2<Boolean, SignedInt6Member, SignedInt6Member>(){

        @Override
        public Boolean call(SignedInt6Member a, SignedInt6Member b) {
            return a.v >= b.v;
        }
    };
    private final Function2<java.lang.Integer, SignedInt6Member, SignedInt6Member> CMP = new Function2<java.lang.Integer, SignedInt6Member, SignedInt6Member>(){

        @Override
        public java.lang.Integer call(SignedInt6Member a, SignedInt6Member b) {
            if (a.v < b.v) {
                return -1;
            }
            if (a.v > b.v) {
                return 1;
            }
            return 0;
        }
    };
    private final Function1<java.lang.Integer, SignedInt6Member> SIG = new Function1<java.lang.Integer, SignedInt6Member>(){

        @Override
        public java.lang.Integer call(SignedInt6Member a) {
            if (a.v < 0) {
                return -1;
            }
            if (a.v > 0) {
                return 1;
            }
            return 0;
        }
    };
    private final Procedure3<SignedInt6Member, SignedInt6Member, SignedInt6Member> MIN = new Procedure3<SignedInt6Member, SignedInt6Member, SignedInt6Member>(){

        @Override
        public void call(SignedInt6Member a, SignedInt6Member b, SignedInt6Member c) {
            if (a.v < b.v) {
                c.set(a);
            } else {
                c.set(b);
            }
        }
    };
    private final Procedure3<SignedInt6Member, SignedInt6Member, SignedInt6Member> MAX = new Procedure3<SignedInt6Member, SignedInt6Member, SignedInt6Member>(){

        @Override
        public void call(SignedInt6Member a, SignedInt6Member b, SignedInt6Member c) {
            if (a.v > b.v) {
                c.set(a);
            } else {
                c.set(b);
            }
        }
    };
    private final Procedure2<SignedInt6Member, SignedInt6Member> ABS = new Procedure2<SignedInt6Member, SignedInt6Member>(){

        @Override
        public void call(SignedInt6Member a, SignedInt6Member b) {
            if (a.v == -32) {
                throw new IllegalArgumentException("Cannot convert -minint symmetrically");
            }
            b.v = a.v < 0 ? (byte)(-a.v) : a.v;
        }
    };
    private final Procedure3<SignedInt6Member, SignedInt6Member, SignedInt6Member> GCD = new Procedure3<SignedInt6Member, SignedInt6Member, SignedInt6Member>(){

        @Override
        public void call(SignedInt6Member a, SignedInt6Member b, SignedInt6Member c) {
            Gcd.compute(G.INT6, a, b, c);
        }
    };
    private final Procedure3<SignedInt6Member, SignedInt6Member, SignedInt6Member> LCM = new Procedure3<SignedInt6Member, SignedInt6Member, SignedInt6Member>(){

        @Override
        public void call(SignedInt6Member a, SignedInt6Member b, SignedInt6Member c) {
            Lcm.compute(G.INT6, a, b, c);
        }
    };
    private final Function1<Boolean, SignedInt6Member> EVEN = new Function1<Boolean, SignedInt6Member>(){

        @Override
        public Boolean call(SignedInt6Member a) {
            return (a.v & 1) == 0;
        }
    };
    private final Function1<Boolean, SignedInt6Member> ODD = new Function1<Boolean, SignedInt6Member>(){

        @Override
        public Boolean call(SignedInt6Member a) {
            return (a.v & 1) == 1;
        }
    };
    private final Procedure3<SignedInt6Member, SignedInt6Member, SignedInt6Member> DIV = new Procedure3<SignedInt6Member, SignedInt6Member, SignedInt6Member>(){

        @Override
        public void call(SignedInt6Member a, SignedInt6Member b, SignedInt6Member d) {
            if (b.v == -1 && a.v == -32) {
                throw new IllegalArgumentException("cannot divide minint by -1");
            }
            d.setV(a.v / b.v);
        }
    };
    private final Procedure3<SignedInt6Member, SignedInt6Member, SignedInt6Member> MOD = new Procedure3<SignedInt6Member, SignedInt6Member, SignedInt6Member>(){

        @Override
        public void call(SignedInt6Member a, SignedInt6Member b, SignedInt6Member m) {
            m.setV(a.v % b.v);
        }
    };
    private final Procedure4<SignedInt6Member, SignedInt6Member, SignedInt6Member, SignedInt6Member> DIVMOD = new Procedure4<SignedInt6Member, SignedInt6Member, SignedInt6Member, SignedInt6Member>(){

        @Override
        public void call(SignedInt6Member a, SignedInt6Member b, SignedInt6Member d, SignedInt6Member m) {
            SignedInt6Algebra.this.div().call(a, b, d);
            SignedInt6Algebra.this.mod().call(a, b, m);
        }
    };
    private final Procedure2<SignedInt6Member, SignedInt6Member> PRED = new Procedure2<SignedInt6Member, SignedInt6Member>(){

        @Override
        public void call(SignedInt6Member a, SignedInt6Member b) {
            if (a.v == -32) {
                b.v = (byte)31;
            } else {
                b.setV(a.v - 1);
            }
        }
    };
    private final Procedure2<SignedInt6Member, SignedInt6Member> SUCC = new Procedure2<SignedInt6Member, SignedInt6Member>(){

        @Override
        public void call(SignedInt6Member a, SignedInt6Member b) {
            if (a.v == 31) {
                b.v = (byte)-32;
            } else {
                b.setV(a.v + 1);
            }
        }
    };
    private final Procedure3<SignedInt6Member, SignedInt6Member, SignedInt6Member> POW = new Procedure3<SignedInt6Member, SignedInt6Member, SignedInt6Member>(){

        @Override
        public void call(SignedInt6Member a, SignedInt6Member b, SignedInt6Member c) {
            PowerNonNegative.compute(G.INT6, b.v, a, c);
        }
    };
    private final Procedure1<SignedInt6Member> RAND = new Procedure1<SignedInt6Member>(){

        @Override
        public void call(SignedInt6Member a) {
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            a.setV(rng.nextInt(64) - 32);
        }
    };
    private final Procedure3<SignedInt6Member, SignedInt6Member, SignedInt6Member> AND = new Procedure3<SignedInt6Member, SignedInt6Member, SignedInt6Member>(){

        @Override
        public void call(SignedInt6Member a, SignedInt6Member b, SignedInt6Member c) {
            c.setV(a.v & b.v);
        }
    };
    private final Procedure3<SignedInt6Member, SignedInt6Member, SignedInt6Member> OR = new Procedure3<SignedInt6Member, SignedInt6Member, SignedInt6Member>(){

        @Override
        public void call(SignedInt6Member a, SignedInt6Member b, SignedInt6Member c) {
            c.setV(a.v | b.v);
        }
    };
    private final Procedure3<SignedInt6Member, SignedInt6Member, SignedInt6Member> XOR = new Procedure3<SignedInt6Member, SignedInt6Member, SignedInt6Member>(){

        @Override
        public void call(SignedInt6Member a, SignedInt6Member b, SignedInt6Member c) {
            c.setV(a.v ^ b.v);
        }
    };
    private final Procedure2<SignedInt6Member, SignedInt6Member> NOT = new Procedure2<SignedInt6Member, SignedInt6Member>(){

        @Override
        public void call(SignedInt6Member a, SignedInt6Member b) {
            b.setV(~a.v);
        }
    };
    private final Procedure3<SignedInt6Member, SignedInt6Member, SignedInt6Member> ANDNOT = new Procedure3<SignedInt6Member, SignedInt6Member, SignedInt6Member>(){

        @Override
        public void call(SignedInt6Member a, SignedInt6Member b, SignedInt6Member c) {
            c.setV(a.v & ~b.v);
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt6Member, SignedInt6Member> SHL = new Procedure3<java.lang.Integer, SignedInt6Member, SignedInt6Member>(){

        @Override
        public void call(java.lang.Integer count, SignedInt6Member a, SignedInt6Member b) {
            if (count < 0) {
                SignedInt6Algebra.this.bitShiftRight().call(-count.intValue(), a, b);
            } else {
                count = count % 6;
                b.setV(a.v << count);
            }
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt6Member, SignedInt6Member> SHR = new Procedure3<java.lang.Integer, SignedInt6Member, SignedInt6Member>(){

        @Override
        public void call(java.lang.Integer count, SignedInt6Member a, SignedInt6Member b) {
            if (count < 0) {
                SignedInt6Algebra.this.bitShiftLeft().call(-count.intValue(), a, b);
            } else {
                int val = a.v >> count;
                if (a.v < 0 && val == 0) {
                    b.v = (byte)-1;
                } else {
                    b.setV(val);
                }
            }
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt6Member, SignedInt6Member> SHRZ = new Procedure3<java.lang.Integer, SignedInt6Member, SignedInt6Member>(){

        @Override
        public void call(java.lang.Integer count, SignedInt6Member a, SignedInt6Member b) {
            if (count < 0) {
                SignedInt6Algebra.this.bitShiftLeft().call(-count.intValue(), a, b);
            } else {
                b.setV(a.v >>> count);
            }
        }
    };
    private final Procedure1<SignedInt6Member> MAXBOUND = new Procedure1<SignedInt6Member>(){

        @Override
        public void call(SignedInt6Member a) {
            a.v = (byte)31;
        }
    };
    private final Procedure1<SignedInt6Member> MINBOUND = new Procedure1<SignedInt6Member>(){

        @Override
        public void call(SignedInt6Member a) {
            a.v = (byte)-32;
        }
    };
    private final Function1<Boolean, SignedInt6Member> ISZERO = new Function1<Boolean, SignedInt6Member>(){

        @Override
        public Boolean call(SignedInt6Member a) {
            return a.v == 0;
        }
    };
    private final Procedure3<HighPrecisionMember, SignedInt6Member, SignedInt6Member> SBHP = new Procedure3<HighPrecisionMember, SignedInt6Member, SignedInt6Member>(){

        @Override
        public void call(HighPrecisionMember a, SignedInt6Member b, SignedInt6Member c) {
            BigDecimal tmp = a.v();
            tmp = tmp.multiply(new BigDecimal(b.v()));
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<HighPrecisionMember, SignedInt6Member, SignedInt6Member> SBHPR = new Procedure3<HighPrecisionMember, SignedInt6Member, SignedInt6Member>(){

        @Override
        public void call(HighPrecisionMember a, SignedInt6Member b, SignedInt6Member c) {
            BigDecimal tmp = a.v();
            int signum = (tmp = tmp.multiply(new BigDecimal(b.v()))).signum();
            tmp = signum < 0 ? tmp.subtract(G.ONE_HALF) : tmp.add(G.ONE_HALF);
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<RationalMember, SignedInt6Member, SignedInt6Member> SBR = new Procedure3<RationalMember, SignedInt6Member, SignedInt6Member>(){

        @Override
        public void call(RationalMember a, SignedInt6Member b, SignedInt6Member c) {
            BigInteger tmp = BigInteger.valueOf(b.v());
            tmp = tmp.multiply(a.n());
            tmp = tmp.divide(a.d());
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<Double, SignedInt6Member, SignedInt6Member> SBD = new Procedure3<Double, SignedInt6Member, SignedInt6Member>(){

        @Override
        public void call(Double a, SignedInt6Member b, SignedInt6Member c) {
            c.setV((int)(a * (double)b.v()));
        }
    };
    private final Procedure3<Double, SignedInt6Member, SignedInt6Member> SBDR = new Procedure3<Double, SignedInt6Member, SignedInt6Member>(){

        @Override
        public void call(Double a, SignedInt6Member b, SignedInt6Member c) {
            c.setV((int)Math.round(a * (double)b.v()));
        }
    };
    private final Function3<Boolean, SignedInt6Member, SignedInt6Member, SignedInt6Member> WITHIN = new Function3<Boolean, SignedInt6Member, SignedInt6Member, SignedInt6Member>(){

        @Override
        public Boolean call(SignedInt6Member tol, SignedInt6Member a, SignedInt6Member b) {
            return NumberWithin.compute(G.INT6, tol, a, b);
        }
    };

    @Override
    public SignedInt6Member construct() {
        return new SignedInt6Member();
    }

    @Override
    public SignedInt6Member construct(SignedInt6Member other) {
        return new SignedInt6Member(other);
    }

    @Override
    public SignedInt6Member construct(String str) {
        return new SignedInt6Member(str);
    }

    @Override
    public Function2<Boolean, SignedInt6Member, SignedInt6Member> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, SignedInt6Member, SignedInt6Member> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<SignedInt6Member, SignedInt6Member> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure1<SignedInt6Member> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<SignedInt6Member, SignedInt6Member> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<SignedInt6Member, SignedInt6Member, SignedInt6Member> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<SignedInt6Member, SignedInt6Member, SignedInt6Member> subtract() {
        return this.SUB;
    }

    @Override
    public Procedure3<SignedInt6Member, SignedInt6Member, SignedInt6Member> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt6Member, SignedInt6Member> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<SignedInt6Member> unity() {
        return this.UNITY;
    }

    @Override
    public Function2<Boolean, SignedInt6Member, SignedInt6Member> isLess() {
        return this.LESS;
    }

    @Override
    public Function2<Boolean, SignedInt6Member, SignedInt6Member> isLessEqual() {
        return this.LE;
    }

    @Override
    public Function2<Boolean, SignedInt6Member, SignedInt6Member> isGreater() {
        return this.GREAT;
    }

    @Override
    public Function2<Boolean, SignedInt6Member, SignedInt6Member> isGreaterEqual() {
        return this.GE;
    }

    @Override
    public Function2<java.lang.Integer, SignedInt6Member, SignedInt6Member> compare() {
        return this.CMP;
    }

    @Override
    public Function1<java.lang.Integer, SignedInt6Member> signum() {
        return this.SIG;
    }

    @Override
    public Procedure3<SignedInt6Member, SignedInt6Member, SignedInt6Member> min() {
        return this.MIN;
    }

    @Override
    public Procedure3<SignedInt6Member, SignedInt6Member, SignedInt6Member> max() {
        return this.MAX;
    }

    @Override
    public Procedure2<SignedInt6Member, SignedInt6Member> abs() {
        return this.ABS;
    }

    @Override
    public Procedure2<SignedInt6Member, SignedInt6Member> norm() {
        return this.ABS;
    }

    @Override
    public Procedure3<SignedInt6Member, SignedInt6Member, SignedInt6Member> gcd() {
        return this.GCD;
    }

    @Override
    public Procedure3<SignedInt6Member, SignedInt6Member, SignedInt6Member> lcm() {
        return this.LCM;
    }

    @Override
    public Function1<Boolean, SignedInt6Member> isEven() {
        return this.EVEN;
    }

    @Override
    public Function1<Boolean, SignedInt6Member> isOdd() {
        return this.ODD;
    }

    @Override
    public Procedure3<SignedInt6Member, SignedInt6Member, SignedInt6Member> div() {
        return this.DIV;
    }

    @Override
    public Procedure3<SignedInt6Member, SignedInt6Member, SignedInt6Member> mod() {
        return this.MOD;
    }

    @Override
    public Procedure4<SignedInt6Member, SignedInt6Member, SignedInt6Member, SignedInt6Member> divMod() {
        return this.DIVMOD;
    }

    @Override
    public Procedure2<SignedInt6Member, SignedInt6Member> pred() {
        return this.PRED;
    }

    @Override
    public Procedure2<SignedInt6Member, SignedInt6Member> succ() {
        return this.SUCC;
    }

    @Override
    public Procedure3<SignedInt6Member, SignedInt6Member, SignedInt6Member> pow() {
        return this.POW;
    }

    @Override
    public Procedure1<SignedInt6Member> random() {
        return this.RAND;
    }

    @Override
    public Procedure3<SignedInt6Member, SignedInt6Member, SignedInt6Member> bitAnd() {
        return this.AND;
    }

    @Override
    public Procedure3<SignedInt6Member, SignedInt6Member, SignedInt6Member> bitOr() {
        return this.OR;
    }

    @Override
    public Procedure3<SignedInt6Member, SignedInt6Member, SignedInt6Member> bitXor() {
        return this.XOR;
    }

    @Override
    public Procedure2<SignedInt6Member, SignedInt6Member> bitNot() {
        return this.NOT;
    }

    @Override
    public Procedure3<SignedInt6Member, SignedInt6Member, SignedInt6Member> bitAndNot() {
        return this.ANDNOT;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt6Member, SignedInt6Member> bitShiftLeft() {
        return this.SHL;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt6Member, SignedInt6Member> bitShiftRight() {
        return this.SHR;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt6Member, SignedInt6Member> bitShiftRightFillZero() {
        return this.SHRZ;
    }

    @Override
    public Procedure1<SignedInt6Member> maxBound() {
        return this.MAXBOUND;
    }

    @Override
    public Procedure1<SignedInt6Member> minBound() {
        return this.MINBOUND;
    }

    @Override
    public Function1<Boolean, SignedInt6Member> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<SignedInt6Member, SignedInt6Member, SignedInt6Member> scale() {
        return this.MUL;
    }

    @Override
    public Procedure3<HighPrecisionMember, SignedInt6Member, SignedInt6Member> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<HighPrecisionMember, SignedInt6Member, SignedInt6Member> scaleByHighPrecAndRound() {
        return this.SBHPR;
    }

    @Override
    public Procedure3<RationalMember, SignedInt6Member, SignedInt6Member> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, SignedInt6Member, SignedInt6Member> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<Double, SignedInt6Member, SignedInt6Member> scaleByDoubleAndRound() {
        return this.SBDR;
    }

    @Override
    public Function3<Boolean, SignedInt6Member, SignedInt6Member, SignedInt6Member> within() {
        return this.WITHIN;
    }
}

