/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.int6;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigDecimal;
import java.math.BigInteger;
import nom.bdezonia.zorbage.sampling.IntegerIndex;
import nom.bdezonia.zorbage.type.algebra.GetReal;
import nom.bdezonia.zorbage.type.algebra.Gettable;
import nom.bdezonia.zorbage.type.algebra.HighPrecRepresentation;
import nom.bdezonia.zorbage.type.algebra.NumberMember;
import nom.bdezonia.zorbage.type.algebra.SetReal;
import nom.bdezonia.zorbage.type.algebra.Settable;
import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.ctor.Duplicatable;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.int8.SignedInt8Member;
import nom.bdezonia.zorbage.type.data.universal.OctonionRepresentation;
import nom.bdezonia.zorbage.type.data.universal.PrimitiveConversion;
import nom.bdezonia.zorbage.type.data.universal.PrimitiveRepresentation;
import nom.bdezonia.zorbage.type.data.universal.TensorOctonionRepresentation;
import nom.bdezonia.zorbage.type.data.universal.TensorStringRepresentation;
import nom.bdezonia.zorbage.type.data.universal.UniversalRepresentation;
import nom.bdezonia.zorbage.type.storage.coder.BitCoder;
import nom.bdezonia.zorbage.type.storage.coder.ByteCoder;

public final class SignedInt6Member
implements BitCoder,
ByteCoder,
Allocatable<SignedInt6Member>,
Duplicatable<SignedInt6Member>,
Settable<SignedInt6Member>,
Gettable<SignedInt6Member>,
UniversalRepresentation,
NumberMember<SignedInt6Member>,
PrimitiveConversion,
HighPrecRepresentation,
SetReal<Integer>,
GetReal<SignedInt8Member> {
    byte v;

    public SignedInt6Member() {
        this.v = 0;
    }

    public SignedInt6Member(SignedInt6Member other) {
        this.set(other);
    }

    public SignedInt6Member(String value) {
        TensorStringRepresentation rep = new TensorStringRepresentation(value);
        OctonionRepresentation val = rep.firstValue();
        int x = val.r().intValue();
        this.setV(x);
    }

    public SignedInt6Member(int v) {
        this.setV(v);
    }

    @Override
    public void v(SignedInt6Member value) {
        this.get(value);
    }

    public byte v() {
        return this.v;
    }

    @Override
    public void setV(SignedInt6Member value) {
        this.set(value);
    }

    @Override
    public void setV(int val) {
        this.v = (byte)(val % 64);
        if (this.v < -32) {
            this.v = (byte)(this.v + 64);
        } else if (this.v > 31) {
            this.v = (byte)(this.v - 64);
        }
    }

    public String toString() {
        return String.valueOf(this.v);
    }

    @Override
    public void toRep(TensorOctonionRepresentation rep) {
        rep.setValue(new OctonionRepresentation(new BigDecimal(this.v)));
    }

    @Override
    public void fromRep(TensorOctonionRepresentation rep) {
        this.setV(rep.getValue().r().intValue());
    }

    @Override
    public void get(SignedInt6Member other) {
        other.v = this.v;
    }

    @Override
    public void set(SignedInt6Member other) {
        this.v = other.v;
    }

    @Override
    public SignedInt6Member duplicate() {
        return new SignedInt6Member(this);
    }

    @Override
    public SignedInt6Member allocate() {
        return new SignedInt6Member();
    }

    @Override
    public int bitCount() {
        return 6;
    }

    @Override
    public void fromBitArray(long[] arr, int index, int offset) {
        if (offset < 59) {
            long b1b2b3b4b5b6 = arr[index] >>> offset & 0x3FL;
            this.setV((int)b1b2b3b4b5b6);
        } else if (offset == 63) {
            long b1 = arr[index] >>> 63 & 1L;
            long b2b3b4b5b6 = arr[index + 1] & 0x1FL;
            this.setV((int)(b1 << 5 | b2b3b4b5b6));
        } else if (offset == 62) {
            long b1b2 = arr[index] >>> 62 & 3L;
            long b3b4b5b6 = arr[index + 1] & 0xFL;
            this.setV((int)(b1b2 << 4 | b3b4b5b6));
        } else if (offset == 61) {
            long b1b2b3 = arr[index] >>> 61 & 7L;
            long b4b5b6 = arr[index + 1] & 7L;
            this.setV((int)(b1b2b3 << 3 | b4b5b6));
        } else if (offset == 60) {
            long b1b2b3b4 = arr[index] >>> 60 & 0xFL;
            long b5b6 = arr[index + 1] & 3L;
            this.setV((int)(b1b2b3b4 << 2 | b5b6));
        } else {
            long b1b2b3b4b5 = arr[index] >>> 60 & 0x1FL;
            long b6 = arr[index + 1] & 1L;
            this.setV((int)(b1b2b3b4b5 << 1 | b6));
        }
    }

    @Override
    public void toBitArray(long[] arr, int index, int offset) {
        if (offset < 59) {
            long oldVals = arr[index] & (63L << offset ^ 0xFFFFFFFFFFFFFFFFL);
            long newVals = (long)this.v << offset;
            arr[index] = newVals | oldVals;
        } else if (offset == 63) {
            long b1 = ((long)this.v & 0x20L) >>> 5;
            long b2b3b4b5b6 = (long)this.v & 0x1FL;
            long oldVals = arr[index] & Long.MAX_VALUE;
            long newVals = b1 << 63;
            arr[index] = newVals | oldVals;
            oldVals = arr[index + 1] & 0xFFFFFFFFFFFFFFE0L;
            newVals = b2b3b4b5b6 << 0;
            arr[index + 1] = newVals | oldVals;
        } else if (offset == 62) {
            long b1b2 = ((long)this.v & 0x30L) >>> 4;
            long b3b4b5b6 = (long)this.v & 0xFL;
            long oldVals = arr[index] & 0x3FFFFFFFFFFFFFFFL;
            long newVals = b1b2 << 62;
            arr[index] = newVals | oldVals;
            oldVals = arr[index + 1] & 0xFFFFFFFFFFFFFFF0L;
            newVals = b3b4b5b6 << 0;
            arr[index + 1] = newVals | oldVals;
        } else if (offset == 61) {
            long b1b2b3 = ((long)this.v & 0x38L) >>> 3;
            long b4b5b6 = (long)this.v & 7L;
            long oldVals = arr[index] & 0x1FFFFFFFFFFFFFFFL;
            long newVals = b1b2b3 << 61;
            arr[index] = newVals | oldVals;
            oldVals = arr[index + 1] & 0xFFFFFFFFFFFFFFF8L;
            newVals = b4b5b6 << 0;
            arr[index + 1] = newVals | oldVals;
        } else if (offset == 60) {
            long b1b2b3b4 = ((long)this.v & 0x3CL) >>> 2;
            long b5b6 = (long)this.v & 3L;
            long oldVals = arr[index] & 0xFFFFFFFFFFFFFFFL;
            long newVals = b1b2b3b4 << 60;
            arr[index] = newVals | oldVals;
            oldVals = arr[index + 1] & 0xFFFFFFFFFFFFFFFCL;
            newVals = b5b6 << 0;
            arr[index + 1] = newVals | oldVals;
        } else {
            long b1b2b3b4b5 = ((long)this.v & 0x3EL) >>> 1;
            long b6 = (long)this.v & 1L;
            long oldVals = arr[index] & 0x7FFFFFFFFFFFFFFL;
            long newVals = b1b2b3b4b5 << 59;
            arr[index] = newVals | oldVals;
            oldVals = arr[index + 1] & 0xFFFFFFFFFFFFFFFEL;
            newVals = b6 << 0;
            arr[index + 1] = newVals | oldVals;
        }
    }

    @Override
    public int byteCount() {
        return 1;
    }

    @Override
    public void fromByteArray(byte[] arr, int index) {
        this.setV(arr[index]);
    }

    @Override
    public void toByteArray(byte[] arr, int index) {
        arr[index] = this.v;
    }

    @Override
    public void fromByteFile(RandomAccessFile raf) throws IOException {
        this.setV(raf.readByte());
    }

    @Override
    public void toByteFile(RandomAccessFile raf) throws IOException {
        raf.writeByte(this.v);
    }

    @Override
    public long dimension(int d) {
        return 0L;
    }

    @Override
    public int numDimensions() {
        return 0;
    }

    @Override
    public PrimitiveRepresentation preferredRepresentation() {
        return PrimitiveRepresentation.BYTE;
    }

    @Override
    public int componentCount() {
        return 1;
    }

    @Override
    public void primComponentSetByte(IntegerIndex index, int component, byte v) {
        this.setV(v);
    }

    @Override
    public void primComponentSetShort(IntegerIndex index, int component, short v) {
        this.setV(v);
    }

    @Override
    public void primComponentSetInt(IntegerIndex index, int component, int v) {
        this.setV(v);
    }

    @Override
    public void primComponentSetLong(IntegerIndex index, int component, long v) {
        this.setV((int)v);
    }

    @Override
    public void primComponentSetFloat(IntegerIndex index, int component, float v) {
        this.setV((int)v);
    }

    @Override
    public void primComponentSetDouble(IntegerIndex index, int component, double v) {
        this.setV((int)v);
    }

    @Override
    public void primComponentSetBigInteger(IntegerIndex index, int component, BigInteger v) {
        this.setV(v.intValue());
    }

    @Override
    public void primComponentSetBigDecimal(IntegerIndex index, int component, BigDecimal v) {
        this.primComponentSetBigInteger(index, component, v.toBigInteger());
    }

    @Override
    public void primComponentSetByteSafe(IntegerIndex index, int component, byte v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            this.setV(v);
        }
    }

    @Override
    public void primComponentSetShortSafe(IntegerIndex index, int component, short v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            this.setV(v);
        }
    }

    @Override
    public void primComponentSetIntSafe(IntegerIndex index, int component, int v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            this.setV(v);
        }
    }

    @Override
    public void primComponentSetLongSafe(IntegerIndex index, int component, long v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0L) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            this.setV((int)v);
        }
    }

    @Override
    public void primComponentSetFloatSafe(IntegerIndex index, int component, float v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0.0f) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            this.setV((int)v);
        }
    }

    @Override
    public void primComponentSetDoubleSafe(IntegerIndex index, int component, double v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0.0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            this.setV((int)v);
        }
    }

    @Override
    public void primComponentSetBigIntegerSafe(IntegerIndex index, int component, BigInteger v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v.signum() != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            this.setV(v.intValue());
        }
    }

    @Override
    public void primComponentSetBigDecimalSafe(IntegerIndex index, int component, BigDecimal v) {
        this.primComponentSetBigIntegerSafe(index, component, v.toBigInteger());
    }

    @Override
    public byte primComponentGetAsByte(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            return this.v;
        }
        return 0;
    }

    @Override
    public short primComponentGetAsShort(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            return this.v;
        }
        return 0;
    }

    @Override
    public int primComponentGetAsInt(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            return this.v;
        }
        return 0;
    }

    @Override
    public long primComponentGetAsLong(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            return this.v;
        }
        return 0L;
    }

    @Override
    public float primComponentGetAsFloat(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            return this.v;
        }
        return 0.0f;
    }

    @Override
    public double primComponentGetAsDouble(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            return this.v;
        }
        return 0.0;
    }

    @Override
    public BigInteger primComponentGetAsBigInteger(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            return BigInteger.valueOf(this.v);
        }
        return BigInteger.ZERO;
    }

    @Override
    public BigDecimal primComponentGetAsBigDecimal(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            return BigDecimal.valueOf(this.v);
        }
        return BigDecimal.ZERO;
    }

    @Override
    public byte primComponentGetAsByteSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0;
        }
        return this.v;
    }

    @Override
    public short primComponentGetAsShortSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0;
        }
        return this.v;
    }

    @Override
    public int primComponentGetAsIntSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0;
        }
        return this.v;
    }

    @Override
    public long primComponentGetAsLongSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0L;
        }
        return this.v;
    }

    @Override
    public float primComponentGetAsFloatSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0.0f;
        }
        return this.v;
    }

    @Override
    public double primComponentGetAsDoubleSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0.0;
        }
        return this.v;
    }

    @Override
    public BigInteger primComponentGetAsBigIntegerSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return BigInteger.ZERO;
        }
        return BigInteger.valueOf(this.v);
    }

    @Override
    public BigDecimal primComponentGetAsBigDecimalSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return BigDecimal.ZERO;
        }
        return BigDecimal.valueOf(this.v);
    }

    @Override
    public void primitiveInit() {
        this.v = 0;
    }

    @Override
    public void toHighPrec(HighPrecisionMember result) {
        result.setV(BigDecimal.valueOf(this.v()));
    }

    @Override
    public void fromHighPrec(HighPrecisionMember input) {
        this.setV(input.v().intValue());
    }

    @Override
    public void setR(Integer val) {
        this.setV(val);
    }

    @Override
    public void getR(SignedInt8Member val) {
        val.setV(this.v);
    }
}

