/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.int6;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.ThreadLocalRandom;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.Gcd;
import nom.bdezonia.zorbage.algorithm.Lcm;
import nom.bdezonia.zorbage.algorithm.NumberWithin;
import nom.bdezonia.zorbage.algorithm.PowerNonNegative;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.BitOperations;
import nom.bdezonia.zorbage.type.algebra.Bounded;
import nom.bdezonia.zorbage.type.algebra.Integer;
import nom.bdezonia.zorbage.type.algebra.Random;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.int6.UnsignedInt6Member;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class UnsignedInt6Algebra
implements Integer<UnsignedInt6Algebra, UnsignedInt6Member>,
Bounded<UnsignedInt6Member>,
BitOperations<UnsignedInt6Member>,
Random<UnsignedInt6Member>,
Tolerance<UnsignedInt6Member, UnsignedInt6Member> {
    private final Function2<Boolean, UnsignedInt6Member, UnsignedInt6Member> EQ = new Function2<Boolean, UnsignedInt6Member, UnsignedInt6Member>(){

        @Override
        public Boolean call(UnsignedInt6Member a, UnsignedInt6Member b) {
            return a.v == b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt6Member, UnsignedInt6Member> NEQ = new Function2<Boolean, UnsignedInt6Member, UnsignedInt6Member>(){

        @Override
        public Boolean call(UnsignedInt6Member a, UnsignedInt6Member b) {
            return a.v != b.v;
        }
    };
    private final Procedure2<UnsignedInt6Member, UnsignedInt6Member> ASSIGN = new Procedure2<UnsignedInt6Member, UnsignedInt6Member>(){

        @Override
        public void call(UnsignedInt6Member a, UnsignedInt6Member b) {
            b.set(a);
        }
    };
    private final Procedure1<UnsignedInt6Member> ZER = new Procedure1<UnsignedInt6Member>(){

        @Override
        public void call(UnsignedInt6Member a) {
            a.v = 0;
        }
    };
    private final Procedure3<UnsignedInt6Member, UnsignedInt6Member, UnsignedInt6Member> ADD = new Procedure3<UnsignedInt6Member, UnsignedInt6Member, UnsignedInt6Member>(){

        @Override
        public void call(UnsignedInt6Member a, UnsignedInt6Member b, UnsignedInt6Member c) {
            c.setV(a.v + b.v);
        }
    };
    private final Procedure3<UnsignedInt6Member, UnsignedInt6Member, UnsignedInt6Member> SUB = new Procedure3<UnsignedInt6Member, UnsignedInt6Member, UnsignedInt6Member>(){

        @Override
        public void call(UnsignedInt6Member a, UnsignedInt6Member b, UnsignedInt6Member c) {
            c.setV(a.v - b.v);
        }
    };
    private final Procedure3<UnsignedInt6Member, UnsignedInt6Member, UnsignedInt6Member> MUL = new Procedure3<UnsignedInt6Member, UnsignedInt6Member, UnsignedInt6Member>(){

        @Override
        public void call(UnsignedInt6Member a, UnsignedInt6Member b, UnsignedInt6Member c) {
            c.setV(a.v * b.v);
        }
    };
    private final Procedure3<java.lang.Integer, UnsignedInt6Member, UnsignedInt6Member> POWER = new Procedure3<java.lang.Integer, UnsignedInt6Member, UnsignedInt6Member>(){

        @Override
        public void call(java.lang.Integer power, UnsignedInt6Member a, UnsignedInt6Member b) {
            PowerNonNegative.compute(G.UINT6, power, a, b);
        }
    };
    private final Procedure1<UnsignedInt6Member> UNITY = new Procedure1<UnsignedInt6Member>(){

        @Override
        public void call(UnsignedInt6Member a) {
            a.v = 1;
        }
    };
    private final Function2<Boolean, UnsignedInt6Member, UnsignedInt6Member> LESS = new Function2<Boolean, UnsignedInt6Member, UnsignedInt6Member>(){

        @Override
        public Boolean call(UnsignedInt6Member a, UnsignedInt6Member b) {
            return a.v < b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt6Member, UnsignedInt6Member> LE = new Function2<Boolean, UnsignedInt6Member, UnsignedInt6Member>(){

        @Override
        public Boolean call(UnsignedInt6Member a, UnsignedInt6Member b) {
            return a.v <= b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt6Member, UnsignedInt6Member> GREAT = new Function2<Boolean, UnsignedInt6Member, UnsignedInt6Member>(){

        @Override
        public Boolean call(UnsignedInt6Member a, UnsignedInt6Member b) {
            return a.v > b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt6Member, UnsignedInt6Member> GE = new Function2<Boolean, UnsignedInt6Member, UnsignedInt6Member>(){

        @Override
        public Boolean call(UnsignedInt6Member a, UnsignedInt6Member b) {
            return a.v >= b.v;
        }
    };
    private final Function2<java.lang.Integer, UnsignedInt6Member, UnsignedInt6Member> CMP = new Function2<java.lang.Integer, UnsignedInt6Member, UnsignedInt6Member>(){

        @Override
        public java.lang.Integer call(UnsignedInt6Member a, UnsignedInt6Member b) {
            if (a.v < b.v) {
                return -1;
            }
            if (a.v > b.v) {
                return 1;
            }
            return 0;
        }
    };
    private final Function1<java.lang.Integer, UnsignedInt6Member> SIG = new Function1<java.lang.Integer, UnsignedInt6Member>(){

        @Override
        public java.lang.Integer call(UnsignedInt6Member a) {
            if (a.v > 0) {
                return 1;
            }
            return 0;
        }
    };
    private final Procedure3<UnsignedInt6Member, UnsignedInt6Member, UnsignedInt6Member> MIN = new Procedure3<UnsignedInt6Member, UnsignedInt6Member, UnsignedInt6Member>(){

        @Override
        public void call(UnsignedInt6Member a, UnsignedInt6Member b, UnsignedInt6Member c) {
            if (a.v < b.v) {
                c.set(a);
            } else {
                c.set(b);
            }
        }
    };
    private final Procedure3<UnsignedInt6Member, UnsignedInt6Member, UnsignedInt6Member> MAX = new Procedure3<UnsignedInt6Member, UnsignedInt6Member, UnsignedInt6Member>(){

        @Override
        public void call(UnsignedInt6Member a, UnsignedInt6Member b, UnsignedInt6Member c) {
            if (a.v > b.v) {
                c.set(a);
            } else {
                c.set(b);
            }
        }
    };
    private final Procedure3<UnsignedInt6Member, UnsignedInt6Member, UnsignedInt6Member> GCD = new Procedure3<UnsignedInt6Member, UnsignedInt6Member, UnsignedInt6Member>(){

        @Override
        public void call(UnsignedInt6Member a, UnsignedInt6Member b, UnsignedInt6Member c) {
            Gcd.compute(G.UINT6, a, b, c);
        }
    };
    private final Procedure3<UnsignedInt6Member, UnsignedInt6Member, UnsignedInt6Member> LCM = new Procedure3<UnsignedInt6Member, UnsignedInt6Member, UnsignedInt6Member>(){

        @Override
        public void call(UnsignedInt6Member a, UnsignedInt6Member b, UnsignedInt6Member c) {
            Lcm.compute(G.UINT6, a, b, c);
        }
    };
    private final Function1<Boolean, UnsignedInt6Member> EVEN = new Function1<Boolean, UnsignedInt6Member>(){

        @Override
        public Boolean call(UnsignedInt6Member a) {
            return (a.v & 1) == 0;
        }
    };
    private final Function1<Boolean, UnsignedInt6Member> ODD = new Function1<Boolean, UnsignedInt6Member>(){

        @Override
        public Boolean call(UnsignedInt6Member a) {
            return (a.v & 1) == 1;
        }
    };
    private final Procedure3<UnsignedInt6Member, UnsignedInt6Member, UnsignedInt6Member> DIV = new Procedure3<UnsignedInt6Member, UnsignedInt6Member, UnsignedInt6Member>(){

        @Override
        public void call(UnsignedInt6Member a, UnsignedInt6Member b, UnsignedInt6Member d) {
            d.setV(a.v / b.v);
        }
    };
    private final Procedure3<UnsignedInt6Member, UnsignedInt6Member, UnsignedInt6Member> MOD = new Procedure3<UnsignedInt6Member, UnsignedInt6Member, UnsignedInt6Member>(){

        @Override
        public void call(UnsignedInt6Member a, UnsignedInt6Member b, UnsignedInt6Member m) {
            m.setV(a.v % b.v);
        }
    };
    private final Procedure4<UnsignedInt6Member, UnsignedInt6Member, UnsignedInt6Member, UnsignedInt6Member> DIVMOD = new Procedure4<UnsignedInt6Member, UnsignedInt6Member, UnsignedInt6Member, UnsignedInt6Member>(){

        @Override
        public void call(UnsignedInt6Member a, UnsignedInt6Member b, UnsignedInt6Member d, UnsignedInt6Member m) {
            UnsignedInt6Algebra.this.div().call(a, b, d);
            UnsignedInt6Algebra.this.mod().call(a, b, m);
        }
    };
    private final Procedure2<UnsignedInt6Member, UnsignedInt6Member> PRED = new Procedure2<UnsignedInt6Member, UnsignedInt6Member>(){

        @Override
        public void call(UnsignedInt6Member a, UnsignedInt6Member b) {
            if (a.v == 0) {
                b.v = (byte)63;
            } else {
                b.setV(a.v - 1);
            }
        }
    };
    private final Procedure2<UnsignedInt6Member, UnsignedInt6Member> SUCC = new Procedure2<UnsignedInt6Member, UnsignedInt6Member>(){

        @Override
        public void call(UnsignedInt6Member a, UnsignedInt6Member b) {
            if (a.v == 63) {
                b.v = 0;
            } else {
                b.setV(a.v + 1);
            }
        }
    };
    private final Procedure3<UnsignedInt6Member, UnsignedInt6Member, UnsignedInt6Member> POW = new Procedure3<UnsignedInt6Member, UnsignedInt6Member, UnsignedInt6Member>(){

        @Override
        public void call(UnsignedInt6Member a, UnsignedInt6Member b, UnsignedInt6Member c) {
            PowerNonNegative.compute(G.UINT6, b.v, a, c);
        }
    };
    private final Procedure1<UnsignedInt6Member> RAND = new Procedure1<UnsignedInt6Member>(){

        @Override
        public void call(UnsignedInt6Member a) {
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            a.setV(rng.nextInt(64));
        }
    };
    private final Procedure3<UnsignedInt6Member, UnsignedInt6Member, UnsignedInt6Member> AND = new Procedure3<UnsignedInt6Member, UnsignedInt6Member, UnsignedInt6Member>(){

        @Override
        public void call(UnsignedInt6Member a, UnsignedInt6Member b, UnsignedInt6Member c) {
            c.setV(a.v & b.v);
        }
    };
    private final Procedure3<UnsignedInt6Member, UnsignedInt6Member, UnsignedInt6Member> OR = new Procedure3<UnsignedInt6Member, UnsignedInt6Member, UnsignedInt6Member>(){

        @Override
        public void call(UnsignedInt6Member a, UnsignedInt6Member b, UnsignedInt6Member c) {
            c.setV(a.v | b.v);
        }
    };
    private final Procedure3<UnsignedInt6Member, UnsignedInt6Member, UnsignedInt6Member> XOR = new Procedure3<UnsignedInt6Member, UnsignedInt6Member, UnsignedInt6Member>(){

        @Override
        public void call(UnsignedInt6Member a, UnsignedInt6Member b, UnsignedInt6Member c) {
            c.setV(a.v ^ b.v);
        }
    };
    private final Procedure2<UnsignedInt6Member, UnsignedInt6Member> NOT = new Procedure2<UnsignedInt6Member, UnsignedInt6Member>(){

        @Override
        public void call(UnsignedInt6Member a, UnsignedInt6Member b) {
            b.setV(~a.v);
        }
    };
    private final Procedure3<UnsignedInt6Member, UnsignedInt6Member, UnsignedInt6Member> ANDNOT = new Procedure3<UnsignedInt6Member, UnsignedInt6Member, UnsignedInt6Member>(){

        @Override
        public void call(UnsignedInt6Member a, UnsignedInt6Member b, UnsignedInt6Member c) {
            c.setV(a.v & ~b.v);
        }
    };
    private final Procedure3<java.lang.Integer, UnsignedInt6Member, UnsignedInt6Member> SHL = new Procedure3<java.lang.Integer, UnsignedInt6Member, UnsignedInt6Member>(){

        @Override
        public void call(java.lang.Integer count, UnsignedInt6Member a, UnsignedInt6Member b) {
            if (count < 0) {
                UnsignedInt6Algebra.this.bitShiftRight().call(-count.intValue(), a, b);
            } else {
                count = count % 6;
                b.setV(a.v << count);
            }
        }
    };
    private final Procedure3<java.lang.Integer, UnsignedInt6Member, UnsignedInt6Member> SHRZ = new Procedure3<java.lang.Integer, UnsignedInt6Member, UnsignedInt6Member>(){

        @Override
        public void call(java.lang.Integer count, UnsignedInt6Member a, UnsignedInt6Member b) {
            if (count < 0) {
                UnsignedInt6Algebra.this.bitShiftLeft().call(-count.intValue(), a, b);
            } else {
                b.setV(a.v >>> count);
            }
        }
    };
    private final Procedure1<UnsignedInt6Member> MAXBOUND = new Procedure1<UnsignedInt6Member>(){

        @Override
        public void call(UnsignedInt6Member a) {
            a.v = (byte)63;
        }
    };
    private final Procedure1<UnsignedInt6Member> MINBOUND = new Procedure1<UnsignedInt6Member>(){

        @Override
        public void call(UnsignedInt6Member a) {
            a.v = 0;
        }
    };
    private final Function1<Boolean, UnsignedInt6Member> ISZERO = new Function1<Boolean, UnsignedInt6Member>(){

        @Override
        public Boolean call(UnsignedInt6Member a) {
            return a.v == 0;
        }
    };
    private final Procedure3<HighPrecisionMember, UnsignedInt6Member, UnsignedInt6Member> SBHP = new Procedure3<HighPrecisionMember, UnsignedInt6Member, UnsignedInt6Member>(){

        @Override
        public void call(HighPrecisionMember a, UnsignedInt6Member b, UnsignedInt6Member c) {
            BigDecimal tmp = a.v();
            tmp = tmp.multiply(new BigDecimal(b.v()));
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<HighPrecisionMember, UnsignedInt6Member, UnsignedInt6Member> SBHPR = new Procedure3<HighPrecisionMember, UnsignedInt6Member, UnsignedInt6Member>(){

        @Override
        public void call(HighPrecisionMember a, UnsignedInt6Member b, UnsignedInt6Member c) {
            BigDecimal tmp = a.v();
            int signum = (tmp = tmp.multiply(new BigDecimal(b.v()))).signum();
            tmp = signum < 0 ? tmp.subtract(G.ONE_HALF) : tmp.add(G.ONE_HALF);
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<RationalMember, UnsignedInt6Member, UnsignedInt6Member> SBR = new Procedure3<RationalMember, UnsignedInt6Member, UnsignedInt6Member>(){

        @Override
        public void call(RationalMember a, UnsignedInt6Member b, UnsignedInt6Member c) {
            BigInteger tmp = BigInteger.valueOf(b.v());
            tmp = tmp.multiply(a.n());
            tmp = tmp.divide(a.d());
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<Double, UnsignedInt6Member, UnsignedInt6Member> SBD = new Procedure3<Double, UnsignedInt6Member, UnsignedInt6Member>(){

        @Override
        public void call(Double a, UnsignedInt6Member b, UnsignedInt6Member c) {
            c.setV((int)(a * (double)b.v()));
        }
    };
    private final Procedure3<Double, UnsignedInt6Member, UnsignedInt6Member> SBDR = new Procedure3<Double, UnsignedInt6Member, UnsignedInt6Member>(){

        @Override
        public void call(Double a, UnsignedInt6Member b, UnsignedInt6Member c) {
            c.setV((int)Math.round(a * (double)b.v()));
        }
    };
    private final Function3<Boolean, UnsignedInt6Member, UnsignedInt6Member, UnsignedInt6Member> WITHIN = new Function3<Boolean, UnsignedInt6Member, UnsignedInt6Member, UnsignedInt6Member>(){

        @Override
        public Boolean call(UnsignedInt6Member tol, UnsignedInt6Member a, UnsignedInt6Member b) {
            return NumberWithin.compute(G.UINT6, tol, a, b);
        }
    };

    @Override
    public UnsignedInt6Member construct() {
        return new UnsignedInt6Member();
    }

    @Override
    public UnsignedInt6Member construct(UnsignedInt6Member other) {
        return new UnsignedInt6Member(other);
    }

    @Override
    public UnsignedInt6Member construct(String str) {
        return new UnsignedInt6Member(str);
    }

    @Override
    public Function2<Boolean, UnsignedInt6Member, UnsignedInt6Member> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, UnsignedInt6Member, UnsignedInt6Member> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<UnsignedInt6Member, UnsignedInt6Member> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure1<UnsignedInt6Member> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<UnsignedInt6Member, UnsignedInt6Member> negate() {
        return this.ASSIGN;
    }

    @Override
    public Procedure3<UnsignedInt6Member, UnsignedInt6Member, UnsignedInt6Member> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<UnsignedInt6Member, UnsignedInt6Member, UnsignedInt6Member> subtract() {
        return this.SUB;
    }

    @Override
    public Procedure3<UnsignedInt6Member, UnsignedInt6Member, UnsignedInt6Member> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt6Member, UnsignedInt6Member> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<UnsignedInt6Member> unity() {
        return this.UNITY;
    }

    @Override
    public Function2<Boolean, UnsignedInt6Member, UnsignedInt6Member> isLess() {
        return this.LESS;
    }

    @Override
    public Function2<Boolean, UnsignedInt6Member, UnsignedInt6Member> isLessEqual() {
        return this.LE;
    }

    @Override
    public Function2<Boolean, UnsignedInt6Member, UnsignedInt6Member> isGreater() {
        return this.GREAT;
    }

    @Override
    public Function2<Boolean, UnsignedInt6Member, UnsignedInt6Member> isGreaterEqual() {
        return this.GE;
    }

    @Override
    public Function2<java.lang.Integer, UnsignedInt6Member, UnsignedInt6Member> compare() {
        return this.CMP;
    }

    @Override
    public Function1<java.lang.Integer, UnsignedInt6Member> signum() {
        return this.SIG;
    }

    @Override
    public Procedure3<UnsignedInt6Member, UnsignedInt6Member, UnsignedInt6Member> min() {
        return this.MIN;
    }

    @Override
    public Procedure3<UnsignedInt6Member, UnsignedInt6Member, UnsignedInt6Member> max() {
        return this.MAX;
    }

    @Override
    public Procedure2<UnsignedInt6Member, UnsignedInt6Member> abs() {
        return this.ASSIGN;
    }

    @Override
    public Procedure2<UnsignedInt6Member, UnsignedInt6Member> norm() {
        return this.ASSIGN;
    }

    @Override
    public Procedure3<UnsignedInt6Member, UnsignedInt6Member, UnsignedInt6Member> gcd() {
        return this.GCD;
    }

    @Override
    public Procedure3<UnsignedInt6Member, UnsignedInt6Member, UnsignedInt6Member> lcm() {
        return this.LCM;
    }

    @Override
    public Function1<Boolean, UnsignedInt6Member> isEven() {
        return this.EVEN;
    }

    @Override
    public Function1<Boolean, UnsignedInt6Member> isOdd() {
        return this.ODD;
    }

    @Override
    public Procedure3<UnsignedInt6Member, UnsignedInt6Member, UnsignedInt6Member> div() {
        return this.DIV;
    }

    @Override
    public Procedure3<UnsignedInt6Member, UnsignedInt6Member, UnsignedInt6Member> mod() {
        return this.MOD;
    }

    @Override
    public Procedure4<UnsignedInt6Member, UnsignedInt6Member, UnsignedInt6Member, UnsignedInt6Member> divMod() {
        return this.DIVMOD;
    }

    @Override
    public Procedure2<UnsignedInt6Member, UnsignedInt6Member> pred() {
        return this.PRED;
    }

    @Override
    public Procedure2<UnsignedInt6Member, UnsignedInt6Member> succ() {
        return this.SUCC;
    }

    @Override
    public Procedure3<UnsignedInt6Member, UnsignedInt6Member, UnsignedInt6Member> pow() {
        return this.POW;
    }

    @Override
    public Procedure1<UnsignedInt6Member> random() {
        return this.RAND;
    }

    @Override
    public Procedure3<UnsignedInt6Member, UnsignedInt6Member, UnsignedInt6Member> bitAnd() {
        return this.AND;
    }

    @Override
    public Procedure3<UnsignedInt6Member, UnsignedInt6Member, UnsignedInt6Member> bitOr() {
        return this.OR;
    }

    @Override
    public Procedure3<UnsignedInt6Member, UnsignedInt6Member, UnsignedInt6Member> bitXor() {
        return this.XOR;
    }

    @Override
    public Procedure2<UnsignedInt6Member, UnsignedInt6Member> bitNot() {
        return this.NOT;
    }

    @Override
    public Procedure3<UnsignedInt6Member, UnsignedInt6Member, UnsignedInt6Member> bitAndNot() {
        return this.ANDNOT;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt6Member, UnsignedInt6Member> bitShiftLeft() {
        return this.SHL;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt6Member, UnsignedInt6Member> bitShiftRight() {
        return this.SHRZ;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt6Member, UnsignedInt6Member> bitShiftRightFillZero() {
        return this.SHRZ;
    }

    @Override
    public Procedure1<UnsignedInt6Member> maxBound() {
        return this.MAXBOUND;
    }

    @Override
    public Procedure1<UnsignedInt6Member> minBound() {
        return this.MINBOUND;
    }

    @Override
    public Function1<Boolean, UnsignedInt6Member> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<UnsignedInt6Member, UnsignedInt6Member, UnsignedInt6Member> scale() {
        return this.MUL;
    }

    @Override
    public Procedure3<HighPrecisionMember, UnsignedInt6Member, UnsignedInt6Member> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<HighPrecisionMember, UnsignedInt6Member, UnsignedInt6Member> scaleByHighPrecAndRound() {
        return this.SBHPR;
    }

    @Override
    public Procedure3<RationalMember, UnsignedInt6Member, UnsignedInt6Member> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, UnsignedInt6Member, UnsignedInt6Member> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<Double, UnsignedInt6Member, UnsignedInt6Member> scaleByDoubleAndRound() {
        return this.SBDR;
    }

    @Override
    public Function3<Boolean, UnsignedInt6Member, UnsignedInt6Member, UnsignedInt6Member> within() {
        return this.WITHIN;
    }
}

