/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.int64;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.ThreadLocalRandom;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.Gcd;
import nom.bdezonia.zorbage.algorithm.Lcm;
import nom.bdezonia.zorbage.algorithm.Max;
import nom.bdezonia.zorbage.algorithm.Min;
import nom.bdezonia.zorbage.algorithm.NumberWithin;
import nom.bdezonia.zorbage.algorithm.PowerNonNegative;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.BitOperations;
import nom.bdezonia.zorbage.type.algebra.Bounded;
import nom.bdezonia.zorbage.type.algebra.Integer;
import nom.bdezonia.zorbage.type.algebra.Random;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.int64.SignedInt64Member;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class SignedInt64Algebra
implements Integer<SignedInt64Algebra, SignedInt64Member>,
Bounded<SignedInt64Member>,
BitOperations<SignedInt64Member>,
Random<SignedInt64Member>,
Tolerance<SignedInt64Member, SignedInt64Member> {
    private static final SignedInt64Member ZERO = new SignedInt64Member();
    private static final SignedInt64Member ONE = new SignedInt64Member(1L);
    private final Function2<Boolean, SignedInt64Member, SignedInt64Member> EQ = new Function2<Boolean, SignedInt64Member, SignedInt64Member>(){

        @Override
        public Boolean call(SignedInt64Member a, SignedInt64Member b) {
            return a.v() == b.v();
        }
    };
    private final Function2<Boolean, SignedInt64Member, SignedInt64Member> NEQ = new Function2<Boolean, SignedInt64Member, SignedInt64Member>(){

        @Override
        public Boolean call(SignedInt64Member a, SignedInt64Member b) {
            return a.v() != b.v();
        }
    };
    private final Procedure2<SignedInt64Member, SignedInt64Member> ASSIGN = new Procedure2<SignedInt64Member, SignedInt64Member>(){

        @Override
        public void call(SignedInt64Member from, SignedInt64Member to) {
            to.v = from.v;
        }
    };
    private final Procedure2<SignedInt64Member, SignedInt64Member> ABS = new Procedure2<SignedInt64Member, SignedInt64Member>(){

        @Override
        public void call(SignedInt64Member a, SignedInt64Member b) {
            if (a.v() == Long.MIN_VALUE) {
                throw new IllegalArgumentException("Cannot convert -minint symmetrically");
            }
            b.v = Math.abs(a.v);
        }
    };
    private final Procedure3<SignedInt64Member, SignedInt64Member, SignedInt64Member> MUL = new Procedure3<SignedInt64Member, SignedInt64Member, SignedInt64Member>(){

        @Override
        public void call(SignedInt64Member a, SignedInt64Member b, SignedInt64Member c) {
            c.setV(a.v() * b.v());
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt64Member, SignedInt64Member> POWER = new Procedure3<java.lang.Integer, SignedInt64Member, SignedInt64Member>(){

        @Override
        public void call(java.lang.Integer power, SignedInt64Member a, SignedInt64Member b) {
            PowerNonNegative.compute(G.INT64, power, a, b);
        }
    };
    private final Procedure1<SignedInt64Member> ZER = new Procedure1<SignedInt64Member>(){

        @Override
        public void call(SignedInt64Member a) {
            a.v = 0L;
        }
    };
    private final Procedure2<SignedInt64Member, SignedInt64Member> NEG = new Procedure2<SignedInt64Member, SignedInt64Member>(){

        @Override
        public void call(SignedInt64Member a, SignedInt64Member b) {
            if (a.v() == Long.MIN_VALUE) {
                throw new IllegalArgumentException("Cannot convert -minint symmetrically");
            }
            b.v = -a.v;
        }
    };
    private final Procedure3<SignedInt64Member, SignedInt64Member, SignedInt64Member> ADD = new Procedure3<SignedInt64Member, SignedInt64Member, SignedInt64Member>(){

        @Override
        public void call(SignedInt64Member a, SignedInt64Member b, SignedInt64Member c) {
            c.setV(a.v() + b.v());
        }
    };
    private final Procedure3<SignedInt64Member, SignedInt64Member, SignedInt64Member> SUB = new Procedure3<SignedInt64Member, SignedInt64Member, SignedInt64Member>(){

        @Override
        public void call(SignedInt64Member a, SignedInt64Member b, SignedInt64Member c) {
            c.setV(a.v() - b.v());
        }
    };
    private final Procedure1<SignedInt64Member> UNITY = new Procedure1<SignedInt64Member>(){

        @Override
        public void call(SignedInt64Member a) {
            a.v = 1L;
        }
    };
    private final Function2<Boolean, SignedInt64Member, SignedInt64Member> LESS = new Function2<Boolean, SignedInt64Member, SignedInt64Member>(){

        @Override
        public Boolean call(SignedInt64Member a, SignedInt64Member b) {
            return a.v() < b.v();
        }
    };
    private final Function2<Boolean, SignedInt64Member, SignedInt64Member> LE = new Function2<Boolean, SignedInt64Member, SignedInt64Member>(){

        @Override
        public Boolean call(SignedInt64Member a, SignedInt64Member b) {
            return a.v() <= b.v();
        }
    };
    private final Function2<Boolean, SignedInt64Member, SignedInt64Member> GREAT = new Function2<Boolean, SignedInt64Member, SignedInt64Member>(){

        @Override
        public Boolean call(SignedInt64Member a, SignedInt64Member b) {
            return a.v() > b.v();
        }
    };
    private final Function2<Boolean, SignedInt64Member, SignedInt64Member> GE = new Function2<Boolean, SignedInt64Member, SignedInt64Member>(){

        @Override
        public Boolean call(SignedInt64Member a, SignedInt64Member b) {
            return a.v() >= b.v();
        }
    };
    private final Function2<java.lang.Integer, SignedInt64Member, SignedInt64Member> CMP = new Function2<java.lang.Integer, SignedInt64Member, SignedInt64Member>(){

        @Override
        public java.lang.Integer call(SignedInt64Member a, SignedInt64Member b) {
            if (a.v() < b.v()) {
                return -1;
            }
            if (a.v() > b.v()) {
                return 1;
            }
            return 0;
        }
    };
    private final Function1<java.lang.Integer, SignedInt64Member> SIG = new Function1<java.lang.Integer, SignedInt64Member>(){

        @Override
        public java.lang.Integer call(SignedInt64Member a) {
            if (a.v() < 0L) {
                return -1;
            }
            if (a.v() > 0L) {
                return 1;
            }
            return 0;
        }
    };
    private final Procedure3<SignedInt64Member, SignedInt64Member, SignedInt64Member> DIV = new Procedure3<SignedInt64Member, SignedInt64Member, SignedInt64Member>(){

        @Override
        public void call(SignedInt64Member a, SignedInt64Member b, SignedInt64Member c) {
            if (b.v() == -1L && a.v() == Long.MIN_VALUE) {
                throw new IllegalArgumentException("cannot divide minint by -1");
            }
            c.setV(a.v() / b.v());
        }
    };
    private final Procedure3<SignedInt64Member, SignedInt64Member, SignedInt64Member> MOD = new Procedure3<SignedInt64Member, SignedInt64Member, SignedInt64Member>(){

        @Override
        public void call(SignedInt64Member a, SignedInt64Member b, SignedInt64Member c) {
            c.setV(a.v() % b.v());
        }
    };
    private final Procedure4<SignedInt64Member, SignedInt64Member, SignedInt64Member, SignedInt64Member> DIVMOD = new Procedure4<SignedInt64Member, SignedInt64Member, SignedInt64Member, SignedInt64Member>(){

        @Override
        public void call(SignedInt64Member a, SignedInt64Member b, SignedInt64Member d, SignedInt64Member m) {
            SignedInt64Algebra.this.div().call(a, b, d);
            SignedInt64Algebra.this.mod().call(a, b, m);
        }
    };
    private final Procedure3<SignedInt64Member, SignedInt64Member, SignedInt64Member> GCD = new Procedure3<SignedInt64Member, SignedInt64Member, SignedInt64Member>(){

        @Override
        public void call(SignedInt64Member a, SignedInt64Member b, SignedInt64Member c) {
            Gcd.compute(G.INT64, a, b, c);
        }
    };
    private final Procedure3<SignedInt64Member, SignedInt64Member, SignedInt64Member> LCM = new Procedure3<SignedInt64Member, SignedInt64Member, SignedInt64Member>(){

        @Override
        public void call(SignedInt64Member a, SignedInt64Member b, SignedInt64Member c) {
            Lcm.compute(G.INT64, a, b, c);
        }
    };
    private final Function1<Boolean, SignedInt64Member> EVEN = new Function1<Boolean, SignedInt64Member>(){

        @Override
        public Boolean call(SignedInt64Member a) {
            return (a.v() & 1L) == 0L;
        }
    };
    private final Function1<Boolean, SignedInt64Member> ODD = new Function1<Boolean, SignedInt64Member>(){

        @Override
        public Boolean call(SignedInt64Member a) {
            return (a.v() & 1L) == 1L;
        }
    };
    private final Procedure2<SignedInt64Member, SignedInt64Member> PRED = new Procedure2<SignedInt64Member, SignedInt64Member>(){

        @Override
        public void call(SignedInt64Member a, SignedInt64Member b) {
            b.v = a.v - 1L;
        }
    };
    private final Procedure2<SignedInt64Member, SignedInt64Member> SUCC = new Procedure2<SignedInt64Member, SignedInt64Member>(){

        @Override
        public void call(SignedInt64Member a, SignedInt64Member b) {
            b.v = a.v + 1L;
        }
    };
    private final Procedure1<SignedInt64Member> MAXBOUND = new Procedure1<SignedInt64Member>(){

        @Override
        public void call(SignedInt64Member a) {
            a.v = Long.MAX_VALUE;
        }
    };
    private final Procedure1<SignedInt64Member> MINBOUND = new Procedure1<SignedInt64Member>(){

        @Override
        public void call(SignedInt64Member a) {
            a.v = Long.MIN_VALUE;
        }
    };
    private final Procedure3<SignedInt64Member, SignedInt64Member, SignedInt64Member> BITAND = new Procedure3<SignedInt64Member, SignedInt64Member, SignedInt64Member>(){

        @Override
        public void call(SignedInt64Member a, SignedInt64Member b, SignedInt64Member c) {
            c.setV(a.v() & b.v());
        }
    };
    private final Procedure3<SignedInt64Member, SignedInt64Member, SignedInt64Member> BITOR = new Procedure3<SignedInt64Member, SignedInt64Member, SignedInt64Member>(){

        @Override
        public void call(SignedInt64Member a, SignedInt64Member b, SignedInt64Member c) {
            c.setV(a.v() | b.v());
        }
    };
    private final Procedure3<SignedInt64Member, SignedInt64Member, SignedInt64Member> BITXOR = new Procedure3<SignedInt64Member, SignedInt64Member, SignedInt64Member>(){

        @Override
        public void call(SignedInt64Member a, SignedInt64Member b, SignedInt64Member c) {
            c.setV(a.v() ^ b.v());
        }
    };
    private final Procedure2<SignedInt64Member, SignedInt64Member> BITNOT = new Procedure2<SignedInt64Member, SignedInt64Member>(){

        @Override
        public void call(SignedInt64Member a, SignedInt64Member b) {
            b.setV(a.v() ^ 0xFFFFFFFFFFFFFFFFL);
        }
    };
    private final Procedure3<SignedInt64Member, SignedInt64Member, SignedInt64Member> BITANDNOT = new Procedure3<SignedInt64Member, SignedInt64Member, SignedInt64Member>(){

        @Override
        public void call(SignedInt64Member a, SignedInt64Member b, SignedInt64Member c) {
            c.setV(a.v() & (b.v() ^ 0xFFFFFFFFFFFFFFFFL));
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt64Member, SignedInt64Member> BITSHL = new Procedure3<java.lang.Integer, SignedInt64Member, SignedInt64Member>(){

        @Override
        public void call(java.lang.Integer count, SignedInt64Member a, SignedInt64Member b) {
            if (count < 0) {
                SignedInt64Algebra.this.bitShiftRight().call(-count.intValue(), a, b);
            } else {
                count = count % 64;
                b.setV(a.v() << count);
            }
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt64Member, SignedInt64Member> BITSHR = new Procedure3<java.lang.Integer, SignedInt64Member, SignedInt64Member>(){

        @Override
        public void call(java.lang.Integer count, SignedInt64Member a, SignedInt64Member b) {
            if (count < 0) {
                SignedInt64Algebra.this.bitShiftLeft().call(-count.intValue(), a, b);
            } else {
                b.setV(a.v() >> count);
            }
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt64Member, SignedInt64Member> BITSHRZ = new Procedure3<java.lang.Integer, SignedInt64Member, SignedInt64Member>(){

        @Override
        public void call(java.lang.Integer count, SignedInt64Member a, SignedInt64Member b) {
            if (count < 0) {
                SignedInt64Algebra.this.bitShiftLeft().call(-count.intValue(), a, b);
            } else {
                b.setV(a.v() >>> count);
            }
        }
    };
    private final Procedure3<SignedInt64Member, SignedInt64Member, SignedInt64Member> MIN = new Procedure3<SignedInt64Member, SignedInt64Member, SignedInt64Member>(){

        @Override
        public void call(SignedInt64Member a, SignedInt64Member b, SignedInt64Member c) {
            Min.compute(G.INT64, a, b, c);
        }
    };
    private final Procedure3<SignedInt64Member, SignedInt64Member, SignedInt64Member> MAX = new Procedure3<SignedInt64Member, SignedInt64Member, SignedInt64Member>(){

        @Override
        public void call(SignedInt64Member a, SignedInt64Member b, SignedInt64Member c) {
            Max.compute(G.INT64, a, b, c);
        }
    };
    private final Procedure1<SignedInt64Member> RAND = new Procedure1<SignedInt64Member>(){

        @Override
        public void call(SignedInt64Member a) {
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            a.v = rng.nextLong();
        }
    };
    private final Procedure3<SignedInt64Member, SignedInt64Member, SignedInt64Member> POW = new Procedure3<SignedInt64Member, SignedInt64Member, SignedInt64Member>(){

        @Override
        public void call(SignedInt64Member a, SignedInt64Member b, SignedInt64Member c) {
            if (b.v() < 0L) {
                throw new IllegalArgumentException("Cannot get negative powers from int64s");
            }
            if (SignedInt64Algebra.this.signum().call(a) == 0 && SignedInt64Algebra.this.signum().call(b) == 0) {
                throw new IllegalArgumentException("0^0 is not a number");
            }
            SignedInt64Member tmp = new SignedInt64Member(ONE);
            SignedInt64Member pow = new SignedInt64Member(b);
            while (!SignedInt64Algebra.this.isEqual().call(pow, ZERO).booleanValue()) {
                SignedInt64Algebra.this.multiply().call(tmp, a, tmp);
                SignedInt64Algebra.this.pred().call(pow, pow);
            }
            SignedInt64Algebra.this.assign().call(tmp, c);
        }
    };
    private final Function1<Boolean, SignedInt64Member> ISZERO = new Function1<Boolean, SignedInt64Member>(){

        @Override
        public Boolean call(SignedInt64Member a) {
            return a.v() == 0L;
        }
    };
    private final Procedure3<HighPrecisionMember, SignedInt64Member, SignedInt64Member> SBHP = new Procedure3<HighPrecisionMember, SignedInt64Member, SignedInt64Member>(){

        @Override
        public void call(HighPrecisionMember a, SignedInt64Member b, SignedInt64Member c) {
            BigDecimal tmp = a.v();
            tmp = tmp.multiply(new BigDecimal(b.v()));
            c.setV(tmp.longValue());
        }
    };
    private final Procedure3<HighPrecisionMember, SignedInt64Member, SignedInt64Member> SBHPR = new Procedure3<HighPrecisionMember, SignedInt64Member, SignedInt64Member>(){

        @Override
        public void call(HighPrecisionMember a, SignedInt64Member b, SignedInt64Member c) {
            BigDecimal tmp = a.v();
            int signum = (tmp = tmp.multiply(new BigDecimal(b.v()))).signum();
            tmp = signum < 0 ? tmp.subtract(G.ONE_HALF) : tmp.add(G.ONE_HALF);
            c.setV(tmp.longValue());
        }
    };
    private final Procedure3<RationalMember, SignedInt64Member, SignedInt64Member> SBR = new Procedure3<RationalMember, SignedInt64Member, SignedInt64Member>(){

        @Override
        public void call(RationalMember a, SignedInt64Member b, SignedInt64Member c) {
            BigInteger tmp = BigInteger.valueOf(b.v());
            tmp = tmp.multiply(a.n());
            tmp = tmp.divide(a.d());
            c.setV(tmp.longValue());
        }
    };
    private final Procedure3<Double, SignedInt64Member, SignedInt64Member> SBD = new Procedure3<Double, SignedInt64Member, SignedInt64Member>(){

        @Override
        public void call(Double a, SignedInt64Member b, SignedInt64Member c) {
            c.setV((long)(a * (double)b.v()));
        }
    };
    private final Procedure3<Double, SignedInt64Member, SignedInt64Member> SBDR = new Procedure3<Double, SignedInt64Member, SignedInt64Member>(){

        @Override
        public void call(Double a, SignedInt64Member b, SignedInt64Member c) {
            c.setV(Math.round(a * (double)b.v()));
        }
    };
    private final Function3<Boolean, SignedInt64Member, SignedInt64Member, SignedInt64Member> WITHIN = new Function3<Boolean, SignedInt64Member, SignedInt64Member, SignedInt64Member>(){

        @Override
        public Boolean call(SignedInt64Member tol, SignedInt64Member a, SignedInt64Member b) {
            return NumberWithin.compute(G.INT64, tol, a, b);
        }
    };

    @Override
    public Function2<Boolean, SignedInt64Member, SignedInt64Member> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, SignedInt64Member, SignedInt64Member> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public SignedInt64Member construct() {
        return new SignedInt64Member();
    }

    @Override
    public SignedInt64Member construct(SignedInt64Member other) {
        return new SignedInt64Member(other);
    }

    @Override
    public SignedInt64Member construct(String s) {
        return new SignedInt64Member(s);
    }

    @Override
    public Procedure2<SignedInt64Member, SignedInt64Member> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure2<SignedInt64Member, SignedInt64Member> abs() {
        return this.ABS;
    }

    @Override
    public Procedure3<SignedInt64Member, SignedInt64Member, SignedInt64Member> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt64Member, SignedInt64Member> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<SignedInt64Member> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<SignedInt64Member, SignedInt64Member> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<SignedInt64Member, SignedInt64Member, SignedInt64Member> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<SignedInt64Member, SignedInt64Member, SignedInt64Member> subtract() {
        return this.SUB;
    }

    @Override
    public Procedure1<SignedInt64Member> unity() {
        return this.UNITY;
    }

    @Override
    public Function2<Boolean, SignedInt64Member, SignedInt64Member> isLess() {
        return this.LESS;
    }

    @Override
    public Function2<Boolean, SignedInt64Member, SignedInt64Member> isLessEqual() {
        return this.LE;
    }

    @Override
    public Function2<Boolean, SignedInt64Member, SignedInt64Member> isGreater() {
        return this.GREAT;
    }

    @Override
    public Function2<Boolean, SignedInt64Member, SignedInt64Member> isGreaterEqual() {
        return this.GE;
    }

    @Override
    public Function2<java.lang.Integer, SignedInt64Member, SignedInt64Member> compare() {
        return this.CMP;
    }

    @Override
    public Function1<java.lang.Integer, SignedInt64Member> signum() {
        return this.SIG;
    }

    @Override
    public Procedure3<SignedInt64Member, SignedInt64Member, SignedInt64Member> div() {
        return this.DIV;
    }

    @Override
    public Procedure3<SignedInt64Member, SignedInt64Member, SignedInt64Member> mod() {
        return this.MOD;
    }

    @Override
    public Procedure4<SignedInt64Member, SignedInt64Member, SignedInt64Member, SignedInt64Member> divMod() {
        return this.DIVMOD;
    }

    @Override
    public Procedure3<SignedInt64Member, SignedInt64Member, SignedInt64Member> gcd() {
        return this.GCD;
    }

    @Override
    public Procedure3<SignedInt64Member, SignedInt64Member, SignedInt64Member> lcm() {
        return this.LCM;
    }

    @Override
    public Procedure2<SignedInt64Member, SignedInt64Member> norm() {
        return this.ABS;
    }

    @Override
    public Function1<Boolean, SignedInt64Member> isEven() {
        return this.EVEN;
    }

    @Override
    public Function1<Boolean, SignedInt64Member> isOdd() {
        return this.ODD;
    }

    @Override
    public Procedure2<SignedInt64Member, SignedInt64Member> pred() {
        return this.PRED;
    }

    @Override
    public Procedure2<SignedInt64Member, SignedInt64Member> succ() {
        return this.SUCC;
    }

    @Override
    public Procedure1<SignedInt64Member> maxBound() {
        return this.MAXBOUND;
    }

    @Override
    public Procedure1<SignedInt64Member> minBound() {
        return this.MINBOUND;
    }

    @Override
    public Procedure3<SignedInt64Member, SignedInt64Member, SignedInt64Member> bitAnd() {
        return this.BITAND;
    }

    @Override
    public Procedure3<SignedInt64Member, SignedInt64Member, SignedInt64Member> bitOr() {
        return this.BITOR;
    }

    @Override
    public Procedure3<SignedInt64Member, SignedInt64Member, SignedInt64Member> bitXor() {
        return this.BITXOR;
    }

    @Override
    public Procedure3<SignedInt64Member, SignedInt64Member, SignedInt64Member> bitAndNot() {
        return this.BITANDNOT;
    }

    @Override
    public Procedure2<SignedInt64Member, SignedInt64Member> bitNot() {
        return this.BITNOT;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt64Member, SignedInt64Member> bitShiftLeft() {
        return this.BITSHL;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt64Member, SignedInt64Member> bitShiftRight() {
        return this.BITSHR;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt64Member, SignedInt64Member> bitShiftRightFillZero() {
        return this.BITSHRZ;
    }

    @Override
    public Procedure3<SignedInt64Member, SignedInt64Member, SignedInt64Member> min() {
        return this.MIN;
    }

    @Override
    public Procedure3<SignedInt64Member, SignedInt64Member, SignedInt64Member> max() {
        return this.MAX;
    }

    @Override
    public Procedure1<SignedInt64Member> random() {
        return this.RAND;
    }

    @Override
    public Procedure3<SignedInt64Member, SignedInt64Member, SignedInt64Member> pow() {
        return this.POW;
    }

    @Override
    public Function1<Boolean, SignedInt64Member> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<SignedInt64Member, SignedInt64Member, SignedInt64Member> scale() {
        return this.MUL;
    }

    @Override
    public Procedure3<HighPrecisionMember, SignedInt64Member, SignedInt64Member> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<HighPrecisionMember, SignedInt64Member, SignedInt64Member> scaleByHighPrecAndRound() {
        return this.SBHPR;
    }

    @Override
    public Procedure3<RationalMember, SignedInt64Member, SignedInt64Member> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, SignedInt64Member, SignedInt64Member> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<Double, SignedInt64Member, SignedInt64Member> scaleByDoubleAndRound() {
        return this.SBDR;
    }

    @Override
    public Function3<Boolean, SignedInt64Member, SignedInt64Member, SignedInt64Member> within() {
        return this.WITHIN;
    }
}

