/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.int64;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.ThreadLocalRandom;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.DivMod;
import nom.bdezonia.zorbage.algorithm.Gcd;
import nom.bdezonia.zorbage.algorithm.Lcm;
import nom.bdezonia.zorbage.algorithm.Max;
import nom.bdezonia.zorbage.algorithm.Min;
import nom.bdezonia.zorbage.algorithm.NumberWithin;
import nom.bdezonia.zorbage.algorithm.PowerNonNegative;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.BitOperations;
import nom.bdezonia.zorbage.type.algebra.Bounded;
import nom.bdezonia.zorbage.type.algebra.Integer;
import nom.bdezonia.zorbage.type.algebra.Random;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.int64.UnsignedInt64Member;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class UnsignedInt64Algebra
implements Integer<UnsignedInt64Algebra, UnsignedInt64Member>,
Bounded<UnsignedInt64Member>,
BitOperations<UnsignedInt64Member>,
Random<UnsignedInt64Member>,
Tolerance<UnsignedInt64Member, UnsignedInt64Member> {
    private static final UnsignedInt64Member ZERO = new UnsignedInt64Member();
    private static final UnsignedInt64Member ONE = new UnsignedInt64Member(BigInteger.ONE);
    private final Function2<Boolean, UnsignedInt64Member, UnsignedInt64Member> EQ = new Function2<Boolean, UnsignedInt64Member, UnsignedInt64Member>(){

        @Override
        public Boolean call(UnsignedInt64Member a, UnsignedInt64Member b) {
            return a.v == b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt64Member, UnsignedInt64Member> NEQ = new Function2<Boolean, UnsignedInt64Member, UnsignedInt64Member>(){

        @Override
        public Boolean call(UnsignedInt64Member a, UnsignedInt64Member b) {
            return a.v != b.v;
        }
    };
    private final Procedure2<UnsignedInt64Member, UnsignedInt64Member> ASSIGN = new Procedure2<UnsignedInt64Member, UnsignedInt64Member>(){

        @Override
        public void call(UnsignedInt64Member from, UnsignedInt64Member to) {
            to.set(from);
        }
    };
    private final Procedure3<UnsignedInt64Member, UnsignedInt64Member, UnsignedInt64Member> MUL = new Procedure3<UnsignedInt64Member, UnsignedInt64Member, UnsignedInt64Member>(){

        @Override
        public void call(UnsignedInt64Member a, UnsignedInt64Member b, UnsignedInt64Member c) {
            c.v = a.v * b.v;
        }
    };
    private Procedure3<java.lang.Integer, UnsignedInt64Member, UnsignedInt64Member> POWER = new Procedure3<java.lang.Integer, UnsignedInt64Member, UnsignedInt64Member>(){

        @Override
        public void call(java.lang.Integer power, UnsignedInt64Member a, UnsignedInt64Member b) {
            PowerNonNegative.compute(G.UINT64, power, a, b);
        }
    };
    private final Procedure1<UnsignedInt64Member> ZER = new Procedure1<UnsignedInt64Member>(){

        @Override
        public void call(UnsignedInt64Member a) {
            a.v = 0L;
        }
    };
    private final Procedure3<UnsignedInt64Member, UnsignedInt64Member, UnsignedInt64Member> ADD = new Procedure3<UnsignedInt64Member, UnsignedInt64Member, UnsignedInt64Member>(){

        @Override
        public void call(UnsignedInt64Member a, UnsignedInt64Member b, UnsignedInt64Member c) {
            c.v = a.v + b.v;
        }
    };
    private final Procedure3<UnsignedInt64Member, UnsignedInt64Member, UnsignedInt64Member> SUB = new Procedure3<UnsignedInt64Member, UnsignedInt64Member, UnsignedInt64Member>(){

        @Override
        public void call(UnsignedInt64Member a, UnsignedInt64Member b, UnsignedInt64Member c) {
            c.v = a.v - b.v;
        }
    };
    private final Procedure1<UnsignedInt64Member> UNITY = new Procedure1<UnsignedInt64Member>(){

        @Override
        public void call(UnsignedInt64Member a) {
            a.v = 1L;
        }
    };
    private final Function2<Boolean, UnsignedInt64Member, UnsignedInt64Member> LESS = new Function2<Boolean, UnsignedInt64Member, UnsignedInt64Member>(){

        @Override
        public Boolean call(UnsignedInt64Member a, UnsignedInt64Member b) {
            return UnsignedInt64Algebra.this.compare().call(a, b) < 0;
        }
    };
    private final Function2<Boolean, UnsignedInt64Member, UnsignedInt64Member> LE = new Function2<Boolean, UnsignedInt64Member, UnsignedInt64Member>(){

        @Override
        public Boolean call(UnsignedInt64Member a, UnsignedInt64Member b) {
            return UnsignedInt64Algebra.this.compare().call(a, b) <= 0;
        }
    };
    private final Function2<Boolean, UnsignedInt64Member, UnsignedInt64Member> GREAT = new Function2<Boolean, UnsignedInt64Member, UnsignedInt64Member>(){

        @Override
        public Boolean call(UnsignedInt64Member a, UnsignedInt64Member b) {
            return UnsignedInt64Algebra.this.compare().call(a, b) > 0;
        }
    };
    private final Function2<Boolean, UnsignedInt64Member, UnsignedInt64Member> GE = new Function2<Boolean, UnsignedInt64Member, UnsignedInt64Member>(){

        @Override
        public Boolean call(UnsignedInt64Member a, UnsignedInt64Member b) {
            return UnsignedInt64Algebra.this.compare().call(a, b) >= 0;
        }
    };
    private final Function2<java.lang.Integer, UnsignedInt64Member, UnsignedInt64Member> CMP = new Function2<java.lang.Integer, UnsignedInt64Member, UnsignedInt64Member>(){

        @Override
        public java.lang.Integer call(UnsignedInt64Member a, UnsignedInt64Member b) {
            long aHi = a.v & Long.MIN_VALUE;
            long bHi = b.v & Long.MIN_VALUE;
            if (aHi == 0L && bHi != 0L) {
                return -1;
            }
            if (aHi != 0L && bHi == 0L) {
                return 1;
            }
            long aLo = a.v & Long.MAX_VALUE;
            long bLo = b.v & Long.MAX_VALUE;
            if (aLo < bLo) {
                return -1;
            }
            if (aLo > bLo) {
                return 1;
            }
            return 0;
        }
    };
    private final Function1<java.lang.Integer, UnsignedInt64Member> SIG = new Function1<java.lang.Integer, UnsignedInt64Member>(){

        @Override
        public java.lang.Integer call(UnsignedInt64Member a) {
            if (a.v == 0L) {
                return 0;
            }
            return 1;
        }
    };
    private final Procedure3<UnsignedInt64Member, UnsignedInt64Member, UnsignedInt64Member> DIV = new Procedure3<UnsignedInt64Member, UnsignedInt64Member, UnsignedInt64Member>(){

        @Override
        public void call(UnsignedInt64Member a, UnsignedInt64Member b, UnsignedInt64Member d) {
            UnsignedInt64Member m = G.UINT64.construct();
            DivMod.compute(G.UINT64, a, b, d, m);
        }
    };
    private final Procedure3<UnsignedInt64Member, UnsignedInt64Member, UnsignedInt64Member> MOD = new Procedure3<UnsignedInt64Member, UnsignedInt64Member, UnsignedInt64Member>(){

        @Override
        public void call(UnsignedInt64Member a, UnsignedInt64Member b, UnsignedInt64Member m) {
            UnsignedInt64Member d = G.UINT64.construct();
            DivMod.compute(G.UINT64, a, b, d, m);
        }
    };
    private final Procedure4<UnsignedInt64Member, UnsignedInt64Member, UnsignedInt64Member, UnsignedInt64Member> DIVMOD = new Procedure4<UnsignedInt64Member, UnsignedInt64Member, UnsignedInt64Member, UnsignedInt64Member>(){

        @Override
        public void call(UnsignedInt64Member a, UnsignedInt64Member b, UnsignedInt64Member d, UnsignedInt64Member m) {
            DivMod.compute(G.UINT64, a, b, d, m);
        }
    };
    private final Procedure3<UnsignedInt64Member, UnsignedInt64Member, UnsignedInt64Member> GCD = new Procedure3<UnsignedInt64Member, UnsignedInt64Member, UnsignedInt64Member>(){

        @Override
        public void call(UnsignedInt64Member a, UnsignedInt64Member b, UnsignedInt64Member c) {
            Gcd.compute(G.UINT64, a, b, c);
        }
    };
    private final Procedure3<UnsignedInt64Member, UnsignedInt64Member, UnsignedInt64Member> LCM = new Procedure3<UnsignedInt64Member, UnsignedInt64Member, UnsignedInt64Member>(){

        @Override
        public void call(UnsignedInt64Member a, UnsignedInt64Member b, UnsignedInt64Member c) {
            Lcm.compute(G.UINT64, a, b, c);
        }
    };
    private final Function1<Boolean, UnsignedInt64Member> EVEN = new Function1<Boolean, UnsignedInt64Member>(){

        @Override
        public Boolean call(UnsignedInt64Member a) {
            return (a.v & 1L) == 0L;
        }
    };
    private final Function1<Boolean, UnsignedInt64Member> ODD = new Function1<Boolean, UnsignedInt64Member>(){

        @Override
        public Boolean call(UnsignedInt64Member a) {
            return (a.v & 1L) == 1L;
        }
    };
    private final Procedure2<UnsignedInt64Member, UnsignedInt64Member> PRED = new Procedure2<UnsignedInt64Member, UnsignedInt64Member>(){

        @Override
        public void call(UnsignedInt64Member a, UnsignedInt64Member b) {
            b.v = a.v == 0L ? -1L : a.v - 1L;
        }
    };
    private final Procedure2<UnsignedInt64Member, UnsignedInt64Member> SUCC = new Procedure2<UnsignedInt64Member, UnsignedInt64Member>(){

        @Override
        public void call(UnsignedInt64Member a, UnsignedInt64Member b) {
            b.v = a.v == -1L ? 0L : a.v + 1L;
        }
    };
    private final Procedure1<UnsignedInt64Member> MAXBOUND = new Procedure1<UnsignedInt64Member>(){

        @Override
        public void call(UnsignedInt64Member a) {
            a.v = -1L;
        }
    };
    private final Procedure1<UnsignedInt64Member> MINBOUND = new Procedure1<UnsignedInt64Member>(){

        @Override
        public void call(UnsignedInt64Member a) {
            a.v = 0L;
        }
    };
    private final Procedure3<UnsignedInt64Member, UnsignedInt64Member, UnsignedInt64Member> BITAND = new Procedure3<UnsignedInt64Member, UnsignedInt64Member, UnsignedInt64Member>(){

        @Override
        public void call(UnsignedInt64Member a, UnsignedInt64Member b, UnsignedInt64Member c) {
            c.v = a.v & b.v;
        }
    };
    private final Procedure3<UnsignedInt64Member, UnsignedInt64Member, UnsignedInt64Member> BITOR = new Procedure3<UnsignedInt64Member, UnsignedInt64Member, UnsignedInt64Member>(){

        @Override
        public void call(UnsignedInt64Member a, UnsignedInt64Member b, UnsignedInt64Member c) {
            c.v = a.v | b.v;
        }
    };
    private final Procedure3<UnsignedInt64Member, UnsignedInt64Member, UnsignedInt64Member> BITXOR = new Procedure3<UnsignedInt64Member, UnsignedInt64Member, UnsignedInt64Member>(){

        @Override
        public void call(UnsignedInt64Member a, UnsignedInt64Member b, UnsignedInt64Member c) {
            c.v = a.v ^ b.v;
        }
    };
    private final Procedure2<UnsignedInt64Member, UnsignedInt64Member> BITNOT = new Procedure2<UnsignedInt64Member, UnsignedInt64Member>(){

        @Override
        public void call(UnsignedInt64Member a, UnsignedInt64Member b) {
            b.v = a.v ^ 0xFFFFFFFFFFFFFFFFL;
        }
    };
    private final Procedure3<UnsignedInt64Member, UnsignedInt64Member, UnsignedInt64Member> BITANDNOT = new Procedure3<UnsignedInt64Member, UnsignedInt64Member, UnsignedInt64Member>(){

        @Override
        public void call(UnsignedInt64Member a, UnsignedInt64Member b, UnsignedInt64Member c) {
            c.v = a.v & (b.v ^ 0xFFFFFFFFFFFFFFFFL);
        }
    };
    private final Procedure3<java.lang.Integer, UnsignedInt64Member, UnsignedInt64Member> BITSHL = new Procedure3<java.lang.Integer, UnsignedInt64Member, UnsignedInt64Member>(){

        @Override
        public void call(java.lang.Integer count, UnsignedInt64Member a, UnsignedInt64Member b) {
            if (count < 0) {
                UnsignedInt64Algebra.this.bitShiftRight().call(-count.intValue(), a, b);
            } else {
                count = count % 64;
                b.v = a.v << count;
            }
        }
    };
    private final Procedure3<java.lang.Integer, UnsignedInt64Member, UnsignedInt64Member> BITSHRZ = new Procedure3<java.lang.Integer, UnsignedInt64Member, UnsignedInt64Member>(){

        @Override
        public void call(java.lang.Integer count, UnsignedInt64Member a, UnsignedInt64Member b) {
            if (count < 0) {
                UnsignedInt64Algebra.this.bitShiftLeft().call(-count.intValue(), a, b);
            } else if (count == 0) {
                b.v = a.v;
            } else {
                long val = (Long.MAX_VALUE & a.v) >> 1;
                if (a.v < 0L) {
                    val |= 0x4000000000000000L;
                }
                b.v = val >> count - 1;
            }
        }
    };
    private final Procedure3<UnsignedInt64Member, UnsignedInt64Member, UnsignedInt64Member> MIN = new Procedure3<UnsignedInt64Member, UnsignedInt64Member, UnsignedInt64Member>(){

        @Override
        public void call(UnsignedInt64Member a, UnsignedInt64Member b, UnsignedInt64Member c) {
            Min.compute(G.UINT64, a, b, c);
        }
    };
    private final Procedure3<UnsignedInt64Member, UnsignedInt64Member, UnsignedInt64Member> MAX = new Procedure3<UnsignedInt64Member, UnsignedInt64Member, UnsignedInt64Member>(){

        @Override
        public void call(UnsignedInt64Member a, UnsignedInt64Member b, UnsignedInt64Member c) {
            Max.compute(G.UINT64, a, b, c);
        }
    };
    private final Procedure1<UnsignedInt64Member> RAND = new Procedure1<UnsignedInt64Member>(){

        @Override
        public void call(UnsignedInt64Member a) {
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            a.v = rng.nextLong();
        }
    };
    private final Procedure3<UnsignedInt64Member, UnsignedInt64Member, UnsignedInt64Member> POW = new Procedure3<UnsignedInt64Member, UnsignedInt64Member, UnsignedInt64Member>(){

        @Override
        public void call(UnsignedInt64Member a, UnsignedInt64Member b, UnsignedInt64Member c) {
            if (UnsignedInt64Algebra.this.signum().call(a) == 0 && UnsignedInt64Algebra.this.signum().call(b) == 0) {
                throw new IllegalArgumentException("0^0 is not a number");
            }
            UnsignedInt64Member tmp = new UnsignedInt64Member(ONE);
            UnsignedInt64Member pow = new UnsignedInt64Member(b);
            while (!UnsignedInt64Algebra.this.isEqual().call(pow, ZERO).booleanValue()) {
                UnsignedInt64Algebra.this.multiply().call(tmp, a, tmp);
                UnsignedInt64Algebra.this.pred().call(pow, pow);
            }
            UnsignedInt64Algebra.this.assign().call(tmp, c);
        }
    };
    private final Function1<Boolean, UnsignedInt64Member> ISZERO = new Function1<Boolean, UnsignedInt64Member>(){

        @Override
        public Boolean call(UnsignedInt64Member a) {
            return a.v == 0L;
        }
    };
    private final Procedure3<HighPrecisionMember, UnsignedInt64Member, UnsignedInt64Member> SBHP = new Procedure3<HighPrecisionMember, UnsignedInt64Member, UnsignedInt64Member>(){

        @Override
        public void call(HighPrecisionMember a, UnsignedInt64Member b, UnsignedInt64Member c) {
            BigDecimal tmp = a.v();
            tmp = tmp.multiply(new BigDecimal(b.v()));
            c.setV(tmp.toBigInteger());
        }
    };
    private final Procedure3<HighPrecisionMember, UnsignedInt64Member, UnsignedInt64Member> SBHPR = new Procedure3<HighPrecisionMember, UnsignedInt64Member, UnsignedInt64Member>(){

        @Override
        public void call(HighPrecisionMember a, UnsignedInt64Member b, UnsignedInt64Member c) {
            BigDecimal tmp = a.v();
            int signum = (tmp = tmp.multiply(new BigDecimal(b.v()))).signum();
            tmp = signum < 0 ? tmp.subtract(G.ONE_HALF) : tmp.add(G.ONE_HALF);
            c.setV(tmp.toBigInteger());
        }
    };
    private final Procedure3<RationalMember, UnsignedInt64Member, UnsignedInt64Member> SBR = new Procedure3<RationalMember, UnsignedInt64Member, UnsignedInt64Member>(){

        @Override
        public void call(RationalMember a, UnsignedInt64Member b, UnsignedInt64Member c) {
            BigInteger tmp = b.v();
            tmp = tmp.multiply(a.n());
            tmp = tmp.divide(a.d());
            c.setV(tmp);
        }
    };
    private final Procedure3<Double, UnsignedInt64Member, UnsignedInt64Member> SBD = new Procedure3<Double, UnsignedInt64Member, UnsignedInt64Member>(){

        @Override
        public void call(Double a, UnsignedInt64Member b, UnsignedInt64Member c) {
            BigDecimal tmp = new BigDecimal(b.v());
            tmp = tmp.multiply(BigDecimal.valueOf(a));
            c.setV(tmp.toBigInteger());
        }
    };
    private final Procedure3<Double, UnsignedInt64Member, UnsignedInt64Member> SBDR = new Procedure3<Double, UnsignedInt64Member, UnsignedInt64Member>(){

        @Override
        public void call(Double a, UnsignedInt64Member b, UnsignedInt64Member c) {
            BigDecimal tmp = new BigDecimal(b.v());
            int signum = (tmp = tmp.multiply(BigDecimal.valueOf(a))).signum();
            tmp = signum < 0 ? tmp.subtract(G.ONE_HALF) : tmp.add(G.ONE_HALF);
            c.setV(tmp.toBigInteger());
        }
    };
    private final Function3<Boolean, UnsignedInt64Member, UnsignedInt64Member, UnsignedInt64Member> WITHIN = new Function3<Boolean, UnsignedInt64Member, UnsignedInt64Member, UnsignedInt64Member>(){

        @Override
        public Boolean call(UnsignedInt64Member tol, UnsignedInt64Member a, UnsignedInt64Member b) {
            return NumberWithin.compute(G.UINT64, tol, a, b);
        }
    };

    @Override
    public Function2<Boolean, UnsignedInt64Member, UnsignedInt64Member> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, UnsignedInt64Member, UnsignedInt64Member> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public UnsignedInt64Member construct() {
        return new UnsignedInt64Member();
    }

    @Override
    public UnsignedInt64Member construct(UnsignedInt64Member other) {
        return new UnsignedInt64Member(other);
    }

    @Override
    public UnsignedInt64Member construct(String s) {
        return new UnsignedInt64Member(s);
    }

    @Override
    public Procedure2<UnsignedInt64Member, UnsignedInt64Member> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure2<UnsignedInt64Member, UnsignedInt64Member> abs() {
        return this.ASSIGN;
    }

    @Override
    public Procedure3<UnsignedInt64Member, UnsignedInt64Member, UnsignedInt64Member> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt64Member, UnsignedInt64Member> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<UnsignedInt64Member> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<UnsignedInt64Member, UnsignedInt64Member> negate() {
        return this.ASSIGN;
    }

    @Override
    public Procedure3<UnsignedInt64Member, UnsignedInt64Member, UnsignedInt64Member> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<UnsignedInt64Member, UnsignedInt64Member, UnsignedInt64Member> subtract() {
        return this.SUB;
    }

    @Override
    public Procedure1<UnsignedInt64Member> unity() {
        return this.UNITY;
    }

    @Override
    public Function2<Boolean, UnsignedInt64Member, UnsignedInt64Member> isLess() {
        return this.LESS;
    }

    @Override
    public Function2<Boolean, UnsignedInt64Member, UnsignedInt64Member> isLessEqual() {
        return this.LE;
    }

    @Override
    public Function2<Boolean, UnsignedInt64Member, UnsignedInt64Member> isGreater() {
        return this.GREAT;
    }

    @Override
    public Function2<Boolean, UnsignedInt64Member, UnsignedInt64Member> isGreaterEqual() {
        return this.GE;
    }

    @Override
    public Function2<java.lang.Integer, UnsignedInt64Member, UnsignedInt64Member> compare() {
        return this.CMP;
    }

    @Override
    public Function1<java.lang.Integer, UnsignedInt64Member> signum() {
        return this.SIG;
    }

    @Override
    public Procedure3<UnsignedInt64Member, UnsignedInt64Member, UnsignedInt64Member> div() {
        return this.DIV;
    }

    @Override
    public Procedure3<UnsignedInt64Member, UnsignedInt64Member, UnsignedInt64Member> mod() {
        return this.MOD;
    }

    @Override
    public Procedure4<UnsignedInt64Member, UnsignedInt64Member, UnsignedInt64Member, UnsignedInt64Member> divMod() {
        return this.DIVMOD;
    }

    @Override
    public Procedure3<UnsignedInt64Member, UnsignedInt64Member, UnsignedInt64Member> gcd() {
        return this.GCD;
    }

    @Override
    public Procedure3<UnsignedInt64Member, UnsignedInt64Member, UnsignedInt64Member> lcm() {
        return this.LCM;
    }

    @Override
    public Procedure2<UnsignedInt64Member, UnsignedInt64Member> norm() {
        return this.ASSIGN;
    }

    @Override
    public Function1<Boolean, UnsignedInt64Member> isEven() {
        return this.EVEN;
    }

    @Override
    public Function1<Boolean, UnsignedInt64Member> isOdd() {
        return this.ODD;
    }

    @Override
    public Procedure2<UnsignedInt64Member, UnsignedInt64Member> pred() {
        return this.PRED;
    }

    @Override
    public Procedure2<UnsignedInt64Member, UnsignedInt64Member> succ() {
        return this.SUCC;
    }

    @Override
    public Procedure1<UnsignedInt64Member> maxBound() {
        return this.MAXBOUND;
    }

    @Override
    public Procedure1<UnsignedInt64Member> minBound() {
        return this.MINBOUND;
    }

    @Override
    public Procedure3<UnsignedInt64Member, UnsignedInt64Member, UnsignedInt64Member> bitAnd() {
        return this.BITAND;
    }

    @Override
    public Procedure3<UnsignedInt64Member, UnsignedInt64Member, UnsignedInt64Member> bitOr() {
        return this.BITOR;
    }

    @Override
    public Procedure3<UnsignedInt64Member, UnsignedInt64Member, UnsignedInt64Member> bitXor() {
        return this.BITXOR;
    }

    @Override
    public Procedure2<UnsignedInt64Member, UnsignedInt64Member> bitNot() {
        return this.BITNOT;
    }

    @Override
    public Procedure3<UnsignedInt64Member, UnsignedInt64Member, UnsignedInt64Member> bitAndNot() {
        return this.BITANDNOT;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt64Member, UnsignedInt64Member> bitShiftLeft() {
        return this.BITSHL;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt64Member, UnsignedInt64Member> bitShiftRight() {
        return this.BITSHRZ;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt64Member, UnsignedInt64Member> bitShiftRightFillZero() {
        return this.BITSHRZ;
    }

    @Override
    public Procedure3<UnsignedInt64Member, UnsignedInt64Member, UnsignedInt64Member> min() {
        return this.MIN;
    }

    @Override
    public Procedure3<UnsignedInt64Member, UnsignedInt64Member, UnsignedInt64Member> max() {
        return this.MAX;
    }

    @Override
    public Procedure1<UnsignedInt64Member> random() {
        return this.RAND;
    }

    @Override
    public Procedure3<UnsignedInt64Member, UnsignedInt64Member, UnsignedInt64Member> pow() {
        return this.POW;
    }

    @Override
    public Function1<Boolean, UnsignedInt64Member> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<UnsignedInt64Member, UnsignedInt64Member, UnsignedInt64Member> scale() {
        return this.MUL;
    }

    @Override
    public Procedure3<HighPrecisionMember, UnsignedInt64Member, UnsignedInt64Member> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<HighPrecisionMember, UnsignedInt64Member, UnsignedInt64Member> scaleByHighPrecAndRound() {
        return this.SBHPR;
    }

    @Override
    public Procedure3<RationalMember, UnsignedInt64Member, UnsignedInt64Member> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, UnsignedInt64Member, UnsignedInt64Member> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<Double, UnsignedInt64Member, UnsignedInt64Member> scaleByDoubleAndRound() {
        return this.SBDR;
    }

    @Override
    public Function3<Boolean, UnsignedInt64Member, UnsignedInt64Member, UnsignedInt64Member> within() {
        return this.WITHIN;
    }
}

