/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.int64;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigDecimal;
import java.math.BigInteger;
import nom.bdezonia.zorbage.sampling.IntegerIndex;
import nom.bdezonia.zorbage.type.algebra.GetReal;
import nom.bdezonia.zorbage.type.algebra.Gettable;
import nom.bdezonia.zorbage.type.algebra.HighPrecRepresentation;
import nom.bdezonia.zorbage.type.algebra.NumberMember;
import nom.bdezonia.zorbage.type.algebra.SetReal;
import nom.bdezonia.zorbage.type.algebra.Settable;
import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.ctor.Duplicatable;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.unbounded.UnboundedIntMember;
import nom.bdezonia.zorbage.type.data.universal.OctonionRepresentation;
import nom.bdezonia.zorbage.type.data.universal.PrimitiveConversion;
import nom.bdezonia.zorbage.type.data.universal.PrimitiveRepresentation;
import nom.bdezonia.zorbage.type.data.universal.TensorOctonionRepresentation;
import nom.bdezonia.zorbage.type.data.universal.TensorStringRepresentation;
import nom.bdezonia.zorbage.type.data.universal.UniversalRepresentation;
import nom.bdezonia.zorbage.type.storage.coder.LongCoder;

public final class UnsignedInt64Member
implements LongCoder,
Allocatable<UnsignedInt64Member>,
Duplicatable<UnsignedInt64Member>,
Settable<UnsignedInt64Member>,
Gettable<UnsignedInt64Member>,
UniversalRepresentation,
NumberMember<UnsignedInt64Member>,
PrimitiveConversion,
HighPrecRepresentation,
SetReal<BigInteger>,
GetReal<UnboundedIntMember> {
    private static final BigInteger UPPER = new BigInteger("8000000000000000", 16);
    long v;

    public UnsignedInt64Member() {
        this.v = 0L;
    }

    public UnsignedInt64Member(BigInteger value) {
        this.setV(value);
    }

    public UnsignedInt64Member(UnsignedInt64Member value) {
        this.set(value);
    }

    public UnsignedInt64Member(String value) {
        TensorStringRepresentation rep = new TensorStringRepresentation(value);
        OctonionRepresentation val = rep.firstValue();
        this.v = val.r().longValue();
    }

    public BigInteger v() {
        BigInteger lower = BigInteger.valueOf(this.v & Long.MAX_VALUE);
        BigInteger upper = this.v < 0L ? UPPER : BigInteger.ZERO;
        return lower.add(upper);
    }

    @Override
    public void setV(BigInteger val) {
        this.v = val.longValue();
    }

    @Override
    public void set(UnsignedInt64Member other) {
        this.v = other.v;
    }

    @Override
    public void get(UnsignedInt64Member other) {
        other.v = this.v;
    }

    public String toString() {
        return String.valueOf(this.v());
    }

    @Override
    public int longCount() {
        return 1;
    }

    @Override
    public void fromLongArray(long[] arr, int index) {
        this.v = arr[index];
    }

    @Override
    public void toLongArray(long[] arr, int index) {
        arr[index] = this.v;
    }

    @Override
    public void fromLongFile(RandomAccessFile raf) throws IOException {
        this.v = raf.readLong();
    }

    @Override
    public void toLongFile(RandomAccessFile raf) throws IOException {
        raf.writeLong(this.v);
    }

    @Override
    public UnsignedInt64Member allocate() {
        return new UnsignedInt64Member();
    }

    @Override
    public UnsignedInt64Member duplicate() {
        return new UnsignedInt64Member(this);
    }

    @Override
    public void toRep(TensorOctonionRepresentation rep) {
        rep.setValue(new OctonionRepresentation(new BigDecimal(this.v())));
    }

    @Override
    public void fromRep(TensorOctonionRepresentation rep) {
        this.v = rep.getValue().r().longValue();
    }

    @Override
    public int numDimensions() {
        return 0;
    }

    @Override
    public void v(UnsignedInt64Member value) {
        this.get(value);
    }

    @Override
    public void setV(UnsignedInt64Member value) {
        this.set(value);
    }

    @Override
    public PrimitiveRepresentation preferredRepresentation() {
        return PrimitiveRepresentation.BIGINTEGER;
    }

    @Override
    public long dimension(int i) {
        return 0L;
    }

    @Override
    public int componentCount() {
        return 1;
    }

    @Override
    public void primComponentSetByte(IntegerIndex index, int component, byte v) {
        this.v = v & 0xFF;
    }

    @Override
    public void primComponentSetShort(IntegerIndex index, int component, short v) {
        this.v = v & 0xFFFF;
    }

    @Override
    public void primComponentSetInt(IntegerIndex index, int component, int v) {
        this.v = v & 0xFFFFFFFF;
    }

    @Override
    public void primComponentSetLong(IntegerIndex index, int component, long v) {
        this.v = v;
    }

    @Override
    public void primComponentSetFloat(IntegerIndex index, int component, float v) {
        this.v = (long)v;
    }

    @Override
    public void primComponentSetDouble(IntegerIndex index, int component, double v) {
        this.v = (long)v;
    }

    @Override
    public void primComponentSetBigInteger(IntegerIndex index, int component, BigInteger v) {
        this.setV(v);
    }

    @Override
    public void primComponentSetBigDecimal(IntegerIndex index, int component, BigDecimal v) {
        this.setV(v.toBigInteger());
    }

    @Override
    public void primComponentSetByteSafe(IntegerIndex index, int component, byte v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            this.v = v;
        }
    }

    @Override
    public void primComponentSetShortSafe(IntegerIndex index, int component, short v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            this.v = v;
        }
    }

    @Override
    public void primComponentSetIntSafe(IntegerIndex index, int component, int v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            this.v = v;
        }
    }

    @Override
    public void primComponentSetLongSafe(IntegerIndex index, int component, long v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0L) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            this.v = v;
        }
    }

    @Override
    public void primComponentSetFloatSafe(IntegerIndex index, int component, float v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0.0f) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            this.v = (long)v;
        }
    }

    @Override
    public void primComponentSetDoubleSafe(IntegerIndex index, int component, double v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0.0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            this.v = (long)v;
        }
    }

    @Override
    public void primComponentSetBigIntegerSafe(IntegerIndex index, int component, BigInteger v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v.signum() != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            this.setV(v);
        }
    }

    @Override
    public void primComponentSetBigDecimalSafe(IntegerIndex index, int component, BigDecimal v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v.signum() != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            this.setV(v.toBigInteger());
        }
    }

    @Override
    public byte primComponentGetAsByte(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            return this.v().byteValue();
        }
        return 0;
    }

    @Override
    public short primComponentGetAsShort(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            return this.v().shortValue();
        }
        return 0;
    }

    @Override
    public int primComponentGetAsInt(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            return this.v().intValue();
        }
        return 0;
    }

    @Override
    public long primComponentGetAsLong(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            return this.v().longValue();
        }
        return 0L;
    }

    @Override
    public float primComponentGetAsFloat(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            return this.v().floatValue();
        }
        return 0.0f;
    }

    @Override
    public double primComponentGetAsDouble(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            return this.v().doubleValue();
        }
        return 0.0;
    }

    @Override
    public BigInteger primComponentGetAsBigInteger(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            return this.v();
        }
        return BigInteger.ZERO;
    }

    @Override
    public BigDecimal primComponentGetAsBigDecimal(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            return new BigDecimal(this.v());
        }
        return BigDecimal.ZERO;
    }

    @Override
    public byte primComponentGetAsByteSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0;
        }
        return this.v().byteValue();
    }

    @Override
    public short primComponentGetAsShortSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0;
        }
        return this.v().shortValue();
    }

    @Override
    public int primComponentGetAsIntSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0;
        }
        return this.v().intValue();
    }

    @Override
    public long primComponentGetAsLongSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0L;
        }
        return this.v().longValue();
    }

    @Override
    public float primComponentGetAsFloatSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0.0f;
        }
        return this.v().floatValue();
    }

    @Override
    public double primComponentGetAsDoubleSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0.0;
        }
        return this.v().doubleValue();
    }

    @Override
    public BigInteger primComponentGetAsBigIntegerSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return BigInteger.ZERO;
        }
        return this.v();
    }

    @Override
    public BigDecimal primComponentGetAsBigDecimalSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(this.v());
    }

    @Override
    public void primitiveInit() {
        this.v = 0L;
    }

    @Override
    public void toHighPrec(HighPrecisionMember result) {
        result.setV(new BigDecimal(this.v()));
    }

    @Override
    public void fromHighPrec(HighPrecisionMember input) {
        this.setV(input.v().toBigInteger());
    }

    @Override
    public void setR(BigInteger val) {
        this.setV(val);
    }

    @Override
    public void getR(UnboundedIntMember val) {
        val.setV(this.v());
    }
}

