/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.int7;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.ThreadLocalRandom;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.Gcd;
import nom.bdezonia.zorbage.algorithm.Lcm;
import nom.bdezonia.zorbage.algorithm.NumberWithin;
import nom.bdezonia.zorbage.algorithm.PowerNonNegative;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.BitOperations;
import nom.bdezonia.zorbage.type.algebra.Bounded;
import nom.bdezonia.zorbage.type.algebra.Integer;
import nom.bdezonia.zorbage.type.algebra.Random;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.int7.SignedInt7Member;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class SignedInt7Algebra
implements Integer<SignedInt7Algebra, SignedInt7Member>,
Bounded<SignedInt7Member>,
BitOperations<SignedInt7Member>,
Random<SignedInt7Member>,
Tolerance<SignedInt7Member, SignedInt7Member> {
    private final Function2<Boolean, SignedInt7Member, SignedInt7Member> EQ = new Function2<Boolean, SignedInt7Member, SignedInt7Member>(){

        @Override
        public Boolean call(SignedInt7Member a, SignedInt7Member b) {
            return a.v == b.v;
        }
    };
    private final Function2<Boolean, SignedInt7Member, SignedInt7Member> NEQ = new Function2<Boolean, SignedInt7Member, SignedInt7Member>(){

        @Override
        public Boolean call(SignedInt7Member a, SignedInt7Member b) {
            return a.v != b.v;
        }
    };
    private final Procedure2<SignedInt7Member, SignedInt7Member> ASSIGN = new Procedure2<SignedInt7Member, SignedInt7Member>(){

        @Override
        public void call(SignedInt7Member a, SignedInt7Member b) {
            b.set(a);
        }
    };
    private final Procedure1<SignedInt7Member> ZER = new Procedure1<SignedInt7Member>(){

        @Override
        public void call(SignedInt7Member a) {
            a.v = 0;
        }
    };
    private final Procedure2<SignedInt7Member, SignedInt7Member> NEG = new Procedure2<SignedInt7Member, SignedInt7Member>(){

        @Override
        public void call(SignedInt7Member a, SignedInt7Member b) {
            if (a.v == -64) {
                throw new IllegalArgumentException("Cannot convert -minint symmetrically");
            }
            b.v = -a.v;
        }
    };
    private final Procedure3<SignedInt7Member, SignedInt7Member, SignedInt7Member> ADD = new Procedure3<SignedInt7Member, SignedInt7Member, SignedInt7Member>(){

        @Override
        public void call(SignedInt7Member a, SignedInt7Member b, SignedInt7Member c) {
            c.setV(a.v + b.v);
        }
    };
    private final Procedure3<SignedInt7Member, SignedInt7Member, SignedInt7Member> SUB = new Procedure3<SignedInt7Member, SignedInt7Member, SignedInt7Member>(){

        @Override
        public void call(SignedInt7Member a, SignedInt7Member b, SignedInt7Member c) {
            c.setV(a.v - b.v);
        }
    };
    private final Procedure3<SignedInt7Member, SignedInt7Member, SignedInt7Member> MUL = new Procedure3<SignedInt7Member, SignedInt7Member, SignedInt7Member>(){

        @Override
        public void call(SignedInt7Member a, SignedInt7Member b, SignedInt7Member c) {
            c.setV(a.v * b.v);
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt7Member, SignedInt7Member> POWER = new Procedure3<java.lang.Integer, SignedInt7Member, SignedInt7Member>(){

        @Override
        public void call(java.lang.Integer power, SignedInt7Member a, SignedInt7Member b) {
            PowerNonNegative.compute(G.INT7, power, a, b);
        }
    };
    private final Procedure1<SignedInt7Member> UNITY = new Procedure1<SignedInt7Member>(){

        @Override
        public void call(SignedInt7Member a) {
            a.v = 1;
        }
    };
    private final Function2<Boolean, SignedInt7Member, SignedInt7Member> LESS = new Function2<Boolean, SignedInt7Member, SignedInt7Member>(){

        @Override
        public Boolean call(SignedInt7Member a, SignedInt7Member b) {
            return a.v < b.v;
        }
    };
    private final Function2<Boolean, SignedInt7Member, SignedInt7Member> LE = new Function2<Boolean, SignedInt7Member, SignedInt7Member>(){

        @Override
        public Boolean call(SignedInt7Member a, SignedInt7Member b) {
            return a.v <= b.v;
        }
    };
    private final Function2<Boolean, SignedInt7Member, SignedInt7Member> GREAT = new Function2<Boolean, SignedInt7Member, SignedInt7Member>(){

        @Override
        public Boolean call(SignedInt7Member a, SignedInt7Member b) {
            return a.v > b.v;
        }
    };
    private final Function2<Boolean, SignedInt7Member, SignedInt7Member> GE = new Function2<Boolean, SignedInt7Member, SignedInt7Member>(){

        @Override
        public Boolean call(SignedInt7Member a, SignedInt7Member b) {
            return a.v >= b.v;
        }
    };
    private final Function2<java.lang.Integer, SignedInt7Member, SignedInt7Member> CMP = new Function2<java.lang.Integer, SignedInt7Member, SignedInt7Member>(){

        @Override
        public java.lang.Integer call(SignedInt7Member a, SignedInt7Member b) {
            if (a.v < b.v) {
                return -1;
            }
            if (a.v > b.v) {
                return 1;
            }
            return 0;
        }
    };
    private final Function1<java.lang.Integer, SignedInt7Member> SIG = new Function1<java.lang.Integer, SignedInt7Member>(){

        @Override
        public java.lang.Integer call(SignedInt7Member a) {
            if (a.v < 0) {
                return -1;
            }
            if (a.v > 0) {
                return 1;
            }
            return 0;
        }
    };
    private final Procedure3<SignedInt7Member, SignedInt7Member, SignedInt7Member> MIN = new Procedure3<SignedInt7Member, SignedInt7Member, SignedInt7Member>(){

        @Override
        public void call(SignedInt7Member a, SignedInt7Member b, SignedInt7Member c) {
            if (a.v < b.v) {
                c.set(a);
            } else {
                c.set(b);
            }
        }
    };
    private final Procedure3<SignedInt7Member, SignedInt7Member, SignedInt7Member> MAX = new Procedure3<SignedInt7Member, SignedInt7Member, SignedInt7Member>(){

        @Override
        public void call(SignedInt7Member a, SignedInt7Member b, SignedInt7Member c) {
            if (a.v > b.v) {
                c.set(a);
            } else {
                c.set(b);
            }
        }
    };
    private final Procedure2<SignedInt7Member, SignedInt7Member> ABS = new Procedure2<SignedInt7Member, SignedInt7Member>(){

        @Override
        public void call(SignedInt7Member a, SignedInt7Member b) {
            if (a.v == -64) {
                throw new IllegalArgumentException("Cannot convert -minint symmetrically");
            }
            b.v = a.v < 0 ? (byte)(-a.v) : a.v;
        }
    };
    private final Procedure3<SignedInt7Member, SignedInt7Member, SignedInt7Member> GCD = new Procedure3<SignedInt7Member, SignedInt7Member, SignedInt7Member>(){

        @Override
        public void call(SignedInt7Member a, SignedInt7Member b, SignedInt7Member c) {
            Gcd.compute(G.INT7, a, b, c);
        }
    };
    private final Procedure3<SignedInt7Member, SignedInt7Member, SignedInt7Member> LCM = new Procedure3<SignedInt7Member, SignedInt7Member, SignedInt7Member>(){

        @Override
        public void call(SignedInt7Member a, SignedInt7Member b, SignedInt7Member c) {
            Lcm.compute(G.INT7, a, b, c);
        }
    };
    private final Function1<Boolean, SignedInt7Member> EVEN = new Function1<Boolean, SignedInt7Member>(){

        @Override
        public Boolean call(SignedInt7Member a) {
            return (a.v & 1) == 0;
        }
    };
    private final Function1<Boolean, SignedInt7Member> ODD = new Function1<Boolean, SignedInt7Member>(){

        @Override
        public Boolean call(SignedInt7Member a) {
            return (a.v & 1) == 1;
        }
    };
    private final Procedure3<SignedInt7Member, SignedInt7Member, SignedInt7Member> DIV = new Procedure3<SignedInt7Member, SignedInt7Member, SignedInt7Member>(){

        @Override
        public void call(SignedInt7Member a, SignedInt7Member b, SignedInt7Member d) {
            if (b.v == -1 && a.v == -64) {
                throw new IllegalArgumentException("cannot divide minint by -1");
            }
            d.setV(a.v / b.v);
        }
    };
    private final Procedure3<SignedInt7Member, SignedInt7Member, SignedInt7Member> MOD = new Procedure3<SignedInt7Member, SignedInt7Member, SignedInt7Member>(){

        @Override
        public void call(SignedInt7Member a, SignedInt7Member b, SignedInt7Member m) {
            m.setV(a.v % b.v);
        }
    };
    private final Procedure4<SignedInt7Member, SignedInt7Member, SignedInt7Member, SignedInt7Member> DIVMOD = new Procedure4<SignedInt7Member, SignedInt7Member, SignedInt7Member, SignedInt7Member>(){

        @Override
        public void call(SignedInt7Member a, SignedInt7Member b, SignedInt7Member d, SignedInt7Member m) {
            SignedInt7Algebra.this.div().call(a, b, d);
            SignedInt7Algebra.this.mod().call(a, b, m);
        }
    };
    private final Procedure2<SignedInt7Member, SignedInt7Member> PRED = new Procedure2<SignedInt7Member, SignedInt7Member>(){

        @Override
        public void call(SignedInt7Member a, SignedInt7Member b) {
            if (a.v == -64) {
                b.v = (byte)63;
            } else {
                b.setV(a.v - 1);
            }
        }
    };
    private final Procedure2<SignedInt7Member, SignedInt7Member> SUCC = new Procedure2<SignedInt7Member, SignedInt7Member>(){

        @Override
        public void call(SignedInt7Member a, SignedInt7Member b) {
            if (a.v == 63) {
                b.v = (byte)-64;
            } else {
                b.setV(a.v + 1);
            }
        }
    };
    private final Procedure3<SignedInt7Member, SignedInt7Member, SignedInt7Member> POW = new Procedure3<SignedInt7Member, SignedInt7Member, SignedInt7Member>(){

        @Override
        public void call(SignedInt7Member a, SignedInt7Member b, SignedInt7Member c) {
            PowerNonNegative.compute(G.INT7, b.v, a, c);
        }
    };
    private final Procedure1<SignedInt7Member> RAND = new Procedure1<SignedInt7Member>(){

        @Override
        public void call(SignedInt7Member a) {
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            a.setV(rng.nextInt(128) - 64);
        }
    };
    private final Procedure3<SignedInt7Member, SignedInt7Member, SignedInt7Member> AND = new Procedure3<SignedInt7Member, SignedInt7Member, SignedInt7Member>(){

        @Override
        public void call(SignedInt7Member a, SignedInt7Member b, SignedInt7Member c) {
            c.setV(a.v & b.v);
        }
    };
    private final Procedure3<SignedInt7Member, SignedInt7Member, SignedInt7Member> OR = new Procedure3<SignedInt7Member, SignedInt7Member, SignedInt7Member>(){

        @Override
        public void call(SignedInt7Member a, SignedInt7Member b, SignedInt7Member c) {
            c.setV(a.v | b.v);
        }
    };
    private final Procedure3<SignedInt7Member, SignedInt7Member, SignedInt7Member> XOR = new Procedure3<SignedInt7Member, SignedInt7Member, SignedInt7Member>(){

        @Override
        public void call(SignedInt7Member a, SignedInt7Member b, SignedInt7Member c) {
            c.setV(a.v ^ b.v);
        }
    };
    private final Procedure2<SignedInt7Member, SignedInt7Member> NOT = new Procedure2<SignedInt7Member, SignedInt7Member>(){

        @Override
        public void call(SignedInt7Member a, SignedInt7Member b) {
            b.setV(~a.v);
        }
    };
    private final Procedure3<SignedInt7Member, SignedInt7Member, SignedInt7Member> ANDNOT = new Procedure3<SignedInt7Member, SignedInt7Member, SignedInt7Member>(){

        @Override
        public void call(SignedInt7Member a, SignedInt7Member b, SignedInt7Member c) {
            c.setV(a.v & ~b.v);
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt7Member, SignedInt7Member> SHL = new Procedure3<java.lang.Integer, SignedInt7Member, SignedInt7Member>(){

        @Override
        public void call(java.lang.Integer count, SignedInt7Member a, SignedInt7Member b) {
            if (count < 0) {
                SignedInt7Algebra.this.bitShiftRight().call(-count.intValue(), a, b);
            } else {
                count = count % 7;
                b.setV(a.v << count);
            }
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt7Member, SignedInt7Member> SHR = new Procedure3<java.lang.Integer, SignedInt7Member, SignedInt7Member>(){

        @Override
        public void call(java.lang.Integer count, SignedInt7Member a, SignedInt7Member b) {
            if (count < 0) {
                SignedInt7Algebra.this.bitShiftLeft().call(-count.intValue(), a, b);
            } else {
                int val = a.v >> count;
                if (a.v < 0 && val == 0) {
                    b.v = (byte)-1;
                } else {
                    b.setV(val);
                }
            }
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt7Member, SignedInt7Member> SHRZ = new Procedure3<java.lang.Integer, SignedInt7Member, SignedInt7Member>(){

        @Override
        public void call(java.lang.Integer count, SignedInt7Member a, SignedInt7Member b) {
            if (count < 0) {
                SignedInt7Algebra.this.bitShiftLeft().call(-count.intValue(), a, b);
            } else {
                b.setV(a.v >>> count);
            }
        }
    };
    private final Procedure1<SignedInt7Member> MAXBOUND = new Procedure1<SignedInt7Member>(){

        @Override
        public void call(SignedInt7Member a) {
            a.v = (byte)63;
        }
    };
    private final Procedure1<SignedInt7Member> MINBOUND = new Procedure1<SignedInt7Member>(){

        @Override
        public void call(SignedInt7Member a) {
            a.v = (byte)-64;
        }
    };
    private final Function1<Boolean, SignedInt7Member> ISZERO = new Function1<Boolean, SignedInt7Member>(){

        @Override
        public Boolean call(SignedInt7Member a) {
            return a.v == 0;
        }
    };
    private final Procedure3<HighPrecisionMember, SignedInt7Member, SignedInt7Member> SBHP = new Procedure3<HighPrecisionMember, SignedInt7Member, SignedInt7Member>(){

        @Override
        public void call(HighPrecisionMember a, SignedInt7Member b, SignedInt7Member c) {
            BigDecimal tmp = a.v();
            tmp = tmp.multiply(new BigDecimal(b.v()));
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<HighPrecisionMember, SignedInt7Member, SignedInt7Member> SBHPR = new Procedure3<HighPrecisionMember, SignedInt7Member, SignedInt7Member>(){

        @Override
        public void call(HighPrecisionMember a, SignedInt7Member b, SignedInt7Member c) {
            BigDecimal tmp = a.v();
            int signum = (tmp = tmp.multiply(new BigDecimal(b.v()))).signum();
            tmp = signum < 0 ? tmp.subtract(G.ONE_HALF) : tmp.add(G.ONE_HALF);
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<RationalMember, SignedInt7Member, SignedInt7Member> SBR = new Procedure3<RationalMember, SignedInt7Member, SignedInt7Member>(){

        @Override
        public void call(RationalMember a, SignedInt7Member b, SignedInt7Member c) {
            BigInteger tmp = BigInteger.valueOf(b.v());
            tmp = tmp.multiply(a.n());
            tmp = tmp.divide(a.d());
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<Double, SignedInt7Member, SignedInt7Member> SBD = new Procedure3<Double, SignedInt7Member, SignedInt7Member>(){

        @Override
        public void call(Double a, SignedInt7Member b, SignedInt7Member c) {
            c.setV((int)(a * (double)b.v()));
        }
    };
    private final Procedure3<Double, SignedInt7Member, SignedInt7Member> SBDR = new Procedure3<Double, SignedInt7Member, SignedInt7Member>(){

        @Override
        public void call(Double a, SignedInt7Member b, SignedInt7Member c) {
            c.setV((int)Math.round(a * (double)b.v()));
        }
    };
    private final Function3<Boolean, SignedInt7Member, SignedInt7Member, SignedInt7Member> WITHIN = new Function3<Boolean, SignedInt7Member, SignedInt7Member, SignedInt7Member>(){

        @Override
        public Boolean call(SignedInt7Member tol, SignedInt7Member a, SignedInt7Member b) {
            return NumberWithin.compute(G.INT7, tol, a, b);
        }
    };

    @Override
    public SignedInt7Member construct() {
        return new SignedInt7Member();
    }

    @Override
    public SignedInt7Member construct(SignedInt7Member other) {
        return new SignedInt7Member(other);
    }

    @Override
    public SignedInt7Member construct(String str) {
        return new SignedInt7Member(str);
    }

    @Override
    public Function2<Boolean, SignedInt7Member, SignedInt7Member> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, SignedInt7Member, SignedInt7Member> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<SignedInt7Member, SignedInt7Member> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure1<SignedInt7Member> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<SignedInt7Member, SignedInt7Member> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<SignedInt7Member, SignedInt7Member, SignedInt7Member> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<SignedInt7Member, SignedInt7Member, SignedInt7Member> subtract() {
        return this.SUB;
    }

    @Override
    public Procedure3<SignedInt7Member, SignedInt7Member, SignedInt7Member> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt7Member, SignedInt7Member> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<SignedInt7Member> unity() {
        return this.UNITY;
    }

    @Override
    public Function2<Boolean, SignedInt7Member, SignedInt7Member> isLess() {
        return this.LESS;
    }

    @Override
    public Function2<Boolean, SignedInt7Member, SignedInt7Member> isLessEqual() {
        return this.LE;
    }

    @Override
    public Function2<Boolean, SignedInt7Member, SignedInt7Member> isGreater() {
        return this.GREAT;
    }

    @Override
    public Function2<Boolean, SignedInt7Member, SignedInt7Member> isGreaterEqual() {
        return this.GE;
    }

    @Override
    public Function2<java.lang.Integer, SignedInt7Member, SignedInt7Member> compare() {
        return this.CMP;
    }

    @Override
    public Function1<java.lang.Integer, SignedInt7Member> signum() {
        return this.SIG;
    }

    @Override
    public Procedure3<SignedInt7Member, SignedInt7Member, SignedInt7Member> min() {
        return this.MIN;
    }

    @Override
    public Procedure3<SignedInt7Member, SignedInt7Member, SignedInt7Member> max() {
        return this.MAX;
    }

    @Override
    public Procedure2<SignedInt7Member, SignedInt7Member> abs() {
        return this.ABS;
    }

    @Override
    public Procedure2<SignedInt7Member, SignedInt7Member> norm() {
        return this.ABS;
    }

    @Override
    public Procedure3<SignedInt7Member, SignedInt7Member, SignedInt7Member> gcd() {
        return this.GCD;
    }

    @Override
    public Procedure3<SignedInt7Member, SignedInt7Member, SignedInt7Member> lcm() {
        return this.LCM;
    }

    @Override
    public Function1<Boolean, SignedInt7Member> isEven() {
        return this.EVEN;
    }

    @Override
    public Function1<Boolean, SignedInt7Member> isOdd() {
        return this.ODD;
    }

    @Override
    public Procedure3<SignedInt7Member, SignedInt7Member, SignedInt7Member> div() {
        return this.DIV;
    }

    @Override
    public Procedure3<SignedInt7Member, SignedInt7Member, SignedInt7Member> mod() {
        return this.MOD;
    }

    @Override
    public Procedure4<SignedInt7Member, SignedInt7Member, SignedInt7Member, SignedInt7Member> divMod() {
        return this.DIVMOD;
    }

    @Override
    public Procedure2<SignedInt7Member, SignedInt7Member> pred() {
        return this.PRED;
    }

    @Override
    public Procedure2<SignedInt7Member, SignedInt7Member> succ() {
        return this.SUCC;
    }

    @Override
    public Procedure3<SignedInt7Member, SignedInt7Member, SignedInt7Member> pow() {
        return this.POW;
    }

    @Override
    public Procedure1<SignedInt7Member> random() {
        return this.RAND;
    }

    @Override
    public Procedure3<SignedInt7Member, SignedInt7Member, SignedInt7Member> bitAnd() {
        return this.AND;
    }

    @Override
    public Procedure3<SignedInt7Member, SignedInt7Member, SignedInt7Member> bitOr() {
        return this.OR;
    }

    @Override
    public Procedure3<SignedInt7Member, SignedInt7Member, SignedInt7Member> bitXor() {
        return this.XOR;
    }

    @Override
    public Procedure2<SignedInt7Member, SignedInt7Member> bitNot() {
        return this.NOT;
    }

    @Override
    public Procedure3<SignedInt7Member, SignedInt7Member, SignedInt7Member> bitAndNot() {
        return this.ANDNOT;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt7Member, SignedInt7Member> bitShiftLeft() {
        return this.SHL;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt7Member, SignedInt7Member> bitShiftRight() {
        return this.SHR;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt7Member, SignedInt7Member> bitShiftRightFillZero() {
        return this.SHRZ;
    }

    @Override
    public Procedure1<SignedInt7Member> maxBound() {
        return this.MAXBOUND;
    }

    @Override
    public Procedure1<SignedInt7Member> minBound() {
        return this.MINBOUND;
    }

    @Override
    public Function1<Boolean, SignedInt7Member> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<SignedInt7Member, SignedInt7Member, SignedInt7Member> scale() {
        return this.MUL;
    }

    @Override
    public Procedure3<HighPrecisionMember, SignedInt7Member, SignedInt7Member> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<HighPrecisionMember, SignedInt7Member, SignedInt7Member> scaleByHighPrecAndRound() {
        return this.SBHPR;
    }

    @Override
    public Procedure3<RationalMember, SignedInt7Member, SignedInt7Member> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, SignedInt7Member, SignedInt7Member> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<Double, SignedInt7Member, SignedInt7Member> scaleByDoubleAndRound() {
        return this.SBDR;
    }

    @Override
    public Function3<Boolean, SignedInt7Member, SignedInt7Member, SignedInt7Member> within() {
        return this.WITHIN;
    }
}

