/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.int7;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.ThreadLocalRandom;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.Gcd;
import nom.bdezonia.zorbage.algorithm.Lcm;
import nom.bdezonia.zorbage.algorithm.NumberWithin;
import nom.bdezonia.zorbage.algorithm.PowerNonNegative;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.BitOperations;
import nom.bdezonia.zorbage.type.algebra.Bounded;
import nom.bdezonia.zorbage.type.algebra.Integer;
import nom.bdezonia.zorbage.type.algebra.Random;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.int7.UnsignedInt7Member;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class UnsignedInt7Algebra
implements Integer<UnsignedInt7Algebra, UnsignedInt7Member>,
Bounded<UnsignedInt7Member>,
BitOperations<UnsignedInt7Member>,
Random<UnsignedInt7Member>,
Tolerance<UnsignedInt7Member, UnsignedInt7Member> {
    private final Function2<Boolean, UnsignedInt7Member, UnsignedInt7Member> EQ = new Function2<Boolean, UnsignedInt7Member, UnsignedInt7Member>(){

        @Override
        public Boolean call(UnsignedInt7Member a, UnsignedInt7Member b) {
            return a.v == b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt7Member, UnsignedInt7Member> NEQ = new Function2<Boolean, UnsignedInt7Member, UnsignedInt7Member>(){

        @Override
        public Boolean call(UnsignedInt7Member a, UnsignedInt7Member b) {
            return a.v != b.v;
        }
    };
    private final Procedure2<UnsignedInt7Member, UnsignedInt7Member> ASSIGN = new Procedure2<UnsignedInt7Member, UnsignedInt7Member>(){

        @Override
        public void call(UnsignedInt7Member a, UnsignedInt7Member b) {
            b.set(a);
        }
    };
    private final Procedure1<UnsignedInt7Member> ZER = new Procedure1<UnsignedInt7Member>(){

        @Override
        public void call(UnsignedInt7Member a) {
            a.v = 0;
        }
    };
    private final Procedure3<UnsignedInt7Member, UnsignedInt7Member, UnsignedInt7Member> ADD = new Procedure3<UnsignedInt7Member, UnsignedInt7Member, UnsignedInt7Member>(){

        @Override
        public void call(UnsignedInt7Member a, UnsignedInt7Member b, UnsignedInt7Member c) {
            c.setV(a.v + b.v);
        }
    };
    private final Procedure3<UnsignedInt7Member, UnsignedInt7Member, UnsignedInt7Member> SUB = new Procedure3<UnsignedInt7Member, UnsignedInt7Member, UnsignedInt7Member>(){

        @Override
        public void call(UnsignedInt7Member a, UnsignedInt7Member b, UnsignedInt7Member c) {
            c.setV(a.v - b.v);
        }
    };
    private final Procedure3<UnsignedInt7Member, UnsignedInt7Member, UnsignedInt7Member> MUL = new Procedure3<UnsignedInt7Member, UnsignedInt7Member, UnsignedInt7Member>(){

        @Override
        public void call(UnsignedInt7Member a, UnsignedInt7Member b, UnsignedInt7Member c) {
            c.setV(a.v * b.v);
        }
    };
    private final Procedure3<java.lang.Integer, UnsignedInt7Member, UnsignedInt7Member> POWER = new Procedure3<java.lang.Integer, UnsignedInt7Member, UnsignedInt7Member>(){

        @Override
        public void call(java.lang.Integer power, UnsignedInt7Member a, UnsignedInt7Member b) {
            PowerNonNegative.compute(G.UINT7, power, a, b);
        }
    };
    private final Procedure1<UnsignedInt7Member> UNITY = new Procedure1<UnsignedInt7Member>(){

        @Override
        public void call(UnsignedInt7Member a) {
            a.v = 1;
        }
    };
    private final Function2<Boolean, UnsignedInt7Member, UnsignedInt7Member> LESS = new Function2<Boolean, UnsignedInt7Member, UnsignedInt7Member>(){

        @Override
        public Boolean call(UnsignedInt7Member a, UnsignedInt7Member b) {
            return a.v < b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt7Member, UnsignedInt7Member> LE = new Function2<Boolean, UnsignedInt7Member, UnsignedInt7Member>(){

        @Override
        public Boolean call(UnsignedInt7Member a, UnsignedInt7Member b) {
            return a.v <= b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt7Member, UnsignedInt7Member> GREAT = new Function2<Boolean, UnsignedInt7Member, UnsignedInt7Member>(){

        @Override
        public Boolean call(UnsignedInt7Member a, UnsignedInt7Member b) {
            return a.v > b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt7Member, UnsignedInt7Member> GE = new Function2<Boolean, UnsignedInt7Member, UnsignedInt7Member>(){

        @Override
        public Boolean call(UnsignedInt7Member a, UnsignedInt7Member b) {
            return a.v >= b.v;
        }
    };
    private final Function2<java.lang.Integer, UnsignedInt7Member, UnsignedInt7Member> CMP = new Function2<java.lang.Integer, UnsignedInt7Member, UnsignedInt7Member>(){

        @Override
        public java.lang.Integer call(UnsignedInt7Member a, UnsignedInt7Member b) {
            if (a.v < b.v) {
                return -1;
            }
            if (a.v > b.v) {
                return 1;
            }
            return 0;
        }
    };
    private final Function1<java.lang.Integer, UnsignedInt7Member> SIG = new Function1<java.lang.Integer, UnsignedInt7Member>(){

        @Override
        public java.lang.Integer call(UnsignedInt7Member a) {
            if (a.v > 0) {
                return 1;
            }
            return 0;
        }
    };
    private final Procedure3<UnsignedInt7Member, UnsignedInt7Member, UnsignedInt7Member> MIN = new Procedure3<UnsignedInt7Member, UnsignedInt7Member, UnsignedInt7Member>(){

        @Override
        public void call(UnsignedInt7Member a, UnsignedInt7Member b, UnsignedInt7Member c) {
            if (a.v < b.v) {
                c.set(a);
            } else {
                c.set(b);
            }
        }
    };
    private final Procedure3<UnsignedInt7Member, UnsignedInt7Member, UnsignedInt7Member> MAX = new Procedure3<UnsignedInt7Member, UnsignedInt7Member, UnsignedInt7Member>(){

        @Override
        public void call(UnsignedInt7Member a, UnsignedInt7Member b, UnsignedInt7Member c) {
            if (a.v > b.v) {
                c.set(a);
            } else {
                c.set(b);
            }
        }
    };
    private final Procedure3<UnsignedInt7Member, UnsignedInt7Member, UnsignedInt7Member> GCD = new Procedure3<UnsignedInt7Member, UnsignedInt7Member, UnsignedInt7Member>(){

        @Override
        public void call(UnsignedInt7Member a, UnsignedInt7Member b, UnsignedInt7Member c) {
            Gcd.compute(G.UINT7, a, b, c);
        }
    };
    private final Procedure3<UnsignedInt7Member, UnsignedInt7Member, UnsignedInt7Member> LCM = new Procedure3<UnsignedInt7Member, UnsignedInt7Member, UnsignedInt7Member>(){

        @Override
        public void call(UnsignedInt7Member a, UnsignedInt7Member b, UnsignedInt7Member c) {
            Lcm.compute(G.UINT7, a, b, c);
        }
    };
    private final Function1<Boolean, UnsignedInt7Member> EVEN = new Function1<Boolean, UnsignedInt7Member>(){

        @Override
        public Boolean call(UnsignedInt7Member a) {
            return (a.v & 1) == 0;
        }
    };
    private final Function1<Boolean, UnsignedInt7Member> ODD = new Function1<Boolean, UnsignedInt7Member>(){

        @Override
        public Boolean call(UnsignedInt7Member a) {
            return (a.v & 1) == 1;
        }
    };
    private final Procedure3<UnsignedInt7Member, UnsignedInt7Member, UnsignedInt7Member> DIV = new Procedure3<UnsignedInt7Member, UnsignedInt7Member, UnsignedInt7Member>(){

        @Override
        public void call(UnsignedInt7Member a, UnsignedInt7Member b, UnsignedInt7Member d) {
            d.setV(a.v / b.v);
        }
    };
    private final Procedure3<UnsignedInt7Member, UnsignedInt7Member, UnsignedInt7Member> MOD = new Procedure3<UnsignedInt7Member, UnsignedInt7Member, UnsignedInt7Member>(){

        @Override
        public void call(UnsignedInt7Member a, UnsignedInt7Member b, UnsignedInt7Member m) {
            m.setV(a.v % b.v);
        }
    };
    private final Procedure4<UnsignedInt7Member, UnsignedInt7Member, UnsignedInt7Member, UnsignedInt7Member> DIVMOD = new Procedure4<UnsignedInt7Member, UnsignedInt7Member, UnsignedInt7Member, UnsignedInt7Member>(){

        @Override
        public void call(UnsignedInt7Member a, UnsignedInt7Member b, UnsignedInt7Member d, UnsignedInt7Member m) {
            UnsignedInt7Algebra.this.div().call(a, b, d);
            UnsignedInt7Algebra.this.mod().call(a, b, m);
        }
    };
    private final Procedure2<UnsignedInt7Member, UnsignedInt7Member> PRED = new Procedure2<UnsignedInt7Member, UnsignedInt7Member>(){

        @Override
        public void call(UnsignedInt7Member a, UnsignedInt7Member b) {
            if (a.v == 0) {
                b.v = (byte)127;
            } else {
                b.setV(a.v - 1);
            }
        }
    };
    private final Procedure2<UnsignedInt7Member, UnsignedInt7Member> SUCC = new Procedure2<UnsignedInt7Member, UnsignedInt7Member>(){

        @Override
        public void call(UnsignedInt7Member a, UnsignedInt7Member b) {
            if (a.v == 127) {
                b.v = 0;
            } else {
                b.setV(a.v + 1);
            }
        }
    };
    private final Procedure3<UnsignedInt7Member, UnsignedInt7Member, UnsignedInt7Member> POW = new Procedure3<UnsignedInt7Member, UnsignedInt7Member, UnsignedInt7Member>(){

        @Override
        public void call(UnsignedInt7Member a, UnsignedInt7Member b, UnsignedInt7Member c) {
            PowerNonNegative.compute(G.UINT7, b.v, a, c);
        }
    };
    private final Procedure1<UnsignedInt7Member> RAND = new Procedure1<UnsignedInt7Member>(){

        @Override
        public void call(UnsignedInt7Member a) {
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            a.setV(rng.nextInt(128));
        }
    };
    private final Procedure3<UnsignedInt7Member, UnsignedInt7Member, UnsignedInt7Member> AND = new Procedure3<UnsignedInt7Member, UnsignedInt7Member, UnsignedInt7Member>(){

        @Override
        public void call(UnsignedInt7Member a, UnsignedInt7Member b, UnsignedInt7Member c) {
            c.setV(a.v & b.v);
        }
    };
    private final Procedure3<UnsignedInt7Member, UnsignedInt7Member, UnsignedInt7Member> OR = new Procedure3<UnsignedInt7Member, UnsignedInt7Member, UnsignedInt7Member>(){

        @Override
        public void call(UnsignedInt7Member a, UnsignedInt7Member b, UnsignedInt7Member c) {
            c.setV(a.v | b.v);
        }
    };
    private final Procedure3<UnsignedInt7Member, UnsignedInt7Member, UnsignedInt7Member> XOR = new Procedure3<UnsignedInt7Member, UnsignedInt7Member, UnsignedInt7Member>(){

        @Override
        public void call(UnsignedInt7Member a, UnsignedInt7Member b, UnsignedInt7Member c) {
            c.setV(a.v ^ b.v);
        }
    };
    private final Procedure2<UnsignedInt7Member, UnsignedInt7Member> NOT = new Procedure2<UnsignedInt7Member, UnsignedInt7Member>(){

        @Override
        public void call(UnsignedInt7Member a, UnsignedInt7Member b) {
            b.setV(~a.v);
        }
    };
    private final Procedure3<UnsignedInt7Member, UnsignedInt7Member, UnsignedInt7Member> ANDNOT = new Procedure3<UnsignedInt7Member, UnsignedInt7Member, UnsignedInt7Member>(){

        @Override
        public void call(UnsignedInt7Member a, UnsignedInt7Member b, UnsignedInt7Member c) {
            c.setV(a.v & ~b.v);
        }
    };
    private final Procedure3<java.lang.Integer, UnsignedInt7Member, UnsignedInt7Member> SHL = new Procedure3<java.lang.Integer, UnsignedInt7Member, UnsignedInt7Member>(){

        @Override
        public void call(java.lang.Integer count, UnsignedInt7Member a, UnsignedInt7Member b) {
            if (count < 0) {
                UnsignedInt7Algebra.this.bitShiftRight().call(-count.intValue(), a, b);
            } else {
                count = count % 7;
                b.setV(a.v << count);
            }
        }
    };
    private final Procedure3<java.lang.Integer, UnsignedInt7Member, UnsignedInt7Member> SHRZ = new Procedure3<java.lang.Integer, UnsignedInt7Member, UnsignedInt7Member>(){

        @Override
        public void call(java.lang.Integer count, UnsignedInt7Member a, UnsignedInt7Member b) {
            if (count < 0) {
                UnsignedInt7Algebra.this.bitShiftLeft().call(-count.intValue(), a, b);
            } else {
                b.setV(a.v >>> count);
            }
        }
    };
    private final Procedure1<UnsignedInt7Member> MAXBOUND = new Procedure1<UnsignedInt7Member>(){

        @Override
        public void call(UnsignedInt7Member a) {
            a.v = (byte)127;
        }
    };
    private final Procedure1<UnsignedInt7Member> MINBOUND = new Procedure1<UnsignedInt7Member>(){

        @Override
        public void call(UnsignedInt7Member a) {
            a.v = 0;
        }
    };
    private final Function1<Boolean, UnsignedInt7Member> ISZERO = new Function1<Boolean, UnsignedInt7Member>(){

        @Override
        public Boolean call(UnsignedInt7Member a) {
            return a.v == 0;
        }
    };
    private final Procedure3<HighPrecisionMember, UnsignedInt7Member, UnsignedInt7Member> SBHP = new Procedure3<HighPrecisionMember, UnsignedInt7Member, UnsignedInt7Member>(){

        @Override
        public void call(HighPrecisionMember a, UnsignedInt7Member b, UnsignedInt7Member c) {
            BigDecimal tmp = a.v();
            tmp = tmp.multiply(new BigDecimal(b.v()));
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<HighPrecisionMember, UnsignedInt7Member, UnsignedInt7Member> SBHPR = new Procedure3<HighPrecisionMember, UnsignedInt7Member, UnsignedInt7Member>(){

        @Override
        public void call(HighPrecisionMember a, UnsignedInt7Member b, UnsignedInt7Member c) {
            BigDecimal tmp = a.v();
            int signum = (tmp = tmp.multiply(new BigDecimal(b.v()))).signum();
            tmp = signum < 0 ? tmp.subtract(G.ONE_HALF) : tmp.add(G.ONE_HALF);
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<RationalMember, UnsignedInt7Member, UnsignedInt7Member> SBR = new Procedure3<RationalMember, UnsignedInt7Member, UnsignedInt7Member>(){

        @Override
        public void call(RationalMember a, UnsignedInt7Member b, UnsignedInt7Member c) {
            BigInteger tmp = BigInteger.valueOf(b.v());
            tmp = tmp.multiply(a.n());
            tmp = tmp.divide(a.d());
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<Double, UnsignedInt7Member, UnsignedInt7Member> SBD = new Procedure3<Double, UnsignedInt7Member, UnsignedInt7Member>(){

        @Override
        public void call(Double a, UnsignedInt7Member b, UnsignedInt7Member c) {
            c.setV((int)(a * (double)b.v()));
        }
    };
    private final Procedure3<Double, UnsignedInt7Member, UnsignedInt7Member> SBDR = new Procedure3<Double, UnsignedInt7Member, UnsignedInt7Member>(){

        @Override
        public void call(Double a, UnsignedInt7Member b, UnsignedInt7Member c) {
            c.setV((int)Math.round(a * (double)b.v()));
        }
    };
    private final Function3<Boolean, UnsignedInt7Member, UnsignedInt7Member, UnsignedInt7Member> WITHIN = new Function3<Boolean, UnsignedInt7Member, UnsignedInt7Member, UnsignedInt7Member>(){

        @Override
        public Boolean call(UnsignedInt7Member tol, UnsignedInt7Member a, UnsignedInt7Member b) {
            return NumberWithin.compute(G.UINT7, tol, a, b);
        }
    };

    @Override
    public UnsignedInt7Member construct() {
        return new UnsignedInt7Member();
    }

    @Override
    public UnsignedInt7Member construct(UnsignedInt7Member other) {
        return new UnsignedInt7Member(other);
    }

    @Override
    public UnsignedInt7Member construct(String str) {
        return new UnsignedInt7Member(str);
    }

    @Override
    public Function2<Boolean, UnsignedInt7Member, UnsignedInt7Member> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, UnsignedInt7Member, UnsignedInt7Member> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<UnsignedInt7Member, UnsignedInt7Member> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure1<UnsignedInt7Member> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<UnsignedInt7Member, UnsignedInt7Member> negate() {
        return this.ASSIGN;
    }

    @Override
    public Procedure3<UnsignedInt7Member, UnsignedInt7Member, UnsignedInt7Member> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<UnsignedInt7Member, UnsignedInt7Member, UnsignedInt7Member> subtract() {
        return this.SUB;
    }

    @Override
    public Procedure3<UnsignedInt7Member, UnsignedInt7Member, UnsignedInt7Member> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt7Member, UnsignedInt7Member> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<UnsignedInt7Member> unity() {
        return this.UNITY;
    }

    @Override
    public Function2<Boolean, UnsignedInt7Member, UnsignedInt7Member> isLess() {
        return this.LESS;
    }

    @Override
    public Function2<Boolean, UnsignedInt7Member, UnsignedInt7Member> isLessEqual() {
        return this.LE;
    }

    @Override
    public Function2<Boolean, UnsignedInt7Member, UnsignedInt7Member> isGreater() {
        return this.GREAT;
    }

    @Override
    public Function2<Boolean, UnsignedInt7Member, UnsignedInt7Member> isGreaterEqual() {
        return this.GE;
    }

    @Override
    public Function2<java.lang.Integer, UnsignedInt7Member, UnsignedInt7Member> compare() {
        return this.CMP;
    }

    @Override
    public Function1<java.lang.Integer, UnsignedInt7Member> signum() {
        return this.SIG;
    }

    @Override
    public Procedure3<UnsignedInt7Member, UnsignedInt7Member, UnsignedInt7Member> min() {
        return this.MIN;
    }

    @Override
    public Procedure3<UnsignedInt7Member, UnsignedInt7Member, UnsignedInt7Member> max() {
        return this.MAX;
    }

    @Override
    public Procedure2<UnsignedInt7Member, UnsignedInt7Member> abs() {
        return this.ASSIGN;
    }

    @Override
    public Procedure2<UnsignedInt7Member, UnsignedInt7Member> norm() {
        return this.ASSIGN;
    }

    @Override
    public Procedure3<UnsignedInt7Member, UnsignedInt7Member, UnsignedInt7Member> gcd() {
        return this.GCD;
    }

    @Override
    public Procedure3<UnsignedInt7Member, UnsignedInt7Member, UnsignedInt7Member> lcm() {
        return this.LCM;
    }

    @Override
    public Function1<Boolean, UnsignedInt7Member> isEven() {
        return this.EVEN;
    }

    @Override
    public Function1<Boolean, UnsignedInt7Member> isOdd() {
        return this.ODD;
    }

    @Override
    public Procedure3<UnsignedInt7Member, UnsignedInt7Member, UnsignedInt7Member> div() {
        return this.DIV;
    }

    @Override
    public Procedure3<UnsignedInt7Member, UnsignedInt7Member, UnsignedInt7Member> mod() {
        return this.MOD;
    }

    @Override
    public Procedure4<UnsignedInt7Member, UnsignedInt7Member, UnsignedInt7Member, UnsignedInt7Member> divMod() {
        return this.DIVMOD;
    }

    @Override
    public Procedure2<UnsignedInt7Member, UnsignedInt7Member> pred() {
        return this.PRED;
    }

    @Override
    public Procedure2<UnsignedInt7Member, UnsignedInt7Member> succ() {
        return this.SUCC;
    }

    @Override
    public Procedure3<UnsignedInt7Member, UnsignedInt7Member, UnsignedInt7Member> pow() {
        return this.POW;
    }

    @Override
    public Procedure1<UnsignedInt7Member> random() {
        return this.RAND;
    }

    @Override
    public Procedure3<UnsignedInt7Member, UnsignedInt7Member, UnsignedInt7Member> bitAnd() {
        return this.AND;
    }

    @Override
    public Procedure3<UnsignedInt7Member, UnsignedInt7Member, UnsignedInt7Member> bitOr() {
        return this.OR;
    }

    @Override
    public Procedure3<UnsignedInt7Member, UnsignedInt7Member, UnsignedInt7Member> bitXor() {
        return this.XOR;
    }

    @Override
    public Procedure2<UnsignedInt7Member, UnsignedInt7Member> bitNot() {
        return this.NOT;
    }

    @Override
    public Procedure3<UnsignedInt7Member, UnsignedInt7Member, UnsignedInt7Member> bitAndNot() {
        return this.ANDNOT;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt7Member, UnsignedInt7Member> bitShiftLeft() {
        return this.SHL;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt7Member, UnsignedInt7Member> bitShiftRight() {
        return this.SHRZ;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt7Member, UnsignedInt7Member> bitShiftRightFillZero() {
        return this.SHRZ;
    }

    @Override
    public Procedure1<UnsignedInt7Member> maxBound() {
        return this.MAXBOUND;
    }

    @Override
    public Procedure1<UnsignedInt7Member> minBound() {
        return this.MINBOUND;
    }

    @Override
    public Function1<Boolean, UnsignedInt7Member> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<UnsignedInt7Member, UnsignedInt7Member, UnsignedInt7Member> scale() {
        return this.MUL;
    }

    @Override
    public Procedure3<HighPrecisionMember, UnsignedInt7Member, UnsignedInt7Member> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<HighPrecisionMember, UnsignedInt7Member, UnsignedInt7Member> scaleByHighPrecAndRound() {
        return this.SBHPR;
    }

    @Override
    public Procedure3<RationalMember, UnsignedInt7Member, UnsignedInt7Member> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, UnsignedInt7Member, UnsignedInt7Member> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<Double, UnsignedInt7Member, UnsignedInt7Member> scaleByDoubleAndRound() {
        return this.SBDR;
    }

    @Override
    public Function3<Boolean, UnsignedInt7Member, UnsignedInt7Member, UnsignedInt7Member> within() {
        return this.WITHIN;
    }
}

