/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.int8;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.ThreadLocalRandom;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.Gcd;
import nom.bdezonia.zorbage.algorithm.Lcm;
import nom.bdezonia.zorbage.algorithm.Max;
import nom.bdezonia.zorbage.algorithm.Min;
import nom.bdezonia.zorbage.algorithm.NumberWithin;
import nom.bdezonia.zorbage.algorithm.PowerNonNegative;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.BitOperations;
import nom.bdezonia.zorbage.type.algebra.Bounded;
import nom.bdezonia.zorbage.type.algebra.Integer;
import nom.bdezonia.zorbage.type.algebra.Random;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.int8.SignedInt8Member;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class SignedInt8Algebra
implements Integer<SignedInt8Algebra, SignedInt8Member>,
Bounded<SignedInt8Member>,
BitOperations<SignedInt8Member>,
Random<SignedInt8Member>,
Tolerance<SignedInt8Member, SignedInt8Member> {
    private final Function2<Boolean, SignedInt8Member, SignedInt8Member> EQ = new Function2<Boolean, SignedInt8Member, SignedInt8Member>(){

        @Override
        public Boolean call(SignedInt8Member a, SignedInt8Member b) {
            return a.v() == b.v();
        }
    };
    private final Function2<Boolean, SignedInt8Member, SignedInt8Member> NEQ = new Function2<Boolean, SignedInt8Member, SignedInt8Member>(){

        @Override
        public Boolean call(SignedInt8Member a, SignedInt8Member b) {
            return a.v() != b.v();
        }
    };
    private final Procedure2<SignedInt8Member, SignedInt8Member> ASSIGN = new Procedure2<SignedInt8Member, SignedInt8Member>(){

        @Override
        public void call(SignedInt8Member from, SignedInt8Member to) {
            to.v = from.v;
        }
    };
    private final Procedure2<SignedInt8Member, SignedInt8Member> ABS = new Procedure2<SignedInt8Member, SignedInt8Member>(){

        @Override
        public void call(SignedInt8Member a, SignedInt8Member b) {
            if (a.v() == -128) {
                throw new IllegalArgumentException("Cannot convert -minint symmetrically");
            }
            b.setV(Math.abs(a.v()));
        }
    };
    private final Procedure3<SignedInt8Member, SignedInt8Member, SignedInt8Member> MUL = new Procedure3<SignedInt8Member, SignedInt8Member, SignedInt8Member>(){

        @Override
        public void call(SignedInt8Member a, SignedInt8Member b, SignedInt8Member c) {
            c.setV(a.v() * b.v());
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt8Member, SignedInt8Member> POWER = new Procedure3<java.lang.Integer, SignedInt8Member, SignedInt8Member>(){

        @Override
        public void call(java.lang.Integer power, SignedInt8Member a, SignedInt8Member b) {
            PowerNonNegative.compute(G.INT8, power, a, b);
        }
    };
    private final Procedure1<SignedInt8Member> ZER = new Procedure1<SignedInt8Member>(){

        @Override
        public void call(SignedInt8Member a) {
            a.v = 0;
        }
    };
    private final Procedure2<SignedInt8Member, SignedInt8Member> NEG = new Procedure2<SignedInt8Member, SignedInt8Member>(){

        @Override
        public void call(SignedInt8Member a, SignedInt8Member b) {
            if (a.v() == -128) {
                throw new IllegalArgumentException("Cannot convert -minint symmetrically");
            }
            b.setV(-a.v());
        }
    };
    private final Procedure3<SignedInt8Member, SignedInt8Member, SignedInt8Member> ADD = new Procedure3<SignedInt8Member, SignedInt8Member, SignedInt8Member>(){

        @Override
        public void call(SignedInt8Member a, SignedInt8Member b, SignedInt8Member c) {
            c.setV(a.v() + b.v());
        }
    };
    private final Procedure3<SignedInt8Member, SignedInt8Member, SignedInt8Member> SUB = new Procedure3<SignedInt8Member, SignedInt8Member, SignedInt8Member>(){

        @Override
        public void call(SignedInt8Member a, SignedInt8Member b, SignedInt8Member c) {
            c.setV(a.v() - b.v());
        }
    };
    private final Procedure1<SignedInt8Member> UNITY = new Procedure1<SignedInt8Member>(){

        @Override
        public void call(SignedInt8Member a) {
            a.v = 1;
        }
    };
    private final Function2<Boolean, SignedInt8Member, SignedInt8Member> LESS = new Function2<Boolean, SignedInt8Member, SignedInt8Member>(){

        @Override
        public Boolean call(SignedInt8Member a, SignedInt8Member b) {
            return a.v() < b.v();
        }
    };
    private final Function2<Boolean, SignedInt8Member, SignedInt8Member> LE = new Function2<Boolean, SignedInt8Member, SignedInt8Member>(){

        @Override
        public Boolean call(SignedInt8Member a, SignedInt8Member b) {
            return a.v() <= b.v();
        }
    };
    private final Function2<Boolean, SignedInt8Member, SignedInt8Member> GREATER = new Function2<Boolean, SignedInt8Member, SignedInt8Member>(){

        @Override
        public Boolean call(SignedInt8Member a, SignedInt8Member b) {
            return a.v() > b.v();
        }
    };
    private final Function2<Boolean, SignedInt8Member, SignedInt8Member> GE = new Function2<Boolean, SignedInt8Member, SignedInt8Member>(){

        @Override
        public Boolean call(SignedInt8Member a, SignedInt8Member b) {
            return a.v() >= b.v();
        }
    };
    private final Function2<java.lang.Integer, SignedInt8Member, SignedInt8Member> CMP = new Function2<java.lang.Integer, SignedInt8Member, SignedInt8Member>(){

        @Override
        public java.lang.Integer call(SignedInt8Member a, SignedInt8Member b) {
            if (a.v() < b.v()) {
                return -1;
            }
            if (a.v() > b.v()) {
                return 1;
            }
            return 0;
        }
    };
    private final Function1<java.lang.Integer, SignedInt8Member> SIG = new Function1<java.lang.Integer, SignedInt8Member>(){

        @Override
        public java.lang.Integer call(SignedInt8Member a) {
            if (a.v() < 0) {
                return -1;
            }
            if (a.v() > 0) {
                return 1;
            }
            return 0;
        }
    };
    private final Procedure3<SignedInt8Member, SignedInt8Member, SignedInt8Member> DIV = new Procedure3<SignedInt8Member, SignedInt8Member, SignedInt8Member>(){

        @Override
        public void call(SignedInt8Member a, SignedInt8Member b, SignedInt8Member c) {
            if (b.v() == -1 && a.v() == -128) {
                throw new IllegalArgumentException("cannot divide minint by -1");
            }
            c.setV(a.v() / b.v());
        }
    };
    private final Procedure3<SignedInt8Member, SignedInt8Member, SignedInt8Member> MOD = new Procedure3<SignedInt8Member, SignedInt8Member, SignedInt8Member>(){

        @Override
        public void call(SignedInt8Member a, SignedInt8Member b, SignedInt8Member c) {
            c.setV(a.v() % b.v());
        }
    };
    private final Procedure4<SignedInt8Member, SignedInt8Member, SignedInt8Member, SignedInt8Member> DIVMOD = new Procedure4<SignedInt8Member, SignedInt8Member, SignedInt8Member, SignedInt8Member>(){

        @Override
        public void call(SignedInt8Member a, SignedInt8Member b, SignedInt8Member d, SignedInt8Member m) {
            SignedInt8Algebra.this.div().call(a, b, d);
            SignedInt8Algebra.this.mod().call(a, b, m);
        }
    };
    private final Procedure3<SignedInt8Member, SignedInt8Member, SignedInt8Member> GCD = new Procedure3<SignedInt8Member, SignedInt8Member, SignedInt8Member>(){

        @Override
        public void call(SignedInt8Member a, SignedInt8Member b, SignedInt8Member c) {
            Gcd.compute(G.INT8, a, b, c);
        }
    };
    private final Procedure3<SignedInt8Member, SignedInt8Member, SignedInt8Member> LCM = new Procedure3<SignedInt8Member, SignedInt8Member, SignedInt8Member>(){

        @Override
        public void call(SignedInt8Member a, SignedInt8Member b, SignedInt8Member c) {
            Lcm.compute(G.INT8, a, b, c);
        }
    };
    private final Function1<Boolean, SignedInt8Member> EVEN = new Function1<Boolean, SignedInt8Member>(){

        @Override
        public Boolean call(SignedInt8Member a) {
            return (a.v() & 1) == 0;
        }
    };
    private final Function1<Boolean, SignedInt8Member> ODD = new Function1<Boolean, SignedInt8Member>(){

        @Override
        public Boolean call(SignedInt8Member a) {
            return (a.v() & 1) == 1;
        }
    };
    private final Procedure2<SignedInt8Member, SignedInt8Member> PRED = new Procedure2<SignedInt8Member, SignedInt8Member>(){

        @Override
        public void call(SignedInt8Member a, SignedInt8Member b) {
            b.setV(a.v() - 1);
        }
    };
    private final Procedure2<SignedInt8Member, SignedInt8Member> SUCC = new Procedure2<SignedInt8Member, SignedInt8Member>(){

        @Override
        public void call(SignedInt8Member a, SignedInt8Member b) {
            b.setV(a.v() + 1);
        }
    };
    private final Procedure1<SignedInt8Member> MAXBOUND = new Procedure1<SignedInt8Member>(){

        @Override
        public void call(SignedInt8Member a) {
            a.v = (byte)127;
        }
    };
    private final Procedure1<SignedInt8Member> MINBOUND = new Procedure1<SignedInt8Member>(){

        @Override
        public void call(SignedInt8Member a) {
            a.v = (byte)-128;
        }
    };
    private final Procedure3<SignedInt8Member, SignedInt8Member, SignedInt8Member> BITAND = new Procedure3<SignedInt8Member, SignedInt8Member, SignedInt8Member>(){

        @Override
        public void call(SignedInt8Member a, SignedInt8Member b, SignedInt8Member c) {
            c.setV(a.v() & b.v());
        }
    };
    private final Procedure3<SignedInt8Member, SignedInt8Member, SignedInt8Member> BITOR = new Procedure3<SignedInt8Member, SignedInt8Member, SignedInt8Member>(){

        @Override
        public void call(SignedInt8Member a, SignedInt8Member b, SignedInt8Member c) {
            c.setV(a.v() | b.v());
        }
    };
    private final Procedure3<SignedInt8Member, SignedInt8Member, SignedInt8Member> BITXOR = new Procedure3<SignedInt8Member, SignedInt8Member, SignedInt8Member>(){

        @Override
        public void call(SignedInt8Member a, SignedInt8Member b, SignedInt8Member c) {
            c.setV(a.v() ^ b.v());
        }
    };
    private final Procedure2<SignedInt8Member, SignedInt8Member> BITNOT = new Procedure2<SignedInt8Member, SignedInt8Member>(){

        @Override
        public void call(SignedInt8Member a, SignedInt8Member b) {
            b.setV(~a.v());
        }
    };
    private final Procedure3<SignedInt8Member, SignedInt8Member, SignedInt8Member> BITANDNOT = new Procedure3<SignedInt8Member, SignedInt8Member, SignedInt8Member>(){

        @Override
        public void call(SignedInt8Member a, SignedInt8Member b, SignedInt8Member c) {
            c.setV(a.v() & ~b.v());
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt8Member, SignedInt8Member> BITSHL = new Procedure3<java.lang.Integer, SignedInt8Member, SignedInt8Member>(){

        @Override
        public void call(java.lang.Integer count, SignedInt8Member a, SignedInt8Member b) {
            if (count < 0) {
                SignedInt8Algebra.this.bitShiftRight().call(-count.intValue(), a, b);
            } else {
                count = count % 8;
                b.setV(a.v() << count);
            }
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt8Member, SignedInt8Member> BITSHR = new Procedure3<java.lang.Integer, SignedInt8Member, SignedInt8Member>(){

        @Override
        public void call(java.lang.Integer count, SignedInt8Member a, SignedInt8Member b) {
            if (count < 0) {
                SignedInt8Algebra.this.bitShiftLeft().call(-count.intValue(), a, b);
            } else {
                b.setV(a.v() >> count);
            }
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt8Member, SignedInt8Member> BITSHRZ = new Procedure3<java.lang.Integer, SignedInt8Member, SignedInt8Member>(){

        @Override
        public void call(java.lang.Integer count, SignedInt8Member a, SignedInt8Member b) {
            if (count < 0) {
                SignedInt8Algebra.this.bitShiftLeft().call(-count.intValue(), a, b);
            } else {
                b.setV(a.v() >>> count);
            }
        }
    };
    private final Procedure3<SignedInt8Member, SignedInt8Member, SignedInt8Member> MIN = new Procedure3<SignedInt8Member, SignedInt8Member, SignedInt8Member>(){

        @Override
        public void call(SignedInt8Member a, SignedInt8Member b, SignedInt8Member c) {
            Min.compute(G.INT8, a, b, c);
        }
    };
    private final Procedure3<SignedInt8Member, SignedInt8Member, SignedInt8Member> MAX = new Procedure3<SignedInt8Member, SignedInt8Member, SignedInt8Member>(){

        @Override
        public void call(SignedInt8Member a, SignedInt8Member b, SignedInt8Member c) {
            Max.compute(G.INT8, a, b, c);
        }
    };
    private final Procedure1<SignedInt8Member> RAND = new Procedure1<SignedInt8Member>(){

        @Override
        public void call(SignedInt8Member a) {
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            a.setV(rng.nextInt(256) - 128);
        }
    };
    private final Procedure3<SignedInt8Member, SignedInt8Member, SignedInt8Member> POW = new Procedure3<SignedInt8Member, SignedInt8Member, SignedInt8Member>(){

        @Override
        public void call(SignedInt8Member a, SignedInt8Member b, SignedInt8Member c) {
            SignedInt8Algebra.this.power().call(java.lang.Integer.valueOf(b.v()), a, c);
        }
    };
    private final Function1<Boolean, SignedInt8Member> ISZERO = new Function1<Boolean, SignedInt8Member>(){

        @Override
        public Boolean call(SignedInt8Member a) {
            return a.v() == 0;
        }
    };
    private final Procedure3<HighPrecisionMember, SignedInt8Member, SignedInt8Member> SBHP = new Procedure3<HighPrecisionMember, SignedInt8Member, SignedInt8Member>(){

        @Override
        public void call(HighPrecisionMember a, SignedInt8Member b, SignedInt8Member c) {
            BigDecimal tmp = a.v();
            tmp = tmp.multiply(new BigDecimal(b.v()));
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<HighPrecisionMember, SignedInt8Member, SignedInt8Member> SBHPR = new Procedure3<HighPrecisionMember, SignedInt8Member, SignedInt8Member>(){

        @Override
        public void call(HighPrecisionMember a, SignedInt8Member b, SignedInt8Member c) {
            BigDecimal tmp = a.v();
            int signum = (tmp = tmp.multiply(new BigDecimal(b.v()))).signum();
            tmp = signum < 0 ? tmp.subtract(G.ONE_HALF) : tmp.add(G.ONE_HALF);
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<RationalMember, SignedInt8Member, SignedInt8Member> SBR = new Procedure3<RationalMember, SignedInt8Member, SignedInt8Member>(){

        @Override
        public void call(RationalMember a, SignedInt8Member b, SignedInt8Member c) {
            BigInteger tmp = BigInteger.valueOf(b.v());
            tmp = tmp.multiply(a.n());
            tmp = tmp.divide(a.d());
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<Double, SignedInt8Member, SignedInt8Member> SBD = new Procedure3<Double, SignedInt8Member, SignedInt8Member>(){

        @Override
        public void call(Double a, SignedInt8Member b, SignedInt8Member c) {
            c.setV((int)(a * (double)b.v()));
        }
    };
    private final Procedure3<Double, SignedInt8Member, SignedInt8Member> SBDR = new Procedure3<Double, SignedInt8Member, SignedInt8Member>(){

        @Override
        public void call(Double a, SignedInt8Member b, SignedInt8Member c) {
            c.setV((int)Math.round(a * (double)b.v()));
        }
    };
    private final Function3<Boolean, SignedInt8Member, SignedInt8Member, SignedInt8Member> WITHIN = new Function3<Boolean, SignedInt8Member, SignedInt8Member, SignedInt8Member>(){

        @Override
        public Boolean call(SignedInt8Member tol, SignedInt8Member a, SignedInt8Member b) {
            return NumberWithin.compute(G.INT8, tol, a, b);
        }
    };

    @Override
    public Function2<Boolean, SignedInt8Member, SignedInt8Member> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, SignedInt8Member, SignedInt8Member> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public SignedInt8Member construct() {
        return new SignedInt8Member();
    }

    @Override
    public SignedInt8Member construct(SignedInt8Member other) {
        return new SignedInt8Member(other);
    }

    @Override
    public SignedInt8Member construct(String s) {
        return new SignedInt8Member(s);
    }

    @Override
    public Procedure2<SignedInt8Member, SignedInt8Member> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure2<SignedInt8Member, SignedInt8Member> abs() {
        return this.ABS;
    }

    @Override
    public Procedure3<SignedInt8Member, SignedInt8Member, SignedInt8Member> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt8Member, SignedInt8Member> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<SignedInt8Member> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<SignedInt8Member, SignedInt8Member> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<SignedInt8Member, SignedInt8Member, SignedInt8Member> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<SignedInt8Member, SignedInt8Member, SignedInt8Member> subtract() {
        return this.SUB;
    }

    @Override
    public Procedure1<SignedInt8Member> unity() {
        return this.UNITY;
    }

    @Override
    public Function2<Boolean, SignedInt8Member, SignedInt8Member> isLess() {
        return this.LESS;
    }

    @Override
    public Function2<Boolean, SignedInt8Member, SignedInt8Member> isLessEqual() {
        return this.LE;
    }

    @Override
    public Function2<Boolean, SignedInt8Member, SignedInt8Member> isGreater() {
        return this.GREATER;
    }

    @Override
    public Function2<Boolean, SignedInt8Member, SignedInt8Member> isGreaterEqual() {
        return this.GE;
    }

    @Override
    public Function2<java.lang.Integer, SignedInt8Member, SignedInt8Member> compare() {
        return this.CMP;
    }

    @Override
    public Function1<java.lang.Integer, SignedInt8Member> signum() {
        return this.SIG;
    }

    @Override
    public Procedure3<SignedInt8Member, SignedInt8Member, SignedInt8Member> div() {
        return this.DIV;
    }

    @Override
    public Procedure3<SignedInt8Member, SignedInt8Member, SignedInt8Member> mod() {
        return this.MOD;
    }

    @Override
    public Procedure4<SignedInt8Member, SignedInt8Member, SignedInt8Member, SignedInt8Member> divMod() {
        return this.DIVMOD;
    }

    @Override
    public Procedure3<SignedInt8Member, SignedInt8Member, SignedInt8Member> gcd() {
        return this.GCD;
    }

    @Override
    public Procedure3<SignedInt8Member, SignedInt8Member, SignedInt8Member> lcm() {
        return this.LCM;
    }

    @Override
    public Procedure2<SignedInt8Member, SignedInt8Member> norm() {
        return this.ABS;
    }

    @Override
    public Function1<Boolean, SignedInt8Member> isEven() {
        return this.EVEN;
    }

    @Override
    public Function1<Boolean, SignedInt8Member> isOdd() {
        return this.ODD;
    }

    @Override
    public Procedure2<SignedInt8Member, SignedInt8Member> pred() {
        return this.PRED;
    }

    @Override
    public Procedure2<SignedInt8Member, SignedInt8Member> succ() {
        return this.SUCC;
    }

    @Override
    public Procedure1<SignedInt8Member> maxBound() {
        return this.MAXBOUND;
    }

    @Override
    public Procedure1<SignedInt8Member> minBound() {
        return this.MINBOUND;
    }

    @Override
    public Procedure3<SignedInt8Member, SignedInt8Member, SignedInt8Member> bitAnd() {
        return this.BITAND;
    }

    @Override
    public Procedure3<SignedInt8Member, SignedInt8Member, SignedInt8Member> bitOr() {
        return this.BITOR;
    }

    @Override
    public Procedure3<SignedInt8Member, SignedInt8Member, SignedInt8Member> bitXor() {
        return this.BITXOR;
    }

    @Override
    public Procedure2<SignedInt8Member, SignedInt8Member> bitNot() {
        return this.BITNOT;
    }

    @Override
    public Procedure3<SignedInt8Member, SignedInt8Member, SignedInt8Member> bitAndNot() {
        return this.BITANDNOT;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt8Member, SignedInt8Member> bitShiftLeft() {
        return this.BITSHL;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt8Member, SignedInt8Member> bitShiftRight() {
        return this.BITSHR;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt8Member, SignedInt8Member> bitShiftRightFillZero() {
        return this.BITSHRZ;
    }

    @Override
    public Procedure3<SignedInt8Member, SignedInt8Member, SignedInt8Member> min() {
        return this.MIN;
    }

    @Override
    public Procedure3<SignedInt8Member, SignedInt8Member, SignedInt8Member> max() {
        return this.MAX;
    }

    @Override
    public Procedure1<SignedInt8Member> random() {
        return this.RAND;
    }

    @Override
    public Procedure3<SignedInt8Member, SignedInt8Member, SignedInt8Member> pow() {
        return this.POW;
    }

    @Override
    public Function1<Boolean, SignedInt8Member> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<SignedInt8Member, SignedInt8Member, SignedInt8Member> scale() {
        return this.MUL;
    }

    @Override
    public Procedure3<HighPrecisionMember, SignedInt8Member, SignedInt8Member> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<HighPrecisionMember, SignedInt8Member, SignedInt8Member> scaleByHighPrecAndRound() {
        return this.SBHPR;
    }

    @Override
    public Procedure3<RationalMember, SignedInt8Member, SignedInt8Member> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, SignedInt8Member, SignedInt8Member> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<Double, SignedInt8Member, SignedInt8Member> scaleByDoubleAndRound() {
        return this.SBDR;
    }

    @Override
    public Function3<Boolean, SignedInt8Member, SignedInt8Member, SignedInt8Member> within() {
        return this.WITHIN;
    }
}

