/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.int8;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.ThreadLocalRandom;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.Gcd;
import nom.bdezonia.zorbage.algorithm.Lcm;
import nom.bdezonia.zorbage.algorithm.Max;
import nom.bdezonia.zorbage.algorithm.Min;
import nom.bdezonia.zorbage.algorithm.NumberWithin;
import nom.bdezonia.zorbage.algorithm.PowerNonNegative;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.BitOperations;
import nom.bdezonia.zorbage.type.algebra.Bounded;
import nom.bdezonia.zorbage.type.algebra.Integer;
import nom.bdezonia.zorbage.type.algebra.Random;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.int8.UnsignedInt8Member;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class UnsignedInt8Algebra
implements Integer<UnsignedInt8Algebra, UnsignedInt8Member>,
Bounded<UnsignedInt8Member>,
BitOperations<UnsignedInt8Member>,
Random<UnsignedInt8Member>,
Tolerance<UnsignedInt8Member, UnsignedInt8Member> {
    private final Function2<Boolean, UnsignedInt8Member, UnsignedInt8Member> EQ = new Function2<Boolean, UnsignedInt8Member, UnsignedInt8Member>(){

        @Override
        public Boolean call(UnsignedInt8Member a, UnsignedInt8Member b) {
            return a.v == b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt8Member, UnsignedInt8Member> NEQ = new Function2<Boolean, UnsignedInt8Member, UnsignedInt8Member>(){

        @Override
        public Boolean call(UnsignedInt8Member a, UnsignedInt8Member b) {
            return a.v != b.v;
        }
    };
    private final Procedure2<UnsignedInt8Member, UnsignedInt8Member> ASSIGN = new Procedure2<UnsignedInt8Member, UnsignedInt8Member>(){

        @Override
        public void call(UnsignedInt8Member from, UnsignedInt8Member to) {
            to.set(from);
        }
    };
    private final Procedure3<UnsignedInt8Member, UnsignedInt8Member, UnsignedInt8Member> MUL = new Procedure3<UnsignedInt8Member, UnsignedInt8Member, UnsignedInt8Member>(){

        @Override
        public void call(UnsignedInt8Member a, UnsignedInt8Member b, UnsignedInt8Member c) {
            c.setV(a.v() * b.v());
        }
    };
    private final Procedure3<java.lang.Integer, UnsignedInt8Member, UnsignedInt8Member> POWER = new Procedure3<java.lang.Integer, UnsignedInt8Member, UnsignedInt8Member>(){

        @Override
        public void call(java.lang.Integer power, UnsignedInt8Member a, UnsignedInt8Member b) {
            PowerNonNegative.compute(G.UINT8, power, a, b);
        }
    };
    private final Procedure1<UnsignedInt8Member> ZER = new Procedure1<UnsignedInt8Member>(){

        @Override
        public void call(UnsignedInt8Member a) {
            a.setV(0);
        }
    };
    private final Procedure3<UnsignedInt8Member, UnsignedInt8Member, UnsignedInt8Member> ADD = new Procedure3<UnsignedInt8Member, UnsignedInt8Member, UnsignedInt8Member>(){

        @Override
        public void call(UnsignedInt8Member a, UnsignedInt8Member b, UnsignedInt8Member c) {
            c.setV(a.v + b.v);
        }
    };
    private final Procedure3<UnsignedInt8Member, UnsignedInt8Member, UnsignedInt8Member> SUB = new Procedure3<UnsignedInt8Member, UnsignedInt8Member, UnsignedInt8Member>(){

        @Override
        public void call(UnsignedInt8Member a, UnsignedInt8Member b, UnsignedInt8Member c) {
            c.setV(a.v - b.v);
        }
    };
    private final Procedure1<UnsignedInt8Member> UNITY = new Procedure1<UnsignedInt8Member>(){

        @Override
        public void call(UnsignedInt8Member a) {
            a.setV(1);
        }
    };
    private final Function2<Boolean, UnsignedInt8Member, UnsignedInt8Member> LESS = new Function2<Boolean, UnsignedInt8Member, UnsignedInt8Member>(){

        @Override
        public Boolean call(UnsignedInt8Member a, UnsignedInt8Member b) {
            return UnsignedInt8Algebra.this.compare().call(a, b) < 0;
        }
    };
    private final Function2<Boolean, UnsignedInt8Member, UnsignedInt8Member> LE = new Function2<Boolean, UnsignedInt8Member, UnsignedInt8Member>(){

        @Override
        public Boolean call(UnsignedInt8Member a, UnsignedInt8Member b) {
            return UnsignedInt8Algebra.this.compare().call(a, b) <= 0;
        }
    };
    private final Function2<Boolean, UnsignedInt8Member, UnsignedInt8Member> GREAT = new Function2<Boolean, UnsignedInt8Member, UnsignedInt8Member>(){

        @Override
        public Boolean call(UnsignedInt8Member a, UnsignedInt8Member b) {
            return UnsignedInt8Algebra.this.compare().call(a, b) > 0;
        }
    };
    private final Function2<Boolean, UnsignedInt8Member, UnsignedInt8Member> GE = new Function2<Boolean, UnsignedInt8Member, UnsignedInt8Member>(){

        @Override
        public Boolean call(UnsignedInt8Member a, UnsignedInt8Member b) {
            return UnsignedInt8Algebra.this.compare().call(a, b) >= 0;
        }
    };
    private final Function2<java.lang.Integer, UnsignedInt8Member, UnsignedInt8Member> CMP = new Function2<java.lang.Integer, UnsignedInt8Member, UnsignedInt8Member>(){

        @Override
        public java.lang.Integer call(UnsignedInt8Member a, UnsignedInt8Member b) {
            int bv;
            int av = a.v();
            if (av < (bv = b.v())) {
                return -1;
            }
            if (av > bv) {
                return 1;
            }
            return 0;
        }
    };
    private final Function1<java.lang.Integer, UnsignedInt8Member> SIG = new Function1<java.lang.Integer, UnsignedInt8Member>(){

        @Override
        public java.lang.Integer call(UnsignedInt8Member a) {
            if (a.v == 0) {
                return 0;
            }
            return 1;
        }
    };
    private final Procedure3<UnsignedInt8Member, UnsignedInt8Member, UnsignedInt8Member> DIV = new Procedure3<UnsignedInt8Member, UnsignedInt8Member, UnsignedInt8Member>(){

        @Override
        public void call(UnsignedInt8Member a, UnsignedInt8Member b, UnsignedInt8Member c) {
            c.setV(a.v() / b.v());
        }
    };
    private final Procedure3<UnsignedInt8Member, UnsignedInt8Member, UnsignedInt8Member> MOD = new Procedure3<UnsignedInt8Member, UnsignedInt8Member, UnsignedInt8Member>(){

        @Override
        public void call(UnsignedInt8Member a, UnsignedInt8Member b, UnsignedInt8Member c) {
            c.setV(a.v() % b.v());
        }
    };
    private final Procedure4<UnsignedInt8Member, UnsignedInt8Member, UnsignedInt8Member, UnsignedInt8Member> DIVMOD = new Procedure4<UnsignedInt8Member, UnsignedInt8Member, UnsignedInt8Member, UnsignedInt8Member>(){

        @Override
        public void call(UnsignedInt8Member a, UnsignedInt8Member b, UnsignedInt8Member d, UnsignedInt8Member m) {
            UnsignedInt8Algebra.this.div().call(a, b, d);
            UnsignedInt8Algebra.this.mod().call(a, b, m);
        }
    };
    private final Procedure3<UnsignedInt8Member, UnsignedInt8Member, UnsignedInt8Member> GCD = new Procedure3<UnsignedInt8Member, UnsignedInt8Member, UnsignedInt8Member>(){

        @Override
        public void call(UnsignedInt8Member a, UnsignedInt8Member b, UnsignedInt8Member c) {
            Gcd.compute(G.UINT8, a, b, c);
        }
    };
    private final Procedure3<UnsignedInt8Member, UnsignedInt8Member, UnsignedInt8Member> LCM = new Procedure3<UnsignedInt8Member, UnsignedInt8Member, UnsignedInt8Member>(){

        @Override
        public void call(UnsignedInt8Member a, UnsignedInt8Member b, UnsignedInt8Member c) {
            Lcm.compute(G.UINT8, a, b, c);
        }
    };
    private final Function1<Boolean, UnsignedInt8Member> EVEN = new Function1<Boolean, UnsignedInt8Member>(){

        @Override
        public Boolean call(UnsignedInt8Member a) {
            return (a.v & 1) == 0;
        }
    };
    private final Function1<Boolean, UnsignedInt8Member> ODD = new Function1<Boolean, UnsignedInt8Member>(){

        @Override
        public Boolean call(UnsignedInt8Member a) {
            return (a.v & 1) == 1;
        }
    };
    private final Procedure2<UnsignedInt8Member, UnsignedInt8Member> PRED = new Procedure2<UnsignedInt8Member, UnsignedInt8Member>(){

        @Override
        public void call(UnsignedInt8Member a, UnsignedInt8Member b) {
            if (a.v == 0) {
                b.setV(255);
            } else {
                b.setV(a.v() - 1);
            }
        }
    };
    private final Procedure2<UnsignedInt8Member, UnsignedInt8Member> SUCC = new Procedure2<UnsignedInt8Member, UnsignedInt8Member>(){

        @Override
        public void call(UnsignedInt8Member a, UnsignedInt8Member b) {
            if (a.v == -1) {
                b.setV(0);
            } else {
                b.setV(a.v() + 1);
            }
        }
    };
    private final Procedure1<UnsignedInt8Member> MAXBOUND = new Procedure1<UnsignedInt8Member>(){

        @Override
        public void call(UnsignedInt8Member a) {
            a.setV(255);
        }
    };
    private final Procedure1<UnsignedInt8Member> MINBOUND = new Procedure1<UnsignedInt8Member>(){

        @Override
        public void call(UnsignedInt8Member a) {
            a.setV(0);
        }
    };
    private final Procedure3<UnsignedInt8Member, UnsignedInt8Member, UnsignedInt8Member> BITAND = new Procedure3<UnsignedInt8Member, UnsignedInt8Member, UnsignedInt8Member>(){

        @Override
        public void call(UnsignedInt8Member a, UnsignedInt8Member b, UnsignedInt8Member c) {
            c.setV(a.v & b.v);
        }
    };
    private final Procedure3<UnsignedInt8Member, UnsignedInt8Member, UnsignedInt8Member> BITOR = new Procedure3<UnsignedInt8Member, UnsignedInt8Member, UnsignedInt8Member>(){

        @Override
        public void call(UnsignedInt8Member a, UnsignedInt8Member b, UnsignedInt8Member c) {
            c.setV(a.v | b.v);
        }
    };
    private final Procedure3<UnsignedInt8Member, UnsignedInt8Member, UnsignedInt8Member> BITXOR = new Procedure3<UnsignedInt8Member, UnsignedInt8Member, UnsignedInt8Member>(){

        @Override
        public void call(UnsignedInt8Member a, UnsignedInt8Member b, UnsignedInt8Member c) {
            c.setV(a.v ^ b.v);
        }
    };
    private final Procedure2<UnsignedInt8Member, UnsignedInt8Member> BITNOT = new Procedure2<UnsignedInt8Member, UnsignedInt8Member>(){

        @Override
        public void call(UnsignedInt8Member a, UnsignedInt8Member b) {
            b.setV(~a.v);
        }
    };
    private final Procedure3<UnsignedInt8Member, UnsignedInt8Member, UnsignedInt8Member> BITANDNOT = new Procedure3<UnsignedInt8Member, UnsignedInt8Member, UnsignedInt8Member>(){

        @Override
        public void call(UnsignedInt8Member a, UnsignedInt8Member b, UnsignedInt8Member c) {
            c.setV(a.v & ~b.v);
        }
    };
    private final Procedure3<java.lang.Integer, UnsignedInt8Member, UnsignedInt8Member> BITSHL = new Procedure3<java.lang.Integer, UnsignedInt8Member, UnsignedInt8Member>(){

        @Override
        public void call(java.lang.Integer count, UnsignedInt8Member a, UnsignedInt8Member b) {
            if (count < 0) {
                UnsignedInt8Algebra.this.bitShiftRight().call(-count.intValue(), a, b);
            } else {
                count = count % 8;
                b.setV(a.v() << count);
            }
        }
    };
    private final Procedure3<java.lang.Integer, UnsignedInt8Member, UnsignedInt8Member> BITSHRZ = new Procedure3<java.lang.Integer, UnsignedInt8Member, UnsignedInt8Member>(){

        @Override
        public void call(java.lang.Integer count, UnsignedInt8Member a, UnsignedInt8Member b) {
            if (count < 0) {
                UnsignedInt8Algebra.this.bitShiftLeft().call(-count.intValue(), a, b);
            } else {
                b.setV(a.v() >>> count);
            }
        }
    };
    private final Procedure3<UnsignedInt8Member, UnsignedInt8Member, UnsignedInt8Member> MIN = new Procedure3<UnsignedInt8Member, UnsignedInt8Member, UnsignedInt8Member>(){

        @Override
        public void call(UnsignedInt8Member a, UnsignedInt8Member b, UnsignedInt8Member c) {
            Min.compute(G.UINT8, a, b, c);
        }
    };
    private final Procedure3<UnsignedInt8Member, UnsignedInt8Member, UnsignedInt8Member> MAX = new Procedure3<UnsignedInt8Member, UnsignedInt8Member, UnsignedInt8Member>(){

        @Override
        public void call(UnsignedInt8Member a, UnsignedInt8Member b, UnsignedInt8Member c) {
            Max.compute(G.UINT8, a, b, c);
        }
    };
    private final Procedure1<UnsignedInt8Member> RAND = new Procedure1<UnsignedInt8Member>(){

        @Override
        public void call(UnsignedInt8Member a) {
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            a.setV(rng.nextInt(256));
        }
    };
    private final Procedure3<UnsignedInt8Member, UnsignedInt8Member, UnsignedInt8Member> POW = new Procedure3<UnsignedInt8Member, UnsignedInt8Member, UnsignedInt8Member>(){

        @Override
        public void call(UnsignedInt8Member a, UnsignedInt8Member b, UnsignedInt8Member c) {
            UnsignedInt8Algebra.this.power().call(b.v(), a, c);
        }
    };
    private final Function1<Boolean, UnsignedInt8Member> ISZERO = new Function1<Boolean, UnsignedInt8Member>(){

        @Override
        public Boolean call(UnsignedInt8Member a) {
            return a.v == 0;
        }
    };
    private final Procedure3<HighPrecisionMember, UnsignedInt8Member, UnsignedInt8Member> SBHP = new Procedure3<HighPrecisionMember, UnsignedInt8Member, UnsignedInt8Member>(){

        @Override
        public void call(HighPrecisionMember a, UnsignedInt8Member b, UnsignedInt8Member c) {
            BigDecimal tmp = a.v();
            tmp = tmp.multiply(new BigDecimal(b.v()));
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<HighPrecisionMember, UnsignedInt8Member, UnsignedInt8Member> SBHPR = new Procedure3<HighPrecisionMember, UnsignedInt8Member, UnsignedInt8Member>(){

        @Override
        public void call(HighPrecisionMember a, UnsignedInt8Member b, UnsignedInt8Member c) {
            BigDecimal tmp = a.v();
            int signum = (tmp = tmp.multiply(new BigDecimal(b.v()))).signum();
            tmp = signum < 0 ? tmp.subtract(G.ONE_HALF) : tmp.add(G.ONE_HALF);
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<RationalMember, UnsignedInt8Member, UnsignedInt8Member> SBR = new Procedure3<RationalMember, UnsignedInt8Member, UnsignedInt8Member>(){

        @Override
        public void call(RationalMember a, UnsignedInt8Member b, UnsignedInt8Member c) {
            BigInteger tmp = BigInteger.valueOf(b.v());
            tmp = tmp.multiply(a.n());
            tmp = tmp.divide(a.d());
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<Double, UnsignedInt8Member, UnsignedInt8Member> SBD = new Procedure3<Double, UnsignedInt8Member, UnsignedInt8Member>(){

        @Override
        public void call(Double a, UnsignedInt8Member b, UnsignedInt8Member c) {
            c.setV((int)(a * (double)b.v()));
        }
    };
    private final Procedure3<Double, UnsignedInt8Member, UnsignedInt8Member> SBDR = new Procedure3<Double, UnsignedInt8Member, UnsignedInt8Member>(){

        @Override
        public void call(Double a, UnsignedInt8Member b, UnsignedInt8Member c) {
            c.setV((int)Math.round(a * (double)b.v()));
        }
    };
    private final Function3<Boolean, UnsignedInt8Member, UnsignedInt8Member, UnsignedInt8Member> WITHIN = new Function3<Boolean, UnsignedInt8Member, UnsignedInt8Member, UnsignedInt8Member>(){

        @Override
        public Boolean call(UnsignedInt8Member tol, UnsignedInt8Member a, UnsignedInt8Member b) {
            return NumberWithin.compute(G.UINT8, tol, a, b);
        }
    };

    @Override
    public Function2<Boolean, UnsignedInt8Member, UnsignedInt8Member> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, UnsignedInt8Member, UnsignedInt8Member> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public UnsignedInt8Member construct() {
        return new UnsignedInt8Member();
    }

    @Override
    public UnsignedInt8Member construct(UnsignedInt8Member other) {
        return new UnsignedInt8Member(other);
    }

    @Override
    public UnsignedInt8Member construct(String s) {
        return new UnsignedInt8Member(s);
    }

    @Override
    public Procedure2<UnsignedInt8Member, UnsignedInt8Member> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure2<UnsignedInt8Member, UnsignedInt8Member> abs() {
        return this.ASSIGN;
    }

    @Override
    public Procedure3<UnsignedInt8Member, UnsignedInt8Member, UnsignedInt8Member> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt8Member, UnsignedInt8Member> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<UnsignedInt8Member> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<UnsignedInt8Member, UnsignedInt8Member> negate() {
        return this.ASSIGN;
    }

    @Override
    public Procedure3<UnsignedInt8Member, UnsignedInt8Member, UnsignedInt8Member> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<UnsignedInt8Member, UnsignedInt8Member, UnsignedInt8Member> subtract() {
        return this.SUB;
    }

    @Override
    public Procedure1<UnsignedInt8Member> unity() {
        return this.UNITY;
    }

    @Override
    public Function2<Boolean, UnsignedInt8Member, UnsignedInt8Member> isLess() {
        return this.LESS;
    }

    @Override
    public Function2<Boolean, UnsignedInt8Member, UnsignedInt8Member> isLessEqual() {
        return this.LE;
    }

    @Override
    public Function2<Boolean, UnsignedInt8Member, UnsignedInt8Member> isGreater() {
        return this.GREAT;
    }

    @Override
    public Function2<Boolean, UnsignedInt8Member, UnsignedInt8Member> isGreaterEqual() {
        return this.GE;
    }

    @Override
    public Function2<java.lang.Integer, UnsignedInt8Member, UnsignedInt8Member> compare() {
        return this.CMP;
    }

    @Override
    public Function1<java.lang.Integer, UnsignedInt8Member> signum() {
        return this.SIG;
    }

    @Override
    public Procedure3<UnsignedInt8Member, UnsignedInt8Member, UnsignedInt8Member> div() {
        return this.DIV;
    }

    @Override
    public Procedure3<UnsignedInt8Member, UnsignedInt8Member, UnsignedInt8Member> mod() {
        return this.MOD;
    }

    @Override
    public Procedure4<UnsignedInt8Member, UnsignedInt8Member, UnsignedInt8Member, UnsignedInt8Member> divMod() {
        return this.DIVMOD;
    }

    @Override
    public Procedure3<UnsignedInt8Member, UnsignedInt8Member, UnsignedInt8Member> gcd() {
        return this.GCD;
    }

    @Override
    public Procedure3<UnsignedInt8Member, UnsignedInt8Member, UnsignedInt8Member> lcm() {
        return this.LCM;
    }

    @Override
    public Procedure2<UnsignedInt8Member, UnsignedInt8Member> norm() {
        return this.ASSIGN;
    }

    @Override
    public Function1<Boolean, UnsignedInt8Member> isEven() {
        return this.EVEN;
    }

    @Override
    public Function1<Boolean, UnsignedInt8Member> isOdd() {
        return this.ODD;
    }

    @Override
    public Procedure2<UnsignedInt8Member, UnsignedInt8Member> pred() {
        return this.PRED;
    }

    @Override
    public Procedure2<UnsignedInt8Member, UnsignedInt8Member> succ() {
        return this.SUCC;
    }

    @Override
    public Procedure1<UnsignedInt8Member> maxBound() {
        return this.MAXBOUND;
    }

    @Override
    public Procedure1<UnsignedInt8Member> minBound() {
        return this.MINBOUND;
    }

    @Override
    public Procedure3<UnsignedInt8Member, UnsignedInt8Member, UnsignedInt8Member> bitAnd() {
        return this.BITAND;
    }

    @Override
    public Procedure3<UnsignedInt8Member, UnsignedInt8Member, UnsignedInt8Member> bitOr() {
        return this.BITOR;
    }

    @Override
    public Procedure3<UnsignedInt8Member, UnsignedInt8Member, UnsignedInt8Member> bitXor() {
        return this.BITXOR;
    }

    @Override
    public Procedure2<UnsignedInt8Member, UnsignedInt8Member> bitNot() {
        return this.BITNOT;
    }

    @Override
    public Procedure3<UnsignedInt8Member, UnsignedInt8Member, UnsignedInt8Member> bitAndNot() {
        return this.BITANDNOT;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt8Member, UnsignedInt8Member> bitShiftLeft() {
        return this.BITSHL;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt8Member, UnsignedInt8Member> bitShiftRight() {
        return this.BITSHRZ;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt8Member, UnsignedInt8Member> bitShiftRightFillZero() {
        return this.BITSHRZ;
    }

    @Override
    public Procedure3<UnsignedInt8Member, UnsignedInt8Member, UnsignedInt8Member> min() {
        return this.MIN;
    }

    @Override
    public Procedure3<UnsignedInt8Member, UnsignedInt8Member, UnsignedInt8Member> max() {
        return this.MAX;
    }

    @Override
    public Procedure1<UnsignedInt8Member> random() {
        return this.RAND;
    }

    @Override
    public Procedure3<UnsignedInt8Member, UnsignedInt8Member, UnsignedInt8Member> pow() {
        return this.POW;
    }

    @Override
    public Function1<Boolean, UnsignedInt8Member> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<UnsignedInt8Member, UnsignedInt8Member, UnsignedInt8Member> scale() {
        return this.MUL;
    }

    @Override
    public Procedure3<HighPrecisionMember, UnsignedInt8Member, UnsignedInt8Member> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<HighPrecisionMember, UnsignedInt8Member, UnsignedInt8Member> scaleByHighPrecAndRound() {
        return this.SBHPR;
    }

    @Override
    public Procedure3<RationalMember, UnsignedInt8Member, UnsignedInt8Member> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, UnsignedInt8Member, UnsignedInt8Member> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<Double, UnsignedInt8Member, UnsignedInt8Member> scaleByDoubleAndRound() {
        return this.SBDR;
    }

    @Override
    public Function3<Boolean, UnsignedInt8Member, UnsignedInt8Member, UnsignedInt8Member> within() {
        return this.WITHIN;
    }
}

