/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.int9;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.ThreadLocalRandom;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.Gcd;
import nom.bdezonia.zorbage.algorithm.Lcm;
import nom.bdezonia.zorbage.algorithm.NumberWithin;
import nom.bdezonia.zorbage.algorithm.PowerNonNegative;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.BitOperations;
import nom.bdezonia.zorbage.type.algebra.Bounded;
import nom.bdezonia.zorbage.type.algebra.Integer;
import nom.bdezonia.zorbage.type.algebra.Random;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.int9.SignedInt9Member;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class SignedInt9Algebra
implements Integer<SignedInt9Algebra, SignedInt9Member>,
Bounded<SignedInt9Member>,
BitOperations<SignedInt9Member>,
Random<SignedInt9Member>,
Tolerance<SignedInt9Member, SignedInt9Member> {
    private final Function2<Boolean, SignedInt9Member, SignedInt9Member> EQ = new Function2<Boolean, SignedInt9Member, SignedInt9Member>(){

        @Override
        public Boolean call(SignedInt9Member a, SignedInt9Member b) {
            return a.v == b.v;
        }
    };
    private final Function2<Boolean, SignedInt9Member, SignedInt9Member> NEQ = new Function2<Boolean, SignedInt9Member, SignedInt9Member>(){

        @Override
        public Boolean call(SignedInt9Member a, SignedInt9Member b) {
            return a.v != b.v;
        }
    };
    private final Procedure2<SignedInt9Member, SignedInt9Member> ASSIGN = new Procedure2<SignedInt9Member, SignedInt9Member>(){

        @Override
        public void call(SignedInt9Member a, SignedInt9Member b) {
            b.set(a);
        }
    };
    private final Procedure1<SignedInt9Member> ZER = new Procedure1<SignedInt9Member>(){

        @Override
        public void call(SignedInt9Member a) {
            a.v = 0;
        }
    };
    private final Procedure2<SignedInt9Member, SignedInt9Member> NEG = new Procedure2<SignedInt9Member, SignedInt9Member>(){

        @Override
        public void call(SignedInt9Member a, SignedInt9Member b) {
            if (a.v == -256) {
                throw new IllegalArgumentException("Cannot convert -minint symmetrically");
            }
            b.v = -a.v;
        }
    };
    private final Procedure3<SignedInt9Member, SignedInt9Member, SignedInt9Member> ADD = new Procedure3<SignedInt9Member, SignedInt9Member, SignedInt9Member>(){

        @Override
        public void call(SignedInt9Member a, SignedInt9Member b, SignedInt9Member c) {
            c.setV(a.v + b.v);
        }
    };
    private final Procedure3<SignedInt9Member, SignedInt9Member, SignedInt9Member> SUB = new Procedure3<SignedInt9Member, SignedInt9Member, SignedInt9Member>(){

        @Override
        public void call(SignedInt9Member a, SignedInt9Member b, SignedInt9Member c) {
            c.setV(a.v - b.v);
        }
    };
    private final Procedure3<SignedInt9Member, SignedInt9Member, SignedInt9Member> MUL = new Procedure3<SignedInt9Member, SignedInt9Member, SignedInt9Member>(){

        @Override
        public void call(SignedInt9Member a, SignedInt9Member b, SignedInt9Member c) {
            c.setV(a.v * b.v);
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt9Member, SignedInt9Member> POWER = new Procedure3<java.lang.Integer, SignedInt9Member, SignedInt9Member>(){

        @Override
        public void call(java.lang.Integer power, SignedInt9Member a, SignedInt9Member b) {
            PowerNonNegative.compute(G.INT9, power, a, b);
        }
    };
    private final Procedure1<SignedInt9Member> UNITY = new Procedure1<SignedInt9Member>(){

        @Override
        public void call(SignedInt9Member a) {
            a.v = 1;
        }
    };
    private final Function2<Boolean, SignedInt9Member, SignedInt9Member> LESS = new Function2<Boolean, SignedInt9Member, SignedInt9Member>(){

        @Override
        public Boolean call(SignedInt9Member a, SignedInt9Member b) {
            return a.v < b.v;
        }
    };
    private final Function2<Boolean, SignedInt9Member, SignedInt9Member> LE = new Function2<Boolean, SignedInt9Member, SignedInt9Member>(){

        @Override
        public Boolean call(SignedInt9Member a, SignedInt9Member b) {
            return a.v <= b.v;
        }
    };
    private final Function2<Boolean, SignedInt9Member, SignedInt9Member> GREAT = new Function2<Boolean, SignedInt9Member, SignedInt9Member>(){

        @Override
        public Boolean call(SignedInt9Member a, SignedInt9Member b) {
            return a.v > b.v;
        }
    };
    private final Function2<Boolean, SignedInt9Member, SignedInt9Member> GE = new Function2<Boolean, SignedInt9Member, SignedInt9Member>(){

        @Override
        public Boolean call(SignedInt9Member a, SignedInt9Member b) {
            return a.v >= b.v;
        }
    };
    private final Function2<java.lang.Integer, SignedInt9Member, SignedInt9Member> CMP = new Function2<java.lang.Integer, SignedInt9Member, SignedInt9Member>(){

        @Override
        public java.lang.Integer call(SignedInt9Member a, SignedInt9Member b) {
            if (a.v < b.v) {
                return -1;
            }
            if (a.v > b.v) {
                return 1;
            }
            return 0;
        }
    };
    private final Function1<java.lang.Integer, SignedInt9Member> SIG = new Function1<java.lang.Integer, SignedInt9Member>(){

        @Override
        public java.lang.Integer call(SignedInt9Member a) {
            if (a.v < 0) {
                return -1;
            }
            if (a.v > 0) {
                return 1;
            }
            return 0;
        }
    };
    private final Procedure3<SignedInt9Member, SignedInt9Member, SignedInt9Member> MIN = new Procedure3<SignedInt9Member, SignedInt9Member, SignedInt9Member>(){

        @Override
        public void call(SignedInt9Member a, SignedInt9Member b, SignedInt9Member c) {
            if (a.v < b.v) {
                c.set(a);
            } else {
                c.set(b);
            }
        }
    };
    private final Procedure3<SignedInt9Member, SignedInt9Member, SignedInt9Member> MAX = new Procedure3<SignedInt9Member, SignedInt9Member, SignedInt9Member>(){

        @Override
        public void call(SignedInt9Member a, SignedInt9Member b, SignedInt9Member c) {
            if (a.v > b.v) {
                c.set(a);
            } else {
                c.set(b);
            }
        }
    };
    private final Procedure2<SignedInt9Member, SignedInt9Member> ABS = new Procedure2<SignedInt9Member, SignedInt9Member>(){

        @Override
        public void call(SignedInt9Member a, SignedInt9Member b) {
            if (a.v == -256) {
                throw new IllegalArgumentException("Cannot convert -minint symmetrically");
            }
            b.v = a.v < 0 ? (short)(-a.v) : a.v;
        }
    };
    private final Procedure3<SignedInt9Member, SignedInt9Member, SignedInt9Member> GCD = new Procedure3<SignedInt9Member, SignedInt9Member, SignedInt9Member>(){

        @Override
        public void call(SignedInt9Member a, SignedInt9Member b, SignedInt9Member c) {
            Gcd.compute(G.INT9, a, b, c);
        }
    };
    private final Procedure3<SignedInt9Member, SignedInt9Member, SignedInt9Member> LCM = new Procedure3<SignedInt9Member, SignedInt9Member, SignedInt9Member>(){

        @Override
        public void call(SignedInt9Member a, SignedInt9Member b, SignedInt9Member c) {
            Lcm.compute(G.INT9, a, b, c);
        }
    };
    private final Function1<Boolean, SignedInt9Member> EVEN = new Function1<Boolean, SignedInt9Member>(){

        @Override
        public Boolean call(SignedInt9Member a) {
            return (a.v & 1) == 0;
        }
    };
    private final Function1<Boolean, SignedInt9Member> ODD = new Function1<Boolean, SignedInt9Member>(){

        @Override
        public Boolean call(SignedInt9Member a) {
            return (a.v & 1) == 1;
        }
    };
    private final Procedure3<SignedInt9Member, SignedInt9Member, SignedInt9Member> DIV = new Procedure3<SignedInt9Member, SignedInt9Member, SignedInt9Member>(){

        @Override
        public void call(SignedInt9Member a, SignedInt9Member b, SignedInt9Member d) {
            if (b.v == -1 && a.v == -256) {
                throw new IllegalArgumentException("cannot divide minint by -1");
            }
            d.setV(a.v / b.v);
        }
    };
    private final Procedure3<SignedInt9Member, SignedInt9Member, SignedInt9Member> MOD = new Procedure3<SignedInt9Member, SignedInt9Member, SignedInt9Member>(){

        @Override
        public void call(SignedInt9Member a, SignedInt9Member b, SignedInt9Member m) {
            m.setV(a.v % b.v);
        }
    };
    private final Procedure4<SignedInt9Member, SignedInt9Member, SignedInt9Member, SignedInt9Member> DIVMOD = new Procedure4<SignedInt9Member, SignedInt9Member, SignedInt9Member, SignedInt9Member>(){

        @Override
        public void call(SignedInt9Member a, SignedInt9Member b, SignedInt9Member d, SignedInt9Member m) {
            SignedInt9Algebra.this.div().call(a, b, d);
            SignedInt9Algebra.this.mod().call(a, b, m);
        }
    };
    private final Procedure2<SignedInt9Member, SignedInt9Member> PRED = new Procedure2<SignedInt9Member, SignedInt9Member>(){

        @Override
        public void call(SignedInt9Member a, SignedInt9Member b) {
            if (a.v == -256) {
                b.v = (short)255;
            } else {
                b.setV(a.v - 1);
            }
        }
    };
    private final Procedure2<SignedInt9Member, SignedInt9Member> SUCC = new Procedure2<SignedInt9Member, SignedInt9Member>(){

        @Override
        public void call(SignedInt9Member a, SignedInt9Member b) {
            if (a.v == 255) {
                b.v = (short)-256;
            } else {
                b.setV(a.v + 1);
            }
        }
    };
    private final Procedure3<SignedInt9Member, SignedInt9Member, SignedInt9Member> POW = new Procedure3<SignedInt9Member, SignedInt9Member, SignedInt9Member>(){

        @Override
        public void call(SignedInt9Member a, SignedInt9Member b, SignedInt9Member c) {
            PowerNonNegative.compute(G.INT9, b.v, a, c);
        }
    };
    private final Procedure1<SignedInt9Member> RAND = new Procedure1<SignedInt9Member>(){

        @Override
        public void call(SignedInt9Member a) {
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            a.setV(rng.nextInt(512) - 256);
        }
    };
    private final Procedure3<SignedInt9Member, SignedInt9Member, SignedInt9Member> AND = new Procedure3<SignedInt9Member, SignedInt9Member, SignedInt9Member>(){

        @Override
        public void call(SignedInt9Member a, SignedInt9Member b, SignedInt9Member c) {
            c.setV(a.v & b.v);
        }
    };
    private final Procedure3<SignedInt9Member, SignedInt9Member, SignedInt9Member> OR = new Procedure3<SignedInt9Member, SignedInt9Member, SignedInt9Member>(){

        @Override
        public void call(SignedInt9Member a, SignedInt9Member b, SignedInt9Member c) {
            c.setV(a.v | b.v);
        }
    };
    private final Procedure3<SignedInt9Member, SignedInt9Member, SignedInt9Member> XOR = new Procedure3<SignedInt9Member, SignedInt9Member, SignedInt9Member>(){

        @Override
        public void call(SignedInt9Member a, SignedInt9Member b, SignedInt9Member c) {
            c.setV(a.v ^ b.v);
        }
    };
    private final Procedure2<SignedInt9Member, SignedInt9Member> NOT = new Procedure2<SignedInt9Member, SignedInt9Member>(){

        @Override
        public void call(SignedInt9Member a, SignedInt9Member b) {
            b.setV(~a.v);
        }
    };
    private final Procedure3<SignedInt9Member, SignedInt9Member, SignedInt9Member> ANDNOT = new Procedure3<SignedInt9Member, SignedInt9Member, SignedInt9Member>(){

        @Override
        public void call(SignedInt9Member a, SignedInt9Member b, SignedInt9Member c) {
            c.setV(a.v & ~b.v);
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt9Member, SignedInt9Member> SHL = new Procedure3<java.lang.Integer, SignedInt9Member, SignedInt9Member>(){

        @Override
        public void call(java.lang.Integer count, SignedInt9Member a, SignedInt9Member b) {
            if (count < 0) {
                SignedInt9Algebra.this.bitShiftRight().call(-count.intValue(), a, b);
            } else {
                count = count % 9;
                b.setV(a.v << count);
            }
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt9Member, SignedInt9Member> SHR = new Procedure3<java.lang.Integer, SignedInt9Member, SignedInt9Member>(){

        @Override
        public void call(java.lang.Integer count, SignedInt9Member a, SignedInt9Member b) {
            if (count < 0) {
                SignedInt9Algebra.this.bitShiftLeft().call(-count.intValue(), a, b);
            } else {
                int val = a.v >> count;
                if (a.v < 0 && val == 0) {
                    b.v = (short)-1;
                } else {
                    b.setV(val);
                }
            }
        }
    };
    private final Procedure3<java.lang.Integer, SignedInt9Member, SignedInt9Member> SHRZ = new Procedure3<java.lang.Integer, SignedInt9Member, SignedInt9Member>(){

        @Override
        public void call(java.lang.Integer count, SignedInt9Member a, SignedInt9Member b) {
            if (count < 0) {
                SignedInt9Algebra.this.bitShiftLeft().call(-count.intValue(), a, b);
            } else {
                b.setV(a.v >>> count);
            }
        }
    };
    private final Procedure1<SignedInt9Member> MAXBOUND = new Procedure1<SignedInt9Member>(){

        @Override
        public void call(SignedInt9Member a) {
            a.v = (short)255;
        }
    };
    private final Procedure1<SignedInt9Member> MINBOUND = new Procedure1<SignedInt9Member>(){

        @Override
        public void call(SignedInt9Member a) {
            a.v = (short)-256;
        }
    };
    private final Function1<Boolean, SignedInt9Member> ISZERO = new Function1<Boolean, SignedInt9Member>(){

        @Override
        public Boolean call(SignedInt9Member a) {
            return a.v == 0;
        }
    };
    private final Procedure3<HighPrecisionMember, SignedInt9Member, SignedInt9Member> SBHP = new Procedure3<HighPrecisionMember, SignedInt9Member, SignedInt9Member>(){

        @Override
        public void call(HighPrecisionMember a, SignedInt9Member b, SignedInt9Member c) {
            BigDecimal tmp = a.v();
            tmp = tmp.multiply(new BigDecimal(b.v()));
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<HighPrecisionMember, SignedInt9Member, SignedInt9Member> SBHPR = new Procedure3<HighPrecisionMember, SignedInt9Member, SignedInt9Member>(){

        @Override
        public void call(HighPrecisionMember a, SignedInt9Member b, SignedInt9Member c) {
            BigDecimal tmp = a.v();
            int signum = (tmp = tmp.multiply(new BigDecimal(b.v()))).signum();
            tmp = signum < 0 ? tmp.subtract(G.ONE_HALF) : tmp.add(G.ONE_HALF);
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<RationalMember, SignedInt9Member, SignedInt9Member> SBR = new Procedure3<RationalMember, SignedInt9Member, SignedInt9Member>(){

        @Override
        public void call(RationalMember a, SignedInt9Member b, SignedInt9Member c) {
            BigInteger tmp = BigInteger.valueOf(b.v());
            tmp = tmp.multiply(a.n());
            tmp = tmp.divide(a.d());
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<Double, SignedInt9Member, SignedInt9Member> SBD = new Procedure3<Double, SignedInt9Member, SignedInt9Member>(){

        @Override
        public void call(Double a, SignedInt9Member b, SignedInt9Member c) {
            c.setV((int)(a * (double)b.v()));
        }
    };
    private final Procedure3<Double, SignedInt9Member, SignedInt9Member> SBDR = new Procedure3<Double, SignedInt9Member, SignedInt9Member>(){

        @Override
        public void call(Double a, SignedInt9Member b, SignedInt9Member c) {
            c.setV((int)Math.round(a * (double)b.v()));
        }
    };
    private final Function3<Boolean, SignedInt9Member, SignedInt9Member, SignedInt9Member> WITHIN = new Function3<Boolean, SignedInt9Member, SignedInt9Member, SignedInt9Member>(){

        @Override
        public Boolean call(SignedInt9Member tol, SignedInt9Member a, SignedInt9Member b) {
            return NumberWithin.compute(G.INT9, tol, a, b);
        }
    };

    @Override
    public SignedInt9Member construct() {
        return new SignedInt9Member();
    }

    @Override
    public SignedInt9Member construct(SignedInt9Member other) {
        return new SignedInt9Member(other);
    }

    @Override
    public SignedInt9Member construct(String str) {
        return new SignedInt9Member(str);
    }

    @Override
    public Function2<Boolean, SignedInt9Member, SignedInt9Member> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, SignedInt9Member, SignedInt9Member> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<SignedInt9Member, SignedInt9Member> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure1<SignedInt9Member> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<SignedInt9Member, SignedInt9Member> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<SignedInt9Member, SignedInt9Member, SignedInt9Member> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<SignedInt9Member, SignedInt9Member, SignedInt9Member> subtract() {
        return this.SUB;
    }

    @Override
    public Procedure3<SignedInt9Member, SignedInt9Member, SignedInt9Member> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt9Member, SignedInt9Member> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<SignedInt9Member> unity() {
        return this.UNITY;
    }

    @Override
    public Function2<Boolean, SignedInt9Member, SignedInt9Member> isLess() {
        return this.LESS;
    }

    @Override
    public Function2<Boolean, SignedInt9Member, SignedInt9Member> isLessEqual() {
        return this.LE;
    }

    @Override
    public Function2<Boolean, SignedInt9Member, SignedInt9Member> isGreater() {
        return this.GREAT;
    }

    @Override
    public Function2<Boolean, SignedInt9Member, SignedInt9Member> isGreaterEqual() {
        return this.GE;
    }

    @Override
    public Function2<java.lang.Integer, SignedInt9Member, SignedInt9Member> compare() {
        return this.CMP;
    }

    @Override
    public Function1<java.lang.Integer, SignedInt9Member> signum() {
        return this.SIG;
    }

    @Override
    public Procedure3<SignedInt9Member, SignedInt9Member, SignedInt9Member> min() {
        return this.MIN;
    }

    @Override
    public Procedure3<SignedInt9Member, SignedInt9Member, SignedInt9Member> max() {
        return this.MAX;
    }

    @Override
    public Procedure2<SignedInt9Member, SignedInt9Member> abs() {
        return this.ABS;
    }

    @Override
    public Procedure2<SignedInt9Member, SignedInt9Member> norm() {
        return this.ABS;
    }

    @Override
    public Procedure3<SignedInt9Member, SignedInt9Member, SignedInt9Member> gcd() {
        return this.GCD;
    }

    @Override
    public Procedure3<SignedInt9Member, SignedInt9Member, SignedInt9Member> lcm() {
        return this.LCM;
    }

    @Override
    public Function1<Boolean, SignedInt9Member> isEven() {
        return this.EVEN;
    }

    @Override
    public Function1<Boolean, SignedInt9Member> isOdd() {
        return this.ODD;
    }

    @Override
    public Procedure3<SignedInt9Member, SignedInt9Member, SignedInt9Member> div() {
        return this.DIV;
    }

    @Override
    public Procedure3<SignedInt9Member, SignedInt9Member, SignedInt9Member> mod() {
        return this.MOD;
    }

    @Override
    public Procedure4<SignedInt9Member, SignedInt9Member, SignedInt9Member, SignedInt9Member> divMod() {
        return this.DIVMOD;
    }

    @Override
    public Procedure2<SignedInt9Member, SignedInt9Member> pred() {
        return this.PRED;
    }

    @Override
    public Procedure2<SignedInt9Member, SignedInt9Member> succ() {
        return this.SUCC;
    }

    @Override
    public Procedure3<SignedInt9Member, SignedInt9Member, SignedInt9Member> pow() {
        return this.POW;
    }

    @Override
    public Procedure1<SignedInt9Member> random() {
        return this.RAND;
    }

    @Override
    public Procedure3<SignedInt9Member, SignedInt9Member, SignedInt9Member> bitAnd() {
        return this.AND;
    }

    @Override
    public Procedure3<SignedInt9Member, SignedInt9Member, SignedInt9Member> bitOr() {
        return this.OR;
    }

    @Override
    public Procedure3<SignedInt9Member, SignedInt9Member, SignedInt9Member> bitXor() {
        return this.XOR;
    }

    @Override
    public Procedure2<SignedInt9Member, SignedInt9Member> bitNot() {
        return this.NOT;
    }

    @Override
    public Procedure3<SignedInt9Member, SignedInt9Member, SignedInt9Member> bitAndNot() {
        return this.ANDNOT;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt9Member, SignedInt9Member> bitShiftLeft() {
        return this.SHL;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt9Member, SignedInt9Member> bitShiftRight() {
        return this.SHR;
    }

    @Override
    public Procedure3<java.lang.Integer, SignedInt9Member, SignedInt9Member> bitShiftRightFillZero() {
        return this.SHRZ;
    }

    @Override
    public Procedure1<SignedInt9Member> maxBound() {
        return this.MAXBOUND;
    }

    @Override
    public Procedure1<SignedInt9Member> minBound() {
        return this.MINBOUND;
    }

    @Override
    public Function1<Boolean, SignedInt9Member> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<SignedInt9Member, SignedInt9Member, SignedInt9Member> scale() {
        return this.MUL;
    }

    @Override
    public Procedure3<HighPrecisionMember, SignedInt9Member, SignedInt9Member> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<HighPrecisionMember, SignedInt9Member, SignedInt9Member> scaleByHighPrecAndRound() {
        return this.SBHPR;
    }

    @Override
    public Procedure3<RationalMember, SignedInt9Member, SignedInt9Member> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, SignedInt9Member, SignedInt9Member> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<Double, SignedInt9Member, SignedInt9Member> scaleByDoubleAndRound() {
        return this.SBDR;
    }

    @Override
    public Function3<Boolean, SignedInt9Member, SignedInt9Member, SignedInt9Member> within() {
        return this.WITHIN;
    }
}

