/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.int9;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.ThreadLocalRandom;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.Gcd;
import nom.bdezonia.zorbage.algorithm.Lcm;
import nom.bdezonia.zorbage.algorithm.NumberWithin;
import nom.bdezonia.zorbage.algorithm.PowerNonNegative;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.BitOperations;
import nom.bdezonia.zorbage.type.algebra.Bounded;
import nom.bdezonia.zorbage.type.algebra.Integer;
import nom.bdezonia.zorbage.type.algebra.Random;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.int9.UnsignedInt9Member;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class UnsignedInt9Algebra
implements Integer<UnsignedInt9Algebra, UnsignedInt9Member>,
Bounded<UnsignedInt9Member>,
BitOperations<UnsignedInt9Member>,
Random<UnsignedInt9Member>,
Tolerance<UnsignedInt9Member, UnsignedInt9Member> {
    private final Function2<Boolean, UnsignedInt9Member, UnsignedInt9Member> EQ = new Function2<Boolean, UnsignedInt9Member, UnsignedInt9Member>(){

        @Override
        public Boolean call(UnsignedInt9Member a, UnsignedInt9Member b) {
            return a.v == b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt9Member, UnsignedInt9Member> NEQ = new Function2<Boolean, UnsignedInt9Member, UnsignedInt9Member>(){

        @Override
        public Boolean call(UnsignedInt9Member a, UnsignedInt9Member b) {
            return a.v != b.v;
        }
    };
    private final Procedure2<UnsignedInt9Member, UnsignedInt9Member> ASSIGN = new Procedure2<UnsignedInt9Member, UnsignedInt9Member>(){

        @Override
        public void call(UnsignedInt9Member a, UnsignedInt9Member b) {
            b.set(a);
        }
    };
    private final Procedure1<UnsignedInt9Member> ZER = new Procedure1<UnsignedInt9Member>(){

        @Override
        public void call(UnsignedInt9Member a) {
            a.v = 0;
        }
    };
    private final Procedure3<UnsignedInt9Member, UnsignedInt9Member, UnsignedInt9Member> ADD = new Procedure3<UnsignedInt9Member, UnsignedInt9Member, UnsignedInt9Member>(){

        @Override
        public void call(UnsignedInt9Member a, UnsignedInt9Member b, UnsignedInt9Member c) {
            c.setV(a.v + b.v);
        }
    };
    private final Procedure3<UnsignedInt9Member, UnsignedInt9Member, UnsignedInt9Member> SUB = new Procedure3<UnsignedInt9Member, UnsignedInt9Member, UnsignedInt9Member>(){

        @Override
        public void call(UnsignedInt9Member a, UnsignedInt9Member b, UnsignedInt9Member c) {
            c.setV(a.v - b.v);
        }
    };
    private final Procedure3<UnsignedInt9Member, UnsignedInt9Member, UnsignedInt9Member> MUL = new Procedure3<UnsignedInt9Member, UnsignedInt9Member, UnsignedInt9Member>(){

        @Override
        public void call(UnsignedInt9Member a, UnsignedInt9Member b, UnsignedInt9Member c) {
            c.setV(a.v * b.v);
        }
    };
    private final Procedure3<java.lang.Integer, UnsignedInt9Member, UnsignedInt9Member> POWER = new Procedure3<java.lang.Integer, UnsignedInt9Member, UnsignedInt9Member>(){

        @Override
        public void call(java.lang.Integer power, UnsignedInt9Member a, UnsignedInt9Member b) {
            PowerNonNegative.compute(G.UINT9, power, a, b);
        }
    };
    private final Procedure1<UnsignedInt9Member> UNITY = new Procedure1<UnsignedInt9Member>(){

        @Override
        public void call(UnsignedInt9Member a) {
            a.v = 1;
        }
    };
    private final Function2<Boolean, UnsignedInt9Member, UnsignedInt9Member> LESS = new Function2<Boolean, UnsignedInt9Member, UnsignedInt9Member>(){

        @Override
        public Boolean call(UnsignedInt9Member a, UnsignedInt9Member b) {
            return a.v < b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt9Member, UnsignedInt9Member> LE = new Function2<Boolean, UnsignedInt9Member, UnsignedInt9Member>(){

        @Override
        public Boolean call(UnsignedInt9Member a, UnsignedInt9Member b) {
            return a.v <= b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt9Member, UnsignedInt9Member> GREAT = new Function2<Boolean, UnsignedInt9Member, UnsignedInt9Member>(){

        @Override
        public Boolean call(UnsignedInt9Member a, UnsignedInt9Member b) {
            return a.v > b.v;
        }
    };
    private final Function2<Boolean, UnsignedInt9Member, UnsignedInt9Member> GE = new Function2<Boolean, UnsignedInt9Member, UnsignedInt9Member>(){

        @Override
        public Boolean call(UnsignedInt9Member a, UnsignedInt9Member b) {
            return a.v >= b.v;
        }
    };
    private final Function2<java.lang.Integer, UnsignedInt9Member, UnsignedInt9Member> CMP = new Function2<java.lang.Integer, UnsignedInt9Member, UnsignedInt9Member>(){

        @Override
        public java.lang.Integer call(UnsignedInt9Member a, UnsignedInt9Member b) {
            if (a.v < b.v) {
                return -1;
            }
            if (a.v > b.v) {
                return 1;
            }
            return 0;
        }
    };
    private final Function1<java.lang.Integer, UnsignedInt9Member> SIG = new Function1<java.lang.Integer, UnsignedInt9Member>(){

        @Override
        public java.lang.Integer call(UnsignedInt9Member a) {
            if (a.v < 0) {
                return -1;
            }
            if (a.v > 0) {
                return 1;
            }
            return 0;
        }
    };
    private final Procedure3<UnsignedInt9Member, UnsignedInt9Member, UnsignedInt9Member> MIN = new Procedure3<UnsignedInt9Member, UnsignedInt9Member, UnsignedInt9Member>(){

        @Override
        public void call(UnsignedInt9Member a, UnsignedInt9Member b, UnsignedInt9Member c) {
            if (a.v < b.v) {
                c.set(a);
            } else {
                c.set(b);
            }
        }
    };
    private final Procedure3<UnsignedInt9Member, UnsignedInt9Member, UnsignedInt9Member> MAX = new Procedure3<UnsignedInt9Member, UnsignedInt9Member, UnsignedInt9Member>(){

        @Override
        public void call(UnsignedInt9Member a, UnsignedInt9Member b, UnsignedInt9Member c) {
            if (a.v > b.v) {
                c.set(a);
            } else {
                c.set(b);
            }
        }
    };
    private final Procedure3<UnsignedInt9Member, UnsignedInt9Member, UnsignedInt9Member> GCD = new Procedure3<UnsignedInt9Member, UnsignedInt9Member, UnsignedInt9Member>(){

        @Override
        public void call(UnsignedInt9Member a, UnsignedInt9Member b, UnsignedInt9Member c) {
            Gcd.compute(G.UINT9, a, b, c);
        }
    };
    private final Procedure3<UnsignedInt9Member, UnsignedInt9Member, UnsignedInt9Member> LCM = new Procedure3<UnsignedInt9Member, UnsignedInt9Member, UnsignedInt9Member>(){

        @Override
        public void call(UnsignedInt9Member a, UnsignedInt9Member b, UnsignedInt9Member c) {
            Lcm.compute(G.UINT9, a, b, c);
        }
    };
    private final Function1<Boolean, UnsignedInt9Member> EVEN = new Function1<Boolean, UnsignedInt9Member>(){

        @Override
        public Boolean call(UnsignedInt9Member a) {
            return (a.v & 1) == 0;
        }
    };
    private final Function1<Boolean, UnsignedInt9Member> ODD = new Function1<Boolean, UnsignedInt9Member>(){

        @Override
        public Boolean call(UnsignedInt9Member a) {
            return (a.v & 1) == 1;
        }
    };
    private final Procedure3<UnsignedInt9Member, UnsignedInt9Member, UnsignedInt9Member> DIV = new Procedure3<UnsignedInt9Member, UnsignedInt9Member, UnsignedInt9Member>(){

        @Override
        public void call(UnsignedInt9Member a, UnsignedInt9Member b, UnsignedInt9Member d) {
            d.setV(a.v / b.v);
        }
    };
    private final Procedure3<UnsignedInt9Member, UnsignedInt9Member, UnsignedInt9Member> MOD = new Procedure3<UnsignedInt9Member, UnsignedInt9Member, UnsignedInt9Member>(){

        @Override
        public void call(UnsignedInt9Member a, UnsignedInt9Member b, UnsignedInt9Member m) {
            m.setV(a.v % b.v);
        }
    };
    private final Procedure4<UnsignedInt9Member, UnsignedInt9Member, UnsignedInt9Member, UnsignedInt9Member> DIVMOD = new Procedure4<UnsignedInt9Member, UnsignedInt9Member, UnsignedInt9Member, UnsignedInt9Member>(){

        @Override
        public void call(UnsignedInt9Member a, UnsignedInt9Member b, UnsignedInt9Member d, UnsignedInt9Member m) {
            UnsignedInt9Algebra.this.div().call(a, b, d);
            UnsignedInt9Algebra.this.mod().call(a, b, m);
        }
    };
    private final Procedure2<UnsignedInt9Member, UnsignedInt9Member> PRED = new Procedure2<UnsignedInt9Member, UnsignedInt9Member>(){

        @Override
        public void call(UnsignedInt9Member a, UnsignedInt9Member b) {
            if (a.v == 0) {
                b.v = (short)511;
            } else {
                b.setV(a.v - 1);
            }
        }
    };
    private final Procedure2<UnsignedInt9Member, UnsignedInt9Member> SUCC = new Procedure2<UnsignedInt9Member, UnsignedInt9Member>(){

        @Override
        public void call(UnsignedInt9Member a, UnsignedInt9Member b) {
            if (a.v == 511) {
                b.v = 0;
            } else {
                b.setV(a.v + 1);
            }
        }
    };
    private final Procedure3<UnsignedInt9Member, UnsignedInt9Member, UnsignedInt9Member> POW = new Procedure3<UnsignedInt9Member, UnsignedInt9Member, UnsignedInt9Member>(){

        @Override
        public void call(UnsignedInt9Member a, UnsignedInt9Member b, UnsignedInt9Member c) {
            PowerNonNegative.compute(G.UINT9, b.v, a, c);
        }
    };
    private final Procedure1<UnsignedInt9Member> RAND = new Procedure1<UnsignedInt9Member>(){

        @Override
        public void call(UnsignedInt9Member a) {
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            a.setV(rng.nextInt(512));
        }
    };
    private final Procedure3<UnsignedInt9Member, UnsignedInt9Member, UnsignedInt9Member> AND = new Procedure3<UnsignedInt9Member, UnsignedInt9Member, UnsignedInt9Member>(){

        @Override
        public void call(UnsignedInt9Member a, UnsignedInt9Member b, UnsignedInt9Member c) {
            c.setV(a.v & b.v);
        }
    };
    private final Procedure3<UnsignedInt9Member, UnsignedInt9Member, UnsignedInt9Member> OR = new Procedure3<UnsignedInt9Member, UnsignedInt9Member, UnsignedInt9Member>(){

        @Override
        public void call(UnsignedInt9Member a, UnsignedInt9Member b, UnsignedInt9Member c) {
            c.setV(a.v | b.v);
        }
    };
    private final Procedure3<UnsignedInt9Member, UnsignedInt9Member, UnsignedInt9Member> XOR = new Procedure3<UnsignedInt9Member, UnsignedInt9Member, UnsignedInt9Member>(){

        @Override
        public void call(UnsignedInt9Member a, UnsignedInt9Member b, UnsignedInt9Member c) {
            c.setV(a.v ^ b.v);
        }
    };
    private final Procedure2<UnsignedInt9Member, UnsignedInt9Member> NOT = new Procedure2<UnsignedInt9Member, UnsignedInt9Member>(){

        @Override
        public void call(UnsignedInt9Member a, UnsignedInt9Member b) {
            b.setV(~a.v);
        }
    };
    private final Procedure3<UnsignedInt9Member, UnsignedInt9Member, UnsignedInt9Member> ANDNOT = new Procedure3<UnsignedInt9Member, UnsignedInt9Member, UnsignedInt9Member>(){

        @Override
        public void call(UnsignedInt9Member a, UnsignedInt9Member b, UnsignedInt9Member c) {
            c.setV(a.v & ~b.v);
        }
    };
    private final Procedure3<java.lang.Integer, UnsignedInt9Member, UnsignedInt9Member> SHL = new Procedure3<java.lang.Integer, UnsignedInt9Member, UnsignedInt9Member>(){

        @Override
        public void call(java.lang.Integer count, UnsignedInt9Member a, UnsignedInt9Member b) {
            if (count < 0) {
                UnsignedInt9Algebra.this.bitShiftRight().call(-count.intValue(), a, b);
            } else {
                count = count % 9;
                b.setV(a.v << count);
            }
        }
    };
    private final Procedure3<java.lang.Integer, UnsignedInt9Member, UnsignedInt9Member> SHRZ = new Procedure3<java.lang.Integer, UnsignedInt9Member, UnsignedInt9Member>(){

        @Override
        public void call(java.lang.Integer count, UnsignedInt9Member a, UnsignedInt9Member b) {
            if (count < 0) {
                UnsignedInt9Algebra.this.bitShiftLeft().call(-count.intValue(), a, b);
            } else {
                b.setV(a.v >>> count);
            }
        }
    };
    private final Procedure1<UnsignedInt9Member> MAXBOUND = new Procedure1<UnsignedInt9Member>(){

        @Override
        public void call(UnsignedInt9Member a) {
            a.v = (short)511;
        }
    };
    private final Procedure1<UnsignedInt9Member> MINBOUND = new Procedure1<UnsignedInt9Member>(){

        @Override
        public void call(UnsignedInt9Member a) {
            a.v = 0;
        }
    };
    private final Function1<Boolean, UnsignedInt9Member> ISZERO = new Function1<Boolean, UnsignedInt9Member>(){

        @Override
        public Boolean call(UnsignedInt9Member a) {
            return a.v == 0;
        }
    };
    private final Procedure3<HighPrecisionMember, UnsignedInt9Member, UnsignedInt9Member> SBHP = new Procedure3<HighPrecisionMember, UnsignedInt9Member, UnsignedInt9Member>(){

        @Override
        public void call(HighPrecisionMember a, UnsignedInt9Member b, UnsignedInt9Member c) {
            BigDecimal tmp = a.v();
            tmp = tmp.multiply(new BigDecimal(b.v()));
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<HighPrecisionMember, UnsignedInt9Member, UnsignedInt9Member> SBHPR = new Procedure3<HighPrecisionMember, UnsignedInt9Member, UnsignedInt9Member>(){

        @Override
        public void call(HighPrecisionMember a, UnsignedInt9Member b, UnsignedInt9Member c) {
            BigDecimal tmp = a.v();
            int signum = (tmp = tmp.multiply(new BigDecimal(b.v()))).signum();
            tmp = signum < 0 ? tmp.subtract(G.ONE_HALF) : tmp.add(G.ONE_HALF);
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<RationalMember, UnsignedInt9Member, UnsignedInt9Member> SBR = new Procedure3<RationalMember, UnsignedInt9Member, UnsignedInt9Member>(){

        @Override
        public void call(RationalMember a, UnsignedInt9Member b, UnsignedInt9Member c) {
            BigInteger tmp = BigInteger.valueOf(b.v());
            tmp = tmp.multiply(a.n());
            tmp = tmp.divide(a.d());
            c.setV(tmp.intValue());
        }
    };
    private final Procedure3<Double, UnsignedInt9Member, UnsignedInt9Member> SBD = new Procedure3<Double, UnsignedInt9Member, UnsignedInt9Member>(){

        @Override
        public void call(Double a, UnsignedInt9Member b, UnsignedInt9Member c) {
            c.setV((int)(a * (double)b.v()));
        }
    };
    private final Procedure3<Double, UnsignedInt9Member, UnsignedInt9Member> SBDR = new Procedure3<Double, UnsignedInt9Member, UnsignedInt9Member>(){

        @Override
        public void call(Double a, UnsignedInt9Member b, UnsignedInt9Member c) {
            c.setV((int)Math.round(a * (double)b.v()));
        }
    };
    private final Function3<Boolean, UnsignedInt9Member, UnsignedInt9Member, UnsignedInt9Member> WITHIN = new Function3<Boolean, UnsignedInt9Member, UnsignedInt9Member, UnsignedInt9Member>(){

        @Override
        public Boolean call(UnsignedInt9Member tol, UnsignedInt9Member a, UnsignedInt9Member b) {
            return NumberWithin.compute(G.UINT9, tol, a, b);
        }
    };

    @Override
    public UnsignedInt9Member construct() {
        return new UnsignedInt9Member();
    }

    @Override
    public UnsignedInt9Member construct(UnsignedInt9Member other) {
        return new UnsignedInt9Member(other);
    }

    @Override
    public UnsignedInt9Member construct(String str) {
        return new UnsignedInt9Member(str);
    }

    @Override
    public Function2<Boolean, UnsignedInt9Member, UnsignedInt9Member> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, UnsignedInt9Member, UnsignedInt9Member> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<UnsignedInt9Member, UnsignedInt9Member> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure1<UnsignedInt9Member> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<UnsignedInt9Member, UnsignedInt9Member> negate() {
        return this.ASSIGN;
    }

    @Override
    public Procedure3<UnsignedInt9Member, UnsignedInt9Member, UnsignedInt9Member> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<UnsignedInt9Member, UnsignedInt9Member, UnsignedInt9Member> subtract() {
        return this.SUB;
    }

    @Override
    public Procedure3<UnsignedInt9Member, UnsignedInt9Member, UnsignedInt9Member> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt9Member, UnsignedInt9Member> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<UnsignedInt9Member> unity() {
        return this.UNITY;
    }

    @Override
    public Function2<Boolean, UnsignedInt9Member, UnsignedInt9Member> isLess() {
        return this.LESS;
    }

    @Override
    public Function2<Boolean, UnsignedInt9Member, UnsignedInt9Member> isLessEqual() {
        return this.LE;
    }

    @Override
    public Function2<Boolean, UnsignedInt9Member, UnsignedInt9Member> isGreater() {
        return this.GREAT;
    }

    @Override
    public Function2<Boolean, UnsignedInt9Member, UnsignedInt9Member> isGreaterEqual() {
        return this.GE;
    }

    @Override
    public Function2<java.lang.Integer, UnsignedInt9Member, UnsignedInt9Member> compare() {
        return this.CMP;
    }

    @Override
    public Function1<java.lang.Integer, UnsignedInt9Member> signum() {
        return this.SIG;
    }

    @Override
    public Procedure3<UnsignedInt9Member, UnsignedInt9Member, UnsignedInt9Member> min() {
        return this.MIN;
    }

    @Override
    public Procedure3<UnsignedInt9Member, UnsignedInt9Member, UnsignedInt9Member> max() {
        return this.MAX;
    }

    @Override
    public Procedure2<UnsignedInt9Member, UnsignedInt9Member> abs() {
        return this.ASSIGN;
    }

    @Override
    public Procedure2<UnsignedInt9Member, UnsignedInt9Member> norm() {
        return this.ASSIGN;
    }

    @Override
    public Procedure3<UnsignedInt9Member, UnsignedInt9Member, UnsignedInt9Member> gcd() {
        return this.GCD;
    }

    @Override
    public Procedure3<UnsignedInt9Member, UnsignedInt9Member, UnsignedInt9Member> lcm() {
        return this.LCM;
    }

    @Override
    public Function1<Boolean, UnsignedInt9Member> isEven() {
        return this.EVEN;
    }

    @Override
    public Function1<Boolean, UnsignedInt9Member> isOdd() {
        return this.ODD;
    }

    @Override
    public Procedure3<UnsignedInt9Member, UnsignedInt9Member, UnsignedInt9Member> div() {
        return this.DIV;
    }

    @Override
    public Procedure3<UnsignedInt9Member, UnsignedInt9Member, UnsignedInt9Member> mod() {
        return this.MOD;
    }

    @Override
    public Procedure4<UnsignedInt9Member, UnsignedInt9Member, UnsignedInt9Member, UnsignedInt9Member> divMod() {
        return this.DIVMOD;
    }

    @Override
    public Procedure2<UnsignedInt9Member, UnsignedInt9Member> pred() {
        return this.PRED;
    }

    @Override
    public Procedure2<UnsignedInt9Member, UnsignedInt9Member> succ() {
        return this.SUCC;
    }

    @Override
    public Procedure3<UnsignedInt9Member, UnsignedInt9Member, UnsignedInt9Member> pow() {
        return this.POW;
    }

    @Override
    public Procedure1<UnsignedInt9Member> random() {
        return this.RAND;
    }

    @Override
    public Procedure3<UnsignedInt9Member, UnsignedInt9Member, UnsignedInt9Member> bitAnd() {
        return this.AND;
    }

    @Override
    public Procedure3<UnsignedInt9Member, UnsignedInt9Member, UnsignedInt9Member> bitOr() {
        return this.OR;
    }

    @Override
    public Procedure3<UnsignedInt9Member, UnsignedInt9Member, UnsignedInt9Member> bitXor() {
        return this.XOR;
    }

    @Override
    public Procedure2<UnsignedInt9Member, UnsignedInt9Member> bitNot() {
        return this.NOT;
    }

    @Override
    public Procedure3<UnsignedInt9Member, UnsignedInt9Member, UnsignedInt9Member> bitAndNot() {
        return this.ANDNOT;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt9Member, UnsignedInt9Member> bitShiftLeft() {
        return this.SHL;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt9Member, UnsignedInt9Member> bitShiftRight() {
        return this.SHRZ;
    }

    @Override
    public Procedure3<java.lang.Integer, UnsignedInt9Member, UnsignedInt9Member> bitShiftRightFillZero() {
        return this.SHRZ;
    }

    @Override
    public Procedure1<UnsignedInt9Member> maxBound() {
        return this.MAXBOUND;
    }

    @Override
    public Procedure1<UnsignedInt9Member> minBound() {
        return this.MINBOUND;
    }

    @Override
    public Function1<Boolean, UnsignedInt9Member> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<UnsignedInt9Member, UnsignedInt9Member, UnsignedInt9Member> scale() {
        return this.MUL;
    }

    @Override
    public Procedure3<HighPrecisionMember, UnsignedInt9Member, UnsignedInt9Member> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<HighPrecisionMember, UnsignedInt9Member, UnsignedInt9Member> scaleByHighPrecAndRound() {
        return this.SBHPR;
    }

    @Override
    public Procedure3<RationalMember, UnsignedInt9Member, UnsignedInt9Member> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, UnsignedInt9Member, UnsignedInt9Member> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<Double, UnsignedInt9Member, UnsignedInt9Member> scaleByDoubleAndRound() {
        return this.SBDR;
    }

    @Override
    public Function3<Boolean, UnsignedInt9Member, UnsignedInt9Member, UnsignedInt9Member> within() {
        return this.WITHIN;
    }
}

