/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.point;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.misc.RealUtils;
import nom.bdezonia.zorbage.type.algebra.DimensionCount;
import nom.bdezonia.zorbage.type.algebra.Gettable;
import nom.bdezonia.zorbage.type.algebra.Settable;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.ctor.Duplicatable;
import nom.bdezonia.zorbage.type.data.float64.real.Float64Member;
import nom.bdezonia.zorbage.type.data.float64.real.Float64VectorMember;
import nom.bdezonia.zorbage.type.storage.coder.ByteCoder;
import nom.bdezonia.zorbage.type.storage.coder.DoubleCoder;

public class Point
implements ByteCoder,
DoubleCoder,
Settable<Point>,
Gettable<Point>,
DimensionCount,
Allocatable<Point>,
Duplicatable<Point>,
Tolerance<Float64Member, Point> {
    private double[] vector;
    private final Function3<Boolean, Float64Member, Point, Point> WITHIN = new Function3<Boolean, Float64Member, Point, Point>(){

        @Override
        public Boolean call(Float64Member tol, Point a, Point b) {
            if (a.vector.length != b.vector.length) {
                throw new IllegalArgumentException("input points do not have the same dimension");
            }
            for (int i = 0; i < a.vector.length; ++i) {
                if (!RealUtils.near(a.vector[i], b.vector[i], tol.v())) continue;
                return false;
            }
            return true;
        }
    };

    public Point(int dimension) {
        this.vector = new double[dimension];
    }

    public Point() {
        this(0);
    }

    public Point(Point other) {
        this.set(other);
    }

    public Point(String str) {
        Float64Member val = G.DBL.construct();
        Float64VectorMember vec = new Float64VectorMember(str);
        if (vec.length() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("string has too many components to fit in a Point");
        }
        this.vector = new double[(int)vec.length()];
        for (int i = 0; i < this.vector.length; ++i) {
            vec.v((long)i, val);
            this.setComponent(i, val.v());
        }
    }

    @Override
    public int numDimensions() {
        return this.vector.length;
    }

    public double component(int i) {
        return this.vector[i];
    }

    public void setComponent(int i, double value) {
        this.vector[i] = value;
    }

    @Override
    public int byteCount() {
        return 4 + this.numDimensions() * 8;
    }

    @Override
    public void fromByteArray(byte[] arr, int index) {
        ByteBuffer buff = ByteBuffer.allocate(4);
        buff.put(0, arr[index + 0]);
        buff.put(1, arr[index + 1]);
        buff.put(2, arr[index + 2]);
        buff.put(3, arr[index + 3]);
        int n = buff.getInt();
        if (this.numDimensions() != n) {
            this.vector = new double[n];
        }
        buff = ByteBuffer.allocate(8);
        for (int k = 0; k < n; ++k) {
            for (int i = 0; i < 8; ++i) {
                buff.put(i, arr[index + 4 + k * 8 + i]);
            }
            this.vector[k] = buff.getDouble();
        }
    }

    @Override
    public void toByteArray(byte[] arr, int index) {
        ByteBuffer buff = ByteBuffer.allocate(4);
        byte[] bytes = buff.putInt(this.vector.length).array();
        for (int i = 0; i < 4; ++i) {
            arr[index + i] = bytes[i];
        }
        buff = ByteBuffer.allocate(8);
        for (int k = 0; k < this.vector.length; ++k) {
            bytes = buff.putDouble(this.vector[k]).array();
            for (int i = 0; i < 8; ++i) {
                arr[index + 4 + k * 8 + i] = bytes[i];
            }
        }
    }

    @Override
    public void fromByteFile(RandomAccessFile raf) throws IOException {
        ByteBuffer buff = ByteBuffer.allocate(4);
        buff.put(0, raf.readByte());
        buff.put(1, raf.readByte());
        buff.put(2, raf.readByte());
        buff.put(3, raf.readByte());
        int n = buff.getInt();
        if (this.numDimensions() != n) {
            this.vector = new double[n];
        }
        buff = ByteBuffer.allocate(8);
        for (int k = 0; k < n; ++k) {
            for (int i = 0; i < 8; ++i) {
                buff.put(i, raf.readByte());
            }
            this.vector[k] = buff.getDouble();
        }
    }

    @Override
    public void toByteFile(RandomAccessFile raf) throws IOException {
        ByteBuffer buff = ByteBuffer.allocate(4);
        byte[] bytes = buff.putInt(this.vector.length).array();
        for (int i = 0; i < 4; ++i) {
            raf.writeByte(bytes[i]);
        }
        buff = ByteBuffer.allocate(8);
        for (int k = 0; k < this.vector.length; ++k) {
            bytes = buff.putDouble(this.vector[k]).array();
            for (int i = 0; i < 8; ++i) {
                raf.writeByte(bytes[i]);
            }
        }
    }

    @Override
    public int doubleCount() {
        return this.numDimensions() + 1;
    }

    @Override
    public void fromDoubleArray(double[] arr, int index) {
        int dim = (int)arr[index];
        if (dim != this.numDimensions()) {
            this.vector = new double[dim];
        }
        for (int i = 0; i < dim; ++i) {
            this.vector[i] = arr[index + 1 + i];
        }
    }

    @Override
    public void toDoubleArray(double[] arr, int index) {
        arr[index] = this.numDimensions();
        for (int i = 0; i < this.numDimensions(); ++i) {
            arr[index + 1 + i] = this.vector[i];
        }
    }

    @Override
    public void fromDoubleFile(RandomAccessFile raf) throws IOException {
        int dim = (int)raf.readDouble();
        if (dim != this.numDimensions()) {
            this.vector = new double[dim];
        }
        for (int i = 0; i < dim; ++i) {
            this.vector[i] = raf.readDouble();
        }
    }

    @Override
    public void toDoubleFile(RandomAccessFile raf) throws IOException {
        raf.writeDouble(this.numDimensions());
        for (int i = 0; i < this.numDimensions(); ++i) {
            raf.writeDouble(this.vector[i]);
        }
    }

    @Override
    public void get(Point other) {
        if (this == other) {
            return;
        }
        if (other.vector.length != this.vector.length) {
            other.vector = (double[])this.vector.clone();
        } else {
            for (int i = 0; i < this.vector.length; ++i) {
                other.vector[i] = this.vector[i];
            }
        }
    }

    @Override
    public void set(Point other) {
        if (this == other) {
            return;
        }
        if (this.vector == null || this.vector.length != other.vector.length) {
            this.vector = (double[])other.vector.clone();
        } else {
            for (int i = 0; i < other.vector.length; ++i) {
                this.vector[i] = other.vector[i];
            }
        }
    }

    @Override
    public Point allocate() {
        return new Point(this.numDimensions());
    }

    @Override
    public Point duplicate() {
        Point p = this.allocate();
        for (int i = 0; i < this.vector.length; ++i) {
            p.setComponent(i, this.vector[i]);
        }
        return p;
    }

    @Override
    public Function3<Boolean, Float64Member, Point, Point> within() {
        return this.WITHIN;
    }
}

