/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.point;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.concurrent.ThreadLocalRandom;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.misc.RealUtils;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.type.algebra.Addition;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.Random;
import nom.bdezonia.zorbage.type.algebra.Scale;
import nom.bdezonia.zorbage.type.algebra.ScaleByDouble;
import nom.bdezonia.zorbage.type.algebra.ScaleByHighPrec;
import nom.bdezonia.zorbage.type.algebra.ScaleByRational;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.data.float64.real.Float64Member;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.point.Point;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class PointAlgebra
implements Algebra<PointAlgebra, Point>,
Addition<Point>,
Scale<Point, Float64Member>,
Random<Point>,
ScaleByHighPrec<Point>,
ScaleByRational<Point>,
ScaleByDouble<Point>,
Tolerance<Double, Point> {
    private static final MathContext CONTEXT = new MathContext(18);
    private final Function2<Boolean, Point, Point> EQ = new Function2<Boolean, Point, Point>(){

        @Override
        public Boolean call(Point a, Point b) {
            if (a == b) {
                return true;
            }
            if (a.numDimensions() != b.numDimensions()) {
                return false;
            }
            for (int i = 0; i < a.numDimensions(); ++i) {
                if (a.component(i) == b.component(i)) continue;
                return false;
            }
            return true;
        }
    };
    private final Function2<Boolean, Point, Point> NEQ = new Function2<Boolean, Point, Point>(){

        @Override
        public Boolean call(Point a, Point b) {
            return PointAlgebra.this.isEqual().call(a, b) == false;
        }
    };
    private final Procedure2<Point, Point> ASSIGN = new Procedure2<Point, Point>(){

        @Override
        public void call(Point a, Point b) {
            b.set(a);
        }
    };
    private final Function1<Boolean, Point> EQZER = new Function1<Boolean, Point>(){

        @Override
        public Boolean call(Point a) {
            for (int i = 0; i < a.numDimensions(); ++i) {
                if (a.component(i) == 0.0) continue;
                return false;
            }
            return true;
        }
    };
    private final Procedure1<Point> ZER = new Procedure1<Point>(){

        @Override
        public void call(Point a) {
            for (int i = 0; i < a.numDimensions(); ++i) {
                a.setComponent(i, 0.0);
            }
        }
    };
    private final Procedure2<Point, Point> NEG = new Procedure2<Point, Point>(){

        @Override
        public void call(Point a, Point b) {
            if (a.numDimensions() != b.numDimensions()) {
                throw new IllegalArgumentException("mismatched point dimensions");
            }
            for (int i = 0; i < a.numDimensions(); ++i) {
                b.setComponent(i, -a.component(i));
            }
        }
    };
    private final Procedure3<Point, Point, Point> ADD = new Procedure3<Point, Point, Point>(){

        @Override
        public void call(Point a, Point b, Point c) {
            if (a.numDimensions() != b.numDimensions() || a.numDimensions() != c.numDimensions()) {
                throw new IllegalArgumentException("mismatched point dimensions");
            }
            for (int i = 0; i < a.numDimensions(); ++i) {
                c.setComponent(i, a.component(i) + b.component(i));
            }
        }
    };
    private final Procedure3<Point, Point, Point> SUB = new Procedure3<Point, Point, Point>(){

        @Override
        public void call(Point a, Point b, Point c) {
            if (a.numDimensions() != b.numDimensions() || a.numDimensions() != c.numDimensions()) {
                throw new IllegalArgumentException("mismatched point dimensions");
            }
            for (int i = 0; i < a.numDimensions(); ++i) {
                c.setComponent(i, a.component(i) - b.component(i));
            }
        }
    };
    private final Procedure3<Float64Member, Point, Point> SCALE = new Procedure3<Float64Member, Point, Point>(){

        @Override
        public void call(Float64Member a, Point b, Point c) {
            if (b.numDimensions() != c.numDimensions()) {
                throw new IllegalArgumentException("mismatched point dimensionality");
            }
            for (int i = 0; i < b.numDimensions(); ++i) {
                c.setComponent(i, a.v() * b.component(i));
            }
        }
    };
    private final Procedure1<Point> RAND = new Procedure1<Point>(){

        @Override
        public void call(Point a) {
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            for (int i = 0; i < a.numDimensions(); ++i) {
                a.setComponent(i, rng.nextDouble());
            }
        }
    };
    private final Procedure3<RationalMember, Point, Point> SBR = new Procedure3<RationalMember, Point, Point>(){

        @Override
        public void call(RationalMember a, Point b, Point c) {
            if (b.numDimensions() != c.numDimensions()) {
                throw new IllegalArgumentException("mismatched point dimensionality");
            }
            for (int i = 0; i < b.numDimensions(); ++i) {
                BigDecimal t = BigDecimal.valueOf(b.component(i));
                t = t.multiply(new BigDecimal(a.n()));
                t = t.divide(new BigDecimal(a.d()), CONTEXT);
                c.setComponent(i, t.doubleValue());
            }
        }
    };
    private final Procedure3<Double, Point, Point> SBD = new Procedure3<Double, Point, Point>(){

        @Override
        public void call(Double a, Point b, Point c) {
            if (b.numDimensions() != c.numDimensions()) {
                throw new IllegalArgumentException("mismatched point dimensionality");
            }
            for (int i = 0; i < b.numDimensions(); ++i) {
                c.setComponent(i, a * b.component(i));
            }
        }
    };
    private final Procedure3<HighPrecisionMember, Point, Point> SBH = new Procedure3<HighPrecisionMember, Point, Point>(){

        @Override
        public void call(HighPrecisionMember a, Point b, Point c) {
            if (b.numDimensions() != c.numDimensions()) {
                throw new IllegalArgumentException("mismatched point dimensionality");
            }
            for (int i = 0; i < b.numDimensions(); ++i) {
                BigDecimal t = BigDecimal.valueOf(b.component(i));
                t = t.multiply(a.v());
                c.setComponent(i, t.doubleValue());
            }
        }
    };
    private final Function3<Boolean, Double, Point, Point> WITHIN = new Function3<Boolean, Double, Point, Point>(){

        @Override
        public Boolean call(Double tol, Point a, Point b) {
            if (a.numDimensions() != b.numDimensions()) {
                throw new IllegalArgumentException("mismatched point dimensionality");
            }
            if (tol < 0.0) {
                throw new IllegalArgumentException("tolerance must be >= 0");
            }
            for (int i = 0; i < b.numDimensions(); ++i) {
                if (RealUtils.near(a.component(i), b.component(i), tol)) continue;
                return false;
            }
            return true;
        }
    };

    @Override
    public Point construct() {
        return new Point();
    }

    @Override
    public Point construct(Point other) {
        return new Point(other);
    }

    @Override
    public Point construct(String str) {
        return new Point(str);
    }

    @Override
    public Function2<Boolean, Point, Point> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, Point, Point> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<Point, Point> assign() {
        return this.ASSIGN;
    }

    @Override
    public Function1<Boolean, Point> isZero() {
        return this.EQZER;
    }

    @Override
    public Procedure1<Point> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<Point, Point> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<Point, Point, Point> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<Point, Point, Point> subtract() {
        return this.SUB;
    }

    @Override
    public Procedure3<Float64Member, Point, Point> scale() {
        return this.SCALE;
    }

    @Override
    public Procedure1<Point> random() {
        return this.RAND;
    }

    @Override
    public Procedure3<RationalMember, Point, Point> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, Point, Point> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<HighPrecisionMember, Point, Point> scaleByHighPrec() {
        return this.SBH;
    }

    @Override
    public Function3<Boolean, Double, Point, Point> within() {
        return this.WITHIN;
    }
}

